package ch.rolfp.minirechner

import android.annotation.SuppressLint
import android.app.AlertDialog
import android.content.res.ColorStateList
import android.os.Bundle
import android.view.View
import android.widget.Button
import android.widget.EditText
import android.widget.TextView
import android.widget.Toast
import androidx.activity.ComponentActivity
import androidx.core.content.ContextCompat
import java.lang.Math.pow
import kotlin.math.PI
import kotlin.math.acos
import kotlin.math.asin
import kotlin.math.atan
import kotlin.math.cos
import kotlin.math.exp
import kotlin.math.ln
import kotlin.math.log10
import kotlin.math.sin
import kotlin.math.sqrt
import kotlin.math.tan
import android.content.SharedPreferences
import android.os.CountDownTimer
import android.text.InputType
import android.view.ViewGroup
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.core.content.edit

const val MAX=10
const val GRAD=PI/180.0
const val codRet=1
const val codEnd=2
const val codNop=0
const val codLBL=900
const val funDelCod=999 //Spezialcode zum ein Programmschritt loeschen
//alle anderen Codes:
// 11 bis 85 fuer Normalbelegung (1.Ziffer: Reihe von unten, 2.Ziffer: Spalte von links)
// 111 bis 185 fuer Aenderungen mit Fn
// 211 bis 285 fuer Aenderungen mit Fn2
// 311 bis 385 fuer Aenderungen mit Fn3
var testString:String="" //test
var aktpc:Int = 0 //aktuelle Adresse von sichtbarem Teil des Programms (ProgrammCounter)
var aktwr:Int = 0 //aktuelle Adresse fuer naechsten Tastendruck schreiben (write)
var aktflags:Int = 0 //aktuelle Flags wenn Programm laeuft

@SuppressLint("SetTextI18n")
class MainActivity : ComponentActivity(), View.OnClickListener, SelectListener {
    lateinit var note1: SharedPreferences
    //lateinit var note1Edit: SharedPreferences.Editor
    lateinit var titel:TextView
    lateinit var feldT:EditText
    lateinit var feldZ:EditText
    lateinit var feldY:EditText
    lateinit var feldX:EditText
    lateinit var progList:EditText
    lateinit var feldStatus: TextView
    lateinit var feldStatus2: TextView
    lateinit var btnFn: Button
    lateinit var btnFn2: Button
    lateinit var btnSin: Button
    lateinit var btnCos: Button
    lateinit var btnTan: Button
    lateinit var btnSto: Button
    lateinit var btnRcl: Button
    lateinit var btnUp: Button
    lateinit var btnDown: Button
    var regist:DoubleArray = DoubleArray(10)
    var progNr=0; var runningNr=0;
    var errorString=""
    lateinit var vi: View
    lateinit var countDownTimer: CountDownTimer
    lateinit var tvCountdown: TextView
    //var countDownTime:Long=100L //wert in Millisec
    //var countDownRest=0L

    //selbst gemachtes Menu und Dateiliste:
    lateinit var menu1:Button; lateinit var menu2:Button; lateinit var menu3:Button; lateinit var menu4:Button
    lateinit var dateiListe: List<String>
    lateinit var recyclerView: RecyclerView

    class ProgSpeicher(size:Int) {
        val max=size
        var rami: IntArray = IntArray(size)
        fun prog(bef:Int) {
            var pc=aktwr
            if(bef==0) {
                if(rami[pc]==0) rami[pc]=codEnd
                else rami[pc]=codNop
            } else if(bef==funDelCod){
                var pcmax=max; while(pcmax>pc && rami[pcmax-1]==0) {pcmax--}
                while(pc<pcmax) {rami[pc]=if(pc==pcmax-1) 0 else rami[pc+1]; pc++}
            } else {
                rami[pc]=bef
                if(++pc >= max) {pc=max-1; rami[pc]=0}
                aktwr=pc
            }
        }
    }
    lateinit var aktp:ProgSpeicher

    fun prog(nr:Int) {
        if(progNr==1) progF1.prog(nr)
        else if(progNr==2) progF2.prog(nr)
        else if(progNr==3) progF3.prog(nr)
        else testString="Error progNr=$progNr"
        updown(0)
    }
    fun endProg() {
        progList.setText("")
        progList.visibility=View.INVISIBLE
        feldT.setEms(15); feldZ.setEms(15); feldY.setEms(15); feldX.setEms(15)
    }
    fun runn(p:ProgSpeicher, adr:Int) {
        errorString=""; printStatus()
        aktadr=adr; aktp=p
        countdown()
    }
    var aktadr=0
    fun runn2() {
        val p=aktp
        var pc=aktadr
        var sp=1000 //StackPointer fuer Subroutine-Ruecksprung
        var timeout=1000000
        while(pc>=0 && pc<sp && runningNr!=0) {
            val bef = p.rami[pc]
            if(bef==codEnd) break
            else if(bef==codRet) {if(sp==1000) break else {pc=p.rami[sp]-1; p.rami[sp++]=0}} //return from SUBX
            else if(bef==11) enterDigit(0)
            else if(bef==21) enterDigit(1)
            else if(bef==22) enterDigit(2)
            else if(bef==23) enterDigit(3)
            else if(bef==31) enterDigit(4)
            else if(bef==32) enterDigit(5)
            else if(bef==33) enterDigit(6)
            else if(bef==41) enterDigit(7)
            else if(bef==42) enterDigit(8)
            else if(bef==43) enterDigit(9)
            else if(bef==12) enterPlusminus()
            else if(bef==13) enterPunkt()
            else if(bef==14) enterDoppelpunkt()
            else if(bef==15) enter()
            else if(bef==24) add()
            else if(bef==25) sub() //subtract
            else if(bef==34) mult()
            else if(bef==35) div()
            else if(bef==44) enterExp() else if(bef==344) funCmp()
            else if(bef==45) enterCorr()
            else if(bef==51) yhochx() else if(bef==151) deg() else if(bef==251) enterDigit(10) else if(bef==351) pc=funBeq(pc)
            else if(bef==52) sqrtx()  else if(bef==152) rad() else if(bef==252) kehrwert() else if(bef==352) pc=funBlt(pc)
            else if(bef==53) sqrx() else if(bef==353) pc=funBle(pc)
            else if(bef==54) popp() else if(bef==354) {p.rami[--sp]=pc+1; pc=funSubx(pc)} //Subroutine aufrufen
            else if(bef==55) exch()
            else if(bef==61) sinx() else if(bef==161) asinx() else if(bef==261) enterDigit(11) else if(bef==361) pc=funBne(pc)
            else if(bef==62) cosx() else if(bef==162) acosx() else if(bef==262) enterDigit(12) else if(bef==362) pc=funBgt(pc)
            else if(bef==63) tanx() else if(bef==163) atanx() else if(bef==263) enterDigit(13) else if(bef==363) pc=funBge(pc)
            else if(bef==64) lnx()  else if(bef==164) ehochx() else if(bef==264) enterDigit(14) else if(bef==364) pc=funBrx(pc)
            else if(bef==65) logx() else if(bef==165) zehnhochx() else if(bef==265) enterDigit(15) else if(bef==365) funLbl()
            //else if(bef==71) fn(v)
            else if(bef==72) sto()  else if(bef==172) konstPi()
            else if(bef==73) rcl()  else if(bef==173) fakultaet()
            //else if(bef==81) fn2()
            //else if(bef==82) fn3()
            //else if(bef==83) f1()
            //else if(bef==84) f2()
            //else if(bef==85) f3()
            else if(bef!=codLBL && bef!=codNop) {errorString="Error: unknown bef=$bef"; break}
            pc++
            if(--timeout<=0) {errorString="Error: timeout"; break}
        }
        runningNr=0;
        if(fn3flag) fn3() //fn3 ausschalten
        //testString="Programm beendet" //test
        printStapel()
        printStatus()
    }
    var progF1:ProgSpeicher = ProgSpeicher(1000)
    var progF2:ProgSpeicher = ProgSpeicher(1000)
    var progF3:ProgSpeicher = ProgSpeicher(1000)
    var degRadFlag:Int = 1 //1 fuer DEG, 0 fuer RAD
    var hexmodus=false
    var pgmModus=false
    var fn3aktiv=false
    lateinit var btnLn: Button
    lateinit var btnLog: Button
    lateinit var btnYhochx: Button
    lateinit var btnXhoch2: Button
    lateinit var btnExp: Button
    lateinit var btn0: Button; lateinit var btn1: Button; lateinit var btn2: Button; lateinit var btn3: Button; lateinit var btn4: Button
    lateinit var btn5: Button; lateinit var btn6: Button; lateinit var btn7: Button; lateinit var btn8: Button; lateinit var btn9: Button
    lateinit var btnMul: Button; lateinit var btnDiv: Button; lateinit var btnPlus: Button; lateinit var btnMinus: Button
    lateinit var btnPlusMin: Button; lateinit var btnPunkt: Button; lateinit var btnDoppelpunkt: Button; lateinit var btnEnt: Button
    lateinit var btnPop: Button
    lateinit var btnExch: Button
    lateinit var btnSqrt: Button
    lateinit var btnPgm:Button; lateinit var btnF1:Button; lateinit var btnF2:Button; lateinit var btnF3:Button
    lateinit var btnCor: Button
    var stapel: DoubleArray = DoubleArray(MAX)
    val defaultForm="%15.12g"
    var stapelForm: Array<String> = Array(MAX, { defaultForm })
    var enterFlag=0 //gesetzt wenn gerade eine Zahl eingegeben wird
    var exponent:Int = 0 //bisher eingegebener Exponent
    var exponentFlag=0 //gesetzt wenn Exponent eingegeben wird
    var doppelpunktFlag=0 //wenn gerade Stunde/Min/Sek oder Grad/Min/Sek eingegeben wird
    var zahleingabe:String = ""
    var exponentEingabe:String = ""
    var vorzeichenEingabe=1
    var vorzeichenExponent=1

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        initView()
        layoutAnpassen()
        printStapel()
        note1 = getSharedPreferences("fileList",MODE_PRIVATE)
        //note1Edit = note1.edit()
        loadProgramF(1,"programF1"); loadProgramF(2,"programF2"); loadProgramF(3,"programF3")
        Toast.makeText(this, "F1..F3 eingelesen", Toast.LENGTH_SHORT).show()
        dateiListeEinlesen()
    }

    fun initView() {
        titel = findViewById(R.id.titel)
        feldT = findViewById(R.id.z1)
        feldZ = findViewById(R.id.z2)
        feldY = findViewById(R.id.z3)
        feldX = findViewById(R.id.z4)
        progList = findViewById(R.id.progList)
        progList.visibility=View.INVISIBLE
        feldStatus = findViewById(R.id.status)
        feldStatus2 = findViewById(R.id.status2)
        //printStapel()
        btnFn = findViewById(R.id.btn_fn)
        btnFn2 = findViewById(R.id.btn_fn2)
        btnSto = findViewById(R.id.btn_sto)
        btnRcl = findViewById(R.id.btn_rcl)
        btnUp = findViewById(R.id.btn_up)
        btnDown = findViewById(R.id.btn_down)
        btnSin = findViewById(R.id.btn_sin)
        btnCos = findViewById(R.id.btn_cos)
        btnTan = findViewById(R.id.btn_tan)
        btnLn = findViewById(R.id.btn_ln)
        btnLog = findViewById(R.id.btn_log)
        btnYhochx = findViewById(R.id.btn_yhochx)
        btnXhoch2 = findViewById(R.id.btn_quadrat)
        btnExp = findViewById(R.id.btn_exp)
        btn0 = findViewById(R.id.btn_0)
        btn1 = findViewById(R.id.btn_1); btn2 = findViewById(R.id.btn_2); btn3 = findViewById(R.id.btn_3)
        btn4 = findViewById(R.id.btn_4); btn5 = findViewById(R.id.btn_5); btn6 = findViewById(R.id.btn_6)
        btn7 = findViewById(R.id.btn_7); btn8 = findViewById(R.id.btn_8); btn9 = findViewById(R.id.btn_9)
        btnMul = findViewById(R.id.btn_mult); btnDiv = findViewById(R.id.btn_div); btnPlus = findViewById(R.id.btn_plus)
        btnMinus = findViewById(R.id.btn_minus); btnPlusMin = findViewById(R.id.btn_plusMinus)
        btnPunkt = findViewById(R.id.btn_punkt); btnDoppelpunkt = findViewById(R.id.btn_doppelpunkt); btnEnt = findViewById(R.id.btn_enter)
        btnPop = findViewById(R.id.btn_pop)
        btnExch = findViewById(R.id.btn_exch)
        btnSqrt = findViewById(R.id.btn_sqrt)
        btnPgm = findViewById(R.id.btn_pgm)
        btnF1 = findViewById(R.id.btn_f1)
        btnF2 = findViewById(R.id.btn_f2)
        btnF3 = findViewById(R.id.btn_f3)
        btnCor = findViewById(R.id.btn_corr)
        aktp=progF1
        tvCountdown = findViewById(R.id.tvCountDown)
        menu1=findViewById(R.id.btn_menu1); menu1.visibility= View.INVISIBLE
        menu2=findViewById(R.id.btn_menu2); menu2.visibility= View.INVISIBLE
        menu3=findViewById(R.id.btn_menu3); menu3.visibility= View.INVISIBLE
        menu4=findViewById(R.id.btn_menu4); menu4.visibility= View.INVISIBLE
        recyclerView = findViewById(R.id.mRecyclerView)
    }

    fun printStapel() {
        if(runningNr!=0) return //bei laufendem Programm nicht dauernd neu zeichnen
        var str:String;
        val ts = myFormat(stapelForm[3],stapel[3]); str = "t:  $ts"; feldT.setText(str)
        val zs = myFormat(stapelForm[2],stapel[2]); str = "z:  $zs"; feldZ.setText(str)
        val ys = myFormat(stapelForm[1],stapel[1]); str = "y:  $ys"; feldY.setText(str)
        val xs = myFormat(stapelForm[0],stapel[0])
        if(enterFlag==0) {str="x:  $xs"}
        else {
            str = if(vorzeichenEingabe==1) "x:  "; else "x:  -"
            str += zahleingabe
            if(exponentFlag!=0) {
                if(vorzeichenExponent==1) str += " * 10^$exponentEingabe"
                else                      str += " * 10^-$exponentEingabe"
            }
        }
        feldX.setText(str)
    }

    // alle Funktionen die von Tastendruecken aufgerufen werden:
    fun enterPlusminusv(v:View) {vi=v; enterPlusminus()}
    fun enterPunktv(v: View) {vi=v; enterPunkt()}
    fun enterDoppelpunktv(v: View) {vi=v; enterDoppelpunkt()}
    fun enterv(v:View) {vi=v; enter()}
    fun addv(v: View) {vi=v; add()}
    fun subv(v: View) {vi=v; sub()}
    fun multv(v: View) {vi=v; mult()}
    fun divv(v: View) {vi=v; div()}
    fun enterExpv(v: View) {vi=v; if(fn3flag) funCmp() else enterExp()}
    fun enterCorrv(v: View) {vi=v;
        if(fn3flag) funDel() else {
            if (testString == "" && enterFlag == 0) bildschirmgroesse()//test
            else testString = ""
            errorString = ""; enterCorr(); printStatus()
        }
    }
    fun yhochxv(v: View) {vi=v; if(fn3flag) funBeq(-1) else if(fn2flag) enterDigit(10) else if(revers) deg() else yhochx()}
    fun sqrtxv(v: View) {vi=v; if(fn3flag) funBlt(-1) else if(fn2flag) kehrwert() else if(revers) rad() else sqrtx()}
    fun sqrxv(v: View) {vi=v; if(fn3flag) funBle(-1) else sqrx()}
    fun popv(v:View) {vi=v; if(fn3flag) funSubxv() else popp()}
    fun exchv(v: View) {vi=v; if(fn3flag) funIns() else exch()}
    fun sinxv(v: View) {vi=v; if(fn3flag) funBnev() else if(fn2flag) enterDigit(11) else if(revers) asinx() else sinx()}
    fun cosxv(v: View) {vi=v; if(fn3flag) funBgt(-1) else if(fn2flag) enterDigit(12) else if(revers) acosx() else cosx()}
    fun tanxv(v: View) {vi=v;  if(fn3flag) funBge(-1) else if(fn2flag) enterDigit(13) else if(revers) atanx() else tanx()}
    fun lnxv(v: View) {vi=v;  if(fn3flag) funBrv() else if(fn2flag) enterDigit(14) else if(revers) ehochx() else lnx()}
    fun logxv(v: View) {vi=v;  if(fn3flag) funLbl() else if(fn2flag) enterDigit(15) else if(revers) zehnhochx() else logx()}
    fun stov(v: View) {vi=v; if(revers) konstPi() else sto()}
    fun rclv(v: View) {vi=v; if(revers) fakultaet() else rcl()}
    fun fnv(v: View) {vi=v; if(fn3flag) ret() else if(fn2flag) hex() else fn()}
    fun fn2v(v: View) {vi=v; if(fn3flag) end() else fn2()}
    // Ende aller Funktionen von Tastendruecken.

    fun enter() {
        if(progNr!=0) prog(15)
        if(enterFlag==0) {
            val x=stapel[0]; val form=stapelForm[0]; push(x,form)
        } else enterCheck()
        printStapel()
    }
    fun enterCheck() {
        if(enterFlag!=0) {
            if(zahleingabe.isEmpty()) stapel[0]=0.0
            else if(doppelpunktFlag!=0) {
                stapel[0] = zeitToDouble(zahleingabe)
                stapelForm[0]="Z"
                doppelpunktFlag=0
            } else if(exponentFlag!=0) {
                val ex:Double = exponent.toDouble()*vorzeichenExponent
                if(hexmodus) {stapel[0] = hexToDouble(zahleingabe)*vorzeichenEingabe * pow(16.0,ex); stapelForm[0]="X"}
                else         {stapel[0] = zahleingabe.toDouble() * vorzeichenEingabe * pow(10.0,ex)}
                exponentFlag=0
            } else {
                if(hexmodus) {stapel[0] = hexToDouble(zahleingabe)*vorzeichenEingabe; stapelForm[0]="X"}
                else         {stapel[0] = zahleingabe.toDouble()*vorzeichenEingabe}
            }
            enterFlag=0
            hexmodus=false; printStatus()
        }
    }

    fun pop():Double {
        enterCheck()
        val x=stapel[0]
        for(i in 0..MAX-2) {stapel[i] = stapel[i+1]}
        stapel[MAX-1] = 0.0
        for(i in 0 ..MAX-2) {stapelForm[i] = stapelForm[i+1]}
        stapelForm[MAX-1] = defaultForm
        return x
    }
    fun popp() {
        if(progNr!=0) prog(54)
        enterCheck()
        pop()
        printStapel()
    }
    fun push(x:Double,form:String) {
        for (i in MAX - 1 downTo 1) {stapel[i] = stapel[i - 1]}
        stapel[0]=x
        for (i in MAX - 1 downTo 1) {stapelForm[i] = stapelForm[i - 1]}
        stapelForm[0]=form
    }

    fun add() {
        if(progNr!=0) prog(getNr("+"))
        enterCheck()
        val x=pop(); val y=stapel[0]
        stapel[0] = x+y
        printStapel()
    }
    fun sub() {
        if(progNr!=0) prog(getNr("-"))
        enterCheck()
        val x=pop(); val y=stapel[0]
        stapel[0] = y-x
        printStapel()
    }
    fun mult() {
        if(progNr!=0) prog(getNr("*"))
        enterCheck()
        val x=pop(); val y=stapel[0]
        stapel[0] = x*y
        printStapel()
    }
    fun div() {
        if(progNr!=0) prog(getNr("/"))
        enterCheck()
        val x=pop(); val y=stapel[0]
        stapel[0] = y/x
        printStapel()
    }

    fun enter0(v:View) {vi=v; enterDigit(0) }
    fun enter1(v:View) {vi=v; enterDigit(1) }
    fun enter2(v:View) {vi=v; enterDigit(2) }
    fun enter3(v:View) {vi=v; enterDigit(3) }
    fun enter4(v:View) {vi=v; enterDigit(4) }
    fun enter5(v:View) {vi=v; enterDigit(5) }
    fun enter6(v:View) {vi=v; enterDigit(6) }
    fun enter7(v:View) {vi=v; enterDigit(7) }
    fun enter8(v:View) {vi=v; enterDigit(8) }
    fun enter9(v:View) {vi=v; enterDigit(9) }
    fun enterDigit(k:Int) {
        if(k<=9 && progNr!=0) prog(getNr("$k"))
        if(k>9 && !hexmodus) {hexmodus=true; printStatus()}
        val digit:String = if(k<=9) "$k" else "${'A'+(k-10)}"
        if(enterFlag==0) {
            val x = k.toDouble(); push(x,defaultForm);
            enterFlag=1; doppelpunktFlag=0; exponentFlag=0; exponent=0; vorzeichenEingabe=1; vorzeichenExponent=1
            zahleingabe=digit
        } else if(exponentFlag!=0) {
            exponentEingabe += digit
            val basis = if(hexmodus) 16 else 10
            exponent = exponent*basis+k
        } else {
            zahleingabe += digit
        }
        //stapel[0]=x
        printStapel()
    }
    fun enterPunkt() {
         if(progNr!=0) prog(getNr("."))
         if(enterFlag==0) {
            push(0.0,defaultForm); zahleingabe="0."
            enterFlag=1; doppelpunktFlag=0; exponentFlag=0; exponent=0; vorzeichenEingabe=1; vorzeichenExponent=1
        } else if(doppelpunktFlag!=1) {
            zahleingabe += "."
        }
        printStapel()
    }
    fun enterDoppelpunkt() {
        if(progNr!=0) prog(getNr(":"))
        if(enterFlag==0) {
            if(stapelForm[0]=="Z") stapelForm[0]="G"
            else if(stapelForm[0]=="G") stapelForm[0]=defaultForm
            else stapelForm[0]="Z"
        } else {
            zahleingabe += ":"
            doppelpunktFlag++
        }
        printStapel()
    }
    fun enterPlusminus() {
        if(progNr!=0) prog(getNr("+/-"))
        if(exponentFlag!=0) {vorzeichenExponent = -vorzeichenExponent}
        else if(enterFlag!=0) {vorzeichenEingabe = -vorzeichenEingabe}
        else stapel[0] = -stapel[0]
        printStapel()
    }
    fun enterCorr() {
        if(pgmModus) {if(progNr!=0) prog(0); return}
        if(progNr!=0) prog(getNr("Cor"))
        if(enterFlag==0) return
        if(doppelpunktFlag!=0) {
            if(zahleingabe.isNotEmpty()) {
                if(zahleingabe.last()==':') doppelpunktFlag--
                zahleingabe = zahleingabe.dropLast(1)
            }
        } else if(exponentFlag!=0) {
            if(exponentEingabe.isEmpty()) exponentFlag=0
            else {
                if(hexmodus) {exponent /= 16} else {exponent /= 10}
                if(exponent==0) vorzeichenExponent=1
                if(exponentEingabe.isNotEmpty()) exponentEingabe = exponentEingabe.dropLast(1)
            }
        } else {
            if(zahleingabe.isNotEmpty()) zahleingabe = zahleingabe.dropLast(1)
            if(zahleingabe.isEmpty()) vorzeichenEingabe=1
        }
        printStapel()
    }
    fun funDel() {
        prog(funDelCod)
    }
    fun enterExp() {
        if(progNr!=0) prog(getNr("Exp"))
        if(doppelpunktFlag!=0) return
        if(exponentFlag==0) {
            if(enterFlag==0) {push(1.0,defaultForm); zahleingabe="1.0"; enterFlag=1;}
            exponent=0; exponentFlag=1; exponentEingabe=""
        }
        printStapel()
    }
    fun printStatus() {
        val degRad = if(degRadFlag==1) "Grad" else "RAD"
        val hexDec = if(hexmodus) "Hex" else "Dez"
        val str = "$hexDec   $degRad"
        feldStatus.setText(str)
        var str2=""
        if(pgmModus) str2 += "Programmiermodus "
        if(runningNr!=0) str2 += "F$runningNr running... "
        if(testString.isNotEmpty()) str2 += " $testString"
        if(errorString.isNotEmpty()) str2 += " $errorString"
        feldStatus2.setText(str2)
    }
    fun yhochx() {
        if(progNr!=0) prog(51) //5=Zeile von unten, 1=Spalte von links
        enterCheck()
        val x=pop(); val y=stapel[0]
        stapel[0] = pow(y,x)
        printStapel()
    }
    fun sqrtx() {
        if(progNr!=0) prog(getNr("Sqrt"))
        enterCheck()
        stapel[0] = sqrt(stapel[0])
        printStapel()
    }
    fun kehrwert() {
        if(progNr!=0) prog(getNr("1/x"))
        enterCheck()
        val x = stapel[0]; stapel[0] = 1.0 / x
        printStapel()
    }
    fun rad() {
        if(progNr!=0) prog(getNr("RAD"))
        degRadFlag=0; printStatus();
    }
    fun deg() {
        if(progNr!=0) prog(getNr("DEG"))
        degRadFlag=1; printStatus();
    }
    fun sqrx() {
        if(progNr!=0) prog(getNr("x^2"))
        enterCheck()
        val x=stapel[0]; stapel[0]=x*x
        printStapel()
    }
    fun exch() {
        if(progNr!=0) prog(55)
        enterCheck()
        val x=stapel[0]; val form=stapelForm[0]
        stapel[0]=stapel[1]; stapelForm[0]=stapelForm[1]
        stapel[1]=x; stapelForm[1]=form
        printStapel()
    }

    fun hex() {
        if(progNr!=0) prog(getNr("HEX"))
        if(enterFlag!=0) {hexmodus = if(hexmodus) false else true; printStatus(); return}
        if(stapelForm[0]=="X") stapelForm[0]=defaultForm
        else stapelForm[0]="X"
        printStapel()
    }

    fun fn() {
        revers = if(revers) false else true
        if(revers) {
            colBtn(btnFn,R.color.colFn)
            btnSin.text = "asin"; colBtn(btnSin,R.color.colFn)
            btnCos.text = "acos"; colBtn(btnCos,R.color.colFn)
            btnTan.text = "atan"; colBtn(btnTan,R.color.colFn)
            btnLn.text = "e^x"; colBtn(btnLn,R.color.colFn)
            btnLog.text = "10^x"; colBtn(btnLog,R.color.colFn)
            btnYhochx.text = "DEG"; colBtn(btnYhochx,R.color.colFn)
            btnSqrt.text = "RAD"; colBtn(btnSqrt,R.color.colFn)
            btnSto.text = "Pi"; colBtn(btnSto,R.color.colFn)
            btnRcl.text = "x!"; colBtn(btnRcl,R.color.colFn)
        } else {
            colBtn(btnFn,R.color.btnBackground)
            btnSin.text = "sin"; colBtn(btnSin,R.color.btnBackground)
            btnCos.text = "cos"; colBtn(btnCos,R.color.btnBackground)
            btnTan.text = "tan"; colBtn(btnTan,R.color.btnBackground)
            btnLn.text = "ln"; colBtn(btnLn,R.color.btnBackground)
            btnLog.text = "log"; colBtn(btnLog,R.color.btnBackground)
            btnYhochx.text = "y^x"; colBtn(btnYhochx,R.color.btnBackground)
            btnSqrt.text = "√"; colBtn(btnSqrt,R.color.btnBackground)
            btnSto.text = "STO"; colBtn(btnSto,R.color.btnBackground)
            btnRcl.text = "RCL"; colBtn(btnRcl,R.color.btnBackground)
        }
    }
    var fn2flag: Boolean = false
    var fn3flag: Boolean = false
    fun fn2() {
        fn2flag = if(fn2flag) false else true
        if(fn2flag) {
            revers=false
            colBtn(btnFn2,R.color.colFn2)
            btnFn.text = "HEX"; colBtn(btnFn,R.color.colFn2)
            btnSin.text = "B"; colBtn(btnSin,R.color.colFn2)
            btnCos.text = "C"; colBtn(btnCos,R.color.colFn2)
            btnTan.text = "D"; colBtn(btnTan,R.color.colFn2)
            btnLn.text = "E"; colBtn(btnLn,R.color.colFn2)
            btnLog.text = "F"; colBtn(btnLog,R.color.colFn2)
            btnYhochx.text = "A"; colBtn(btnYhochx,R.color.colFn2)
            btnSqrt.text = "1/x"; colBtn(btnSqrt,R.color.colFn2)
        } else {
            colBtn(btnFn2,R.color.btnBackground)
            btnFn.text = "Fn"; colBtn(btnFn,R.color.btnBackground)
            btnSin.text = "sin"; colBtn(btnSin,R.color.btnBackground)
            btnCos.text = "cos"; colBtn(btnCos,R.color.btnBackground)
            btnTan.text = "tan"; colBtn(btnTan,R.color.btnBackground)
            btnLn.text = "ln"; colBtn(btnLn,R.color.btnBackground)
            btnLog.text = "log"; colBtn(btnLog,R.color.btnBackground)
            btnYhochx.text = "y^x"; colBtn(btnYhochx,R.color.btnBackground)
            btnSqrt.text = "√"; colBtn(btnSqrt,R.color.btnBackground)
        }
    }

    var revers: Boolean = false

    fun sinx() {
        if(progNr!=0) prog(getNr("sin"))
        enterCheck()
        val x=stapel[0]
        stapel[0] = if(degRadFlag==1) sin(x*GRAD) else sin(x)
        printStapel()
    }
    fun asinx() {
        if(progNr!=0) prog(getNr("asin"))
        enterCheck()
        val x=stapel[0]
        stapel[0] = if(degRadFlag==1) asin(x)/GRAD else asin(x)
        printStapel()
    }
    fun cosx() {
        if(progNr!=0) prog(getNr("cos"))
        enterCheck()
        val x=stapel[0]
        stapel[0] = if(degRadFlag==1) cos(x*GRAD) else cos(x)
        printStapel()
    }
    fun acosx() {
        if(progNr!=0) prog(getNr("acos"))
        enterCheck()
        val x=stapel[0]
        stapel[0] = if(degRadFlag==1) acos(x)/GRAD else acos(x)
    }
    fun tanx() {
        if(progNr!=0) prog(getNr("tan"))
        enterCheck()
        val x=stapel[0]
        stapel[0] = if(degRadFlag==1) tan(x*GRAD) else tan(x)
        printStapel()
    }
    fun atanx() {
        if(progNr!=0) prog(getNr("atan"))
        enterCheck()
        val x=stapel[0]
        stapel[0] = if(degRadFlag==1) atan(x)/GRAD else atan(x)
        printStapel()
    }
    fun lnx() {
        if(progNr!=0) prog(getNr("ln"))
        enterCheck()
        val x=stapel[0]
        stapel[0] = ln(x)
        printStapel()
    }
    fun ehochx() {
        if(progNr!=0) prog(getNr("e^x"))
        enterCheck()
        val x=stapel[0]
        stapel[0] = exp(x)
        printStapel()
    }
    fun logx() {
        if(progNr!=0) prog(getNr("log"))
        enterCheck()
        val x=stapel[0]
        stapel[0] = log10(x)
        printStapel()
    }
    fun zehnhochx() {
        if(progNr!=0) prog(getNr("10^x"))
        enterCheck()
        val x=stapel[0]
        stapel[0] = pow(10.0,x)
        printStapel()
    }

    fun sto() {
        if(progNr!=0) prog(getNr("STO"))
        enterCheck()
        val n:Int = pop().toInt()
        if(n>=0 && n<=9) {val x=pop(); regist[n] = x}
        else {errorString="Error: wrong register number"; printStatus()}
        printStapel()
    }
    fun konstPi() {
        if(progNr!=0) prog(getNr("Pi"))
        enterCheck()
        push(PI,defaultForm)
        printStapel()
    }
    fun rcl() {
        if(progNr!=0) prog(getNr("RCL"))
        enterCheck()
        val n:Int = stapel[0].toInt()
        var x=0.0
        if(n>=0 && n<=9) x=regist[n]
        stapel[0] = x
        printStapel()
    }
    fun fakultaet() {
        if(progNr!=0) prog(getNr("x!"))
        enterCheck()
        var x = stapel[0];
        var z = 1.0
        while (x > 1.0) {
                z *= x; x -= 1.0
        }
        stapel[0] = z
        printStapel()
    }

    fun colBtn(btn: Button,id:Int) {
        btn.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(this,id)))
    }
    fun fnaus() {if(fn2flag) fn2() else if(revers) fn()}
    fun pgm(v: View) {vi=v
        if((pgmModus && fn3aktiv) || runningNr!=0) {fn3(); return}
        fnaus() //sicherstellen dass Fn und Fn2 ausgeschaltet
        if(pgmModus) {
            pgmModus = false
            colBtn(btnPgm, R.color.btnBackground)
            colBtn(btnF1, R.color.btnBackground)
            colBtn(btnF2, R.color.btnBackground)
            colBtn(btnF3, R.color.btnBackground)
        } else {
            pgmModus = true
            colBtn(btnPgm, R.color.btnProgBackground)
            colBtn(btnF1, R.color.btnProgBackground)
            colBtn(btnF2, R.color.btnProgBackground)
            colBtn(btnF3, R.color.btnProgBackground)
        }
        printStatus()
    }
    fun fn3() {
        fnaus() //Fn und Fn2 aus
        fn3flag = if(fn3flag) false else true
        if(fn3flag) {
            colBtn(btnPgm,R.color.colFn3)
            btnFn2.text = "END"; colBtn(btnFn2,R.color.colFn3)
            btnFn.text = "RET"; colBtn(btnFn,R.color.colFn3)
            btnSin.text = "BNE"; colBtn(btnSin,R.color.colFn3)
            btnCos.text = "BGT"; colBtn(btnCos,R.color.colFn3)
            btnTan.text = "BGE"; colBtn(btnTan,R.color.colFn3)
            btnLn.text = "BR"; colBtn(btnLn,R.color.colFn3)
            btnLog.text = "LBL"; colBtn(btnLog,R.color.colFn3)
            btnYhochx.text = "BEQ"; colBtn(btnYhochx,R.color.colFn3)
            btnSqrt.text = "BLT"; colBtn(btnSqrt,R.color.colFn3)
            btnXhoch2.text = "BLE"; colBtn(btnXhoch2,R.color.colFn3)
            btnExp.text = "CMP"; colBtn(btnExp,R.color.colFn3)
            btnPop.text = "SUB"; colBtn(btnPop,R.color.colFn3)
            btnExch.text = "INS"; colBtn(btnExch,R.color.colFn3)
            btnCor.text = "DEL"; colBtn(btnCor,R.color.colFn3)
        } else {
            colBtn(btnPgm,R.color.btnProgBackground)
            btnFn2.text = "Fn2"; colBtn(btnFn2,R.color.btnBackground)
            btnFn.text = "Fn"; colBtn(btnFn,R.color.btnBackground)
            btnSin.text = "sin"; colBtn(btnSin,R.color.btnBackground)
            btnCos.text = "cos"; colBtn(btnCos,R.color.btnBackground)
            btnTan.text = "tan"; colBtn(btnTan,R.color.btnBackground)
            btnLn.text = "ln"; colBtn(btnLn,R.color.btnBackground)
            btnLog.text = "log"; colBtn(btnLog,R.color.btnBackground)
            btnYhochx.text = "y^x"; colBtn(btnYhochx,R.color.btnBackground)
            btnSqrt.text = "√"; colBtn(btnSqrt,R.color.btnBackground)
            btnXhoch2.text = "x²"; colBtn(btnXhoch2,R.color.btnBackground)
            btnExp.text = "Exp"; colBtn(btnExp,R.color.btnBackground)
            btnPop.text = "Pop"; colBtn(btnPop,R.color.btnBackground)
            btnExch.text = "x↔y"; colBtn(btnExch,R.color.btnBackground)
            btnCor.text = "Cor"; colBtn(btnCor,R.color.btnBackground)
        }
    }

    fun ret() {
        if(progNr!=0) prog(codRet)
    }
    fun end() {
        if(progNr!=0) {saveProgramF(progNr,"programF$progNr"); endProg(); progNr=0}
        if(fn3flag) fn3() //fn3 ausschalten
        fn3aktiv=false
        btnPgm.text = "Pgm"
        colBtn(btnPgm,R.color.btnBackground)
        colBtn(btnF1,R.color.btnBackground)
        colBtn(btnF2,R.color.btnBackground)
        colBtn(btnF3,R.color.btnBackground)
        pgmModus=false; printStatus()
    }
    fun end2() {
        if(progNr!=0) {saveProgramF(progNr,"programF$progNr"); endProg(); progNr=0}
        if(fn3flag) fn3() //fn3 ausschalten
        fn3aktiv=false
        btnPgm.text = "Pgm"
        pgmModus = true
        colBtn(btnF1, R.color.btnProgBackground)
        colBtn(btnF2, R.color.btnProgBackground)
        colBtn(btnF3, R.color.btnProgBackground)
    }

    var n5=5  //Anzahl verfuegbare Zeilen in Programmlisting
    @SuppressLint("DefaultLocale")
    fun showProg(p: ProgSpeicher,adr:Int) {
        var str=""
        for(i in adr..adr+n5) {
            val cod = p.rami[i]
            val bef = getBef(cod)
            str += if(i==aktwr) ">" else " "
            str += String.format("%03d: %3d  %s\n",i,cod,bef)
        }
        progList.setText(str)
    }
    fun startProg(p: ProgSpeicher) {
        btnPgm.text = "Fn3"; fn3aktiv=true
        aktp=p; aktpc=0; aktwr=0; aktflags=0
        showProg(p,0)
        progList.visibility=View.VISIBLE
        feldT.setEms(10); feldZ.setEms(10); feldY.setEms(10); feldX.setEms(10)
    }

    fun f1(v: View) {vi=v
        if(progNr==1) {end(); return} else if(progNr!=0) end2()
        fnaus(); enterCheck();
        if(pgmModus) {
            progNr=1; colBtn(btnF1,R.color.btnRunBackground)
            startProg(progF1)
        }
        else {runningNr=1; runn(progF1, 0)}
    }
    fun f2(v: View) {vi=v
        if(progNr==2) {end(); return} else if(progNr!=0) end2()
        fnaus(); enterCheck();
        if(pgmModus) {
            progNr=2; colBtn(btnF2,R.color.btnRunBackground)
            startProg(progF2)
        }
        else {runningNr=2; runn(progF2,0)}
    }
    fun f3(v: View) {vi=v
        if(progNr==3) {end(); return} else if(progNr!=0) end2()
        fnaus(); enterCheck();
        if(pgmModus) {
            progNr=3; colBtn(btnF3,R.color.btnRunBackground)
            startProg(progF3)
        }
        else {runningNr=3; runn(progF3,0)}
    }

    fun updown(n:Int) {
        aktwr += n; if(aktwr<0) aktwr=0 else if(aktwr>=1000) aktwr=1000-1
        if(aktwr>aktpc+n5-1) aktpc++
        else if(aktwr<aktpc) aktpc=aktwr
        showProg(aktp,aktpc)
    }
    fun up(v: View) {vi=v; updown(-1)}
    fun down(v: View) {vi=v; updown(1)}

    // Programmier-Funktionen:
    val cmpEQ=1; val cmpGT=2; val cmpLT=4 //Werte die aktflags annehmen kann
    fun funCmp() {
        if(progNr!=0) prog(getNr("CMP"))
        val x=pop(); val y=stapel[0]
        aktflags = if(y==x) cmpEQ else if(y>x) cmpGT else cmpLT
        printStapel()
    }
    fun funLbl() {prog(codLBL)}
    fun funIns() {
        var pc=aktwr
        var tmp=aktp.rami[pc]
        aktp.rami[pc]=0
        while(++pc<1000-1 && aktp.rami[pc]!=0) {
            val tmp2=aktp.rami[pc]
            aktp.rami[pc]=tmp
            tmp=tmp2
        }
        aktp.rami[pc]=tmp
        showProg(aktp,aktpc)
    }
    fun funBrv() {prog(getNr("BR")); pop(); printStapel()}
    fun funSubxv() {prog(getNr("SUB")); pop(); printStapel()}
    fun funSubx(pc:Int):Int {return funBrx(pc)}
    fun funBrx(pc:Int):Int {
        var pcneu=pc
        var x:Int = pop().toInt()
        if(x<= -100 || x>=100) {x=99; errorString="ErrBXX"}
        if(pc<0) {printStapel(); return pc}
        if(x>0) {
            while(x>0 && pcneu<1000-2 && aktp.rami[pcneu]!=codEnd) {
                if(aktp.rami[++pcneu] == codLBL) x--
            }
        } else {
            if(x==0) x= -1
            while(x<0 && pcneu>0) {
                if(aktp.rami[--pcneu] == codLBL) x++
            }
            if(pcneu==0 && x<0) pcneu= -1
        }
        //printStapel()
        return pcneu
    }
    fun funBeq(pc:Int):Int {
        if(progNr!=0) prog(getNr("BEQ"))
        if(aktflags==cmpEQ) return funBrx(pc)
        pop(); printStapel()
        return pc
    }

    fun funBnev() {prog(361); pop(); printStapel()}
    fun funBne(pc:Int):Int {
        if(aktflags!=cmpEQ) return funBrx(pc)
        pop()
        return pc
    }
    fun funBlt(pc:Int):Int {
        if(progNr!=0) prog(getNr("BLT"))
        if(aktflags==cmpLT) return funBrx(pc)
        pop(); printStapel()
        return pc
    }
    fun funBle(pc:Int):Int {
        if(progNr!=0) prog(getNr("BLE"))
        if(aktflags==cmpLT || aktflags==cmpEQ) return funBrx(pc)
        pop(); printStapel()
        return pc
    }
    fun funBgt(pc:Int):Int {
        if(progNr!=0) prog(getNr("BGT"))
        if(aktflags==cmpGT) return funBrx(pc)
        pop(); printStapel()
        return pc
    }
    fun funBge(pc:Int):Int {
        if(progNr!=0) prog(getNr("BGE"))
        if(aktflags==cmpGT || aktflags==cmpEQ) return funBrx(pc)
        pop(); printStapel()
        return pc
    }

    fun loadProgramF(nr:Int,name:String): Boolean {
        val p = if(nr==1) progF1 else if(nr==2) progF2 else progF3
        var str=load(name); if(str.length<3) return false
        var pc=0
        while(pc<1000 && str.length>=3) {
            val c1=str[0]; val c2=str[1]; val c3=str[2]
            var z:Int = if(c1==' ') 0 else c1-'0'
            z = z*10 + if(c2==' ') 0 else c2-'0'
            z = z*10 + if(c3==' ') 0 else c3-'0'
            p.rami[pc++] = z
            str = str.drop(3)
        }
        return true
    }
    @SuppressLint("DefaultLocale")
    fun saveProgramF(nr:Int,name:String) {
        val p = if(nr==1) progF1 else if(nr==2) progF2 else progF3
        var imax=1000-1
        while(imax>0 && p.rami[imax]==0) {imax--}
        var str:String = ""
        for(i in 0..imax) {
            str += String.format("%3d",p.rami[i])
        }
        save(name,str)
    }
    fun countdown() {
        countDownTimer = object : CountDownTimer(100,100) {
            override fun onTick(millisUntilFinished: Long) {
                //tvCountdown.text = millisUntilFinished.toString()//test
                //countDownRest=millisUntilFinished //test
            }
            override fun onFinish() {
                //tvCountdown.text = "0" //test
                //countDownRest=0L //test
                runn2()
            }
        }.start()
    }

    var menuOffen=0
    fun settings(v: View) {vi=v
        if(menuOffen==0) {
            menu1.text = "Save...  "; menu1.visibility = View.VISIBLE
            menu2.text = "Load...  "; menu2.visibility = View.VISIBLE
            menu3.text = "Delete..."; menu3.visibility = View.VISIBLE
            menu4.text = "About    "; menu4.visibility = View.VISIBLE
            menuOffen=1
        } else menuAus()
    }
    fun menuAus() {
        menu1.visibility = View.INVISIBLE; menu2.visibility = View.INVISIBLE
        menu3.visibility = View.INVISIBLE; menu4.visibility = View.INVISIBLE
        menuOffen=0
    }

    fun menu1(v:View) {vi=v
        val builder = AlertDialog.Builder(this)
        builder.setTitle("welches Programm speichern?")
        val input = EditText(this)
        input.inputType = InputType.TYPE_NULL
        builder.setView(input)
        builder.setPositiveButton("F3") { dialog, which -> nameInputSave(3,"F3 speichern unter:") }
        builder.setNegativeButton("F2") { dialog, which -> nameInputSave(2,"F2 speichern unter:") }
        builder.setNeutralButton("F1") { dialog, which -> nameInputSave(1,"F1 speichern unter:") }
        builder.show()
    }
    fun nameInputSave(nr:Int,fragetext:String) {
        val builder = AlertDialog.Builder(this)
        builder.setTitle(fragetext)
        val input = EditText(this)
        input.inputType = InputType.TYPE_TEXT_FLAG_MULTI_LINE
        input.hint = "Programmname"
        builder.setView(input)
        builder.setPositiveButton("save") { dialog, which ->
            var name = input.text.toString().trim()
            if(name.isNotEmpty() && name[0]=='_') name = name.drop(1)
            if(name.isNotEmpty() && name!="index") {
                saveProgramF(nr, name)
                Toast.makeText(this, "F$nr unter $name gespeichert", Toast.LENGTH_SHORT).show()
                indexErweitern(name)
            } else Toast.makeText(this, "Fehler: nichts gespeichert", Toast.LENGTH_SHORT).show()
        }
        builder.setNegativeButton("cancel") {dialog, which ->
            Toast.makeText(this, "Cancel: nichts gespeichert", Toast.LENGTH_SHORT).show()
        }
        builder.show()
        menuAus()
    }

    fun menu2(v:View) {vi=v
        val builder = AlertDialog.Builder(this)
        builder.setTitle("welches Programm laden?")
        val input = EditText(this)
        input.inputType= InputType.TYPE_NULL
        builder.setView(input)
        builder.setPositiveButton("F3") { dialog, which -> programmLaden(3) }
        builder.setNegativeButton("F2") { dialog, which -> programmLaden(2) }
        builder.setNeutralButton("F1") { dialog, which -> programmLaden(1) }
        builder.show()
    }
    fun menu3(v:View) {vi=v
        programmLoeschen()
    }
    fun menu4(v:View) {vi=v
        Toast.makeText(this, "Version 1.0", Toast.LENGTH_LONG).show()
        menuAus()
    }

    //Layout an aktuelle Bildschirmgroesse anpassen:

    fun bildschirmgroesse() {
        val displayMetrics = this.resources.displayMetrics
        val screenWidth = displayMetrics.widthPixels
        val screenHeight = displayMetrics.heightPixels
        val dpi = displayMetrics.densityDpi
        val xdpi = displayMetrics.xdpi
        val ydpi = displayMetrics.ydpi
        val y=(gety(btnFn2)*160/dpi+0.5).toInt()
        //testString="$screenWidth $screenHeight dpi=$dpi xydpi:$xdpi $ydpi"
        testString="$screenWidth $screenHeight dpi=$dpi"
        //testString="dpi=$dpi xdpi=$xdpi ydpi=$ydpi"
    }

    fun layoutAnpassen() {
        val displayMetrics = this.resources.displayMetrics
        //val screenWidth = displayMetrics.widthPixels
        val screenHeight = displayMetrics.heightPixels
        val dpi = displayMetrics.densityDpi
        //val xdpi = displayMetrics.xdpi
        val ydpi = displayMetrics.ydpi
        var hoehedp = screenHeight*160.0/ydpi //Umrechnung von Pixel auf dp
        val dpy=ydpi/160.0 //Umrechnungsfaktor fuer dp nach Pixl
        hoehedp *= 0.95 //5 Prozent fuer unteren Rand abziehen
        hoehedp = runden(hoehedp,1)
        val maxjetzt=570 //benutzte Hoehe in dp mit Layout von activity_main.xml
        val mehr=8*5+2 //zusaetzliche dp benoetigt fuer groessere Tasten
        if(maxjetzt+mehr <= hoehedp) {
            // groessere Tasten machen:
            var rest=(hoehedp-(maxjetzt+mehr)).toInt()
            var h=48; var h2=50
            if(rest>9) {h2++; rest-=9}
            while(rest>8 && h<55) {h++; h2++; rest-=8}
            var dy:Int=(gety(btnFn2)*160/dpi+0.5).toInt()
            //var dy:Int=185 //test
            dy += rest/2
            setz(btnFn2,h,dy,dpy); setz(btnPgm,h,dy,dpy); setz(btnF1,h,dy,dpy); setz(btnF2,h,dy,dpy); setz(btnF3,h,dy,dpy)
            dy+=h2
            setz(btnFn,h,dy,dpy); setz(btnSto,h,dy,dpy); setz(btnRcl,h,dy,dpy); setz(btnUp,h,dy,dpy); setz(btnDown,h,dy,dpy)
            dy+=h2
            setz(btnSin,h,dy,dpy); setz(btnCos,h,dy,dpy); setz(btnTan,h,dy,dpy); setz(btnLn,h,dy,dpy); setz(btnLog,h,dy,dpy)
            dy+=h2
            setz(btnYhochx,h,dy,dpy); setz(btnSqrt,h,dy,dpy); setz(btnXhoch2,h,dy,dpy); setz(btnPop,h,dy,dpy); setz(btnExch,h,dy,dpy)
            dy+=h2
            setz(btn7,h,dy,dpy); setz(btn8,h,dy,dpy); setz(btn9,h,dy,dpy); setz(btnExp,h,dy,dpy); setz(btnCor,h,dy,dpy)
            dy+=h2
            setz(btn4,h,dy,dpy); setz(btn5,h,dy,dpy); setz(btn6,h,dy,dpy); setz(btnMul,h,dy,dpy); setz(btnDiv,h,dy,dpy)
            dy+=h2
            setz(btn1,h,dy,dpy); setz(btn2,h,dy,dpy); setz(btn3,h,dy,dpy); setz(btnPlus,h,dy,dpy); setz(btnMinus,h,dy,dpy)
            dy+=h2
            setz(btn0,h,dy,dpy); setz(btnPlusMin,h,dy,dpy); setz(btnPunkt,h,dy,dpy); setz(btnDoppelpunkt,h,dy,dpy); setz(btnEnt,h,dy,dpy)
            dy+=h2
            sety(feldStatus,dy,dpy)
            sety(feldStatus2,dy,dpy)
            if(rest>40) {
                dy = rest/2-20
                xyztRunterschieben(dy,dpy)
                val params=recyclerView.layoutParams as ViewGroup.MarginLayoutParams
                params.height += (dy*dpy+0.5).toInt()
                recyclerView.layoutParams=params
                n5 += dy/20 //Anzahl verfuegbare Zeilen in Proglist anpassen
            }
        }
    }
    fun xyztRunterschieben(dy:Int, dpy:Double) {
        sety2(feldX,dy,dpy)
        sety2(feldY,dy,dpy)
        sety2(feldZ,dy,dpy)
        sety2(feldT,dy,dpy)
    }
    fun setz(btn:Button,h:Int,dy:Int,dpy:Double) {
        val params=btn.layoutParams as ViewGroup.MarginLayoutParams
        params.height=(h*dpy+0.5).toInt()
        params.topMargin=(dy*dpy+0.5).toInt()
        btn.layoutParams=params
    }
    fun sety(tv:TextView,dy:Int,dpy:Double) {
        val params=tv.layoutParams as ViewGroup.MarginLayoutParams
        params.topMargin=(dy*dpy+0.5).toInt()
        tv.layoutParams=params
    }
    fun sety2(tv:TextView,dy:Int,dpy:Double) {
        val params=tv.layoutParams as ViewGroup.MarginLayoutParams
        params.topMargin += (dy*dpy+0.5).toInt()
        tv.layoutParams=params
    }
    fun gety(btn:Button):Int {
        val params=btn.layoutParams as ViewGroup.MarginLayoutParams
        val y=params.topMargin
        return y
    }
    //Dateien speichern/einlesen  (koennte man moeglicherweise in separate Datei auslagern)
    fun save(name:String,text:String) {
        delete(name)
        note1.edit(commit = true) { putString(name, text) }
    }
    fun load(name:String):String {
        var str = note1.getString(name,"")
        if(str==null) str=""
        return str
    }
    fun delete(name:String) {
        if(note1.getString(name,"")!="") {
            note1.edit(commit = true) { remove(name) }
        }
        var neueListe:List<String> = emptyList()
        for(s in dateiListe) {
            if(s!=name) neueListe += s
        }
        dateiListe=neueListe
    }
    fun indexInit() {
        note1.edit(commit = true) { putString("index", "Test1") }
        note1.edit(commit = true) { putString("Test1", " 00 01 02") }
    }
    fun dateiListeEinlesen() {
        var str = load("index").trim()
        if(str.isEmpty() || str=="") {indexInit(); str=load("index")}
        val tmpListe: List<String> = str.split(' ')
        dateiListe = emptyList()
        for(s in tmpListe) {
            if(note1.getString(s,"")!="") dateiListe += s
        }
    }
    fun indexErweitern(name:String) {
        delete("index")
        var str:String = ""
        for(s in dateiListe) {
            str += "$s "
        }
        str += name
        save("index", str)
        dateiListeEinlesen()
    }

    var zuLadendesProgramm:Int = 0
    var programmDelete:Int = 0
    fun programmLaden(nr:Int) {
        zuLadendesProgramm=nr
        programmDelete=0
        titel.text = "Datei laden:"
        scrollListeErstellen()
    }
    fun programmLoeschen() {
        zuLadendesProgramm=0
        programmDelete=1
        titel.text = "Datei löschen:"
        scrollListeErstellen()
    }
    fun scrollListeErstellen() {
        //recyclerView = findViewById(R.id.mRecyclerView)
        val adapter: ArecyclerViewAdapter = ArecyclerViewAdapter(this, dateiListe+"Cancel", this)
        recyclerView.adapter=adapter
        recyclerView.layoutManager= LinearLayoutManager(this)
        recyclerView.visibility=View.VISIBLE
    }

    override fun onClick(v: View?) {
        Toast.makeText(this, "onClick()", Toast.LENGTH_SHORT).show()
    }

    override fun onItemClicked(item: String) {
        val nr=zuLadendesProgramm
        val name:String = item.trim()
        if(nr!=0 && name!="Cancel") {
            if (loadProgramF(nr, name)) {
                Toast.makeText(this, "F$nr von $name geladen", Toast.LENGTH_SHORT).show()
            } else {
                Toast.makeText(this, "Fehler: konnte '$name' nicht laden", Toast.LENGTH_SHORT).show()
            }
        } else if(nr==0 && programmDelete==1 && name.isNotEmpty() && name!="Cancel" && name!="index") {
            delete(name)
            dateiListeEinlesen()
            Toast.makeText(this, "Datei '$name' geloescht", Toast.LENGTH_SHORT).show()
        }
        titel.text = "Minirechner"
        zuLadendesProgramm=0
        programmDelete=0
        menuAus()
        recyclerView.visibility = View.GONE
    }

}
