package ch.rolfp.mond
import kotlin.math.*
//const val kgauss:Double = 0.01720209895

fun posvel(l:Double, b:Double, r:Double, dl:Double, db:Double, dr:Double): Array<Double> {
    val cl=cs(l); val sl=sn(l); val cb=cs(b); val sb=sn(b)
    val x = r*cl*cb;  val vx = dr*cl*cb-dl*r*sl*cb-db*r*cl*sb
    val y = r*sl*cb;  val vy = dr*sl*cb+dl*r*cl*cb-db*r*sl*sb
    val z = r*sb;     val vz = dr*sb              +db*r*cb
    return arrayOf(x,y,z,vx,vy,vz)
}

fun geocen(t:Double, lp:Double, bp:Double, rp:Double,
           ls:Double, bs:Double, rs:Double, iplan:Int, imode:Int): Array<Double> {
    var dl=0.0; var db=0.0; var dr=0.0; var dls=0.0; var dbs=0.0; var drs=0.0
    var sinm:Double; var cosm:Double; var sin2m:Double; var cos2m:Double
    var sin3m:Double; var cos3m:Double; var sin4m:Double; var cos4m:Double
    if(imode>0) {
        val m = p2 * frac(0.9931266 + 99.9973604 * t)              // Sun     //
        dls = 172.00 + 5.75 * sin(m); drs = 2.87 * cos(m); dbs = 0.0
        // dl,db in 1e-4 rad/d, dr in 1e-4 AU/d //
        when (iplan) {
            0 -> {}//dl=db=dr=0.0; // Sun
            1 -> {
                val m = p2 * frac(0.4855407 + 415.2014314 * t) // Mercury //
                sinm = sin(m); sin2m = sin(2 * m); sin3m = sin(3 * m); sin4m = sin(4 * m)
                cosm = cos(m); cos2m = cos(2 * m); cos3m = cos(3 * m); cos4m = cos(4 * m)
                dl = 714.00 + 292.66 * cosm + 71.96 * cos2m + 18.16 * cos3m
                +4.61 * cos4m + 3.81 * sin2m + 2.43 * sin3m
                +1.08 * sin4m
                dr = 55.94 * sinm + 11.36 * sin2m + 2.60 * sin3m
                db = 73.40 * cosm + 29.82 * cos2m + 10.22 * cos3m
                +3.28 * cos4m - 40.44 * sinm - 16.55 * sin2m
                -5.56 * sin3m - 1.72 * sin4m
            }

            2 -> {
                val m = p2 * frac(0.1400197 + 162.5494552 * t)    // Venus   //
                sinm = sin(m); cosm = cos(m)
                dl = 280.00 + 3.79 * cosm; dr = 1.37 * sinm
                db = 9.54 * cosm - 13.57 * sinm
            }

            3 -> {
                dl = dls; dr = drs; db = -dbs
            }          // Earth   //
            4 -> {
                val m = p2 * frac(0.0538553 + 53.1662736 * t)     // Mars    //
                sinm = sin(m); cosm = cos(m); cos2m = cos(2 * m)
                dl = 91.50 + 17.07 * cosm + 2.03 * cos2m
                dr = 12.98 * sinm + 1.21 * cos2m
                db = 0.83 * cosm + 2.80 * sinm
            }

            5 -> {
                val m = p2 * frac(0.0565314 + 8.4302963 * t)      // Jupiter //
                sinm = sin(m)
                dl = 14.50 + 1.41 * cos(m); dr = 3.66 * sinm; db = 0.33 * sinm
            }

            6 -> {
                val m = p2 * frac(0.8829867 + 3.3947688 * t)      // Saturn  //
                cosm = cos(m)
                dl = 5.84 + 0.65 * cosm; dr = 3.09 * sin(m); db = 0.24 * cosm
            }

            7 -> {
                val m = p2 * frac(0.3967117 + 1.1902849 * t)      // Uranus  //
                sinm = sin(m)
                dl = 2.05 + 0.19 * cos(m); dr = 1.86 * sinm; db = -0.03 * sinm
            }

            8 -> {
                val m = p2 * frac(0.7214906 + 0.6068526 * t)      // Neptune //
                sinm = sin(m)
                dl = 1.04 + 0.02 * cos(m); dr = 0.27 * sinm; db = 0.03 * sinm
            }

            9 -> {
                val m = p2 * frac(0.0385795 + 0.4026667 * t)      // Pluto   //
                sinm = sin(m); cosm = cos(m); sin2m = sin(2 * m)
                dl = 0.69 + 0.34 * cosm + 0.12 * cos(2 * m) + 0.05 * cos(3 * m)
                dr = 6.66 * sinm + 1.64 * sin2m
                db = -0.08 * cosm - 0.17 * sinm - 0.09 * sin2m
            }
        } // end of when block
    } // end of if
    var p = posvel(ls,bs,rs,dls,dbs,drs)
    val xs=p[0]; val ys=p[1]; val zs=p[2]; val vxs=p[3]; val vys=p[4]; val vzs=p[5]
    p = posvel(lp,bp,rp,dl ,db ,dr)
    val xp=p[0]; val yp=p[1]; val zp=p[2]; val vx=p[3]; val vy=p[4]; val vz=p[5]
    var x=0.0; var y=0.0; var z=0.0; var delta0=0.0
    if(iplan!=3) {x=xp+xs; y=yp+ys; z=zp+zs; delta0=sqrt(x*x+y*y+z*z);}
    val fac = 0.00578 * delta0 * 1e-4
    when(imode) {
        1 -> {x -= fac*vx;  y -= fac*vy;  z -= fac*vz}
        2 -> {x -= fac*(vx+vxs); y -= fac*(vy+vys); z -= fac*(vz+vzs)}
    }
    return arrayOf(xp,yp,zp,  xs,ys,zs, x,y,z, delta0)
}

/*-----------------------------------------------------------------------*/
/* NUTEQU: transformation of mean to true coordinates                    */
/*         (including terms >0.1" according to IAU 1980)                 */
/*         T = (JD-2451545.0)/36525.0                                    */
/*-----------------------------------------------------------------------*/
fun nutequ(t:Double, x:Double, y:Double, z:Double): Array<Double> {
    val ls  = ZWEIPI*frac(0.993133+  99.997306*t) // mean anomaly Sun
    val d   = ZWEIPI*frac(0.827362+1236.853087*t) // diff. longitude Moon-Sun
    val f   = ZWEIPI*frac(0.259089+1342.227826*t) // mean argument of latitude
    val n   = ZWEIPI*frac(0.347346-   5.372447*t) // longitude ascending node
    val eps = 0.4090928 - 2.2696e-4 * t           // obliquity of the ecliptic
    val fdn2:Double = 2.0*(f-d+n); val fn2:Double = 2.0*(f+n); val n2:Double = n+n
    val dpsi = (-17.200*sin(n)  - 1.319*sin(fdn2) - 0.227*sin(fn2)
            +  0.206*sin(n2) + 0.143*sin(ls) ) / arc
    val deps = (  9.203*cos(n)  + 0.574*cos(fdn2) + 0.098*cos(fn2)
            -  0.090*cos(n2) ) / arc
    val c = dpsi*cos(eps);  val s = dpsi*sin(eps)
    val dx = -(c*y+s*z); val dy = c*x-deps*z; val dz = s*x+deps*y
    return arrayOf(x+dx, y+dy, z+dz)
}

/*
fun horequ() {
    //TODO
}

fun equhor() {
    //TODO
}
*/