package ch.rolfp.nmrprecalc;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;

/**
 * Created by rpfister on 27.11.15.
 */
public class AlkenActivity extends Activity implements View.OnClickListener, AdapterView.OnItemSelectedListener  {

    public static String r1,r2,r3,r4,warnstring;
    public static double wert13c1,wert13c2;
    public static double wert1h1,wert1h2,wert1h3,wert1h4;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_alken);
        Button button = (Button) findViewById(R.id.button5);
        button.setOnClickListener(this);
        Spinner spinner = (Spinner)findViewById(R.id.spinner2);
        ArrayAdapter adapter=ArrayAdapter.createFromResource(this,R.array.solvents,android.R.layout.simple_spinner_item);
        spinner.setAdapter(adapter);
        spinner.setSelection(MainActivity.getSolventNr()); //auf aktuellen Wert setzen
        spinner.setOnItemSelectedListener(this);
    }

    @Override
    public void onClick(View v) {
        EditText editText;
        editText = (EditText) findViewById(R.id.editText2);
        r1 = editText.getText().toString(); if(istleer(r1)) r1="H";
        editText = (EditText) findViewById(R.id.editText12);
        r2 = editText.getText().toString(); if(istleer(r2)) r2="H";
        editText = (EditText) findViewById(R.id.editText13);
        r3 = editText.getText().toString(); if(istleer(r3)) r3="H";
        editText = (EditText) findViewById(R.id.editText14);
        r4 = editText.getText().toString(); if(istleer(r4)) r4="H";

        //hier die Berechnung machen
        Object[] result;
        warnstring="";
        double startwert13c,startwert1h;
        switch(MainActivity.getSolventNr()) {
            case 2: //DMSO-D6
                startwert13c=123.3d; startwert1h=5.25d;
                break;
            default: //CDCl3
                startwert13c=123.3d; startwert1h=5.25d;
                break;
        }
        wert13c1=wert13c2 = startwert13c; //Wert fuer Ethylen?
        wert1h1=wert1h2=wert1h3=wert1h4 = startwert1h; //Wert fuer Ethylen?

        //Tabellen auswerten:
	    result=BenzolActivity.formelSuchen(r1, alken13c_tabelle, 2);
	    if(result[0]!=null) warnstring += addwarning(r1,(String)result[0]);
	    wert13c1 += (double)result[1];
	    wert13c2 += (double)result[2];
	    result=BenzolActivity.formelSuchen(r2, alken13c_tabelle, 2);
	    if(result[0]!=null) warnstring += addwarning(r2,(String)result[0]);
	    wert13c1 += (double)result[2];
	    wert13c2 += (double)result[1];
	    result=BenzolActivity.formelSuchen(r3, alken13c_tabelle, 2);
	    if(result[0]!=null) warnstring += addwarning(r3,(String)result[0]);
	    wert13c1 += (double)result[2];
	    wert13c2 += (double)result[1];
        result=BenzolActivity.formelSuchen(r4, alken13c_tabelle, 2);
        if(result[0]!=null) warnstring += addwarning(r4,(String)result[0]);
        wert13c1 += (double)result[1];
        wert13c2 += (double)result[2];

    	if(!r1.equals("H")) {
	        result=BenzolActivity.formelSuchen(r1, alken_tabelle, 3);
	        if(result[0]!=null) warnstring += addwarning2(r1,(String)result[0]);
	        wert1h4 += (double)result[1];
	        if(r2.equals("H")) wert1h2 += (double)result[2];
	        if(r3.equals("H")) wert1h3 += (double)result[3];
            wert1h1=0;
        }

	    if(!r2.equals("H")) {
	        result=BenzolActivity.formelSuchen(r2, alken_tabelle, 3);
	        if(result[0]!=null) warnstring += addwarning2(r2,(String)result[0]);
	        wert1h1 += (double)result[2];
	        if(r1.equals("H")) wert1h3 += (double)result[1];
	        if(r3.equals("H")) wert1h4 += (double)result[3];
	        wert1h2=0;
	    }

        if(!r3.equals("H")) {
            result=BenzolActivity.formelSuchen(r3, alken_tabelle, 3);
            if(result[0]!=null) warnstring += addwarning2(r3,(String)result[0]);
            wert1h1 += (double)result[3];
            if(r2.equals("H")) wert1h2 += (double)result[1];
            if(r2.equals("H")) wert1h4 += (double)result[2];
            wert1h3=0;
        }

        if(!r4.equals("H")) {
            result=BenzolActivity.formelSuchen(r4, alken_tabelle, 3);
            if(result[0]!=null) warnstring += addwarning2(r4,(String)result[0]);
            wert1h1 += (double)result[1];
            if(r2.equals("H")) wert1h2 += (double)result[3];
            if(r2.equals("H")) wert1h3 += (double)result[2];
            wert1h4=0;
        }

        //Resultate anzeigen:
        startActivity(new Intent(this, ResultatActivityAlken.class));

    }

    private boolean istleer(String st) {return (st==null || st.length()==0);}

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        //TextView mytext = (TextView) view;
        MainActivity.setSolventNr(position);
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {
    }

    static String addwarning(String gesucht,String gefunden)
    {
        return gesucht+" not found, best match: "+gefunden+"\n";
    }

static String addwarning2(String gesucht,String gefunden)
{
 return gesucht+" -> "+gefunden+"\n";
}

final static Object[] alken_tabelle =
  {
   //    H     R2
   //     \   /
   //      C=C
   //     /   \
   //    R1    R3
   //            1=gem  2=cis  3=trans
   "H",          0.00,  0.00,  0.00,
   // aus Hesse Seite 129:
   "R",          0.45,  -0.22,  -0.28,
   "CH3",        0.45,  -0.22,  -0.28,
   "CH2-Aryl",   1.05,  -0.29,  -0.32,
   "CH2OR",      0.64,  -0.01,  -0.02,
   "CH2NR2",     0.58,  -0.10,  -0.08,
   "CH2-Hal",    0.70,   0.11,  -0.04,
   "CH2-CO-R",   0.69,  -0.08,  -0.06,
   "CH2COR",     0.69,  -0.08,  -0.06,
   "CR=CR2",     1.00,  -0.09,  -0.23,
   "C(R)=CR2",   1.00,  -0.09,  -0.23,
   "CequvC",     0.47,   0.38,   0.12,
   "CC",         0.47,   0.38,   0.12,
   "Aryl",       1.38,   0.36,  -0.07,
   "C6H5",       1.38,   0.36,  -0.07,
   "CH=O",       1.02,   0.95,   1.17,
   "COH",        1.02,   0.95,   1.17,
   "CO-R",       1.10,   1.12,   0.87,
   "CO-OH",      0.97,   1.41,   0.71,
   "COOH",       0.97,   1.41,   0.71,
   "CO-OR",      0.80,   1.18,   0.55,
   "COOR",       0.80,   1.18,   0.55,
   "CO-NR2",     1.37,   0.98,   0.46,
   "CONR2",      1.37,   0.98,   0.46,
   "CO-Cl",      1.11,   1.46,   1.01,
   "COCl",       1.11,   1.46,   1.01,
   "CequvN",     0.27,   0.75,   0.55,
   "CN",         0.27,   0.75,   0.55,
   "OR",             1.22,  -1.07,  -1.21,
   "OR(gesaettigt)", 1.22,  -1.07,  -1.21,
   "OR(unges.)",     1.21,  -0.60,  -1.00,
   "O-CO-R",     2.11,  -0.35,  -0.64,
   "OCOR",       2.11,  -0.35,  -0.64,
   "S-R",        1.11,  -0.29,  -0.13,
   "SO2-R",      1.55,   1.16,   0.93,
   "NR2",             0.80,  -1.26,  -1.21,
   "NR2(gesaettigt)", 0.80,  -1.26,  -1.21,
   "NR2(unges.)",     1.17,  -0.53,  -0.99,
   "N-CO-R",     2.08,  -0.57,  -0.72,
   "NO2",        1.87,   1.32,   0.62,
   "F",          1.54,  -0.40,  -1.02,
   "Cl",         1.08,   0.18,   0.13,
   "Br",         1.07,   0.45,   0.55,
   "I",          1.14,   0.81,   0.88,
   "J",          1.14,   0.81,   0.88,
   null,          0.0,   0.0,    0.0
  };

final static Object[] alken13c_tabelle =
  {"H",          0.00,  0.00,
   // aus Hesse Seite 173:
   "CH3",        10.6,  -8.0,
   "R",          10.6,  -8.0,
   "C2H5",       15.5,  -9.7,
   "CH2CH3",     15.5,  -9.7,
   "CH2CH2CH3",  14.0,  -8.2,
   "(CH2)2CH3",  14.0,  -8.2,
   "(CH2)3CH3",  14.7,  -9.0,
   "CH=CH2",     13.6,  -7.0,
   "CequivC-R",  -7.5,  8.9,
   "CC-R",       -7.5,  8.9,
   "C6H5",       12.5,  -11.0,
   "CH2Cl",      10.2,  -6.0,
   "CH2Br",      10.9,  -4.5,
   "CH2OR",      13.0,  -8.6,
   "CH=O",       13.1,  12.7,
   "COH",        13.1,  12.7,
   "CO-CH3",     15.0,  5.9,
   "COCH3",      15.0,  5.9,
   "COOH",        4.2,  8.9,
   "COOR",        6.0,  7.0,
   "CN",        -15.1,  14.2,
   "OR",         28.8,  -39.5,
   "O-CO-R",     18.0,  -27.0,
   "OCOR",       18.0,  -27.0,
   "NR2",        16.0,  -29.0,
   "N+(CH3)3",   19.8,  -10.6,
   "N(CH3)3",    19.8,  -10.6,
   "NO2",        22.3,  -0.9,
   "SR",         19.0,  -16.0,
   "F",          24.9,  -34.3,
   "Cl",          2.6,  -6.1,
   "Br",         -7.9,  -1.4,
   "I",         -38.1,  7.0,
   "J",         -38.1,  7.0,
   null,          0.0,  0.0
  };

}
