package ch.rolfp.nmrprecalc;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;

/**
 * Created by rpfister on 25.11.15.
 */
public class BenzolActivity extends Activity implements View.OnClickListener, AdapterView.OnItemSelectedListener {

    public static String r1,r2,r3,r4,r5,r6,warnstring;
    public static double c13r1,c13r2,c13r3,c13r4,c13r5,c13r6;
    public static double h1r1,h1r2,h1r3,h1r4,h1r5,h1r6;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_benzol);
        Button button = (Button) findViewById(R.id.button4);
        button.setOnClickListener(this);
        Spinner spinner = (Spinner)findViewById(R.id.spinner3);
        ArrayAdapter adapter=ArrayAdapter.createFromResource(this,R.array.solvents,android.R.layout.simple_spinner_item);
        spinner.setAdapter(adapter);
        spinner.setSelection(MainActivity.getSolventNr()); //auf aktuellen Wert setzen

        spinner.setOnItemSelectedListener(this);
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        /*
        TextView mytext = (TextView) view;
        String tmpsolvent = mytext.getText().toString();
        Log.d("Testpunkt", "tmpsolvent=" + tmpsolvent);
        */
        //Log.d("Testpunkt", "solventNr=" + position);
        MainActivity.setSolventNr(position);
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {
    }


    @Override
    public void onClick(View v) {
        EditText editText;
        editText = (EditText) findViewById(R.id.editText3);
        r1 = editText.getText().toString(); if(istleer(r1)) r1="H";
        editText = (EditText) findViewById(R.id.editText4);
        r2 = editText.getText().toString(); if(istleer(r2)) r2="H";
        editText = (EditText) findViewById(R.id.editText5);
        r3 = editText.getText().toString(); if(istleer(r3)) r3="H";
        editText = (EditText) findViewById(R.id.editText6);
        r4 = editText.getText().toString(); if(istleer(r4)) r4="H";
        editText = (EditText) findViewById(R.id.editText7);
        r5 = editText.getText().toString(); if(istleer(r5)) r5="H";
        editText = (EditText) findViewById(R.id.editText8);
        r6 = editText.getText().toString(); if(istleer(r6)) r6="H";

        //hier die Berechnung machen
	    Object[] result;
	    warnstring="";
        double startwert13c,startwert1h;
        switch(MainActivity.getSolventNr()) {
            case 2: //DMSO-D6
                startwert13c=128.19d; startwert1h=7.33d;
                break;
            default: //CDCl3
                startwert13c=128.34d; startwert1h=7.32d;
                break;
        }

        c13r1=c13r2=c13r3=c13r4=c13r5=c13r6 = startwert13c; //Wert fuer Benzol
        h1r1=h1r2=h1r3=h1r4=h1r5=h1r6 = startwert1h; //Wert fuer Benzol

	result=formelSuchen(r1, benzshift13c_tabelle, 4);
	if(result[0]!=null) warnstring += addwarning(r1,(String)result[0]);
	c13r1 += (double)result[1]; //Shift fuer C1
	c13r2 += (double)result[2]; //Shift fuer orto
	c13r6 += (double) result[2]; //Shift fuer orto
	c13r3 += (double) result[3]; //Shift fuer meta
	c13r5 += (double) result[3]; //Shift fuer meta
	c13r4 += (double) result[4]; //Shift fuer para

	result=formelSuchen(r2, benzshift13c_tabelle, 4);
	if(result[0]!=null) warnstring += addwarning(r2,(String)result[0]);
	c13r2 += (double)result[1]; //Shift fuer C1
	c13r3 += (double)result[2]; //Shift fuer orto
	c13r1 += (double) result[2]; //Shift fuer orto
	c13r4 += (double) result[3]; //Shift fuer meta
	c13r6 += (double) result[3]; //Shift fuer meta
	c13r5 += (double) result[4]; //Shift fuer para

	result=formelSuchen(r3, benzshift13c_tabelle, 4);
	if(result[0]!=null) warnstring += addwarning(r3,(String)result[0]);
	c13r3 += (double)result[1]; //Shift fuer C1
	c13r4 += (double)result[2]; //Shift fuer orto
	c13r2 += (double) result[2]; //Shift fuer orto
	c13r5 += (double) result[3]; //Shift fuer meta
	c13r1 += (double) result[3]; //Shift fuer meta
	c13r6 += (double) result[4]; //Shift fuer para

	result=formelSuchen(r4, benzshift13c_tabelle, 4);
	if(result[0]!=null) warnstring += addwarning(r4,(String)result[0]);
	c13r4 += (double)result[1]; //Shift fuer C1
	c13r5 += (double)result[2]; //Shift fuer orto
	c13r3 += (double) result[2]; //Shift fuer orto
	c13r6 += (double) result[3]; //Shift fuer meta
	c13r2 += (double) result[3]; //Shift fuer meta
	c13r1 += (double) result[4]; //Shift fuer para

	result=formelSuchen(r5, benzshift13c_tabelle, 4);
	if(result[0]!=null) warnstring += addwarning(r5,(String)result[0]);
	c13r5 += (double)result[1]; //Shift fuer C1
	c13r6 += (double)result[2]; //Shift fuer orto
	c13r4 += (double) result[2]; //Shift fuer orto
	c13r1 += (double) result[3]; //Shift fuer meta
	c13r3 += (double) result[3]; //Shift fuer meta
	c13r2 += (double) result[4]; //Shift fuer para

	result=formelSuchen(r6, benzshift13c_tabelle, 4);
	if(result[0]!=null) warnstring += addwarning(r6,(String)result[0]);
	c13r6 += (double)result[1]; //Shift fuer C1
	c13r1 += (double)result[2]; //Shift fuer orto
	c13r5 += (double) result[2]; //Shift fuer orto
	c13r2 += (double) result[3]; //Shift fuer meta
	c13r4 += (double) result[3]; //Shift fuer meta
	c13r3 += (double) result[4]; //Shift fuer para

	if(!r1.equals("H"))
	 {
	  result=formelSuchen(r1, benzshift_tabelle, 3); //Tabelle fuer 1H-NMR
	  if(result[0]!=null) warnstring += "..R1";
	  if(r2.equals("H"))  h1r2 += (double) result[1]; //Shift fuer orto
	  if(r6.equals("H"))  h1r6 += (double) result[1]; //Shift fuer orto
	  if(r3.equals("H"))  h1r3 += (double) result[2]; //Shift fuer meta
	  if(r5.equals("H"))  h1r5 += (double) result[2]; //Shift fuer meta
	  if(r4.equals("H"))  h1r4 += (double) result[3]; //Shift fuer para
	 }

	if(!r2.equals("H"))
	 {
	  result=formelSuchen(r2, benzshift_tabelle, 3); //Tabelle fuer 1H-NMR
	  if(result[0]!=null) warnstring += "..R2";
	  if(r3.equals("H"))  h1r3 += (double) result[1]; //Shift fuer orto
	  if(r1.equals("H"))  h1r1 += (double) result[1]; //Shift fuer orto
	  if(r4.equals("H"))  h1r4 += (double) result[2]; //Shift fuer meta
	  if(r6.equals("H"))  h1r6 += (double) result[2]; //Shift fuer meta
	  if(r5.equals("H"))  h1r5 += (double) result[3]; //Shift fuer para
	 }

	if(!r3.equals("H"))
	 {
	  result=formelSuchen(r3, benzshift_tabelle, 3); //Tabelle fuer 1H-NMR
	  if(result[0]!=null) warnstring += "..R3";
	  if(r4.equals("H"))  h1r4 += (double) result[1]; //Shift fuer orto
	  if(r2.equals("H"))  h1r2 += (double) result[1]; //Shift fuer orto
	  if(r5.equals("H"))  h1r5 += (double) result[2]; //Shift fuer meta
	  if(r1.equals("H"))  h1r1 += (double) result[2]; //Shift fuer meta
	  if(r6.equals("H"))  h1r6 += (double) result[3]; //Shift fuer para
	 }

	if(!r4.equals("H"))
	 {
	  result=formelSuchen(r4, benzshift_tabelle, 3); //Tabelle fuer 1H-NMR
	  if(result[0]!=null) warnstring += "..R4";
	  if(r5.equals("H"))  h1r5 += (double) result[1]; //Shift fuer orto
	  if(r3.equals("H"))  h1r3 += (double) result[1]; //Shift fuer orto
	  if(r6.equals("H"))  h1r6 += (double) result[2]; //Shift fuer meta
	  if(r2.equals("H"))  h1r2 += (double) result[2]; //Shift fuer meta
	  if(r1.equals("H"))  h1r1 += (double) result[3]; //Shift fuer para
	 }

	if(!r5.equals("H"))
	 {
	  result=formelSuchen(r5, benzshift_tabelle, 3); //Tabelle fuer 1H-NMR
	  if(result[0]!=null) warnstring += "..R5";
	  if(r6.equals("H"))  h1r6 += (double) result[1]; //Shift fuer orto
	  if(r4.equals("H"))  h1r4 += (double) result[1]; //Shift fuer orto
	  if(r1.equals("H"))  h1r1 += (double) result[2]; //Shift fuer meta
	  if(r3.equals("H"))  h1r3 += (double) result[2]; //Shift fuer meta
	  if(r2.equals("H"))  h1r2 += (double) result[3]; //Shift fuer para
	 }

	if(!r6.equals("H"))
	 {
	  result=formelSuchen(r6, benzshift_tabelle, 3); //Tabelle fuer 1H-NMR
	  if(result[0]!=null) warnstring += "..R6";
	  if(r1.equals("H"))  h1r1 += (double) result[1]; //Shift fuer orto
	  if(r5.equals("H"))  h1r5 += (double) result[1]; //Shift fuer orto
	  if(r2.equals("H"))  h1r2 += (double) result[2]; //Shift fuer meta
	  if(r4.equals("H"))  h1r4 += (double) result[2]; //Shift fuer meta
	  if(r3.equals("H"))  h1r3 += (double) result[3]; //Shift fuer para
	 }

	//Resultate anzeigen:
        startActivity(new Intent(this, ResultatActivity.class));

    }

    private boolean istleer(String st) {return (st==null || st.length()==0);}

    static String addwarning(String gesucht,String gefunden) {
        return gesucht+" not found, best match: "+gefunden+"\n";
    }

final static Object[] benzshift_tabelle =
  {"H",        0.00,  0.00,  0.00,
   //aus Flemming S.138:
   "NO2",      0.94,  0.18,  0.39,
   "CHO",      0.58,  0.20,  0.26,
   "COOH",     0.80,  0.16,  0.25,
   "COOCH3",   0.71,  0.08,  0.20,
   "COCl",     0.82,  0.21,  0.35,
   "CCl3",     0.80,  0.20,  0.20,
   "COCH3",    0.62,  0.10,  0.25,
   "CN",       0.26,  0.18,  0.30,
   "CONH2",    0.65,  0.20,  0.22,
   "NH3",      0.40,  0.20,  0.20,
   "CH2X",     0.05,  0.05,  0.05,
   "CH3",     -0.16, -0.09, -0.17,
   "CH2CH3",  -0.15, -0.06, -0.18,
   "CH(CH3)2",-0.14, -0.09, -0.18,
   "C(CH3)3", -0.09,  0.05, -0.23,
   "F",       -0.30, -0.02, -0.23,
   "Cl",       0.01, -0.06, -0.08,
   "Br",       0.19, -0.12, -0.05,
   "J",        0.39, -0.25, -0.02,
   "I",        0.39, -0.25, -0.02,
   "NH2",     -0.76, -0.25, -0.63,
   "OCH3",    -0.46, -0.10, -0.41,
   "OH",      -0.49, -0.13, -0.20,
   "OCOR",    -0.20,  0.10, -0.20,
   "NHCH3",   -0.80, -0.30, -0.60,
   "N(CH3)2", -0.60, -0.10, -0.62,
   //aus Friebolin S.144:
   "C6H5",     0.18,  0.0,   0.08,
   //aus eigenen Messungen:
   "N=N",      0.63,  0.23,  0.20,
   "NN",       0.63,  0.23,  0.20,
   "NHCOCH3",  0.37, -0.07,  0.0,
   "NHAc",     0.37, -0.07,  0.0,
   "SO3",      0.61,  0.04,  0.0, //aus H2N-C6H4-SO3Bu4N
   "SO3Test",  0.88,  0.62,  0.64, //aus H2N-C6H4-SO3H und H2N-C6H3(SO3H)-NH2
   "SO3H",    -0.2,   0.0,  -0.52, //   +H3N-C6H4-SO3H u. +H3N-C6H3(SO3H)-NH2
   //aus Spektrendatenbank:
   "NO",       0.64,  0.39,  0.31,
   "N\\equivN", 0.22,  0.14,  0.11,
   "NequivN",   0.22,  0.14,  0.11,
   null, 0, 0, 0
  };

static int vergleich(String s1,String s2)
{
 int diff,i,imax;
 //Test auf Gleichheit:
 if(s1.equals(s2)) return 0; //Strings sind gleich
 //Test auf Aehnlichkeit:
 imax=s1.length();
 if(s2.length()<imax) imax=s2.length();
 if(imax>10) imax=10; //nur erste 10 Zeichen testen
 diff=1024; //2^10 fuer 10 Zeichen
 for(i=0; i<imax && s1.charAt(i)==s2.charAt(i); i++)
     diff/=2;
 return diff;
}

public static Object[] formelSuchen(String str,Object[] tabelle,int n)
{
 int i,j,diff=100000,min=100000,minj=0;
 Object[] resultat=new Object[n+1];
 for(j=0;min!=0 && tabelle[j]!=null;j+=n+1)
  {
   diff=vergleich(str,(String)tabelle[j]);
   if(diff<min) {min=diff; minj=j;}
  }
    /*
    int test=j/(n+1);//test
    Log.d("Tabelle","j="+j+" n="+n+" Anzahl Eintraege="+test); //test
    if(test<5 && min!=0) {
        Log.e("FalscheTabelle","j="+j+"n="+n);
        for(i=0;i<test;i+=n+1)
            Log.e("i"+i+": ",tabelle[i].toString());
    }
    else if(min!=0) //test
    {
        Log.d("Tabelle","nichtgefunden: "+str);
        for(i=0;(String)tabelle[i]!=null;i+=n+1)
            Log.d(" i="+i+": ",tabelle[i].toString());
        Log.d("Tabelle","j="+j+" i="+i);
    }
    */
 if(diff==0) resultat[0]=null;
 else resultat[0]=tabelle[minj];
 for(i=1;i<n+1;i++) resultat[i]=tabelle[minj+i];
 return resultat;
}

final static Object[] benzshift13c_tabelle =
  {"H",  0.0,  0.0,  0.0,  0.0,
   //aus Friebolin S.153:
   "CH3",     9.2,   0.7, -0.1, -3.1,
   "CH2CH3", 15.6,  -0.5,  0.0, -2.7,
   "F",      34.8, -13.0,  1.6, -4.4,
   "Cl",      6.3,   0.4,  1.4, -1.9,
   "Br",     -5.8,   3.2,  1.6, -1.6,
   "I",     -34.1,   8.9,  1.6, -1.1,
   "J",     -34.1,   8.9,  1.6, -1.1,
   "OH",     26.9, -12.8,  1.4, -7.4,
   "OCH3",   31.4, -14.4,  1.0, -7.7,
   "OCOCH3", 22.4,  -7.1,  0.4, -3.2,
   "NH2",    18.2, -13.4,  0.8, -10.0,
   "N(CH3)2",22.5, -15.4,  0.9, -11.5,
   "C6H5",   13.1,  -1.1,  0.4, -1.1,
   "CHO",     8.4,   1.2,  0.5,  5.7,
   "COCH3",   8.9,   0.1, -0.1,  4.4,
   "COOCH3",  2.0,   1.2, -0.1,  4.3,
   "NO2",    19.9,  -4.9,  0.9,  6.1,
   //aus Encyclopedia of Spectr. S162:
   "NH3+",    0.1,  -5.8,  2.2,  2.2,
   "NHCOCH3", 9.7,   -8.1,  0.2, -4.4,
   "NHAc",    9.7,   -8.1,  0.2, -4.4,
   "SO3H",    15.0,  -2.2,  1.3,  3.8,
   //aus Vergleichsspektren:
   "N=N",    24.2,   -5.7, 0.54, -2.4, //aus azobenzene-Spektrum
   "CH2OH",  12.4,  -1.55, -0.1, -1.1, //aus benzyl alcohol
// "NHCOCH3", 9.7,   -8.1,  0.3, -4.3, //acetanilide
// "NHAc",    9.7,   -8.1,  0.3, -4.3, //acetanilide
   "NHCOCH2I",11.5,  -8.6,  1.1, -4.0, //iodoacetanilide
   "NHCOCH2J",11.5,  -8.6,  1.1, -4.0, //iodoacetanilide
// "NHCOCH2I",15.2,  -9.8,  0.3, -4.3, //Linker-13C
   "CH2Br",   14.0,   1.8,  1.0, -1.8, //aus 4-Nitro-Benzylbromid
   "CH2I",    11.0,   0.1,  0.0, -0.8, //aus C6H5-CH2-I Lit.Spektrum
   "CH2J",    11.0,   0.1,  0.0, -0.8, //aus C6H5-CH2-I Lit.Spektrum
   "SO3Bu4N", 19.1,  -1.9, -1.6,  0.5, //aus H2N-C6H4-SO3Bu4N
   "SO3-",    14.2,  -2.2,  7.1,  0.45, //aus H2N-C6H4-SO3H
   //aus Spektrendatenbank:
   "NO",      37.4,  -7.64,  0.81, 7.07, //nitrosobenzene
   "COOtBu",  3.61,   0.91, -0.37, 3.86, //tert-butyl benzoate
   "N\\equivN", -13.6, 3.0, 0.60, -0.3,
   "NequivN",   -13.6, 3.0, 0.60, -0.3,
   null, 0, 0, 0, 0
  };

}
