package ch.rolfp.nmrprecalc;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.Spinner;

public class MainActivity extends Activity implements View.OnClickListener, AdapterView.OnItemSelectedListener {

 //TextView textOutput,textOutput2;
    private static String solvent="CDCl3";
    private static int solventNr=0;
    private static Spinner spinner;
    private static String[] solventList;

    public static String getSolvent() {
        return solvent;
    }

    public static int getSolventNr() {
        return solventNr;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Button button=(Button)findViewById(R.id.button);
        button.setOnClickListener(this);
        ImageButton button2=(ImageButton)findViewById(R.id.button2);
        button2.setOnClickListener(this);
        ImageButton button3=(ImageButton)findViewById(R.id.button3);
        button3.setOnClickListener(this);
        spinner = (Spinner)findViewById(R.id.spinner);
        ArrayAdapter adapter=ArrayAdapter.createFromResource(this, R.array.solvents, android.R.layout.simple_spinner_item);
        spinner.setAdapter(adapter);
        spinner.setOnItemSelectedListener(this);
        solventList = getResources().getStringArray(R.array.solvents);
    }

    public static void setSolventNr(int nr) {
        solventNr = nr;
        solvent=solventList[nr];
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.button:
                startActivity(new Intent(this,BenzolActivity.class));
                break;
            case R.id.button2:
                startActivity(new Intent(this,AlkenActivity.class));
                break;
            case R.id.button3:
                startActivity(new Intent(this,MethanActivity.class));
                break;
            default:
                break;
        }
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        //TextView mytext = (TextView) view;
        //solvent = mytext.getText().toString();
        setSolventNr(position);
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {
    }

    @Override
    protected void onResume() {
        super.onResume();

        /*
        int i,imax=2; //provisorisch
        //for(i=0;i<2;i++) {irgendwie Werte aus array.xml lesen??}
        if(solvent.equals("CDCl3")) i=0;
        else if(solvent.equals("DMSO")) i=1;
        else i=imax;
        if(i<imax) spinner.setSelection(i);
        */

        spinner.setSelection(solventNr);
        //Log.d("Testpunkt", "2");
    }

}
