package ch.rolfp.nmrprecalc;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;

/**
 * Created by rpfister on 27.11.15.
 */
public class MethanActivity extends Activity implements View.OnClickListener, AdapterView.OnItemSelectedListener {

    public static String r1,r2,r3,warnstring,debugstring=null;
    public static double wert13c;
    public static double wert1h;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_methan);
        Button button = (Button) findViewById(R.id.button6);
        button.setOnClickListener(this);
        Spinner spinner = (Spinner)findViewById(R.id.spinner4);
        ArrayAdapter adapter=ArrayAdapter.createFromResource(this,R.array.solvents,android.R.layout.simple_spinner_item);
        spinner.setAdapter(adapter);
        spinner.setSelection(MainActivity.getSolventNr()); //auf aktuellen Wert setzen
        spinner.setOnItemSelectedListener(this);
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        TextView mytext = (TextView) view;
        MainActivity.setSolventNr(position);
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {
    }


    @Override
    public void onClick(View v) {
        EditText editText;
        editText = (EditText) findViewById(R.id.editText9);
        r1 = editText.getText().toString(); if(istleer(r1)) r1="H";
        editText = (EditText) findViewById(R.id.editText10);
        r2 = editText.getText().toString(); if(istleer(r2)) r2="H";
        editText = (EditText) findViewById(R.id.editText11);
        r3 = editText.getText().toString(); if(istleer(r3)) r3="H";

        //hier die Berechnung machen
	    Object[] result;
	    warnstring="";
        double startwert13c,startwert1h;
        int anzahlh=1;
        if(r1.equals("H")) anzahlh++;
        if(r2.equals("H")) anzahlh++;
        if(r3.equals("H")) anzahlh++;
        switch(MainActivity.getSolventNr()) {
            case 1: //CDCl3 (exp)
                if(anzahlh>1) {startwert13c = -8.8d; startwert1h = 0.24d;} //geschaetzt
                else          {startwert13c = -16.2d; startwert1h = 0.43d;} //geschaetzt
                break;
            case 2: //DMSO-D6
                startwert13c = -7.6d; startwert1h = 0.7d; //geschaetzt
                break;
            case 3: //Acetone-D6
                startwert13c = -7.5d; startwert1h = 0.57d; //geschaetzt
                break;
            case 4: //D2O
                startwert13c = -2.3d; startwert1h = 0.23d; //geschaetzt
                break;
            default: //CDCl3 (default)
                startwert13c = -2.3d; startwert1h = 0.23d; //aus Buechern (Friebolin, Fleming)
                break;
        }
        wert13c = startwert13c; //Wert fuer Methan?
        wert1h = startwert1h; //Wert fuer Methan?
        debugstring = "startwert13c="+startwert13c+" startwert1h="+startwert1h; //test

	result=BenzolActivity.formelSuchen(r1, shoolery13c_tabelle, 4);
	if(result[0]!=null) warnstring += addwarning(r1,(String)result[0]);
	wert13c += (double)result[1];
	result=BenzolActivity.formelSuchen(r2, shoolery13c_tabelle, 4);
	if(result[0]!=null) warnstring += addwarning(r2,(String)result[0]);
	wert13c += (double)result[1];
	result=BenzolActivity.formelSuchen(r3, shoolery13c_tabelle, 4);
	if(result[0]!=null) warnstring += addwarning(r3,(String)result[0]);
	wert13c += (double)result[1];

	result=BenzolActivity.formelSuchen(r1, shoolery_tabelle, 1);
	if(result[0]!=null) warnstring += addwarning2(r1,(String)result[0]);
	wert1h += (double)result[1];
	result=BenzolActivity.formelSuchen(r2, shoolery_tabelle, 1);
	if(result[0]!=null) warnstring += addwarning2(r2,(String)result[0]);
	wert1h += (double)result[1];
	result=BenzolActivity.formelSuchen(r3, shoolery_tabelle, 1);
	if(result[0]!=null) warnstring += addwarning2(r3,(String)result[0]);
	wert1h += (double)result[1];

	//Resultate anzeigen:
        startActivity(new Intent(this, ResultatActivityMethan.class));

    }

    private boolean istleer(String st) {return (st==null || st.length()==0);}
    private boolean istleer(char[] ch) {return (ch==null || ch[0]==0);}

    static String addwarning(String gesucht,String gefunden)
{
 return gesucht+" not found, best match: "+gefunden+"\n";
}

static String addwarning2(String gesucht,String gefunden)
{
 return gesucht+" -> "+gefunden+"\n";
}

final static Object[] shoolery_tabelle =
  {"H",        0.0,
   //aus Flemming S.89 (2 Nachkommastellen aus Friebolin):
   "R",        0.5,
   "CF3",      1.14,
   "CRCR2",    1.32, "CH=CH2",      1.32, "CR=CR2",      1.32,
   "CCR",      1.4, "C==C-R",   1.4, //C==C steht fuer 3-fach-Bindung
   "COO",      1.5, "COOR",     1.5,
   "NR2",      1.57,
   "NH2",      1.6,
   "CONR2",    1.6, "CO-NR2",    1.6,
   "SR",       1.64,
   "CC-C6H5",  1.7, "C==C-C6H5",  1.7,
   "CN",       1.7,
   "COR",      1.7,
   "J",        1.82, "I",        1.82,
   "Br",       2.33,
   "Cl",       2.53,
   "C6H5",     1.83,
   "OH",       2.56,
   "OR",       2.36,
   "NCS",      2.9, "N=C=S",    2.9,
   "OCOR",     3.13, "O-CO-R",   3.13,
   "O-C6H5",   3.23,
   //aus Friebolin S.142:
   "CH3",      0.47,
   "CCH",      1.44,
   "CONH2",    1.59,
   //aus Internet:
   "N3",       1.97,
   "SH",       1.64,
   "OSO2R",    3.13,
   //aus eigenen Messungen:
   "NHCO",      2.2,
   "NHAc",      2.2,
   "C6H4NH",    1.8,
   "C6H4NO",    2.0,
   "C6H4NN",    2.0,
   null, 0.0
  };

final static Object[] shoolery13c_tabelle =
  {"H",  0.0,  0.0,  0.0,  0.0,
   //aus Friebolin S.150:
   "D",      -0.4, -0.12, -0.02, 0.0,
   "CH3",     9.1,   9.4, -2.5,  0.3,  "R",     9.1,   9.4, -2.5,  0.3,
   "CH=CH2", 22.3,   6.9, -2.2,  0.2,
   "CCH",     4.5,   5.5, -3.5,  0.0, //C<Dreifachbindung>CH
   "C6H5",   22.3,   8.6, -2.3,  0.2,
   "CHO",    31.9,   0.7, -2.3,  0.0,
   "COCH3",  30.9,   2.3, -0.9,  2.7,
   "COOH",   20.8,   2.7, -2.3,  1.0,
   "CN",      3.6,   2.0, -3.1, -0.5,
   "NH2",    28.6,  11.5, -4.9,  0.3,
   "NO2",    64.5,   3.1, -4.7, -1.0,
   "OH",     48.3,  10.2, -5.8,  0.3,
   "OH-sek", 44.5,   9.7, -3.3,  0.2,
   "OH-tert",39.7,   7.3, -1.8,  0.3,
   "OCH3",   58.0,   8.1, -4.7,  1.4,
   "OR",     58.0,   8.1, -4.7,  1.4,
   "OCOCH3", 51.1,   7.1, -4.8,  1.1,
   "SH",     11.1,  11.8, -2.9,  0.7,
   "F",      70.1,   7.8, -6.8,  0.0,
   "Cl",     31.2,  10.5, -4.6,  0.1,
   "Br",     20.0,  10.6, -3.1,  0.1,
   "I",      -6.0,  11.3, -1.0,  0.2,
   "J",      -6.0,  11.3, -1.0,  0.2,
   //Erweiterung mit Vergleichssubstanzen:
   "C6H4NO2", 12.2,   8.6, -2.3,  0.2, //O2N-C6H4-CH2Br
   null, 0.0, 0.0, 0.0, 0.0
  };

}
