package ch.rolfp.nmrprecalc;

import android.app.Activity;
import android.os.Bundle;
import android.widget.TextView;

import java.text.DecimalFormat;

/**
 * Created by rpfister on 25.11.15.
 */
public class ResultatActivity extends Activity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_resultat);
        String str;
        DecimalFormat f = new DecimalFormat("#0.00");

        str = "Solvent: "+MainActivity.getSolvent()+"\n";
        str += "R1: "+ BenzolActivity.r1+" \t ";
        str += "R2: "+BenzolActivity.r2+" \t ";
        str += "R3: "+BenzolActivity.r3+"\n";
        str += "R4: "+BenzolActivity.r4+" \t ";
        str += "R5: "+BenzolActivity.r5+" \t ";
        str += "R6: "+BenzolActivity.r6+"\n\n";

        str += "C1: "+f.format(BenzolActivity.c13r1)+"\n";
        str += "C2: "+f.format(BenzolActivity.c13r2)+"\n";
        str += "C3: "+f.format(BenzolActivity.c13r3)+"\n";
        str += "C4: "+f.format(BenzolActivity.c13r4)+"\n";
        if(!BenzolActivity.r2.equals(BenzolActivity.r6) || !BenzolActivity.r3.equals(BenzolActivity.r5)) {
            str += "C5: " + f.format(BenzolActivity.c13r5) + "\n";
            str += "C6: " + f.format(BenzolActivity.c13r6) + "\n";
        }

        if(BenzolActivity.r1.equals("H")) str += "H1: "+f.format(BenzolActivity.h1r1)+"\n";
        if(BenzolActivity.r2.equals("H")) str += "H2: "+f.format(BenzolActivity.h1r2)+"\n";
        if(BenzolActivity.r3.equals("H")) str += "H3: "+f.format(BenzolActivity.h1r3)+"\n";
        if(BenzolActivity.r4.equals("H")) str += "H4: "+f.format(BenzolActivity.h1r4)+"\n";
        if(!BenzolActivity.r2.equals(BenzolActivity.r6) || !BenzolActivity.r3.equals(BenzolActivity.r5)) {
            if (BenzolActivity.r5.equals("H")) str += "H5: " + f.format(BenzolActivity.h1r5) + "\n";
            if (BenzolActivity.r6.equals("H")) str += "H6: " + f.format(BenzolActivity.h1r6) + "\n";
        }
        String w=BenzolActivity.warnstring;
        if(w!=null && !w.equals("")) {
            str += "\nWarnings: " + w;
        }

        TextView textOutput = (TextView) findViewById(R.id.textView12);
        textOutput.setText(str);
    }
}
