/* nmrschift.cc		letzte Aenderungen: 21.7.2014 18.5.2015 */
#define VERSION "Version 0.3"
/*

 Berechnung von NMR-Spektren von Substituirten Benzolen und Alkanen
 z.B:
         R3
      __/
     /  \
 R1--    --R2
     \__/

History:
20.10.2005	Erstellung (RP)
15.12.05  0.1	Erweiterung um Shoolery-Regel
2.11.07   0.2   Anpassung fuer 13C-NMR
22.10.08  0.3   Erweitert fuer 3-fach substituiertes Benzol
27-30.10.08     SO3H justiert
31.10.08        Neuer Name "nmrschift" (alter Name war "phenylen")
21.7.14         Neue Gruppen: N3, SH, OSO2R
18.5.15         Neue Gruppe: N\equivN (Dreifachbindung, Diazonium)

*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
//#include <xtekplot1.h>
#include <ulong.h>
//#include <math3.h>

//#define XMAX 640
//#define YMAX 512
//#define TIEFE 8

/************************* Globale Variablen **************************/

/************************* Vordeklarationen ***************************/
void c13interaktiv(int,char*,char*,char*);

/*************************** kleinkram ***************************/
double abs(double x) {return x>0.0?x:-x;}
double sq(double x) {return x*x;}

/***************************** Klassen ********************************/
class benzshift
{
public:
 char formel[80];
 double orto,meta,para;
};

static benzshift tabelle[] =
  {{"H",        0.00,  0.00,  0.00},
   //aus Flemming S.138:
   {"NO2",      0.94,  0.18,  0.39},
   {"CHO",      0.58,  0.20,  0.26},
   {"COOH",     0.80,  0.16,  0.25},
   {"COOCH3",   0.71,  0.08,  0.20},
   {"COCl",     0.82,  0.21,  0.35},
   {"CCl3",     0.80,  0.20,  0.20},
   {"COCH3",    0.62,  0.10,  0.25},
   {"CN",       0.26,  0.18,  0.30},
   {"CONH2",    0.65,  0.20,  0.22},
   {"NH3",      0.40,  0.20,  0.20},
   {"CH2X",     0.05,  0.05,  0.05},
   {"CH3",     -0.16, -0.09, -0.17},
   {"CH2CH3",  -0.15, -0.06, -0.18},
   {"CH(CH3)2",-0.14, -0.09, -0.18},
   {"C(CH3)3", -0.09,  0.05, -0.23},
   {"F",       -0.30, -0.02, -0.23},
   {"Cl",       0.01, -0.06, -0.08},
   {"Br",       0.19, -0.12, -0.05},
   {"J",        0.39, -0.25, -0.02},
   {"I",        0.39, -0.25, -0.02},
   {"NH2",     -0.76, -0.25, -0.63},
   {"OCH3",    -0.46, -0.10, -0.41},
   {"OH",      -0.49, -0.13, -0.20},
   {"OCOR",    -0.20,  0.10, -0.20},
   {"NHCH3",   -0.80, -0.30, -0.60},
   {"N(CH3)2", -0.60, -0.10, -0.62},
   //aus Friebolin S.144:
   {"C6H5",     0.18,  0.0,   0.08},
   //aus eigenen Messungen:
   {"N=N",      0.63,  0.23,  0.20},
   {"NN",       0.63,  0.23,  0.20},
   {"NHCOCH3",  0.37, -0.07,  0.0},
   {"NHAc",     0.37, -0.07,  0.0},
   {"SO3",      0.61,  0.04,  0.0}, //aus H2N-C6H4-SO3Bu4N
   {"SO3Test",  0.88,  0.62,  0.64}, //aus H2N-C6H4-SO3H und H2N-C6H3(SO3H)-NH2
   {"SO3H",    -0.2,   0.0,  -0.52}, //   +H3N-C6H4-SO3H u. +H3N-C6H3(SO3H)-NH2
   //aus Spektrendatenbank:
   {"NO",       0.64,  0.39,  0.31},
   {"N\\equivN", 0.22,  0.14,  0.11},
   {"NequivN",   0.22,  0.14,  0.11},
   {"", 0, 0, 0}
  };

class shoolshift
{
public:
 char formel[80];
 double x;
};

static shoolshift tabelle2[] =
  {{"H",        0.0},
   //aus Flemming S.89 (2 Nachkommastellen aus Friebolin):
   {"R",        0.5},
   {"CF3",      1.14},
   {"CRCR2",    1.32}, {"CH=CH2",      1.32}, {"CR=CR2",      1.32},
   {"CCR",      1.4}, {"C==C-R",   1.4}, //C==C steht fuer 3-fach-Bindung
   {"COO",      1.5}, {"COOR",     1.5},
   {"NR2",      1.57},
   {"NH2",      1.6},
   {"CONR2",    1.6}, {"CO-NR2",    1.6},
   {"SR",       1.64},
   {"CC-C6H5",  1.7}, {"C==C-C6H5",  1.7},
   {"CN",       1.7},
   {"COR",      1.7},
   {"J",        1.82}, {"I",        1.82},
   {"Br",       2.33},
   {"Cl",       2.53},
   {"C6H5",     1.83},
   {"OH",       2.56},
   {"OR",       2.36},
   {"NCS",      2.9}, {"N=C=S",    2.9},
   {"OCOR",     3.13}, {"O-CO-R",   3.13},
   {"O-C6H5",   3.23},
   //aus Friebolin S.142:
   {"CH3",      0.47},
   {"CCH",      1.44},
   {"CONH2",    1.59},
   //aus Internet:
   {"N3",       1.97},
   {"SH",       1.64},
   {"OSO2R",    3.13},
   //aus eigenen Messungen:
   {"NHCO",      2.2},
   {"NHAc",      2.2},
   {"C6H4NH",    1.8},
   {"C6H4NO",    2.0},
   {"C6H4NN",    2.0},
   {"", 0}
  };

int vergleich(const char *s1,const char *s2)
{
 int diff=1024,i;
 for(i=0;i<10 && *s1 == *s2;i++,s1++,s2++,diff/=2)
   {if(*s1==0) return 0;
   }
 return diff;
}

/************************* Hauptprogramm ******************************/
#define MAXARG 3
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

int main(int argc,char *argv[])
{
 //int breite,hoehe,tiefe,visklasse;
 //tek_setdebug(1);//test
 char R1[80],R2[80],R3[80],zeile[80],name[80];
 //FILE *fp;
 int i,j,c;
 R1[0]=R2[0]=R3[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else  if(++j==1) strcpy(R1,argv[i]);
	 else  if(j==2) strcpy(R2,argv[i]);
	 else  if(j==3) strcpy(R3,argv[i]);
	}
 if(j>MAXARG || argflag['?'] || argflag['H'])
	{printf("nmrschift  %s\n",VERSION);
	 printf("Anwendung: nmrschift R1 R2      fuer R1-C6H4-R2\n");
	 printf("     oder: nmrschift R1 R2 R3   fuer Shoolery-Regel von CH-Gruppe\n");
	 printf("     oder: nmrschift -b R1 R2 R3  fuer R1-C6H3(R3)-R2\n");
	 printf("     oder: nmrschift -c R1 R2 R3  fuer 13-C-NMR von subst. Benzol\n");
	 printf("     oder: nmrschift -ca R1 R2 R3 fuer 13-C-NMR von Alkanen\n");
	 printf("     oder: nmrschift -c           fuer 13-C-NMR mit interaktiver Eingabe\n");
	 exit(0);
	}
 if(argflag['C'])
        {c13interaktiv(j,R1,R2,R3);
	 exit(0);
	}
 double posa,posb,posc,posd;
 int v1,v2,v3,min1=1000,min2=1000,min3=1000,min1i=0,min2i=0,min3i=0;
 if(j<3 || argflag['B']) {
 if(j==3) printf("Berechnung der NMR-Shifts von R1-C6H3(R3)-R2\n");
 else
   {printf("Berechnung der NMR-Shifts von R1-C6H4-R2\n");
    if(R1[0]==0) {printf("R1:"); scanf("%s",R1);}
    else printf(" R1: %s\n",R1);
    if(R2[0]==0) {printf("R2:"); scanf("%s",R2);}
    else printf(" R2: %s\n",R2);
   }
 for(i=0;tabelle[i].formel[0]!=0;i++)
   {v1=vergleich(R1,tabelle[i].formel);
    if(v1<min1) {min1=v1; min1i=i;}
    v2=vergleich(R2,tabelle[i].formel);
    if(v2<min2) {min2=v2; min2i=i;}
    if(j==3)
      {v3=vergleich(R3,tabelle[i].formel);
       if(v3<min3) {min3=v3; min3i=i;}
      }
   }
 if(min1>0) printf("aehnlichstes R1: %s\n",tabelle[min1i].formel);
 if(min2>0) printf("aehnlichstes R2: %s\n",tabelle[min2i].formel);
 if(j==3 && min3>0) printf("aehnlichstes R3: %s\n",tabelle[min3i].formel);
 if(j<3)
 {printf("Orto: (R1 A B C D R2)\n");
  //   A HC-CH B
  //     /  \
  // R1-C    CH C
  //     \  /
  //   R2-C-CH D
  posa=7.27+tabelle[min1i].orto+tabelle[min2i].meta;
  posb=7.27+tabelle[min1i].meta+tabelle[min2i].para;
  posc=7.27+tabelle[min1i].para+tabelle[min2i].meta;
  posd=7.27+tabelle[min1i].meta+tabelle[min2i].orto;
  printf(" A: %.2lf  B: %.2lf  C: %.2lf  D: %.2lf\n",posa,posb,posc,posd);
  printf("Meta: (R1 A B C R2 D)\n");
  //   A HC-CH B
  //     /  \
  // R1-C    CH C
  //     \  /
  //   D HC-C-R2
  posa=7.27+tabelle[min1i].orto+tabelle[min2i].para;
  posb=7.27+tabelle[min1i].meta+tabelle[min2i].meta;
  posc=7.27+tabelle[min1i].para+tabelle[min2i].orto;
  posd=7.27+tabelle[min1i].orto+tabelle[min2i].orto;
  printf(" A: %.2lf  B: %.2lf  C: %.2lf  D: %.2lf\n",posa,posb,posc,posd);
  printf("Para: (R1 A B R2 B A)\n");
  posa=7.27+tabelle[min1i].orto+tabelle[min2i].meta;
  posb=7.27+tabelle[min2i].orto+tabelle[min1i].meta;
  printf(" A: %.2lf  B: %.2lf\n",posa,posb);
 }
 else //if(j<3) else
    {printf("                 %s\n",tabelle[min3i].formel);
     printf("                /\n");
     printf("            C--<\n");
          printf("%9s--<    >--%s\n",tabelle[min1i].formel,tabelle[min2i].formel);
     printf("            A--B\n");
     posa=7.27+tabelle[min1i].orto+tabelle[min2i].meta+tabelle[min3i].para;
     posb=7.27+tabelle[min1i].meta+tabelle[min2i].orto+tabelle[min3i].meta;
     posc=7.27+tabelle[min1i].orto+tabelle[min2i].meta+tabelle[min3i].orto;
     printf(" A: %.2lf  B: %.2lf  C: %.2lf\n",posa,posb,posc);
    }

 } else { //if(argc<MAXARG) else

 int v3,min3=1000,min3i=0,ch2flag;
 ch2flag = (vergleich(R3,"H")==0);
 if(ch2flag)
  printf("\nBerechnung der NMR-Shifts von R1-CH2-R2 (nach Shoolery)\n");
 else
  printf("Berechnung der NMR-Shifts von R1-CH(R2)R3 (nach Shoolery)\n");
 min1=1000; min2=1000; min1i=0; min2i=0;
 for(i=0;tabelle2[i].formel[0]!=0;i++)
   {v1=vergleich(R1,tabelle2[i].formel);
    if(v1<min1) {min1=v1; min1i=i;}
    v2=vergleich(R2,tabelle2[i].formel);
    if(v2<min2) {min2=v2; min2i=i;}
    v3=vergleich(R3,tabelle2[i].formel);
    if(v3<min3) {min3=v3; min3i=i;}
   }
 if(min1>0) printf("aehnlichstes R1: %s\n",tabelle2[min1i].formel);
 else printf(" R1: %s\n",tabelle2[min1i].formel);
 if(min2>0) printf("aehnlichstes R2: %s\n",tabelle2[min2i].formel);
 else printf(" R2: %s\n",tabelle2[min2i].formel);
 if(ch2flag)
  {posa=0.23+tabelle2[min1i].x+tabelle2[min2i].x;
   printf(" CH2: %.2lf\n",posa);
  }
 else
  {if(min3>0) printf("aehnlichstes R3: %s\n",tabelle2[min3i].formel);
   else printf(" R3: %s\n",tabelle2[min3i].formel);
   posa=0.23+tabelle2[min1i].x+tabelle2[min2i].x+tabelle2[min3i].x;
   printf(" CH: %.2lf\n",posa);
  }

 } //endif
 
 return 0;
}/* ende von main */

/********************* Erweiterung fuer 13C-NMR ***********************/
class benzshift13c
{
public:
 char formel[80];
 double s1,orto,meta,para;
};

static benzshift13c tabelle13cbenzolderivate[] =
  {{"H",  0.0,  0.0,  0.0,  0.0},
   //aus Friebolin S.153:
   {"CH3",     9.2,   0.7, -0.1, -3.1},
   {"CH2CH3", 15.6,  -0.5,  0.0, -2.7},
   {"F",      34.8, -13.0,  1.6, -4.4},
   {"Cl",      6.3,   0.4,  1.4, -1.9},
   {"Br",     -5.8,   3.2,  1.6, -1.6},
   {"I",     -34.1,   8.9,  1.6, -1.1},
   {"J",     -34.1,   8.9,  1.6, -1.1},
   {"OH",     26.9, -12.8,  1.4, -7.4},
   {"OCH3",   31.4, -14.4,  1.0, -7.7},
   {"OCOCH3", 22.4,  -7.1,  0.4, -3.2},
   {"NH2",    18.2, -13.4,  0.8, -10.0},
   {"N(CH3)2",22.5, -15.4,  0.9, -11.5},
   {"C6H5",   13.1,  -1.1,  0.4, -1.1},
   {"CHO",     8.4,   1.2,  0.5,  5.7},
   {"COCH3",   8.9,   0.1, -0.1,  4.4},
   {"COOCH3",  2.0,   1.2, -0.1,  4.3},
   {"NO2",    19.9,  -4.9,  0.9,  6.1},
   //aus Encyclopedia of Spectr. S162:
   {"NH3+",    0.1,  -5.8,  2.2,  2.2},
   {"NHCOCH3", 9.7,   -8.1,  0.2, -4.4},
   {"NHAc",    9.7,   -8.1,  0.2, -4.4},
   {"SO3H",    15.0,  -2.2,  1.3,  3.8},
   //aus Vergleichsspektren:
   {"N=N",    24.2,   -5.7, 0.54, -2.4}, //aus azobenzene-Spektrum
   {"CH2OH",  12.4,  -1.55, -0.1, -1.1}, //aus benzyl alcohol
// {"NHCOCH3", 9.7,   -8.1,  0.3, -4.3}, //acetanilide
// {"NHAc",    9.7,   -8.1,  0.3, -4.3}, //acetanilide
   {"NHCOCH2I",11.5,  -8.6,  1.1, -4.0}, //iodoacetanilide
   {"NHCOCH2J",11.5,  -8.6,  1.1, -4.0}, //iodoacetanilide
// {"NHCOCH2I",15.2,  -9.8,  0.3, -4.3}, //Linker-13C
   {"CH2Br",   14.0,   1.8,  1.0, -1.8}, //aus 4-Nitro-Benzylbromid
   {"CH2I",    11.0,   0.1,  0.0, -0.8}, //aus C6H5-CH2-I Lit.Spektrum
   {"CH2J",    11.0,   0.1,  0.0, -0.8}, //aus C6H5-CH2-I Lit.Spektrum
   {"SO3Bu4N", 19.1,  -1.9, -1.6,  0.5}, //aus H2N-C6H4-SO3Bu4N
   {"SO3-",    14.2,  -2.2,  7.1,  0.45}, //aus H2N-C6H4-SO3H
   //aus Spektrendatenbank:
   {"NO",      37.4,  -7.64,  0.81, 7.07}, //nitrosobenzene
   {"COOtBu",  3.61,   0.91, -0.37, 3.86}, //tert-butyl benzoate
   {"N\\equivN", -13.6, 3.0, 0.60, -0.3},
   {"NequivN",   -13.6, 3.0, 0.60, -0.3},
   {"", 0, 0, 0, 0}
  };

class shoolshift13c
{
public:
 char formel[80];
 double sa,sb,sc,sd;
};

static shoolshift13c tabelle13calkane[] =
  {{"H",  0.0,  0.0,  0.0,  0.0},
   //aus Friebolin S.150:
   {"D",      -0.4, -0.12, -0.02, 0.0},
   {"CH3",     9.1,   9.4, -2.5,  0.3},
   {"CH=CH2", 22.3,   6.9, -2.2,  0.2},
   {"CCH",     4.5,   5.5, -3.5,  0.0}, //C<Dreifachbindung>CH
   {"C6H5",   22.3,   8.6, -2.3,  0.2},
   {"CHO",    31.9,   0.7, -2.3,  0.0},
   {"COCH3",  30.9,   2.3, -0.9,  2.7},
   {"COOH",   20.8,   2.7, -2.3,  1.0},
   {"CN",      3.6,   2.0, -3.1, -0.5},
   {"NH2",    28.6,  11.5, -4.9,  0.3},
   {"NO2",    64.5,   3.1, -4.7, -1.0},
   {"OH",     48.3,  10.2, -5.8,  0.3},
   {"OH-sek", 44.5,   9.7, -3.3,  0.2},
   {"OH-tert",39.7,   7.3, -1.8,  0.3},
   {"OCH3",   58.0,   8.1, -4.7,  1.4},
   {"OR",     58.0,   8.1, -4.7,  1.4},
   {"OCOCH3", 51.1,   7.1, -4.8,  1.1},
   {"SH",     11.1,  11.8, -2.9,  0.7},
   {"F",      70.1,   7.8, -6.8,  0.0},
   {"Cl",     31.2,  10.5, -4.6,  0.1},
   {"Br",     20.0,  10.6, -3.1,  0.1},
   {"I",      -6.0,  11.3, -1.0,  0.2},
   {"J",      -6.0,  11.3, -1.0,  0.2},
   //Erweiterung mit Vergleichssubstanzen:
   {"C6H4NO2", 12.2,   8.6, -2.3,  0.2}, //O2N-C6H4-CH2Br
   {"", 0, 0, 0, 0}
  };

int auswahlfrage(const char *t1,const char *t2)
{
 int n;
 printf("1=%s oder 2=%s ?",t1,t2); scanf("%d",&n);
 return n;
}

void c13interaktiv(int j,char *R1,char *R2,char *R3)
{
 int i,antwort1,antwort2;
 double posa,posb,posd,pose,posr1,posr2;
 int v1,v2,v3,min1=1000,min2=1000,min3=1000,min1i=0,min2i=0,min3i=0;
 //char R1[80],R2[80],R3[80];
 //R1[0]=R2[0]=R3[0]=0;
 if(argflag['A']) antwort1=2;
 else if(j>=2) antwort1=1;
 else antwort1=auswahlfrage("Benzolderivat","Alkane");
 if(antwort1==1)
   {benzshift13c *tabelle=tabelle13cbenzolderivate;
    if(j>=2) antwort2=j-1;
    else antwort2=auswahlfrage("R1R2","R1R2R3");
    if(antwort2==1)
    {printf("Berechnung der NMR-Shifts von R1-C6H4-R2\n");
     if(R1[0]==0) {printf("R1:"); scanf("%s",R1);}
     else printf(" R1: %s\n",R1);
     if(R2[0]==0) {printf("R2:"); scanf("%s",R2);}
     else printf(" R2: %s\n",R2);
     for(i=0;tabelle[i].formel[0]!=0;i++)
      {v1=vergleich(R1,tabelle[i].formel);
       if(v1<min1) {min1=v1; min1i=i;}
       v2=vergleich(R2,tabelle[i].formel);
       if(v2<min2) {min2=v2; min2i=i;}
      }
     if(min1>0) printf("aehnlichstes R1: %s\n",tabelle[min1i].formel);
     if(min2>0) printf("aehnlichstes R2: %s\n",tabelle[min2i].formel);
     printf("           A--B\n");
     printf("Para: R1-C<    >C-R2\n");
     printf("           A--B\n");
     posr1=128.5+tabelle[min1i].s1+tabelle[min2i].para;
     posa=128.5+tabelle[min1i].orto+tabelle[min2i].meta;
     posb=128.5+tabelle[min2i].orto+tabelle[min1i].meta;
     posr2=128.5+tabelle[min2i].s1+tabelle[min1i].para;
     printf(" R1-C: %.2lf  A: %.2lf  B: %.2lf  C-R2: %.2lf\n",
	    posr1,posa,posb,posr2);
    }
    else
    {printf("Berechnung der NMR-Shifts von R1-C6H3(R3)-R2\n");
     if(R1[0]==0) {printf("R1:"); scanf("%s",R1);}
     else printf(" R1: %s\n",R1);
     if(R2[0]==0) {printf("R2:"); scanf("%s",R2);}
     else printf(" R2: %s\n",R2);
     if(R3[0]==0) {printf("R3:"); scanf("%s",R3);}
     else printf(" R3: %s\n",R3);
     for(i=0;tabelle[i].formel[0]!=0;i++)
       {v1=vergleich(R1,tabelle[i].formel);
	if(v1<min1) {min1=v1; min1i=i;}
	v2=vergleich(R2,tabelle[i].formel);
	if(v2<min2) {min2=v2; min2i=i;}
	v3=vergleich(R3,tabelle[i].formel);
	if(v3<min3) {min3=v3; min3i=i;}
       }
     if(min1>0) printf("aehnlichstes R1: %s\n",tabelle[min1i].formel);
     if(min2>0) printf("aehnlichstes R2: %s\n",tabelle[min2i].formel);
     if(min3>0) printf("aehnlichstes R3: %s\n",tabelle[min3i].formel);
     printf("                R3\n");
     printf("               /\n");
     printf("           D--E\n");
     printf("     R1--C<    >C--R2\n");
     printf("           A--B\n");
     posr1=128.5+tabelle[min1i].s1+tabelle[min2i].para+tabelle[min3i].meta;
     posa=128.5+tabelle[min1i].orto+tabelle[min2i].meta+tabelle[min3i].para;
     posb=128.5+tabelle[min2i].orto+tabelle[min1i].meta+tabelle[min3i].meta;
     posr2=128.5+tabelle[min2i].s1+tabelle[min1i].para+tabelle[min3i].orto;
     posd=128.5+tabelle[min1i].orto+tabelle[min2i].meta+tabelle[min3i].orto;
     pose=128.5+tabelle[min1i].meta+tabelle[min2i].orto+tabelle[min3i].s1;
     printf(" R1-C: %.2lf  A: %.2lf  B: %.2lf  C-R2: %.2lf  D: %.2lf  E: %.2lf\n",
	    posr1,posa,posb,posr2,posd,pose);
    }
   }
 else //antwort1==2
   {shoolshift13c *tabelle;
    printf("Aus Tabelle von Friebolin S.150: S_alfa verwendet zur\n");//provi.
    printf("Berechnung der 13C-NMR-Shifts von R1-CH2-R2\n");
    tabelle=tabelle13calkane;
    if(R1[0]==0) {printf("R1:"); scanf("%s",R1);}
    else printf(" R1: %s\n",R1);
    if(R2[0]==0) {printf("R2:"); scanf("%s",R2);}
    else printf(" R2: %s\n",R2);
    for(i=0;tabelle[i].formel[0]!=0;i++)
      {v1=vergleich(R1,tabelle[i].formel);
       if(v1<min1) {min1=v1; min1i=i;}
       v2=vergleich(R2,tabelle[i].formel);
       if(v2<min2) {min2=v2; min2i=i;}
      }
    if(min1>0) printf("aehnlichstes R1: %s\n",tabelle[min1i].formel);
    if(min2>0) printf("aehnlichstes R2: %s\n",tabelle[min2i].formel);
    posa=0+tabelle[min1i].sa+tabelle[min2i].sa;//provi.
    printf(" CH2: %.2lf\n",posa);
   }
}
