package ch.rolfp.sonnenpos.orte

class Ort (val ort:String, var lat:Double, var lon:Double, val land:String?=null, var alt:Int=0)

var ortsliste:Array<Ort> = arrayOf(
Ort("Zuerich", 47.374, 8.541, null, 408),
Ort("Zürich", 47.374, 8.541, null, 408),
Ort("Pfaffhausen", 47.365, 8.622, null, 614),
Ort("Genf", 46.2018, 6.1466),
Ort("Berlin", 52.5235, 13.4115, "Deutschland", 34),
Ort("Hamburg", 53.55034, 10.00065, "Deutschland", 0),
Ort("Leon", 42.599, -5.56824),
Ort("Barcelona", 41.38258, 2.17707),
Ort("Palma", 39.5696, 2.6501, "Mallorca"),
Ort("LasPalmas", 28.1289, -15.4349),
Ort("GranCanaria", 28.1289, -15.4349),
Ort("SantaCruz", 28.46718, -16.25079),
Ort("Teneriffa", 28.46718, -16.25079),
Ort("Island", 64.98418, -18.1059),
Ort("Kapstadt", -33.92883, 18.41722),
Ort("Stanley", -51.69306, -57.85653),
Ort("Falkland", -51.70100, -57.84920, "Falklandinseln", 0),
//Liste aller Hauptstaedte:
Ort("Tirana", 41.33170, 19.81720, "Albanien", 104),
Ort("Andorra la Vella", 42.50750, 1.52180, "Andorra", 1409),
Ort("Minsk", 53.96780, 27.57660, "Weißrussland", 198),
Ort("Brüssel", 50.83710, 4.36760, "Belgien", 76),
Ort("Sarajevo", 43.86080, 18.42140, "Bosnien-Herzegowina", 577),
Ort("Sofia", 42.71050, 23.32380, "Bulgarien", 591),
Ort("Kopenhagen", 55.67630, 12.56810, "Dänemark", 0),
Ort("Berlin", 52.52350, 13.41150, "Deutschland", 34),
Ort("Tallinn", 59.43890, 24.75450, "Estland", 37),
Ort("Helsinki", 60.16990, 24.93840, "Finnland", 25),
Ort("Paris", 48.85670, 2.35100, "Frankreich", 34),
Ort("Athen", 37.97920, 23.71660, "Griechenland", 153),
Ort("London", 51.50020, -0.12620, "Großbritannien", 14),
Ort("Dublin", 53.34410, -6.26750, "Irland", 8),
Ort("Reykjavik", 64.13530, -21.89520, "Island", 15),
Ort("Rom", 41.89550, 12.48230, "Italien", 14),
Ort("Pristina", 42.67400, 21.17880, "Kosovo", 652),
Ort("Zagreb", 45.81500, 15.97850, "Kroatien", 130),
Ort("Riga", 56.94650, 24.10490, "Lettland", 8),
Ort("Vaduz", 47.14110, 9.52150, "Liechtenstein", 601),
Ort("Vilnius", 54.68960, 25.27990, "Litauen", 124),
Ort("Luxemburg", 49.61000, 6.12960, null, 273),
Ort("Valletta", 35.90420, 14.51890, "Malta", 0),
Ort("Chisinau", 47.01670, 28.84970, "Moldawien", 80),
Ort("Monaco", 43.73250, 7.41890, null, 0),
Ort("Podgorica", 42.46020, 19.25950, "Montenegro", 61),
Ort("Amsterdam", 52.37380, 4.89100, "Niederlande", -1),
Ort("Skopje", 42.00240, 21.43610, "Nordmazedonien", 243),
Ort("Oslo", 59.91380, 10.73870, "Norwegen", 12),
Ort("Wien", 48.20920, 16.37280, "Österreich", 170),
Ort("Warschau", 52.22970, 21.01220, "Polen", 93),
Ort("Lissabon", 38.70720, -9.13550, "Portugal", 15),
Ort("Bukarest", 44.44790, 26.09790, "Rumänien", 70),
Ort("Moskau", 55.75580, 37.61760, "Russland", 124),
Ort("San Marino", 43.94240, 12.45780, null, 328),
Ort("Stockholm", 59.33280, 18.06450, "Schweden", 15),
Ort("Bern", 46.94800, 7.44810, "Schweiz", 513),
Ort("Belgrad", 44.80480, 20.47810, "Serbien", 116),
Ort("Bratislava", 48.21160, 17.15470, "Slowakei", 131),
Ort("Ljubljana", 46.05140, 14.50600, "Slowenien", 281),
Ort("Madrid", 40.41670, -3.70330, "Spanien", 588),
Ort("Prag", 50.08780, 14.42050, "Tschechien", 244),
Ort("Kiew", 50.44220, 30.53670, "Ukraine", 168),
Ort("Budapest", 47.49840, 19.04080, "Ungarn", 102),
Ort("Torshavn", 62.01770, -6.77190, "Färöer (DK)", 0),
Ort("Gibraltar", 36.13770, -5.34530, "Gibraltar (UK)", 447),
Ort("Saint Peter Port", 49.46600, -2.55220, "Guernsey (UK)", 0),
Ort("Douglas", 54.16700, -4.48210, "Isle of Man (UK)", 34),
Ort("Saint Helier", 49.19190, -2.10710, "Jersey (UK)", 0),
Ort("Longyearbyen", 78.21860, 15.64880, "Svalbard (NO)", 199),
Ort("Kabul", 34.51550, 69.19520, "Afghanistan", 1807),
Ort("Eriwan", 40.15960, 44.50900, "Armenien", 1032),
Ort("Baku", 40.38340, 49.89320, "Aserbaidschan", 1),
Ort("Manama", 26.19210, 50.53540, "Bahrain", 6),
Ort("Dhaka", 23.71060, 90.39780, "Bangladesch", 3),
Ort("Thimphu", 27.44050, 89.67300, "Bhutan", 2736),
Ort("Bandar Seri Begawan", 4.94310, 114.94250, "Brunei", 0),
Ort("Peking", 39.90560, 116.39580, "China", 63),
Ort("Tiflis", 41.70100, 44.79300, "Georgien", 451),
Ort("Neu-Delhi", 28.63530, 77.22500, "Indien", 210),
Ort("Jakarta", -6.18620, 106.80630, "Indonesien", 3),
Ort("Bagdad", 33.31570, 44.39220, "Irak", 40),
Ort("Teheran", 35.70610, 51.43580, "Iran", 1138),
Ort("Jerusalem", 31.78570, 35.20070, "Israel", 580),
Ort("Tokio", 35.67850, 139.68230, "Japan", 17),
Ort("Sanaa", 15.35560, 44.20810, "Jemen", 2253),
Ort("Amman", 31.93940, 35.93490, "Jordanien", 759),
Ort("Phnom Penh", 11.54340, 104.89840, "Kambodscha", 15),
Ort("Astana", 51.17960, 71.44750, "Kasachstan", 338),
Ort("Doha", 25.29480, 51.50820, "Katar", 13),
Ort("Bischkek", 42.86790, 74.59840, "Kirgisistan", 771),
Ort("Kuwait", 29.37210, 47.98240, null, 5),
Ort("Vientiane", 17.96890, 102.61370, "Laos", 148),
Ort("Beirut", 33.88720, 35.51340, "Libanon", 55),
Ort("Kuala Lumpur", 3.15020, 101.70770, "Malaysia", 60),
Ort("Male", 4.17420, 73.51090, "Malediven", 0),
Ort("Ulan Bator", 47.91380, 106.92200, "Mongolei", 1284),
Ort("Naypyidaw", 19.75400, 96.13450, "Birma", 127),
Ort("Kathmandu", 27.70580, 85.31570, "Nepal", 1298),
Ort("Pjöngjang", 39.01870, 125.74680, "Nordkorea", 6),
Ort("Maskat", 23.60860, 58.59220, "Oman", 68),
Ort("Islamabad", 33.67510, 73.09460, "Pakistan", 507),
Ort("Manila", 14.57900, 120.97260, "Philippinen", 7),
Ort("Riad", 24.67480, 46.69770, "Saudi-Arabien", 624),
Ort("Singapur", 1.28940, 103.85000, null, 0),
Ort("Colombo", 6.91550, 79.85720, "Sri Lanka", 4),
Ort("Damaskus", 33.51580, 36.29390, "Syrien", 691),
Ort("Seoul", 37.51390, 126.98280, "Südkorea", 33),
Ort("Dushanbe", 38.57370, 68.77380, "Tadschikistan", 789),
Ort("Bangkok", 13.75730, 100.50200, "Thailand", 1),
Ort("Dili", -8.56620, 125.58800, "Osttimor", 11),
Ort("Ankara", 39.94390, 32.85600, "Türkei", 938),
Ort("Ashgabat", 37.95090, 58.37940, "Turkmenistan", 215),
Ort("Tashkent", 41.31930, 69.24810, "Usbekistan", 459),
Ort("Abu Dhabi", 24.47640, 54.37050, "Vereinigte Arabische Emirate", 13),
Ort("Hanoi", 21.03410, 105.83720, "Vietnam", 25),
Ort("Nikosia", 35.16760, 33.37360, "Zypern", 134),
Ort("Taipeh", 25.03380, 121.56450, "Taiwan (CN)", 5),
Ort("Saint John's", 17.11750, -61.84560, "Antigua und Barbuda", 0),
Ort("Buenos Aires", -34.61180, -58.41730, "Argentinien", 10),
Ort("Nassau", 25.06610, -77.33900, "Bahamas", 2),
Ort("Bridgetown", 13.09350, -59.61050, "Barbados", 6),
Ort("Belmopan", 17.25340, -88.77130, "Belize", 59),
Ort("Sucre", -19.04210, -65.25590, "Bolivien", 2783),
Ort("Brasilia", -15.78010, -47.92920, "Brasilien", 1079),
Ort("Santiago", -33.46910, -70.64200, "Chile", 521),
Ort("San Jose", 9.94020, -84.10020, "Costa Rica", 1146),
Ort("Roseau", 15.29760, -61.39000, "Dominica", 0),
Ort("Santo Domingo", 18.47900, -69.89080, "Dominikanische Republik", 0),
Ort("Quito", -0.22950, -78.52430, "Ecuador", 2763),
Ort("San Salvador", 13.70340, -89.20730, "El Salvador", 658),
Ort("Saint George's", 12.05400, -61.74860, "Grenada", 25),
Ort("Guatemala", 14.62480, -90.53280, null, 1529),
Ort("Georgetown", 6.80460, -58.15480, "Guyana", 0),
Ort("Port-au-Prince", 18.53920, -72.32880, "Haiti", 98),
Ort("Tegucigalpa", 14.08210, -87.20630, "Honduras", 980),
Ort("Kingston", 17.99270, -76.79200, "Jamaika", 53),
Ort("Ottawa", 45.42350, -75.69790, "Kanada", 74),
Ort("Bogota", 4.64730, -74.09620, "Kolumbien", 2619),
Ort("Havanna", 23.13330, -82.36670, "Kuba", 4),
Ort("Ciudad de Mexico", 19.42710, -99.12760, "Mexiko", 2216),
Ort("Managua", 12.14750, -86.27340, "Nicaragua", 75),
Ort("Panama", 8.99430, -79.51880, null, 0),
Ort("Asuncion", -25.30050, -57.63620, "Paraguay", 54),
Ort("Lima", -12.09310, -77.04650, "Peru", 107),
Ort("Basseterre", 17.29680, -62.71380, "St. Kitts und Nevis", 0),
Ort("Castries", 13.99720, -61.00180, "St. Lucia", 204),
Ort("Kingstown", 13.20350, -61.26530, "St. Vincent und die Grenadinen", 0),
Ort("Paramaribo", 5.82320, -55.16790, "Suriname", 1),
Ort("Port-of-Spain", 10.65960, -61.47890, "Trinidad und Tobago", 0),
Ort("Montevideo", -34.89410, -56.06750, "Uruguay", 43),
Ort("Caracas", 10.49610, -66.89830, "Venezuela", 909),
Ort("Washington", 38.89210, -77.02410, "Vereinigte Staaten", 2),
Ort("Charlotte Amalie", 18.34050, -64.93260, "Amerikanische Jungferninseln (US)", 0),
Ort("The Valley", 18.22490, -63.06690, "Anguilla (UK)", 0),
Ort("Oranjestad", 12.52460, -70.02650, "Aruba (NL)", 13),
Ort("Hamilton", 32.29300, -64.78200, "Bermuda (UK)", 0),
Ort("Road Town", 18.43280, -64.62350, "Britische Jungferninseln (UK)", 0),
Ort("George Town", 19.30220, -81.38570, "Caymaninseln (UK)", 3),
Ort("Stanley", -51.70100, -57.84920, "Falklandinseln (UK)", 0),
Ort("Cayenne", 4.93460, -52.33030, "Französisch-Guayana (FR)", 32),
Ort("Nuuk", 64.18360, -51.72140, "Grönland (DK)", 0),
Ort("Basse-Terre", 15.99850, -61.72200, "Guadeloupe (FR)", 0),
Ort("Fort-de-France", 14.59970, -61.07600, "Martinique (FR)", 0),
Ort("Plymouth", 16.68020, -62.20140, "Montserrat (UK)", 114),
Ort("Willemstad", 12.10340, -68.93350, "Niederländische Antillen (NL)", 0),
Ort("San Juan", 18.45000, -66.06670, "Puerto Rico (US)", 3),
Ort("Saint-Pierre", 46.78780, -56.19680, "St. Pierre und Miquelon (FR)", 0),
Ort("Cockburn Town", 21.46080, -71.13630, "Turks- und Caicosinseln (UK)", 0),
Ort("Kairo", 30.05710, 31.22720, "Ägypten", 22),
Ort("Algier", 36.77550, 3.05970, "Algerien", 0),
Ort("Luanda", -8.81590, 13.23060, "Angola", 6),
Ort("Malabo", 3.75230, 8.77410, "Äquatorialguinea", 107),
Ort("Addis Abeba", 9.00840, 38.75750, "Äthiopien", 2362),
Ort("Porto-Novo", 6.47790, 2.63230, "Benin", 38),
Ort("Gaborone", -24.65700, 25.90890, "Botswana", 1014),
Ort("Ouagadougou", 12.35690, -1.53520, "Burkina Faso", 305),
Ort("Bujumbura", -3.38180, 29.36220, "Burundi", 794),
Ort("Yamoussoukro", 6.80670, -5.27280, "Elfenbeinküste", 217),
Ort("Dschibuti", 11.58060, 43.14250, null, 0),
Ort("Asmara", 15.33150, 38.91830, "Eritrea", 2363),
Ort("Mbabane", -26.31860, 31.14100, "Eswatini", 1243),
Ort("Libreville", 0.38580, 9.44960, "Gabun", 0),
Ort("Banjul", 13.43990, -16.67750, "Gambia", 0),
Ort("Accra", 5.54010, -0.20740, "Ghana", 98),
Ort("Conakry", 9.53700, -13.67850, "Guinea", 0),
Ort("Bissau", 11.85980, -15.58750, "Guinea-Bissau", 0),
Ort("Jaunde", 3.86120, 11.52170, "Kamerun", 726),
Ort("Praia", 14.91950, -23.51530, "Kap Verde", 0),
Ort("Nairobi", -1.27620, 36.79650, "Kenia", 1728),
Ort("Moroni", -11.70040, 43.24120, "Komoren", 110),
Ort("Brazzaville", -4.27670, 15.26620, "Kongo", 155),
Ort("Kinshasa", -4.33690, 15.32710, "Kongo (Demokratische Republik)", 240),
Ort("Maseru", -29.29760, 27.48540, "Lesotho", 1673),
Ort("Monrovia", 6.31060, -10.80470, "Liberia", 0),
Ort("Tripolis", 32.88300, 13.18970, "Libyen", 6),
Ort("Antananarivo", -18.92010, 47.52370, "Madagaskar", 1288),
Ort("Lilongwe", -13.98990, 33.77030, "Malawi", 1024),
Ort("Bamako", 12.65300, -7.98640, "Mali", 349),
Ort("Rabat", 33.99050, -6.87040, "Marokko", 53),
Ort("Nouakchott", 18.06690, -15.99000, "Mauretanien", 6),
Ort("Port Louis", -20.16540, 57.48960, "Mauritius", 134),
Ort("Maputo", -25.96860, 32.58040, "Mosambik", 63),
Ort("Windhuk", -22.57490, 17.08050, "Namibia", 1721),
Ort("Niamey", 13.51640, 2.11570, "Niger", 207),
Ort("Abuja", 9.05800, 7.48910, "Nigeria", 777),
Ort("Kigali", -1.94410, 30.06190, "Ruanda", 1567),
Ort("Lusaka", -15.41450, 28.28090, "Sambia", 1270),
Ort("Sao Tome", 0.33600, 6.73110, "Sao Tome und Principe", 141),
Ort("Dakar", 14.69530, -17.44390, "Senegal", 37),
Ort("Victoria", -4.61670, 55.45000, "Seychellen", 0),
Ort("Freetown", 8.46970, -13.26590, "Sierra Leone", 76),
Ort("Harare", -17.82270, 31.04960, "Simbabwe", 1480),
Ort("Mogadischu", 2.04110, 45.34260, "Somalia", 28),
Ort("Khartoum", 15.55010, 32.53220, "Sudan (Nord)", 381),
Ort("Juba", 4.84960, 31.60460, "Sudan (Süd)", 466),
Ort("Pretoria", -25.74630, 28.18760, "Südafrika", 1271),
Ort("Dodoma", -6.16700, 35.74970, "Tansania", 1148),
Ort("Lome", 6.12280, 1.22550, "Togo", 63),
Ort("N'djamena", 12.11210, 15.03550, "Tschad", 298),
Ort("Tunis", 36.81170, 10.17610, "Tunesien", 0),
Ort("Kampala", 0.31330, 32.57140, "Uganda", 1202),
Ort("Bangui", 4.36210, 18.58730, "Zentralafrikanische Republik", 369),
Ort("Mamoudzou", -12.78060, 45.22780, "Mayotte (FR)", 0),
Ort("Saint Denis", -20.87320, 55.46030, "Reunion (FR)", 112),
Ort("Jamestown", -15.92440, -5.71810, "St. Helena (UK)", 292),
Ort("El Aaiun", 27.15360, -13.20330, "Westsahara (MA)", 72),
Ort("Canberra", -35.28200, 149.12860, "Australien", 605),
Ort("Suva", -18.14160, 178.44190, "Fidschi", 0),
Ort("Bairiki", 1.32820, 172.97840, "Kiribati", 0),
Ort("Dalap-Uliga-Darrit", 7.11670, 171.36670, "Marshallinseln", 0),
Ort("Palikir", 6.91770, 158.18540, "Mikronesien (Föderierte Staaten)", 207),
Ort("Yaren", -0.54340, 166.91960, "Nauru", 9),
Ort("Wellington", -41.28650, 174.77620, "Neuseeland", 20),
Ort("Melekeok", 7.50070, 134.62410, "Palau", 0),
Ort("Port Moresby", -9.46560, 147.19690, "Papua-Neuguinea", 39),
Ort("Honiara", -9.43330, 159.95000, "Salomonen", 29),
Ort("Apia", -13.83140, -171.75180, "Samoa", 0),
Ort("Nuku'alofa", -21.13600, -175.21640, "Tonga", 0),
Ort("Vaiaku", -8.52100, 179.19830, "Tuvalu", 0),
Ort("Port Vila", -17.74040, 168.32100, "Vanuatu", 0),
Ort("Pago Pago", -14.27930, -170.70090, "Amerikanisch-Samoa (US)", 49),
Ort("Avarua", -21.20390, -159.76580, "Cookinseln (NZ)", 208),
Ort("Papeete", -17.53500, -149.56960, "Französisch-Polynesien (FR)", 59),
Ort("Hagatna", 13.46670, 144.74700, "Guam (US)", 9),
Ort("West Island", -12.18690, 96.82830, "Kokosinseln (AU)", 0),
Ort("Noumea", -22.27580, 166.45810, "Neukaledonien (FR)", 0),
Ort("Alofi", -19.05650, -169.92370, "Niue (NZ)", 6),
Ort("Garapan", 15.20690, 145.71970, "Nördliche Marianen (US)", 132),
Ort("Kingston", -29.05450, 167.96660, "Norfolkinsel (AU)", 0),
Ort("Adamstown", -25.06620, -130.10270, "Pitcairninseln (UK)", 0),
Ort("Mata-Utu", -13.27840, -176.14300, "Wallis und Futuna (FR)", 0),
Ort("Flying Fish Cove", -10.42860, 105.68070, "Weihnachtsinsel (AU)", 0),
Ort("Montgomery", 32.37540, -86.29960, "Alabama", 75),
Ort("Juneau", 58.36370, -134.57210, "Alaska", 0),
Ort("Phoenix", 33.44830, -112.07380, "Arizona", 342),
Ort("Little Rock", 34.72440, -92.27890, "Arkansas", 91),
Ort("Sacramento", 38.57370, -121.48710, "California", 4),
Ort("Denver", 39.75510, -104.98810, "Colorado", 1613),
Ort("Hartford", 41.76650, -72.67320, "Connecticut", 13),
Ort("Dover", 39.16150, -75.51360, "Delaware", 5),
Ort("Tallahassee", 30.43820, -84.28060, "Florida", 53),
Ort("Atlanta", 33.75450, -84.38970, "Georgia", 304),
Ort("Honolulu", 21.29200, -157.82190, "Hawaii", 34),
Ort("Boise", 43.60210, -116.21250, "Idaho", 834),
Ort("Springfield", 39.80180, -89.65330, "Illinois", 182),
Ort("Indianapolis", 39.76700, -86.15630, "Indiana", 221),
Ort("Des Moines", 41.58880, -93.62030, "Iowa", 267),
Ort("Topeka", 39.04740, -95.68150, "Kansas", 273),
Ort("Frankfort", 38.18940, -84.87150, "Kentucky", 151),
Ort("Baton Rouge", 30.44930, -91.18820, "Louisiana", 14),
Ort("Augusta", 44.32940, -69.73230, "Maine", 20),
Ort("Annapolis", 38.96930, -76.51970, "Maryland", 0),
Ort("Boston", 42.35890, -71.05680, "Massachusetts", 2),
Ort("Lansing", 42.73360, -84.54660, "Michigan", 257),
Ort("Saint Paul", 44.94460, -93.10270, "Minnesota", 228),
Ort("Jackson", 32.31220, -90.17800, "Mississippi", 80),
Ort("Jefferson City", 38.56980, -92.19410, "Missouri", 181),
Ort("Helena", 46.59110, -112.02050, "Montana", 1262),
Ort("Lincoln", 40.81360, -96.70260, "Nebraska", 379),
Ort("Carson City", 39.15010, -119.75190, "Nevada", 1462),
Ort("Concord", 43.23140, -71.55970, "New Hampshire", 84),
Ort("Trenton", 40.22020, -74.76420, "New Jersey", 15),
Ort("Santa Fe", 35.68160, -105.93810, "New Mexico", 2152),
Ort("Albany", 42.65170, -73.75510, "New York", 20),
Ort("Raleigh", 35.77970, -78.64340, "North Carolina", 90),
Ort("Bismarck", 46.80840, -100.76940, "North Dakota", 516),
Ort("Columbus", 39.96220, -83.00070, "Ohio", 234),
Ort("Oklahoma City", 35.49310, -97.45910, "Oklahoma", 359),
Ort("Salem", 44.93700, -123.02720, "Oregon", 58),
Ort("Harrisburg", 40.27400, -76.88490, "Pennsylvania", 108),
Ort("Providence", 41.82700, -71.40870, "Rhode Island", 2),
Ort("Columbia", 34.00070, -81.03530, "South Carolina", 84),
Ort("Pierre", 44.37760, -100.31770, "South Dakota", 442),
Ort("Nashville", 36.15890, -86.78210, "Tennessee", 138),
Ort("Austin", 30.26870, -97.74520, "Texas", 140),
Ort("Salt Lake City", 40.77160, -111.88820, "Utah", 1308),
Ort("Montpelier", 44.26270, -72.57160, "Vermont", 182),
Ort("Richmond", 37.54080, -77.43390, "Virginia", 48),
Ort("Olympia", 47.04490, -122.90160, "Washington", 27),
Ort("Charleston", 38.35330, -81.63540, "West Virginia", 174),
Ort("Madison", 43.06320, -89.40070, "Wisconsin", 267),
Ort("Cheyenne", 41.13890, -104.81650, "Wyoming", 1856)
)

fun inListeSuchen(name:String):Ort? {
    var i:Int = 0
    while(i<ortsliste.size) {
        if(ortsliste[i].ort == name) return ortsliste[i]
        i++
    }
    var nameLow = name.lowercase().trimEnd()
    i=0
    while(i<ortsliste.size) {
        if(ortsliste[i].ort.lowercase() == nameLow) return ortsliste[i]
        if(ortsliste[i].land!=null) {
            val land:String? = ortsliste[i].land;
            if(land!=null) {
                if(land.lowercase() == nameLow) return ortsliste[i]
                if(land.indexOf(" (")>0) {
                    val array: List<String> = land.split('(')
                    if(!array[0].isEmpty() && array[0].trimEnd().lowercase()==nameLow) return ortsliste[i]
                }
            }
        }
        i++
    }
    nameLow = nameLow.replace(" ","") //alle Leerzeichen entfernt
    nameLow = nameLow.replace("-","") //alle Bindestriche entfernt
    var nmax:Int = nameLow.length
    if(nmax<1) return null
    i=0
    while(i<ortsliste.size) {
        var str:String = ortsliste[i].ort.lowercase().replace(" ","")
        str = str.replace("-","")//Leerzeichen und Bindestriche entfernen
        if(str.length > nmax) str = str.substring(0,nmax)
        if(str==nameLow) return ortsliste[i]
        val land:String? = ortsliste[i].land
        if(land!=null) {
            str = land.lowercase().replace(" ", "")
            str = str.replace("-", "")//Leerzeichen und Bindestriche entfernen
            if (str.length > nmax) str = str.substring(0, nmax)
            if (str == nameLow) return ortsliste[i]
        }
        i++
    }

    return null
}
