;-----------------------------------------------------------------------------
;* tast5x4.asm               letzte Aenderung: 14.8.2010
;* Version: 0.1
;* Autor: Rolf Pfister
;* Copyright: Freeware
;* Prozessor: ATtiny2313A, 4.194304MHz Quarz
;* Schaltschema: tastatur5x4.png
;*	 PortB: B0-B4 Matrix-Eingaenge
;*	        B5-B7 Matrix-Eingaenge Reserve
;*	 PortD:	D1 TxD Serielle Daten senden
;*		D0, D2-D6 Matrix-Ausgaenge
;* Tastatur von billigem Migros-Taschenrechner (4.90) verwendet.
;* Diese hat 5*4 Tasten, die Verdrahtung ist aber eine 5*6-Matrix.
;*
;* History:
;* 27.6.2010	Erstellung
;* 9.8.2010	Variante mit UART
;*
; Globale Registerbelegung:
; r8: Sicherung von Status im Timer-Interrupt
; r9: Zaehlung Viertels-Millisek
; r10-r15: Millisek bis Tage
;-----------------------------------------------------------------------------
.include "tn2313Adef.inc" 	; Definitionsdatei fuer den Prozessortyp
.equ SRAMSTART=0x60	;beim ATtiny2313A

;.define DEBUGGING
;.define TESTCODE
;.define FREQTEST
;.define TIMERTEST
;.define VARIANTE1
.define UARTVARIANTE

;-----------------------------------------------------------------------------
; Reset und Interruptvectoren	;VNr. Beschreibung
begin:	rjmp	main		; 0   Power On Reset
	reti			; 1   Int0-Interrupt
	reti			; 2   Int1-Interrupt
	reti			; 3   TC1 Capture
	reti			; 4   TC1 Compare Match A
	reti			; 5   TC1 Overflow
	rjmp tc0over		; 6   TC0 Overflow
	reti			; 7   UART Rx Complete
	reti			; 8   UART Data Register Empty
	reti			; 9   UART Tx Complete
	reti			; 10  Analog Comperator
	reti			; 11  Pin Change B
	reti			; 12  OC1B
	reti			; 13  OC0A
	reti			; 14  OC0B
	reti			; 15  USI Start Condition
	reti			; 16  USI Overflow
	reti			; 17  ERDY
	reti			; 18  Watchdog Timer Overflow
	reti			; 19  Pin Change A
	reti			; 20  Pin Change D

;-----------------------------------------------------------------------------
; Variablen im SRAM:
;.equ maske=SRAMSTART		;Maske mit 1 Bit auf 0 fuer Matrix-Ausgabe
;.equ taste=SRAMSTART+1		;zuletzt gelesene Taste

.ifdef UARTVARIANTE
;-----------------------------------------------------------------------------
;; UART Routinen
.equ F_CPU = 4194304	; Systemtakt in Hz
.equ BAUD  = 8192	; Baudrate

; Berechnungen
.equ UBRR_VAL   = ((F_CPU+BAUD*8)/(BAUD*16)-1)  ; clever runden
.equ BAUD_REAL  = (F_CPU/(16*(UBRR_VAL+1)))     ; Reale Baudrate
.equ BAUD_ERROR = ((BAUD_REAL*1000)/BAUD-1000)  ; Fehler in Promille
 
.if ((BAUD_ERROR>10) || (BAUD_ERROR<-10))       ; max. +/-10 Promille Fehler
  .error "Systematischer Fehler der Baudrate groesser 1 Prozent und damit zu hoch!"
.endif

uart_init:
	ldi r16, UBRR_VAL>>8
	out UBRRH, r16
	ldi r16, UBRR_VAL&0xFF
	out UBRRL, r16
;	ldi r16, (1<<RXEN)|(1<<TXEN)
	ldi r16, (1<<TXEN)
	out UCSRB, r16
;	ldi r16, (1<<USBS)|(3<<UCSZ0) ;8N2 ATtiny2313A
;	ldi r16, (1<<URSEL)|(3<<UCSZ0) ;8N1 Atmega8
	ldi r16, (3<<UCSZ0) ;8N1 ATtiny2313A
	out UCSRC, r16
	ret

uart_putc:			; zu sendendes Zeichen in r16
	sbis UCSRA, UDRE
	rjmp uart_putc
	out UDR, r16
	ret

;uart_getc:			; Resultat in r16
;	sbis UCSRA, RXC		
;	rjmp uart_getc
;	in r16, UDR
;	ret

.endif
	
;-----------------------------------------------------------------------------
; Start, Power On, Reset
main:	ldi r16, RAMEND
        out SPL, r16  	     ; Init Stackpointer L

;; Init-Code
	ldi r16, 0xFF		;Alle 8 Leitungen auf Ausgang
        out DDRD, r16		;Data Direction Register D setzen
	ldi r16, 0xFF
	out PORTD, r16		;alle auf High
	ldi r16, 0x00		;Alle 8 Leitungen auf Eingang
        out DDRB, r16		;Data Direction Register B setzen
	ldi r16, 0xFF		;Pullup fuer Eingangspins
	out PORTB, r16		;Pullup-Widerstaende an

.ifdef FREQTEST
t1:	inc r16
	out PORTD, r16		;Schlaufe braucht 4 Takte, ganze Periode also 8
	rjmp t1			;An PD0 gemessene Frequenz*8 = Systemtakt
.endif

	ldi r17, (1<<TOIE0)
	out TIMSK, r17		;Timer/Counter0 Overflow einschalten
	ldi r17, 0		;Normal-Modus
	out TCCR0A, r17
	ldi r17, 2		;1=nicht teilen, 2=durch 8, 3=64, 4=256, 5=1024
	out TCCR0B, r17		;Vorteiler setzen
;Bei 4194304Hz: Schrittweite 1.907 usec
;Fuer einen Interrupt alle etwa 250usec:
	.equ ZAEHLER=256-131
	ldi r17, ZAEHLER
	out TCNT0, r17

	clr r9			; Viertels-Millisec
	clr r10
	clr r11			; r11r10 = Millisec
	clr r12			; Sekunden
	clr r13			; Minuten
	clr r14			; Stunden
	clr r15			; Tage, auf 0 setzen
	sei			;Interrupt erlauben

.ifdef TIMERTEST
T1:	sbi PORTD, 0
	ldi r16, 1
	rcall milliwait1
	cbi PORTD, 0
	ldi r16, 1
	rcall milliwait1	;sollte 500Hz geben
	rjmp T1
.endif
.ifdef VARIANTE1
	rcall lcd_init		;provi.
	ldi r16, 'A'		;test
	rcall lcd_write
	ldi r16, 'B'
	rcall lcd_write
	ldi r16, 'C'
	rcall lcd_write		;test
.endif

.ifdef UARTVARIANTE
	rcall uart_init
.endif
	
;-----------------------------------------------------------------------------
mainloop:
	rcall tastencheck
	tst r16			;wurde eine Taste gedrueckt?
	breq mainloop		;nein-->
	dec r16
	ldi ZL, low(tasten<<1)
	ldi ZH, high(tasten<<1)
	clr r17
	add ZL, r16
	adc ZH, r17
	lpm r16, Z+
.ifdef UARTVARIANTE
	rcall uart_putc
.else
	rcall lcd_write
.endif
mloop2:	rcall tastencheck
	tst r16
	brne mloop2		;warten bis Taste wieder losgelassen
	rjmp mainloop

;; Zuordnung der 5*6-Matrix zu den Tasten:
tasten:	.db '2',':','c','9','d','5','3','*','+','-' ;Kleinbuchstaben sind
	.db 'a','6','0','=','e','7','g','R','1','N' ;bisher nicht verwendete
	.db 'M','8','C','4','o','p','q','r','s','.' ;Matrix-Punkte.

tastencheck:			;wenn Taste gedrueckt r16=Tastennummer
	push r17
	push r18
	push r19
	clr r18			;Spaltenzaehler=0
	ldi r19, 0xFE		;Maske mit erstem Bit auf 0
L1:	out PORTD, r19
	ldi r16, 1
	rcall milliwait1
	in r16, PINB
	andi r16, 0x1F
	cpi r16, 0x1F
	brne t2
t1:	sec
	rol r19			;naechstes PDx auf 0 setzen
	cpi r19, 0xFD		;PD1 ueberspringen
	breq t1
	inc r18			;Spaltenzaehler++
	cpi r19, 0xFF		;fertig?
	brne L1			;nein-->
t0:	clr r16			;keine Taste gedrueckt
	rjmp t9
t2:	ldi r17, 6		;Tastendruck erkannt
L2:	add r18, r17		;fuer jede Reihe Spaltenzahl addieren
	lsr r16
	brcs L2
	sub r18, r17		;eins zuviel addiertes wieder subtrahieren
	inc r18			;Zahl im Bereich von 1 bis 4*6+1
	ldi r16, 10
	rcall milliwait1	;Pause zur Tastenentprellung
	mov r16, r18
t9:	pop r19
	pop r18
	pop r17
	ret

;-----------------------------------------------------------------------------
; Interrupt-Routine, sollte alle 0.25 msec kommen
; Registerbelegungen:
; r9: Viertels-Millisekunden
; r11:r10 Millisekunden, r12 Sekunden, r13 Minuten, r14 Stunden, r15 Tage
tc0over:push r16
	in r8, SREG	;Statusregister sichern
	ldi r16, ZAEHLER
	out TCNT0, r16
	inc r9
	ldi r16, 4
	cp r9, r16
	breq tc1
tc0reti:
	out SREG, r8
	pop r16
	reti
tc1:	clr r9
	sei
millisek:
	push r17
	ldi r16, 0xE8
	ldi r17, 0x03	;r17:r16 = 1000 = 0x03E8
	inc r10		;Millisekunden erhoehen
	brne mL1
	inc r11
mL1:	cp r10, r16
	cpc r11, r17
	brne end1	;fertig wenn msec!=1000
	clr r10
	clr r11		;Millisekunden auf 0 setzen
	inc r12		;Sekunden erhoehen
	ldi r16, 60
	cp r12, r16
	brne end1	;fertig wenn sec!=60
	clr r12		;Sekunden auf 0 setzen
	inc r13		;Minuten erhoehen
	cp r13, r16
	brne end1	;fertig wenn min!=60
	clr r13		;Minuten auf 0 setzen
	inc r14		;Stunden erhoehen
	ldi r16, 24
	cp r14, r16
	brne end1	;fertig wenn std!=24
	clr r14		;Stunden auf 0 setzen
	inc r15		;Tage erhoehen
end1:
	pop r17
	rjmp tc0reti

;-----------------------------------------------------------------------------
milliwait1:			;Wartezeit: r16, 1 bis 255 msec
	push r16
	push r17
	clr r17
	rjmp miL1
milliwait255:
	ldi r16, 255
milliwait:			;Wartezeit: r17:r16 msec, min 1 max 1000
	push r16
	push r17
miL1:	push r18
	push r19
	mov r18, r10
loop1:	cp  r18, r10
	breq loop1		;1. Millisekunde abwarten (0 bis 1 ms)
	mov r18, r17		; Oberstes Bit von r17 nach r18 kopieren
	andi r17, 0x7F		; und in r17 loeschen.
	add r16, r10
	adc r17, r11		;sollzeit = Wartezeit + aktuelle Millisek
	subi r16, low(1001)
	sbci r17, high(1001)	;sollzeit -= 1; sollzeit -= 1000;
	brpl loop2		;wenn sollzeit>=0 -->
	subi r16, low(-1000)	;sonst haben wir 1000 zuviel subtrahiert
	sbci r17, high(-1000)	;also wieder 1000 addieren (soll -= -1000)
loop2:	mov r19, r10
	subi r19, -8
	cp r16, r10
	cpc r17, r11		;auf sollzeit warten
	cpc r16, r10		;falls zwischen 1. u 2. cp ein Interrupt war
	brne loop2
pop19ret: pop r19
pop18ret: pop r18
pop17ret: pop r17
	  pop r16
	  ret

.ifdef VARIANTE1
;provisorisch zum Testen mit LCD-Anzeige:
;-----------------------------------------------------------------------------
; LCD-Ansteuerung ueber nur 1 Datenleitung
.equ LCDPORT=PORTD
.equ LCDPIN=1
.ifdef RUECKSIGNAL
.equ LCDDDR=DDRD
.equ LCDPINB=PIND
.endif

lcd_init:		;LCD initialisieren
	push r16
	push r17
	push r18
	sbi LCDPORT, LCDPIN
	ldi r16, low(500)
	ldi r17, high(500)	;sicherstellen dass LCD-Modul gebootet hat
	rcall milliwait
	ldi r16, 0x11
	rcall lcd_go
	ldi r18, 20
lcd_i1:	ldi r16, ' '		;Anzeige loeschen
	rcall lcd_write
	dec r18
	brne lcd_i1
	ldi r16, 0x21		;zweite Zeile
	rcall lcd_go
	ldi r18, 20
lcd_i2:	ldi r16, ' '		;Anzeige loeschen
	rcall lcd_write
	dec r18
	brne lcd_i2
	ldi r16, 0x11
	rcall lcd_go
	pop r18
	pop r17
	pop r16
	ret
	
lcd_ziffer:		; r16 als Ziffer auf LCD anzeigen (0 <= r16 <= 15)
	ori r16, 0x30
	cpi r16, 0x3A	; Hex-Ziffer (r16>9) ?
	brcs lcd_write	; nein-->
	subi r16, -7	; fuer Hex-Ziffern z.B. 3A --> 41=='A'

lcd_write:		; r16 = Zeichen auf LCD senden, r16 zerstoert
	push r17
	ldi r17, 0
	rjmp lcd_se
lcd_cmd:push r17	; r16 = Kommando an LCD senden, r16 zerstoert
	ldi r17, 1
lcd_se:	push r18
	push r19
	mov r18, r16
	mov r19, r17
	cbi LCDPORT, LCDPIN	; Start-Bit
	rcall lcd_wait2
	rcall lcd_wait1		; 3 Einheit langer Startpuls
	sbi LCDPORT, LCDPIN	; Ende des Start-Bits
	ldi r17, 9		; 9 Bits senden
w_L1:	rcall lcd_wait1		; 1Einheit auf High
	cbi LCDPORT, LCDPIN
	andi r19, 1
	breq bit0
bit1:	rcall lcd_wait1		; kurzer Puls kodiert eine 1
	rjmp w_L2
bit0:	rcall lcd_wait2		; langer Puls kodiert eine 0
w_L2:	sbi LCDPORT, LCDPIN	; Ende des Bits
	rol r18
	rol r19
	dec r17
	brne w_L1
.ifdef RUECKSIGNAL
	cbi LCDDDR, LCDPIN	;Pin als Eingang
	sbi LCDPORT, LCDPIN	;Pullup-Widerstand
	ldi r18, 100
w_L3:	rcall lcd_wait1
	dec r18
	breq w_L5		;Abbruch wenn keine Rueckmeldung kommt
	in r16, LCDPINB
	andi r16, (1<<LCDPIN)
	brne w_L3
w_L4:	in r16, LCDPINB
	andi r16, (1<<LCDPIN)
	breq w_L4
w_L5:	sbi LCDDDR, LCDPIN	;Pin als Ausgang
.else
	ldi r16, 2
	rcall milliwait1	; warten bis LCD wieder bereit
.endif
	pop r19
	pop r18
	pop r17
	ret

lcd_go:	push r17
;	sts lcdpos, r16
	mov r17, r16
	swap r16
	rcall lcd_goto
	pop r17
	ret
lcd_goto:		;lcd_goto(r16=row,r17=col)
	dec r16		;row--
	andi r16, 0x01	;row &= 0x01; //nur Zeile 0 oder Zeile 1 zulassen
	swap r16
 	add r16, r16		
 	add r16, r16	;row <<= 6; //Zeile nach Bit 6 bringen
	dec r17		;col--;
	andi r17, 0x0F	;col &= 0x0F; //nur Bereich 0 bis 15 zulassen
	or r16, r17	;char tmp=row|col; //Adresse bilden
	ori r16, 0x80	;tmp |= 0x80; //Cursor setzen
	rcall lcd_cmd	;lcd_cmd(tmp);
	ret

lcd_wait2:	;Warteschlaufe fuer lange Pulse
	rcall lcd_wait1
lcd_wait1:	;Warteschlaufe fuer kurze Pulse
.ifdef SCHNELL
;	push r17
;	ldi r17, 1
;w0:	ldi r16, 255
	ldi r16, 80
w1:	dec r16		;Schlaufe braucht 3 Takte
	brne w1		;70*3/6.4MHz = 32usec
;	dec r17		;255*3/6.4MHz = 120usec , 7*120usec = 0.84msec
;	brne w0
;	pop r17
.else
	ldi r16, 1
	rcall milliwait1
.endif
	ret
;-----------------------------------------------------------------------------
.endif
