/* glcd.cc       letzte Aenderung: 15.8.2010
 Version: 0.05
Ansteuern von Grafik-LCD, zum includen
 Prozessor: Atmega32
 Anschluss Grafik-LCD: PA0...PA7, PC2-PC7

 Autor: Rolf Pfister
 Copyright: Freeware
 History:
 6.8.2010	Erstellung, erster Teil von bahn.cc uebernommen
		Font vom Internet kopiert.
 15.8.10	Anpassung an Schaltungsaenderung

*/

/* im Hauptprogramm machen:
#include <avr/io.h>
#include <avr/interrupt.h>
#include "ulong.h"
#include "stdio.h"

void glcd_init();
void glcd_test();

#include "glcd.cc"
*/
/**** Grafik-LCD-Ansteuerung ****/
/*  Grafik-LCD: AV128641
	D/I   PC2 (H=Data, L=Instruction)
	R/W   PC3 (H=Read, L=Write)
	E     PC4 (Enable, H-aktiv)
	Daten PA0...PA7
	CS1   PC5 (L=Select1)
	CS2   PC6 (L=Select2)
	RST   PC7 (L=Reset)
*/
const int DI=2, RW=3, EN=4, CS1=5, CS2=6, RST=7;

void glcd_wait(char cs)
{
 char a;
 DDRA=0; //Port A auf Eingang
 PORTC &= ~(1<<DI); //Instruction
 PORTC |= (1<<RW); //Read
 do
  {PORTC &= ~(1<<cs); //Select CS1 oder CS2
   PORTC |= (1<<EN); //sbi(PORTC,4); Enable
   microwait(1);
   a=PINA;
   PORTC &= ~(1<<EN); //cbi(PORTC,4);
   PORTC |= (1<<cs); //Select ausschalten
/*
   if(a&0xB0) //test
    {lcd_goto(1,1);
     if(a&0x80) lcd_write("Busy");//test
     if(a&0x20) lcd_write(" Off");//test
     else lcd_write(" On");//test
     if(a&0x10) lcd_write(" Res");//test
    }
*/
  }
 while((a & 0x80)!=0);
}

static char glcd_cs=CS1;

void glcd_command(char a,char cs)
{
 glcd_cs=cs;
 PORTC &= ~(1<<DI); //Instruction
 PORTC &= ~(1<<RW); //Write
 DDRA=0xFF; //Port A auf Ausgang
 PORTA=a;
 PORTC &= ~(1<<cs); //Select CS1 oder CS2
 microwait(1);
 PORTC |= (1<<EN); //sbi(PORTC,4); Enable
 microwait(1);
 PORTC &= ~(1<<EN); //cbi(PORTC,4);
 PORTC |= (1<<cs); //Select1 aus
 glcd_wait(cs);
}

void glcd_data(char a)
{
 char cs=glcd_cs;
 PORTC |= (1<<DI); //Data
 PORTC &= ~(1<<RW); //Write
 DDRA=0xFF; //Port A auf Ausgang
 PORTA=a;
 PORTC &= ~(1<<cs); //Select1
 microwait(1);
 PORTC |= (1<<EN); //sbi(PORTC,4); Enable
 microwait(1);
 PORTC &= ~(1<<EN); //cbi(PORTC,4);
 PORTC |= (1<<cs); //Select1 aus
 glcd_wait(cs);
}

unsigned char glcd_readdata()
{
 unsigned char a;
 char cs=glcd_cs,i;
 PORTC |= (1<<DI); //Data
 PORTC |= (1<<RW); //Read
 DDRA=0x00; //Port A auf Eingang
 PORTC &= ~(1<<cs); //Select1
 microwait(1);
 PORTC |= (1<<EN); //sbi(PORTC,4); Enable
 microwait(1);
 a=PINA;
 PORTC &= ~(1<<EN); //cbi(PORTC,4);
 PORTC |= (1<<cs); //Select1 aus
 glcd_wait(cs);
 return a;
}

void glcd_clear(char farbe)
{
 char i,x,cs;
 if(farbe!=0) farbe=0xFF;
 farbe=0x0F;//test
 for(cs=CS1;cs<=CS2;cs+=CS2-CS1)
  {glcd_command(0x40,cs); //y-Start
   for(x=0;x<8;x++)
    {glcd_command(0xB8+x,cs); //x-Start
     for(i=0;i<64;i++) glcd_data(farbe);
    }
  }
}

void glcd_init()
{
 DDRA=0; //Port A auf Eingang
 //DDRC=0xFC; //Port C2-C7 auf Ausgang, C0-C1 Eingaenge
 //PORTC=0xE3; //RST,CS1,CS2 auf H; E,R/W,D/I auf L; (3=Pullup-Widerstaende)
 DDRC=0xFF; //Port C alles Ausgaenge
 cli();
 PORTC=(PORTC&3)+0xE0; //RST,CS1,CS2 auf H; E,R/W,D/I auf L
 sei();
 PORTC &= ~(1<<RST); //cbi(PORTC,7); Reset ausfuehren
 microwait(10);
 PORTC |= (1<<RST); //sbi(PORTC,7);
 glcd_wait(CS1);
 glcd_wait(CS2);
 glcd_command(0x3F,CS1); //Display ON
 glcd_command(0x3F,CS2); //Display ON
 glcd_clear(0);
}

void glcd_punkt(char x,char y,char farbe)
{
 char cs;
 unsigned char a,maske;
 y=63-y; //if(y>63) y=63; else if(y<0) y=0;
 maske = 1<<(y&7);
 y >>= 3;
 if(x>=64) {cs=CS1; x-=64;}
 else cs=CS2;
 glcd_command(0x40+x,cs); //y-Start
 glcd_command(0xB8+y,cs); //x-Start
 glcd_readdata();//dummy-read
 a=glcd_readdata();
 if(farbe==0) a &= ~maske; //Pixel loeschen
 else if(farbe==1) a |= maske; //Pixel setzen
 else a ^= maske; //bei farbe==2 Pixel umkehren
 glcd_command(0x40+x,cs); //y-Start
 glcd_data(a);
}

void glcd_portein()
{
 tasten_aktiv=0; //wegen Doppelbelegungen Tastendruckerkennung abschalten
 //DDRC=0xFC; //Port C2-C7 auf Ausgang, C0-C1 Eingaenge
 //PORTC=0xE3; //RST,CS1,CS2 auf H; E,R/W,D/I auf L; (3=Pullup-Widerstaende)
 DDRC=0xFF; //Port C alles Ausgaenge
 //PORTC=(PORTC&3)+0xE0; //RST,CS1,CS2 auf H; E,R/W,D/I auf L; C0C1 unveraendert
 PORTC |= (1<<RST);
 PORTC |= (1<<CS1);
 PORTC |= (1<<CS2);
 PORTC &= ~(1<<EN);
 PORTC &= ~(1<<RW);
 PORTC &= ~(1<<DI);
}
void glcd_portaus()
{
 //DDRC=0xF8; //Port C3-C7 auf Ausgang, C0-C2 Eingaenge fuer Taster
 //PORTC=0xE7; //RST,CS1,CS2 auf H; E,R/W auf L; (7=Pullup-Widerstaende)
 DDRC=0xE3; //Port C2-C4 Eingaenge fuer Taster
 //PORTC=(PORTC&3)+0xE0; //RST,CS1,CS2 auf H; E,R/W auf L
 //PORTC |= 0x1C; //Pullup-Widerstaende C2-C4
 PORTC |= (1<<RST);
 PORTC |= (1<<CS1);
 PORTC |= (1<<CS2);
 PORTC |= 0x10; //Pullup-Widerstand
 PORTC |= 0x08; //Pullup-Widerstand
 PORTC |= 0x04; //Pullup-Widerstand
 tasten_aktiv=1;//Tastenerkennung wieder einschalten
}

void glcd_test(char farbe)
{
 unsigned char x,y;
 glcd_portein();
 /*
 glcd_command(0x40+20,CS1); //y-Start
 glcd_command(0xB8+2,CS1); //x-Start
 glcd_data(0xF0);
 glcd_data(0xF0);
 glcd_data(0x0F);
 glcd_data(0xF0);
 glcd_data(0x0F);
 glcd_data(0xAA);
 glcd_data(0xAA);
 glcd_data(0x55);
 glcd_data(0x55);
 glcd_command(0xC0,CS1); //Display-Data
 */
 /*
 for(x=0;x<8;x++)
  {glcd_command(0xB8+x,CS2); //x-Start
   glcd_command(0x40,CS2); //y-Start
   for(y=0;y<64;y++)
    {glcd_data(y);
    }
  }
 */
 for(x=0;x<128;x++)
  {if(x<64) y=x; else y=127-x;
   glcd_punkt(x,y,farbe);
  }
 //glcd_command(0xC0,CS1); //Display-Data
 //glcd_command(0xC0,CS2); //Display-Data
 glcd_portaus();
}

const int fontbreite=6, fonthoehe=8;
#include "6x8_vertikal_LSB_1a.h"
/* const char font[128][6]={
...
{0x00,0x00,0x42,0x7F,0x40,0x00},	// 0x31
...
};
*/

static int glcd_x0=0, glcd_y0=0;

void glcd_goto(int row,int col)
{
 //const int x8=(fontbreite+7)/8*8; //auf durch 8 teilbare Zahl aufgerundet
 const int x8=fontbreite; //Variante ohne Rundung
 glcd_x0=(col*x8) & 127; //Breite auf 128 beschraenkt
 glcd_y0=(row*fonthoehe) & 63; //Hoehe auf 64 beschraenkt
}

void glcd_write(char c)
{
 char cs,i;
 int ypage,x;
 glcd_portein();
 ypage=glcd_y0/8;
 //y=glcd_x0&0x07; //untere 3 Bits
 c &= 0x7F;
 if(glcd_x0<64) {cs=CS2; x=glcd_x0&0x3F;}
 else {cs=CS1;  x=(glcd_x0-64)&0x3F;}
 glcd_command(0xB8+ypage,cs); //x-Start (senkrecht auf Display)
 glcd_command(0x40+x,cs); //y-Start (waagrecht auf Display)

 /* Variante mit Aufrundung: * /
 for(i=0;i<fontbreite;i++)
    {glcd_data(font[c][i]);
    }
 for(;i<8;i++)
    {glcd_data(0);
    }
 glcd_x0 += 8;
 /* Variante ohne Aufrundung: */
 for(i=0;i<fontbreite;i++)
    {if(i>0 && glcd_x0+i==64) //Wechsel auf rechte Display-Haelfte
       {glcd_command(0xC0,cs); //Display-Data
	glcd_command(0xB8+ypage,cs=CS1); //x-Start = ypage
	glcd_command(0x40,cs); //y-Start = 0
       }
     glcd_data(font[c][i]);
    }
 glcd_x0 += fontbreite;
 /* */
 glcd_command(0xC0,cs); //Display-Data
 glcd_portaus();
 if(glcd_x0==128) glcd_x0=0;
}

void glcd_write1(char c)
{
 char cs,i;
 int ypage,x;
 ypage=glcd_y0/8;
 c &= 0x7F;
 if(glcd_x0<64) {cs=CS2; x=glcd_x0&0x3F;}
 else {cs=CS1;  x=(glcd_x0-64)&0x3F;}
 glcd_command(0xB8+ypage,cs); //x-Start (senkrecht auf Display)
 glcd_command(0x40+x,cs); //y-Start (waagrecht auf Display)
 for(i=0;i<fontbreite;i++)
    {if(i>0 && glcd_x0+i==64) //Wechsel auf rechte Display-Haelfte
       {glcd_command(0xC0,cs); //Display-Data
	glcd_command(0xB8+ypage,cs=CS1); //x-Start = ypage
	glcd_command(0x40,cs); //y-Start = 0
       }
     glcd_data(font[c][i]);
    }
 glcd_x0 += fontbreite;
 glcd_command(0xC0,cs); //Display-Data
 if(glcd_x0==128) glcd_x0=0;
}

void glcd_write(const char *text)
{
 char c;
 glcd_portein();
 while((c= *text++)!=0)
  glcd_write1(c);
 glcd_portaus();
}

void glcd_test2()
{
 glcd_goto(4,2);
 glcd_write("123 Hallo Welt");
}
