/* glcd.cc       letzte Aenderung: 1.9.2023
 Version: 0.07
Ansteuern von Grafik-LCD, zum includen
 Prozessor: Atmega32
 Anschluss Grafik-LCD: PA0...PA7, PC2-PC7

 Autor: Rolf Pfister
 Copyright: Freeware
 History:
 6.8.2010	Erstellung, erster Teil von bahn.cc uebernommen
		Font vom Internet kopiert.
 15.8.10	Anpassung an Schaltungsaenderung
 19.8.10  0.06	Vereinfachung und Anpassung an anderen Port
 31.8.23  0.07	microwait() eingefuegt, so dass unabhaengig vom Hauptprogramm.
                Jeweils microwait(1) auf microwait(2) geaendert, da in urspruenglicher
                Version microwait laenger gewartet hat. Beim Umschalten von PortA als
		Eingang jeweils Pullup-Widerstaende gesetzt: wirklich noetig!
*/

/* im Hauptprogramm machen:
#include <avr/io.h>
#include <avr/interrupt.h>
#include "ulong.h"
#include "stdio.h"

void glcd_init();
void glcd_test();

#include "glcd.cc"
*/
/**** Grafik-LCD-Ansteuerung ****/
/*  Grafik-LCD: AV128641
 es werden 2 Ports benoetigt.
 mit z.B. PORTC: obere 6 Bits benoetigt:
	D/I   PC2 (H=Data, L=Instruction)
	R/W   PC3 (H=Read, L=Write)
	E     PC4 (Enable, H-aktiv)
	CS1   PC5 (L=Select1)
	CS2   PC6 (L=Select2)
	RST   PC7 (L=Reset)
 und als 2.Port z.B. PORTA: alle 8 Bit benoetigt:
	Daten PA0...PA7
*/
#define LCD_PORT PORTD
#define LCD_DDR  DDRD
const int DI=2, RW=3, EN=4, CS1=5, CS2=6, RST=7;

#define LCD2_PORT PORTA
#define LCD2_PIN  PINA
#define LCD2_DDR  DDRA

/************ Warte-Funktionen: **************/
#include <util/delay.h>

void microwait(uint8_t n) //etwa n Microsekunden warten
{
 do {_delay_us(1);} while(--n!=0);
}

/* urspruengliche Variante war falsch: Compiler hat es wegoptimiert!
char microwait(int n) //etwa n Microsekunden warten
{
 //Vorsicht: Compiler abhaengig.  Im .lss ueberpruefen
 char vx=0;
 n*=2;//bei 16MHz noetig, bei 8MHz auskommentieren
 while(n>0)
  {vx+=n; --n;}
 return vx;
}
*/

/************ inline Funktionen: **************/
//(offenbar wird das inline vom aktuellen Compilier ignoriert)
inline void select_cs1_or_cs2(char cs)
{
 //LCD_PORT &= ~(1<<cs); //geht nur wenn Port ausschliesslich fuer LCD benutzt
 //cli(); LCD_PORT &= ~(1<<cs); sei(); //Select CS1 oder CS2
 if(cs==CS1) LCD_PORT &= ~(1<<CS1); else LCD_PORT &= ~(1<<CS2);
}
inline void select_cs1_or_cs2_off(char cs)
{
 //LCD_PORT |= (1<<cs); //geht nur wenn Port ausschliesslich fuer LCD benutzt
 //cli(); LCD_PORT |= (1<<cs); sei(); //Select CS1 oder CS2 aus
 if(cs==CS1) LCD_PORT |= (1<<CS1); else LCD_PORT |= (1<<CS2);
}
/**********************************************/

void glcd_wait(char cs)
{
 char a;
 LCD2_DDR=0; //Port A auf Eingang
 LCD2_PORT=0xFF; //Port A Pullups
 LCD_PORT &= ~(1<<DI); //Instruction
 LCD_PORT |= (1<<RW); //Read
 select_cs1_or_cs2(cs);
 do
  {
   microwait(2);
   LCD_PORT |= (1<<EN); //sbi(PORTC,4); Enable
   microwait(2);
   a=LCD2_PIN;
   LCD_PORT &= ~(1<<EN); //cbi(PORTC,4);
/*
   if(a&0xB0) //test
    {lcd_goto(1,1); //auf anderem LCD-Display
     if(a&0x80) lcd_write("Busy");//test
     if(a&0x20) lcd_write(" Off");//test
     else lcd_write(" On");//test
     if(a&0x10) lcd_write(" Res");//test
    }
*/
  }
 while((a & 0x80)!=0);
 select_cs1_or_cs2_off(cs);
}

static char glcd_cs; //CS1 oder CS2, wird mit 1. glcd_command() initialisiert

void glcd_comm1(char a,char cs)
{
 LCD_PORT &= ~(1<<RW); //Write
 LCD2_DDR=0xFF; //Port A auf Ausgang
 LCD2_PORT=a;
 select_cs1_or_cs2(cs);
 microwait(2);
 LCD_PORT |= (1<<EN); //sbi(PORTC,4); Enable
 microwait(2);
 LCD_PORT &= ~(1<<EN); //cbi(PORTC,4);
 select_cs1_or_cs2_off(cs);
 glcd_wait(cs);
}
void glcd_command(char a,char cs)
{
 glcd_cs=cs;
 LCD_PORT &= ~(1<<DI); //Instruction
 glcd_comm1(a,cs);
}
void glcd_data(char a)
{
 LCD_PORT |= (1<<DI); //Data
 glcd_comm1(a,glcd_cs);
}

unsigned char glcd_readdata()
{
 unsigned char a;
 char cs=glcd_cs;
 LCD_PORT |= (1<<DI); //Data
 LCD_PORT |= (1<<RW); //Read
 LCD2_DDR=0x00; //Port A auf Eingang
 LCD2_PORT=0xFF; //Port A Pullups
 select_cs1_or_cs2(cs);
 microwait(2);
 LCD_PORT |= (1<<EN); //sbi(PORTC,4); Enable
 microwait(2);
 a=LCD2_PIN;
 LCD_PORT &= ~(1<<EN); //cbi(PORTC,4);
 select_cs1_or_cs2_off(cs);
 glcd_wait(cs);
 return a;
}

void glcd_clear(char farbe)
{
 uchar i,x,cs;
 if(farbe!=0) farbe=0xFF;
 //farbe=0x0F;//test: Teststreifen beim Einschalten
 for(cs=CS1;cs<=CS2;cs+=CS2-CS1)
  {glcd_command(0x40,cs); //y-Start
   for(x=0;x<8;x++)
    {glcd_command(0xB8+x,cs); //x-Start
     for(i=0;i<64;i++) glcd_data(farbe);
    }
  }
}

void glcd_init()
{
 cli();
 LCD_DDR |= 0xFC; //PORTC mindestens obere 6 Bits Ausgaenge
 LCD_PORT=(LCD_PORT&3)|0xE0; //RST,CS1,CS2 auf H; E,R/W,D/I auf L
 sei();
 LCD2_DDR=0; //Port A auf Eingang
 LCD2_PORT=0xFF; //Port A Pullups
 LCD_PORT &= ~(1<<RST); //cbi(PORTC,7); Reset ausfuehren
 microwait(10);
 LCD_PORT |= (1<<RST); //sbi(PORTC,7);
 glcd_wait(CS1);
 glcd_wait(CS2);
 glcd_command(0x3F,CS1); //Display ON
 glcd_command(0x3F,CS2); //Display ON
 glcd_clear(0);
}

void glcd_punkt(char x,char y,char farbe)
{
 char cs;
 unsigned char a,maske;
 y=63-y; //if(y>63) y=63; else if(y<0) y=0;
 maske = 1<<(y&7);
 y >>= 3;
 if(x>=64) {cs=CS1; x-=64;}
 else cs=CS2;
 glcd_command(0x40+x,cs); //y-Start
 glcd_command(0xB8+y,cs); //x-Start
 glcd_readdata();//dummy-read
 a=glcd_readdata();
 if(farbe==0) a &= ~maske; //Pixel loeschen
 else if(farbe==1) a |= maske; //Pixel setzen
 else a ^= maske; //bei farbe==2 Pixel umkehren
 glcd_command(0x40+x,cs); //y-Start
 glcd_data(a);
}

const int fontbreite=6, fonthoehe=8;
#include "6x8_vertikal_LSB_1a.h"
/* const char font[128][6]={
...
{0x00,0x00,0x42,0x7F,0x40,0x00},	// 0x31
...
};
*/

static int glcd_x0=0, glcd_y0=0;

void glcd_goto(int row,int col)
{
 //const int x8=(fontbreite+7)/8*8; //auf durch 8 teilbare Zahl aufgerundet
 const int x8=fontbreite; //Variante ohne Rundung
 glcd_x0=(col*x8) & 127; //Breite auf 128 beschraenkt
 glcd_y0=(row*fonthoehe) & 63; //Hoehe auf 64 beschraenkt
}

void glcd_write(int8_t c)
{
 int8_t cs,i;
 int ypage,x;
 ypage=glcd_y0/8;
 //y=glcd_x0&0x07; //untere 3 Bits
 c &= 0x7F;
 if(glcd_x0<64) {cs=CS2; x=glcd_x0&0x3F;}
 else {cs=CS1;  x=(glcd_x0-64)&0x3F;}
 glcd_command(0xB8+ypage,cs); //x-Start (senkrecht auf Display)
 glcd_command(0x40+x,cs); //y-Start (waagrecht auf Display)
 /* Variante mit Aufrundung: * /
 for(i=0;i<fontbreite;i++)
    {glcd_data(font[c][i]);}
 for(;i<8;i++)
    {glcd_data(0);}
 glcd_x0 += 8;
 */
 /* Variante ohne Aufrundung: */
 for(i=0;i<fontbreite;i++)
    {if(i>0 && glcd_x0+i==64) //Wechsel auf rechte Display-Haelfte
       {glcd_command(0xC0,cs); //Display-Data
	glcd_command(0xB8+ypage,cs=CS1); //x-Start = ypage
	glcd_command(0x40,cs); //y-Start = 0
       }
     glcd_data(font[c][i]);
    }
 glcd_x0 += fontbreite;
 /* */
 glcd_command(0xC0,cs); //Display-Data
 if(glcd_x0==128) glcd_x0=0;
}

void glcd_write(const char *text)
{
 char c;
 while((c= *text++)!=0)
  glcd_write(c);
}

void glcd_test(char farbe)
{
 unsigned char x,y;
 for(x=0;x<128;x++)
  {if(x<64) y=x; else y=127-x;
   glcd_punkt(x,y,farbe);
  }
}
void glcd_test2()
{
 glcd_goto(4,2);
 glcd_write("123 Hallo Welt");
}
