/* thumb.cc  Erzeugen von Vorschaubildchen (thumbnails)

*/

#include <stdio.h>
#include <stdlib.h>
#include <jpeglib.h>

typedef unsigned char uchar;

uchar *loadJpg(const char* name)
{
 uchar r, g, b;
 int width, height;
 struct jpeg_decompress_struct cinfo;
 struct jpeg_error_mgr jerr;

 FILE *fp;        /* source file */
 JSAMPARRAY pJpegBuffer;       /* Output row buffer */
 int row_stride;       /* physical row width in output buffer */
 if((fp=fopen(name,"rb"))==NULL)
   {fprintf(stderr, "can't open %s\n",name); return NULL;}
 cinfo.err = jpeg_std_error(&jerr);
 jpeg_create_decompress(&cinfo);
 jpeg_stdio_src(&cinfo, fp);
 jpeg_read_header(&cinfo, TRUE);
 jpeg_start_decompress(&cinfo);
 width = cinfo.output_width;
 height = cinfo.output_height;

 uchar *pDummy = new uchar [width*height*4];
 uchar *pTest = pDummy;
 if(!pDummy) {printf("NO MEM FOR JPEG CONVERT!\n"); return NULL;}
 row_stride = width * cinfo.output_components;
 pJpegBuffer = (*cinfo.mem->alloc_sarray)
  ((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);

 while(cinfo.output_scanline < cinfo.output_height)
  {
   jpeg_read_scanlines(&cinfo, pJpegBuffer, 1);
   for(int x=0; x < width; x++)
    {
     //a = 0; // alpha value is not supported on jpg
     r = pJpegBuffer[0][cinfo.output_components * x];
     if(cinfo.output_components > 2)
      {
       g = pJpegBuffer[0][cinfo.output_components * x + 1];
       b = pJpegBuffer[0][cinfo.output_components * x + 2];
      }
     else {g=r; b=r;}
     *(pDummy++) = b;
     *(pDummy++) = g;
     *(pDummy++) = r;
     *(pDummy++) = 0; //a;
    }
  }
 fclose(fp);
 jpeg_finish_decompress(&cinfo);
 jpeg_destroy_decompress(&cinfo);
 /*
   BMap = (uchar*)pTest; 
   Height = height;
   Width = width;
   Depth = 32;
 */
 printf("Bildgroesse: %dx%d\n",width,height);//test
 return pTest;
}

int main(int argc, char **argv)
{
 uchar *data;
 data=loadJpg("test.jpg");
 if(data==NULL) printf("Fehler\n");
 else
  {
   //TODO
   delete[] data;
  }
 return 0;
}
