#ifdef CHECK
#include "kernelcheck.h"
#endif

#include "kernel.h"  //Konstanten, sowohl im Kernel als auch im Hauptprogramm benutzt

#pragma OPENCL EXTENSION cl_khr_fp64 : enable

__kernel void hello(__global double *px,__global double *py,__global double *pz,
		    __global float *mass,__global float *radi,__global double3 *kraft,
		    double dt)
{
 // Kraefte (f) zwischen allen moeglichen Paaren berechnen
 int i=get_global_id(0); //erstes Atom
 int j=get_global_id(1); //zweites Atom des aktuellen Paares
 if(i<j && j<NATOMS)
  {
   double ax=px[j]-px[i];
   double ay=py[j]-py[i];
   double az=pz[j]-pz[i];
   double abst2 = ax*ax+ay*ay+az*az; //Abstand im Quadrat
   double nah=(radi[i]+radi[j])*1.5;
   double3 f3={0,0,0};
   if(abst2 < nah*nah) //Abstossung nur wenn Atome sehr nahe
    {
     if(abst2==0) abst2=nah/4;//test
     double f=KFKA/(abst2*abst2*abst2); //Dividieren durch Abstand hoch 6
     double abstand=sqrt(abst2);
     f /= abstand;
     f3.x = f*ax;
     f3.y = f*ay;
     f3.z = f*az;
    }
   /*
   const double dd=1e-20, hh=1e20;
   if(f3.x<dd && f3.x > -dd) f3.x=0;//test
   if(f3.y<dd && f3.y > -dd) f3.y=0;//test
   if(f3.z<dd && f3.z > -dd) f3.z=0;//test
   if(f3.x>hh) f3.x=hh; else if(f3.x< -hh) f3.x= -hh;//test
   if(f3.y>hh) f3.y=hh; else if(f3.y< -hh) f3.y= -hh;//test
   if(f3.z>hh) f3.z=hh; else if(f3.z< -hh) f3.z= -hh;//test
   */
   f3.x=0.1*i;//test
   f3.y=0.1*j;//test
   f3.z=0.001*NATOMS;//test
   //kraft[i*NATOMS+j] = f3;
   //kraft[j*NATOMS+i] = -f3;
   kraft[i*NATOMS+j].x = f3.x;
   kraft[i*NATOMS+j].y = f3.y;
   kraft[i*NATOMS+j].z = f3.z;
   kraft[j*NATOMS+i].x = f3.x;
   kraft[j*NATOMS+i].y = f3.y;
   kraft[j*NATOMS+i].z = f3.z;
  }
 else if(i==j)
  {
   double3 f3={0,0,0};
   //kraft[i*NATOMS+j]=f3; //Diagonalwerte auf 0 setzen
   kraft[i*NATOMS+j].x = i; //test
   kraft[i*NATOMS+j].y = j; //test
   kraft[i*NATOMS+j].z = NATOMS; //test
  }
}

__kernel void fsum(__global double *vx,__global double *vy,__global double *vz,
		   __global float *mass,__global double3 *kraft,double dt)
{
// Kraefte aufsummieren und entsprechend Geschwindigkeit aendern
 //int id=get_local_id(0);
 //int tpb=get_local_size(0);
 int i=get_global_id(0);
 double3 f3={0,0,0};
 for(int j=0;j<NATOMS;j++)
  if(j!=i) //nicht noetig wenn Diagonalwerte auf 0 gesetzt
   {
    f3 += kraft[i*NATOMS+j];
   }
 double dtm=dt/mass[i];
 /*
 vx[i] -= f3.x*dtm; //a=f/m, dv=a*dt, dv=f/m*dt, dv=f*dt/m
 vy[i] -= f3.y*dtm;
 vz[i] -= f3.z*dtm;
 */
}

__kernel void vpos(__global double *px,__global double *py,__global double *pz,
		   __global double *vx,__global double *vy,__global double *vz,
		   __global float *radi,double dt)
{
 // Aus den Geschwindigkeiten neue Positionen berechnen,
 // und Richtungsaenderungen bei Stoessen mit den Waenden.
 int i=get_global_id(0); //aktuelles Atom
 //if(i<NATOMS)
  {
   float radius=radi[i];
   px[i] += vx[i]*dt;
   py[i] += vy[i]*dt;
   pz[i] += vz[i]*dt;
   double a;
   if((a=px[i]+BOXX) < radius)
    {if(vx[i]<0) {vx[i] = -vx[i]; px[i] += (radius-a)*2;}}
   else if((a=BOXX-px[i]) < radius)
    {if(vx[i]>0) {vx[i] = -vx[i]; px[i] -= (radius-a)*2;}}
   if((a=py[i]+BOXY) < radius)
    {if(vy[i]<0) {vy[i] = -vy[i]; py[i] += (radius-a)*2;}}
   else if((a=BOXY-py[i]) < radius)
    {if(vy[i]>0) {vy[i] = -vy[i]; py[i] -= (radius-a)*2;}}
   if((a=pz[i]+BOXZ) < radius)
    {if(vz[i]<0) {vz[i] = -vz[i]; pz[i] += (radius-a)*2;}}
   else if((a=BOXZ-pz[i]) < radius)
    {if(vz[i]>0) {vz[i] = -vz[i]; pz[i] -= (radius-a)*2;}}
  }
}

__kernel void sort(__global const double *pz,__global int *list)
{
 int id=get_local_id(0);
 __local int s[NATOMS];
 int i=id*2;
 int j=i+1;
 if(pz[i] < pz[j]) //vertauschen, so dass groessere z-Werte zuerst
  {s[i]=j; s[j]=i;}
 else
  {s[i]=i; s[j]=j;}
 barrier(CLK_LOCAL_MEM_FENCE);
 for(int k=1;k<NATOMS;k++)
  {
   i ^= 1; //jedes zweite Mahl mit ungeradem Wert beginnen
   j=i+1;
   if(j<NATOMS && pz[s[i]] < pz[s[j]]) //vertauschen, so dass groessere Werte zuerst
    {
     int h=s[i]; s[i]=s[j]; s[j]=h;
    }
   barrier(CLK_LOCAL_MEM_FENCE);
  }
 list[2*id]   = s[2*id];
 list[2*id+1] = s[2*id+1];
}
