#ifdef CHECK
#include "kernelcheck.h"
#endif

#include "kernel.h"  //Konstanten, sowohl im Kernel als auch im Hauptprogramm benutzt

#pragma OPENCL EXTENSION cl_khr_fp64 : enable

__kernel void hello(__global double *px,__global double *py,__global double *pz,
		    __global double *vx,__global double *vy,__global double *vz,
		    __global float *mass,__global float *radi,int natoms,double dt)
{
 // Kraefte zwischen den Atomen und daraus neue Geschwindigkeiten berechnen
 int i=get_global_id(0); //aktuelles Atom
 if(i<natoms)
  {
   double fx=0,fy=0,fz=0;
   for(int j=0;j<natoms;j++) //Abstaende zu allen andern Atomen
    if(j!=i)
     {
      double ax=px[j]-px[i];
      double ay=py[j]-py[i];
      double az=pz[j]-pz[i];
      double rx2=ax*ax; //Abstand x im Quadrat
      double ry2=ay*ay;
      double rz2=az*az;
      double abst2 = rx2+ry2+rz2; //Abstand im Quadrat
      double nah=(radi[i]+radi[j])*1.5;
      if(abst2 < nah*nah) //Abstossung nur wenn Atome sehr nahe
       {
	double f=KFKA/(abst2*abst2*abst2); //Dividieren durch Abstand hoch 6
	double abstand=sqrt(abst2);
	fx += f*ax/abstand;
	fy += f*ay/abstand;
	fz += f*az/abstand;
       }
     }
   double m=mass[i];
   vx[i] -= fx/m*dt; //a=F/m, dv=a*dt
   vy[i] -= fy/m*dt;
   vz[i] -= fz/m*dt;
  }
}

__kernel void vpos(__global double *px,__global double *py,__global double *pz,
		   __global double *vx,__global double *vy,__global double *vz,
		   __global float *radi,int natoms,double dt)
{
 // Aus den Geschwindigkeiten neue Positionen berechnen,
 // und Richtungsaenderungen bei Stoessen mit den Waenden.
 int i=get_global_id(0); //aktuelles Atom
 if(i<natoms)
  {
   float radius=radi[i];
   px[i] += vx[i]*dt;
   py[i] += vy[i]*dt;
   pz[i] += vz[i]*dt;
   double a;
   if((a=px[i]+BOXX) < radius)
    {if(vx[i]<0) {vx[i] = -vx[i]; px[i] += (radius-a)*2;}}
   else if((a=BOXX-px[i]) < radius)
    {if(vx[i]>0) {vx[i] = -vx[i]; px[i] -= (radius-a)*2;}}
   if((a=py[i]+BOXY) < radius)
    {if(vy[i]<0) {vy[i] = -vy[i]; py[i] += (radius-a)*2;}}
   else if((a=BOXY-py[i]) < radius)
    {if(vy[i]>0) {vy[i] = -vy[i]; py[i] -= (radius-a)*2;}}
   if((a=pz[i]+BOXZ) < radius)
    {if(vz[i]<0) {vz[i] = -vz[i]; pz[i] += (radius-a)*2;}}
   else if((a=BOXZ-pz[i]) < radius)
    {if(vz[i]>0) {vz[i] = -vz[i]; pz[i] -= (radius-a)*2;}}
  }
}

__kernel void sort(__global const double *pz,__global int *list)
{
 int id=get_local_id(0);
 __local int s[NATOMS];
 int i=id*2;
 int j=i+1;
 if(pz[i] < pz[j]) //vertauschen, so dass groessere z-Werte zuerst
  {s[i]=j; s[j]=i;}
 else
  {s[i]=i; s[j]=j;}
 barrier(CLK_LOCAL_MEM_FENCE);
 for(int k=1;k<NATOMS;k++)
  {
   i ^= 1; //jedes zweite Mahl mit ungeradem Wert beginnen
   j=i+1;
   if(j<NATOMS && pz[s[i]] < pz[s[j]]) //vertauschen, so dass groessere Werte zuerst
    {
     int h=s[i]; s[i]=s[j]; s[j]=h;
    }
   barrier(CLK_LOCAL_MEM_FENCE);
  }
 list[2*id]   = s[2*id];
 list[2*id+1] = s[2*id+1];
}
