#ifdef CHECK
#include "kernelcheck.h" //nur zum Testen mit gcc
#endif

#include "kernel.h"  //Konstanten, sowohl im Kernel als auch im Hauptprogramm benutzt

#pragma OPENCL EXTENSION cl_khr_fp64 : enable
 
#define KNR (NATOMS-1) //Anzahl Knoten
#define TSTEP (NATOMS/2) //Anzahl Paare pro Knoten
#define NPAARE (KNR*TSTEP) //totale Anzahl Paare

__kernel void hello(__global double *px,__global double *py,__global double *pz,
		    __global double *vx,__global double *vy,__global double *vz,
		    __global float *mass,__global float *radi,
		    __global short2 *paartab, double dt)
{
 // Kraefte zwischen den Atomen und daraus neue Geschwindigkeiten berechnen
 int id=get_local_id(0);
 int tpb=get_local_size(0);
 __local double fx[NATOMS+1],fy[NATOMS+1],fz[NATOMS]; //bei 1024 Atomen: 3*8=24KB
                                                      //bei 2048 --> 48KB = gerade zuviel!
 __local float locradi[NATOMS+1];
 __local double locpx[NATOMS+1],locpy[NATOMS]; //fuer locpz[] reicht es nicht mehr
 for(int i=id;i<NATOMS;i+=tpb)
  {
   fx[i]=fy[i]=fz[i]=0;
   locradi[i]=radi[i];
   locpx[i]=px[i]; locpy[i]=py[i];
  }
 barrier(CLK_LOCAL_MEM_FENCE);
 for(int t=0;t<NPAARE;t+=TSTEP)
  {
   for(int b=0;b<TSTEP;b+=tpb) //falls tpb<TSTEP diese Schlaufe mehrmals
    {
     int i=paartab[t+b+id].x; //erstes Atom
     int j=paartab[t+b+id].y; //zweites Atom
     // Kraefte zwischen 2 Atomen und damit Geschwindigkeitsaenderung berechnen.
     // Jeder Thread verwendet 2 andere Atome, so dass die Geschwindigkeiten der
     // aktuellen beiden ohne Konflickt gesetzt werden koennen.
     double ax=locpx[j]-locpx[i];
     double ay=locpy[j]-locpy[i];
     double az=pz[j]-pz[i];
     double abst2 = ax*ax+ay*ay+az*az; //Abstand im Quadrat
     double nah=(locradi[i]+locradi[j])*1.5;
     if(abst2 < nah*nah) //Abstossung nur wenn Atome sehr nahe
      {
       double f=KFKA/(abst2*abst2*abst2); //Dividieren durch Abstand hoch 6
       double abstand=sqrt(abst2);
       f /= abstand;
       fx[i] += f*ax;
       fy[i] += f*ay;
       fz[i] += f*az;
       fx[j] -= f*ax; //Kraftrichtung im zweiten Atom entgegengesetzt
       fy[j] -= f*ay;
       fz[j] -= f*az;
      }
    }
   barrier(CLK_LOCAL_MEM_FENCE);
  }
 for(int i=id;i<NATOMS;i+=tpb)
  {
   double dtm = dt/mass[i]; //dt/m
   vx[i] -= fx[i]*dtm; //a=f/m, dv=a*dt --> dv=f*dt/m
   vy[i] -= fy[i]*dtm;
   vz[i] -= fz[i]*dtm;
  }
}

__kernel void vpos(__global double *px,__global double *py,__global double *pz,
		   __global double *vx,__global double *vy,__global double *vz,
		   __global float *radi,double dt)
{
 // Aus den Geschwindigkeiten neue Positionen berechnen,
 // und Richtungsaenderungen bei Stoessen mit den Waenden.
 int i=get_global_id(0); //aktuelles Atom
 if(i<NATOMS)
  {
   float radius=radi[i];
   px[i] += vx[i]*dt;
   py[i] += vy[i]*dt;
   pz[i] += vz[i]*dt;
   double a;
   if((a=px[i]+BOXX) < radius)
    {if(vx[i]<0) {vx[i] = -vx[i]; px[i] += (radius-a)*2;}}
   else if((a=BOXX-px[i]) < radius)
    {if(vx[i]>0) {vx[i] = -vx[i]; px[i] -= (radius-a)*2;}}
   if((a=py[i]+BOXY) < radius)
    {if(vy[i]<0) {vy[i] = -vy[i]; py[i] += (radius-a)*2;}}
   else if((a=BOXY-py[i]) < radius)
    {if(vy[i]>0) {vy[i] = -vy[i]; py[i] -= (radius-a)*2;}}
   if((a=pz[i]+BOXZ) < radius)
    {if(vz[i]<0) {vz[i] = -vz[i]; pz[i] += (radius-a)*2;}}
   else if((a=BOXZ-pz[i]) < radius)
    {if(vz[i]>0) {vz[i] = -vz[i]; pz[i] -= (radius-a)*2;}}
  }
}

__kernel void sort(__global const double *pz,__global int *list)
{
 int id=get_local_id(0);
 __local int s[NATOMS];
 int i=id*2;
 int j=i+1;
 if(pz[i] < pz[j]) //vertauschen, so dass groessere z-Werte zuerst
  {s[i]=j; s[j]=i;}
 else
  {s[i]=i; s[j]=j;}
 barrier(CLK_LOCAL_MEM_FENCE);
 for(int k=1;k<NATOMS;k++)
  {
   i ^= 1; //jedes zweite Mahl mit ungeradem Wert beginnen
   j=i+1;
   if(j<NATOMS && pz[s[i]] < pz[s[j]]) //vertauschen, so dass groessere Werte zuerst
    {
     int h=s[i]; s[i]=s[j]; s[j]=h;
    }
   barrier(CLK_LOCAL_MEM_FENCE);
  }
 list[2*id]   = s[2*id];
 list[2*id+1] = s[2*id+1];
}
