#ifdef CHECK
#include "kernelcheck.h"
#endif

#include "kernel.h"  //Konstanten, sowohl im Kernel als auch im Hauptprogramm benutzt

#pragma OPENCL EXTENSION cl_khr_fp64 : enable

__kernel void hello(__global double *px,__global double *py,__global double *pz,
		    __global double *vx,__global double *vy,__global double *vz,
		    __global float *mass,__global float *radi,double dt)
{
 // Kraefte zwischen den Atomen und daraus neue Geschwindigkeiten berechnen
 int id=get_local_id(0);
 int tpb=get_local_size(0);
 int i=get_global_id(0); //aktuelles Atom
#define PAD 1 //ev. variieren um Bank-konflikt zu vermeiden
 __local double locpx[NATOMS+PAD],locpy[NATOMS+PAD],locpz[NATOMS+PAD]; //maximal 1024 Atome: 24KB
 __local float locradi[NATOMS];
 for(int i=id;i<NATOMS;i+=tpb)
  {
   locpx[i]=px[i]; locpy[i]=py[i]; locpz[i]=pz[i];
   locradi[i]=radi[i];
  }
 barrier(CLK_LOCAL_MEM_FENCE);
 //if(i<NATOMS) //mit Anzahl Atomen 2^n ist das sichergestellt
  {
   double pxi=locpx[i], pyi=locpy[i], pzi=locpz[i];
   float radii=locradi[i];
   double fx=0,fy=0,fz=0;
   for(int j=0;j<NATOMS;j++) //Abstaende zu allen andern Atomen
    if(j!=i)
     {
      double ax=locpx[j]-pxi;
      double ay=locpy[j]-pyi;
      double az=locpz[j]-pzi;
      double abst2 = ax*ax+ay*ay+az*az; //Abstand im Quadrat
      double nah=(radii+locradi[j])*1.5;
      if(abst2 < nah*nah) //Abstossung nur wenn Atome sehr nahe
       {
	double f=KFKA/(abst2*abst2*abst2); //Dividieren durch Abstand hoch 6
	double abstand=sqrt(abst2);
	f /= abstand;
	fx += f*ax;
	fy += f*ay;
	fz += f*az;
       }
     }
   double dtm=dt/mass[i];
   vx[i] -= fx*dtm; //a=f/m, dv=a*dt, dv=f/m*dt, dv=f*dt/m
   vy[i] -= fy*dtm;
   vz[i] -= fz*dtm;
  }
}

__kernel void vpos(__global double *px,__global double *py,__global double *pz,
		   __global double *vx,__global double *vy,__global double *vz,
		   __global float *radi,double dt)
{
 // Aus den Geschwindigkeiten neue Positionen berechnen,
 // und Richtungsaenderungen bei Stoessen mit den Waenden.
 int i=get_global_id(0); //aktuelles Atom
 //if(i<NATOMS)
  {
   float radius=radi[i];
   px[i] += vx[i]*dt;
   py[i] += vy[i]*dt;
   pz[i] += vz[i]*dt;
   double a;
   if((a=px[i]+BOXX) < radius)
    {if(vx[i]<0) {vx[i] = -vx[i]; px[i] += (radius-a)*2;}}
   else if((a=BOXX-px[i]) < radius)
    {if(vx[i]>0) {vx[i] = -vx[i]; px[i] -= (radius-a)*2;}}
   if((a=py[i]+BOXY) < radius)
    {if(vy[i]<0) {vy[i] = -vy[i]; py[i] += (radius-a)*2;}}
   else if((a=BOXY-py[i]) < radius)
    {if(vy[i]>0) {vy[i] = -vy[i]; py[i] -= (radius-a)*2;}}
   if((a=pz[i]+BOXZ) < radius)
    {if(vz[i]<0) {vz[i] = -vz[i]; pz[i] += (radius-a)*2;}}
   else if((a=BOXZ-pz[i]) < radius)
    {if(vz[i]>0) {vz[i] = -vz[i]; pz[i] -= (radius-a)*2;}}
  }
}

__kernel void sort(__global const double *pz,__global int *list)
{
 int id=get_local_id(0);
 __local int s[NATOMS];
 int i=id*2;
 int j=i+1;
 if(pz[i] < pz[j]) //vertauschen, so dass groessere z-Werte zuerst
  {s[i]=j; s[j]=i;}
 else
  {s[i]=i; s[j]=j;}
 barrier(CLK_LOCAL_MEM_FENCE);
 for(int k=1;k<NATOMS;k++)
  {
   i ^= 1; //jedes zweite Mahl mit ungeradem Wert beginnen
   j=i+1;
   if(j<NATOMS && pz[s[i]] < pz[s[j]]) //vertauschen, so dass groessere Werte zuerst
    {
     int h=s[i]; s[i]=s[j]; s[j]=h;
    }
   barrier(CLK_LOCAL_MEM_FENCE);
  }
 list[2*id]   = s[2*id];
 list[2*id+1] = s[2*id+1];
}
