// Defines um Kernel mit gcc zu uebersetzen fuer Syntax-Test
#include <stdio.h>
#include <math.h>
#include <vector_types.h>
// "vector_types.h" sollte in /usr/include/ oder /usr/local/cuda... zu finden sein

#define __kernel
#define __global
#define __local
#define get_local_id(n) (n)
#define get_group_id(n) (n)
#define get_global_id(n) (n)
#define get_local_size(n) (32)
#define get_group_size(n) (32)
#define get_global_size(n) (1024)
#define CLK_LOCAL_MEM_FENCE 0
#define CLK_GLOBAL_MEM_FENCE 1
//#define barrier(n) (n)
void barrier(int n) {}

float4 operator+(const float4& a,const float4& b)
{return {a.x+b.x, a.y+b.y, a.z+b.z, a.w+b.w};}

float4 operator*(const float c,const float4& v)
{return {c*v.x, c*v.y, c*v.z, c*v.w};}

float4& operator+=(float4& x,const float4& y)
{x.x+=y.x; x.y+=y.y; x.z+=y.z; x.w+=y.w; return x;}

struct float8 {float s0,s1,s2,s3,s4,s5,s6,s7,s8;};

float8 operator*(const float c,const float8& v)
{return {c*v.s0,c*v.s1,c*v.s2,c*v.s3,c*v.s4,c*v.s5,c*v.s6,c*v.s7};}

float8& operator+=(float8& x,const float8& y)
{
 x.s0+=y.s0; x.s1+=y.s1; x.s2+=y.s2; x.s3+=y.s3;
 x.s4+=y.s4; x.s5+=y.s5; x.s6+=y.s6; x.s7+=y.s7;
 return x;
}

double4 operator-(const double4& a,const double4& b)
{return {a.x-b.x, a.y-b.y, a.z-b.z, a.w-b.w};}

double4 operator*(const double4& a,const double4& b)
{return {a.x*b.x, a.y*b.y, a.z*b.z, a.w*b.w};}

double4 operator+(const double4& a,const double4& b)
{return {a.x+b.x, a.y+b.y, a.z+b.z, a.w+b.w};}

double4 operator/(const double4& a,const float4& b)
{return {a.x/b.x, a.y/b.y, a.z/b.z, a.w/b.w};}

double4 operator*(const double4& a,const float b)
{return {a.x*b, a.y*b, a.z*b, a.w*b};}

double4& operator+=(double4& x,const double4& y)
{x.x+=y.x; x.y+=y.y; x.z+=y.z; x.w+=y.w; return x;}

double4& operator-=(double4& x,const double4& y)
{x.x-=y.x; x.y-=y.y; x.z-=y.z; x.w-=y.w; return x;}

double3 operator-(double3 a)
{
 a.x = -a.x;
 a.y = -a.y;
 a.z = -a.z;
 return a;
}

double3& operator+=(double3& a,const double3& b)
{a.x+=b.x; a.y+=b.y; a.z+=b.z; return a;}
