// myopencl.h

#ifndef MYOPENCL_H
#define MYOPENCL_H

bool kernel_compilieren(const char *kernel_name,int maxreg=0);
bool copy_to_device(const double *px,const double *py,const double *pz,
		    const double *vx,const double *vy,const double *vz,
		    const float *mass,const float *radi,const int natoms);
bool copy_to_device_opt(const double *px,const double *py,const double *pz,
		    const double *vx,const double *vy,const double *vz,
		    const float *mass,const float *radi,const short2 *paartab);
bool kernel_aufrufen(double dt,int *zwi=NULL);
bool kernel_aufruf_sort(int *list);
bool copy_from_device(double *px,double *py,double *pz, int n);
void device_speicher_freigeben();
const char *getErrorString(int error);
void set_TPB(int n);
void set_TPBxy(int x,int y);
void get_tpb(int *t,int *x,int *y);
bool debug_copy_kraft(double *kraft);

#endif
