/* quaternionklasse.cc */

#include "quaternionklasse.h"

void Quaternion::normieren()
{
 double z=sqrt(a*a+b*b+c*c+d*d);
 a/=z; b/=z; c/=z; d/=z;
}

void Quaternion::normieren2()
{
 double z=sqrt((b*b+c*c+d*d)/(1-a*a));
 b/=z; c/=z; d/=z;
}

Drehmatrix Quaternion::rotationsmatrix()
{
 Drehmatrix r;
 r.a = a*a+b*b-c*c-d*d;
 r.b = 2*(b*c-a*d);
 r.c = 2*(b*d+a*c);
 r.d = 2*(b*c+a*d);
 r.e = a*a-b*b+c*c-d*d;
 r.f = 2*(c*d-a*b);
 r.g = 2*(b*d-a*c);
 r.h = 2*(c*d+a*b);
 r.i = a*a-b*b-c*c+d*d;
 return r;
}

void Quaternion::drehung_definieren(Vektor3d achse,double winkel)
{
 double whalbe=winkel/2;
 double sinwh=sin(whalbe);
 a=cos(whalbe); b=achse.x*sinwh; c=achse.y*sinwh; d=achse.z*sinwh;
 normieren2();
}

Vektor3d Quaternion::vektordrehen(Vektor3d v)
{
 Vektor3d vgedreht;
 double r[9];
 r[0] = a*a+b*b-c*c-d*d;
 r[1] = 2*(b*c-a*d);
 r[2] = 2*(b*d+a*c);
 r[3] = 2*(b*c+a*d);
 r[4] = a*a-b*b+c*c-d*d;
 r[5] = 2*(c*d-a*b);
 r[6] = 2*(b*d-a*c);
 r[7] = 2*(c*d+a*b);
 r[8] = a*a-b*b-c*c+d*d;
 vgedreht.x = v.x*r[0]+v.y*r[1]+v.z*r[2];
 vgedreht.y = v.x*r[3]+v.y*r[4]+v.z*r[5];
 vgedreht.z = v.x*r[6]+v.y*r[7]+v.z*r[8];
 return vgedreht;
}

Vektor3d Quaternion::vektordrehen(Vektor3d v,Vektor3d achse,double winkel)
{
 drehung_definieren(achse,winkel);
 return vektordrehen(v);
}

Quaternion Quaternion::operator+=(Quaternion v)
{
 a+=v.a; b+=v.b; c+=v.c; d+=v.d;
 return *this;
}

Quaternion operator+(Quaternion v1,Quaternion v2)
{
 Quaternion v;
 v.a=v1.a+v2.a; v.b=v1.b+v2.b; v.c=v1.c+v2.c; v.d=v1.d+v2.d;
 return v;
}

Quaternion operator*(Quaternion v1,Quaternion v2)
{
 Quaternion v;
 v.a = v1.a*v2.a-v1.b*v2.b-v1.c*v2.c-v1.d*v2.d; //i*i=j*j=k*k=-1
 v.b = v1.a*v2.b+v1.b*v2.a+v1.c*v2.d-v1.d*v2.c; //j*k=i, k*j=-i
 v.c = v1.a*v2.c+v1.c*v2.a-v1.b*v2.d+v1.d*v2.b; //k*i=j, i*k=-j
 v.d = v1.a*v2.d+v1.d*v1.a+v1.b*v2.c-v1.c*v2.b; //i*j=k, j*i=-k
 return v;
}
