/* raumflug.cc  letzte Aenderung: 9.10.2019

Simulation eines Raumfluges mit Geschwindigkeiten nahe der Lichtgeschw.
*/
#define VERSION "0.02"
/*
11.9.2019  0.01  Erstellung (RP)
29.9.2019  0.02  BSC5-Katalog eingefuegt

*/

#define MAXBILDBREITE (1920*2) //FullHD: 1920, 4K-Bildschirm: (1920*2)
#define MAXBILDHOEHE (1080*2)  //FullHD: 1080, 4K-Bildschirm: (1080*2)

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <GL/freeglut.h>

#if(MAXBILDHOEHE>=2040)
//#define MAXBILDBREITE (1920*2)
#define BILDBREITE 2400
#define BILDHOEHE 2000
#define SCHRIFTSKALIERUNG 2
#elif(MAXBILDHOEHE>=1040)
#define BILDBREITE 2000
#define BILDHOEHE 1000
#define SCHRIFTSKALIERUNG 1
#endif

#define BILDPOSX ((MAXBILDBREITE-BILDBREITE)/2)
#define BILDPOSY ((MAXBILDHOEHE-BILDHOEHE)/4)

typedef unsigned char uchar;

const double PI=4*atan(1.0);
#include "vektor3dklasse.cc"

const double C=1; //1 Lichtjahr/Jahr
//const double C=299792458.0; //Lichtgeschwindigkeit in m/s
const double LJM=365.25*24*3600*299792458; //Lichtjahr in Meter
//const double PARSEC=30.857e15; //Parsec in Meter
const double PARSEC=30.857e15/LJM; //Parsec in Lichtjahren
const double PARSEC10QUAD=100*PARSEC*PARSEC; //10 Parsec ist definiert als Distanz fuer Absmag

//const double PHYSBR=0.4; //physikalische Bildbreite in Meter
//const double PHYSBR=0.4/LJM; //physikalische Bildbreite in Lichtjahren
//const double BILDSKAL=2*PHYSBR;
const double BILDSKAL=2.0; //so entsprechen xmin...ymax Pixelwerten von Bildmitte aus gesehen

const double xmin= -BILDBREITE/BILDSKAL, xmax=BILDBREITE/BILDSKAL;
const double ymin= -BILDHOEHE/BILDSKAL, ymax=BILDHOEHE/BILDSKAL;
const double DX=(xmax-xmin)/BILDBREITE; //Pixelgroesse
const double DY=(ymax-ymin)/BILDHOEHE; //Pixelgroesse in y-Richtung
const double DXS=DX*SCHRIFTSKALIERUNG, DYS=DY*SCHRIFTSKALIERUNG; //fuer Schriftgroessen
const double xrand=(xmax-xmin)/50, yrand=(ymax-ymin)/20;
#include "myfonts.cc"

#include "bsc5.h"

/** schon in bsc5.h
class Sterndata
{
public:
 double absmag,mag;
 char name[80];
 double rektaszension,deklination,abstand;
...
};
**/

#define MAX_STERNE 12000
Vektor3d sternepos[MAX_STERNE];
Sterndata sternedaten[MAX_STERNE];
static int anz_sterne=0;

#define FRONTFENSTER 0
#define RECHTSFENSTER 1
#define HINTERFENSTER 2
#define LINKSFENSTER 3
#define OBENFENSTER 4
#define UNTENFENSTER 5
static int fenst=FRONTFENSTER;

/********************************* kleinkram **********************************/
void mpause(int n) //n millisekunden warten
{
 usleep(n*1000); //soviele Mikrosekunden warten
}

bool getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

bool fastgleich(double a,double b,double diff)
{
 return (abs(a-b)<diff);
}

/*************************** Sterntabellen einlesen ***************************/
char *parser(char *s,const char *cstr,void* p)
{
 char *nexttab=NULL,*t;
 for(t=s;*t!=0;t++)
  {
   if(*t=='\t') {nexttab=t; *t++ = 0; break;}
  }
 if(cstr[1]=='s')
  {
   char *q=(char*)p;
   while(*s==' ' && s[1]!=0) s++; //fuehrende Leerstellen loeschen
   strcpy(q,s);
   for(int n=strlen(q);n>1 && q[n-1]==' ';) {q[--n]=0;} //hintere Leerstellen loeschen
  }
 else if(cstr[1]=='d')
  {
   sscanf(s,cstr,p);
  }
 else if(cstr[1]=='f')
  {
   sscanf(s,cstr,p);
  }
 else if(cstr[1]=='l' && cstr[2]=='f')
  {
   sscanf(s,cstr,p);
  }
 else if(cstr[1]=='K')
  { //Deklination
   int grad,min,sec,sig=1;
   if(*s=='-') {sig= -1; s++;}
   else if(*s=='+') {s++;}
   for(char *q=s;*q!=0;q++) {if(*q>'z' || *q<0) *q=' ';}//Sonderzeichen entfernen
   sscanf(s,"%d%*c%d%*c%d",&grad,&min,&sec);
   if(grad>90 || grad< -90) printf("Fehler: grad=%d nicht im Bereich -90...+90\n",grad);
   if(min>=60 || min<0) printf("Fehler: min=%d nicht im Bereich 0...59\n",min);
   if(sec>=60 || sec<0) printf("Fehler: sec=%d nicht im Bereich 0...59\n",sec);
   double dek=(grad+min/60.0+sec/3600.0)*sig*GRAD;
   *(double*)p = dek;
  }
 else if(cstr[1]=='R')
  { //Rektaszension
   int stu,min,sec,sig=1;
   if(*s=='-') {sig= -1; s++;}
   else if(*s=='+') {s++;}
   sscanf(s,"%d%*c%d%*c%d",&stu,&min,&sec);
   if(stu>24 || stu<0) printf("Fehler: Stundenwinkel=%d nicht im Bereich 0...24\n",stu);
   if(min>=60 || min<0) printf("Fehler: min=%d nicht im Bereich 0...59\n",min);
   if(sec>=60 || sec<0) printf("Fehler: sec=%d nicht im Bereich 0...59\n",sec);
   double rekt=(stu+min/60.0+sec/3600.0)*sig*(ZWEIPI/24);
   *(double*)p = rekt;
  }
 else {printf("Fehler in parser: cstr falsch\n");}
 if(nexttab!=NULL) *nexttab='\t';
 return t;
}

void polar_xyz_umrechnung(double ra,double dek,double r,Vektor3d& p)
{
 double rsindek=r*sin(PIHALBE-dek);
 /*
 p.x = rsindek*cos(ra);
 p.y = rsindek*sin(ra);
 p.z = r*cos(PIHALBE-dek);
 */
 //gedrehtes Koordinatensystem, so dass y-Achse auf Polarstern zeigt:
 p.z = rsindek*cos(ra);
 p.x = rsindek*sin(ra);
 p.y = r*cos(PIHALBE-dek);
}

void sterne_einlesen2(const char *name)
{
 FILE *fp=fopen(name,"r");
 if(fp==NULL) {printf("kann \"%s\" nicht oeffnen.\n",name); exit(0);}
 char *s,zeile[200],nam1[80],sternname[80];
 int i,nr;
 float mag,absmag;
 double dist;
 Vektor3d pos;
 for(i=0;getline(fp,zeile,200);)
  {
   if(*zeile==';' || *zeile==0) continue; //Kommentare und Leerzeilen ueberlesen
   if(!isdigit(*zeile)) {printf("Fehler in Tabelle: \"%s\"\n",zeile); continue;}
   //Format der Zeilen siehe Datei sterntabelle2.dat
   //sscanf(zeile,"%d \t%f \t%f \t%s \t%s", &nr,&mag,&absmag,nam1,sternname);
   s=parser(zeile,"%d",&nr);
   s=parser(s,"%f",&mag);
   s=parser(s,"%f",&absmag);
   s=parser(s,"%s",nam1);
   s=parser(s,"%s",sternname);
   s=parser(s,"%lf",&dist);
   float neuabsmag=mag+2.5*log10(PARSEC10QUAD/(dist*dist));
   if(!fastgleich(absmag,neuabsmag,0.2))
    {
     printf("%s: falsches absmag?  Tabelle: %f  berechnet: %f\n",sternname,absmag,neuabsmag);//test
     absmag=neuabsmag;
    }
   if(strncmp(sternname,"Sonne",5)==0)
    {
     pos.x=0; pos.z=1e-20;  pos.y = -dist;
     //printf("Sonnenabstand: %f\n",pos.y);//test
    }
   else
    {
     double ra,dek;
     //printf("sternname=\"%s\"\n",sternname);//test
     //printf("dist=%f\n",dist);//test
     s=parser(s,"%K",&dek);
     s=parser(s,"%R",&ra);
     sternedaten[i].rektaszension=ra; sternedaten[i].deklination=dek;
     polar_xyz_umrechnung(ra,dek,dist,pos);
     //printf("dist zurueckgerechnet: %f\n",sqrt(pos.x*pos.x+pos.y*pos.y+pos.z*pos.z));//test
    }
   //printf("%s %f %f pos=%f %f %f\n",sternname,mag,absmag,pos.x,pos.y,pos.z);//test
   sternedaten[i].set(sternname,absmag,mag);
   sternepos[i++]=pos;
  }
 anz_sterne=i;
 printf("%d Sterne von %s eingelesen\n",anz_sterne,name);//test
 
 fclose(fp);
}

int stern_schon_vorhanden(int imax,double rekt,double dekl,double mag)
{
 //TODO: d1, d2 und d3 optimieren, ev. Daten in sterntabelle2.dat korrigieren
 double d1=10.0*(ZWEIPI/360/3600); //max. Abweichung Winkelsekunden
 double d2=10.0*(ZWEIPI/24/3600); //max. Abweichung Sekunden im Stundenwinkel
 const double d3=0.5;
 for(int i=0;i<imax;i++)
  {
   if(fastgleich(sternedaten[i].rektaszension,rekt,d1) && fastgleich(sternedaten[i].deklination,dekl,d2)
      && fastgleich(sternedaten[i].mag,mag,d3))
    return i;//index des schon vorhandenen
  }
 return -1;//noch nicht vorhanden
}

void sterne_einlesen3(const char *quellname) //bsc5-Katalog einlesen
{
 FILE *fp=fopen(quellname,"r");
 if(fp==NULL) {printf("kann \"%s\" nicht finden.\n",quellname); return;}
 Vektor3d pos;
 Sterndata data;
 int n, i=anz_sterne;
 int anz_doppelt=0;//test
 for(n=1; eintrag_lesen(fp,data,false); n++)
  {
   //if(argflag['V']) printf("\n%d. Eintrag:\n",n);//test
   if(data.abstand!=0)
    {
     if(n==1851 || n==1852) //test
      {
       printf("n=%d name=\"%s\" rekt=%f dekl=%f\n",n,data.name,data.rektaszension,data.deklination);
      }
     int doppelt=stern_schon_vorhanden(i,data.rektaszension,data.deklination,data.mag);
     //TODO: Fehler suchen: z.B. "Alpha Centauri A" 2 mal als doppelt erkannt
     if(doppelt>=0)
      {
       anz_doppelt++;//test
       printf("%d. Eintrag schon vorhanden name(neu)=\"%s\" name(alt)=\"%s\"\n", //test
	      n,data.name,sternedaten[doppelt].name);//test
      }
     else
      {
       polar_xyz_umrechnung(data.rektaszension,data.deklination,data.abstand,pos);
       sternedaten[i].set(data.name,data.absmag,data.mag);
       sternepos[i++]=pos;
       if(i>=MAX_STERNE) {printf("zu wenig Speicher MAX_STERNE=%d\n",MAX_STERNE); break;}
      }
    }
  }
 printf("anz_doppelt=%d\n",anz_doppelt);//test
 fclose(fp);
 printf("Total %d Eintraege gelesen, davon %d verwendbar\n",n,i-anz_sterne);//test
 anz_sterne=i;
 printf("Total %d Sterne\n",anz_sterne);//test
}

static double vr=0,tr=0; //Geschwindigkeit und Zeit im Raumschiff
static double sra=0; //Zurueckgelegte Distanz von Raumschiff aus gesehen
static double ser=0; //Zurueckgelegte Distanz von Erde aus gesehen

double tanalfa_berechnen(Vektor3d& p,double v,double t)
{
 //Hoehe ueber xz-Ebene fuer Stern mit Position p berechnen
 //Berechnung von Erde aus gesehen, Version 2.9.19
 //v=Geschwindigkeit vom Raumschiff aus gesehen
 //Resultat=Tangens des Winkels vom Raumschiff aus gesehen
 double B=sqrt(p.x*p.x+p.z*p.z);
 double beta=sqrt(1-v*v/(C*C));
 //double te=t/beta; //Zeit auf Erde: groesser als im Raumschiff
 //double A=p.y-te*v; //te*v ist zurueckgelegte Distanz von Erde aus gesehen
 //                   //stimmt nur wenn v immer gleich war
 double A=p.y-ser; //ser ist aufsummierte zurueckgelegte Distanz von Erde aus gesehen
 return (A + v/C*sqrt(A*A+B*B))/(B*beta);
}

Vektor3d scheinbare_position(Vektor3d p,double v,double t,double *tanalfa)
{
 //wie tanalfa, aber direkt Vektor von scheinbarer Position zurueckgeben
 double B=sqrt(p.x*p.x+p.z*p.z);
 double beta=sqrt(1-v*v/(C*C));
 double A=p.y-ser; //ser ist aufsummierte zurueckgelegte Distanz von Erde aus gesehen
 p.y = (A + v/C*sqrt(A*A+B*B))/beta;
 *tanalfa = p.y/B;
 return p;
}

double helligkeit_radialkorr(double helligkeit,double v1) //v1=Geschw. auf uns zu
{
 helligkeit *= sqrt(1-v1*v1/(C*C))/(1-v1/C); //Formel fuer Photonen pro Sekunde
 helligkeit *= 1.0/sqrt((C-v1)/(C+v1));//test: Helligkeitszunahme durch Blauverschiebung?
 //(die beiden Formeln scheinen identisch zu sein)
 return helligkeit;
}

double magberechnung(int i,double v1,double D2)
{
 double helligkeit = pow(10.0,-0.4*sternedaten[i].absmag) * PARSEC10QUAD/D2;
 //double v1=(A/D)*vr; //Geschw. auf uns zu: cos(90Grad-alfa)*v
 helligkeit = helligkeit_radialkorr(helligkeit,v1);
 double mag = -2.5*log10(helligkeit);
 return mag;
}

/** alte Version von stern_zeichnen() **
void pixelmitte(double& x,double& y) //auf die Mitte eines Pixels justieren
{
 int ix=(int)((x-xmin)/DX+0.5);
 int iy=(int)((y-ymin)/DY+0.5);
 x=ix*DX+(xmin+0.5*DX);
 y=iy*DY+(ymin+0.5*DY);
}
void kleiner_kreis_gefuellt(double x0,double y0,double r)
{
 double x,y,r2=r*r;
 pixelmitte(x0,y0); //auf die Mitte eines Pixels justieren
 for(x=x0-r;x<x0+r+DX/2;x+=DX)
  glVertex2d(x,y0);
 for(y=y0-r;y<y0+r+DX/2;y+=DY)
  glVertex2d(x0,y);
 for(x=DX;x<=r;x+=DX)
  {
   double x2=x*x;
   for(y=DY; (y*y+x2) <= r2; y+=DY)
    {
     glVertex2d(x0+x,y0+y);
     glVertex2d(x0+x,y0-y);
     glVertex2d(x0-x,y0+y);
     glVertex2d(x0-x,y0-y);
    }
  }
}

void stern_zeichnen(double mag,double x,double y)
{
 const double GM=5; //Grenzmagnitude
 if(mag>=GM) //schwache Sterne nur als einzelner Punkt zeichnen
  {
   uchar h;
   //const double kontrast=0.5;//test
   //double he=255.0/pow(2.511886*kontrast,mag-3);
   //h=(int)(he+0.9);
   //if(h<50) h=40;//minimale Helligkeit damit man ueberhaupt was sieht
   float f=mag-GM;
   if(f>3) h=40;
   else if(f>2.5) h=60;
   else if(f>2.0) h=100;
   else if(f>1.5) h=140;
   else if(f>1.0) h=180;
   else if(f>0.5) h=220;
   else h=255;
   if(mag<10) printf("mag=%f f=%f h=%d\n",mag,f,h);//test
   glColor3ub(h,h,h);
   glVertex2d(x,y);
   //stat_mag_dunkel++;//test
  }
 else
  {
   glColor3ub(255,255,255);
   double r=(GM+1-mag)*0.25*DX; //TODO: werte ausprobieren
   kleiner_kreis_gefuellt(x,y,r);
   //stat_mag_hell++;//test
  }
}
**/

/** neue Version **/
void stern_zeichnen(double mag,double x,double y)
{
 const double GM=4; //Grenzmagnitude
 if(mag>=GM) //schwache Sterne nur als einzelner Punkt zeichnen
  {
   uchar h; //weiss wenn mag==GM, grau fuer mag>GM
   float f=mag-GM;
   if(f>3) h=40;
   else if(f>2.5) h=60;
   else if(f>2.0) h=100;
   else if(f>1.5) h=140;
   else if(f>1.0) h=180;
   else if(f>0.5) h=220;
   else h=255;
   glColor3ub(h,h,h);
   glVertex2d(x,y);
  }
 else
  {
   glEnd();
   glColor3ub(255,255,255);
   float r=(GM+0.25-mag)*1.0; //TODO: werte ausprobieren
   glEnable(GL_POINT_SMOOTH); //fuer runde Punkte
   glPointSize(r);
   glBegin(GL_POINTS);
   glVertex2d(x,y);
   glEnd();
   glDisable(GL_POINT_SMOOTH);
   glPointSize(1);
   glBegin(GL_POINTS);
  }
}
/**/

void zeichne_sterne()
{
 glColor3ub(255,255,255); // Farbe setzen, hier 255,255,255 RGB = WEISS
 glBegin(GL_POINTS); // GL einschalten auf Punkte-Modus
 Vektor3d p,ps;
 double tanalfa,x=0,y=0;
 for(int i=0;i<anz_sterne;i++)
  {
   p=sternepos[i];
   //tanalfa=tanalfa_berechnen(p,vr,tr);
   ps=scheinbare_position(p,vr,tr,&tanalfa);
   double A=ps.y;
   double D2=ps.x*ps.x+ps.y*ps.y+ps.z*ps.z, D=sqrt(D2);
   //if(strncmp(sternedaten[i].name,"Polar",5)==0)//test
   if(strncmp(sternedaten[i].name,"Aldebar",7)==0)//test
    glColor3ub(255,0,0); //test: rot markieren, TODO: Farbe in Sterndata definieren
   else if(strncmp(sternedaten[i].name,"Sirius",6)==0)//test
    glColor3ub(255,255,0); //test: gelb markieren
   if(fenst==FRONTFENSTER && tanalfa>0) //bei mehr als 0Grad ev. im Frontfenster sichtbar
    {
     //double B2=p.x*p.x+p.z*p.z, B=sqrt(B2);
     //double D2=B2*(tanalfa*tanalfa+1), D=sqrt(D2);
     //double A=B*tanalfa;
     //double skal=ymax*sqrt(2.0)/D;
     double skal=ymax/A;
     y=ps.z*skal;
     x=ps.x*skal;
     if(x>xmin && x<xmax && y>ymin && y<ymax) //im Fensterbereich sichtbar?
      {
       /*
       double helligkeit = pow(10.0,-0.4*sternedaten[i].absmag) * PARSEC10QUAD/D2;
       double B=sqrt(B2);
       //double v1=(tanalfa*B/D)*vr; //Geschw. auf uns zu: cos(90Grad-alfa)*v
       double v1=(A/D)*vr; //Geschw. auf uns zu: cos(90Grad-alfa)*v
       helligkeit = helligkeit_radialkorr(helligkeit,v1);
       double mag = -2.5*log10(helligkeit);
       */
       double mag=magberechnung(i,A/D*vr,D2);
       //if(v1==0 && !fastgleich(mag,sternedaten[i].mag,0.2))//test
       // {printf("%s: mag = %f  berechnet: %f  hellig=%g\n",sternedaten[i].name,sternedaten[i].mag,mag,helligkeit); sleep(1);}//test
       //if(strncmp(sternedaten[i].name,"Sirius",6)==0)//test
	  //printf("Sirius: helligk=%f mag=%f\n",helligkeit,mag);//test
       stern_zeichnen(mag,x,y);
      }
    }
   else if(fenst==RECHTSFENSTER && p.x>0)
    {
     //double B2=p.x*p.x+p.z*p.z,        B=sqrt(B2);
     //double D2=B2*(tanalfa*tanalfa+1), D=sqrt(D2);
     //double A=B*tanalfa;
     double skal=ymax/ps.x;
     y = ps.z*skal;
     x = -A*skal;
     if(x>xmin && x<xmax && y>ymin && y<ymax) //im Fensterbereich sichtbar?
      {
       double mag=magberechnung(i,A/D*vr,D2);
       //if(strncmp(sternedaten[i].name,"Sirius",6)==0)//test
	  //printf("Sirius: helligk=%f mag=%f\n",helligkeit,mag);//test
       stern_zeichnen(mag,x,y);
      }
    }
   else if(fenst==LINKSFENSTER && p.x<0)
    {
     //double A=ps.y;
     //double D2=ps.x*ps.x+ps.y*ps.y+ps.z*ps.z, D=sqrt(D2);
     double skal=ymax/(-ps.x);
     y = ps.z*skal;
     x = A*skal;
     if(x>xmin && x<xmax && y>ymin && y<ymax) //im Fensterbereich sichtbar?
      {
       double mag=magberechnung(i,A/D*vr,D2);
       //if(strncmp(sternedaten[i].name,"Sirius",6)==0)//test
	  //printf("Sirius: helligk=%f mag=%f\n",helligkeit,mag);//test
       stern_zeichnen(mag,x,y);
      }
    }
   else if(fenst==HINTERFENSTER && tanalfa<0)
    {
     //double A=ps.y;
     //double D2=ps.x*ps.x+ps.y*ps.y+ps.z*ps.z, D=sqrt(D2);
     double skal=ymax/A;
     y = ps.z*skal;
     x = -ps.x*skal;
     if(x>xmin && x<xmax && y>ymin && y<ymax) //im Fensterbereich sichtbar?
      {
       double mag=magberechnung(i,A/D*vr,D2);
       //if(strncmp(sternedaten[i].name,"Sirius",6)==0)//test
	  //printf("Sirius: helligk=%f mag=%f\n",helligkeit,mag);//test
       stern_zeichnen(mag,x,y);
      }
    }
   else if(fenst==OBENFENSTER && ps.z>0)
    {
     double skal=ymax/ps.z;
     y = -ps.y*skal;
     x = ps.x*skal;
     if(x>xmin && x<xmax && y>ymin && y<ymax) //im Fensterbereich sichtbar?
      {
       double mag=magberechnung(i,A/D*vr,D2);
       stern_zeichnen(mag,x,y);
      }
    }
   else if(fenst==UNTENFENSTER && ps.z<0)
    {
     double skal=ymax/(-ps.z);
     y = ps.y*skal;
     x = ps.x*skal;
     if(x>xmin && x<xmax && y>ymin && y<ymax) //im Fensterbereich sichtbar?
      {
       double mag=magberechnung(i,A/D*vr,D2);
       stern_zeichnen(mag,x,y);
      }
    }
   if(strncmp(sternedaten[i].name,"Aldebar",7)==0 //test
      || strncmp(sternedaten[i].name,"Sirius",6)==0)//test
    glColor3ub(255,255,255); //test danach wieder weiss
  }
 glEnd(); //GL ausschalten
 //printf("mag_fehler=%d\n",mag_fehler);//test
}

static int fadenflag=1;
#define BILDER_PRO_SEC 50 //?? wieviele sind es wirklich?
static int animflag=0, anim_i=0,anim_imax=0;
static double jahre_pro_sec=1.0;
void animation(int n);

void animation_start(int imax)
{
 anim_i=0; anim_imax=imax; animflag=1;
 printf("Animation gestartet\n");//test
 animation(0);
}

void animation(int n)
{
 if(n!=0) return;//falscher timer?
 ++anim_i;
 if(anim_imax>0 && (anim_i>=anim_imax || ser>=430)) //430 LJ von Erde aus gesehen fliegen
  {
   animflag=0; printf("Animation beendet.\n");
  }
 else
  {
   if(animflag==1) glutTimerFunc(1000.0/BILDER_PRO_SEC-1, animation, 0);
   //double dt=(1.0/BILDER_PRO_SEC); //1Jahr pro Sekunde simulieren
   double dt=(jahre_pro_sec/BILDER_PRO_SEC);
   tr=anim_i*dt;
   sra += dt*vr;
   double beta=sqrt(1-vr*vr/(C*C));
   //ser += (1.0/BILDER_PRO_SEC)/beta*vr;
   ser += (jahre_pro_sec/BILDER_PRO_SEC)/beta*vr;
   //glutPostRedisplay(); //schon in idle() gemacht TODO: hier waere besser?
   //mpause(1000/BILDER_PRO_SEC-3); //zeichnen braucht etwa 3ms ?
  }
}

void zeichne_koordinatenkreuz()
{
 if(fadenflag!=0)
  {
   glColor3ub(127,127,127); // Farbe setzen, grau
   glBegin(GL_LINES); // GL einschalten Modus: LINIE
   glVertex2f(xmin+xrand,0.0); // erst der x-wert (links), y=0
   glVertex2f(xmax-xrand,0.0); // dann Linie nach rechts ziehen
   glVertex2f(0.0,ymin); // y-Wert unten Mitte
   glVertex2f(0.0,ymax); // y nach oben hochziehen
   glEnd(); // fertig, GL ausschalten
  }
 textsize(9*DXS,12*DYS,"9x12");
 glColor3ub(190,190,190); //graue Schrift
 if(fenst==FRONTFENSTER)
  {
   if(fadenflag!=0) schrift(15*DX,0,"Polarstern");//test
   schrift(xmin+10*DX,ymax-30*DY,"Frontfenster");
  }
 else if(fenst==RECHTSFENSTER)
  schrift(xmin+10*DX,ymax-30*DY,"Rechtes Fenster");
 else if(fenst==LINKSFENSTER)
  schrift(xmin+10*DX,ymax-30*DY,"Linkes Fenster");
 else if(fenst==HINTERFENSTER)
  {
   schrift(xmin+10*DX,ymax-30*DY,"Hinteres Fenster");
   if(fadenflag!=0) schrift(30*DX,0,"Sonne");//test
  }
 else if(fenst==OBENFENSTER)
  schrift(xmin+10*DX,ymax-30*DY,"Oberes Fenster");
 else if(fenst==UNTENFENSTER)
  schrift(xmin+10*DX,ymax-30*DY,"Unteres Fenster");
 textsize(12*DXS,16*DYS,"12x16");
}

void status_anzeigen()
{
 char text[256];
 double x0=xmin+10*DX, y0=ymin+5*DY;
 glColor3ub(150,150,150); //graue Schrift
 sprintf(text,"v=%.3f*c  dist=%.3f Lichtjahre  tr=%.1f Jahre",vr,sra,tr);
 schrift(x0,y0,text);
 x0=100*DX;
 double te=tr/sqrt(1-vr*vr/(C*C));
 sprintf(text,"Von Erde aus gesehen: dist=%.3f LJ  t=%.1f J",ser,te);
 schrift(x0,y0,text);
}

void display(void)
{
 glClearColor(0, 0, 0, 0);
 glClear(GL_COLOR_BUFFER_BIT);
 glMatrixMode(GL_MODELVIEW);
 glLoadIdentity();
 glPushMatrix(); // GL_MODELVIEW is default
 glScalef(1.0/(xmax-xmin), 1.0/(ymax-ymin), 1.0);
 glTranslatef(-xmin, -ymin, 0.0);
 //if(animflag==1) animation();
 zeichne_sterne();
 zeichne_koordinatenkreuz();
 status_anzeigen();
 glPopMatrix();
 glutSwapBuffers();
}

/* Idle proc. Redisplays, if called. */
void idle(void)
{
 glutPostRedisplay();
}

#define PFEIL_LINKS 100
#define PFEIL_OBEN 101
#define PFEIL_RECHTS 102
#define PFEIL_UNTEN 103
#define PAGE_UP 104
#define PAGE_DOWN 105
#define KEY_HOME 106
#define KEY_END 107
#define KEY_INSERT 108

void spezial(int c,int x,int y) //Tastatur Spezialtasten, z.B. Pfeiltasten
{
 if(c==PFEIL_RECHTS)
  {if(fenst<4) fenst=(fenst+1)&3; else fenst=RECHTSFENSTER;}
 else if(c==PFEIL_LINKS)
  {if(fenst<4) fenst=(fenst-1)&3; else fenst=LINKSFENSTER;}
 else if(c==PFEIL_OBEN)
  {fenst = (fenst==UNTENFENSTER) ? FRONTFENSTER : OBENFENSTER;}
 else if(c==PFEIL_UNTEN)
  {fenst = (fenst==OBENFENSTER) ? FRONTFENSTER : UNTENFENSTER;}
 else if(c==PAGE_UP)//beschleunigen 
  {//TODO
   if(animflag==0) animation_start(0);
   if(vr<=0.8) vr+=0.1;//provi.
   else vr = 1.0 - (1.0-vr)/2;//provi.
   printf("vr=%f*c\n",vr);//test
  }
 else if(c==PAGE_DOWN) //abbremsen
  {//TODO
   if(vr>=0.1) vr-=0.1;//provi.
   else if(vr>=0.01) vr-=0.01;//provi.
   printf("vr=%f*c\n",vr);//test
  }
 else if(c==KEY_HOME) //Zeit schneller laufen lassen TODO
  {
   jahre_pro_sec *= 2;//provi.
  }
 else if(c==KEY_END) //Zeit langsamer laufen lassen
  {
   jahre_pro_sec *= 0.5;//provi.
  }
 else
  printf("special(c=%d,x=%d,y=%d)\n",c,x,y);//test
}

const char *hilfetext="\n\
Bedienung mit Tasten: (gross/klein egal)\n\
H = diese Hilfe\n\
Q = Programm verlassen\n\
F = Fadenkreuz ein/aus\n\
A = Animation starten/anhalten (Pause)\n\
S = Stoppen (Simulation abbrechen)\n\
R = Ruecksetzen auf Startposition\n\
Pfeiltasten: Wechsel auf Fenster links/rechts/oben/unten/hinten\n\
0-9: Geschwindigkeit setzen auf 0.1*c bis 0.9*c\n\
PgUp: Beschleunigen\n\
PgDn: Abbremsen (=Beschleunigung in Gegenrichtung)\n\
Home: Zeit schneller laufen lassen\n\
End: Zeit langsamer laufen lassen\n\
";

void key(unsigned char c, int x, int y)
{
 //if(c==27) exit(0); //mit ESC-Taste beenden
 c=toupper(c);
 if(c=='Q') exit(0); //oder mit q-Taste
 if(c=='?' || c=='H') printf("%s\n",hilfetext);
 else if(c>='0' && c<='9')
  {
   if(c=='9' && vr>0.89*C) {vr=C-(C-vr/C)*0.1;}
   else vr=(c-'0')*0.1*C;
   display();
   printf("vr=%f*C\n",vr/C);
  }
 else if(c=='F') {fadenflag ^= 1;} //Fadenkreuz ein/aus
 else if(c=='A') //Animation starten/anhalten
  {
   if(animflag==0)
    {
     animation_start(600*BILDER_PRO_SEC); //auf 10 Minuten begrenzen
     printf("Simulation gestartet\n");
     animation(0);
    }
   if(animflag==2)
    {
     animflag=1;
     printf("Simulation wird fortgesetzt\n");
     animation(0);
    }
   else
    {
     animflag=2; printf("Simulation angehalten\n");
    }
  }
 else if(c=='S') //Animation stoppen
  {
   animflag=0; printf("Simulation abgebrochen.\n");
  }
 else if(c=='R') //Animation ruecksetzen
  {
   animflag=0; printf("Rueckgesetzt auf Starposition und v=0 t=0\n");
   sra=ser=0;
   vr=0; tr=0;
  }
 else printf("key(c=%d='%c',x=%d,y=%d)\n",c,c,x,y);//test
}

/* Window reashape */
void reshape(int w, int h)
{
 printf("reshape(w=%d,h=%d)\n",w,h);//test
 glViewport(0, 0, w, h);
 glMatrixMode(GL_PROJECTION);
 glLoadIdentity();
 glOrtho(0, 1, 0, 1, -1, 1);
 glMatrixMode(GL_MODELVIEW);
}

void grafik_init(int br,int ho,int posx,int posy)
{
 glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE);
 glutInitWindowSize(br,ho);
 glutInitWindowPosition(posx,posy);
 glutCreateWindow("Raumflug-Simulator");

 /* Register GLUT callbacks. */
 glutDisplayFunc(display);
 glutKeyboardFunc(key);
 glutSpecialFunc(spezial);
 glutReshapeFunc(reshape);
 glutIdleFunc(idle);

 /* Init the GL state */
 glLineWidth(1.0);
}

int main(int argc, char **argv)
{
 int fensterbreite=BILDBREITE, fensterhoehe=BILDHOEHE, posx=BILDPOSX, posy=BILDPOSY;
 sterne_einlesen2("sterntabelle2.dat");
 sterne_einlesen3("bsc5.catalog");
 glutInit(&argc, argv);
 grafik_init(fensterbreite,fensterhoehe,posx,posy);
 glutMainLoop();
 return 0;
}
