/* elast.cc			letzte Aenderung: 14.3.2025 */
#define VERSION "Version 0.0"
/*

History:
14.3.2025       Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include <xtekplot1.h>

#define uchar uint8_t

//#define XMAX 1024
//#define YMAX  820
#define XMAX 1280
#define YMAX 854
#define TIEFE 24

#define SCHWARZAUFWEISS //auskommentieren fuer weiss auf schwarz

/************************* Vordeklarationen ***************************/
void stoss_simulieren(double t,double dt);

/************************* Globale Variablen **************************/
double g_xmin= 0.0, g_ymin=0.0, g_xmax=1.5, g_ymax=1.0;
int anzstoss=0, anzwandstoss=0;

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
static int vflag=0;

void setargflags(const char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   c &= 127; argflag[c]=1;
   if(c=='V') vflag++;
  }
}

/****************************** Klassen *******************************/
class Klotz
{
public:
 double px,py,breite,hoehe; //Position und Groesse
 double vx; //Geschwindigkeit in x-Richtung
 double masse;
 Klotz() {px=0.062; py=0.102; breite=0.05; hoehe=0.05; vx=0; masse=1;}
 Klotz(double x0,double y0,double br,double ho) {px=x0; py=y0; breite=br; hoehe=ho; vx=0; masse=1;}
 void init(double x0,double y0,double br,double ho) {px=x0; py=y0; breite=br; hoehe=ho; vx=0; masse=1;}
 void setpos(double x0,double y0) {px=x0; py=y0;}
 void setvx(double v) {vx=v;}
 void setsize(double br,double ho) {breite=br; hoehe=ho;}
 void add(double dx,double dy) {px+=dx; py+=dy;}
 void neupos(double dt) {px += dt*vx;}
 //void setmasse(double ma) {masse=ma; breite=hoehe=0.05*sqrt(masse);} //sqrt=Quadratwurzel
 void setmasse(double ma) {masse=ma; breite=hoehe=0.05*cbrt(masse);} //cbrt=Kubikwurzel
};

static Klotz boden(g_xmin, g_ymin+0.05, g_xmax-g_xmin, 0.05);
static Klotz wand(g_xmin+0.01, g_ymin+0.1, 0.05, g_ymax-(g_ymin+0.1));
static Klotz klotz1,klotz2;

void startpos()
{
 klotz1.setpos(0.062, 0.102);
 klotz1.add(0.5, 0);
 klotz1.setvx(0.0);
 klotz2.setpos(0.062, 0.102);
 klotz2.add(1.0, 0);
 klotz2.setvx(-0.1);
 anzstoss=anzwandstoss=0;
}

void wprint(const char *str,int anz)
{
 static int vorher=0;
 if(anz!=vorher)
  {
   vorher=anz;
   char text[80];
   sprintf(text,str,anz);
   //TODO
   double pi=anz/sqrt(klotz2.masse/klotz1.masse);//test
   printf("%s  pi=%f\n",text,pi);//provi.
   
  }
}

/************************* Menu Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}
void m_para();

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 quellname[0]=zielname[0]=0;
 //FILE *fp1,*fp2;
 int i,j=0,c;
 int breite,hoehe,tiefe,visklasse;
 if(argc>0)
  for(j=0,i=1;i<argc;i++)
   {if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
    else if(++j==1) strcpy(quellname,argv[i]);
    else if(j==2) strcpy(zielname,argv[i]);
   }
 if(argflag['?'] || j>MAXARG)
  {printf("elast  %s\n",VERSION);
   printf("Anwendung: elast [Quelle] [Ziel]\n");
   exit(0);
  }
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 setsize(breite,hoehe,tiefe);
 setmenu(2,"File","Einstellungen");
 setmenu(2,"Exit","Parameter ...",&menu_exit,&m_para);
 inital(g_xmin,g_ymin,g_xmax,g_ymax); /* Grafikfenster oeffnen */

#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss (default ist weiss auf schwarz):
 if(TIEFE==24)
  {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
 else
  {screenclear(1); color(0);}
#endif

 //Hintergrundbild zeichnen:
 double x0=g_xmin,y0=g_ymin;
 double dx=0.01; //Abstand von Wand vom linken Rand
 double dy=0.05; //Abstand von Boden von unten
 double dx2=0.05; //Dicke der Wand
 double dy2=0.05; //Dicke der Bodens
 drawbox(x0+dx, y0+dy+dy2, x0+dx+dx2, g_ymax); //Wand zeichnen
 drawbox(x0+dx, y0+dy, g_xmax, y0+dy+dy2); //Boden zeichnen
 term_refresh();

 //Anfangsbedingungen setzen:
 startpos();
 
 double t, dt=1.0/64; //dt = ca. Bildwiderholrate
 for(t=0; exitflag==0 && waitmenu(0)==0; t+=dt)
  {
   //printf("t=%g\n",t);//test
   stoss_simulieren(t,dt);
   waitBOF();		//auf Ende des Bildaufbaus warten
  }

 term_exit();
 return 0;
}/* ende von main */

void refresh()
{
 inital_new();
#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss (default ist weiss auf schwarz):
 if(TIEFE==24)
  {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
 else
  {screenclear(1); color(0);}
#endif
 rgbcolor(0,0,0); //Farbe schwarz
 drawbox(wand.px, wand.py, wand.px+wand.breite, wand.py+wand.hoehe);
 drawbox(boden.px, boden.py, boden.px+boden.breite, boden.py+boden.hoehe);
 drawbox(klotz1.px, klotz1.py, klotz1.px+klotz1.breite, klotz1.py+klotz1.hoehe);
 drawbox(klotz2.px, klotz2.py, klotz2.px+klotz2.breite, klotz2.py+klotz2.hoehe);
 wprint("%d",anzstoss);
 term_refresh();
}

void m_para()
{
 startpos();
 int ok;
 double m1=klotz1.masse, m2=klotz2.masse;
 double p1=klotz1.px, p2=klotz2.px;
 double v1=klotz1.vx, v2= -klotz2.vx;
 ok=requester_input(6,"Masse1 (kleiner Klotz)","%lf","%lf",&m1,
		    "Masse2 (grosser Klotz)","%lf","%lf\n",&m2,
		    "Pisition1","%lf","%lf",&p1,
		    "Pisition2","%lf","%lf\n",&p2,
		    "Start v1","%lf","%lf",&v1,
		    "Start v2","%lf","%lf",&v2);
 if(ok)
  {
   klotz1.setmasse(m1); klotz2.setmasse(m2);
   klotz1.px=p1; klotz2.px= p2;
   klotz1.vx=v1; klotz2.vx= -v2;
  }
 refresh();
}

bool stoss_erkennung(double t,double dt)
{
 bool flag=false;
 if(klotz2.px <= klotz1.px+klotz1.breite)
  {//Stoss zwischen klotz1 und klotz2 erkannt
   double m1=klotz1.masse, m2=klotz2.masse, v1=klotz1.vx,  v2=klotz2.vx;
   //printf("Stoss bei t = %g\n",t);//test
   //printf(" m1=%g m2=%g v1=%f v2=%f\n",m1,m2,v1,v2);//test
   klotz1.vx = (m1*v1+m2*(2*v2-v1))/(m1+m2);
   klotz2.vx = (m2*v2+m1*(2*v1-v2))/(m1+m2);
   //printf(" nach Stoss: v1=%f v2=%f\n",klotz1.vx, klotz2.vx);//test
   //if(v1>100 || v2>100) exitflag=1;//test
   anzstoss++;
  }
 if(klotz1.px < wand.px+wand.breite+0.002)
  {//Stoss zwischen klotz1 und wand erkannt
   //printf("Stoss mit Wand bei t = %g\n",t);//test
   if(klotz1.vx < 0)   klotz1.vx = -klotz1.vx;
   flag=true;
   //printf(" v1 = %f\n",klotz1.vx);//test
   anzstoss++;
   anzwandstoss++;
  }
 return flag;
}

void stoss_simulieren_alt(double t,double dt)
{
 bool stoss=stoss_erkennung(t,dt);
 //vorherige Position loeschen:
 inital_new();
 rgbcolor(255,255,255); //Farbe weiss
 drawbox(klotz1.px, klotz1.py, klotz1.px+klotz1.breite, klotz1.py+klotz1.hoehe);
 drawbox(klotz2.px, klotz2.py, klotz2.px+klotz2.breite, klotz2.py+klotz2.hoehe);
 klotz1.neupos(dt);
 klotz2.neupos(dt);
 //neue Position zeichnen:
 rgbcolor(0,0,0); //Farbe schwarz
 drawbox(klotz1.px, klotz1.py, klotz1.px+klotz1.breite, klotz1.py+klotz1.hoehe);
 drawbox(klotz2.px, klotz2.py, klotz2.px+klotz2.breite, klotz2.py+klotz2.hoehe);
 if(stoss) //Bei Stoss mit Wand auch Wand neu zeichnen
  drawbox(wand.px, wand.py, wand.px+wand.breite, wand.py+wand.hoehe);
 wprint("%d",anzstoss);
 term_refresh();
}

void stoss_simulieren(double t,double dt)
{
 Klotz vorher1=klotz1, vorher2=klotz2;
 const int N=1024;
 double ddt=dt/N;
 bool stoss=false;
 for(int i=0;i<N;i++)
  {
   if(stoss_erkennung(t,dt)) stoss=true;
   klotz1.neupos(ddt);
   klotz2.neupos(ddt);
  }
 //vorherige Position loeschen:
 inital_new();
 rgbcolor(255,255,255); //Farbe weiss
 drawbox(vorher1.px, vorher1.py, vorher1.px+vorher1.breite, vorher1.py+vorher1.hoehe);
 drawbox(vorher2.px, vorher2.py, vorher2.px+vorher2.breite, vorher2.py+vorher2.hoehe);
 //neue Position zeichnen:
 rgbcolor(0,0,0); //Farbe schwarz
 drawbox(klotz1.px, klotz1.py, klotz1.px+klotz1.breite, klotz1.py+klotz1.hoehe);
 drawbox(klotz2.px, klotz2.py, klotz2.px+klotz2.breite, klotz2.py+klotz2.hoehe);
 if(stoss) //Bei Stoss mit Wand auch Wand neu zeichnen
  drawbox(wand.px, wand.py, wand.px+wand.breite, wand.py+wand.hoehe);
 wprint("%d",anzstoss);
 term_refresh();
}
