/* suchebiber.cc		letzte Aenderung: 13.9.2017 */
#define VERSION "Version 0.3"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

Fleissiger Biber:
 Suche nach der Turingmaschine mit Z Zustaenden, die am laengste laeuft,
 aber nicht unendlich lang.
 Gestartet wird mit einem Band mit lauter Nullen. Es sind  nur die
 Zahlen 0 und 1 auf dem Band erlaubt.

Konzeptioneller Fehler:
 Ein Biber der moeglichst viele Einsen schreibt ist nicht das
 gleiche wie ein Biber der moeglichst viele Schritte macht.
 Beispiel: mit Z=3 moeglichst viele Einsen: 6  dazu gebrauchte Schritte: 13 bis 20
                   moeglichst viele Schritte: 5 Einsen, 21 Schritte


History:
Datum      Vers
10.9.2017       Erstellung aus biber.cc 0.3

*/

#define BAND_DARSTELLEN  //bei Z>=5 auskommentieren
#define ESC_MARKIERUNGEN //markiere aktuelle Position farbig, zuletzt gschriebenes fett
//#define LOOPTEST //Testen ob in einer unendlichen Schlaufe, und dann abbrechen
//#define DEBUG  //Testausdrucke fuer Fehlersuche (bisher die meisten mit //test auskommentiert)
#define UNBEKANNTE_BIBER_DRUCKEN

// nur eine der beiden Moeglichkeiten nicht auskommentieren:
//#define VIELE_SCHRITTE  //sucht nach moeglichst vielen Schritten
#define VIELE_EINSEN    //sucht nach moeglichst vielen Einsen

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "dateiklasse.cc"

/************************* Vordeklarationen ***************************/
typedef unsigned char uchar;
typedef unsigned char uint8_t;
typedef unsigned long long uint64_t;

/************************* Globale Variablen **************************/
int errnum=0;
#define BANDVOLL 1
#define LOOPUNENDLICH 2

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(const char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Kleinkram ********************************/

/************** Klassen und Hauptteil des Programms *******************/
#define SMAX 2  //Maximale Anzahl Symbole (bisher auf 4 beschraenkt)
#define ZMAX 6  //maximale Anzahl Zustaende, ein fleissiger Biber mit mehr als 6 Zustaenden ist zwar zu kompliziert,
                //aber fuer andere Turingmaschinen sinnvoll (z.B. Addierer)
//#define MAXBAND 100000 //Laenge des Bandes
#define MAXBAND 500000 //Laenge des Bandes (sollte fast unendlich sein)
#define BANDMITTE (MAXBAND/2)

const char *zustand_name(int i)
{
 static char str[8];
 if(i==ZMAX) return "Halt";
 if(i<=24) {str[0] = (i>=7) ? i-7+'I' : 'A'+i; str[1]=0;}
#if(ZMAX>25)
 else sprintf(str,"Z%d",i);
#endif
 return str;
}

#define A 0
#define B 1
#define C 2
#define D 3
#define E 4
#define F 5

#define HALT ZMAX

int zustand_einlesen(const char *str)
{  //Zustaende mussen mit 'A' 'B' ... 'Y' ohne 'H', oder Z0 ... Z99 bezeichnet sein, 'H' fuer Halt
 int zustand=0;
 char c = *str++;
 if(c=='H') return HALT; //Haltezustand (Nummer ZMAX in aktueller Programmversion)
 if(c>='A' && c<='G') zustand = c-'A';
 else if(c>='I' && c<='Y') zustand = c-1-'A';
 else if(c=='Z')
  {sscanf(str,"%d",&zustand);} // Z0 entspricht Zustand 'A' und bekommt Nummer 0
 return zustand; // ZMAX fuer Halt oder Zahl 0 ... ZMAX-1
}

class Band
{
 uchar feld[MAXBAND];
public:
 uint pos,lastpos;
 uint posmin,posmax;
 uint symbol_setz_j;
 bool errflag;
 Band() {init(); symbol_setz_j=pos;}
 void init();
 uchar& operator[](uint i) {return feld[i];}
 void einsen_setzen(uint u); //provi. fuer Voreinstellungen auf dem Band
 void symbol_setzen(uchar u,bool alleflag=false); //fuer Voreinstellungen auf dem Band
 uchar read() {return feld[pos];}
 void write(uchar neuezahl,uchar richtung,uchar neuerzustand);
 uint einsen_zaehlen();
 bool istleer();
};

static Band band;

void Band::init()
{
 lastpos=pos=BANDMITTE; //in der Mitte des unendlichen Bandes starten
 posmax=pos+1;
 posmin=pos-1;
 for(uint i=0;i<MAXBAND;i++) feld[i]=0;//mit leerem Band starten
 errflag=false;
 //printf("Band::init() gemacht\n");//test
}

void Band::symbol_setzen(uchar u,bool alleflag)
{
 feld[symbol_setz_j++] = u;
 if(symbol_setz_j==MAXBAND) symbol_setz_j=0;
 if(alleflag)
  while(symbol_setz_j!=pos)
   {
    feld[symbol_setz_j++] = u;
    if(symbol_setz_j==MAXBAND) symbol_setz_j=0;
   }
}

void Band::einsen_setzen(uint u) //provi.
{
 int i=pos;
 while(u!=0)
  {
   feld[i++] = (u&1);
   u >>= 1;
   posmax++;
  }
}

uint Band::einsen_zaehlen()
{
 uint n=0;
 for(uint i=posmin;i<=posmax;i++)
  if(feld[i]==1) n++;
 return n;
}

bool Band::istleer()
{
 for(uint i=posmin;i<=posmax;i++)
  if(feld[i]!=0) return false;
 return true;
}

#define RECHTS 1
#define LINKS  0

class Eintrag
{
public:
 uchar schreibwert,richtung,neuerzustand; //schreibwert muss im Bereich 0 bis SMAX-1 liegen
 void set(uchar s,uchar r,uchar z) {schreibwert=s; richtung=r; neuerzustand=z;}
};

class Biber
{
 bool gueltig(); //einige Gueltigkeitstest juer beliebiges zmax
public:
 int zmax; //Anzahl moegliche Zustaende
 //uint8_t smax; //Anzahl moegliche Symbole
 Eintrag tabelle[ZMAX*SMAX]; //Index ist Zustand*AnzahlSymbole + gelesene Zahl
 int zustand; //aktueller Zustand als Zahl, 0='A', 1='B'... , ZMAX=Halt
 Biber() {init(1); /*smax=2;*/}
 void init(int z);
 void setprog(int zust,int zahl,int neuezahl,int richtung,int neuerzustand)
      {
       tabelle[zust*SMAX+zahl].set(neuezahl,richtung,neuerzustand);
      }
 bool step(); //false wenn Halt erreicht
 bool gueltig2(); //fuer zmax==2
 bool gueltig3(); //fuer zmax==3
 bool gueltig4(); //fuer zmax==4
 bool gueltig5(); //fuer zmax==5
 bool gueltig6(); //fuer zmax==6
 void testprint_tabelle();
 int testlauf(uint max);
};

void Biber::init(int z)
{
 zmax=z;
 zustand=0; //es wird mit Zustand A gestartet
}

//static uint maxschritte[ZMAX+1]={0, 1, 6, 21, 107, 0, 0}; //Gesicherte Werte (0 = noch nicht gesichert)
//static uint maxeinsen[ZMAX+1] = {0, 1, 4,  6,  13, 4098, 0}; //Gesicherte Werte Anzahl geschriebene Einsen
static uint maxschritte[ZMAX+1]={0, 1, 6, 21, 107, 47176870, 0}; //provisorisch
static uint maxeinsen[ZMAX+1] = {0, 1, 4,  6,  13, 4098, 0}; //provisorisch

int Biber::testlauf(uint max)
{
 uint schritte=0;
 band.init();
 uint startpos=band.pos;
 bool aschlaufe=true;//auf Schlaufe durch A pruefen
 bool maxtest=true; //wenn noch nicht alle Zustaende erreicht: pruefen auf Maximale Anzahl Schritte oder Einsen fuer zmax-1
 bool tab[zmax]; for(int i=C;i<zmax;i++) tab[zmax]=false; //Tabelle fuer schon besuchte Zustaende
 zustand=A;
 while(aschlaufe)
  {
   if(step()==false) return schritte;
   if(++schritte==max || band.errflag) return 0; //unklar ob nicht anhaltend oder Rekordkandidat
   tab[zustand]=true; //Buchhaltung ueber erreichte Zustaende
   //auf unendlich laufend pruefen:
   if(zustand==A)
    {
     if(band.istleer()) return -1;
     if(band.read()==0)
      {//Schlaufen die immer wieder durch A gehen pruefen
       if(band.pos>startpos && band.pos-startpos == schritte) return -1;//ewig nach rechts laufend
       aschlaufe=false;
      }
    }
   if(maxtest)
    {
     if(schritte > maxschritte[zmax-1] || band.einsen_zaehlen() > maxeinsen[zmax-1])
      {
       for(int i=zmax;--i>=C;)            // Wenn ein Zustand noch nicht erreicht, aber schon die maximale
	{if(tab[i]==false) return false;} // Anzahl Schritte oder Einsen fuer zmax-1 ueberschritten, dann laeuft er ewig.
       maxtest=false; //Alle Zustaende erreicht: dieser Test nicht weiter noetig
      }
    }
   //TODO: weitere Tests auf unendlich laufend
  }
 while(true) //wie erste Schlaufe aber ohne Test auf aschlaufe
  {
   if(step()==false) return schritte;
   if(++schritte==max || band.errflag) return 0; //unklar ob nicht anhaltend oder Rekordkandidat
   tab[zustand]=true; //Buchhaltung ueber erreichte Zustaende
   //auf unendlich laufend pruefen:
   if(zustand==A && band.istleer()) return -1; //sicher ewig laufend
   //if(band.istleer()) return -1;//sehr warscheinlich ewig laufend oder equivalente Variant mit bei entsprechendem Zustand beginnend
   if(maxtest)
    {
     if(schritte > maxschritte[zmax-1] || band.einsen_zaehlen() > maxeinsen[zmax-1])
      {
       for(int i=zmax;--i>=C;)            // Wenn ein Zustand noch nicht erreicht, aber schon die maximale
	{if(tab[i]==false) return false;} // Anzahl Schritte oder Einsen fuer zmax-1 ueberschritten, dann laeuft er ewig.
       maxtest=false; //Alle Zustaende erreicht: dieser Test nicht weiter noetig
      }
    }
   //TODO: weitere Tests auf unendlich laufend
  }
 return 0;
}

void Biber::testprint_tabelle()
{
 for(int i=0;i<zmax;i++)
  for(int j=0;j<2;j++)
   {
    Eintrag *e= &tabelle[i*SMAX+j];
    printf("(%c%d %d%c%c)\n", 'A'+i, j,
	   e->schreibwert, (e->richtung==RECHTS)?'R':'L', (e->neuerzustand>=zmax)?'H':'A'+e->neuerzustand);
   }
}

bool Biber::gueltig() //Tests die mit jedem zmax gehen sollten
{
 bool haltflag=false;
 int imax=zmax*SMAX;
 for(int i=0;i<imax;i++)
  {
   if(tabelle[i].neuerzustand==zmax)
    {
     if(tabelle[i].richtung!=0) return false; //Links und Halt oder Rechts und Halt ist equivalent
     if(tabelle[i].schreibwert==0) return false; //eine 1 schreiben ergibt besseren Biber
     haltflag=true;
    }
  }
 if(haltflag==false) return false; //kein HALT vorhanden
 for(int i=0;i<zmax;i++)   // Suche fuer jeden Zustand i
  {
   int n=0;
   for(int j=0;j<zmax;j++) // ob er von Zustand j erreichbar ist. 
    if(j!=i)
     {
      if(tabelle[j*SMAX+0].neuerzustand==i || tabelle[j*SMAX+1].neuerzustand==i)
       {n=1; break;}
     }
   if(n==0) return false; //nicht erreichbarer Zustand
  }
 int i;
 for(i=0;i<B*SMAX+1;i++)
  {
   int nz=tabelle[i].neuerzustand;
   if(nz!=zmax && nz>=C) break;
  }
 if(i==B*SMAX+1) //bis hier wurde noch nicht zu einem Zustand >= C gesprungen
  {int nz=tabelle[i].neuerzustand;
   if(nz!=zmax && nz>C) return false; //diese Varianten waeren equivalent
  }
 return true;
}

bool Biber::gueltig2()
{
 Eintrag *e = &tabelle[B*SMAX+0]; //B0 wird immer nach dem 1.Schritt erreicht
 if(e->richtung==RECHTS) return false; //wuerde endlos nach rechts laufen
 return gueltig();
}

bool Biber::gueltig3()
{
 Eintrag *e = &tabelle[B*SMAX+0]; //B0 wird immer nach dem 1.Schritt erreicht
 if(e->neuerzustand == zmax) return false; //wenn Halt schon erreicht kein optimaler Biber
 if(e->richtung==RECHTS) //wenn B0 nach rechts geht
  {
   if(e->neuerzustand!=C) return false; //wenn mit (A01RB) beginnend wuerde er so endlos nach rechts laufen
   Eintrag *e2 = &tabelle[C*SMAX+0]; //C0 wird nach dem 2.Schritt erreicht wenn B0 nach rechts geht
   if(e2->richtung==RECHTS) return false; //so wuerde er endlos nach rechts laufen
  }
 else //(e->richtung==LINKS)  im 2.Schritt nach Links gegangen
  {
   int z = e->neuerzustand;
   Eintrag *e2 = &tabelle[z*SMAX+1]; //A1,B1,oder C1 wird nach dem 2.Schritt erreicht wenn B0 nach links geht
   if(e2->neuerzustand >= zmax) return false; //wenn Halt schon erreicht kein optimaler Biber
   if(e->schreibwert==0 && e2->schreibwert==0) return false; //so waere das Band wieder leer
  }
 return gueltig();
}

bool Biber::gueltig4()
{
 Eintrag *e = &tabelle[B*SMAX+0]; //B0 wird immer nach dem 1.Schritt erreicht
 if(e->neuerzustand > C) return false; //diese Varianten waeren equivalent (oder Halt wuerde schon Stoppen)
 if(e->richtung==RECHTS) //wenn B0 nach rechts geht
  {
   if(e->neuerzustand!=C) return false; //wenn mit (A01RB) beginnend wuerde er so endlos nach rechts laufen
   Eintrag *e2 = &tabelle[C*SMAX+0]; //C0 wird nach dem 2.Schritt erreicht wenn B0 nach rechts geht
   if(e2->neuerzustand > D) return false; //diese Varianten waeren equivalent (oder Halt wuerde schon Stoppen)
   if(e2->richtung==RECHTS) //wenn C0 nach rechts geht
    {
     if(e2->neuerzustand!=D) return false; //bisher immer nach rechts: zwingend nach D gehen
     Eintrag *e3 = &tabelle[D*SMAX+0]; //bisher immer nach rechts gegangen wird D0 erreicht
#ifdef DEBUG
     if(e3->richtung==RECHTS)
	{testprint_tabelle(); printf("so wuerde ewig nach rechts gelaufen werden\n");}//test
#endif
     if(e3->richtung==RECHTS) return false; //wenn E0 auch nach rechts geht --> ewig rechts
     if(e3->neuerzustand==zmax) return false; //wenn E0 nach Halt geht --> zu schnell gestoppt
    }
  }
 else //(e->richtung==LINKS)  im 2.Schritt nach Links gegangen
  {
   int z = e->neuerzustand;
   Eintrag *e2 = &tabelle[z*SMAX+1]; //A1,B1,oder C1 wird nach dem 2.Schritt erreicht wenn B0 nach links geht
   if(e2->neuerzustand > D) return false; //diese Varianten waeren equivalent (oder Halt wuerde schon Stoppen)
   if(e->schreibwert==0 && e2->schreibwert==0) return false; //so waere das Band wieder leer
  }
 return gueltig();
}

bool Biber::gueltig5()
{
 Eintrag *e = &tabelle[B*SMAX+0]; //B0 wird immer nach dem 1.Schritt erreicht
 if(e->neuerzustand > C) return false; //diese Varianten waeren equivalent (oder Halt wuerde schon Stoppen)
 if(e->richtung==RECHTS) //wenn B0 nach rechts geht
  {
   if(e->neuerzustand!=C) return false; //wenn mit (A01RB) beginnend wuerde er so endlos nach rechts laufen
   Eintrag *e2 = &tabelle[C*SMAX+0]; //C0 wird nach dem 2.Schritt erreicht wenn B0 nach rechts geht
   if(e2->neuerzustand > D) return false; //diese Varianten waeren equivalent (oder Halt wuerde schon Stoppen)
   if(e2->richtung==RECHTS) //wenn C0 nach rechts geht
    {
     if(e2->neuerzustand!=D) return false; //bisher immer nach rechts: nach D gehen (nach E waere equivalent)
     Eintrag *e3 = &tabelle[D*SMAX+0]; //bisher immer nach rechts gegangen wird D0 erreicht
     if(e3->richtung==RECHTS) //wenn D0 nach rechts geht
      {
       if(e3->neuerzustand!=E) return false; //bisher immer nach rechts: zwingend nach E gehen
       Eintrag *e4 = &tabelle[E*SMAX+0]; //bisher immer nach rechts gegangen wird E0 erreicht
#ifdef DEBUG
       if(e4->richtung==RECHTS)
	{testprint_tabelle(); printf("so wuerde ewig nach rechts gelaufen werden\n");}//test
#endif
       if(e4->richtung==RECHTS) return false; //wenn E0 auch nach rechts geht --> ewig rechts
       if(e4->neuerzustand>=zmax) return false; //wenn E0 nach Halt geht --> zu schnell gestoppt
      }
    }
  }
 else //(e->richtung==LINKS)  im 2.Schritt nach Links gegangen
  {
   int z = e->neuerzustand;
   Eintrag *e2 = &tabelle[z*SMAX+1]; //A1,B1,oder C1 wird nach dem 2.Schritt erreicht wenn B0 nach links geht
   if(e2->neuerzustand > D) return false; //diese Varianten waeren equivalent (oder Halt wuerde schon Stoppen)
   if(e->schreibwert==0 && e2->schreibwert==0) return false; //so waere das Band wieder leer
  }
 //TODO
 return gueltig();
}

bool Biber::gueltig6() //TODO: diese provisorische Variante waere vermutlich zu langsam
{
 Eintrag *e = &tabelle[B*SMAX+0]; //B0 wird immer nach dem 1.Schritt erreicht
 if(e->neuerzustand > C) return false; //diese Varianten waeren equivalent (oder Halt wuerde schon Stoppen)
 if(e->richtung==RECHTS) //wenn B0 nach rechts geht
  {
   if(e->neuerzustand!=C) return false; //wenn mit (A01RB B0XRC) beginnend wuerde er so endlos nach rechts laufen
   Eintrag *e2 = &tabelle[C*SMAX+0]; //C0 wird nach dem 2.Schritt erreicht wenn B0 nach rechts geht
   if(e2->neuerzustand > D) return false; //diese Varianten waeren equivalent (oder Halt wuerde schon Stoppen)
   if(e2->richtung==RECHTS) //wenn C0 nach rechts geht
    {
     if(e2->neuerzustand!=D) return false; //wenn mit (A01RB B0XRC C0XRC) beginnend wuerde er so endlos nach rechts laufen
     Eintrag *e3 = &tabelle[D*SMAX+0]; //D0 wird nach dem 3.Schritt erreicht wenn immer nach rechts gegangen
     if(e3->neuerzustand > E) return false; //diese Varianten waeren equivalent (oder Halt wuerde schon Stoppen)
     if(e3->richtung==RECHTS) //wenn D0 nach rechts geht
      {
       if(e3->neuerzustand!=E) return false; //bisher immer nach rechts: nach D gehen (nach E waere equivalent)
       Eintrag *e4 = &tabelle[E*SMAX+0]; //D0 wird nach dem 4.Schritt erreicht wenn immer nach rechts gegangen
       if(e4->richtung==RECHTS) //wenn D0 nach rechts geht
	{
	 if(e4->neuerzustand!=F) return false; //bisher immer nach rechts: zwingend nach F gehen
	 Eintrag *e5 = &tabelle[F*SMAX+0]; //bisher immer nach rechts gegangen wird F0 erreicht
#ifdef DEBUG
	 if(e5->richtung==RECHTS)
	  {testprint_tabelle(); printf("so wuerde ewig nach rechts gelaufen werden\n");}//test
#endif
	 if(e5->richtung==RECHTS) return false; //wenn F0 auch nach rechts geht --> ewig rechts
	 if(e5->neuerzustand>=zmax) return false; //wenn F0 nach Halt geht --> zu schnell gestoppt
	}
      }
    }
  }
 else //(e->richtung==LINKS)  im 2.Schritt nach Links gegangen
  {
   int z = e->neuerzustand;
   Eintrag *e2 = &tabelle[z*SMAX+1]; //A1,B1,oder C1 wird nach dem 2.Schritt erreicht wenn B0 nach links geht
   if(e2->neuerzustand > D) return false; //diese Varianten waeren equivalent (oder Halt wuerde schon Stoppen)
   if(e->schreibwert==0 && e2->schreibwert==0) return false; //so waere das Band wieder leer
  }
 //TODO
 return gueltig();
}

bool Biber::step()
{
 if(zustand>=zmax) return false; //bei HALT nichts machen
 int zahl=band.read();
 int i=zustand*SMAX+zahl;
 int neuezahl = tabelle[i].schreibwert;
 int richtung = tabelle[i].richtung;
 //printf("neuezahl=%d, richtung=%d\n",neuezahl,richtung);//test
 zustand = tabelle[i].neuerzustand;
 band.write(neuezahl,richtung,zustand);
 return true;
}

void Band::write(uchar neuezahl,uchar richtung,uchar zustand)
{
 feld[pos]=neuezahl;
 lastpos=pos;
 if(richtung==LINKS)
   {
    if(pos==0) {/*fprintf(stderr,"Band zu kurz, linker Rand erreicht.\n"); errnum=BANDVOLL;*/ errflag=true;}
    else if(--pos < posmin) posmin=pos;
   }
 else
   {
    if(pos==MAXBAND-1) {/*fprintf(stderr,"Band zu kurz, rechter Rand erreicht.\n"); errnum=BANDVOLL;*/ errflag=true;}
    else if(++pos > posmax) posmax=pos;
   }
#ifdef LOOPTEST
 if(zustand==0 && feld[pos]==0) //wieder im Startzustand
   {
    uint i;
    for(i=posmin;i<=posmax;i++)
      {if(feld[i]!=0) break;}
    if(i>posmax) {errnum=LOOPUNENDLICH; errflag=true;}
   }
#endif
}

uchar symbol_name2nr(char c)
{
 if(c=='0' || c=='1') return c-'0';
 if(c=='_') return 2;
 if(c=='+') return 3;
 return 3;//provi. (nur Symbole 0 1 _ + erlaubt)
}

char symbol_nr2name(uchar u)
{
 if(u<=1) return u+'0';
 if(u==2) return '_';
 if(u==3) return '+';
 return u-2+'a';//provi. (nur Symbole 0 1 _ + erlaubt)
}

void print_pos_markiert(int c)
{
 c=symbol_nr2name(c);
#ifdef ESC_MARKIERUNGEN
 printf("\033[33m%c\033[0m",c); //Position gelb markieren ([31=rot, [35=magenta, [33=gelb)
#else
 if(c==0) printf("o");
 else if(c==1) printf("i"); //Position mit o fuer 0 und i fuer 1 markieren
 else printf("<%c>",c);     //Position mit < > markieren
#endif
}

void print_letztes_markiert(int c)
{
 c=symbol_nr2name(c);
#ifdef ESC_MARKIERUNGEN
 printf("\033[1m%c\033[0m",c); //Letztes fett markieren
#else
 if(c==0) printf("O");
 else if(c==1) printf("I");} //statt fett mit O fuer 0 und I fuer 1 markieren
 else printf("(%c)",c);      //statt fett mit ( ) markieren
#endif
}

/************************* Hauptprogramm ******************************/
static Biber biber;
static Biber fleissigster_biber;

static uint gefundene_biber=0; //Anzahl anhaltende Turingmaschinen
static uint fleissige_anzahl=0;
static uint fleissigste_anzahl=0;
static uint nicht_anhaltend_anzahl=0;
static uint unklar_anzahl=0;

//Resultat-Tabelle:
//                                 Z = 0  1  2  3  4  5  6
static int fleissige_einsen[ZMAX+1] = {0, 1, 4, 5, 5, 5, 5}; //Anzahl produzierte Einsen
static int fleissige_schritte[ZMAX+1]={0, 1, 4, 5,13,14,15}; //Anzahl Schritte die Fleissigster Biber braucht
                                                             //(je mehr er braucht umso fleissiger ist er)

// je nach Suche maximale Einsen oder maximale Schritte werden andere Werte erhalten:
//                                   Z = 0  1  2  3   4    5         6 
//static int fleissige_einsen[ZMAX+1] = {0, 1, 4, 6,  13,  4098,     4099};  //bisher berechnete Resultate (viele Einsen)
//static int fleissige_schritte[ZMAX+1]={0, 1, 6, 21, 107, 47176870, 47176871};  //bisher berechnete Resultate (viele Schritte)

#ifdef VIELE_SCHRITTE
bool ist_fleissig(int schritte) //ist der gefundene Biber ein fleissiger?
{
 gefundene_biber++; //es ist Ein Biber, also anhaltende Turingmaschine, aber vielleicht kein fleissiger
 int z=biber.zmax;
 if(schritte < fleissige_schritte[z]) return false; //hauptsaechlich nach Bibern mit moeglichst vielen Schritten suchen
 if(schritte > fleissige_schritte[z])
  {
   fleissige_schritte[z] = schritte; fleissige_anzahl=0; //Maximaler Wert suchen
   int n=band.einsen_zaehlen();
   if(n > fleissige_einsen[z]) {fleissige_einsen[z]=n; fleissigste_anzahl=0;} //suche maximale Einsen unter den Bibern mit moeglichst vielen Schritten 
   if(n==fleissige_einsen[z])
    {fleissigste_anzahl++; //als fleissigste diejenigen mit auch noch vielen Einsen
     fleissigster_biber=biber;
     printf("bisher fleissigster Biber:\n"); biber.testprint_tabelle(); //test
     printf(" Anzahl Einsen = %d  Schritte = %d\n", n, schritte);//test
    }
   else //test
    {
     printf("wahrscheinlich fleissiger Biber:\n"); biber.testprint_tabelle(); //test
     printf(" Anzahl Einsen = %d  Schritte = %d\n", n, schritte);//test
    }
  }
 fleissige_anzahl++;
 return true;
}
#endif

#ifdef VIELE_EINSEN
//Minimale Anzahl Schritte die ein Fleissiger Biber braucht:
static int minimale_schritte[ZMAX+1] ={0, 1, 4, 5,13,14,15};  //provi.

bool ist_fleissig(int schritte) //ist der gefundene Biber ein fleissiger?
{
 gefundene_biber++; //es ist Ein Biber, also anhaltende Turingmaschine, aber vielleicht kein fleissiger
 int z=biber.zmax;
 if(schritte < minimale_schritte[z]) return false; //wenn nicht die minimale Anzahl Schritte gemacht ist es kein fleissiger
 int n=band.einsen_zaehlen();
 if(n < fleissige_einsen[z]) return false; //nur einer der die maximale Anzahl 1en schreibt als "Fleissigen Biber" betrachten
 if(n > fleissige_einsen[z])          {fleissige_einsen[z] = n; fleissige_anzahl=0;} //Maximaler Wert suchen
 fleissige_anzahl++;
 if(schritte > fleissige_schritte[z]) {fleissige_schritte[z] = schritte; fleissigste_anzahl=0;} //Maximaler Wert suchen
 if(schritte==fleissige_schritte[z])
  {
   fleissigster_biber=biber;
   fleissigste_anzahl++;
   printf("bisher fleissigster Biber:\n"); biber.testprint_tabelle(); //test
   printf(" Anzahl Einsen = %d  Schritte = %d\n", n, schritte);//test
  }
 else if(fleissige_anzahl==1)
  {
   printf("Wahrscheinlich Fleissiger Biber:\n"); biber.testprint_tabelle(); //test
   printf(" Anzahl Einsen = %d  Schritte = %d\n", n, schritte);//test
  }
 return true;
}
#endif

uint64_t bibersuche2()
{
 const int zmax=2;
 uint64_t anzahl=0;
 int ka,ra,nza; //Zahler fuer Schreibwert, Richtung, NeuerZustand
 int kb,rb,nzb,kb1,rb1,nzb1;
 biber.setprog(A,0, 1,RECHTS,B); //ist einzige relevante Moeglichkeit (LINKS waere equivalent)
 for(ka=0;ka<2;ka++)  //A1 Schreibwert
  for(ra=0;ra<2;ra++) //A1 Richtung
   for(nza=0;nza<=zmax;nza++) //A1 NeuerZustand.  0 ist A, 1 ist B, ... zmax ist HALT
    {
     biber.setprog(A,1, ka,ra,nza); //setprog(Zustand,Lesewert, Schreibwert,Richtung,NeuerZustand)
     for(kb=0;kb<2;kb++)  //Schreibwert
      for(rb=0;rb<2;rb++) //Richtung
       for(nzb=0;nzb<=zmax;nzb++) //0 ist A, 1 ist B, ... zmax ist HALT
	  {
	   biber.setprog(B,0, kb,rb,nzb);
	   for(kb1=0;kb1<2;kb1++)  //Schreibwert
	    for(rb1=0;rb1<2;rb1++) //Richtung
	     for(nzb1=0;nzb1<=zmax;nzb1++) //0 ist A, 1 ist B, ... zmax ist HALT
	      {
	       biber.setprog(B,1, kb1,rb1,nzb1);
	       // Biber untersuchen:
	       if(biber.gueltig2())
		{
		 int schritte=biber.testlauf(100);
		 if(schritte>0) //Biber gefunden
		   {if(ist_fleissig(schritte)) anzahl++;} //wahrscheinlich ein fleissiger Biber gefunden
		 else if(schritte==0) //noch unbekannt ob Fleissiger Biber oder nicht anhaltend
		   {
		    anzahl++;
#ifdef UNBEKANNTE_BIBER_DRUCKEN
		    unklar_anzahl++;
		    if(unklar_anzahl<=3) //nur erste 3 unbekannte Biber drucken
		     {
		      printf("Unbekannt ob anhaltend oder nicht:\n");
		      biber.testprint_tabelle();
		     }
#endif
		   }
		 else if(schritte<0) {nicht_anhaltend_anzahl++;} //eindeutig nicht anhaltend
		}
	       // Ende Biber untersuchen
	      }
	  }
    }
 return anzahl;
}

uint64_t bibersuche3()
{
 const int zmax=3;
 uint64_t anzahl=0;
 int ka,ra,nza; //Zahler fuer Schreibwert, Richtung, NeuerZustand
 int kb,rb,nzb,kb1,rb1,nzb1;
 int kc,rc,nzc,kc1,rc1,nzc1;
 biber.setprog(A,0, 1,RECHTS,B); //ist einzige relevante Moeglichkeit (LINKS oder C waeren equivalent)
 for(ka=0;ka<2;ka++)  //A1 Schreibwert
  for(ra=0;ra<2;ra++) //A1 Richtung
   for(nza=0;nza<=zmax;nza++) //A1 NeuerZustand.  0 ist A, 1 ist B, ... zmax ist HALT
    {
     biber.setprog(A,1, ka,ra,nza); //setprog(Zustand,Lesewert, Schreibwert,Richtung,NeuerZustand)
     for(kb=0;kb<2;kb++)  //Schreibwert
      for(rb=0;rb<2;rb++) //Richtung
       for(nzb=0;nzb<=zmax;nzb++) //0 ist A, 1 ist B, ... zmax ist HALT
	  {
	   biber.setprog(B,0, kb,rb,nzb);
	   for(kb1=0;kb1<2;kb1++)  //Schreibwert
	    for(rb1=0;rb1<2;rb1++) //Richtung
	     for(nzb1=0;nzb1<=zmax;nzb1++) //0 ist A, 1 ist B, ... zmax ist HALT
	      {
	       biber.setprog(B,1, kb1,rb1,nzb1);
	       for(kc=0;kc<2;kc++)  //Schreibwert
		for(rc=0;rc<2;rc++) //Richtung
		 for(nzc=0;nzc<=zmax;nzc++) //0 ist A, 1 ist B, ... zmax ist HALT
		  {
		   biber.setprog(C,0, kc,rc,nzc);
		   for(kc1=0;kc1<2;kc1++)  //Schreibwert
		    for(rc1=0;rc1<2;rc1++) //Richtung
		     for(nzc1=0;nzc1<=zmax;nzc1++) //0 ist A, 1 ist B, ... zmax ist HALT
		      {
		       biber.setprog(C,1, kc1,rc1,nzc1);
		       // Biber untersuchen:
		       if(biber.gueltig3())
			{
			 int schritte=biber.testlauf(200);
			 if(schritte>0) //Biber gefunden
			  {if(ist_fleissig(schritte)) anzahl++;} //wahrscheinlich ein fleissiger Biber gefunden
			 else if(schritte==0) //noch unbekannt ob Fleissiger Biber oder nicht anhaltend
			  {
			   anzahl++;
#ifdef UNBEKANNTE_BIBER_DRUCKEN
			   unklar_anzahl++;
			   if(unklar_anzahl<=3) //nur erste 3 unbekannte Biber drucken
			    {
			     printf("Unbekannt ob anhaltend oder nicht:\n");
			     biber.testprint_tabelle();
			    }
#endif
			  }
			 else if(schritte<0) {nicht_anhaltend_anzahl++;} //eindeutig nicht anhaltend
			}
		       // Ende Biber untersuchen
		      }
		  }
	      }
	  }
    }
 return anzahl;
}

uint64_t bibersuche4()
{
 const int zmax=4;
 uint64_t anzahl=0;
 int ka,ra,nza; //Zahler fuer Schreibwert, Richtung, NeuerZustand
 int kb,rb,nzb,kb1,rb1,nzb1;
 int kc,rc,nzc,kc1,rc1,nzc1;
 int kd,rd,nzd,kd1,rd1,nzd1;
 biber.setprog(A,0, 1,RECHTS,B); //ist einzige relevante Moeglichkeit (LINKS oder C waeren equivalent)
 for(ka=0;ka<2;ka++)  //A1 Schreibwert
  for(ra=0;ra<2;ra++) //A1 Richtung
   for(nza=0;nza<=zmax;nza++) //A1 NeuerZustand.  0 ist A, 1 ist B, ... zmax ist HALT
    {
     biber.setprog(A,1, ka,ra,nza); //setprog(Zustand,Lesewert, Schreibwert,Richtung,NeuerZustand)
     for(kb=0;kb<2;kb++)  //Schreibwert
      for(rb=0;rb<2;rb++) //Richtung
       for(nzb=0;nzb<=zmax;nzb++) //0 ist A, 1 ist B, ... zmax ist HALT
	{
	 biber.setprog(B,0, kb,rb,nzb);
	 for(kb1=0;kb1<2;kb1++)  //Schreibwert
	  for(rb1=0;rb1<2;rb1++) //Richtung
	   for(nzb1=0;nzb1<=zmax;nzb1++) //0 ist A, 1 ist B, ... zmax ist HALT
	    {
	     biber.setprog(B,1, kb1,rb1,nzb1);
	     for(kc=0;kc<2;kc++)  //Schreibwert
	      for(rc=0;rc<2;rc++) //Richtung
	       for(nzc=0;nzc<=zmax;nzc++) //0 ist A, 1 ist B, ... zmax ist HALT
		{
		 biber.setprog(C,0, kc,rc,nzc);
		 for(kc1=0;kc1<2;kc1++)  //Schreibwert
		  for(rc1=0;rc1<2;rc1++) //Richtung
		   for(nzc1=0;nzc1<=zmax;nzc1++) //0 ist A, 1 ist B, ... zmax ist HALT
		    {
		     biber.setprog(C,1, kc1,rc1,nzc1);
		     for(kd=0;kd<2;kd++)  //Schreibwert
		      for(rd=0;rd<2;rd++) //Richtung
		       for(nzd=0;nzd<=zmax;nzd++) //0 ist A, 1 ist B, ... zmax ist HALT
			{
			 biber.setprog(D,0, kd,rd,nzd);
			 for(kd1=0;kd1<2;kd1++)  //Schreibwert
			  for(rd1=0;rd1<2;rd1++) //Richtung
			   for(nzd1=0;nzd1<=zmax;nzd1++) //0 ist A, 1 ist B, ... zmax ist HALT
			    {
			     biber.setprog(D,1, kd1,rd1,nzd1);
			     // Biber untersuchen:
			     if(biber.gueltig4())
			      {
			       int schritte=biber.testlauf(1000);
			       if(schritte>0) //Biber gefunden
				{if(ist_fleissig(schritte)) anzahl++;} //wahrscheinlich ein fleissiger Biber gefunden
			       else if(schritte==0) //noch unbekannt ob Fleissiger Biber oder nicht anhaltend
				{
				 anzahl++;
#ifdef UNBEKANNTE_BIBER_DRUCKEN
				 unklar_anzahl++;
				 if(unklar_anzahl<=3) //nur erste 3 unbekannte Biber drucken
				  {
				   printf("Unbekannt ob anhaltend oder nicht:\n");
				   biber.testprint_tabelle();
				  }
#endif
				}
			       else if(schritte<0) {nicht_anhaltend_anzahl++;} //eindeutig nicht anhaltend
			      }
			     // Ende Biber untersuchen
			    }
			}
		    }
		}
	    }
	}
    }
 return anzahl;
}

uint64_t bibersuche5()
{
 const int zmax=5;
 uint64_t anzahl=0;
 int ka,ra,nza; //Zahler fuer Schreibwert, Richtung, NeuerZustand
 int kb,rb,nzb,kb1,rb1,nzb1;
 int kc,rc,nzc,kc1,rc1,nzc1;
 int kd,rd,nzd,kd1,rd1,nzd1;
 int ke,re,nze,ke1,re1,nze1;
 biber.setprog(A,0, 1,RECHTS,B); //ist einzige relevante Moeglichkeit (LINKS oder C waeren equivalent)
 for(ka=0;ka<2;ka++)  //A1 Schreibwert
  for(ra=0;ra<2;ra++) //A1 Richtung
   for(nza=0;nza<=zmax;nza++) //A1 NeuerZustand.  0 ist A, 1 ist B, ... zmax ist HALT
    {
     biber.setprog(A,1, ka,ra,nza); //setprog(Zustand,Lesewert, Schreibwert,Richtung,NeuerZustand)
     if(argflag['V']) printf("setprog(A,1, %d,%d,%d)\n",ka,ra,nza);//test
     for(kb=0;kb<2;kb++)  //Schreibwert
      for(rb=0;rb<2;rb++) //Richtung
       for(nzb=0;nzb<=zmax;nzb++) //0 ist A, 1 ist B, ... zmax ist HALT
	{
	 biber.setprog(B,0, kb,rb,nzb);
	 //printf("setprog(B,0, %d,%d,%d)\n",kb,rb,nzb);//test
	 for(kb1=0;kb1<2;kb1++)  //Schreibwert
	  for(rb1=0;rb1<2;rb1++) //Richtung
	   for(nzb1=0;nzb1<=zmax;nzb1++) //0 ist A, 1 ist B, ... zmax ist HALT
	    {
	     biber.setprog(B,1, kb1,rb1,nzb1);
	     for(kc=0;kc<2;kc++)  //Schreibwert
	      for(rc=0;rc<2;rc++) //Richtung
	       for(nzc=0;nzc<=zmax;nzc++) //0 ist A, 1 ist B, ... zmax ist HALT
		{
		 biber.setprog(C,0, kc,rc,nzc);
		 //printf("setprog(C,0, %d,%d,%d)\n",kc,rc,nzc);//test
		 for(kc1=0;kc1<2;kc1++)  //Schreibwert
		  for(rc1=0;rc1<2;rc1++) //Richtung
		   for(nzc1=0;nzc1<=zmax;nzc1++) //0 ist A, 1 ist B, ... zmax ist HALT
		    {
		     biber.setprog(C,1, kc1,rc1,nzc1);
		     for(kd=0;kd<2;kd++)  //Schreibwert
		      for(rd=0;rd<2;rd++) //Richtung
		       for(nzd=0;nzd<=zmax;nzd++) //0 ist A, 1 ist B, ... zmax ist HALT
			{
			 biber.setprog(D,0, kd,rd,nzd);
			 for(kd1=0;kd1<2;kd1++)  //Schreibwert
			  for(rd1=0;rd1<2;rd1++) //Richtung
			   for(nzd1=0;nzd1<=zmax;nzd1++) //0 ist A, 1 ist B, ... zmax ist HALT
			    {
			     biber.setprog(D,1, kd1,rd1,nzd1);
			     for(ke=0;ke<2;ke++)  //Schreibwert
			      for(re=0;re<2;re++) //Richtung
			       for(nze=0;nze<=zmax;nze++) //0 ist A, 1 ist B, ... zmax ist HALT
				{
				 biber.setprog(E,0, ke,re,nze);
				 for(ke1=0;ke1<2;ke1++)  //Schreibwert
				  for(re1=0;re1<2;re1++) //Richtung
				   for(nze1=0;nze1<=zmax;nze1++) //0 ist A, 1 ist B, ... zmax ist HALT
				    {
				     biber.setprog(E,1, ke1,re1,nze1);
				     // Biber untersuchen:
				     if(biber.gueltig5())
				      {
				       int schritte=biber.testlauf(100000000);
				       if(schritte>0) //Biber gefunden
					{if(ist_fleissig(schritte)) anzahl++;} //wahrscheinlich ein fleissiger Biber gefunden
				       else if(schritte==0) //noch unbekannt ob Fleissiger Biber oder nicht anhaltend
					{
					 anzahl++;
#ifdef UNBEKANNTE_BIBER_DRUCKEN
					 unklar_anzahl++;
					 if(unklar_anzahl<=3) //nur erste 3 unbekannte Biber drucken
					  {
					   printf("Unbekannt ob anhaltend oder nicht:\n");
					   biber.testprint_tabelle();
					  }
#endif
					}
				       else if(schritte<0) {nicht_anhaltend_anzahl++;} //eindeutig nicht anhaltend
				      }
				     // Ende Biber untersuchen
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
 return anzahl;
}

uint64_t bibersuche6()  //TODO: mit dieser provisorischen Version wird er viel zu lange haben um alle durchzurechnen
{
 const int zmax=5;
 uint64_t anzahl=0;
 int ka,ra,nza; //Zahler fuer Schreibwert, Richtung, NeuerZustand
 int kb,rb,nzb,kb1,rb1,nzb1;
 int kc,rc,nzc,kc1,rc1,nzc1;
 int kd,rd,nzd,kd1,rd1,nzd1;
 int ke,re,nze,ke1,re1,nze1;
 int kf,rf,nzf,kf1,rf1,nzf1;
 biber.setprog(A,0, 1,RECHTS,B); //ist einzige relevante Moeglichkeit (LINKS oder C waeren equivalent)
 for(ka=0;ka<2;ka++)  //A1 Schreibwert
  for(ra=0;ra<2;ra++) //A1 Richtung
   for(nza=0;nza<=zmax;nza++) //A1 NeuerZustand.  0 ist A, 1 ist B, ... zmax ist HALT
    {
     biber.setprog(A,1, ka,ra,nza); //setprog(Zustand,Lesewert, Schreibwert,Richtung,NeuerZustand)
     if(argflag['V']) printf("setprog(A,1, %d,%d,%d)\n",ka,ra,nza);//test
     for(kb=0;kb<2;kb++)  //Schreibwert
      for(rb=0;rb<2;rb++) //Richtung
       for(nzb=0;nzb<=zmax;nzb++) //0 ist A, 1 ist B, ... zmax ist HALT
	{
	 biber.setprog(B,0, kb,rb,nzb);
	 //printf("setprog(B,0, %d,%d,%d)\n",kb,rb,nzb);//test
	 for(kb1=0;kb1<2;kb1++)  //Schreibwert
	  for(rb1=0;rb1<2;rb1++) //Richtung
	   for(nzb1=0;nzb1<=zmax;nzb1++) //0 ist A, 1 ist B, ... zmax ist HALT
	    {
	     biber.setprog(B,1, kb1,rb1,nzb1);
	     for(kc=0;kc<2;kc++)  //Schreibwert
	      for(rc=0;rc<2;rc++) //Richtung
	       for(nzc=0;nzc<=zmax;nzc++) //0 ist A, 1 ist B, ... zmax ist HALT
		{
		 biber.setprog(C,0, kc,rc,nzc);
		 //printf("setprog(C,0, %d,%d,%d)\n",kc,rc,nzc);//test
		 for(kc1=0;kc1<2;kc1++)  //Schreibwert
		  for(rc1=0;rc1<2;rc1++) //Richtung
		   for(nzc1=0;nzc1<=zmax;nzc1++) //0 ist A, 1 ist B, ... zmax ist HALT
		    {
		     biber.setprog(C,1, kc1,rc1,nzc1);
		     for(kd=0;kd<2;kd++)  //Schreibwert
		      for(rd=0;rd<2;rd++) //Richtung
		       for(nzd=0;nzd<=zmax;nzd++) //0 ist A, 1 ist B, ... zmax ist HALT
			{
			 biber.setprog(D,0, kd,rd,nzd);
			 for(kd1=0;kd1<2;kd1++)  //Schreibwert
			  for(rd1=0;rd1<2;rd1++) //Richtung
			   for(nzd1=0;nzd1<=zmax;nzd1++) //0 ist A, 1 ist B, ... zmax ist HALT
			    {
			     biber.setprog(D,1, kd1,rd1,nzd1);
			     for(ke=0;ke<2;ke++)  //Schreibwert
			      for(re=0;re<2;re++) //Richtung
			       for(nze=0;nze<=zmax;nze++) //0 ist A, 1 ist B, ... zmax ist HALT
				{
				 biber.setprog(E,0, ke,re,nze);
				 for(ke1=0;ke1<2;ke1++)  //Schreibwert
				  for(re1=0;re1<2;re1++) //Richtung
				   for(nze1=0;nze1<=zmax;nze1++) //0 ist A, 1 ist B, ... zmax ist HALT
				    {
				     biber.setprog(E,1, ke1,re1,nze1);
				     for(kf=0;kf<2;kf++)  //Schreibwert
				      for(rf=0;rf<2;rf++) //Richtung
				       for(nzf=0;nzf<=zmax;nzf++) //0 ist A, 1 ist B, ... zmax ist HALT
					{
					 biber.setprog(F,0, kf,rf,nzf);
					 for(kf1=0;kf1<2;kf1++)  //Schreibwert
					  for(rf1=0;rf1<2;rf1++) //Richtung
					   for(nzf1=0;nzf1<=zmax;nzf1++) //0 ist A, 1 ist B, ... zmax ist HALT
					    {
					     biber.setprog(F,1, kf1,rf1,nzf1);
					     // Biber untersuchen:
					     if(biber.gueltig6())
					      {
					       //int schritte=biber.testlauf(400000000); //provi.
					       int schritte=biber.testlauf(47200000); //provi.
					       if(schritte>0) //Biber gefunden
						{if(ist_fleissig(schritte)) anzahl++;} //wahrscheinlich ein fleissiger Biber gefunden
					       else if(schritte==0) //noch unbekannt ob Fleissiger Biber oder nicht anhaltend
						{
						 anzahl++;
#ifdef UNBEKANNTE_BIBER_DRUCKEN
						 unklar_anzahl++;
						 if(unklar_anzahl<=3) //nur erste 3 unbekannte Biber drucken
						  {
						   printf("Unbekannt ob anhaltend oder nicht:\n");
						   biber.testprint_tabelle();
						  }
#endif
						}
					       else if(schritte<0) {nicht_anhaltend_anzahl++;} //eindeutig nicht anhaltend
					      }
					     // Ende Biber untersuchen
					    }
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
 return anzahl;
}

uint64_t bibersuche(int zmax)
{
 biber.zmax=zmax;
 gefundene_biber=0;
 fleissige_anzahl=0;
 fleissigste_anzahl=0;
 nicht_anhaltend_anzahl=0;
 unklar_anzahl=0;
 biber.setprog(A,0, 1,RECHTS,B); //ist einzige relevante Moeglichkeit (LINKS waere equivalent)
 if(zmax==2) return bibersuche2();
 if(zmax==3) return bibersuche3();
 if(zmax==4) return bibersuche4();
 if(zmax==5) return bibersuche5();
 if(zmax==6) return bibersuche6();
 return 0;
}

int main(int argc,char *argv[])
{
 char zielname[80];
 int64_t i;
 int j,c;
 int z=2;
 if(sizeof(uint64_t)<8) {printf("falsche groesse von uint64_t: %d\n",sizeof(uint64_t)); exit(0);}
 zielname[0]=0;
 
 for(j=0,i=1;i<argc;i++)
  {if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
   else if(++j==1)
      {if(isdigit(*argv[i])) sscanf(argv[i],"%d",&z);
       else strcpy(zielname,argv[i]);
      }
   else if(j==2) strcpy(zielname,argv[i]);
  }
 
 if(argflag['?'] || j>MAXARG || z<2 || z>ZMAX)
	{printf("biber  %s\n",VERSION);
	 printf("Anwendung: suchebiber [-Flags] [Z] [zieldatei.tm]\n");
	 printf("  fuer Z sind bisher nur Zahlen von 2 bis %d moeglich.\n",ZMAX);
	 printf("  Flags: v=verbose (Testausdrucke)\n");
	 printf("sizeof(long)=%d sizeof(long long)=%d (uint64_t)=%d\n",sizeof(long),sizeof(long long),sizeof(uint64_t));//test
	 exit(0);
	}

 Datei datei(zielname); //TODO: Resultat in Datei speichern
 if(zielname[0]!=0)
  {
   if(datei.open_read()) {fprintf(stderr,"Datei '%s' schon vorhanden.\n",zielname); exit(0);}
  }
 uint64_t anzahl=pow(4*(z+1), 2*z);
 printf("Theoret.  Anzahl  Turingmaschinen mit %d Zustaenden: %Lu\n",z,anzahl);
 anzahl=pow(4*(z+1), 2*z-1);
 printf("Theoretisch moegliche Anzahl mit (A01RB) beginnend: %Lu\n",anzahl);

 /***********************  Erster Suchdurchlauf ********************************/
 #ifdef VIELE_SCHRITTE
 printf("\nNach fleissigen Bibern, die moeglichst viele Schritten machen, suchen...\n");
 #endif
 #ifdef VIELE_EINSEN
 printf("\nNach fleissigen Bibern, die moeglichst viel Einsen erzeugen, suchen...\n");
 #endif
 
 anzahl=bibersuche(z);
 
 if(anzahl==0) {printf("Fehler: anzahl=0\n"); exit(0);}
 printf("als anhaltend identifizierte Turingmaschinen mit %d Zustaenden: %u\n", z, gefundene_biber);

 printf("Anzahl moeglicherweise fleissige Biber: %Lu\n",anzahl);
 ulong giga=1e9;
 if(anzahl>giga) printf("also etwa %Lu Milliarden\n",anzahl/giga);
 else if(anzahl>1000000) printf("also etwa %Lu Millionen\n",anzahl/1000000);
 
 printf("als  nicht anhaltend identifiziert: %u\n", nicht_anhaltend_anzahl);
 printf("nicht klar ob anhaltend oder nicht: %u\n", unklar_anzahl);
 if(fleissige_anzahl>1) printf("Eventuell gibt es %d Fleissige Biber\n",fleissige_anzahl);
 
 printf("Fleissigster Biber:\n");
 fleissigster_biber.testprint_tabelle();
 if(fleissigste_anzahl>1) printf("Eventuell gibt es %d Fleissigste Biber\n",fleissigste_anzahl);

 printf("Anzahl Einsen: %d  Anzahl Schritte: %d\n",fleissige_einsen[z],fleissige_schritte[z]);//test

#ifdef VIELE_SCHRITTE
 printf("Es wurde nach moeglichst vielen Schritten gesucht.\n");//test
#endif
#ifdef VIELE_EINSEN
 printf("Es wurde nach moeglichst vielen Einsen gesucht.\n");//test
#endif

 /***********************  Zweiter Suchdurchlauf *******************************/
 #ifdef VIELE_SCHRITTE
 printf("\nZweiter Durchlauf, nach moeglichst vielen Schritten suchen...\n");
 #endif
 #ifdef VIELE_EINSEN
 printf("\nZweiter Durchlauf, nach moeglichst vielen Einsen suchen...\n");
 #endif
 
 anzahl=bibersuche(z); //zweiter Durchlauf mit vom ersten Lauf aktualisierter Tabelle

 printf("als anhaltend identifizierte Turingmaschinen mit %d Zustaenden: %u\n", z, gefundene_biber);

 printf("Anzahl moeglicherweise fleissige Biber: %Lu\n",anzahl);
 if(anzahl>giga) printf("also etwa %Lu Milliarden\n",anzahl/giga);
 else if(anzahl>1000000) printf("also etwa %Lu Millionen\n",anzahl/1000000);
 
 printf("als  nicht anhaltend identifiziert: %u\n", nicht_anhaltend_anzahl);
 printf("nicht klar ob anhaltend oder nicht: %u\n", unklar_anzahl);
 if(fleissige_anzahl>1) printf("Es gibt %d Fleissige Biber\n",fleissige_anzahl);
 
 if(fleissigste_anzahl>1)
  printf("Es gibt %d Fleissigste Biber\neiner davon ist:\n",fleissigste_anzahl);
 else
  printf("Der einzige Fleissigste Biber ist:\n");
 fleissigster_biber.testprint_tabelle();
 
 printf("Anzahl Einsen: %d  Anzahl Schritte: %d\n",fleissige_einsen[z],fleissige_schritte[z]);//test

#ifdef VIELE_SCHRITTE
 printf("Es wurde nach moeglichst vielen Schritten gesucht.\n");//test
#endif
#ifdef VIELE_EINSEN
 printf("Es wurde nach moeglichst vielen Einsen gesucht.\n");//test
#endif
 
 //TODO: alle Fleissigste Biber anzeigen und eventuell in Datei speichern

 return 0;
}/* ende von main */
