;Beispiel einer Turingmaschine: Biber mit 5 Zustaenden und 4 Symbolen

;Es wird angenommen dass mit einem leeren Band begonnen wird (nicht mit
;Nullen gefuelltes wie bei Bibern mit nur 2 Symbolen).
;Die Maschine beginnt mit der Binaerzahl n=1 und berechnet dann 2^(n+1)-1,
;indem es n bis auf -1 runterzaehlt und in einer Schlaufe das Resultat
;aufbaut. Also eine Binaerzahl bestehend aus n+1 Einsen.
;Dann wird das Ergebnis um 2 Einsen erweitert und als neue Startzahl
;benuzt. Also neues n = 2^(n+1)*4-1.
;Dann noch ein dritter grosser Schlaufendurchlauf.
;Theoretisch somit: n=1 --> n=15 --> n=262143 (18 Einsen) --> ca. 1.6*10^78913 (ca. 262144 Einsen)
; Beobachtet: 1 --> 1111 --> 37 Einsen geschrieben

S=4  ;Anzahl Symbole
Z=5  ;Anzahl Zustaende

A 0 _ R A  ;unbenutzt wenn mit leerem Band begonnen wird
A 1 1 R A  ;schon vorhandene 1 ueberlesen
A _ 1 R B  ;Startzahl 1 schreiben
A + + R B  ;wird ab dem zweiten grossen Schlaufendurchlauf erreicht

B 0 0 R B  ;unbenutzt
B 1 1 R B  ;schon vorhandene 1 ueberlesen
B _ _ R C  ;Leerstelle zwischen Startzahl und Resultat
B + 1 L HALT  ;nach dem dritten grossen Schlaufendurchlauf

C 0 0 R C  ;unbenutzt
C 1 1 R C  ;schon vorhandene 1 ueberlesen
;C 1 1 L D  ;test: Kette nicht verlaengern um Endverhalten zu pruefen
C _ 1 L D  ;eine 1 ans Resultat anhaengen
C + + R C  ;unbenutzt

D 0 0 L D  ;unbenutzt
D 1 1 L D  ;zurueck vor das Resultat
D _ _ L E  ;zur zu decrementierender Zahl gehen
D + + L D  ;unbenutzt

E 0 1 L E  ;Decrementiere Zahl
E 1 0 R B  ;fertig decrementiert
E _ + R A  ;bei Ueberlauf neues Abschlusszeichen setzen
E + + L E  ;bei Ueberlauf ab 2. Durchlauf noch ein Abschlusszeichen setzen

Band="_"  ;ganzes Band mit Leerzeichen gefuellt
;Band="111++0_"  ;test: einige Zeichen, restliches Band mit Leerzeichen gefuellt
