/* dateiklasse.cc

 Daten von einer Datei einlesen
Anwendung: einfuegen in C++ Programmen
*/

#ifndef DATEIKLASSE_CC
#define DATEIKLASSE_CC
#include <stdio.h>
#include <ctype.h>

#define MAX_ZEICHEN_PRO_ZEILE 200  //inklusive 0-Byte

class Datei
{
public:
 const char *name;
 FILE *fp;
 double r,i;
 char zeile[MAX_ZEICHEN_PRO_ZEILE];
 Datei() {name=NULL; fp=NULL;}
 Datei(const char *nam) {name=nam; fp=NULL;}
 bool open_read() {return (fp=fopen(name,"r"))!=NULL;}
 bool open_write() {return (fp=fopen(name,"w"))!=NULL;}
 bool getline(char *s,int lim);
 bool getzeile() {return getline(zeile,MAX_ZEICHEN_PRO_ZEILE);}
 bool getzeile_ohne_kommentare(char kommentarzeichen);
 bool exists() {if(open_read()) {close(); return true;} return false;}
 void close() {if(fp!=NULL) {fclose(fp); fp=NULL;}}
 int  get() {return getc(fp);}
 void put(char c) {if(fp!=NULL) putc(c,fp);}
};

bool Datei::getline(char *s,int lim)
{		// liest eine Textzeile oder maximal lim Zeichen
		// und ersetzt den Zeilentrenner durch 0
 int c=0;
 if(fp==NULL) return false;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF); // TRUE wenn erfolgreich, FALSE wenn Fileende
}

bool Datei::getzeile_ohne_kommentare(char k)
{
 bool result;
 char *z, *z1, *z2;
 do
  {
   result=getline(zeile,MAX_ZEICHEN_PRO_ZEILE);
   for(z1=zeile;*z1==' ';z1++) ;//Leerzeichen am Zeilenanfang ueberlesen
   for(z2=z=z1;*z!=0 && *z!=k;z++)
    {if(*z!=' ') z2=z;}
   *++z2=0; //Leerzeichen an Zeilenende ignorieren
   if(z1!=zeile) strcpy(zeile,z1);
  }
 while(result==true && (*zeile==0 || *zeile==k));
 // In zeile[] steht jetzt aktuelle Zeile ohne Leerzeichen am Anfang und Ende,
 // und Kommentare weggelassen.
 return result;
}

#endif
