/* sucheallebiber.cc		letzte Aenderung: 19.9.2017 */
#define VERSION "Version 0.4"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

Neue Definition von "Fleissiger Biber":
 Ein Fleissiger Biber ist eine Turingmaschine mit S Symbolen und Z Zustaenden,
 die auf ein leeres Band (mit 0 gefuellt) angewendet moeglichst viel macht.
 Also entweder moeglichst viele Schritte macht,
 oder moeglichst viele Einsen hinterlaesst,
 oder moeglichst grosse Bandlaenge benutzt.

Biser nur mit S=2 und Z=1 bis 4 untersucht.
Der Fall Z=1 ist trivial: Anzahl Schritte=1, Anzahl Einsen=1, Bandlaenge=2
(bei Bandlaenge wird die Endposition mitgezaehlt)

History:
Datum      Vers
15.9.2017       Erstellung aus suchebiber.cc 0.4

*/

#define SMAX 2 //Bisher nur fuer S=2 programmiert
#define ZMAX 5 //Bisher nur fuer Z=2 bis 4 alle auffindbar, mit 5 noch unsicher

//#define DEBUG  //Testausdrucke fuer Fehlersuche (bisher die meisten mit //test auskommentiert)

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "dateiklasse.cc"

/************************* Vordeklarationen ***************************/
typedef unsigned char uchar;
typedef unsigned char uint8_t;
typedef unsigned long long uint64_t;

/************************* Globale Variablen **************************/

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(const char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Kleinkram ********************************/

/************** Klassen und Hauptteil des Programms *******************/
//#define SMAX 2  //Maximale Anzahl Symbole    //schon weiter oben definiert
//#define ZMAX 5  //maximale Anzahl Zustaende  //schon weiter oben definiert
#define MAXBAND 40000 //Laenge des Bandes (sollte mindestens 2 mal so gross sein wie maximal benutzte Bandlaenge)
#define BANDMITTE (MAXBAND/2)

/*
const char *zustand_name(int i)
{
 static char str[8];
 if(i==biber.zmax) return "Halt";
 if(i<=24) {str[0] = (i>=7) ? i-7+'I' : 'A'+i; str[1]=0;}
 return str;
}
*/

#define A 0
#define B 1
#define C 2
#define D 3
#define E 4
#define F 5
//#define HALT zmax
#define RECHTS 1
#define LINKS  0

class Band
{
 uchar feld[MAXBAND];
public:
 uint pos;
 //uint lastpos; //fuer Markierung der letzten Position beim Darstellen des Bandes
 uint posmin,posmax;
 uint benutzte_bandlaenge;
 bool errflag;
 Band() {init();}
 void init();
 uchar& operator[](uint i) {return feld[i];}
 uchar read() {return feld[pos];}
 void write(uchar neuezahl,uchar richtung);
 uint einsen_zaehlen();
 bool istleer();
};

static Band band;

void Band::init()
{
 //lastpos=pos=BANDMITTE; //in der Mitte des unendlichen Bandes starten
 pos=BANDMITTE; //in der Mitte des unendlichen Bandes starten
 posmax=pos;
 posmin=pos;
 benutzte_bandlaenge=1;
 for(uint i=0;i<MAXBAND;i++) feld[i]=0;//mit leerem Band starten
 errflag=false;
 //printf("Band::init() gemacht\n");//test
}

void Band::write(uchar neuezahl,uchar richtung)
{
 feld[pos]=neuezahl;
 //lastpos=pos;
 if(richtung==LINKS)
   {
    if(--pos < posmin)
     {posmin=pos; benutzte_bandlaenge++;
      if(pos==0) {posmin=pos=1; /*fprintf(stderr,"Band zu kurz, linker Rand erreicht.\n");*/ errflag=true;}
     }
   }
 else //if(richtung==RECHTS)
   {
    if(++pos > posmax)
     {posmax=pos; benutzte_bandlaenge++;
      if(pos==MAXBAND) {posmax = --pos; /*fprintf(stderr,"Band zu kurz, rechter Rand erreicht.\n");*/ errflag=true;}
     }
   }
}

uint Band::einsen_zaehlen()
{
 uint n=0;
 for(uint i=posmin;i<=posmax;i++)
  if(feld[i]==1) n++;
 return n;
}

bool Band::istleer()
{
 for(uint i=posmin;i<=posmax;i++)
  if(feld[i]!=0) return false;
 return true;
}

class Eintrag
{
public:
 uchar schreibwert,richtung,neuerzustand; //schreibwert muss im Bereich 0 bis SMAX-1 liegen, richtung LINKS oder RECHTS
 void set(uchar s,uchar r,uchar z) {schreibwert=s; richtung=r; neuerzustand=z;}
};

class Biber
{
public:
 int zmax; //Anzahl moegliche Zustaende
 //uint8_t smax; //Anzahl moegliche Symbole
 Eintrag tabelle[ZMAX*SMAX]; //Index ist Zustand*AnzahlSymbole + gelesene Zahl
 int zustand; //aktueller Zustand als Zahl, 0='A', 1='B'... , ZMAX=Halt
 Biber() {init(1); /*smax=2;*/}
 void init(int z);
 void setprog(int zust,int zahl,int neuezahl,int richtung,int neuerzustand)
      {
       tabelle[zust*SMAX+zahl].set(neuezahl,richtung,neuerzustand);
      }
 bool step(); //false wenn Halt erreicht
 bool gueltig(); //einige Gueltigkeitstest fuer beliebiges zmax
 void testprint_tabelle();
 int testlauf(uint max);
 int testlauf5(uint max);
};

void Biber::init(int z)
{
 zmax=z;
 zustand=0; //es wird mit Zustand A gestartet
 setprog(A,0,1,RECHTS,A); //Band mit 1en fuellen und nie anhalten (falls nie wirklich initialisiert wird)
}

//zu berechnende Tabellen:
/*
static uint maxschritte[ZMAX+1]   = {0, 1, 2,  3,  4,};
static uint maxeinsen[ZMAX+1]     = {0, 1, 2,  3,  4,};
static uint maxbandlaenge[ZMAX+1] = {0, 1, 2,  3,  4,};

static uint maxschritte_gesichert[ZMAX+1]={0, 1, 6, 21, 107}; //Werte die schon jemand berechnet hat
//static uint maxeinsen_gesichert[ZMAX+1] = {0, 1, 4,  6,  13}; //schon berechnete Werte
//static uint maxbandlaenge_gesichert[ZMAX+1] = {0, 1, 4,  7,  16}; //schon berechnete Werte
*/

int Biber::testlauf(uint max) //max muss groesser als der Wert entsprechend der Tabelle maxschritte_gesichert[] sein.
{                             //Rueckgabewert: 0=unklar ob anhaltend oder nicht, >=1 Anzahl Schritte bis Halt, -1 nicht anhaltend
                              // Da bis zmax==4 die maximale Anzahl Schritte bekannt ist, laesst sich eindeutig feststellen ob die
                              // Maschine anhaelt oder nicht. (Ab zmax==5 ist dies nicht mehr der Fall.)
 uint schritte=0;
 band.init();
 zustand=A;
 while(true)
  {
   if(step()==false) return schritte; //nach so vielen Schritten Halt erreicht
   if(band.errflag) {if(zmax<5) printf("Fehler: band.errflag.\n"); return 0;}
   if(++schritte==max) return -1; //nicht anhaltend
  }
 printf("Fehler: testlauf() Schlaufe sollte nicht beendet werden.\n");
 return 0;//Fehler
}

int Biber::testlauf5(uint max) //fuer zmax=5 optimierte Variante
{      //Rueckgabewert: 0=unklar ob anhaltend oder nicht, >=1 Anzahl Schritte bis Halt, -1 nicht anhaltend
 uint schritte=0;
 band.init();
 zustand=A;
 int erreichte_zustaende[5]={1,1,0,0,0};
 bool alle_zustaende_erreicht=false;
 while(true)
  {
   if(step()==false) return schritte; //nach so vielen Schritten Halt erreicht
   if(!alle_zustaende_erreicht)
    {
     erreichte_zustaende[zustand]=1;
     alle_zustaende_erreicht=true; //vielleicht sind jetzt alle Zustaende erreicht
     for(int i=2;i<5;i++)
      if(erreichte_zustaende[i]==0)
       {alle_zustaende_erreicht=false;
	if(band.benutzte_bandlaenge>16) //Wenn mit nur 4 Zustaenden schon eine groessere Bandlaenge erreicht
	            return -1; //als mit 4 Zustaenden moeglich, dann ist er nicht anhaltend.
	if(schritte>107) //Wenn mit nur 4 Zustaenden schon maximale Anzahl Schritte ueberschritten
	      return -1; //dann ist er nicht anhaltend.
	break;
       }
    }
   if(band.errflag) return 0;
   if(++schritte==max) return 0; //unsicher ob nicht anhaltend
  }
 printf("Fehler: testlauf5() Schlaufe sollte nicht beendet werden.\n");
 return 0;//Fehler
}

void Biber::testprint_tabelle()
{
 for(int i=0;i<zmax;i++)
  for(int j=0;j<2;j++)
   {
    Eintrag *e= &tabelle[i*SMAX+j];
    printf("(%c%d %d%c%c)\n", 'A'+i, j,
	   e->schreibwert, (e->richtung==RECHTS)?'R':'L', (e->neuerzustand>=zmax)?'H':'A'+e->neuerzustand);
   }
}

bool Biber::gueltig() //Tests die mit jedem zmax gehen sollten
{
 bool haltflag=false;
 int imax=zmax*SMAX;
 for(int i=0;i<imax;i++)
  {
   if(tabelle[i].neuerzustand==zmax)
    {
     if(tabelle[i].schreibwert==0) return false; //eine 1 schreiben ergibt besseren Biber
     haltflag=true;
    }
  }
 if(haltflag==false) return false; //kein HALT vorhanden
 for(int i=0;i<zmax;i++)   // Suche fuer jeden Zustand i
  {
   int j;
   for(j=0;j<zmax;j++) // ob er von Zustand j erreichbar ist. 
    if(j!=i)
     {
      if(tabelle[j*SMAX+0].neuerzustand==i || tabelle[j*SMAX+1].neuerzustand==i)
       {break;}
     }
   if(j==zmax) return false; //nicht erreichbarer Zustand
  }
 return true;
}

bool Biber::step()
{
 if(zustand==zmax) return false; //bei HALT nichts machen
 int zahl=band.read();
 int i=zustand*SMAX+zahl;
 int neuezahl = tabelle[i].schreibwert;
 int richtung = tabelle[i].richtung;
 //printf("neuezahl=%d, richtung=%d\n",neuezahl,richtung);//test
 zustand = tabelle[i].neuerzustand;
 band.write(neuezahl,richtung);
 return true;
}

uchar symbol_name2nr(char c)
{
 if(c=='0' || c=='1') return c-'0';
 if(c=='_') return 2;
 if(c=='+') return 3;
 return 3;//provi. (nur Symbole 0 1 _ + erlaubt)
}

char symbol_nr2name(uchar u)
{
 if(u<=1) return u+'0';
 if(u==2) return '_';
 if(u==3) return '+';
 return u-2+'a';//provi. (nur Symbole 0 1 _ + erlaubt)
}

/************************* Hauptprogramm ******************************/
static Biber biber;
static Biber fleissigster_biber_meiste_schritte;
static Biber fleissigster_biber_meiste_einsen;
static Biber fleissigster_biber_groesste_bandlaenge;
static Biber fleissigster_biber_groesste_summe;

static uint gefundene_biber=0; //Anzahl anhaltende Turingmaschinen
static uint nicht_anhaltend_anzahl=0;
static uint unsicher_anzahl=0;

static int meiste_schritte[4]={0,0,0};
static int meiste_einsen[4]={0,0,0,0};
static uint meiste_band[4]= {0,0,0,0};
static uint meiste_summe[4]={0,0,0,0};

static int gewichtung[3]={1,1,1};

void maximale_finden(int schritte)
{
 int einsen=band.einsen_zaehlen();
 if(schritte>meiste_schritte[0])
  {
   fleissigster_biber_meiste_schritte = biber;
   meiste_schritte[0]=schritte;
   meiste_schritte[1]=schritte;
   meiste_schritte[2]=einsen;
   meiste_schritte[3]=band.benutzte_bandlaenge;
  }
 if(einsen>meiste_einsen[0])
  {
   fleissigster_biber_meiste_einsen = biber;
   meiste_einsen[0]=einsen;
   meiste_einsen[1]=schritte;
   meiste_einsen[2]=einsen;
   meiste_einsen[3]=band.benutzte_bandlaenge;
  }
 if(band.benutzte_bandlaenge>meiste_band[0])
  {
   fleissigster_biber_groesste_bandlaenge = biber;
   meiste_band[0]=band.benutzte_bandlaenge;
   meiste_band[1]=schritte;
   meiste_band[2]=einsen;
   meiste_band[3]=band.benutzte_bandlaenge;
  }
 uint summe;
 summe = gewichtung[0]*schritte + gewichtung[1]*einsen + gewichtung[2]*band.benutzte_bandlaenge; //gewichtete Summe
 if(summe > meiste_summe[0])
  {
   fleissigster_biber_groesste_summe = biber;
   meiste_summe[0]=summe;
   meiste_summe[1]=schritte;
   meiste_summe[2]=einsen;
   meiste_summe[3]=band.benutzte_bandlaenge;
  }
}

uint bibersuche2()
{
 const int zmax=2;
 uint anzahl=0;
 int ka,       ka1,ra1,nza1; //Zahler fuer Schreibwert, Richtung, NeuerZustand
 int kb,rb,nzb,kb1,rb1,nzb1;
 for(ka=1;ka>=0;ka--) {
 biber.setprog(A,0, ka,RECHTS,B); //einzige relevante Moeglichkeit ist nach rechts zu B gehen (LINKS waere equivalent)
 for(ka1=0;ka1<2;ka1++)  //A1 Schreibwert
  for(ra1=0;ra1<2;ra1++) //A1 Richtung
   for(nza1=0;nza1<=zmax;nza1++) //A1 NeuerZustand.  0 ist A, 1 ist B, ... zmax ist HALT
    {
     biber.setprog(A,1, ka1,ra1,nza1); //setprog(Zustand,Lesewert, Schreibwert,Richtung,NeuerZustand)
     for(kb=0;kb<2;kb++)  //Schreibwert
      for(rb=0;rb<2;rb++) //Richtung
       for(nzb=0;nzb<=zmax;nzb++) //0 ist A, 1 ist B, ... zmax ist HALT
	  {
	   biber.setprog(B,0, kb,rb,nzb);
	   for(kb1=0;kb1<2;kb1++)  //Schreibwert
	    for(rb1=0;rb1<2;rb1++) //Richtung
	     for(nzb1=0;nzb1<=zmax;nzb1++) //0 ist A, 1 ist B, ... zmax ist HALT
	      {
	       biber.setprog(B,1, kb1,rb1,nzb1);
	       // Biber untersuchen:
	       if(biber.gueltig())
		{
		 anzahl++; //gesamte Anzahl Biber (auch nicht fleissige und nicht haltende)
		 int schritte=biber.testlauf(12);
		 if(schritte>0) //Biber gefunden
		   {
		    gefundene_biber++; //anhaltende Biber (auch nicht fleissige)
		    maximale_finden(schritte);
		   }
		 else if(schritte<0) {nicht_anhaltend_anzahl++;} //eindeutig nicht anhaltend
		}
	       // Ende Biber untersuchen
	      }
	  }
    }
 }
 return anzahl;
}

uint64_t bibersuche3()
{
 const int zmax=3;
 uint64_t anzahl=0;
 int ka, ka1,ra1,nza1; //Zahler fuer Schreibwert, Richtung, NeuerZustand
 int kb,rb,nzb,kb1,rb1,nzb1;
 int kc,rc,nzc,kc1,rc1,nzc1;
 for(ka=1;ka>=0;ka--) {
 biber.setprog(A,0, ka,RECHTS,B); //ist einzige relevante Moeglichkeit (LINKS oder C waeren equivalent)
 for(ka1=0;ka1<2;ka1++)  //A1 Schreibwert
  for(ra1=0;ra1<2;ra1++) //A1 Richtung
   for(nza1=0;nza1<=zmax;nza1++) //A1 NeuerZustand.  0 ist A, 1 ist B, ... zmax ist HALT
    {
     biber.setprog(A,1, ka1,ra1,nza1); //setprog(Zustand,Lesewert, Schreibwert,Richtung,NeuerZustand)
     for(kb=0;kb<2;kb++)  //Schreibwert
      for(rb=0;rb<2;rb++) //Richtung
       for(nzb=0;nzb<=zmax;nzb++) //0 ist A, 1 ist B, ... zmax ist HALT
	  {
	   biber.setprog(B,0, kb,rb,nzb);
	   for(kb1=0;kb1<2;kb1++)  //Schreibwert
	    for(rb1=0;rb1<2;rb1++) //Richtung
	     for(nzb1=0;nzb1<=zmax;nzb1++) //0 ist A, 1 ist B, ... zmax ist HALT
	      {
	       biber.setprog(B,1, kb1,rb1,nzb1);
	       for(kc=0;kc<2;kc++)  //Schreibwert
		for(rc=0;rc<2;rc++) //Richtung
		 for(nzc=0;nzc<=zmax;nzc++) //0 ist A, 1 ist B, ... zmax ist HALT
		  {
		   biber.setprog(C,0, kc,rc,nzc);
		   for(kc1=0;kc1<2;kc1++)  //Schreibwert
		    for(rc1=0;rc1<2;rc1++) //Richtung
		     for(nzc1=0;nzc1<=zmax;nzc1++) //0 ist A, 1 ist B, ... zmax ist HALT
		      {
		       biber.setprog(C,1, kc1,rc1,nzc1);
		       // Biber untersuchen:
		       if(biber.gueltig())
			{
			 anzahl++; //gesamte Anzahl Biber (auch nicht fleissige und nicht haltende)
			 int schritte=biber.testlauf(42);
			 if(schritte>0) //Biber gefunden
			  {
			   gefundene_biber++; //anhaltende Biber (auch nicht fleissige)
			   maximale_finden(schritte);
			  }
			 else if(schritte<0) {nicht_anhaltend_anzahl++;} //eindeutig nicht anhaltend
			}
		       // Ende Biber untersuchen
		      }
		  }
	      }
	  }
    }
 }
 return anzahl;
}

uint64_t bibersuche4()
{
 const int zmax=4;
 uint64_t anzahl=0;
 int ka, ka1,ra1,nza1; //Zahler fuer Schreibwert, Richtung, NeuerZustand
 int kb,rb,nzb,kb1,rb1,nzb1;
 int kc,rc,nzc,kc1,rc1,nzc1;
 int kd,rd,nzd,kd1,rd1,nzd1;
 for(ka=1;ka>=0;ka--) {
 biber.setprog(A,0, ka,RECHTS,B); //ist einzige relevante Moeglichkeit (LINKS oder C waeren equivalent)
 for(ka1=0;ka1<2;ka1++)  //A1 Schreibwert
  for(ra1=0;ra1<2;ra1++) //A1 Richtung
   for(nza1=0;nza1<=zmax;nza1++) //A1 NeuerZustand.  0 ist A, 1 ist B, ... zmax ist HALT
    {
     biber.setprog(A,1, ka1,ra1,nza1); //setprog(Zustand,Lesewert, Schreibwert,Richtung,NeuerZustand)
     for(kb=0;kb<2;kb++)  //Schreibwert
      for(rb=0;rb<2;rb++) //Richtung
       for(nzb=0;nzb<=zmax;nzb++) //0 ist A, 1 ist B, ... zmax ist HALT
	{
	 biber.setprog(B,0, kb,rb,nzb);
	 for(kb1=0;kb1<2;kb1++)  //Schreibwert
	  for(rb1=0;rb1<2;rb1++) //Richtung
	   for(nzb1=0;nzb1<=zmax;nzb1++) //0 ist A, 1 ist B, ... zmax ist HALT
	    {
	     biber.setprog(B,1, kb1,rb1,nzb1);
	     for(kc=0;kc<2;kc++)  //Schreibwert
	      for(rc=0;rc<2;rc++) //Richtung
	       for(nzc=0;nzc<=zmax;nzc++) //0 ist A, 1 ist B, ... zmax ist HALT
		{
		 biber.setprog(C,0, kc,rc,nzc);
		 for(kc1=0;kc1<2;kc1++)  //Schreibwert
		  for(rc1=0;rc1<2;rc1++) //Richtung
		   for(nzc1=0;nzc1<=zmax;nzc1++) //0 ist A, 1 ist B, ... zmax ist HALT
		    {
		     biber.setprog(C,1, kc1,rc1,nzc1);
		     for(kd=0;kd<2;kd++)  //Schreibwert
		      for(rd=0;rd<2;rd++) //Richtung
		       for(nzd=0;nzd<=zmax;nzd++) //0 ist A, 1 ist B, ... zmax ist HALT
			{
			 biber.setprog(D,0, kd,rd,nzd);
			 for(kd1=0;kd1<2;kd1++)  //Schreibwert
			  for(rd1=0;rd1<2;rd1++) //Richtung
			   for(nzd1=0;nzd1<=zmax;nzd1++) //0 ist A, 1 ist B, ... zmax ist HALT
			    {
			     biber.setprog(D,1, kd1,rd1,nzd1);
			     // Biber untersuchen:
			     if(biber.gueltig())
			      {
			       anzahl++; //gesamte Anzahl Biber (auch nicht fleissige und nicht haltende)
			       int schritte=biber.testlauf(214);
			       if(schritte>0) //Biber gefunden
				{
				 gefundene_biber++; //anhaltende Biber (auch nicht fleissige)
				 maximale_finden(schritte);
				}
			       else if(schritte<0) {nicht_anhaltend_anzahl++;} //eindeutig nicht anhaltend
			      }
			     // Ende Biber untersuchen
			    }
			}
		    }
		}
	    }
	}
    }
 }
 return anzahl;
}

uint64_t bibersuche5()
{
 const int zmax=5;
 uint64_t anzahl=0;
 int ka, ka1,ra1,j1; //Zahler fuer Schreibwert, Richtung, NeuerZustand
 int nza1[5]={C,D,zmax,A,B}; //ungewoehnliche Reihenfolge fuer NeuerZustand bei A1
 int kb,rb,j2,kb1,rb1,j3;
 int nzb[3]={C,A,B}; //Reihenfolge bei B0
 int nzb1[6]={B,C,D,zmax,A,E}; //Reihenfoleg bei B1
 int kc,rc,nzc,kc1,rc1,nzc1;
 int kd,rd,nzd,kd1,rd1,nzd1;
 int ke,re,nze,ke1,re1,nze1;
 for(ka=1;ka>=0;ka--) { //A0 Schreibwert
 biber.setprog(A,0, ka,RECHTS,B); //ist einzige relevante Moeglichkeit (LINKS oder C waeren equivalent)
 for(ka1=1;ka1>=0;ka1--) //A1 Schreibwert
  for(ra1=0;ra1<2;ra1++) //A1 Richtung
   //for(nza1= -1;nza1<=D;nza1++) //A1 NeuerZustand.  0 ist A, 1 ist B, ... zmax oder -1 ist HALT
   for(j1=0;j1<5;j1++) //A1 NeuerZustand.  ungewoehnliche Reihenfolge damit bisher bester schneller gefunden wird
    {
     biber.setprog(A,1, ka1,ra1,nza1[j1]); //setprog(Zustand,Lesewert, Schreibwert,Richtung,NeuerZustand)
     printf("A,0, %d,%d,%d\n",ka,RECHTS,B);//test
     printf("A,1, %d,%d,%d\n",ka1,ra1,nza1[j1]);//test
     for(kb=1;kb>=0;kb--) //B0 Schreibwert
      for(rb=1;rb>=0;rb--) //B0 Richtung
       for(j2=0;j2<3;j2++) //B0 neuer_zustand nur bis C, waere sonst equivalent
	{
	 biber.setprog(B,0, kb,rb,nzb[j2]);
	 printf("B,0, %d,%d,%d\n",kb,rb,nzb[j2]);//test
	 for(kb1=1;kb1>=0;kb1--) //B1 Schreibwert
	  for(rb1=1;rb1>=0;rb1--) //B1 Richtung
	   for(j3=(nza1[j1]<C && nzb[j2]<C)?1:0;
	       j3 < ((nza1[j1]<C && nzb[j2]<C)?2:6); j3++) //B1 neuer_Zustand, wenn kein anderer C erreicht, nur mit C probieren
	    {
	     biber.setprog(B,1, kb1,rb1,nzb1[j3]);
	     printf("B,1, %d,%d,%d\n",kb1,rb1,nzb1[j3]);//test
	     for(kc=1;kc>=0;kc--) //C0 Schreibwert
	      for(rc=1;rc>=0;rc--) //C0 Richtung
	       for(nzc=0;nzc<=zmax;nzc++) //0 ist A, 1 ist B, ... zmax ist HALT
		{
		 biber.setprog(C,0, kc,rc,nzc);
		 printf("C,0, %d,%d,%d\n",kc,rc,nzc);//test
		 printf("Anhaltend: %d  nicht anhaltend: %d  unsicher: %d\n", gefundene_biber,nicht_anhaltend_anzahl,unsicher_anzahl);//test
		 for(kc1=0;kc1<2;kc1++)  //C1 Schreibwert
		  for(rc1=0;rc1<2;rc1++) //C1 Richtung
		   {
		    if(nza1[j1]<D && nzb[j2]<D && nzb1[j3]<D && nzc<D) nzc1=D;
		    else if(nza1[j1]<E && nzb[j2]<E && nzb1[j3]<E && nzc<E) nzc1=E;
		    else nzc1=A;
		   for(; nzc1<=zmax; nzc1++) //C1 neuer_Zustand, wenn kein anderer D erreicht, bei D starten
		    {
		     biber.setprog(C,1, kc1,rc1,nzc1);
		     //printf("C,1, %d,%d,%d\n",kc1,rc1,nzc1);//test
		     for(kd=0;kd<2;kd++)  //Schreibwert
		      for(rd=0;rd<2;rd++) //Richtung
		       for(nzd=0;nzd<=zmax;nzd++) //0 ist A, 1 ist B, ... zmax ist HALT
			{
			 biber.setprog(D,0, kd,rd,nzd);
			 for(kd1=0;kd1<2;kd1++)  //Schreibwert
			  for(rd1=0;rd1<2;rd1++) //Richtung
			   for(nzd1=0;nzd1<=zmax;nzd1++) //0 ist A, 1 ist B, ... zmax ist HALT
			    {
			     biber.setprog(D,1, kd1,rd1,nzd1);
			     for(ke=0;ke<2;ke++)  //Schreibwert
			      for(re=0;re<2;re++) //Richtung
			       for(nze=0;nze<=zmax;nze++) //0 ist A, 1 ist B, ... zmax ist HALT
				{
				 biber.setprog(E,0, ke,re,nze);
				 for(ke1=0;ke1<2;ke1++)  //Schreibwert
				  for(re1=0;re1<2;re1++) //Richtung
				   for(nze1=0;nze1<=zmax;nze1++) //0 ist A, 1 ist B, ... zmax ist HALT
				    {
				     biber.setprog(E,1, ke1,re1,nze1);
				     // Biber untersuchen:
				     if(biber.gueltig())
				      {
				       anzahl++; //gesamte Anzahl Biber (auch nicht fleissige und nicht haltende)
				       int schritte=biber.testlauf5(47177870); //1000 mehr als bester bisher gefundener
				       if(schritte>0) //Biber gefunden
					{
					 gefundene_biber++; //anhaltende Biber (auch nicht fleissige)
					 //printf("Anhaltender gefunden: schritte=%d\n",schritte);//test
					 //biber.testprint_tabelle();//test
					 maximale_finden(schritte);
					}
				       else if(schritte<0) {nicht_anhaltend_anzahl++;} //eindeutig nicht anhaltend
				       else //if(schritte==0)
					{unsicher_anzahl++;} //unsicher ob anhaltend oder nicht
				      }
				     // Ende Biber untersuchen
				    }
				}
			    }
			}
		    }
		   }
		}
	    }
	}
    }
 }
 return anzahl;
}

uint64_t bibersuche(int zmax)
{
 biber.init(zmax);
 gefundene_biber=0;
 nicht_anhaltend_anzahl=0;
 if(zmax==2) return bibersuche2();
 if(zmax==3) return bibersuche3();
 if(zmax==4) return bibersuche4();
 if(zmax==5) return bibersuche5();
 return 0;
}

int main(int argc,char *argv[])
{
 char zielname[80];
 int64_t i;
 int j,c;
 int z=2;
 if(sizeof(uint64_t)<8) {printf("falsche groesse von uint64_t: %d\n",sizeof(uint64_t)); exit(0);}
 zielname[0]=0;
 
 for(j=0,i=1;i<argc;i++)
  {if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
   else if(++j==1)
      {if(isdigit(*argv[i])) sscanf(argv[i],"%d",&z);
       else strcpy(zielname,argv[i]);
      }
   else if(j==2) strcpy(zielname,argv[i]);
  }
 
 if(argflag['?'] || j>MAXARG || z<2 || z>ZMAX)
	{printf("biber  %s\n",VERSION);
	 printf("Anwendung: sucheallebiber [-Flags] [Z] [zieldatei.tm]\n");
	 printf("  fuer Z sind bisher nur Zahlen von 2 bis %d moeglich.\n",ZMAX);
	 printf("  (Bei Z=5 ist bei einigen Bibern unsicher ob nicht anhaltend oder Rekordbiber)\n");
	 printf("  Flags: v=verbose (Testausdrucke)\n");
	 printf("         s=Schritte staerker gewichtet fuer Summe\n");
	 printf("         e=Einsen staerker gewichtet fuer Summe\n");
	 printf("         b=Bandlaenge staerker gewichtet fuer Summe\n");
	 printf("         c=Bandlaenge noch staerker gewichtet\n");
	 //printf("sizeof(uint)=%d sizeof(long long)=%d (uint64_t)=%d\n",sizeof(uint),sizeof(long long),sizeof(uint64_t));//test
	 exit(0);
	}
 
 if(argflag['E'])      {gewichtung[0]=1; gewichtung[1]=10; gewichtung[2]=1;} // Schritte _Einsen_ Bandlaenge  Gewichtung
 else if(argflag['S']) {gewichtung[0]=2; gewichtung[1]=1; gewichtung[2]=1;} //_Schritte_ Einsen  Bandlaenge
 else if(argflag['C']) {gewichtung[0]=1; gewichtung[1]=1; gewichtung[2]=60;} // _Bandlaenge_ extrem stark gewichtet
 else if(argflag['B']) {gewichtung[0]=1; gewichtung[1]=1; gewichtung[2]=10;} // Schritte  Einsen _Bandlaenge_

 Datei datei(zielname); //TODO: Resultat in Datei speichern
 if(zielname[0]!=0)
  {
   if(datei.open_read()) {fprintf(stderr,"Datei '%s' schon vorhanden.\n",zielname); exit(0);}
   printf("Speichern in Zieldatei geht noch nicht.\n");
  }
 uint64_t anzahl=pow(4*(z+1), 2*z);
 printf("Theoret.  Anzahl  Turingmaschinen mit %d Zustaenden: %Lu\n",z,anzahl);
 anzahl=pow(4*(z+1), 2*z-1);
 printf("Theoretisch moegliche Anzahl mit (A01RB) oder (A00RB) beginnend: %Lu\n",anzahl*2);

 /***********************  Erster Suchdurchlauf ********************************/
 printf("\nNach allen Bibern mit Z=%d suchen...\n",z);
 
 anzahl=bibersuche(z);
 
 if(anzahl==0) {printf("Fehler: anzahl=0\n"); exit(0);}
 else printf("Anzahl aller Biber mit %d Zustaenden: %Lu\n",z,anzahl);
 ulong giga=1e9;
 if(anzahl>giga) printf("also etwa %Lu Milliarden\n",anzahl/giga);
 else if(anzahl>1000000) printf("also etwa %Lu Millionen\n",anzahl/1000000);
 printf("als anhaltend identifizierte: %u\n", gefundene_biber);
 printf("als nicht anhaltende identif: %u\n", nicht_anhaltend_anzahl);
 if(z==5)
  printf("unsicher ob nicht anhaltend: %u\n", unsicher_anzahl);
 
 printf("\nFleissigster Biber mit am meisten Schritte:\n");
 fleissigster_biber_meiste_schritte.testprint_tabelle();
 printf("Anzahl Schritte: %d  Anzahl Einsen: %d  Bandlaenge: %d\n", meiste_schritte[1], meiste_schritte[2], meiste_schritte[3]); 
 
 printf("\nFleissigster Biber mit den meisten Einsen:\n");
 fleissigster_biber_meiste_einsen.testprint_tabelle();
 printf("Anzahl Einsen: %d  Anzahl Schritte: %d  Bandlaenge: %d\n", meiste_einsen[2], meiste_einsen[1], meiste_einsen[3]); 
 
 printf("\nFleissigster Biber mit groesster benutzter Bandlaenge:\n");
 fleissigster_biber_groesste_bandlaenge.testprint_tabelle();
 printf("Benutzte Bandlaenge: %d  Anzahl Einsen: %d  Anzahl Schritte: %d\n", meiste_band[3], meiste_band[2], meiste_band[1]);
 
 printf("\nBiber mit groesster gewichteter Summe:\n");
 fleissigster_biber_groesste_summe.testprint_tabelle();
 printf("Summe: %d  Anzahl Schritte: %d  Anzahl Einsen: %d  Bandlaenge: %d\n",
	meiste_summe[0], meiste_summe[1], meiste_summe[2], meiste_summe[3]); 
 printf("(Gewichtung: %d %d %d)\n",gewichtung[0],gewichtung[1],gewichtung[2]);
 //TODO: alle Fleissigste Biber anzeigen und eventuell in Datei speichern

 return 0;
}/* ende von main */
