/* fontcopy.cc */
#define VERSION "Version 0.0"
/*
  Kopieren von Fonts zwischen den Formaten .i und .h

History:
5.9.2017       Erstellung

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(const char *s)
{
 int c;
 while((c= *s++)!=0)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/***************************** Kleinkram ******************************/
bool getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

void putline(FILE *fp,const char *s) /* wie fprintf(fp,"%s\n",s)  aber */
{				     /* ohne ein Nullbyte zu schreiben */
 char c;
 while((c= *s++)!=0)  putc(c,fp);
 putc('\n',fp);
}


bool istendung(const char *name,const char *endung)
{
 char c; int i;
 const char *s=name;
 for(i=0,s=name;*s!=0;s++,i++) ;
 while(i>0 && (c= *s)!='.')
        {--i; --s;}
 return (strcmp(s,endung)==0);
}

/************************* Hauptprogramm ******************************/
void fontcopy(FILE *fp1,FILE *fp2)
{
 char zeile[200],c;
 int j, errflag=0;
 while(getline(fp1,zeile,200)) //eine Zeile von erster Datei lesen
  {
   if(argflag['C'])
    { //umkopieren von Assembler-Syntax nach c-Syntax
     if(zeile[0]==';') //Kommentarzeichen von Assembler-Syntax ersetzen
      {
       if(strncmp(zeile,";//",3)==0)  strncpy(zeile,"// ",3); //durch c-Kommentar
       else strncpy(zeile,"//",2);
      }
     else
      {
       if(strncmp(zeile,".db ",4)==0) {strncpy(zeile,"   {",4);}
       for(j=0; zeile[j]!=0 && zeile[j]!=';'; j++) {} //Kommentar suchen
       if(zeile[j]==';' && j>4)
	{
	 strncpy(&zeile[j-1],"//",2);
	 j -= 3;
	 while(j>0 && zeile[j]==' ') {--j;}//letztes Komma suchen
	 if(zeile[j]==',') {strncpy(&zeile[j],"},",2);}
	 else {if(errflag<10) {printf("Syntaxfehler: %s\n",zeile); errflag++;}}
	}
       int klam=0;
       for(j=0;(c=zeile[j])!=0 && c!='/';j++)
	{if(c=='{') klam++; else if(c=='}') klam--;}
       if(klam>0) printf("Syntaxfehler: fehlende } Klammer: %s\n",zeile);
       else if(klam<0) printf("Syntaxfehler: fehlende { Klammer: %s\n",zeile);
      }
    }
   else if(argflag['A'])
    { //umkopieren von c-Syntax nach Assembler-Syntax
     if(zeile[0]=='/' && zeile[1]=='/') //Kommentarzeichen von c-Syntax ersetzen
      {
       if(zeile[2]==' ') strncpy(zeile,";//",3);
       else              strncpy(zeile,"; ",2);
      }
     else if(zeile[0]!='.' && zeile[0]!=';')
      {
       for(j=0; zeile[j]==' '; j++) {}
       if(zeile[j]=='{')
	{
	 if(j>=3) strncpy(&zeile[j-3],".db ",4);
	 else {char tmp[200]; sprintf(tmp,".db %s",&zeile[j]); strcpy(zeile,tmp);}
	 for(++j; (c=zeile[j])!=0 && c!='}' && c!='/';j++) {}
	 if(zeile[j]=='}')
	  {
	   if(zeile[j+1]==',') strncpy(&zeile[j],", ",2);
	   else zeile[j]=' ';
	  }
	}
       for(j=0; (c=zeile[j])!=0 && c!='/'; j++) {}
       if(j>4 && zeile[j+1]=='/') strncpy(&zeile[j]," ;",2);
      }
    }
   else
    {
     if(errflag<2) {printf("Fehler in fontcopy(): fehlendes Flag A oder C\n"); errflag++;}
    }
   putline(fp2,zeile); //geaenderte Zeile in zeiter Datei speichern
  }
}

int main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 FILE *fp1,*fp2;
 int i,j=0,c;
 quellname[0]=zielname[0]=0;
 if(argc<=0)
  {/* es wurde von WorkBench (GUI, Desktop, ...) gestartet */
   fprintf(stderr,"fontcopy muss mit Kommandozeile gestartet werden.\n");
  }
 else
  {/* es wurde von Shell (Terminal, Konsole, ...) gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
  }
 if(argflag['?'] || j>MAXARG || (argflag['A'] && argflag['C']))
	{printf("fontcopy  %s\n",VERSION);
	 printf("Anwendung: astart [-Flags] Quelle [Ziel]\n");
	 printf("  Flags: a=Convertiere nach Assembler (ziel.i)\n");
	 printf("         c=Convertiere nach c-Syntax (ziel.h)\n");
	 exit(0);
	}
 if(*quellname==0) {printf("Quellname:"); scanf("%s",quellname);}
 if(*zielname==0)  {printf("Zielname:"); scanf("%s",zielname);}
 
 if((fp1=fopen(quellname,"r"))!=NULL)
  {
   printf("Datei '%s' vorhanden\n",quellname);//test
  }
 else printf("Datei '%s' nicht vorhanden\n",quellname);
 
 if((fp2=fopen(zielname,"r"))!=NULL)
  {printf("Datei '%s' schon vorhanden\n",zielname); fclose(fp2); fp2=NULL;}
 else if((fp2=fopen(zielname,"w"))!=NULL)
  {
   printf("Datei '%s' erfolgreich erstellt.\n",zielname);//test
  }
 else printf("Datei '%s' nicht vorhanden\n",zielname);
 
 if(fp1!=NULL && fp2!=NULL)
  {
   if(!argflag['A'] && !argflag['C'])
    {if(istendung(zielname,".i")) argflag['A']=1; else if(istendung(zielname,".h")) argflag['C']=1;}
   fontcopy(fp1,fp2);
  }
 if(fp1) fclose(fp1);
 if(fp2) fclose(fp2);
 return 0;
}/* ende von main */
