/* gpstrack.cc			letzte Aenderung: 27.6.2009 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Geschwindigkeitsprofil aus GPS-Trackdaten berechnen

History:
26.6.2009	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>

/************************* Vordeklarationen ***************************/
bool parser(FILE *fp,const char *c1,const char *c2,const char *c3,
	    double *x1,double *x2);
bool parser1(FILE *fp,const char *c1,const char *c3,char *text,int max);
bool parser2(FILE *fp,const char *c1,const char *c2,char *text,int max);
void geschwindigkeitsprofil(FILE *fp1,FILE *fp2);

/*************************** kleinkram ********************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80], text[200];
 FILE *fp1,*fp2;
 int i,j,c,nzahlen=0,zahl;
 const int ndefault=7;
 int *liste, defaultliste[ndefault]={1, 17, 5, 4, 8, 12, 10};
 int neueliste[1000];
 quellname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
	         //else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("gpstrack  %s\n",VERSION);
	 printf("Anwendung: gpstrack Datei\n");
	 printf("  Optionen: T=Geschwindigkeit gegen Zeit auftragen\n");
	 printf("              (sonst: Geschwindigkeit gegen Distanz)\n");
	 exit(0);
	}
 if(*quellname!=0 && (fp1=fopen(quellname,"r"))!=NULL)
  {fp2=fopen("neu.xy","w");
   if(fp2==NULL)
     {printf("kann neu.xy nicht erstellen.\n"); fclose(fp1); exit(0);}
   while(parser2(fp1,"<trk>","<name>",text,200))
     if(strncmp(text,"ACTIVE LOG",10)==0)
       geschwindigkeitsprofil(fp1,fp2);
   fclose(fp2);
   fclose(fp1);
  }
 else printf("kann '%s' nicht oeffnen.\n",quellname);
 return 0;
}/* ende von main */

bool parser(FILE *fp,const char *c1,const char *c2,const char *c3,
	    double *x1,double *x2)
{
 char zeile[200],*s;
 int i,c,n1=strlen(c1),n2=strlen(c2),n3=strlen(c3);
 while(getline(fp,zeile,200))
  {for(s=zeile;*s==' ';s++) ;
   if(strncmp(s,c1,n1)==0)
    {s= &s[n1];
     sscanf(s,"%lf",x1);
     for(;(c= *s)!=0 && c!= *c2;) s++;
     if(strncmp(s,c2,n2)==0)
      {sscanf(&s[n2],"%lf",x2);
       return true;
      }
    }
   else if(strncmp(s,c3,n3)==0)
    return false;
  }
 return false;
}

bool parser1(FILE *fp,const char *c1,const char *c3,char *text,int max)
{
 char zeile[200],*s;
 int i,c,n1=strlen(c1),n3=strlen(c3);
 while(getline(fp,zeile,200))
  {for(s=zeile;*s==' ';s++) ;
   if(strncmp(s,c1,n1)==0)
      {for(i=0,s= &s[n1];i<max-1 && (c= *s++)!=0 && c!='<';)
	 *text++ = c;
       *text=0;
       return true;
      }
   else if(strncmp(s,c3,n3)==0)
      return false;
  }
 return false;
}

bool parser2(FILE *fp,const char *c1,const char *c2,char *text,int max)
{
 char zeile[200],*s;
 int i,c,n1=strlen(c1),n2=strlen(c2);
 while(getline(fp,zeile,200))
  {for(s=zeile;*s==' ';s++) ;
   if(strncmp(s,c1,n1)==0 && getline(fp,zeile,200))
    {for(s=zeile;*s==' ';s++) ;
     if(strncmp(s,c2,n2)==0)
      {for(i=0,s= &s[n2];i<max-1 && (c= *s++)!='<' && c!=0;)
	 *text++ = c;
       *text=0;
       return true;
      }
    }
  }
 return false;
}

long zeitinsec(char *t)
{
 int c,std,min,sec;
 while((c= *t++)!=0 && c!='T') ; //provi. ohne Datum
 sscanf(t,"%d:%d:%d",&std,&min,&sec);
 return std*3600+min*60+sec;
}

#include "math3.h"

double distanz(double lat0,double lon0,double lat1,double lon1)
{
 //Distanz zwischen zwei GPS-Koordinaten in km
 double latb=lat1*GRAD,lata=lat0*GRAD,lonb=lon1*GRAD,lona=lon0*GRAD;
 const double r=6380; //Erdradius
 return acos(sin(latb)*sin(lata)+cos(latb)*cos(lata)*cos(lonb-lona))*r;
}

void geschwindigkeitsprofil(FILE *fp1,FILE *fp2)
{
 static double lat0=0,lon0=0,totaldist=0;
 static long zeit0=0,zeit1=0;
 const int dt=10; //minimale Zeitdifferenz um Geschwindigkeit zu berechnen
 double lat,lon,v1,dist;
 char zeit[80];
 long zeit2;
 bool ok;
 while(parser(fp1,"<trkpt lat=\"","lon=\"","</trk>",&lat,&lon))
  {ok=parser1(fp1,"<time>","</trkpt>",zeit,80);
   if(ok && (zeit2=zeitinsec(zeit)-zeit0)>=zeit1+dt)
    {
     if(lat0==0)
      {zeit0=zeit2; zeit2=zeit1=0;
       v1=0;
      }
     else
      {totaldist += dist=distanz(lat0,lon0,lat,lon);
       v1=dist/(zeit2-zeit1)*3600;
       zeit1=zeit2;
      }
     //fprintf(fp2,"%lf %lf %s\n",lat,lon,zeit);//test
     //fprintf(fp2,"dist=%lf zeit1=%ld zeit2=%ld\n",dist,zeit1,zeit2);//test
     if(argflag['T']) fprintf(fp2,"%lf %lf\n",zeit2/3600.0,v1);
     else fprintf(fp2,"%lf %lf\n",totaldist,v1);
     lat0=lat; lon0=lon;
    }
  }
}
