/* halesen.cc			letzte Aenderung: 20.2.2025 */
#define VERSION "Version 0.2"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Versuch von Handschrift lesen aus ppm-Datei von Scanner

History:
31.1.2025       Erstellung (RP)
9.2.2025   0.2  Felder w1 und w2 statt Klasse Neuron
*/
//#define ERSTER_TEST
#define HIDDEN32x32 //Variante mit mehr Zwischenneuronen
#define W1FIXIERT   //w1 beim trainieren unveraendert lassen

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <math.h>
#include <xtekplot1.h>

#define uchar uint8_t

//#define XMAX 1024
//#define YMAX  820
#define XMAX 1280
#define YMAX 1024
#define TIEFE 24

#define SCHWARZAUFWEISS //auskommentieren fuer weiss auf schwarz

/************************* Vordeklarationen ***************************/
void bild_einlesen(const char *name);
void pixelfeld_zeichnen();
void erstes_anlernen();
void trainieren(int ivarmax,int methode);
void von_lernliste_einlesen(int soll);
int nnw_einlesen(const char *name);
void neuronen_rechts_zeichnen(double *z,int imax,int jmax);
void propagieren();
void zeichen_erkennung_von_mitte(int zeichnenflag=2);
void lerndatei_einlesen();

void menu_load(), menu_save();
void m_rechts(), m_unten(), m_links(), m_oben(), m_position(), m_lernpos();
void m_zoom32(),m_zoomin(), m_zoomout(), m_zoomtotale(), m_zoomfaktor(), m_refresh();
void maus_gedrueckt(), maus_bewegung(), maus_losgelassen();
void m_scannen(), m_scannen2(), m_wortscannen(), m_lernen(), m_wertesetzen();

/************************* Globale Variablen **************************/
//double g_xmin= -0.125,g_ymin=0.0,g_xmax=1.125,g_ymax=1.0;
double g_xmin= 0.0, g_ymin=0.0, g_xmax=1.25, g_ymax=1.0;
#ifdef ERSTER_TEST
static int shiftx=234,shifty=36;
#else
static int shiftx=0,shifty=0;
#endif
typedef char Dateinamen[200];
static Dateinamen lerndatei[20];//TODO
static double Epsilon=0.3;

/***************************** Kleinkram ******************************/
const int N80=200;//maximal vorkommende Laenge eines Dateinamens
const int MAXL=1000;

inline int idfix(double x) {return int((x>=0.0) ? x+0.5 : x-0.5);} //Runden

bool fastgleich(double x1,double x2,double d=0.001)
{
 double d2=x2-x1; if(d2<0) d2 = -d2;
 return (d2<d);
}

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}


// Umgang mit Dateien:
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

bool vorhanden(const char *dateiname)
{
 struct stat buf;
 return (lstat(dateiname,&buf)>=0);
}

bool istordner(char *dateiname)
{
 struct stat buf;
 if(lstat(dateiname,&buf)<0) return false;
 //if(buf.st_mode & S_IFDIR) return true;
 if((buf.st_mode & S_IFMT)==S_IFDIR) return true;
 return false;
}
bool istregulaer(char *dateiname) //Regulaere Datei ohne Softlink ohne Ordner
{
 struct stat buf; //siehe man lstat
 //(Fehler in man lstat: S_IFMT ist nicht 0017000 sondern 0170000)
 if(lstat(dateiname,&buf)<0) return false;
 if((buf.st_mode & S_IFMT)==S_IFREG) return true;
 return false;
}
bool istsoftlink(char *dateiname)
{
 struct stat buf;
 if(lstat(dateiname,&buf)<0) return false;
 if((buf.st_mode & S_IFMT)==S_IFLNK) return true;
 return false;
}

bool istbilddatei(const char *name) //Bilddatei anhand der Endung
{
 int n=strlen(name);
 if(n<5) return false;
 if(name[n-4]=='.')
   return (strcmp(&name[n-3],"jpg")==0 || strcmp(&name[n-3],"JPG")==0 ||
	   strcmp(&name[n-3],"gif")==0 || strcmp(&name[n-3],"GIF")==0 ||
	 //strcmp(&name[n-3],"ppm")==0 || strcmp(&name[n-3],"PPM")==0 ||
	   strcmp(&name[n-3],"png")==0 || strcmp(&name[n-3],"PNG")==0);
 else if(n>5 && name[n-5]=='.')
   return (strcmp(&name[n-4],"jpeg")==0 || strcmp(&name[n-4],"JPEG")==0);
 return false;
}

int anzahlblanks(const char *s) //zaehle Anzahl Leerstellen im String
{                               //und Klammern auch
 int c,n=0;
 while((c= *s++)!=0)
    if(c==' ' || c=='(' || c==')') n++;
 return n;
}

char *escapeblanks(const char *s,int nb)
{
 char *name2=new char[strlen(s)+nb+1];
 char *p=name2;
 int c;
 while((c= *s++)!=0)
   {if(--nb>=0 && (c==' ' || c=='(' || c==')'))
       *p++ = '\\'; //vor jede Leerstelle oder Klammer ein \ setzen
    *p++ = c;
   }
 *p=0;
 return name2;
}

char *entferneblanks(const char *s)
{
 char *name2=new char[strlen(s)+1];
 char *p=name2;
 int c;
 while((c= *s++)!=0)
   {if(c==' ' || c=='(' || c==')')
       c = '_'; //Leerstelle oder Klammer durch _ ersetzen
    *p++ = c;
   }
 *p=0;
 return name2;
}

class Aktuellerpfad
{
 char *pfad;
 char *liste[MAXL];//fuer Speicherrueckgabe
 int imax;
public:
 Aktuellerpfad() {pfad=NULL; imax=0;}
 ~Aktuellerpfad() {if(pfad!=NULL) delete[] pfad; loeschen();}
 void set(const char *arg0)
	{char *s; int n=strlen(arg0);
	 if(pfad!=NULL) delete[] pfad;
	 pfad=new char[n+1];
	 strcpy(pfad,arg0);
	 for(s= &pfad[n];*--s!='/';) ;
	 *s=0;
	 setenv("PWD",pfad,1);
	}
 void cd(const char* ordner);
 FILE *fopen2(const char *name,const char *rw);
 const char *vollpfad(const char *name);
 char *getpfad() {if(pfad) return pfad; else return getenv("PWD");}
 void loeschen() {while(imax>0) delete[] liste[--imax];}
};
void Aktuellerpfad::cd(const char* ordner)
{
 const char *s,*altpfad=pfad;
 if(ordner[0]=='/') s="";
 else if(altpfad==NULL) s=getenv("PWD");
 else s=altpfad;
 int n=strlen(s)+strlen(ordner)+2;
 pfad=new char[n];
 if(*s==0) strcpy(pfad,ordner);
 else sprintf(pfad,"%s/%s",s,ordner);
 while(!istordner(pfad) && (n=strlen(pfad))>1)
   {while(--n>1 && pfad[n]!='/') {}
    pfad[n]=0;
   }
 if(altpfad) delete[] altpfad;
}

FILE *Aktuellerpfad::fopen2(const char *name,const char *rw)
{
 FILE *fp;
 if(pfad!=NULL && *name!='/')
  {char str[strlen(pfad)+strlen(name)+2];
   sprintf(str,"%s/%s",pfad,name);
   fp=fopen(str,rw);
  }
 else fp=fopen(name,rw);
 return fp;
}

static int test=0;

const char *Aktuellerpfad::vollpfad(const char *name)
{
 if(name==NULL || *name=='/' || pfad==NULL) return name;
 char *name2=NULL;
 int nb;
 if((nb=anzahlblanks(name))>0) //falls in name Leerstellen sind
   name=name2=escapeblanks(name,nb);
 char vollname[strlen(pfad)+strlen(name)+2];
 sprintf(vollname,"%s/%s",pfad,name);
 int i;
 for(i=0;i<imax;i++)
   if(strcmp(vollname,liste[i])==0) {return liste[i];}
 char *str=new char[strlen(vollname)+1];
 strcpy(str,vollname);
 if(imax<MAXL)
   {liste[imax++]=str;
    if(imax==MAXL && test>0)
      printf("Aktuellerpfad::vollpfad() liste fuer Speichrrueckgabe voll.\n");
   }
 if(name2!=NULL) delete[] name2;
 return str;
}

static Aktuellerpfad pwd;
inline FILE *fopen2(const char *na,const char *rw) {return pwd.fopen2(na,rw);}
inline const char *vollpfad(const char *s) {return pwd.vollpfad(s);}
inline bool vorhanden2(const char *name) {return vorhanden(vollpfad(name));}

#include <errno.h>
void fehlermeldung(int err)
{
 if(err== -1) err=errno;
#ifdef EEXIST
 if(err==EEXIST) printf("EEXIST - Datei schon vorhanden.\n");
 else if(err==EROFS) printf("EROFS - nur lesbar\n");
 else if(err==ENOMEM) printf("ENOMEM - nicht genug Kernelspeicher\n");
 else if(err==EACCES) printf("EACCES - kein Schreibrecht\n");
 else
#endif
    printf("Fehlercode %d: siehe \"more /usr/include/asm*/errno*.h\"\n",err);
}

void system1(const char *s,int k)
{
 if(test>=2) printf("system%d> %s\n",k,s);
 int n=system(s);
 if(n!=0)
   {if(n==127) printf("Fehler %d in system(): fehlendes /bin/sh\n",n);
    else if(n<0) {printf("Fehler %d in system(%s)\n",n,s); fehlermeldung(n);}
    else if(test>=2) printf("Rueckgabewert von system() = %d\n",n);
   }
}

void system2(const char *s,const char *p1,const char *p2=NULL)
{
 char str[3*N80];
 sprintf(str,s,vollpfad(p1),vollpfad(p2));
 system1(str,2);
}

char *ohneletztenpunkt(char *name)  /* die Endung .xxx loeschen */
{
 char c=0,*s; int i;
 for(i=0,s=name;*s!=0;s++,i++) ;
 while(i>0 && (c= *s)!='.')
        {--i; --s;}
 if(c=='.') *s='\0';
 return name;
}

char *anhaengen(char *s,const char *t)  /* s + t --> s */
{
 char *p;
 for(p=s;*p!=0;p++) ;
 for(;*p++ = *t++;) ;
 return s;
}

char *endungersetzen(char *neu,const char *name,const char *endung)
{
 strcpy(neu,name); ohneletztenpunkt(neu);
 return anhaengen(neu,endung);
}

bool istppm(const char *name)
{
 int i=0;
 while(name[i]!=0 && name[i]!='.') {i++;}
 return (strcmp(&name[i],"ppm")==0);
}

bool hatendung(const char *name,const char *endung)
{
 int i=0;
 while(name[i]!=0 && name[i]!='.') {i++;}
 return (strcmp(&name[i],endung)==0);
}

double zufall4()	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* bisher bester Zufallsgenerator   */
 static double x=581;
 double y;
 if(x==0.) x=581;
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}

double zufall() //Zufallszahl zwischen -1.0 und +1.0
{
 return zufall4()*2-1;
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/****************************** Klassen *******************************/
class Bild
{
public:
 int breite,hoehe,tiefe,nx,ny;
 uchar *data; //[ny][nx*3] fuer RGB je 1 Byte pro Bildpunkt
 int mingrau,maxgrau;
 uint mittelgrau;
 Bild() {breite=hoehe=tiefe=0; nx=ny=32; data=NULL; mingrau=0; maxgrau=255; mittelgrau=127;}
 Bild(int N,int M) {breite=nx=N; hoehe=ny=M; tiefe=255; data=new uchar[N*M*3]; mingrau=0; maxgrau=255;}
 ~Bild() {if(data!=NULL) {delete[] data; data=NULL;}}
 void init(int N,int M) {breite=nx=N; hoehe=ny=M; tiefe=255; data=new uchar[N*M*3]; mingrau=0; maxgrau=255;}
 void setpixel(int j,int i,int wert)
  {
   if(data==NULL)
    {
     if(breite==0 || hoehe==0 || tiefe==0) {printf("Fehler in bild.setpixel()\n");}//TODO: Fehler
     data = new uchar[breite*hoehe*3];
    }
   data[j*(breite*3)+i]=wert;
  }
 int get(int j,int i) //j=Zeile, i/3 = Spalte: (i+0)=R, i+1=G, i+2=B
  {if(data==NULL) {printf("Fehler1\n"); return 0;}
   return data[j*(breite*3)+i];
  }
 int getgrau(int j,int i) //j=Zeile, i = Spalte
  {if(data==NULL) {printf("Fehler2\n"); return 0;}
   int i0=j*(breite*3)+i*3;
   int grau = (data[i0]+data[i0+1]+data[i0+2])/3;
   return grau;
  }
 void setgrau(int j,int i,int grau) //j=Zeile, i = Spalte, grau: 0...255
  {if(data==NULL) {printf("Fehler3\n"); return;}
   int i0=j*(breite*3)+i*3;
   data[i0+2]=data[i0+1]=data[i0] = grau;
  }
 void setgrauR(int grau)
  {if(data==NULL) {printf("Fehler4\n"); return;}
   for(int j=0;j<hoehe;j++)
    for(int i=0;i<breite*3;i+=3)
     {int i0=j*(breite*3)+i*3;
      data[i0+2]=data[i0+1]=data[i0];
     }
  }
 void minmaxpixel()
  {mingrau=255; maxgrau=0; mittelgrau=0;
   int n=0;
   for(int i=0;i<breite;i++)
    for(int j=0;j<hoehe;j++)
     {
      int grauwert = (get(j,i)+get(j,i*3+1)+get(j,i*3+2))/3;
      if(grauwert<mingrau) mingrau=grauwert;
      if(grauwert>maxgrau) maxgrau=grauwert;
      mittelgrau += grauwert; n++;
     }
   mittelgrau /= n;
  }
 int ausschnitt_mittelgrau(int x0,int y0,int n,int m)
 { int mgrau=0, k=0;
   if(x0<0) x0=0;
   if(y0<0) y0=0;
   for(int i=x0;i<x0+n && i<breite;i++)
    for(int j=y0;j<y0+m && j<hoehe;j++)
     {mgrau += getgrau(j,i); k++;}
   mgrau /= k;
   return mgrau;
  }
 int ausschnitt_schwellgrau(int x0,int y0,int n,int m)
  {int min=255,max=0,grau;
   if(x0<0) x0=0;
   if(y0<0) y0=0;
   for(int i=x0;i<x0+n && i<breite;i++)
    for(int j=y0;j<y0+m && j<hoehe;j++)
     {
      grau = getgrau(j,i);
      if(grau!=255) //ganz weisse Pixel ausgenommen
       {if(grau>max) max=grau;
	if(grau<min) min=grau;
       }
     }
   int schwelle = (min+max)/2+(max-min)*4/16; //TODO: ev. *5/16 oder *3/16
   return schwelle;
  }
 int ausschnitt_schwellschwarz(int x0,int y0,int n,int m)
  {int min=255,max=0,grau;
   if(x0<0) x0=0;
   if(y0<0) y0=0;
   for(int i=x0;i<x0+n && i<breite;i++)
    for(int j=y0;j<y0+m && j<hoehe;j++)
     {
      grau = getgrau(j,i);
      if(grau!=255 && grau!=0) //ganz weisse und ganz schwarze Pixel ausgenommen
       {if(grau>max) max=grau;
	if(grau<min) min=grau;
       }
     }
   //int schwelle = (min+max)/2-(max-min)*3/16; //TODO: ev. *5/16 oder *3/16
   int schwelle = (min+max)/2; //TODO
   return schwelle;
  }
};
static Bild bild;

//Vordeklarationen:
void umrechnung_nxm_nach_32x32(Bild &quelle,Bild &ziel);
void umrechnung_nxm_nach_32x32_randweiss(Bild &quelle,Bild &ziel);

#define NINP 1024 //32*32
#define NOUT 128  //Anzahl ASCII-Zeichen
#ifdef HIDDEN32x32
#define NZWI 1024 //32*32
#else
#define NZWI 257  //16*16 + 1 fuer Zeichenerkennung
#define ZE (NZWI-1) //Zeichenerkennung mit H[ZE]
#endif
#define NX NINP //Anzahl Eingabeneuronen
#define NH NZWI //Anzahl Zwischenschichtneuronen
#define NY NOUT //Anzahl Ausgabeneuronen
#define ZEOUT (NY-1) //Zeichenerkennung mit Y[ZEOUT]
#define BIASX NX
#define BIASH NH

static double X[NX+1]; //Eingabeneuronen + Bias, Werte von 0.0 bis 1.0
static double H[NH+1]; //Zwischenschicht(Hidden) + Bias (H[NH] ist Bias, H[NH-1] ist Zeichenerkennung)
static double Y[NY]; //Ausabeneuronen, Werte von 0.0 bis 1.0
static uchar gelernt[NY];

static double w1[NX+1][NH+1]; //w1[i][k]
static double w2[NH+1][NY];   //w2[k][j]

#ifndef W1FIXIERT
static double w1_bak[NX+1][NH+1];
#endif
static double w2_bak[NH+1][NY];

void m_anzeigen()
{
 int antw=1;
 printf("w1[]=\n");
 for(int i=0;i<=NX;i++)
  {
   for(int k=0;k<=NH;k++)
    printf("%7.4f ",w1[i][k]);
   printf("\n");
   if(antw!=2) {printf("Weiter? (1=ja, 0=Abbruch, 2=weiter):"); scanf("%d",&antw);}//test
   if(antw==0) break;//test
  }
 printf("w2[]=\n");
 antw=1;
 for(int j=0;j<NY;j++)
  {
   for(int k=0;k<=NH;k++)
    printf("%7.4f ",w2[k][j]);
   printf("\n");
   if(antw!=2) {printf("Weiter? (1=ja, 0=Abbruch, 2=weiter):"); scanf("%d",&antw);}//test
   if(antw==0) break;//test
  }
}

#ifdef HIDDEN32x32

void m_wertesetzen()
{
 //w1- und w2-Werte von Hand berechnet setzen:
 // wenn NX==NH:
 for(int i=0;i<=NX;i++)
  for(int k=0;k<=NH;k++)
    {if(i==k) w1[i][k] = 1.0;
     else     w1[i][k] = 0.0;
    }
 //gesamtes w2-Feld auf 0 setzen:
 for(int j=0;j<NY;j++)
  for(int k=0;k<=NH;k++)
    w2[k][j] = 0;
 //Zeichenerkennung:
 const double wert=1.0/4; //TODO
 for(int iy=0;iy<32;iy++)
  {bool randflag1 = (iy<1 || iy>32-2);
   bool mittflag1 = (iy>1 && iy<32-2);
   for(int ix=0;ix<32;ix++)
    {bool randflag = (randflag1 || ix<2 || ix>32-3);
     bool mittflag = (mittflag1 && ix>2 && ix<32-3);
     int i=iy*32+ix;
     if(randflag)      w2[i][ZEOUT] = -1.0;
     else if(mittflag) w2[i][ZEOUT] = wert;
     else              w2[i][ZEOUT] = wert/2;
    }
  }
 w2[BIASH][ZEOUT] = -4;//TODO: Schwellwert fuer Zeichenerkennung
}

#else //HIDDEN32x32

void m_wertesetzen()
{
 //w1- und w2-Werte von Hand berechnet setzen:
 /* wenn NX==32*32 und NH==16*16+1 (+1 fuer Zeichenerkennung (ZE)): */
 for(int i=0;i<=NX;i++)
  {
   for(int k=0;k<=NH;k++)
     w1[i][k]=0;
  }
 w1[NX][NH] = 1.0; //Bias von Eingang auf Zwischenschicht auf 1 setzen
 for(int ky=0;ky<16;ky++)
  for(int kx=0;kx<16;kx++)
   {int k=ky*16+kx;
    for(int iy=ky*2,ny=0;ny<2;iy++,ny++)
     for(int ix=kx*2,nx=0;nx<2;ix++,nx++)
      {int i=iy*32+ix;
       w1[i][k] = 0.25; //Durchschnitt von 4 Pixeln vom 32x32-Feld aufs 16x16-Feld
      }
   }
 //gesamtes w2-Feld auf 0 setzen:
 for(int j=0;j<NY;j++)
  {
   for(int k=0;k<=NH;k++)
     w2[k][j] = 0;
  }
 //Zeichenerkennung:
 const double wert=1.0/4; //TODO
 for(int iy=0;iy<32;iy++)
  {bool randflag1 = (iy<1 || iy>32-2);
   bool mittflag1 = (iy>1 && iy<32-2);
   for(int ix=0;ix<32;ix++)
    {bool randflag = (randflag1 || ix<2 || ix>32-3);
     bool mittflag = (mittflag1 && ix>2 && ix<32-3);
     int i=iy*32+ix;
     if(randflag)      w1[i][ZE] = -1.0;
     else if(mittflag) w1[i][ZE] = wert;
     else              w1[i][ZE] = wert/2;
    }
  }
 w1[BIASX][ZE] = -4;//TODO: Schwellwert fuer Zeichenerkennung
 //war falsch: w2[ZEOUT][BIASH] = -4;//TODO: Schwellwert fuer Zeichenerkennung
 w2[BIASH][ZEOUT] = -4;//TODO: Schwellwert fuer Zeichenerkennung
 
 /*
 printf("w1[i][ZE] zur Zeichenerkennung:\nw1: ");//test 
 for(int iy=0;iy<32;iy++)
  {
   for(int ix=0;ix<32;ix++)
    {int i=iy*32+ix;
     printf("%g ",w1[i][ZE]);
    }
   printf("\n");
  }//test
 */

 int k=ZE, j=ZEOUT;
 w2[k][j] = 1.0;//fuer Zeichenerkennung
}
#endif //HIDDEN32x32

void zufallsvarieren_w1()
{
 static int ntwert=1, zaehler=0;
 for(int i=0;i<=NX;i++)
  for(int k=0;k<=NH;k++)
   {
    double z=zufall4(); //Zufallszahl zwischen 0 und 1
    if(z<1.0/ntwert) //nur jeder n. w-Wert varieren
     w1[i][k] = zufall(); //Zufallszahl zwischen -1.0 und +1.0
   }
 if(++zaehler>100)
  {zaehler=0;
   if(++ntwert>50) ntwert=1;
  }
}

void zufallsvarieren_w2()
{
 static int ntwert=1, zaehler=0;
 for(int j=0;j<NY;j++)
  for(int k=0;k<=NH;k++)
   {
    double z=zufall4(); //Zufallszahl zwischen 0 und 1
    if(z<1.0/ntwert) //nur jeder n. w-Wert varieren
     w2[k][j] = zufall(); //Zufallszahl zwischen -1.0 und +1.0
   }
 if(++zaehler>100)
  {zaehler=0;
   if(++ntwert>50) ntwert=1;
  }
}

void zufall_w2()
{
 for(int j=0;j<NY;j++)
  for(int k=0;k<=NH;k++)
    w2[k][j] = zufall(); //oder zufall4() ?
}

void zufall_w1()
{
 for(int i=0;i<=NX;i++)
  for(int k=0;k<=NH;k++)
    w1[i][k] = zufall(); //oder zufall4() ?
}

void neuronen_init()
{
#ifdef HIDDEN32x32
 int ok=nnw_einlesen("NeuronalesNetzwerkGross.dat");
#else
 int ok=nnw_einlesen("NeuronalesNetzwerk.dat");
#endif
 if(!ok)
  {
   for(int k=0;k<=NH;k++)
    {
     for(int i=0;i<=NX;i++)
      if(k==NH) w1[i][k]=0.0; else //test
       w1[i][k] = zufall4(); //TODO: zufall() oder zufall4() ?
     for(int j=0;j<NY;j++)
      if(k==NH) w2[k][j]=0.0; else //test
       w2[k][j] = zufall(); //TODO: zufall() oder zufall4() ?
    }
  }
 X[NX] = 1.0; //Bias immer auf 1 setzen
 /*
 //TODO: setzen der bisher gelernten Zeichen:
 for(int j=0;j<NY;j++) gelernt[j]=0;
 for(int j='A';j<='Z';j++) gelernt[j]=1;
 //for(int j='a';j<='z';j++) gelernt[j]=1;
 //for(int j='0';j<='9';j++) gelernt[j]=1;
 gelernt[ZEOUT]=1;
 */
 printf("neuronen_init() gelernt[%d]=%d\n",ZEOUT,gelernt[ZEOUT]);//test
 printf(" gelernt[%d]=%d\n",'A',gelernt['A']);//test
 printf(" gelernt[%d]=%d\n",'B',gelernt['B']);//test
 printf(" gelernt[%d]=%d\n",'C',gelernt['C']);//test
 printf(" gelernt[%d]=%d\n",'1',gelernt['1']);//test
 printf(" gelernt[%d]=%d\n",'2',gelernt['2']);//test
 printf(" gelernt[%d]=%d\n",'3',gelernt['3']);//test
}

void teilbild_zeichnen(double xmi,double ymi,double xma,double yma,Bild& bi,
		       int nx=0,int ny=0,int x0=0,int y0=0)
{
 if(nx==0 || ny==0) {nx=bi.breite; ny=bi.hoehe;}
 double dx=(xma-xmi)/nx, dy=(yma-ymi)/ny;
 inital_new();
 for(int j=0; j<ny; j++)
  {double y2=yma-j*dy, y1=y2-dy;
   for(int i=0; i<nx; i++)
      {double x1=i*dx+xmi, x2=x1+dx;
       int grau=bi.getgrau(j+y0,i+x0); rgbcolor(grau,grau,grau);
       fillbox(x1,y1,x2,y2);
      }
  }
 term_refresh();
}
 
void teilbild_kopieren(int x0,int y0,int nx,int ny,Bild& quelle,Bild& ziel)
{
 ziel.init(nx,ny);
 for(int x=0;x<nx;x++)
  for(int y=0;y<ny;y++)
   {int grau=quelle.getgrau(y0+y,x0+x);
    ziel.setgrau(y,x,grau);
   }
}

void eingabe_an_neuronen(Bild& bil,int j0,int i0,int zflag=0) //wenn zflag gesetzt: Teilbild zeichnen
{
 Bild teilbild;
 double ho,br,ypos;
 //printf("eingabe_an_neuronen(..., zflag=%d)\n",zflag);//test
 if(zflag) {ho=(g_ymax-g_ymin)/4; br=ho; ypos=g_ymax;} //Werte zum Teilbild zeichnen
 if(bil.nx==32 && bil.ny==32)
  {
   teilbild_kopieren(i0, j0, bil.nx, bil.ny, bil, teilbild);
   if(zflag>=2) teilbild_zeichnen(g_xmin, ypos-ho, g_xmin+br, ypos, teilbild);
  }
 else
  {
   Bild bi;
   teilbild_kopieren(i0, j0, bil.nx, bil.ny, bil, bi);
   if(zflag>=2) {teilbild_zeichnen(g_xmin, ypos-ho, g_xmin+br, ypos, bi); ypos -= ho+ho/32;}
   umrechnung_nxm_nach_32x32_randweiss(bi,teilbild);
   if(zflag) {teilbild_zeichnen(g_xmin, ypos-ho, g_xmin+br, ypos, teilbild); ypos -= ho+ho/32;}
  }
 int wert, n=0;
 double summegrau=0;
 //double mingrau=1.0, maxgrau=0.0;//test
 //printf("eingabe_an_neuronen(j0=%d,i0=%d)\n",j0,i0);//test
 for(int j=0;j<32;j++)
  for(int i=0;i<32;i++)
    {
     wert = teilbild.getgrau(j,i); //j=Zeile, i=Spalte
     double grauwert = 1.0-wert/255.0; //1.0=schwarz 0.0=weiss
     summegrau += grauwert;
     X[n++] = grauwert;
     //if(grauwert>maxgrau) maxgrau=grauwert;//test
     //if(grauwert<mingrau) mingrau=grauwert;//test
    }
 //printf("mingrau=%f maxgrau=%f\n",mingrau,maxgrau);//test
 int nmax=n;
 //double mittleres_grau = summegrau/nmax;
 double mittleres_grau = 1.0 - teilbild.ausschnitt_schwellgrau(0,0,32,32)/255.0;
 //printf("mittleres_grau=%f nmax=%d\n",mittleres_grau,nmax);//test
 for(n=0;n<nmax;n++)
  {
   //X[n] = (X[n] < mittleres_grau) ? -1.0 : 1.0; //??
   X[n] = (X[n] < mittleres_grau) ? 0.0 : 1.0;
  }
 if(zflag) neuronen_rechts_zeichnen(X,32,32);
#ifdef HIDDEN32x32
 if(zflag>=2) {propagieren(); neuronen_rechts_zeichnen(H,32,32);}//TODO
#else
 if(zflag>=2) {propagieren(); neuronen_rechts_zeichnen(H,16,16);}//TODO
#endif
}

void propagieren()
{
 const double ks=0.05; //Konstante Skalierung //TODO

 /*
 printf("X[%d]=\n",NX+1);//test
 int test=0;//test
 for(int i=0;i<=NX;i++)//test
  {//printf("%g ",X[i]);//test
   if(X[i]==0) printf(". "); else if(X[i]==1) printf("1 "); else printf("? ");
   if(++test==32) {printf("\n"); test=0;}//test: Zeilenumbruch alle 32 Zahlen
  }//test
  printf("\n");//test
 */
 
 for(int k=0;k<=NH;k++)
  {
   H[k]=0;
   for(int i=0;i<=NX;i++)
    {
     H[k] += w1[i][k]*X[i];
    }
   //fuer Hidden-Neuronen entweder Abs-Funktion oder Sigmoid-Funktion, was ist besser?
   //Abs-Funktion:
   //if(H[k] < 0.0001) H[k]=0.0001;
   if(H[k] < 0) H[k]=0;
   //Sigmoid-Funktion:
   //double x=H[k];
   //H[k] = (1.0/(1.0+exp(-x*ks)))*2-1;
   //printf("H[%d]=%g ",k,H[k]);//test
  }

 if(argflag['V']) //test
  {printf("\nH[%d]=\n",NH+1);//test
   test=0;
   for(int k=0;k<=NH;k++)
    if(k>=NH-1) {printf("%g ",H[k]);}
    else {
     if(H[k]==0) printf(". "); else if(H[k]==1) printf("1 "); else if(H[k]==0.5) printf("; "); else printf("? ");
     if(++test==16) {printf("\n"); test=0;}//Zeilenumbruch alle 16 Zahlen
    }
   printf("\n");
  }//test
 
 for(int j=0;j<NY;j++)
  if(gelernt[j])
  {
   Y[j]=0;
   for(int k=0;k<=NH;k++)
    {
     Y[j] += w2[k][j]*H[k];
    }
   //Sigmoid-Funktion fuer Ausgabeneuronen:
   double x=Y[j];
   Y[j] = 1.0/(1.0+exp(-x*ks));
   //printf("x=%f Y[%d]=%f\n",x,j,Y[j]);//test
  }
}

void m_scannen()
{
 eingabe_an_neuronen(bild,shifty,shiftx,2);
 propagieren();
 printf("m_scannen()\nZeichenerkennung:  Y[%d]=%f\n",ZEOUT,Y[ZEOUT]);//test
 double max= -2, min=2, max2= -2;
 double summe=0; int ns=0;//test
 int jmax=0,jmin=0,jmax2=0;
 for(int j=0;j<NOUT-1;j++)
  if(gelernt[j])
   {
    double x=Y[j];
    //printf("j=%d x=%f\n",j,x);//test
    summe += x; ns++;//test
    if(x>max) {max2=max; jmax2=jmax; max=x; jmax=j;}
    else if(max2== -2 && x==max) {max2=x; jmax2=j;}
    if(x<min) {min=x; jmin=j;}
   }
 printf("Kleinster Wert: %d: %f\n",jmin,min);
 printf("Zweitgroesster: %d: %f\n",jmax2,max2);
 printf("Groesster Wert: %d: %f\n",jmax,max);
 printf("x durchschnitt: %f\n",summe/ns);//test
 char c = isprint(jmax) ? jmax : '?';
 printf("Resultat von Neuronalem Netz: 0x%02X = \'%c\'\n",jmax,c);
}

void m_scannen2() //Lerndaten ueberpruefen
{
 printf("m_scannen2()\n");//test
 int soll;
 for(soll='A';soll<='Z';soll++)
  {
   von_lernliste_einlesen(soll);
   eingabe_an_neuronen(bild,shifty,shiftx);
   propagieren();
   printf("soll=%c\nZeichenerkennung:  Y[%d]=%f\n",soll,ZEOUT,Y[ZEOUT]);//test
   double max= -2;
   int jmax=0;
   for(int j=0;j<NOUT-1;j++)
    if(gelernt[j])
     {
      double x=Y[j];
      if(x>max) {max=x; jmax=j;}
     }
   char c = isprint(jmax) ? jmax : '?';
   printf("Sollwert: 0x%02X \'%c\'\n",soll,soll);
   printf("Resultat von Neuronalem Netz: Y[j]=%f 0x%02X = \'%c\'\n",max,jmax,c);
  }
}

double scannen_test(int x0,int y0)
{
 eingabe_an_neuronen(bild,y0,x0);
 propagieren();
 double zeichenerkennung=Y[ZEOUT];
 double max= -2;
 for(int j=' ';j<'z';j++)
  {
   if(gelernt[j])
    {
     double x=Y[j];
     if(x>max) {max=x;}
    }
  }
 if(max<0.8) return 0;
 return zeichenerkennung;
}

double propagieren_zeichenerkennung(int *zeichen,double *wert)
{
 propagieren();
 double zeichenerkennung=Y[ZEOUT];
 double max= -1;
 int jmax=0;
 for(int j=0;j<ZEOUT;j++)
  {
   if(gelernt[j])
    {
     double x=Y[j];
     if(x>max) {max=x; jmax=j;}
    }
  }
 *zeichen = jmax;
 *wert = max;
 return zeichenerkennung;
}
 
int zeichen_suchen(int startx0,int starty0,int y2,int maxx0,int maxy0,int schwelle,double* bestwert)
{
 int zeichen=0,zaehler=0;
 *bestwert=0;
 //for(int x0=startx0,y0=starty0; y0<starty0+hoehe-8;)
 for(int x0=startx0,y0=starty0; y0<maxy0-8;)
  {
   while(bild.getgrau(y0,x0)>schwelle && bild.getgrau(y2,x0)>schwelle)
    {if(++x0 >= maxx0-4) break;}
   if(bild.getgrau(y0,x0+1)<=schwelle) x0++;
   if(bild.getgrau(y2,x0+1)<=schwelle) x0++;
   int grau=bild.getgrau(y0,x0);
   int grau2=bild.getgrau(y2,x0);
   int grau3=bild.getgrau((y0+y2)/2,x0);
   if(grau<grau2 && grau<grau3) {}//dunkelster Pixel bei y0
   else if(grau2<grau && grau2<grau3) y0=y2;
   else y0=(y0+y2)/2;
   shiftx=x0; shifty=y0;
   bild.nx=bild.ny=8;//TODO: etwa halbe minimale Buchstabengroesse
   //printf("Startpunkt fuer zeichen_erkennung_von_mitte(): shiftx=%d shifty=%d nx=8 ny=8\n",shiftx,shifty);//test
   zeichen_erkennung_von_mitte(0);
   double wert;
   double erkennung=propagieren_zeichenerkennung(&zeichen,&wert);
   //printf("erkennung=%f zeichen='%c' wert=%f\n",erkennung,zeichen,wert);//test
   //if(wert>0.65 && erkennung>0.65) {*bestwert=wert; break;}
   if(wert>0.65 && erkennung>0.65) {*bestwert=wert; break;} //TODO: Werte anpassen
   //if((x0 += bild.nx) > startx0+breite-8)  {y0 += bild.ny;}
   if((x0 += bild.nx) > maxx0-8)  {x0=startx0; y0 += bild.ny;}
   if(++zaehler>100) break;//test
  }
 return zeichen;
}

void m_wortscannen()
{
 printf("m_wortscannen()\n");//test
 int x0=shiftx, y0=shifty;
 int startx0=x0, starty0=y0;
 int breite=bild.nx, hoehe=bild.ny;
 if(breite<=32) breite=bild.breite-startx0;
 else if((x0+breite)>bild.breite) breite=bild.breite-x0;
 if(hoehe<=32) hoehe=bild.hoehe-starty0;
 else if((y0+hoehe)>bild.hoehe) hoehe=bild.hoehe-y0;
 bild.nx=breite; bild.ny=hoehe;//test
 m_refresh();//test
 int maxx0=startx0+breite;
 int maxy0=starty0+hoehe;
 printf("maxx0=%d maxy0=%d\n",maxx0,maxy0);//test
 //Bereich mit dunkeln Pixeln suchen:
 int schwelle = bild.ausschnitt_schwellschwarz(x0,y0,breite,hoehe);
 //kleinerer Wert von schwelle ist dunkeler Pixel
 printf("schwelle=%d\n",schwelle);//test
 int i,j,grau;
 for(j=0;j<hoehe;j++)
  {for(i=0;i<breite;i++)
    {
     grau=bild.getgrau(y0+j,x0+i);
     if(grau<schwelle) break;
    }
   if(grau<schwelle) break;
  }
 printf("oberster dunkler Pixel gefunden bei x=%d y=%d\n",x0+i,y0+j);//test
 starty0=y0+j;
 for(i=0;i<breite;i++)
  {for(j=0;j<hoehe;j++)
    {
     grau=bild.getgrau(y0+j,x0+i);
     if(grau<schwelle) break;
    }
   if(grau<schwelle) break;
  }
 printf("linkster dunkler Pixel gefunden bei x=%d y=%d\n",x0+i,y0+j);//test
 startx0=x0+i;
 startx0 += 4;//TODO: halbe minimale Buchstabengroesse
 starty0 += 8;//TODO: halbe minimale Buchstabengroesse
 double bestwert=0;
 int zeichen=0;
 //von links nach rechts und oben nach unten suchen:
 y0=starty0; //auf dieser Linie testen fuer ersten Buchstabe
 int y2=starty0+8; //zweite zu testende Linie
 if(y2+shifty > bild.hoehe-4) y2=bild.hoehe-4;
 printf("Testlinien fuer Suche von erstem Buchstaben: y0=%d y2=%d\n",y0,y2);//test
 zeichen=zeichen_suchen(startx0,starty0,y2,maxx0,maxy0,schwelle,&bestwert);
 x0=shiftx; y0=shifty; //bild.nx und bild.ny wurde auch gesetzt wenn erfolgreich
 int zaehler=0;
 char text[80];
 if(bestwert==0) printf("keine Zeichen gefunden\n");
 else
  {printf("Erstes gefundenes Zeichen bei x=%d y=%d %dx%d: '%c'\n",x0,y0,bild.nx,bild.ny,zeichen);//test
   printf("bestwert=%f\n",bestwert);//test
   m_refresh();//test
   printf("nachfolgende Zeichen:\n");//test
   startx0=shiftx+bild.nx;
   starty0=shifty+bild.ny/2;
   y2=starty0+bild.ny/4;
   text[0]=zeichen;
   for(zaehler=1; startx0+x0<bild.breite-8;)
    {
     zeichen=zeichen_suchen(startx0,starty0,y2,maxx0,maxy0,schwelle,&bestwert);
     if(bestwert==0) {break;}
     text[zaehler++]=zeichen;
     int c=zeichen; if(!isprint(c)) {c='?'; printf("zeichen=%d\n",zeichen);}//test
     printf(" Zeichen bei x=%d y=%d %dx%d: '%c'\n",shiftx,shifty,bild.nx,bild.ny,c);//test
     printf(" bestwert=%f\n",bestwert);//test
     m_refresh();//test
     int tmp=startx0;
     startx0=shiftx+bild.nx;
     if(startx0<=tmp) startx0=tmp+8;
     starty0=shifty+bild.ny/2;
     y2=starty0+bild.ny/4;
     if(zaehler>=80) break;//test
    }
   printf("Total %d Zeichen in Wort gefunden\n",zaehler);//test
   text[zaehler]=0;
   printf("gefundenes Wort:\"%s\"\n",text);
  }
 //TODO
}

/************************* Menu Behandlung ****************************/
static int exitflag=0;
static char quellname[200],zielname[200];
void menu_exit() {exitflag=1;}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 quellname[0]=zielname[0]=0;
 int i,j=0,c;
 int breite,hoehe,tiefe,visklasse;
 if(argc>0)
  {
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else if(++j==1) strcpy(quellname,argv[i]);
	 else if(j==2) strcpy(zielname,argv[i]);
	}
  }
 if(argflag['?'] || j>MAXARG)
	{printf("halesen  %s\n",VERSION);
	 printf("Anwendung: %s [-Flags] [Quelle] [Ziel]\n",argv[0]);
	 printf("  Qeulle.ppm fuer Bild, Quelle.txt fuer Lerndaten\n");
	 printf("  Flags: v=verbose (Testpunkte drucken)\n");
	 printf("         L=Lernen von Quelle (lerndaten.txt)\n");
	 exit(0);
	}
 if(argflag['L'] && quellname[0]!=0)
  {
   if(!hatendung(quellname,".txt")) {printf("Fehler: Lerndatei muss Endung .txt haben\n"); exit(0);}
   strncpy(lerndatei[0],quellname,200);
   char name[200];
   FILE *fp=fopen(quellname,"r");
   if(fp!=NULL)
    {fscanf(fp,"%s",name);
     fclose(fp);
     if(!hatendung(name,".ppm"))
      {printf("fehlende Bilddatei in %s\n",quellname);
       quellname[0]=0;
      }
     else strncpy(quellname,name,200);
    }
  }
 neuronen_init();
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 setsize(breite,hoehe,tiefe);
 setmenu(4,"File",    "Position","Zoom",    "Scannen");
 setmenu(4,"Load ...","Rechts",  "Zoom in", "Werte setzen", menu_load, m_rechts, m_zoomin, m_wertesetzen);
 setmenu(4,"Save ...","Unten",   "Zoom out","Lernen ...", menu_save, m_unten, m_zoomout, m_lernen);
 setmenu(4,"Exit",    "Links", "Zoomfaktor ...","Werte anzeigen",menu_exit,m_links,m_zoomfaktor,m_anzeigen);
 setmenu(4,NULL,      "Oben",   "Totale",     "Scannen",  NULL, m_oben, m_zoomtotale, m_scannen);
 setmenu(4,NULL, "Position ...","Zoom 32x32", "Lerndaten scannen", NULL,m_position, m_zoom32, m_scannen2);
 setmenu(4,NULL,"Lernposition ...","Refresh", "Wort scannen", NULL,m_lernpos, m_refresh, m_wortscannen);
 //set_funktions(maus_gedrueckt,maus_losgelassen,fenster_verdeckung,maus_bewegung);
 set_funktions(maus_gedrueckt,maus_losgelassen,NULL,maus_bewegung);
 inital(g_xmin,g_ymin,g_xmax,g_ymax); /* Grafikfenster oeffnen */
#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss (default ist weiss auf schwarz):
 if(TIEFE==24)
  {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
 else
  {screenclear(1); color(0);}
#endif
 drawbox(0.0,0.0,1.0,1.0); // ein Quadrat zeichnen
 term_refresh();

 if(quellname[0]!=0)
  {
   bild_einlesen(quellname);
#ifndef ERSTER_TEST
   m_zoomtotale();
#endif
  }
 
 if(argflag['L'])
  {
   lerndatei_einlesen();
   erstes_anlernen();
  }
  
 while(exitflag==0 && waitmenu(0)==0) // auf Benutzereingaben warten
  {
   waitBOF();		//auf Ende des Bildaufbaus warten
  }
 term_exit();
 return 0;
}/* ende von main */

void menu_load()
{
 int ok=nachfilenamefragen("Lade Datei",quellname,200);
 if(ok)
  {
   bild_einlesen(quellname);
  }
}

void menu_save()
{
 char dateiname[200]; strcpy(dateiname,"NeuronalesNetzwerk2.dat");
 int ok=nachfilenamefragen("Speichere NeuronalesNetzWerk (NNW)",dateiname,200);
 if(ok)
  {
   FILE *fp=fopen(dateiname,"r");
   if(fp!=NULL)
    {fclose(fp); ok=janeinrequester("Datei schon vorhanden, ueberschrieben?","ja","nein");
     if(!ok) return;
    }
   fp=fopen(dateiname,"w");
   if(fp==NULL) {printf("Konnte Datei \"%s\" nicht erstellen.\n",dateiname); return;}
   fprintf(fp,"%d %d %d %d ;AnzahlEbenen NX NH ... NY\n",3,NX,NH,NY);
   fprintf(fp,"gelernt: ");
   for(int j=0;j<NOUT;j++)
     if(gelernt[j])
      {if(j>' ' && j<='z') fprintf(fp,"'%c' ",j);
       else fprintf(fp,"%d ",j);
      }
   fprintf(fp,"\nw1: ");
   for(int i=0;i<=NX;i++)
    for(int k=0;k<=NH;k++)
     fprintf(fp,"%f ",w1[i][k]);
   fprintf(fp,"\nw2: ");
   for(int k=0;k<=NH;k++)
    for(int j=0;j<NY;j++)
     fprintf(fp,"%f ",w2[k][j]);
   fprintf(fp,"\n");
   fclose(fp);
  }
}

void gelernt_einlesen(FILE *fp)
{
 int c,j;
 //printf("gelernt_einlesen()\n");//test
 while((c=getc(fp))!='\n' && c!=EOF)
  {if(c==' ') continue;
   if(c=='\'')
    {j=getc(fp); c=getc(fp);} //Zeichen als 'X' dargestellt
   else if(isdigit(c))
    {//Sonder-Zeichen als Zahl dargestellt
     ungetc(c,fp);
     fscanf(fp,"%d",&j);
    }
   //printf("gelernt[%d]=1\n",j);//test
   gelernt[j]=1;
  }
}

int nnw_einlesen(const char *name)
{
 FILE *fp=fopen(name,"r"); if(fp==NULL) return 0;
 int c,anz,nx,nh,ny;
 c=fscanf(fp,"%d %d %d %d\n",&anz,&nx,&nh,&ny);
 if(c!=4 || anz!=3) {fclose(fp); printf("Falsche Struktur in \"%s\"\n",name); return 0;}
 if(nx!=NX || nh!=NH || ny!=NY) {printf("NNW Groesse stimmt nicht ueberein\n"); return 0;}
 while((c=getc(fp))!='w' && c!='g' && c!=EOF) {} //suche w1: oder gelernt:
 if((c=getc(fp))=='e')
  {
   while((c=getc(fp))!=':' && c!=EOF) {} //"gelernt:" ueberlesen
   gelernt_einlesen(fp);
   while((c=getc(fp))!='w' && c!=EOF) {} //suche w1:
  }
 while((c=getc(fp))!=':' && c!=EOF) {} //"w1:" ueberlesen
 if(c==EOF) {fclose(fp); printf("w1: fehlt in \"%s\"\n",name); return 0;}
 for(int i=0;i<=NX;i++)
  for(int k=0;k<=NH;k++)
   fscanf(fp,"%lf ",&w1[i][k]);
 while((c=getc(fp))!=':' && c!=EOF) {} //"w2:" ueberlesen
 if(c==EOF) {fclose(fp); printf("w2: fehlt in \"%s\"\n",name); return 0;}
 for(int k=0;k<=NH;k++)
  for(int j=0;j<NY;j++)
   fscanf(fp,"%lf ",&w2[k][j]);
 fclose(fp);
 return 1;
}

void bild_einlesen(const char *name)
{
 char ppmname[200];
 if(!istppm(name))
  {
   endungersetzen(ppmname,name,".ppm");
   system2("convert %s %s",name,ppmname);
  }
 else strcpy(ppmname,name);
 FILE *fp=fopen(ppmname,"rb");
 if(fp==NULL) {printf("kann \"%s\" nicht oeffnen\n",ppmname); quellname[0]=0; return;}
 if(getc(fp)!='P' || getc(fp)!='6') {printf("Fehler in \"%s\": P6 fehlt\n",ppmname); quellname[0]=0; return;}
 getc(fp); //0A ueberlesen
 fscanf(fp,"%d %d",&bild.breite,&bild.hoehe);
 fscanf(fp,"%d",&bild.tiefe);
 printf("breite=%d hoehe=%d tiefe=%d\n",bild.breite,bild.hoehe,bild.tiefe);//test
 if(getc(fp)!='\n') printf("fehlender Zeilentrenner\n");//test
 int i,j,wert;
 //gesamtes Bild einlesen:
 for(j=0; j<bild.hoehe; j++)
  {
   for(i=0; i<bild.breite*3; i++)
    {
     wert = (getc(fp) & 0xFF);
     //if(bild.tiefe>255) {wert <<= 8; wert += (getc(fp) & 0xFF);}
     if(bild.tiefe>255) {getc(fp);} //auf 8Bit pro Farbwert beschraenken
     bild.setpixel(j,i,wert);
    }
  }
 /*
 for(j=0;j<32;j++) //test: Pixel als Zahlen ausgeben
  {printf("Zeile %d:\n",j);
   for(i=0;i<32*3;i+=3)
    {
     int r=bild.get(j,i);
     int g=bild.get(j,i+1);
     int b=bild.get(j,i+2);
     printf("R=%d G=%d B=%d\n",r,g,b);
    }
  }
 */
 fclose(fp);
 bild.minmaxpixel();
 printf("mingrau=%d maxgrau=%d mittelgrau=%d\n",bild.mingrau,bild.maxgrau,bild.mittelgrau);//test
 pixelfeld_zeichnen();
 quellname[0]=0;
}

void pixelfeld_zeichnen()
{
 int i,j, r,g,b;
 int nx=bild.nx, ny=bild.ny;
 double dx=1.0/nx, dy=1.0/ny;
 inital_new();
 for(j=shifty; j<shifty+ny; j++)
  {
   double y1=(ny-1-(j-shifty))*dy, y2=y1+dy;
   for(i=shiftx*3; i<shiftx*3+nx*3; i+=3)
      {
       if(i<bild.breite*3 && j<bild.hoehe)
	{
	 r=bild.get(j,i);
	 g=bild.get(j,i+1);
	 b=bild.get(j,i+2);
	}
       else r=g=b=255;//weisse Pixel am Rand
       rgbcolor(r,g,b);
       double x1=(i/3-shiftx)*dx, x2=x1+dx;
       fillbox(x1,y1,x2,y2);
      }
  }
 term_refresh();
}

void m_rechts()
{
 shiftx += bild.nx;
 if(shiftx>=bild.breite) shiftx=bild.breite-bild.nx;
 pixelfeld_zeichnen();
 printf("shiftx=%d shifty=%d\n",shiftx,shifty);//test
}

void m_unten()
{
 shifty += bild.ny;
 if(shifty>=bild.hoehe) shifty=bild.hoehe-bild.ny;
 pixelfeld_zeichnen();
 printf("shiftx=%d shifty=%d\n",shiftx,shifty);//test
}

void m_links()
{
 if(shiftx>=bild.nx) shiftx -= bild.nx; else shiftx=0;
 pixelfeld_zeichnen();
 printf("shiftx=%d shifty=%d\n",shiftx,shifty);//test
}

void m_oben()
{
 if(shifty>=bild.ny) shifty -= bild.ny; else shifty=0;
 pixelfeld_zeichnen();
 printf("shiftx=%d shifty=%d\n",shiftx,shifty);//test
}

void m_refresh()
{
#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss (default ist weiss auf schwarz):
 if(TIEFE==24)
  {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
 else
  {screenclear(1); color(0);}
#endif
 pixelfeld_zeichnen();
}

void m_zoom32()
{
 bild.nx = 32;
 bild.ny = 32;
 m_refresh();
}

void m_zoomin()
{
 bild.nx /= 2; if(bild.nx<16) bild.nx=16;
 bild.ny /= 2; if(bild.ny<16) bild.ny=16;
 m_refresh();
}

void m_zoomout()
{
 bild.nx *= 2; if(bild.nx>1024) bild.nx=1024;
 bild.ny *= 2; if(bild.ny>1024) bild.ny=1024;
 m_refresh();
}

void m_zoomtotale()
{
 shiftx=0; shifty=0;
 bild.nx = bild.breite;
 bild.ny = bild.hoehe;
 if(bild.ny>bild.nx) bild.nx=bild.ny;
 else if(bild.nx>bild.ny) bild.ny=bild.nx;
 m_refresh();
}

void m_zoomfaktor()
{
 int ok,nx=bild.nx,ny=bild.ny;
 ok=requester_input(2,"Zoomfaktor NX","%d","%d",&nx,
		      "Zoomfaktor NY","%d","%d",&ny);
 if(ok)
  {if(nx>0 && ny>0) {bild.nx=nx; bild.ny=ny;}
   else printf("Eingabefehler: NX und NY muessen groesser 1 sein\n");
  }
 m_refresh();
}

/*
void complement_farbe(int nr) //stark Hardwareabhaengig !
{
 rgbfarbe *p;
 if(nr==0) nr=GRAU2;
 p = &farbpalette[nr];
 setcolor(GRAU2,p->r,p->g,p->b);
}
*/

class Lerndaten {
public:
 int x0,y0,nx,ny,sollwert;
 int iname; //Index fuer lerndatei[]
 Lerndaten() {x0=y0=0; nx=ny=32; sollwert=0; iname=0;}
 void setxysoll(int x,int y,int soll,int xn,int yn) {x0=x; y0=y; sollwert=soll; nx=xn; ny=yn;}
 void getxysoll(int *x,int *y,int *soll,int *xn,int *yn) {*x=x0; *y=y0; *soll=sollwert; *xn=nx; *yn=ny;}
 void setdateiname(int i,const char *name) {strncpy(lerndatei[i],name,200); iname=i;}
 char *getdateiname() {return lerndatei[iname];}
};

static Lerndaten lernliste[1000];//TODO
static int lernliste_jmax=0;

void lerndatei_einlesen()
{
 if(lerndatei[0][0]==0) strcpy(lerndatei[0],"lerndaten.txt");
 FILE *fp=fopen(lerndatei[0],"r"); //Textdatei mit Name von Bilddatei in 1.Zeile, Koord. und Sollwerte weitere Zeilen
 if(fp==NULL) {printf("Datei \"%s\" nicht gefunden\n",lerndatei[0]); return;}
 char zeile[200];
 int j=0,x,y,nx,ny,soll,i;
 while(getline(fp,zeile,200))
  {
   if(!isdigit(zeile[0])) {bild_einlesen(zeile); j=0;}
   else
    {
     sscanf(zeile,"%d %d",&x,&y);
     for(i=1;zeile[i++]!=' ';) {}
     while(zeile[i++]!=' ') {} //2 Leerzeichen ueberlesen
     if(zeile[i]=='\'') soll=zeile[i+1]; else sscanf(&zeile[i],"%d",&soll);
     while(zeile[i]!=0 && zeile[i]!=' ') {i++;}
     if(zeile[i]==0 || sscanf(&zeile[i],"%d %d",&nx,&ny)!=2) {nx=ny=32;}
     lernliste[j++].setxysoll(x,y,soll,nx,ny);
     lernliste_jmax=j;
    }
  }
 fclose(fp);
}

void von_lernliste_einlesen(int soll)
{
 int x,y,soll2,nx,ny;
 if(lernliste_jmax==0) lerndatei_einlesen();
 for(int jlern=0; jlern<lernliste_jmax; jlern++)
  {
   lernliste[jlern].getxysoll(&x,&y,&soll2,&nx,&ny);
   if(soll2==soll) {shifty=y; shiftx=x; bild.nx=nx; bild.ny=ny; return;}
  }
 printf("Fehler: soll=%d nicht in lernliste gefunden\n",soll);
}

#define METHODE_ERSTE    1
#define METHODE_ZUFALL   2
#define METHODE_BACKPROP 3

void m_lernen()
{
 int ok;
 static int methode=1;
 double epsilon=Epsilon;
 static int ivarmax=200000;
 int startzufall=0;
 if(lerndatei[0][0]==0) strcpy(lerndatei[0],"lerndaten.txt");
 //int ok=nachfilenamefragen("Lerndaten",lerndatei,200);
 ok=requester_input(5,"Lerndaten","%s","%s",lerndatei[0],
		    "Epsilon (0.3 bis 0.9)","%f","%f",&Epsilon,
		    "Anzahl Iterationen","%d","%d\n",&ivarmax,
		    "Lernmethode (1=Erstes Lernen, 2=Zufall, 3=Backprop)","%d","%d",&methode,
		    "Start-Zufallswerte (0=nein, 1=w1, 2=w2, 3=beide)","%d","%d",&startzufall);
 if(ok)
  {
   lerndatei_einlesen();
   Epsilon=epsilon;
   if(methode==METHODE_ERSTE) erstes_anlernen();
   else
    {
     if((startzufall&1)==1) zufall_w1();
     if((startzufall&2)==2) zufall_w2();
     trainieren(ivarmax,methode);
    }
  }
}

#define VARIEREN_NEU 1
#define VARIEREN_ZURUECK 2

void neuronen_speichern()
{
#ifndef W1FIXIERT
 for(int i=0;i<=NX;i++)
  for(int k=0;k<=NH;k++)
   w1_bak[i][k] = w1[i][k];
#endif
 for(int j=0;j<NY;j++)
  for(int k=0;k<=NH;k++)
   w2_bak[k][j] = w2[k][j];
}

void neuronen_zurueck()
{
#ifndef W1FIXIERT
 for(int i=0;i<=NX;i++)
  for(int k=0;k<=NH;k++)
   w1[i][k] = w1_bak[i][k];
#endif
 for(int j=0;j<NY;j++)
  for(int k=0;k<=NH;k++)
   w2[k][j] = w2_bak[k][j];
}

double punkte_berechnen()
{
 double summe_punkte=0;
 int x,y,soll;
 for(int j=0;j<lernliste_jmax;j++)
  {
   lernliste[j].getxysoll(&x,&y,&soll,&bild.nx,&bild.ny);
   eingabe_an_neuronen(bild,y,x);
   propagieren();
   //Bewertung von Resultat:
   double punkte=0;
   int imax=0; double Ymax=Y[0];
   for(int i=0;i<NOUT;i++)
    if(gelernt[i])
     {
      if(Y[i]>Ymax) {Ymax=Y[i]; imax=i;}
      if(i==soll) {punkte += Y[i];}
      else punkte += (1.0-Y[i]);
     }
   if(imax==soll) punkte += 1000;
   summe_punkte += punkte;
  }
 return summe_punkte;
}

void erstes_anlernen()
{
 printf("erstes_anlernen()\n");//test
 int x,y,soll;
 static int testflag=26*2+10;//TODO
 m_wertesetzen();
 for(int i=0;i<NY;i++) gelernt[i]=0;
 for(int jlern=0;jlern<lernliste_jmax;jlern++)
  {int nx,ny;
   lernliste[jlern].getxysoll(&x,&y,&soll,&nx,&ny);
   gelernt[soll]=1;
  }
 gelernt[ZEOUT]=1;
 for(int jlern=0;jlern<lernliste_jmax;jlern++)
  {
   lernliste[jlern].getxysoll(&x,&y,&soll,&bild.nx,&bild.ny);
   eingabe_an_neuronen(bild,y,x);
   propagieren();
   int j=soll;
   if(testflag) printf("Ausgabe an Sollposition: Y[%d] = %f\n",j,Y[j]);//test
   for(int k=0;k<NH-1;k++) // H[NH-1] ist Zeichenerkennung, hier unberuecksichtigt
    {
     w2[k][j] = (H[k]>=0.5) ? 1.0 : -1.0;
    }
   if(testflag)
    {propagieren();//test
     printf("       nach Lernschritt: Y[%d] = %f\n",j,Y[j]);//test
     testflag--;
    }
  }
 double summe_punkte=punkte_berechnen();
 printf("nach erstem Anlernen: summe_punkte = %f\n",summe_punkte);
}

void trainieren(int ivarmax,int methode)
{
 int anz_verbesserungen=0;
 double best_punkte=punkte_berechnen();
 neuronen_speichern();
 printf("trainieren()\n best_punkte=%f\n",best_punkte);//test
 int test=10,test2=10;//test
 if(ivarmax==0) ivarmax=200000;
 for(int ivar=0;ivar<ivarmax;ivar++)
  {
   if(methode==METHODE_ZUFALL)
    {
#ifndef W1FIXIERT
     zufallsvarieren_w1();
#endif
     zufallsvarieren_w2();
    }
   else //if(methode==METHODE_BACKPROP)
    {
     static double summe_vjmalw2kj[NH+1][NY-1];//fuer w1-backprop
     for(int jlern=0;jlern<lernliste_jmax;jlern++)
      {
       int x,y,soll;
       lernliste[jlern].getxysoll(&x,&y,&soll,&bild.nx,&bild.ny);
       eingabe_an_neuronen(bild,y,x);
       propagieren();
       for(int j=0;j<NY-1;j++)
	for(int k=0;k<=NH;k++) summe_vjmalw2kj[k][j]=0;
       for(int j=0;j<NY-1;j++)
	if(gelernt[j])
	 {
	  //double Dj = (j==soll) ? 1.0 : 0.0;//Sollwert
	  double Dj = (j==soll) ? 0.9 : 0.1;//Sollwert TODO: Realistischere Solwerte?
	  double Yj=Y[j];
	  double vj=Epsilon*(Dj-Yj)*Yj*(1.0-Yj); // Lernformel von Seite 84
	  for(int k=0;k<=NH;k++)
	   {
	    summe_vjmalw2kj[k][j] += vj*w2[k][j];
	    w2[k][j] += vj*H[k];
	   }
	 }
#ifndef W1FIXIERT
       //jetzt noch w1 backprop:
       for(int j=0;j<NY-1;j++)
	if(gelernt[j])
	 {
	  for(int k=0;k<=NH;k++)
	   {//Formel Seite 85, Epsilon schon in summe_.. enthalten
	    double Hk = H[k];
	    double sigmak = summe_vjmalw2kj[k][j]*Hk*(1.0-Hk);
	    for(int i=0;i<=NX;i++)
	     {
	      w1[i][k] += sigmak*X[i];
	     }
	   }//Ende k-Schlaufe
	 }//Ende j-Schlaufe
#endif
      }//Ende jlern-Schlaufe
    }
   double summe_punkte=punkte_berechnen();
   if(test!=0 && fastgleich(summe_punkte,best_punkte,0.1))
    {
     --test;
     if(summe_punkte != best_punkte) printf("fast");
     printf("gleich: summe=%f best=%f\n",summe_punkte,best_punkte);//test
    }
   if(summe_punkte < best_punkte)
    {
     if(test2)
      {--test2; printf("summe=%f best=%f neuronen_zurueck()\n",summe_punkte,best_punkte);}//test
     neuronen_zurueck();
    }
   else if(summe_punkte > best_punkte)
    {
     printf("ivar=%d summe_punkte = %f\n",ivar,summe_punkte);//test
     best_punkte = summe_punkte;
     neuronen_speichern();
     anz_verbesserungen++;
    }
   if(ivar%10000==0)
    {
     printf("ivar=%d anz_verbesserungen=%d\n",ivar,anz_verbesserungen);//test
     if(ivar>=1000 && anz_verbesserungen==0) break;//Abbrechen wenn keine weitere Verbesserung
     anz_verbesserungen=0;
    }
  }//Ende ivar-Schlaufe
 printf("Trainieren fertig\n best_punkte = %f\n",best_punkte);//test
}

static int mausmodus=0;
double maus_x1=0, maus_y1=0, maus_x2=0, maus_y2=0;

void mydrawmode(int mode)
{
 if(mode==COMPLEMENT)
   {//complement_farbe(PURPUR);
    rgbcolor(255, 0, 255);//Purpur
    drawmode(mode);
   }
 else
   {drawmode(mode);//wieder normaler Zeichnungsmodus
    //complement_farbe(0);
    rgbcolor(128,128,128);//Grau
   }
}

void m_position()
{
 int ok,sx=shiftx,sy=shifty;
 ok=requester_input(2,"Position X","%d","%d",&sx,
		      "Position Y","%d","%d",&sy);
 if(ok)
  {if(sx>=0 && sy>=0) {shiftx=sx; shifty=sy;}
   else printf("Eingabefehler: X und Y muessen groesser 0 sein\n");
  }
 m_refresh();
}

#define WEISS_OBEN  0x01
#define WEISS_UNTEN 0x02
#define WEISS_LINKS 0x04
#define WEISS_RECHTS 0x08
#define WEISS_GESAMTER_RAND 0x0F

int rand_weisstest(Bild& bild)
{
 static int schwelle=0;
 int x0=shiftx, y0=shifty, nx=bild.nx, ny=bild.ny;
 if(schwelle==0 || (nx<24 && ny<24)) //TODO
  {
   if(nx<16) {x0 -= (16-nx)/2; nx=16;}
   if(ny<16) {y0 -= (16-ny)/2; ny=16;}
   schwelle = bild.ausschnitt_schwellgrau(x0,y0,nx,ny);
  }
 int jmax=bild.ny, imax=bild.nx;
 int flags=WEISS_GESAMTER_RAND;
 for(int j=0;j<jmax;j++)
  {if(bild.getgrau(shifty+j, shiftx) < schwelle) flags &= ~(WEISS_LINKS);
   if(bild.getgrau(shifty+j, shiftx+imax-1) < schwelle) flags &= ~(WEISS_RECHTS);
  }
 for(int i=0;i<imax;i++)
  {if(bild.getgrau(shifty, shiftx+i) < schwelle) flags &= ~(WEISS_OBEN);
   if(bild.getgrau(shifty+jmax-1, shiftx+i) < schwelle) flags &= ~(WEISS_UNTEN);
  }
 return flags;
}

static double g_ypos=g_ymax;

void teilbild_rechts_zeichnen(Bild& bi,int nx,int ny,int x0,int y0,double ypos0=0)
{
 if(ypos0!=0) g_ypos=ypos0;
 double ho=(g_ymax-g_ymin)/4, br=ho; //Werte zum Teilbild zeichnen
 teilbild_zeichnen(g_xmax-br, g_ypos-ho, g_xmax, g_ypos, bi, nx, ny, x0, y0);
 rgbcolor(0,255,0); drawbox(g_xmax-br, g_ypos-ho, g_xmax, g_ypos);//gruene Umrandung
 g_ypos -= ho; if(g_ypos<=g_ymin) g_ypos=g_ymax;
}

void  neuronen_rechts_zeichnen(double *z,int imax,int jmax)
{
 double ho=(g_ymax-g_ymin)/4, br=ho; //Werte zum Teilbild zeichnen
 double xmi=g_xmax-br, ymi=g_ypos-ho, xma=g_xmax, yma=g_ypos;
 double dx=(xma-xmi)/imax, dy=(yma-ymi)/jmax;
 inital_new();
 for(int j=0;j<jmax;j++)
  {double y2=yma-j*dy, y1=y2-dy;
   for(int i=0;i<imax;i++)
    {double x1=i*dx+xmi, x2=x1+dx;
     int grau=(1.0-z[j*imax+i])*255;
     if(grau==255) rgbcolor(180,200,255); else rgbcolor(grau,grau,grau);
     fillbox(x1,y1,x2,y2);
    }
  }
 rgbcolor(0,0,255); drawbox(xmi,ymi,xma,yma);//dunkelblaue Umrandung
 term_refresh();
 g_ypos -= ho; if(g_ypos<=g_ymin) g_ypos=g_ymax;
}

void zeichen_erkennung_von_mitte(int zeichnenflag) //Rueckgabewerte: shiftx, shifty, bild.nx, bild.ny
{
 int flags, randflags=0;
 //printf("Testpunkt1: shiftx=%d shifty=%d bild.nx=%d bild.ny=%d\n",shiftx,shifty,bild.nx,bild.ny);//test
 while((flags=(rand_weisstest(bild)|randflags)) != WEISS_GESAMTER_RAND)
  {
   if((flags&WEISS_LINKS)==0)
    {
     if(shiftx>0) {--shiftx; bild.nx++;} else randflags |= WEISS_LINKS;
    }
   if((flags&WEISS_OBEN)==0)
    {
     if(shifty>0) {--shifty; bild.ny++;} else randflags |= WEISS_OBEN;
    }
   if((flags&WEISS_RECHTS)==0)
    {
     if(bild.breite-shiftx > bild.nx) bild.nx++; else randflags |= WEISS_RECHTS;
    }
   if((flags&WEISS_UNTEN)==0)
    {
     if(bild.hoehe-shifty > bild.ny) bild.ny++; else randflags |= WEISS_UNTEN;
    }
   if(bild.nx>64)
    {int flags=rand_weisstest(bild)|randflags;
     if((flags & (WEISS_OBEN|WEISS_UNTEN))!=(WEISS_OBEN|WEISS_UNTEN)) bild.ny=bild.nx;
     break;
    }
   if(bild.ny>64)
    {int flags=rand_weisstest(bild)|randflags;
     if((flags & (WEISS_LINKS|WEISS_RECHTS))!=(WEISS_LINKS|WEISS_RECHTS)) bild.nx=bild.ny;
     break;
    }
  }
 if(bild.nx>bild.ny) //wenn breiter als hoch
  {shifty -= (bild.nx-bild.ny); if(shifty<0) shifty=0;
   bild.ny=bild.nx; if(bild.ny+shifty > bild.hoehe) bild.ny=bild.hoehe-shifty;
  }
 else if(bild.ny>bild.nx+2 && shiftx>1 && shiftx+bild.nx<bild.breite-1)
  {//wenn hoeher als breit und links und rechts genug platz:
   shiftx--; bild.nx+=2; //um 2 Pixel breiter machen
   if(rand_weisstest(bild) != WEISS_GESAMTER_RAND) //wenn zugefuegter Rand nicht weiss
    {shiftx++; bild.nx-=2;} //dann zuruecknehmen
  }
 Bild bi,teilbild;
 //printf("Testpunkt2: shiftx=%d shifty=%d bild.nx=%d bild.ny=%d\n",shiftx,shifty,bild.nx,bild.ny);//test
 teilbild_kopieren(shiftx, shifty, bild.nx, bild.ny, bild, bi);
 if(zeichnenflag) teilbild_rechts_zeichnen(bi, bi.nx, bi.ny, 0, 0, g_ymax);
 umrechnung_nxm_nach_32x32_randweiss(bi,teilbild);
 if(zeichnenflag) teilbild_rechts_zeichnen(teilbild, teilbild.nx, teilbild.ny, 0, 0);
 eingabe_an_neuronen(teilbild,0,0,zeichnenflag);//TODO
}

void m_lernpos()
{
 static char name[200];
 static int startflag=1;
 char zeichen[80]; zeichen[0]=0;
 bool klicklern = (bild.nx<32 && bild.ny<32); //mit einzelnem Klick lernen
 if(klicklern) zeichen_erkennung_von_mitte();
 int ok;
 if(startflag) {strcpy(name,"lerndaten_neu.txt"); startflag=0;}
 do {
  if(klicklern)
   {int nx=bild.nx, ny=bild.ny, x0=shiftx, y0=shifty;
    for(;;)
     {ok=requester_input(6,"Dateiname (Textdatei)","%s","%s",name,
			 "Zeichen","%s","%s",zeichen,
			 "bild.nx","%d","%d",&nx,
			 "bild.ny","%d","%d",&ny,
			 "shiftx","%d","%d",&x0,
			 "shifty","%d","%d",&y0);//TODO
      if(!ok) break;
      if(nx!=bild.nx || ny!=bild.ny || x0!=shiftx || y0!=shifty)
       {bild.nx=nx; bild.ny=ny; shiftx=x0; shifty=y0;
	teilbild_rechts_zeichnen(bild, nx, ny, x0, y0, g_ymax);
	int zflag=2; eingabe_an_neuronen(bild,y0,x0,zflag);//TODO
       }
      else break;
     }
   }
  else
   {char antw[80]; strcpy(antw,"nein");
    ok=requester_input(3,"Dateiname (Textdatei)","%s","%s",name,
		       "Zeichen","%s","%s",zeichen,
		       "Rahmen groesser","%s","%s",antw);
    if(ok && antw[0]!='n' && antw[0]!='N')
     {if(shiftx>0) {shiftx--; bild.nx++;}
      if(shifty>0) {shifty--; bild.ny++;}
      if(shiftx+bild.nx<bild.breite) bild.nx++;
      if(shifty+bild.ny<bild.hoehe) bild.ny++;
      zeichen[0]=0; klicklern=true;
     }
   }
 } while(ok && zeichen[0]==0);
 if(ok)
  {
   FILE *fp=fopen(name,"a");
   if(fp==NULL) {printf("konnte \"%s\" nicht oeffnen\n",name); return;}
    fprintf(fp,"%d %d '%c' %d %d\n",shiftx,shifty,zeichen[0],bild.nx,bild.ny);
    fclose(fp);
   }
}

void test_grauwert_pixel(double x,double y)
{
 printf("Pixel an Position %f %f:\n",x,y);//test
 int i = shiftx+int((x-g_xmin)*bild.nx);
 int j = shifty+int((g_ymax-y)*bild.ny);
 printf(" i=%d j=%d\n",i,j);//test
 int grau=bild.getgrau(j,i);
 int r=bild.get(j,i*3), g=bild.get(j,i*3+1), b=bild.get(j,i*3+2);
 printf(" Farbe: R=%d G=%d B=%d, grau=%d\n",r,g,b,grau);
}

void maus_gedrueckt()
{
 double x,y; //dy,rand;
 int taste=mausposition(&x,&y);
 test_grauwert_pixel(x,y);
 if(taste==LIMAUS)
  {
   mausmodus=1; maus_x1=x; maus_y1=y;
   mydrawmode(COMPLEMENT);
  }
 else if(taste==REMAUS)
  {
   mausmodus=2; maus_x1=x; maus_y1=y;
  }
 else if(taste==SCROLL_UP)
  {
   if(shifty>=32) shifty -= 32; else shifty=0;
   m_refresh();
  }
 else if(taste==SCROLL_DOWN || taste==6144) //TODO
  {
   if(shifty+32<bild.hoehe-bild.ny) shifty += 32; else shifty=bild.hoehe-bild.ny;
   m_refresh();
  }
 else
  {
   printf("maus_gedrueckt() taste=%d x=%lf y=%lf\n",taste,x,y);//test
  }
}

void maus_bewegung()
{
 double x,y;
 //int taste=
 mausposition(&x,&y);
 //printf("maus_bewegung() tasten=%d x=%f y=%f\n",taste,x,y); //test
 if(mausmodus==1 && x!=maus_x1 && y!=maus_y1)
  {
   /*
   printf("maus_bewegung() taste=%d\n",taste);//test
   if(taste==LIMAUS) printf("LIMAUS\n");//test
   if(taste==REMAUS) printf("REMAUS\n");//test
   if(taste==MIMAUS) printf("MIMAUS\n");//test
   */
   if(maus_x2!=0 && maus_y2!=0)
    {
     drawbox(maus_x1,maus_y1,maus_x2,maus_y2); //altes Fadenkreuz loeschen
    }
   maus_x2=x; maus_y2=y;
   drawbox(maus_x1,maus_y1,maus_x2,maus_y2); //neues Fadenkreuz zeichnen
  }
 else if(mausmodus==2 && x!=maus_x1 && y!=maus_y1)
  {
   maus_x2=x; maus_y2=y;
   int dx=idfix((maus_x1-maus_x2)*bild.nx); 
   int dy=idfix((maus_y2-maus_y1)*bild.ny);
   if(dx!=0 || dy!=0)
    {
     shiftx += dx; if(shiftx<0) shiftx=0;
     shifty += dy; if(shifty<0) shifty=0;
     maus_x1=maus_x2; maus_y1=maus_y2;
     m_refresh();
    }
  }
}

void maus_losgelassen()
{
 double x,y;
 mausposition(&x,&y);
 if(mausmodus==1)
  {
   if(maus_x2!=0 && maus_y2!=0)
    {
     drawbox(maus_x1,maus_y1,maus_x2,maus_y2); //altes Fadenkreuz loeschen
    }
   maus_x2=x; maus_y2=y;
   printf("x1=%f y1=%f x2=%f y2=%f\n",maus_x1,maus_y1,maus_x2,maus_y2);//test
   int dy = idfix((1.0-maus_y1)*bild.ny);
   int dx = idfix((maus_x1)*bild.nx);
   if(fastgleich(maus_x1,maus_x2) && fastgleich(maus_y1,maus_y2))
    {
     mausmodus=0; mydrawmode(JAM1);//wieder normaler Zeichnungsmodus
     int shiftx_alt=shiftx, shifty_alt=shifty;
     int nx_alt=bild.nx, ny_alt=bild.ny;
     shifty += dy-4; if(shifty<0) shifty=0;
     shiftx += dx-4; if(shiftx<0) shiftx=0;
     bild.nx=bild.ny=8;
     m_lernpos();
     shiftx=shiftx_alt; shifty=shifty_alt;
     bild.nx=nx_alt; bild.ny=ny_alt;
    }
   else
    {
     //Position auf maux_x1,maus_y1 setzen und Skalierung anpassen:
     //werte in inital(): double xmin= -0.125,ymin=0.,xmax=1.125,ymax=1.;
     if(maus_x1>maus_x2) {double h=maus_x1; maus_x1=maus_x2; maus_x2=h;}
     if(maus_y1<maus_y2) {double h=maus_y1; maus_y1=maus_y2; maus_y2=h;}
     shifty += dy; shiftx += dx; //Position anpassen
     //jetzt noch Skalierung:
     double sy = maus_y2-maus_y1; if(sy<0) sy = -sy;
     double sx = maus_x2-maus_x1; if(sx<0) sx = -sx;
     if(sx==0) sx=sy;
     if(sy!=0)
      {double h=sx/sy; //wenn beide Faktoren fast gleich
       if(h<1.5 && h>0.75) sx=sy=(sx+sy)/2; //dann beide auf gleichen Wert setzen (Mittelwert)
       bild.nx *= sx; if(bild.nx<16) bild.nx=16;
       bild.ny *= sy; if(bild.ny<16) bild.ny=16;
      }
     mydrawmode(JAM1);//wieder normaler Zeichnungsmodus
    }
   mausmodus=0; maus_x1=maus_y1=0; maus_x2=maus_y2=0;
   m_refresh();
  }
 else if(mausmodus==2)
  {
   maus_x2=x; maus_y2=y;
   int dx=idfix((maus_x1-maus_x2)*bild.nx); 
   int dy=idfix((maus_y2-maus_y1)*bild.ny); 
   shiftx += dx; if(shiftx<0) shiftx=0;
   shifty += dy; if(shifty<0) shifty=0;
   mausmodus=0; maus_x1=maus_y1=0; maus_x2=maus_y2=0;
   m_refresh();
  }
 else
  {
   printf("maus_losgelassen() x=%f y=%f\n",x,y); //test
  }
}

void vergroessern_mit_interpolation(Bild &bi)
{
 if(bi.breite<2 || bi.hoehe<2) {fprintf(stderr,"Error: vergroessern_mit_interpolation()\n"); exit(1);}
 int Nalt=bi.breite, Malt=bi.hoehe;
 int N=2*Nalt-1, M=2*Malt-1;
 Bild bineu(N,M);
 for(int x=0;x<Nalt;x++)
  for(int y=0;y<Malt;y++)
   {int grau=bi.getgrau(y,x);
    bineu.setgrau(y*2,x*2,grau);
   }
 for(int x=1;x<N-1;x+=2)
  for(int y=0;y<M;y+=2)
   {
    int grau = (bineu.getgrau(y,x-1) + bineu.getgrau(y,x+1))/2;
    bineu.setgrau(y,x,grau); //neue x-Werte interpolieren
   }
 for(int x=0;x<N;x++)
  for(int y=1;y<M;y+=2)
   {
    int grau = (bineu.getgrau(y-1,x) + bineu.getgrau(y+1,x))/2;
    bineu.setgrau(y,x,grau); //neue y-Werte interpolieren
   }
 delete[] bi.data;
 bi.data = bineu.data; bineu.data=NULL;
 bi.nx = bi.breite = bineu.breite;
 bi.ny = bi.hoehe = bineu.hoehe;
}

void umrechnung_nxm_nach_32x32(Bild &quelle,Bild &ziel)
{
 while(quelle.breite<32 || quelle.hoehe<32) vergroessern_mit_interpolation(quelle);
 int N=quelle.breite, M=quelle.hoehe;
 ziel.init(32,32);
 for(int x=0; x<ziel.breite; x++)
  for(int y=0; y<ziel.hoehe; y++)
   {
    int i1=N*x/32,     j1=M*y/32;
    int i2=N*(x+1)/32, j2=M*(y+1)/32;
    int summe=0, n=0;
    for(int i=i1;i<i2;i++)
     for(int j=j1;j<j2;j++)
      {
       summe += quelle.getgrau(j,i);
       n++;
      }
    int grau = summe/n;
    ziel.setgrau(y,x,grau);
   }
}

void umrechnung_nxm_nach_32x32_randweiss(Bild &quelle,Bild &ziel)
{
 if(quelle.breite==quelle.hoehe) {umrechnung_nxm_nach_32x32(quelle,ziel); return;}
 while(quelle.breite<32 && quelle.hoehe<32) vergroessern_mit_interpolation(quelle);
 int N=quelle.breite, M=quelle.hoehe;
 //printf("umrechnung_nxm_nach_32x32_randweiss() N=%d M=%d\n",N,M);//test
 Bild bi;
 if(N<M)
  {bi.init(M,M);
   int xrand=(M-N)/2, xrand2=xrand+N;
   //printf("xrand=%d xrand2=%d\n",xrand,xrand2);//test
   for(int y=0; y<M; y++)
    for(int x=0; x<M; x++)
     {
      if(x<xrand || x>=xrand2) bi.setgrau(y,x,255);//Rand auf weiss setzen
      else
       {
	int grau = quelle.getgrau(y,x-xrand);
	bi.setgrau(y,x,grau);
       }
     }
  }
 else //if(M<N)
  {bi.init(N,N);
   int yrand=(N-M)/2, yrand2=yrand+M;
   for(int y=0; y<M; y++)
    for(int x=0; x<M; x++)
     {
      if(y<yrand || y>=yrand2) bi.setgrau(y,x,255);//Rand auf weiss setzen
      else
       {
	int grau = quelle.getgrau(y-yrand,x);
	bi.setgrau(y,x,grau);
       }
     }
  }
 umrechnung_nxm_nach_32x32(bi,ziel);
}
