/* halesen.cc			letzte Aenderung: 6.3.2025 */
#define VERSION "Version 0.5"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Versuch von Handschrift lesen aus ppm- oder png-Datei von Scanner

History:
31.1.2025       Erstellung (RP)
9.2.2025   0.2  Felder w1 und w2 statt Klasse Neuron
21.2.2025  0.3  Zeichengroesse statt 32*32 neu NHO*NBR, Input und Hidden gleiche Groesse
24.2.2025  0.4  Optimiert fuer W1FIXIERT, m_wortscannen und m_abschnittscannen() erneuert
28.2.2025  0.5  in class Bild nur Grauwerte speichern, globale Schwellen fuer schwarz und weiss

*/
#define W1FIXIERT   //w1 beim trainieren unveraendert lassen (Eingabe direkt auf Zwischenneuronen)
//#define EINGABE_GRAUWERTE //Werte der Eingabeneuronen zwischen 0.0 und 1.0
#define EINGABE_TRIPEL //Werte bei hellen Pixeln auf -1, bei dunklen +1, sonst 0.0
//#define EINGABE_SCHWARZWEISS //Werte auf 0.0 (helle) oder 1.0 (dunkle Pixel) setzen
#define SCHWELLE_SCHWARZ 130
#define SCHWELLE_WEISS   240

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include <xtekplot1.h>

#define uchar uint8_t

//#define XMAX 1024
//#define YMAX  820
#define XMAX 1280
#define YMAX 1024
#define TIEFE 24

#define SCHWARZAUFWEISS //auskommentieren fuer weiss auf schwarz

/************************* Vordeklarationen ***************************/
void datei_laden(const char *name);
void bild_einlesen(const char *name);
void pixelfeld_zeichnen();
void erstes_anlernen();
void trainieren(int ivarmax,int methode);
void von_lernliste_einlesen(int soll);
int nnw_einlesen(const char *name);
void neuronen_rechts_zeichnen(double *z,int imax,int jmax);
void propagieren();
void zeichen_erkennung_von_mitte(int x0,int y0,int zeichnenflag=2);
int lerndatei_einlesen();

void menu_load(), menu_save();
void m_rechts(), m_unten(), m_links(), m_oben(), m_position(), m_lernpos();
void m_zoom24x32(),m_zoomin(), m_zoomout(), m_zoomtotale(), m_zoomfaktor(), m_refresh();
void maus_gedrueckt(), maus_bewegung(), maus_losgelassen();
void m_scannen(), m_scannen2(), m_wortscannen(), m_abschnittscannen(), m_lernen(), m_wertesetzen();

/************************* Globale Variablen **************************/
#define NHO 32 //Buchstabenhoehe in Pixel
#define NBR 24 //Buchstabenbreite in Pixel

//double g_xmin= -0.125,g_ymin=0.0,g_xmax=1.125,g_ymax=1.0;
double g_xmin= 0.0, g_ymin=0.0, g_xmax=1.25, g_ymax=1.0;
static int shiftx=0,shifty=0;
typedef char Dateinamen[200];
static Dateinamen lerndatei[20];//TODO
static double Epsilon=0.3;

//Schwellen int bild.schwelle3() zu setzen:
static int schwelle_schwarz=0, schwelle_weiss=0;
static int schwelldiff=20;//Unterschied von schwelle_weiss zu schwelle_schwarz 

static int lernmodus=0; //0=aus, 1=ein
static int g_modus=1; //0=Handschrift, 1=Drucktext, ... //TODO
#define DRUCKTEXT 1

//Buchstaben-Eigenschaften bei Drucktext:
static int bu_hoehe=29, bu_minbreite=4, bu_maxbreite=32;
static int bu_unterlaenge=7, bu_oberlaenge=0, bu_maxabstand=4;
static int htestflag=0;//wenn gesetzt testpunkte in erstes_anlernen() und propagieren()
static int g_schwelle_schwarz=SCHWELLE_SCHWARZ, g_schwelle_weiss=SCHWELLE_WEISS;//schwellen in eingabe_an_neuronen()
static double g_ks=0.02; //TODO
static int zusaflag=1;//TODO

/***************************** Kleinkram ******************************/
const int N80=200;//maximal vorkommende Laenge eines Dateinamens
const int MAXL=1000;

inline int idfix(double x) {return int((x>=0.0) ? x+0.5 : x-0.5);} //Runden

bool isletter(int c)
{
 return ((c>='A' && c<='Z') || (c>='a' && c<='z')); 
}

bool fastgleich(double x1,double x2,double d=0.001)
{
 double d2=x2-x1; if(d2<0) d2 = -d2;
 return (d2<d);
}

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}


// Umgang mit Dateien:
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

bool vorhanden(const char *dateiname)
{
 struct stat buf;
 return (lstat(dateiname,&buf)>=0);
}

bool istordner(char *dateiname)
{
 struct stat buf;
 if(lstat(dateiname,&buf)<0) return false;
 //if(buf.st_mode & S_IFDIR) return true;
 if((buf.st_mode & S_IFMT)==S_IFDIR) return true;
 return false;
}
bool istregulaer(char *dateiname) //Regulaere Datei ohne Softlink ohne Ordner
{
 struct stat buf; //siehe man lstat
 //(Fehler in man lstat: S_IFMT ist nicht 0017000 sondern 0170000)
 if(lstat(dateiname,&buf)<0) return false;
 if((buf.st_mode & S_IFMT)==S_IFREG) return true;
 return false;
}
bool istsoftlink(char *dateiname)
{
 struct stat buf;
 if(lstat(dateiname,&buf)<0) return false;
 if((buf.st_mode & S_IFMT)==S_IFLNK) return true;
 return false;
}

bool istbilddatei(const char *name) //Bilddatei anhand der Endung
{
 int n=strlen(name);
 if(n<5) return false;
 if(name[n-4]=='.')
   return (strcmp(&name[n-3],"jpg")==0 || strcmp(&name[n-3],"JPG")==0 ||
	   strcmp(&name[n-3],"gif")==0 || strcmp(&name[n-3],"GIF")==0 ||
	 //strcmp(&name[n-3],"ppm")==0 || strcmp(&name[n-3],"PPM")==0 ||
	   strcmp(&name[n-3],"png")==0 || strcmp(&name[n-3],"PNG")==0);
 else if(n>5 && name[n-5]=='.')
   return (strcmp(&name[n-4],"jpeg")==0 || strcmp(&name[n-4],"JPEG")==0);
 return false;
}

int anzahlblanks(const char *s) //zaehle Anzahl Leerstellen im String
{                               //und Klammern auch
 int c,n=0;
 while((c= *s++)!=0)
    if(c==' ' || c=='(' || c==')') n++;
 return n;
}

char *escapeblanks(const char *s,int nb)
{
 char *name2=new char[strlen(s)+nb+1];
 char *p=name2;
 int c;
 while((c= *s++)!=0)
   {if(--nb>=0 && (c==' ' || c=='(' || c==')'))
       *p++ = '\\'; //vor jede Leerstelle oder Klammer ein \ setzen
    *p++ = c;
   }
 *p=0;
 return name2;
}

char *entferneblanks(const char *s)
{
 char *name2=new char[strlen(s)+1];
 char *p=name2;
 int c;
 while((c= *s++)!=0)
   {if(c==' ' || c=='(' || c==')')
       c = '_'; //Leerstelle oder Klammer durch _ ersetzen
    *p++ = c;
   }
 *p=0;
 return name2;
}

class Aktuellerpfad
{
 char *pfad;
 char *liste[MAXL];//fuer Speicherrueckgabe
 int imax;
public:
 Aktuellerpfad() {pfad=NULL; imax=0;}
 ~Aktuellerpfad() {if(pfad!=NULL) delete[] pfad; loeschen();}
 void set(const char *arg0)
	{char *s; int n=strlen(arg0);
	 if(pfad!=NULL) delete[] pfad;
	 pfad=new char[n+1];
	 strcpy(pfad,arg0);
	 for(s= &pfad[n];*--s!='/';) ;
	 *s=0;
	 setenv("PWD",pfad,1);
	}
 void cd(const char* ordner);
 FILE *fopen2(const char *name,const char *rw);
 const char *vollpfad(const char *name);
 char *getpfad() {if(pfad) return pfad; else return getenv("PWD");}
 void loeschen() {while(imax>0) delete[] liste[--imax];}
};
void Aktuellerpfad::cd(const char* ordner)
{
 const char *s,*altpfad=pfad;
 if(ordner[0]=='/') s="";
 else if(altpfad==NULL) s=getenv("PWD");
 else s=altpfad;
 int n=strlen(s)+strlen(ordner)+2;
 pfad=new char[n];
 if(*s==0) strcpy(pfad,ordner);
 else sprintf(pfad,"%s/%s",s,ordner);
 while(!istordner(pfad) && (n=strlen(pfad))>1)
   {while(--n>1 && pfad[n]!='/') {}
    pfad[n]=0;
   }
 if(altpfad) delete[] altpfad;
}

FILE *Aktuellerpfad::fopen2(const char *name,const char *rw)
{
 FILE *fp;
 if(pfad!=NULL && *name!='/')
  {char str[strlen(pfad)+strlen(name)+2];
   sprintf(str,"%s/%s",pfad,name);
   fp=fopen(str,rw);
  }
 else fp=fopen(name,rw);
 return fp;
}

static int test=0;

const char *Aktuellerpfad::vollpfad(const char *name)
{
 if(name==NULL || *name=='/' || pfad==NULL) return name;
 char *name2=NULL;
 int nb;
 if((nb=anzahlblanks(name))>0) //falls in name Leerstellen sind
   name=name2=escapeblanks(name,nb);
 char vollname[strlen(pfad)+strlen(name)+2];
 sprintf(vollname,"%s/%s",pfad,name);
 int i;
 for(i=0;i<imax;i++)
   if(strcmp(vollname,liste[i])==0) {return liste[i];}
 char *str=new char[strlen(vollname)+1];
 strcpy(str,vollname);
 if(imax<MAXL)
   {liste[imax++]=str;
    if(imax==MAXL && test>0)
      printf("Aktuellerpfad::vollpfad() liste fuer Speichrrueckgabe voll.\n");
   }
 if(name2!=NULL) delete[] name2;
 return str;
}

static Aktuellerpfad pwd;
inline FILE *fopen2(const char *na,const char *rw) {return pwd.fopen2(na,rw);}
inline const char *vollpfad(const char *s) {return pwd.vollpfad(s);}
inline bool vorhanden2(const char *name) {return vorhanden(vollpfad(name));}

#include <errno.h>
void fehlermeldung(int err)
{
 if(err== -1) err=errno;
#ifdef EEXIST
 if(err==EEXIST) printf("EEXIST - Datei schon vorhanden.\n");
 else if(err==EROFS) printf("EROFS - nur lesbar\n");
 else if(err==ENOMEM) printf("ENOMEM - nicht genug Kernelspeicher\n");
 else if(err==EACCES) printf("EACCES - kein Schreibrecht\n");
 else
#endif
    printf("Fehlercode %d: siehe \"more /usr/include/asm*/errno*.h\"\n",err);
}

void system1(const char *s,int k)
{
 if(test>=2) printf("system%d> %s\n",k,s);
 int n=system(s);
 if(n!=0)
   {if(n==127) printf("Fehler %d in system(): fehlendes /bin/sh\n",n);
    else if(n<0) {printf("Fehler %d in system(%s)\n",n,s); fehlermeldung(n);}
    else if(test>=2) printf("Rueckgabewert von system() = %d\n",n);
   }
}

void system2(const char *s,const char *p1,const char *p2=NULL)
{
 char str[3*N80];
 sprintf(str,s,vollpfad(p1),vollpfad(p2));
 system1(str,2);
}

char *ohneletztenpunkt(char *name)  /* die Endung .xxx loeschen */
{
 char c=0,*s; int i;
 for(i=0,s=name;*s!=0;s++,i++) ;
 while(i>0 && (c= *s)!='.')
        {--i; --s;}
 if(c=='.') *s='\0';
 return name;
}

char *anhaengen(char *s,const char *t)  /* s + t --> s */
{
 char *p;
 for(p=s;*p!=0;p++) ;
 for(;*p++ = *t++;) ;
 return s;
}

char *endungersetzen(char *neu,const char *name,const char *endung)
{
 strcpy(neu,name); ohneletztenpunkt(neu);
 return anhaengen(neu,endung);
}

bool istppm(const char *name)
{
 int i=0;
 while(name[i]!=0 && name[i]!='.') {i++;}
 return (strcmp(&name[i],"ppm")==0);
}

bool hatendung(const char *name,const char *endung)
{
 int i=0;
 while(name[i]!=0 && name[i]!='.') {i++;}
 return (strcmp(&name[i],endung)==0);
}

const char *getendung(const char *name)
{
 int i=0;
 while(name[i]!=0 && name[i]!='.') {i++;}
 return &name[i];
}

double zufall4()	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* bisher bester Zufallsgenerator   */
 static double x=581;
 double y;
 if(x==0.) x=581;
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}

double zufall() //Zufallszahl zwischen -1.0 und +1.0
{
 return zufall4()*2-1;
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(const char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/****************************** Klassen *******************************/
class Bild
{
public:
 int breite,hoehe,nx,ny;
 uchar *data; //[ny][nx] fuer Grauwerte 1 Byte pro Bildpunkt
 int mingrau,maxgrau;
 uint mittelgrau;
 Bild() {breite=hoehe=0; nx=NBR; ny=NHO; data=NULL; mingrau=0; maxgrau=255; mittelgrau=127;}
 Bild(int N,int M) {breite=nx=N; hoehe=ny=M; data=new uchar[N*M]; mingrau=0; maxgrau=255;}
 ~Bild() {if(data!=NULL) {delete[] data; data=NULL;}}
 void init(int N,int M) {breite=nx=N; hoehe=ny=M; data=new uchar[N*M]; mingrau=0; maxgrau=255;}
 void setpixel(int j,int i,int wert)
  {if(data==NULL)
    {if(breite==0 || hoehe==0) {printf("Fehler in bild.setpixel()\n");}
     data = new uchar[breite*hoehe];
    }
   data[j*breite+i]=wert;
  }
 int getgrau(int j,int i) //j=Zeile, i = Spalte
  {if(data==NULL) {printf("Fehler2\n"); return 0;}
   int grau = data[j*breite+i];
   return grau;
  }
 void setgrau(int j,int i,int grau) //j=Zeile, i = Spalte, grau: 0...255
  {if(data==NULL) {printf("Fehler3\n"); return;}
   data[j*breite+i] = grau;
  }
 void minmaxpixel()
  {mingrau=255; maxgrau=0; mittelgrau=0;
   for(int i=0;i<breite;i++)
    for(int j=0;j<hoehe;j++)
     {int grau = data[j*breite+i];
      if(grau<mingrau) mingrau=grau;
      if(grau>maxgrau) maxgrau=grau;
      mittelgrau += grau;
     }
   mittelgrau /= breite*hoehe;
  }
 void ausschnitt_schwelle3(int x0,int y0,int br,int ho)
  {int min=255,max=0,grau;
   if(x0<0) x0=0;
   if(y0<0) y0=0;
   for(int i=x0;i<x0+br && i<breite;i++)
    for(int j=y0;j<y0+ho && j<hoehe;j++)
     {grau = getgrau(j,i);
      if(grau!=255) //ganz weisse Pixel ausgenommen
       {if(grau>max) max=grau;
	if(grau<min) min=grau;
       }
     }
   if(max==min) max=min+2;
   int mitte = (min+max)/2;
   //schwelle_grau = mitte;//nicht gebraucht
   //schwelle_schwarz = mitte - (max-min)*schwelldiff/255;//test
   schwelle_schwarz = mitte;//TODO
   schwelle_weiss = mitte + (max-min)*schwelldiff/255;
  }
};
static Bild bild;

//Vordeklarationen:
void umrechnung_nxm_nach_24x32(Bild &quelle,Bild &ziel);
void umrechnung_nxm_nach_24x32_randweiss(Bild &quelle,Bild &ziel);
void eingabe_an_neuronen(Bild& bil,int j0,int i0,int zflag=0);

//schon weiter oben definiert:
//#define NHO 32 //Buchstabenhoehe in Pixel
//#define NBR 24 //Buchstabenbreite in Pixel

#define NINP (NHO*NBR)
#define NOUT 128  //Anzahl ASCII-Zeichen
#define NZWI (NHO*NBR)
#define NX NINP //Anzahl Eingabeneuronen
#define NH NZWI //Anzahl Zwischenschichtneuronen
#define NY NOUT //Anzahl Ausgabeneuronen
#define ZEOUT (NY-1) //Zeichenerkennung mit Y[ZEOUT]
#define BIASX NX
#define BIASH NH

#ifdef W1FIXIERT
static double H[NH+1]; //Zwischenschicht(Hidden) + Bias (H[NH] ist Bias, H[NH-1] ist Zeichenerkennung)
#define X H
static double Y[NY]; //Ausabeneuronen, Werte von 0.0 bis 1.0
#else
static double X[NX+1]; //Eingabeneuronen + Bias, Werte von 0.0 bis 1.0
static double H[NH+1]; //Zwischenschicht(Hidden) + Bias (H[NH] ist Bias, H[NH-1] ist Zeichenerkennung)
static double Y[NY]; //Ausabeneuronen, Werte von 0.0 bis 1.0
#endif

static uchar gelernt[NY];
static uchar gelerntakt[NY];

static double w1[NX+1][NH+1]; //w1[i][k]
static double w2[NH+1][NY];   //w2[k][j]

#ifndef W1FIXIERT
static double w1_bak[NX+1][NH+1];
#endif
static double w2_bak[NH+1][NY];

/** Buchstaben in Gruppen einteilen: **/
#define GRUPPE_kleinklein   "acemnorsuvwxz"
#define GRUPPE_unterlaenge  "gpqy"
//#define GRUPPE_INSELN       "bdABDOPQR"
//#define GRUPPE_REST         "fhktCEFGHIJKLMNSTUVWXYZ"
#define GRUPPE_REST         "bdfhktABCDEFGHIJKLMNOPQRSTUVWXYZ"
//#define GRUPPE_klein_schmal "ijl" //schon mit ijerkennung() behandelt
#define GRUPPE_SATZZEICHEN  ";,:.!?"

const char *gruppenerkennung(int buhoehe,int x0,int y0,int startx0,int endx0,int starty0,int endy0,int schwelle)
{
 int x1,y1;
 for(y1=endy0+1,x1=startx0; x1<endx0 && bild.getgrau(y1,x1)>=schwelle; x1++) {}
 if(x1!=endx0) return GRUPPE_unterlaenge;
 int klein_maxhoehe = buhoehe*3/4;//TODO
 for(y1=endy0+klein_maxhoehe,x1=startx0; x1<endx0 && bild.getgrau(y1,x1)>=schwelle; x1++) {}
 if(x1==endx0) return GRUPPE_kleinklein;
 //TODO: GRUPPE_INSELN
 return GRUPPE_REST;
}

void gelernt_kopieren(uchar* quelle,uchar* ziel)
{
 for(int j=0;j<NY;j++) ziel[j]=quelle[j];
}
void gelernt_kopieren(uchar* ziel) {gelernt_kopieren(gelernt,ziel);}

void set_gelerntakt(const char *gruppe)
{
 int c;
 for(int j=0;j<ZEOUT;j++) gelerntakt[j]=0;
 while((c= *gruppe++)!=0)
  {
   if(gelernt[c]) gelerntakt[c]=1;
  }
}

void set_gelerntakt_ohne(const char *gruppe) //alle gelernten ausser gruppe setzen
{
 int c;
 for(int j=0;j<NY;j++) gelerntakt[j]=gelernt[j];
 while((c= *gruppe++)!=0)
  {
   gelerntakt[c]=0;
  }
}
/** :Buchstaben in Gruppen einteilen **/

void drawboxi(int ix1,int iy1,int ix2,int iy2)
{
 inital_new();
 double x1= (ix1-shiftx)*1.0/bild.nx;
 double x2= (ix2-shiftx)*1.0/bild.nx;
 double y1= 1.0 - (iy1-shifty)*1.0/bild.ny;
 double y2= 1.0 - (iy2-shifty)*1.0/bild.ny;
 drawbox(x1,y1,x2,y2);
 term_refresh();
}

void m_anzeigen()
{
 int antw=1;
 printf("w1[]=\n");
 for(int i=0;i<=NX;i++)
  {
   for(int k=0;k<=NH;k++)
    printf("%7.4f ",w1[i][k]);
   printf("\n");
   if(antw!=2) {printf("Weiter? (1=ja, 0=Abbruch, 2=weiter):"); scanf("%d",&antw);}//test
   if(antw==0) break;//test
  }
 printf("w2[]=\n");
 antw=1;
 for(int j=0;j<NY;j++)
  {
   for(int k=0;k<=NH;k++)
    printf("%7.4f ",w2[k][j]);
   printf("\n");
   if(antw!=2) {printf("Weiter? (1=ja, 0=Abbruch, 2=weiter):"); scanf("%d",&antw);}//test
   if(antw==0) break;//test
  }
}

void w1w2ruecksetzen()
{
 //w1- und w2-Werte von Hand berechnet setzen:
 // wenn NX==NH:
 for(int i=0;i<=NX;i++)
  for(int k=0;k<=NH;k++)
    {if(i==k) w1[i][k] = 1.0;
     else     w1[i][k] = 0.0;
    }
 //gesamtes w2-Feld auf 0 setzen:
 for(int j=0;j<NY;j++)
  for(int k=0;k<=NH;k++)
    w2[k][j] = 0;
 //Zeichenerkennung:
 const double wert=1.0/4; //TODO
 for(int iy=0;iy<NHO;iy++)
  {bool randflag1 = (iy<1 || iy>NHO-2);
   bool mittflag1 = (iy>1 && iy<NHO-2);
   for(int ix=0;ix<NBR;ix++)
    {bool randflag = (randflag1 || ix<1 || ix>NBR-2);
     bool mittflag = (mittflag1 && ix>1 && ix<NBR-2);
     int i=iy*NBR+ix;
     if(randflag)      w2[i][ZEOUT] = -1.0;
     else if(mittflag) w2[i][ZEOUT] = wert;
     else              w2[i][ZEOUT] = wert/2;
    }
  }
 w2[BIASH][ZEOUT] = -4;//TODO: Schwellwert fuer Zeichenerkennung
}

void m_wertesetzen()
{
 int ok;
 ok=requester_input(2,"Modus (0=Handschrift, 1=Drucktext)","%d","%d",&g_modus,
		    "Lernmodus (0=aus, 1=ein)","%d","%d",&lernmodus);
 if(ok)
  {if(g_modus==1)
    {
     ok=requester_input(10,"Buchstabenhoehe","%d","%d",&bu_hoehe,
			"Minimale Breite","%d","%d",&bu_minbreite,
			"Maximale Breite","%d","%d\n",&bu_maxbreite,
			"Unterlaenge (gjpqy)","%d","%d",&bu_unterlaenge,
			"Oberlaenge z.B. m^2","%d","%d\n",&bu_oberlaenge,
			"Max. Abstand zwischen Buchstaben in Wort","%d","%d\n",&bu_maxabstand,
			"Schwelle schwarz (0=aus, 1...254 = Grau)","%d","%d",&g_schwelle_schwarz,
			"Schwelle weiss ","%d","%d",&g_schwelle_weiss,
			"schwelldiff (Diff. zu Mittelwert)","%d","%d\n",&schwelldiff,
			"g_ks (0.001 bis etwa 0.05)","%lf","%lf\n",&g_ks);
    }
   else
    {
     ok=requester_input(4,"Schwelle schwarz (0=aus, 1...254 = Grau)","%d","%d",&g_schwelle_schwarz,
			"Schwelle weiss ","%d","%d",&g_schwelle_weiss,
			"schwelldiff (Diff. zu Mittelwert)","%d","%d\n",&schwelldiff,
			"g_ks (0.001 bis etwa 0.05)","%lf","%lf\n",&g_ks);
     //TODO
    }
  }
}

void zufallsvarieren_w1()
{
 static int ntwert=1, zaehler=0;
 if(Epsilon<0.5)
  {
   for(int i=0;i<=NX;i++)
    for(int k=0;k<=NH;k++)
     {
      double z=zufall4(); //Zufallszahl zwischen 0 und 1
      if(z<1.0/ntwert) //nur jeder n. w-Wert varieren
       w1[i][k] = zufall(); //Zufallszahl zwischen -1.0 und +1.0
     }
  }
 else
  {double faktor=Epsilon-0.4; //Faktor zwischen 0.1 und 0.7
   for(int i=0;i<=NX;i++)
    for(int k=0;k<=NH;k++)
     {
      double z=zufall4(); //Zufallszahl zwischen 0 und 1
      if(z<1.0/ntwert) //nur jeder n. w-Wert varieren
       w1[i][k] += zufall()*faktor; //Zufallszahl zwischen +-(0.1 und 0.7)
     }
  }
 if(++zaehler>100)
  {zaehler=0;
   if(++ntwert>50) ntwert=1;
  }
}

void zufallsvarieren_w2()
{
 static int ntwert=1, zaehler=0;
 if(Epsilon<0.5)
  {
   for(int j=0;j<ZEOUT;j++)
    for(int k=0;k<=NH;k++)
     {
      double z=zufall4(); //Zufallszahl zwischen 0 und 1
      if(z<1.0/ntwert) //nur jeder n. w-Wert varieren
       w2[k][j] = zufall(); //Zufallszahl zwischen -1.0 und +1.0
     }
  }
 else
  {double faktor=Epsilon-0.4; //Faktor zwischen 0.1 und 0.7
   for(int j=0;j<ZEOUT;j++)
    for(int k=0;k<=NH;k++)
     {
      double z=zufall4(); //Zufallszahl zwischen 0 und 1
      if(z<1.0/ntwert) //nur jeder n. w-Wert varieren
       w2[k][j] += zufall()*faktor; //Zufallszahl zwischen +-(0.1 und 0.7)
     }
  }
 if(++zaehler>100)
  {zaehler=0;
   if(++ntwert>50) ntwert=1;
  }
}

void zufall_w2()
{
 for(int j=0;j<NY;j++)
  for(int k=0;k<=NH;k++)
    w2[k][j] = zufall(); //oder zufall4() ?
}

void zufall_w1()
{
 for(int i=0;i<=NX;i++)
  for(int k=0;k<=NH;k++)
    w1[i][k] = zufall(); //oder zufall4() ?
}

void neuronen_init()
{
 int ok;
 if(g_modus==DRUCKTEXT) ok=nnw_einlesen("NeuronalesNetzSpektr.dat");
 else ok=nnw_einlesen("NeuronalesNetzwerk_init.dat");
 if(!ok)
  {
   for(int k=0;k<=NH;k++)
    {
     for(int i=0;i<=NX;i++)
      if(k==NH) w1[i][k]=0.0; else //test
       w1[i][k] = zufall4(); //TODO: zufall() oder zufall4() ?
     for(int j=0;j<NY;j++)
      if(k==NH) w2[k][j]=0.0; else //test
       w2[k][j] = zufall(); //TODO: zufall() oder zufall4() ?
    }
  }
 X[NX] = 1.0; //Bias immer auf 1 setzen
 if(argflag['V']) {
 printf("neuronen_init() gelernt[%d]=%d\n",ZEOUT,gelernt[ZEOUT]);//test
 printf(" gelernt[%d]=%d\n",'A',gelernt['A']);//test
 printf(" gelernt[%d]=%d\n",'B',gelernt['B']);//test
 printf(" gelernt[%d]=%d\n",'C',gelernt['C']);//test
 printf(" gelernt[%d]=%d\n",'1',gelernt['1']);//test
 printf(" gelernt[%d]=%d\n",'2',gelernt['2']);//test
 printf(" gelernt[%d]=%d\n",'3',gelernt['3']);//test
 printf(" gelernt[%d]=%d\n",'a',gelernt['a']);//test
 printf(" gelernt[%d]=%d\n",'b',gelernt['b']);//test
 printf(" gelernt[%d]=%d\n",'c',gelernt['c']);//test
 }
}

void teilbild_zeichnen(double xmi,double ymi,double xma,double yma,Bild& bi,
		       int nx=0,int ny=0,int x0=0,int y0=0)
{
 if(nx==0 || ny==0) {nx=bi.breite; ny=bi.hoehe;}
 double dx=(xma-xmi)/nx, dy=(yma-ymi)/ny;
 inital_new();
 for(int j=0; j<ny; j++)
  {double y2=yma-j*dy, y1=y2-dy;
   for(int i=0; i<nx; i++)
      {double x1=i*dx+xmi, x2=x1+dx;
       int grau=bi.getgrau(j+y0,i+x0); rgbcolor(grau,grau,grau);
       fillbox(x1,y1,x2,y2);
      }
  }
 term_refresh();
}

void teilbild_kopieren(int x0,int y0,int nx,int ny,Bild& quelle,Bild& ziel)
{
 ziel.init(nx,ny);
 for(int x=0;x<nx;x++)
  for(int y=0;y<ny;y++)
   {int grau=quelle.getgrau(y0+y,x0+x);
    ziel.setgrau(y,x,grau);
   }
}

/*
void eingabe_an_neuronen_alt(Bild& bil,int j0,int i0,int zflag=0) //wenn zflag gesetzt: Teilbild zeichnen
{
 if(g_modus==DRUCKTEXT) {eingabe_an_neuronen_neu(bil,j0,i0,zflag); return;}//TODO
 Bild teilbild;
 double ho=0,br=0,ypos=0;
 if(zflag && argflag['V']) printf("eingabe_an_neuronen(bil, j0=%d, i0=%d, zflag=%d)\n",j0,i0,zflag);//test
 if(zflag) {ho=(g_ymax-g_ymin)/4; br=ho; ypos=g_ymax;} //Werte zum Teilbild zeichnen
 if(bil.nx==NHO && bil.ny==NBR)
  {
   teilbild_kopieren(i0, j0, bil.nx, bil.ny, bil, teilbild);
   if(zflag>=2 && argflag['V']) printf("%dx%d teilbild_zeichnen(.. ypos-ho=%f ..)\n",bil.nx,bil.ny,ypos-ho);//test
   if(zflag>=2) teilbild_zeichnen(g_xmin, ypos-ho, g_xmin+br, ypos, teilbild);
  }
 else
  {
   Bild bi;
   teilbild_kopieren(i0, j0, bil.nx, bil.ny, bil, bi);
   if(zflag>=2 && argflag['V']) printf("teilbild_zeichnen(.. ypos-ho=%f ..)\n",ypos-ho);//test
   if(zflag>=2) {teilbild_zeichnen(g_xmin, ypos-ho, g_xmin+br, ypos, bi); ypos -= ho+ho/NHO;}
   umrechnung_nxm_nach_24x32_randweiss(bi,teilbild);
   if(zflag && argflag['V']) printf("24x32 teilbild_zeichnen(.. ypos-ho=%f ..)\n",ypos-ho);//test
   if(zflag) {teilbild_zeichnen(g_xmin, ypos-ho, g_xmin+br, ypos, teilbild); ypos -= ho+ho/NHO;}
  }
 
 int mingrau=0, maxgrau=255;
 for(int j=0,n=0;j<NHO;j++)
  for(int i=0;i<NBR;i++)
    {
     int grau = teilbild.getgrau(j,i); //j=Zeile, i=Spalte, Grauwert 0=schwarz 255=weiss
     if(grau<mingrau) mingrau=grau;
     if(grau>maxgrau) maxgrau=grau;
     X[n++] = grau;
    }
 if(maxgrau<=mingrau) maxgrau=mingrau+1;//wenn alle Pixel gleich: Fehler vermeiden
 int diff=maxgrau-mingrau;
 
#ifdef EINGABE_GRAUWERTE
 for(int i=0; i<(NHO*NBR); i++)
  {X[i] = 1.0 - (X[i]*diff/255+mingrau)/255.0;} //1.0 fuer schwarz, 0.0 fuer weiss
#else
 #ifdef EINGABE_SCHWARZWEISS //Werte auf 0.0 (helle) oder 1.0 (dunkle Pixel) setzen
 double mittleres_grau = (g_schwelle_schwarz+g_schwelle_weiss)/(2*255.0);
 for(int i=0; i<(NHO*NBR); i++)
   {X[i] = (X[i] > mittleres_grau) ? 0.0 : 1.0;} //helle Pixel auf 0.0, dunkle Pixel auf 1.0 setzen
 #endif
 #ifdef EINGABE_TRIPEL //Werte bei hellen Pixeln auf -1, bei dunklen +1, sonst 0.0
 double schwelle1 = g_schwelle_schwarz*diff/255.0+mingrau; //immer noch Bereich 0 ... 255
 double schwelle2 = g_schwelle_weiss*diff/255.0+mingrau;
 for(int i=0; i<(NHO*NBR); i++)
  {if(X[i] < schwelle1) X[i] = 1.0; //fuer schwarze Pixel +1 setzen
   else if(X[i] > schwelle2) X[i] = -1.0; //fuer weisse Pixel -1 setzen
   else X[i] = 0.0; //graue Pixel auf 0 setzen
  }
 #endif
#endif
 
 if(zflag) neuronen_rechts_zeichnen(X,NBR,NHO);
 if(zflag>=2) {propagieren(); neuronen_rechts_zeichnen(H,NBR,NHO);}//TODO
}
*/

void propagieren()
{
 double ks=g_ks; //Konstante Skalierung //TODO

 /*
 printf("X[%d]=\n",NX+1);//test
 int test=0;//test
 for(int i=0;i<=NX;i++)//test
  {//printf("%g ",X[i]);//test
   if(X[i]==0) printf(". "); else if(X[i]==1) printf("1 "); else printf("? ");
   if(++test==32) {printf("\n"); test=0;}//test: Zeilenumbruch alle 32 Zahlen
  }//test
  printf("\n");//test
 */
 
#ifndef W1FIXIERT
 for(int k=0;k<=NH;k++)
  {
   H[k]=0;
   for(int i=0;i<=NX;i++)
    {
     H[k] += w1[i][k]*X[i];
    }
   //fuer Hidden-Neuronen entweder Abs-Funktion oder Sigmoid-Funktion, was ist besser?
   //Abs-Funktion:
   //if(H[k] < 0.0001) H[k]=0.0001;
   if(H[k] < 0) H[k]=0;
   //Sigmoid-Funktion:
   //double x=H[k];
   //H[k] = (1.0/(1.0+exp(-x*ks)))*2-1;
   //printf("H[%d]=%g ",k,H[k]);//test
  }
#endif

 if(argflag['V'] && htestflag) //test
  {printf("\nH[%d]=\n",NH+1);//test
   test=0;
   for(int k=0;k<=NH;k++)
    if(k>=NH-1) {printf("%g ",H[k]);}
    else {
     if(H[k]==0) printf(". "); else if(H[k]==1) printf("1 "); else if(H[k]==0.5) printf("; ");
     else if(H[k]== -1) printf("# "); else printf("? ");
     if(++test==NBR) {printf("\n"); test=0;}//Zeilenumbruch
    }
   printf("\n");
  }//test
 
 for(int j=0;j<NY;j++)
  if(gelerntakt[j])
  {
   Y[j]=0;
   for(int k=0;k<=NH;k++)
    {
     Y[j] += w2[k][j]*H[k];
    }
   //Sigmoid-Funktion fuer Ausgabeneuronen:
   double x=Y[j];
   Y[j] = 1.0/(1.0+exp(-x*ks));
   //printf("x=%f Y[%d]=%f\n",x,j,Y[j]);//test
  }
 
 if(argflag['V'] && htestflag>=2) //test
  {int maxj=0; double maxwert=0;
   for(int j=0;j<NY;j++)
    if(gelerntakt[j])
     {
      if(Y[j]>maxwert) {maxwert=Y[j]; maxj=j;}
     }
   printf("maxwert=%g maxj=%d\n",maxwert,maxj);//test
   printf("w2[k][maxj]-Werte: ('.'=0, '#'<=-0.99 ';'=0.5)\n");//test
   test=0;
   for(int k=0;k<NH;k++)
    {double x=w2[k][maxj];
     if(x==0) printf(". "); else if(x==0.5) printf("; ");
     else if(x <= -0.99) printf("# ");
     else printf("%g ",x);
     if(++test==NBR) {printf("\n"); test=0;}//Zeilenumbruch
    }
   printf("\n");
  }//test
}

void m_scannen()
{
 gelernt_kopieren(gelerntakt);
 if(argflag['V']) htestflag=2;
 eingabe_an_neuronen(bild,shifty,shiftx,2);
 propagieren();
 htestflag=0;
 printf("m_scannen()\nZeichenerkennung:  Y[%d]=%f\n",ZEOUT,Y[ZEOUT]);//test
 double max= -2, min=2, max2= -2;
 double summe=0; int ns=0;//test
 int jmax=0,jmin=0,jmax2=0;
 for(int j=0;j<NOUT-1;j++)
  if(gelernt[j])
   {
    double x=Y[j];
    //printf("j=%d x=%f\n",j,x);//test
    summe += x; ns++;//test
    if(x>max) {max2=max; jmax2=jmax; max=x; jmax=j;}
    else if(max2== -2 && x==max) {max2=x; jmax2=j;}
    if(x<min) {min=x; jmin=j;}
   }
 printf("Kleinster Wert: %d: %f\n",jmin,min);
 printf("Zweitgroesster: %d: %f\n",jmax2,max2);
 printf("Groesster Wert: %d: %f\n",jmax,max);
 printf("x durchschnitt: %f\n",summe/ns);//test
 char c = isprint(jmax) ? jmax : '?';
 printf("Resultat von Neuronalem Netz: 0x%02X = \'%c\'\n",jmax,c);
}

void m_scannen2() //Lerndaten ueberpruefen
{
 printf("m_scannen2()\n");//test
 gelernt_kopieren(gelerntakt);
 int soll;
 //for(soll='A';soll<='Z';soll++)
 for(soll=1;soll<NY;soll++)
  if(gelernt[soll])
  {
   von_lernliste_einlesen(soll);
   if(!isletter(soll)) zusaflag=0;
   else zusaflag=g_modus;//TODO
   eingabe_an_neuronen(bild,shifty,shiftx);
   propagieren();
   zusaflag=g_modus;//TODO
   printf("soll=%c\nZeichenerkennung:  Y[%d]=%f\n",soll,ZEOUT,Y[ZEOUT]);//test
   double max= -2;
   int jmax=0;
   for(int j=0;j<NOUT-1;j++)
    if(gelernt[j])
     {
      double x=Y[j];
      if(x>max) {max=x; jmax=j;}
     }
   char c = isprint(jmax) ? jmax : '?';
   printf("Sollwert: 0x%02X \'%c\'\n",soll,soll);
   printf("Resultat von Neuronalem Netz: Y[j]=%f 0x%02X = \'%c\'\n",max,jmax,c);
  }
}

double scannen_test(int x0,int y0)
{
 gelernt_kopieren(gelerntakt);
 eingabe_an_neuronen(bild,y0,x0);
 propagieren();
 double zeichenerkennung=Y[ZEOUT];
 double max= -2;
 for(int j=' ';j<'z';j++)
  {
   if(gelernt[j])
    {
     double x=Y[j];
     if(x>max) {max=x;}
    }
  }
 if(max<0.8) return 0;
 return zeichenerkennung;
}

double propagieren_zeichenerkennung(int *zeichen,double *wert)
{
 propagieren();
 double zeichenerkennung=Y[ZEOUT];
 double max= -1;
 int jmax=0;
 for(int j=0;j<ZEOUT;j++)
  if(gelerntakt[j])
   {
    double x=Y[j];
    if(x>max) {max=x; jmax=j;}
   }
 *zeichen = jmax;
 *wert = max;
 return zeichenerkennung;
}

static int maxx0=0,maxy0=0;

int dunkler_pixel_in_linie(Bild& bil,int x0,int y1,int y2,int schwelle)
{
 if(y2>=y1)
  {for(int y0=y1;y0<y2;y0++)
    {int grau=bil.getgrau(y0,x0);
     if(grau<=schwelle) return y0;
    }
  }
 else //if(y2<y1)
  {for(int y0=y1; --y0>=y2;)
    {int grau=bil.getgrau(y0,x0);
     if(grau<=schwelle) return y0;
    }
  }
 return -1;//kein dunkler Pixel gefunden
}

bool dunkler_pixel_in_linie(int x0,int y1,int y2,int schwelle)
{
 for(int y0=y1;y0<y2;y0++)
    {
     int grau=bild.getgrau(y0,x0);
     if(grau<=schwelle) return true;
    }
 return false;
}

bool dunkler_pixel_in_zeile(int y0,int x1,int x2,int schwelle)
{
 for(int x0=x1;x0<x2;x0++)
  {if(bild.getgrau(y0,x0) <= schwelle) return true;}
 return false;
}

int nexty_weiss_unten(int x0,int y0,int endy0,int schwelle)
{
 for(; bild.getgrau(y0,x0) <= schwelle && y0<endy0; y0++) {}
 return y0;
}

int nexty_dunkel_unten(int x0,int y0,int endy0,int schwelle)
{
 for(; bild.getgrau(y0,x0) > schwelle && y0<endy0; y0++) {}
 return y0;
}

int ijerkennung(int buhoehe,int x0,int y0,int startx0,int starty0,int endy0,int schwelle)
{ //Rueckgabewert gefundenes Zeichen: 'i' oder 'j' oder 'l' (kleines L), 0=keins gefunden
  //weitere Rueckgabewerte: shiftx, shifty, bild.nx, bild.ny
 //x0,y0 ist Startpunkt mit dunklem Pixel, starty0...endy0 ist Bereich des Zeichens
 //kleinere y-Wert sind weiter oben, groessere weiter unten
 if(argflag['V'])
  printf("ijerkennung(buhoehe=%d,x0=%d,y0=%d,startx0=%d,starty0=%d,endy0=%d,schwelle=%d)\n",
	 buhoehe,x0,y0,startx0,starty0,endy0,schwelle);//test
 int x1,x2;
 for(x1=x0; dunkler_pixel_in_linie(x1,starty0,endy0,schwelle) && x1>startx0; x1--) {}
 //for(x2=x0; dunkler_pixel_in_linie(x2,starty0,endy0,schwelle); x2++) {}
 for(x2=x0+2; dunkler_pixel_in_linie(x2,starty0,endy0,schwelle); x2++) {}//test
 int breite=x2+1-x1;
 int buminbr = bu_minbreite*buhoehe/bu_hoehe;
 int buunterlaenge = bu_unterlaenge*buhoehe/bu_hoehe; 
 if(breite > buminbr*2)
  {if(argflag['V']) printf("zu breit\n");//test
   return 0;
  }
 if(argflag['V']) printf("ijerkennung() breite=%d\n",breite);//test
 x0=(x1+x2)/2;
 int y1,y2,ymitte=(starty0+endy0)/2;
 for(y1=starty0; bild.getgrau(y1,x0)>schwelle && y1<endy0; y1++) {}//erster Pixel vom ipunkt
 if(y1>ymitte)
  {if(argflag['V']) printf("1.Pixel unterhalb Mitte\n");//test
   //erster dunkler Pixel unterhalb Mitte: kein i-Punkt
   return 0;
  }
 for(y2=y1+1; bild.getgrau(y2,x0)<=schwelle && y2<endy0; y2++) {}//weisser Pixel unter ipunkt
 if(y2>ymitte) //Ende von i-Punkt unterhalb Mitte?
  {if(y2>endy0-4 && breite<buminbr*2)
    {if(argflag['V']) printf("kleines L erkannt: breite=%d y1=%d y2=%d\n",breite,y1,y2);//test
     shiftx=x1; shifty=starty0; bild.nx=x2+1-x1; bild.ny=endy0-starty0;
     return 'l';//kleines L erkannt //TODO: Unterscheidung grosses i?
    }
   if(argflag['V']) printf("letzter Pixel von i-Punkt unterhalb Mitte, zu breite fuer kleines L\n");//test
   return 0;
  }
 for(y1=y2+1; bild.getgrau(y1,x0)>schwelle && y1<endy0; y1++) {}//erster Pixel von unterm Teil
 if(y1==endy0)
  {if(argflag['V']) printf("kein unterer Teil gefunden\n");//test
   return 0;
  }
 for(y2=y1+1; bild.getgrau(y2,x0)<=schwelle && y2<endy0; y2++) {}//ende von unterm Teil
 if(y2<=ymitte)
  {if(argflag['V']) printf("ende von unterer Teil zu weit oben\n");//test
   return 0;
  }
 shiftx=x1; shifty=y0; bild.nx=x2-x1; bild.ny=endy0-starty0;
 //jetzt noch Unterscheidung i oder j:
 for(y2=endy0; bild.getgrau(y2,x0)<=schwelle && y2<endy0+buunterlaenge; y2++) {}
 if(y2>endy0+2) {bild.ny=y2-starty0; return 'j';}// j erkannt
 return 'i';// i erkannt
}

int zeichen_suchen(int buhoehe,int startx0,int starty0,int breite,int hoehe,int schwelle,double* bestwert)
{
 if(argflag['V']) printf("zeichen_suchen(startx0=%d, starty0=%d, breite=%d, hoehe=%d, schwelle=%d ...)\n",
			 startx0,starty0,breite,hoehe,schwelle);//test
 if(buhoehe==0)//TODO
  {buhoehe=bu_hoehe;
   while(hoehe>=buhoehe*2) buhoehe *= 2;
   if(hoehe>buhoehe*3/2) buhoehe = buhoehe*3/2;
  }
 int zeichen=0;
 *bestwert=0;
 int endy0=starty0+hoehe;
 int endx0=startx0+breite-2;
 //if(g_modus==DRUCKTEXT) {dru_shifty=starty0; dru_hoehe=hoehe;}//TODO
 for(int x0=startx0; x0<endx0; x0++)
  {
   int y0,grau;
   for(y0=endy0; --y0>=starty0 && (grau=bild.getgrau(y0,x0))>schwelle;) {}
   if(y0<starty0) continue;
   //rgbcolor(0,0,255); drawboxi(x0,y0,x0+4,y0+4); //sleep(1);//test blaue Markierung
   double wert,erkennung;
   int ij=ijerkennung(buhoehe,x0,y0,startx0,starty0,endy0,schwelle);
   // Rueckgabe: shiftx, shifty, bild.nx, bild.ny
   if(ij!=0)
    {if(argflag['V']) printf("Zeichen erkannt von ijerkennung() '%c'\n",ij);//test
     zeichen=ij; wert=1; erkennung=1;
    }
   else
    {
     zeichen_erkennung_von_mitte(x0,y0,0); //Rueckgabewerte: shiftx, shifty, bild.nx, bild.ny
     erkennung=propagieren_zeichenerkennung(&zeichen,&wert);
    }
   //printf("erkennung=%f zeichen='%c' wert=%f\n",erkennung,zeichen,wert);//test
   if(wert>0.65 && erkennung>0.65) {*bestwert=wert; return zeichen;}
   if(erkennung>0.5)
    {printf("unsicheres Zeichen bei %d %d\n",x0,y0);//test
     *bestwert=wert; 
     return zeichen;
    }
   x0 += bild.nx-1;
  }
 return 0;
}

int bereich_eingrenzen(int& x0,int& y0,int& breite,int& hoehe) //Rueckgabe: schwelle_schwarz
{
 int flag=0;
 if((x0+breite)>bild.breite) {breite=bild.breite-x0; flag++;}
 if((y0+hoehe)>bild.hoehe) {hoehe=bild.hoehe-y0; flag++;}
 bild.nx=breite; bild.ny=hoehe;
 if(flag) m_refresh();
 //Bereich mit dunkeln Pixeln suchen:
 bild.ausschnitt_schwelle3(x0,y0,breite,hoehe);//3 Schwellen berechnen: Weiss, Grau, Schwarz
 int schwelle = schwelle_schwarz;
 //kleinerer Wert von schwelle ist dunkeler Pixel
 //printf("schwelle=%d\n",schwelle);//test
 int i=0,j,grau=0;
 //Rand von oben und links einengen:
 for(j=0;j<hoehe;j++)
  {for(i=0;i<breite;i++)
    {
     grau=bild.getgrau(y0+j,x0+i);
     if(grau<schwelle) break;
    }
   if(grau<schwelle) break;
  }
 //printf("oberster dunkler Pixel gefunden bei x=%d y=%d\n",x0+i,y0+j);//test
 if(j>0) {--j; y0 += j; hoehe -= j;}
 for(i=0;i<breite;i++)
  {for(j=0;j<hoehe;j++)
    {
     grau=bild.getgrau(y0+j,x0+i);
     if(grau<schwelle) break;
    }
   if(grau<schwelle) break;
  }
 //printf("linkster dunkler Pixel gefunden bei x=%d y=%d\n",x0+i,y0+j);//test
 if(i>0) {--i; x0 += i; breite -= i;}
 //Rand von unten und rechts einengen:
 for(j=hoehe-1; --j>1;)
  {for(i=0;i<breite;i++)
    {
     grau=bild.getgrau(y0+j,x0+i);
     if(grau<schwelle) break;
    }
   if(grau<schwelle) break;
  }
 //printf("unterster dunkler Pixel gefunden bei x=%d y=%d\n",x0+i,y0+j);//test
 hoehe = j+1;
 for(i=breite-1; --i>1;)
  {for(j=0;j<hoehe;j++)
    {
     grau=bild.getgrau(y0+j,x0+i);
     if(grau<schwelle) break;
    }
   if(grau<schwelle) break;
  }
 //printf("rechtester dunkler Pixel gefunden bei x=%d y=%d\n",x0+i,y0+j);//test
 breite = i+1;
 //rgbcolor(255,0,255); drawboxi(x0,y0,x0+breite,y0+hoehe);//test Roter Rahmen um Text zeichnen
 //sleep(1);//test
 bild.ausschnitt_schwelle3(x0,y0,breite,hoehe);//3 Schwellen berechnen: Weiss, Grau, Schwarz
 return schwelle_schwarz; //Schwelle fuer schwarze Pixel
}

void m_wortscannen_lern()
{
 static int lernschritt=0;
 printf("m_wortscannen_lern()\n");//test
 lernschritt++;
 //int t_shiftx=shiftx, t_shifty=shifty, t_nx=bild.nx, t_ny=bild.ny;
 int startx0=shiftx, starty0=shifty;
 int breite=bild.nx, hoehe=bild.ny;
 int schwelle=bereich_eingrenzen(startx0,starty0,breite,hoehe); //schwelle_schwarz
 
 maxx0=startx0+breite;
 maxy0=starty0+hoehe;
 int ok,typ=0,klein=0;
 if(lernschritt>1 && hoehe<bu_hoehe-4) klein=1;//TODO
 ok=requester_input(2,
    "Worttyp (0=ohne, 1=mit Unterlaengen, 2=mit Oberlaengen, 3=beides)","%d","%d\n",&typ,
    "Nur Kleinbuchstaben ohne Unterlaenge? (0=nein, 1=ja)","%d","%d",&klein);
 if(!ok) {m_refresh(); return;}//TODO
 if(klein==0)
  {
   if(typ==0)      bu_hoehe = hoehe;
   else if(typ==1) bu_unterlaenge = hoehe-bu_hoehe;
   else if(typ==2) bu_oberlaenge = hoehe-bu_hoehe;
   else
    {int test=bu_unterlaenge+bu_oberlaenge+bu_hoehe;
     char stimmt[200];
     if(test==hoehe) strcpy(stimmt,"stimmtperfekt");
     else if(test<=hoehe+1 && test>=hoehe-1) strcpy(stimmt,"stimmtgut");
     else strcpy(stimmt,"unterschiedlich");
     ok=requester_input(5,"Vergleich mit bisherigen Werten","%s","%s\n",stimmt,
			"Hoehe","%d","%d",&bu_hoehe,
			"Unterlaenge","%d","%d",&bu_unterlaenge,
			"Oberlaenge","%d","%d\n",&bu_oberlaenge,
			"Alles zusammen","%d","%d",&hoehe);
    }
  }
 else
  {
   ok=requester_input(4,"bu_hoehe","%d","%d",&bu_hoehe,
			"bu_unterlaenge","%d","%d",&bu_unterlaenge,
			"bu_oberlaenge","%d","%d\n",&bu_oberlaenge,
			"Hoehe aktuelles Wort","%d","%d",&hoehe);
  }
 //Wort in Buchstaben unterteilen:
 int x[81]; //Endpositionen von maximal 80 Buchstaben in Wort (x[0]=Endpos 1.Buchstabe), Ende=0
 int z[81]; //Zwischenraeume zwischen maximal 80 Buchstaben (z[1]=zwischen 1. und 2.), Ende= -1
 int maxabstand=0;
 if(lernschritt>1) {maxabstand=bu_maxabstand;}
 for(int k=0;k<80;k++)
  {int y;
   //Spalte mit dunkeln Pixeln suchen:
   int x0 = (k==0) ? startx0+1 : x[k-1]+1;
   int abst=0;
   for(; x0<maxx0; x0++)
    {for(y=starty0;y<maxy0;y++)  {if(bild.getgrau(y,x0)<schwelle) break;}
     if(y<maxy0) break;
     abst++;
    }
   if(x0==maxx0) //kein weiterer Buchstabe gefunden?
    {x[k]=0; z[k]= -1; break;}
   z[k]=abst;
   if(abst>maxabstand) maxabstand=abst;
   //Spalte ohne dunkle Pixel suchen:
   for(x0++; x0<maxx0; x0++)
    {for(y=starty0;y<maxy0;y++)  {if(bild.getgrau(y,x0)<schwelle) break;}
     if(y==maxy0) break;
    }
   x[k]=x0;
   if(x0==maxx0) {x[k+1]=0; z[k+1]= -1; break;}
  }
 int minbreite=255, maxbreite=0;
 if(lernschritt>1) {minbreite=bu_minbreite; maxbreite=bu_maxbreite;}
 for(int k=0; x[k]!=0; k++)
  {int x0 = (k==0) ? startx0 : x[k-1];
   int br = x[k]-x0;
   printf("Breite %d. Buchstabe: %d  Abstand: %d\n",k+1,br,z[k]);//test
   if(br<minbreite) minbreite=br;
   if(br>maxbreite) maxbreite=br;
  }
 ok=requester_input(3,"minbreite","%d","%d",&minbreite,
		    "maxbreite","%d","%d",&maxbreite,
		    "maxabstand","%d","%d",&maxabstand);//TODO
 if(ok) {bu_minbreite=minbreite; bu_maxbreite=maxbreite; bu_maxabstand=maxabstand;}
 //TODO
}

int dru_starty_hoehe_anpassen(int& starty0,int& hoehe)
{
 int flag=0;
 //printf("dru_starty_hoehe_anpassen(starty0=%d,hoehe=%d)\n",starty0,hoehe);//test
 int buhoehe=bu_hoehe;
 int buoberlaenge = bu_oberlaenge;
 int buunterlaenge = bu_unterlaenge;
 if(hoehe>bu_hoehe*3/2) //grosse Buchstaben (z.B. in Titel)
  {//TODO: wie tatsaechliche Buchstabenhoehe erkennen?
   buhoehe=hoehe;
   buoberlaenge = bu_oberlaenge*buhoehe/bu_hoehe;
   buunterlaenge = bu_unterlaenge*buhoehe/bu_hoehe;
  }
 if(buoberlaenge!=0 && hoehe>=buhoehe+buunterlaenge+buoberlaenge-1) //TODO
  {// fuer Buchstabe mit Unterlaengen und Oberlaengen anpassen
   starty0 += buoberlaenge;
   hoehe=buhoehe;
   flag=1;
  }
 //else if... //TODO: Wort mit nur Oberlaengen - wie erkennen?
 else if(hoehe<buhoehe-4)
  {// fuer kleiner Kleinbuchstabe anpassen (acemnorsuvwxz)
   int d=buhoehe-hoehe;
   hoehe=buhoehe;
   starty0 -= d;
   if(starty0<0) {d= -starty0; starty0=0; hoehe -= d;}
   flag=1;
  }
 else if(hoehe>buhoehe+buunterlaenge/2)
  {// fuer Buchstaben mit Unterlaenge anpassen
   hoehe -= buunterlaenge;
   flag=1;
  }
 //printf("dru_starty_hoehe_anpassen() fertig: hoehe=%d flag=%d\n",hoehe,flag);//test
 return flag;
}

//Vordeklaration:
int wortscannen(int buhoehe,char *geftext,int startx0,int starty0,int breite,int hoehe,int schwelle);

void m_wortscannen()
{
 if(lernmodus) {m_wortscannen_lern();}
 printf("m_wortscannen()\n");//test
 int startx0=shiftx, starty0=shifty;
 int breite=bild.nx, hoehe=bild.ny;
 int schwelle=bereich_eingrenzen(startx0,starty0,breite,hoehe); //schwelle_schwarz
 char geftext[200];
 //int gefj=
  wortscannen(0,geftext,startx0,starty0,breite,hoehe,schwelle);
 printf("gefundenes Wort:\"%s\"\n",geftext);
}

int wortscannen(int buhoehe,char *geftext,int startx0,int starty0,int breite,int hoehe,int schwelle)
{//geftext[] muss Platz fuer 200 Zeichen haben
 //buhohe==0 falls noch nicht bekannt
 int t_shiftx=shiftx, t_shifty=shifty, t_nx=bild.nx, t_ny=bild.ny;
 if(g_modus==DRUCKTEXT)
  {// weiteres Anpassen von: startx0,starty0,breite,hoehe
   int zeichnenflag = dru_starty_hoehe_anpassen(starty0,hoehe);
   if(zeichnenflag)
    {//Testrahmen neu zeichnen:
     rgbcolor(0,255,255); drawboxi(startx0,starty0,startx0+breite,starty0+hoehe);//Blaugruener Rahmen um Wort zeichnen
    }
  }
 maxx0=startx0+breite;
 maxy0=starty0+hoehe;
 if(argflag['V']) printf("maxx0=%d maxy0=%d\n",maxx0,maxy0);//test
 
 //von links nach rechts suchen:
 double bestwert=0;
 int zeichen=zeichen_suchen(buhoehe,startx0,starty0,breite,hoehe,schwelle,&bestwert);
 if(bestwert==0)
  {shiftx=t_shiftx; shifty=t_shifty; bild.nx=t_nx; bild.ny=t_ny;
   printf("keine Zeichen gefunden\n");//test
   return 0;
  }
 int x0=shiftx, y0=shifty, nx=bild.nx, ny=bild.ny; //wurde von zeichen_suchen() gesetzt wenn erfolgreich
 shiftx=t_shiftx; shifty=t_shifty; bild.nx=t_nx; bild.ny=t_ny;
 int gefj=0;
 if(argflag['V'])
  {printf("Erstes gefundenes Zeichen bei x=%d y=%d %dx%d: '%c'\n",x0,y0,nx,ny,zeichen);//test
   printf("bestwert=%f\n",bestwert);//test
  }
 //rgbcolor(255,0,0); drawboxi(x0,y0,x0+nx,y0+ny);//test Roter Rahmen um erstes Zeichen zeichnen
 geftext[gefj++]=zeichen;
 if(argflag['V']) printf("nachfolgende Zeichen:\n");//test
 for(;;)
  {
   if(x0<startx0-2)
    {if(x0+nx < startx0+4)
      {printf("Fehler x0<startx0: x0=%d, startx0=%d, nx=%d\n",x0,startx0,nx);//test
       startx0=startx0+4;//TODO
      }
     else startx0 = x0+nx;
    }
   else startx0 = x0+nx;
   breite=maxx0-startx0; if(breite<3) break;
   zeichen=zeichen_suchen(buhoehe,startx0,starty0,breite,hoehe,schwelle,&bestwert);
   if(bestwert==0) break;
   x0=shiftx; y0=shifty; nx=bild.nx; ny=bild.ny; //wurde von zeichen_suchen() gesetzt wenn erfolgreich
   shiftx=t_shiftx; shifty=t_shifty; bild.nx=t_nx; bild.ny=t_ny;
   geftext[gefj++]=zeichen;
   int c=zeichen; if(!isprint(c)) {c='?'; printf("zeichen=%d\n",zeichen);}//test
   if(argflag['V'])
    {printf(" Zeichen bei x=%d y=%d %dx%d: '%c'\n",x0,y0,nx,ny,c);//test
     printf(" bestwert=%f\n",bestwert);//test
    }
   //rgbcolor(0,255,0); drawboxi(x0,y0,x0+nx,y0+ny);//test Gruener Rahmen um Zeichen zeichnen
   if(gefj>200-1) break;
  }
 shiftx=t_shiftx; shifty=t_shifty; bild.nx=t_nx; bild.ny=t_ny;
 if(argflag['V']) printf("Total %d Zeichen in Wort gefunden\n",gefj);//test
 geftext[gefj]=0;
 return gefj;
}

int hatzeile_dunkle_punkte(int y0,int x0,int x2)
{
 int schwelle=schwelle_schwarz;
 for(;x0<x2;x0++)
  {if(bild.getgrau(y0,x0)<schwelle) return x0+1;}
 return 0;
}

int naechst_heller_in_zeile(int y0,int x0,int x2)
{
 int schwelle=schwelle_schwarz;
 for(;x0<x2;x0++)
  {if(bild.getgrau(y0,x0)>=schwelle) return x0;}
 return 0;
}
 

bool hatspalte_dunkle_punkte(int x0,int y0,int y2)
{
 int schwelle=schwelle_schwarz;
 for(;y0<y2;y0++)
  {if(bild.getgrau(y0,x0)<schwelle) return true;}
 return false;
}

int anzdunkle_punkte_in_zeile(int y0,int x0,int x2)
{
 int anz=0;
 for(;x0<x2;x0++) {if(bild.getgrau(y0,x0)<schwelle_schwarz) anz++;}
 return anz;
}

int anzdunkle_punkte_in_spalte(int x0,int y0,int y2)
{
 int anz=0;
 for(;y0<y2;y0++) {if(bild.getgrau(y0,x0)<schwelle_schwarz) anz++;}
 return anz;
}

void test_tabelle_asciart(int* tab,int anz,int maxwert)
{
 for(int j=0;j<anz;j++)
  {int wert=tab[j]; if(maxwert>80) wert=wert*80/maxwert;
   for(int i=0;i<=wert;i++) printf("*");
   printf("\n");
  }
}

int buchstabenhoehe_aus_zeile_ermitteln(int x1,int y0,int x2,int y2)
{
 int hoehe = y2-y0; //das ist wahrscheinlich mit Unterlaenge
 int j, anztab[hoehe], max=0;
 for(j=0; j<hoehe; j++)
  {
   int n = anzdunkle_punkte_in_zeile(y0+j,x1,x2);
   if(n>max) max=n;
   anztab[j]=n; 
  }
 //test_tabelle_asciart(anztab,hoehe,x2-x1);//test
 for(j=hoehe; j>0; j--)
  {if(anztab[j-1]>max/2) break;}
 if(j<hoehe) j++;
 int unt = hoehe-j;//vermutliche Unterlaenge
 int obe = 0;
 if(bu_oberlaenge!=0)
  {
   for(j=0; j<hoehe; j++)
    {if(anztab[j]>max/4) break;}
   if(j>0) j--;
   obe = j;//vermutliche Oberlaenge
  }
 printf("hoehe=%d obe=%d unt=%d\n",hoehe,obe,unt);//test
 int buhoehe = hoehe-obe-unt;
 if(!fastgleich(double(buhoehe)/hoehe, double(bu_hoehe)/(bu_hoehe+bu_unterlaenge+bu_oberlaenge), 0.05))
  {
   // unt ist vielleicht nur Unterlaenge von Komma oder Punktstrich
   int ukomma = bu_unterlaenge/2;//TODO
   if(fastgleich(double(buhoehe)/hoehe, double(bu_hoehe)/(bu_hoehe+ukomma+bu_oberlaenge), 0.05))
    {printf("Zeile vermutlich mit Komma oder Strichpunkt\n");//test
    }
   else
    {printf("buhoehe unsicher: %d\n",buhoehe);//test
     //TODO
    }
  }
 return buhoehe;
}

int satzzeichen_erkennung(int buhoehe,int startx0,int starty0,int endx0,int endy0)
{
 printf("satzzeichen_erkennung(buhoehe=%d, startx0=%d, starty0=%d, endx0=%d, endy0=%d)\n",//test
 	buhoehe,startx0,starty0,endx0,endy0);//test
 int hoehe=endy0-starty0;//test
 if(!fastgleich(double(hoehe)/buhoehe, 1.0, 0.05))//test
  {printf("hoehe und buhoehe verschieden: %d %d\n",hoehe,buhoehe);}//test
 int y0,y1,y2,y3,y4;
 //test auf dunkle Punkte in unterm Bereich:
 for(y0=endy0-hoehe/3; y0<endy0; y0++)
  {if(hatzeile_dunkle_punkte(y0,startx0,endx0)) break;}
 if(y0==endy0)
  {//keine dunkle Punkte in unterm Bereich
   printf("keine dunkle Punkte in unterm Bereich\n");//test
   for(y0=endy0; --y0>=starty0;)
    {if(hatzeile_dunkle_punkte(y0,startx0,endx0)) break;}
   if(y0<starty0+hoehe*3/4 && y0>starty0+hoehe/8)
    {//eventuell ein Minus-Zeichen
     for(y1=starty0; y1<endy0; y1++)
      {if(hatzeile_dunkle_punkte(y1,startx0,endx0)) break;}
     if(y1-y0 > hoehe/4) {return 0;}//zu dick fuer Minus-Zeichen?
     return '-';
    }
   //TODO: ev. noch auf + pruefen
   return 0;
  }
 //suche mindestens 2 dunkle Bereich von oben nach unten:
 int x1=startx0, x2=endx0;
 for(y1=starty0;y1<endy0;y1++) //Start von oberstem dunklen Bereich->y1
  {if(hatzeile_dunkle_punkte(y1,x1,x2)) break;}
 for(y2=y1+1;y2<endy0;y2++) //Ende von oberstem dunklen Bereich->y2
  {if(!hatzeile_dunkle_punkte(y2,x1,x2)) break;}
 for(y3=y2+1;y3<endy0;y3++) //Start von 2. dunklen Bereich->y3
  {if(hatzeile_dunkle_punkte(y3,startx0,endx0)) break;}
 for(y4=y3+1;y4<endy0+8;y4++) //Ende von 2. dunklen Bereich->y4
  {if(!hatzeile_dunkle_punkte(y4,startx0,endx0)) break;}
 
 if(y3>=endy0) //nur 1 dunkler Bereich
  {//vielleicht Punkt oder Komma
   printf("nur 1 dunkler Bereich, endy0=%d y3=%d\n",endy0,y3);//test
   if(y1<starty0+hoehe*3/4) return 0;//Beginn dunkler Bereich zu weit oben
   y3=endy0+8;
   for(y2++;y2<y3;y2++)
    {if(!hatzeile_dunkle_punkte(y2,startx0,endx0)) break;}
   //printf("Komma oder Punkt erkannt\n");//test
   if(y2>endy0+2) return ',';//Komma erkannt TODO: ev. auch Underline
   return '.';//Punkt erkannt TODO: ev. auch Underline
  }
 
 //mindestens 2 dunkle Bereiche erkannt.
 int dyoben= y2-y1; //groesse oberer dunkler Bereich
 int dyunten=y4-y3; //groesse unterer dunkler Bereich
 printf("y1=%d dyoben=%d dyunten=%d\n",y1,dyoben,dyunten);//test
 if(y1<starty0+(hoehe+7)/8 && dyunten>dyoben) //oberer Bereich hoch oben und unterer Bereich groesser?
  {printf("vermutlich i oder j oder umlaut\n");//test
   //TODO: auf umlaute testen
   return 0; //kein Satzzeichen, koennte ev i oder j sein, oder Umlaute ae oe ue
  }
 
 y3=starty0; y4=endy0;
 while(hatzeile_dunkle_punkte(y4,x1,x2) && !hatzeile_dunkle_punkte(y3+1,x1,x2))
  {y3++; y4++;} //fuer Unterlaenge (,;) Kasten nach unten schieben
 //if(y4>endy0+2) printf("wahrscheinlich Strichpunkt\n");//test
 //else printf("kein Strichpunkt y3=%d y4=%d\n",y3,y4);//test
 
 int zeichen=0;
 int nx_vorher=bild.nx, ny_vorher=bild.ny;
 int zusaflag_vorher=zusaflag;
 zusaflag=0;
 set_gelerntakt(GRUPPE_SATZZEICHEN);
 bild.nx=endx0-startx0; bild.ny=y4-y3;
 eingabe_an_neuronen(bild,y3,startx0);
 double wert=0;
 //double erkennung =
 propagieren_zeichenerkennung(&zeichen,&wert);
 //printf("erkennung=%f wert=%f zeichen='%c'\n",erkennung,wert,zeichen);//test
 if(wert<0.9) zeichen=0;
 set_gelerntakt_ohne(GRUPPE_SATZZEICHEN);
 zusaflag=zusaflag_vorher;
 bild.nx=nx_vorher; bild.ny=ny_vorher;
 return zeichen;
}

void m_abschnittscannen()
{
 printf("m_abschnittscannen()\n");//test
 int x0=shiftx, y0=shifty;
 int breite=bild.nx, hoehe=bild.ny;
 int schwelle=bereich_eingrenzen(x0,y0,breite,hoehe);
 if(schwelle!=schwelle_schwarz) printf("Fehler: schwelle ungleich schwelle_schwarz\n");//test
 printf("schwelle = schwelle_schwarz = %d\n",schwelle);//test
 //int t_shiftx=shiftx, t_shifty=shifty, t_nx=bild.nx, t_ny=bild.ny;
 char geftext[2200]; int gefj=0;//bisher gefundener Text
 int startx0=x0, starty0=y0, y1,y2;
 int maxx0=startx0+breite;
 int maxy0=starty0+hoehe;
 printf("x0=%d y0=%d maxx0=%d maxy0=%d\n",x0,y0,maxx0,maxy0);//test
 
 // Zeilen suchen:
 int maxzeilen=200;//TODO
 for(int zeile=0; zeile<maxzeilen; zeile++)
  {
   if(zeile>0 && gefj>0) geftext[gefj++]='\n';
   //Anfang einer Zeile suchen:
   for(y0=starty0; y0<maxy0 && !hatzeile_dunkle_punkte(y0,startx0,maxx0); y0++) {}
   y1=y0;
   //printf("Start %d.Zeile: %d\n",zeile+1,y1);//test
   //Ende der Zeile suchen:
   for(y0++; y0<maxy0 && hatzeile_dunkle_punkte(y0,startx0,maxx0); y0++) {}
   y2=y0;
   //printf("Ende %d.Zeile: %d\n",zeile+1,y2);//test
   int buhoehe = buchstabenhoehe_aus_zeile_ermitteln(startx0,y1,maxx0,y2);
   printf("buhoehe=%d\n",buhoehe);//test
   int y3=y1+buhoehe;//TODO
   
   // Worte in Zeile suchen:
   int x1bu[200],x2bu[200],zeich[200]; int bj;
   for(int wort=0,x3=startx0; ;wort++)
    {
     for(bj=0,x0=x3; bj<200; bj++)
      {
       for(x0++; x0<maxx0 && !hatspalte_dunkle_punkte(x0,y1,y2); x0++) {}
       if(x0>=maxx0) {x3=x0; break;}//fertig wenn Ende der Zeile erreicht
       if(bj>0 && x0-x2bu[bj-1] > bu_maxabstand+1) break;//fertig wenn Wortabstand erkannt
       x1bu[bj]=x0; //Start bj. Buchstabe
       for(x0++; x0<maxx0 && hatspalte_dunkle_punkte(x0,y1,y2); x0++) {}
       x2bu[bj]=x0; //Ende bj. Buchstabe
       //printf("%d. Buchstabe x1=%d x2=%d\n",bj+1,x1bu[bj],x2bu[bj]);
      }
     if(bj==200) printf("Fehler: zu viele Buchstaben in Wort\n");//test
     if(bj==0) {printf("bj=0\n");//test
                break;}//fertig wenn keine weiteren Buchstaben gefunden
     //printf("%d Buchstaben in %d. Wort der %d. Zeile\n",bj,wort+1,zeile+1);//test
     for(int j=0;j<bj;j++)
      {int xb1=x1bu[j], xb2=x2bu[j];
       rgbcolor(0,255,0); drawboxi(xb1,y1,xb2,y3);//test Gruener Rahmen um Zeichen zeichnen
       zeich[j] = satzzeichen_erkennung(buhoehe,xb1,y1,xb2,y3);//TODO
       //if(zeich[j]==0) zeich[j]=zeichenscannen(...); //TODO
      }
     x0=x1bu[0];
     int br=x2bu[bj-1]-x0, ho=y3-y1;
     set_gelerntakt_ohne(GRUPPE_SATZZEICHEN);
     int n=wortscannen(buhoehe,&geftext[gefj],x0,y1,br,ho,schwelle);//TODO: wegoptimieren
     geftext[gefj+n]=0;
     for(int j=0;j<bj;j++)
      if(zeich[j]!=0)
       {geftext[gefj+j]=zeich[j];}//TODO
     printf("gefundenes Wort:\"%s\"\n",&geftext[gefj]);
     gefj += n;
     if(x3>=maxx0) break;//Ende der Zeile erreicht
     x3 = x2bu[bj-1];
     if(x3+1>=maxx0) break;//Ende der Zeile erreicht
     geftext[gefj++]=' ';//TODO: noch Satzzeichen suchen
     if(gefj>=2000) {printf("zu viele Buchstaben in Zeile\n"); break;}
    }
   printf("y2=%d maxy0=%d\n",y2,maxy0);//test
   starty0=y2; if(starty0>=maxy0) break;
  }
 geftext[gefj++]=0;
 printf("gefundener Text in Abschnitt:\n");//test
 printf("%s\n",geftext);//test
 /*
 sleep(1);//test
 shiftx=t_shiftx; shifty=t_shifty; bild.nx=t_nx; bild.ny=t_ny;
 m_refresh();
 */
}

/************************* Menu Behandlung ****************************/
static int exitflag=0;
static char bildquellname[200];
void menu_exit() {exitflag=1;}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 char quellname[200],quellname2[200];
 quellname[0]=quellname2[0]=0;
 bildquellname[0]=0;
 int i,j=0,c;
 int breite,hoehe,tiefe,visklasse;
 if(argc>0)
  {
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else if(++j==1) strcpy(quellname,argv[i]);
	 else if(j==2) strcpy(quellname2,argv[i]);
	}
  }
 if(argflag['?'] || j>MAXARG)
	{printf("halesen  %s\n",VERSION);
	 printf("Anwendung: %s [-Flags] [Quelle]\n",argv[0]);
	 printf("  quelle.png fuer Bild, quelle.txt fuer Lerndatei, quelle.dat fuer NeuroNetzWerk\n");
	 printf("  Flags: v=verbose (Testpunkte drucken)\n");
	 printf("         L=Lernen von Quelle (lerndaten.txt)\n");
	 printf("         d= drucktext-Modus gesetzt (default)\n");
	 printf("         h= handschrift-Modus gesetzt\n");
	 printf("         t= Test: lernmodus gesetzt\n");
	 exit(0);
	}
 if(argflag['D']) g_modus=1;
 if(argflag['H']) g_modus=0;
 if(argflag['T']) {lernmodus=1;}//TODO
 if(g_modus!=0) {zusaflag=1;}//TODO
 if(g_modus==1) printf("Drucktext-Modus gesetzt.\n");//test
 else  printf("Handschrift-Modus gesetzt.\n");//test
 if(hatendung(quellname,".txt")) setargflags("L");
 if(argflag['L'])
  {if(quellname[0]==0) {printf("Lerndatei: "); scanf("%s",quellname);}
   if(!hatendung(quellname,".txt")) {printf("Fehler: Lerndatei muss Endung .txt haben\n"); exit(0);}
   strncpy(lerndatei[0],quellname,200);
   FILE *fp=fopen(quellname,"r");
   if(fp!=NULL)
    {fscanf(fp,"%s",bildquellname);
     fclose(fp);
     if(!istbilddatei(bildquellname))
      {printf("Bildname in Bilddatei: \"%s\"\n",bildquellname);
       printf("fehlende oder falsche Bilddatei in %s\n",quellname);
       bildquellname[0]=0;
      }
    }
   else printf("kann \"%s\" nicht oeffnen\n",quellname);
   quellname[0]=0;
  }
 neuronen_init();
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 setsize(breite,hoehe,tiefe);
 setmenu(4,"File",    "Position","Zoom",    "Scannen");
 setmenu(4,"Load ...","Rechts",  "Zoom in", "Werte setzen ...", menu_load, m_rechts, m_zoomin, m_wertesetzen);
 setmenu(4,"Save ...","Unten",   "Zoom out","Lernen ...", menu_save, m_unten, m_zoomout, m_lernen);
 setmenu(4,"Exit",    "Links", "Zoomfaktor ...","Werte anzeigen",menu_exit,m_links,m_zoomfaktor,m_anzeigen);
 setmenu(4,NULL,      "Oben",   "Totale",     "Scannen",  NULL, m_oben, m_zoomtotale, m_scannen);
 setmenu(4,NULL, "Position ...","Zoom 24x32", "Lerndaten scannen", NULL,m_position, m_zoom24x32, m_scannen2);
 setmenu(4,NULL,"Lernposition ...","Refresh", "Wort scannen", NULL,m_lernpos, m_refresh, m_wortscannen);
 setmenu(4,NULL, NULL,             NULL,      "Abschnitt scannen", NULL,NULL,NULL,m_abschnittscannen);
 //set_funktions(maus_gedrueckt,maus_losgelassen,fenster_verdeckung,maus_bewegung);
 set_funktions(maus_gedrueckt,maus_losgelassen,NULL,maus_bewegung);
 inital(g_xmin,g_ymin,g_xmax,g_ymax); /* Grafikfenster oeffnen */
#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss (default ist weiss auf schwarz):
 if(TIEFE==24)
  {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
 else
  {screenclear(1); color(0);}
#endif
 drawbox(0.0,0.0,1.0,1.0); // ein Quadrat zeichnen
 term_refresh();

 int zoomflag=0;
 if(argflag['L'])
  {
   lerndatei_einlesen();
   erstes_anlernen();
   zoomflag=1;
  }
 else if(quellname[0]!=0)
  {
   bild_einlesen(quellname);
   zoomflag=1;
  }
 if(quellname2[0]!=0)
  {
   datei_laden(quellname2);
   zoomflag=1;
  }
 if(zoomflag) m_zoomtotale();

 while(exitflag==0 && waitmenu(0)==0) // auf Benutzereingaben warten
  {
   waitBOF();		//auf Ende des Bildaufbaus warten
  }
 term_exit();
 return 0;
}/* ende von main */

void datei_laden(const char *name)
{
 if(hatendung(name,".ppm") || hatendung(name,".png"))  bild_einlesen(name);
 else if(hatendung(name,".dat"))
  {if(nnw_einlesen(name)!=0) printf("%s erfolgreich eingelesen.\n",name);
   else printf("Fehler beim Einlesen von NNW-Datei %s\n",name);
  }
 else if(hatendung(name,".txt"))
  {strncpy(lerndatei[0],name,200-1);
   int jmax=lerndatei_einlesen();
   if(jmax==0) printf("Fehler beim Einlesen von Lerndatei %s\n",name);
   else printf("Lerndatei eingelesen: jmax=%d\n",jmax);
  }
 else printf("kann keine Datei mit Endung \"%s\" laden\n",getendung(name));
}

void menu_load()
{
 int ok=nachfilenamefragen("Lade Datei",bildquellname,200);
 if(ok)
  {datei_laden(bildquellname);
   m_zoomtotale();
  }
}

void fprintf_fliesszahl(FILE *fp,double zahl)
{
 if(zahl==1.0)    fprintf(fp,"1 ");
 else if(zahl==0) fprintf(fp,"0 ");
 else fprintf(fp,"%f ",zahl);
}

void menu_save()
{
 char dateiname[200]; strcpy(dateiname,"NeuronalesNetzwerk2.dat");
 int ok=nachfilenamefragen("Speichere NeuronalesNetzWerk (NNW)",dateiname,200);
 if(ok)
  {
   FILE *fp=fopen(dateiname,"r");
   if(fp!=NULL)
    {fclose(fp); ok=janeinrequester("Datei schon vorhanden, ueberschrieben?","ja","nein");
     if(!ok) return;
    }
   fp=fopen(dateiname,"w");
   if(fp==NULL) {printf("Konnte Datei \"%s\" nicht erstellen.\n",dateiname); return;}
   fprintf(fp,"%d %d %d %d ;AnzahlEbenen NX NH ... NY\n",3,NX,NH,NY);
   fprintf(fp,"gelernt: ");
   for(int j=0;j<NOUT;j++)
     if(gelernt[j])
      {if(j>' ' && j<='z') fprintf(fp,"'%c' ",j);
       else fprintf(fp,"%d ",j);
      }
   fprintf(fp,"\nw1: ");
   for(int i=0;i<=NX;i++)
    for(int k=0;k<=NH;k++)
     fprintf_fliesszahl(fp,w1[i][k]);
   fprintf(fp,"\nw2: ");
   for(int k=0;k<=NH;k++)
    for(int j=0;j<NY;j++)
     fprintf_fliesszahl(fp,w2[k][j]);
   fprintf(fp,"\n");
   fclose(fp);
  }
}

void gelernt_einlesen(FILE *fp)
{
 int c,j;
 //printf("gelernt_einlesen()\n");//test
 while((c=getc(fp))!='\n' && c!=EOF)
  {if(c==' ') continue;
   if(c=='\'')
    {j=getc(fp); c=getc(fp);} //Zeichen als 'X' dargestellt
   else if(isdigit(c))
    {//Sonder-Zeichen als Zahl dargestellt
     ungetc(c,fp);
     fscanf(fp,"%d",&j);
    }
   //printf("gelernt[%d]=1\n",j);//test
   gelernt[j]=1;
  }
 gelernt_kopieren(gelerntakt);
}

int nnw_einlesen(const char *name)
{
 FILE *fp=fopen(name,"r"); if(fp==NULL) return 0;
 int c,anz,nx,nh,ny;
 c=fscanf(fp,"%d %d %d %d\n",&anz,&nx,&nh,&ny);
 if(c!=4 || anz!=3) {fclose(fp); printf("Falsche Struktur in \"%s\"\n",name); return 0;}
 if(nx!=NX || nh!=NH || ny!=NY) {printf("NNW Groesse stimmt nicht ueberein\n"); return 0;}
 while((c=getc(fp))!='w' && c!='g' && c!=EOF) {} //suche w1: oder gelernt:
 if((c=getc(fp))=='e')
  {
   while((c=getc(fp))!=':' && c!=EOF) {} //"gelernt:" ueberlesen
   gelernt_einlesen(fp);
   while((c=getc(fp))!='w' && c!=EOF) {} //suche w1:
  }
 while((c=getc(fp))!=':' && c!=EOF) {} //"w1:" ueberlesen
 if(c==EOF) {fclose(fp); printf("w1: fehlt in \"%s\"\n",name); return 0;}
 for(int i=0;i<=NX;i++)
  for(int k=0;k<=NH;k++)
   fscanf(fp,"%lf ",&w1[i][k]);
 while((c=getc(fp))!=':' && c!=EOF) {} //"w2:" ueberlesen
 if(c==EOF) {fclose(fp); printf("w2: fehlt in \"%s\"\n",name); return 0;}
 for(int k=0;k<=NH;k++)
  for(int j=0;j<NY;j++)
   fscanf(fp,"%lf ",&w2[k][j]);
 fclose(fp);
 return 1;
}

void bild_einlesen(const char *name)
{
 char ppmname[200];
 bool ppmflag = istppm(name);
 if(!ppmflag)
  {
   endungersetzen(ppmname,name,".ppm");
   system2("convert %s %s",name,ppmname);
  }
 else strcpy(ppmname,name);
 FILE *fp=fopen(ppmname,"rb");
 if(fp==NULL) {printf("kann \"%s\" nicht oeffnen\n",ppmname); return;}
 if(getc(fp)!='P' || getc(fp)!='6') {printf("Fehler in \"%s\": P6 fehlt\n",ppmname); return;}
 getc(fp); //0A ueberlesen
 fscanf(fp,"%d %d",&bild.breite,&bild.hoehe);
 int tiefe;
 fscanf(fp,"%d",&tiefe);
 printf("breite=%d hoehe=%d tiefe=%d\n",bild.breite,bild.hoehe,tiefe);//test
 if(getc(fp)!='\n') printf("fehlender Zeilentrenner\n");//test
 int i,j,wert;
 //gesamtes Bild einlesen:
 for(j=0; j<bild.hoehe; j++)
  for(i=0; i<bild.breite; i++)
   {
    int r = (getc(fp) & 0xFF);
    //if(tiefe>255) {wert <<= 8; wert += (getc(fp) & 0xFF);}
    if(tiefe>255) {getc(fp);} //auf 8Bit pro Farbwert beschraenken
    int g = (getc(fp) & 0xFF);
    if(tiefe>255) {getc(fp);} //auf 8Bit pro Farbwert beschraenken
    int b = (getc(fp) & 0xFF);
    if(tiefe>255) {getc(fp);} //auf 8Bit pro Farbwert beschraenken
    wert = (r+g+b+1)/3;
    bild.setpixel(j,i,wert);
   }
 fclose(fp);
 if(!ppmflag) unlink(ppmname);//erstellte ppm-Datei wieder loeschen
 bild.minmaxpixel();
 printf("mingrau=%d maxgrau=%d mittelgrau=%d\n",bild.mingrau,bild.maxgrau,bild.mittelgrau);//test
 pixelfeld_zeichnen();
}

void pixelfeld_zeichnen()
{
 int i,j, grau;
 int nx=bild.nx, ny=bild.ny;
 double dx=1.0/nx, dy=1.0/ny;
 inital_new();
 for(j=shifty; j<shifty+ny; j++)
  {double y1=(ny-1-(j-shifty))*dy, y2=y1+dy;
   for(i=shiftx; i<shiftx+nx; i++)
      {
       if(i<bild.breite && j<bild.hoehe)
	    {grau=bild.getgrau(j,i);}
       else {grau=255;}//weisse Pixel am Rand
       rgbcolor(grau,grau,grau);
       double x1=(i-shiftx)*dx, x2=x1+dx;
       fillbox(x1,y1,x2,y2);
      }
  }
 rgbcolor(0,255,255); drawbox(0, 0, 1.0, 1.0);//blaugruener Rahmen zeichnen
 term_refresh();
}

void m_rechts()
{
 shiftx += bild.nx;
 if(shiftx>=bild.breite) shiftx=bild.breite-bild.nx;
 pixelfeld_zeichnen();
 printf("shiftx=%d shifty=%d\n",shiftx,shifty);//test
}

void m_unten()
{
 shifty += bild.ny;
 if(shifty>=bild.hoehe) shifty=bild.hoehe-bild.ny;
 pixelfeld_zeichnen();
 printf("shiftx=%d shifty=%d\n",shiftx,shifty);//test
}

void m_links()
{
 if(shiftx>=bild.nx) shiftx -= bild.nx; else shiftx=0;
 pixelfeld_zeichnen();
 printf("shiftx=%d shifty=%d\n",shiftx,shifty);//test
}

void m_oben()
{
 if(shifty>=bild.ny) shifty -= bild.ny; else shifty=0;
 pixelfeld_zeichnen();
 printf("shiftx=%d shifty=%d\n",shiftx,shifty);//test
}

void m_refresh()
{
#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss (default ist weiss auf schwarz):
 if(TIEFE==24)
  {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
 else
  {screenclear(1); color(0);}
#endif
 pixelfeld_zeichnen();
}

void m_zoom24x32()
{
 bild.nx = NBR;
 bild.ny = NHO;
 m_refresh();
}

void m_zoomin()
{
 bild.nx /= 2; if(bild.nx<16) bild.nx=16;
 bild.ny /= 2; if(bild.ny<16) bild.ny=16;
 m_refresh();
}

void m_zoomout()
{
 bild.nx *= 2; if(bild.nx>1024) bild.nx=1024;
 bild.ny *= 2; if(bild.ny>1024) bild.ny=1024;
 m_refresh();
}

void m_zoomtotale()
{
 shiftx=0; shifty=0;
 bild.nx = bild.breite;
 bild.ny = bild.hoehe;
 if(bild.ny>bild.nx) bild.nx=bild.ny;
 else if(bild.nx>bild.ny) bild.ny=bild.nx;
 m_refresh();
}

void m_zoomfaktor()
{
 int ok,nx=bild.nx,ny=bild.ny;
 ok=requester_input(2,"Zoomfaktor NX","%d","%d",&nx,
		      "Zoomfaktor NY","%d","%d",&ny);
 if(ok)
  {if(nx>0 && ny>0) {bild.nx=nx; bild.ny=ny;}
   else printf("Eingabefehler: NX und NY muessen groesser 1 sein\n");
  }
 m_refresh();
}

/*
void complement_farbe(int nr) //stark Hardwareabhaengig !
{
 rgbfarbe *p;
 if(nr==0) nr=GRAU2;
 p = &farbpalette[nr];
 setcolor(GRAU2,p->r,p->g,p->b);
}
*/

class Lerndaten {
public:
 int x0,y0,nx,ny,sollwert;
 int iname; //Index fuer lerndatei[]
 Lerndaten() {x0=y0=0; nx=NBR; ny=NHO; sollwert=0; iname=0;}
 void setxysoll(int x,int y,int soll,int xn,int yn) {x0=x; y0=y; sollwert=soll; nx=xn; ny=yn;}
 void getxysoll(int *x,int *y,int *soll,int *xn,int *yn) {*x=x0; *y=y0; *soll=sollwert; *xn=nx; *yn=ny;}
 void setdateiname(int i,const char *name) {strncpy(lerndatei[i],name,200); iname=i;}
 char *getdateiname() {return lerndatei[iname];}
};

static Lerndaten lernliste[1000];//TODO
static int lernliste_jmax=0;

int lerndatei_einlesen() //Rueckgabewert: Anzahl eingelesene Elemente
{
 if(lerndatei[0][0]==0) strcpy(lerndatei[0],"lerndaten.txt");//TODO
 FILE *fp=fopen(lerndatei[0],"r"); //Textdatei mit Name von Bilddatei in 1.Zeile, Koord. und Sollwerte weitere Zeilen
 //ev. noch Parameterzeile: "para: 1" fuer g_modus setzen //TODO: noch weitere Parmeter
 if(fp==NULL) {printf("Datei \"%s\" nicht gefunden\n",lerndatei[0]); return 0;}
 char zeile[200];
 int j=0,x,y,nx,ny,soll,i;
 while(getline(fp,zeile,200))
  {
   if(zeile[0]==';') continue;//Kommentarzeilen ueberlesen
   if(!isdigit(zeile[0]))
    {if(istbilddatei(zeile)) {bild_einlesen(zeile); j=0;}//TODO
     else if(strncmp(zeile,"para:",4)==0) {sscanf(&zeile[5],"%d",&g_modus);}//TODO
     else {printf("Fehler in \"%s\"\n",lerndatei[0]); return 0;}
    }
   else
    {
     sscanf(zeile,"%d %d",&x,&y);
     for(i=1;zeile[i++]!=' ';) {}
     while(zeile[i++]!=' ') {} //2 Leerzeichen ueberlesen
     if(zeile[i]=='\'') soll=zeile[i+1]; else sscanf(&zeile[i],"%d",&soll);
     while(zeile[i]!=0 && zeile[i]!=' ') {i++;}
     if(zeile[i]==0 || sscanf(&zeile[i],"%d %d",&nx,&ny)!=2) {nx=NBR; ny=NHO;}
     lernliste[j++].setxysoll(x,y,soll,nx,ny);
     lernliste_jmax=j;
    }
  }
 fclose(fp);
 return lernliste_jmax;
}

void von_lernliste_einlesen(int soll)
{
 int x,y,soll2,nx,ny;
 if(lernliste_jmax==0) lerndatei_einlesen();
 for(int jlern=0; jlern<lernliste_jmax; jlern++)
  {
   lernliste[jlern].getxysoll(&x,&y,&soll2,&nx,&ny);
   if(soll2==soll) {shifty=y; shiftx=x; bild.nx=nx; bild.ny=ny; return;}
  }
 printf("Fehler: soll=%d nicht in lernliste gefunden\n",soll);
}

#define METHODE_ERSTE    1
#define METHODE_ZUFALL   2
#define METHODE_BACKPROP 3
#define METHODE_ABWECHSL 4

void m_lernen()
{
 int ok;
 static int methode=1;
 double epsilon=Epsilon;
 static int ivarmax=50000;
 int startzufall=0;
 if(lerndatei[0][0]==0) strcpy(lerndatei[0],"lerndaten2.txt");
 //int ok=nachfilenamefragen("Lerndaten",lerndatei,200);
 ok=requester_input(5,"Lerndaten","%s","%s",lerndatei[0],
		    "Epsilon (0.3 bis 0.9)","%f","%f",&Epsilon,
		    "Anzahl Iterationen","%d","%d\n",&ivarmax,
		    "Lernmethode (1=Erstes Lernen, 2=Zufall, 3=Backprop, 4=Abwechseln)","%d","%d",&methode,
		    "Start-Zufallswerte (0=nein, 1=w1, 2=w2, 3=beide)","%d","%d",&startzufall);
 if(ok)
  {
   lerndatei_einlesen();
   Epsilon=epsilon;
   if(methode==METHODE_ERSTE) erstes_anlernen();
   else
    {
     if((startzufall&1)==1) zufall_w1();
     if((startzufall&2)==2) zufall_w2();
     trainieren(ivarmax,methode);
    }
   m_zoomtotale();
  }
 else m_refresh();
}

#define VARIEREN_NEU 1
#define VARIEREN_ZURUECK 2

void neuronen_speichern()
{
#ifndef W1FIXIERT
 for(int i=0;i<=NX;i++)
  for(int k=0;k<=NH;k++)
   w1_bak[i][k] = w1[i][k];
#endif
 for(int j=0;j<NY;j++)
  for(int k=0;k<=NH;k++)
   w2_bak[k][j] = w2[k][j];
}

void neuronen_zurueck()
{
#ifndef W1FIXIERT
 for(int i=0;i<=NX;i++)
  for(int k=0;k<=NH;k++)
   w1[i][k] = w1_bak[i][k];
#endif
 for(int j=0;j<NY;j++)
  for(int k=0;k<=NH;k++)
   w2[k][j] = w2_bak[k][j];
}

double punkte_berechnen()
{
 double summe_punkte=0;
 int x,y,soll;
 for(int j=0;j<lernliste_jmax;j++)
  {
   lernliste[j].getxysoll(&x,&y,&soll,&bild.nx,&bild.ny);
   if(!isletter(soll)) zusaflag=0;
   else zusaflag=g_modus;//TODO
   eingabe_an_neuronen(bild,y,x);
   propagieren();
   zusaflag=g_modus;//TODO
   //Bewertung von Resultat:
   double punkte=0;
   int imax=0; double Ymax=Y[0];
   for(int i=0;i<NOUT;i++)
    if(gelernt[i])
     {
      if(Y[i]>Ymax) {Ymax=Y[i]; imax=i;}
      if(i==soll) {punkte += Y[i];}
      else punkte += (1.0-Y[i]);
     }
   if(imax==soll) punkte += 1000;
   summe_punkte += punkte;
  }
 return summe_punkte;
}

void erstes_anlernen()
{
 printf("erstes_anlernen()\n");//test
 int x,y,soll;
 w1w2ruecksetzen();
 for(int i=0;i<NY;i++) gelerntakt[i]=gelernt[i]=0;
 for(int jlern=0;jlern<lernliste_jmax;jlern++)
  {int nx,ny;
   lernliste[jlern].getxysoll(&x,&y,&soll,&nx,&ny);
   gelerntakt[soll] = gelernt[soll] = 1;
  }
 gelerntakt[ZEOUT]=gelernt[ZEOUT]=1;
 for(int jlern=0;jlern<lernliste_jmax;jlern++)
  {
   lernliste[jlern].getxysoll(&x,&y,&soll,&bild.nx,&bild.ny);
   if(!isletter(soll)) zusaflag=0;
   else zusaflag=g_modus;//TODO
   eingabe_an_neuronen(bild,y,x);
   propagieren();
   zusaflag=g_modus;//TODO
   int j=soll;
   if(argflag['V']) printf("Ausgabe an Sollposition: Y[%d] = %f\n",j,Y[j]);//test
   for(int k=0;k<NH-1;k++) // H[NH-1] ist Zeichenerkennung, hier unberuecksichtigt
    {
     //w2[k][j] = (H[k]>=0.5) ? 1.0 : -1.0;
     w2[k][j] = H[k];
    }
   //if(argflag['V'])
    {propagieren();//test
     printf("    '%c'  nach Lernschritt: Y[%d] = %f\n",isprint(j)?j:' ',j,Y[j]);//test
    }
  }
 double summe_punkte=punkte_berechnen();
 printf("nach erstem Anlernen: summe_punkte = %f\n",summe_punkte);
 //test: nachpruefen
 printf("Gelernte Zeichen nochmals nachpruefen:\n");//test
 if(argflag['V']) htestflag=1;
 int schwach=0,fehler=0;//test
 for(int jlern=0;jlern<lernliste_jmax;jlern++)//test
  {
   lernliste[jlern].getxysoll(&x,&y,&soll,&bild.nx,&bild.ny);
   if(!isletter(soll)) zusaflag=0;
   else zusaflag=g_modus;//TODO
   eingabe_an_neuronen(bild,y,x);
   propagieren();
   zusaflag=g_modus;//TODO
   int j,jmax=0;
   double ymax=0;
   for(j=0;j<NY-1;j++)
    if(gelernt[j])
     {
      if(Y[j]>ymax) {ymax=Y[j]; jmax=j;}
     }
   if(jmax!=soll) {printf("Fehler bei '%c': %d statt %d erkannt\n",soll,jmax,soll); fehler++;}
   j=soll;
   if(Y[j]<0.9) {schwach++; printf("schwacher Wert: Y[%d] = %f\n",j,Y[j]);}//test
  }
 if(schwach==0 && fehler==0) printf("Nachpruefung erfolgreich.\n");//test
 if(fehler!=0) printf("%d Fehler\n",fehler);
 if(schwach!=0) printf("%d schwache Werte\n",schwach);
 htestflag=0;
}

void trainieren(int ivarmax,int methode)
{
 int anz_verbesserungen=0, verb1000=0;
 double best_punkte=punkte_berechnen();
 neuronen_speichern();
 printf("trainieren()\n best_punkte=%f\n",best_punkte);//test
 int test=10,test2=10;//test
 bool abwechseln=(methode==METHODE_ABWECHSL);
 if(ivarmax==0) ivarmax=200000;
 for(int ivar=1;ivar<=ivarmax;ivar++)
  {
   if(methode==METHODE_ZUFALL)
    {
#ifndef W1FIXIERT
     zufallsvarieren_w1();
#endif
     zufallsvarieren_w2();
    }
   else //if(methode==METHODE_BACKPROP)
    {
     static double summe_vjmalw2kj[NH+1][NY-1];//fuer w1-backprop
     for(int jlern=0;jlern<lernliste_jmax;jlern++)
      {
       int x,y,soll;
       lernliste[jlern].getxysoll(&x,&y,&soll,&bild.nx,&bild.ny);
       if(!isletter(soll)) zusaflag=0;
       else zusaflag=g_modus;//TODO
       eingabe_an_neuronen(bild,y,x);
       propagieren();
       zusaflag=g_modus;//TODO
       for(int j=0;j<NY-1;j++)
	for(int k=0;k<=NH;k++) summe_vjmalw2kj[k][j]=0;
       for(int j=0;j<NY-1;j++)
	if(gelernt[j])
	 {
	  //double Dj = (j==soll) ? 1.0 : 0.0;//Sollwert
	  double Dj = (j==soll) ? 0.99 : 0.01;//Sollwert TODO: Realistischere Sollwerte?
	  double Yj=Y[j];
	  double vj=Epsilon*(Dj-Yj)*Yj*(1.0-Yj); // Lernformel von Seite 84
	  for(int k=0;k<=NH;k++)
	   {
	    summe_vjmalw2kj[k][j] += vj*w2[k][j];
	    w2[k][j] += vj*H[k];
	   }
	 }
#ifndef W1FIXIERT
       //jetzt noch w1 backprop:
       for(int j=0;j<NY-1;j++)
	if(gelernt[j])
	 {
	  for(int k=0;k<=NH;k++)
	   {//Formel Seite 85, Epsilon schon in summe_.. enthalten
	    double Hk = H[k];
	    double sigmak = summe_vjmalw2kj[k][j]*Hk*(1.0-Hk);
	    for(int i=0;i<=NX;i++)
	     {
	      w1[i][k] += sigmak*X[i];
	     }
	   }//Ende k-Schlaufe
	 }//Ende j-Schlaufe
#endif
      }//Ende jlern-Schlaufe
    }
   double summe_punkte=punkte_berechnen();
   if(test!=0 && fastgleich(summe_punkte,best_punkte,0.1))
    {
     --test;
     if(summe_punkte != best_punkte) printf("fast");
     printf("gleich: summe=%f best=%f\n",summe_punkte,best_punkte);//test
    }
   if(summe_punkte < best_punkte)
    {
     if(test2)
      {--test2; printf("summe=%f best=%f neuronen_zurueck()\n",summe_punkte,best_punkte);}//test
     neuronen_zurueck();
    }
   else if(summe_punkte > best_punkte+0.0001)
    {
     if(summe_punkte>best_punkte+0.1) printf("ivar=%d summe_punkte = %f\n",ivar,summe_punkte);//test
     best_punkte = summe_punkte;
     neuronen_speichern();
     anz_verbesserungen++; verb1000++;
    }
   if(ivar%1000==0)
    {
     if(verb1000==0) //wenn keine weitere Verbesserung letzte 1000 Durchgaenge
	{Epsilon = zufall4()+0.1; //Zufallswert zwischen 0.1 und 1.1
	 printf("Epsilon = %f\n",Epsilon);//test
	 if(abwechseln) methode = (methode==METHODE_BACKPROP) ? METHODE_ZUFALL : METHODE_BACKPROP;
	}
     verb1000=0;
     if(ivar%10000==0)
      {
       printf("ivar=%d anz_verbesserungen=%d\n",ivar,anz_verbesserungen);//test
       if(anz_verbesserungen==0) break;//Abbrechen wenn keine weitere Verbesserung
       anz_verbesserungen=0;
      }
    }
  }//Ende ivar-Schlaufe
 Epsilon=0.3; //wieder auf Standardwert setzen
 printf("Trainieren fertig\n best_punkte = %f\n",best_punkte);//test
}

static int mausmodus=0;
double maus_x1=0, maus_y1=0, maus_x2=0, maus_y2=0;

void mydrawmode(int mode)
{
 if(mode==COMPLEMENT)
   {//complement_farbe(PURPUR);
    rgbcolor(255, 0, 255);//Purpur
    drawmode(mode);
   }
 else
   {drawmode(mode);//wieder normaler Zeichnungsmodus
    //complement_farbe(0);
    rgbcolor(128,128,128);//Grau
   }
}

void m_position()
{
 int ok,sx=shiftx,sy=shifty,nx=bild.nx,ny=bild.ny;
 ok=requester_input(4,"Position X","%d","%d",&sx,
		    "Position Y","%d","%d\n",&sy,
		    "Zoomfaktor NX","%d","%d",&nx,
		    "Zoomfaktor NY","%d","%d",&ny);
 if(ok)
  {if(sx>=0 && sy>=0 && nx>0 && ny>0)
    {shiftx=sx; shifty=sy; bild.nx=nx; bild.ny=ny;}
   else printf("Eingabefehler: alle Parameter sollten groesser 0 sein\n");
  }
 m_refresh();
}

#define WEISS_OBEN  0x01
#define WEISS_UNTEN 0x02
#define WEISS_LINKS 0x04
#define WEISS_RECHTS 0x08
#define WEISS_GESAMTER_RAND 0x0F
#define WEISS_LINKS_RECHTS 0x0C

void schwelle_weiss_setzen(int k)
{
 int x0=shiftx, y0=shifty, nx=bild.nx, ny=bild.ny;
 if(nx<k) {x0 -= (k-nx)/2; nx=k;}
 if(ny<k) {y0 -= (k-ny)/2; ny=k;}
 bild.ausschnitt_schwelle3(x0,y0,nx,ny);
}

int rand_weisstest(Bild& bild)
{
 if(schwelle_weiss==0) schwelle_weiss_setzen(16);
 int schwelle=schwelle_weiss;
 int jmax=bild.ny, imax=bild.nx;
 int flags=WEISS_GESAMTER_RAND;
 for(int j=0;j<jmax;j++)
  {if(bild.getgrau(shifty+j, shiftx) < schwelle) flags &= ~(WEISS_LINKS);
   if(bild.getgrau(shifty+j, shiftx+imax-1) < schwelle) flags &= ~(WEISS_RECHTS);
  }
 for(int i=0;i<imax;i++)
  {if(bild.getgrau(shifty, shiftx+i) < schwelle) flags &= ~(WEISS_OBEN);
   if(bild.getgrau(shifty+jmax-1, shiftx+i) < schwelle) flags &= ~(WEISS_UNTEN);
  }
 return flags;
}

static double g_ypos=g_ymax;

void teilbild_rechts_zeichnen(Bild& bi,int nx,int ny,int x0,int y0,double ypos0=0)
{
 if(ypos0!=0) g_ypos=ypos0;
 double ho=(g_ymax-g_ymin)/4, br=ho*nx/ny; //Werte zum Teilbild zeichnen
 teilbild_zeichnen(g_xmax-br, g_ypos-ho, g_xmax, g_ypos, bi, nx, ny, x0, y0);
 rgbcolor(0,255,0); drawbox(g_xmax-br, g_ypos-ho, g_xmax, g_ypos);//gruene Umrandung
 g_ypos -= ho; if(g_ypos<=g_ymin) g_ypos=g_ymax;
}

void  neuronen_rechts_zeichnen(double *z,int imax,int jmax)
{
 printf("neuronen_rechts_zeichnen(z, imax=%d, jmax=%d)  g_ypos=%f\n",imax,jmax,g_ypos);//test
 double ho=(g_ymax-g_ymin)/4, br=ho*NBR/NHO; //Werte zum Teilbild zeichnen
 double xmi=g_xmax-br, ymi=g_ypos-ho, xma=g_xmax, yma=g_ypos;
 double dx=(xma-xmi)/imax, dy=(yma-ymi)/jmax;
 inital_new();
 for(int j=0;j<jmax;j++)
  {double y2=yma-j*dy, y1=y2-dy;
   for(int i=0;i<imax;i++)
    {double x1=i*dx+xmi, x2=x1+dx;
     int grau=(1.0-z[j*imax+i])*255;
     if(grau==255) rgbcolor(180,200,255); else rgbcolor(grau,grau,grau);
     fillbox(x1,y1,x2,y2);
    }
  }
 rgbcolor(0,0,255); drawbox(xmi,ymi,xma,yma);//dunkelblaue Umrandung
 term_refresh();
 g_ypos -= ho; if(g_ypos<=g_ymin) g_ypos=g_ymax;
}

int naechster_dunkler_pixel_suchen(int& x0,int& y0,int schwelle)
{
 for(int dd=1; dd<8; dd++)
  {
   for(int i= -dd; i<dd; i++)
    for(int j= -dd; j<dd; j++)
     if(i!=0 || j!=0)
      {int x1=x0+i;
       int y1=y0+j;
       if(x1>0 && y1>0 && x1<bild.breite && y1<bild.hoehe)
	{
	 int grau=bild.getgrau(y1,x1);
	 if(grau<schwelle) {x0=x1; y0=y1; return grau;}
	}
      }
  }
 int grau=bild.getgrau(y0,x0);
 return grau;
}

static uchar hfeld[128][128]; //0=undef, 1=schwarz, 2=weiss, 3=ausserhalb Bild

void zusasuche(int x0,int y0,int i0,int j0) //Zusammenhaengender dunkler Bereich suchen
{//Rekursive Funktion
 int imin = (i0>0) ? i0-1 : i0;
 int jmin = (j0>0) ? j0-1 : j0;
 int imax = (i0<127) ? i0+1 : i0;
 int jmax = (j0<127) ? j0+1 : j0;
 for(int i=imin;i<=imax;i++)
  for(int j=jmin;j<=jmax;j++)
   if(hfeld[i][j]==0)
    {
     int x1=x0+i-i0, y1=y0+j-j0;
     if(x1>=0 && y1>=0 && x1<bild.breite && y1<bild.hoehe)
      {
       if(bild.getgrau(y1,x1) < schwelle_weiss)
	{hfeld[i][j]=1;
	 //printf("i=%d j=%d bild.getgrau(%d,%d) --> %d\n",i,j,y1,x1,bild.getgrau(y1,x1));//test
	 zusasuche(x1,y1,i,j);
	}
       else {hfeld[i][j]=2;}
      }
     else {hfeld[i][j]=3;}//ausserhalb Bildbereich
    }
}

void zeichen_erkennung_von_mitte(int x0,int y0,int zeichnenflag)
{  //Rueckgabewerte: shiftx, shifty, bild.nx, bild.ny
 if(argflag['V']) printf("zeichen_erkennung_von_mitte(%d,%d,%d)\n",x0,y0,zeichnenflag);//test
 for(int i=0;i<128;i++)
  for(int j=0;j<128;j++)
   hfeld[i][j]=0;
 //int schwelle=g_schwelle_schwarz;//TODO: so geht es meistens
 int schwelle=g_schwelle_schwarz-schwelldiff;//TODO
 if(argflag['V'])
  printf(" schwelle=%d (schwelle_schwarz=%d g_schwelle_schwarz=%d\n",schwelle,schwelle_schwarz,g_schwelle_schwarz);//test
 if(schwelle==0) {printf("Fehler: schwelle_schwarz noch nicht gesetzt\n"); return;}//test
 int grau=bild.getgrau(y0,x0);
 if(grau >= schwelle) grau=naechster_dunkler_pixel_suchen(x0,y0,schwelle);
 if(grau >= schwelle)
  {printf("Fehler: kein dunkler Pixel nahe %d %d gefunden\n",x0,y0); return;}//test
 hfeld[64][64]=1;
 //printf("Startpunkt fuer zusasuche(): x0=%d y0=%d\n",x0,y0);//test
 zusasuche(x0,y0,64,64); //Zusammenhaengender dunkler Bereich suchen
 int imin=128,imax=0,jmin=128,jmax=0;
 for(int j=0;j<128;j++)
  for(int i=0;i<128;i++)
   if(hfeld[i][j]==1)
    {if(i<imin) imin=i;
     if(i>imax) imax=i;
     if(j<jmin) jmin=j;
     if(j>jmax) jmax=j;
    }
 //printf("imin=%d imax=%d jmin=%d jmax=%d\n",imin,imax,jmin,jmax);//test
 /* test: * /
 for(int j=jmin-1;j<=jmax+1;j++)
  {for(int i=imin-1;i<=imax+1;i++)
     printf("%d",hfeld[i][j]);//test
   printf(" ");//test
   for(int i=imin-1;i<=imax+1;i++)
    {int grau=bild.getgrau(y0+j-64,x0+i-64); printf("%4d",grau);}//test
   printf("\n");//test
  }
 / * */
 
 int breite=imax-imin+3;
 int hoehe=jmax-jmin+3;
 x0 += imin-65; if(x0<0) {breite+=x0; x0=0;}
 y0 += jmin-65; if(y0<0) {hoehe+=y0; y0=0;}
 if(x0+breite>bild.breite) breite=bild.breite-x0;
 if(y0+hoehe>bild.hoehe) hoehe=bild.hoehe-y0;
 shiftx=x0; shifty=y0; bild.nx=breite; bild.ny=hoehe;//Rueckgabewerte
 
 if(g_modus==DRUCKTEXT)
  {
   if(argflag['V']) printf("anpassen: shifty=%d bild.ny=%d\n",shifty,bild.ny);//test
   int flag = dru_starty_hoehe_anpassen(shifty,bild.ny);
   if(argflag['V'])
    {printf("angepasst: shifty=%d bild.ny=%d\n",shifty,bild.ny);//test
     if(!flag) printf("nichts veraendert\n");//test
    }
  }
 else
  {
   double verhaeltnis=bild.ny/double(bild.nx);
   const double vsoll=NHO/double(NBR);
   if(verhaeltnis < vsoll-0.1) //wenn zu breit
    {int dy = NHO*bild.nx/NBR-bild.ny;
     shifty -= dy; if(shifty<0) shifty=0;
     bild.ny += dy; if(bild.ny+shifty > bild.hoehe) bild.ny=bild.hoehe-shifty;
    }
   else if(verhaeltnis > vsoll+0.5 && shiftx>1 && shiftx+bild.nx<bild.breite-1)
    {//wenn viel hoeher als breit und links und rechts genug platz:
     shiftx--; bild.nx+=2; //um 2 Pixel breiter machen
     if((rand_weisstest(bild) & WEISS_LINKS_RECHTS)!=WEISS_LINKS_RECHTS) //wenn zugefuegter Rand nicht weiss
      {shiftx++; bild.nx-=2;} //dann zuruecknehmen
    }
  }
 Bild bi,teilbild;
 //printf("Testpunkt2: shiftx=%d shifty=%d bild.nx=%d bild.ny=%d\n",shiftx,shifty,bild.nx,bild.ny);//test
 teilbild_kopieren(shiftx, shifty, bild.nx, bild.ny, bild, bi);
 if(zeichnenflag) teilbild_rechts_zeichnen(bi, bi.nx, bi.ny, 0, 0, g_ymax);
 umrechnung_nxm_nach_24x32_randweiss(bi,teilbild);
 if(zeichnenflag) teilbild_rechts_zeichnen(teilbild, teilbild.nx, teilbild.ny, 0, 0);
 eingabe_an_neuronen(teilbild,0,0,zeichnenflag);//TODO
 if(argflag['V']) printf("Ende von zeichen_erkennung_von_mitte()\n");//test 
}

void m_lernpos()
{
 static char name[200];
 static int startflag=1;
 char zeichen[80]; zeichen[0]=0;
 bool klicklern = (bild.nx<NBR && bild.ny<NHO); //mit einzelnem Klick lernen
 if(klicklern)
  {printf("Testpunkt klicklern: bild.nx=%d bild.ny=%d\n",bild.nx,bild.ny);//test
   if(schwelle_weiss==0 || schwelle_schwarz==0) schwelle_weiss_setzen(64);//TODO
   printf("schwelle_weiss=%d schwelle_schwarz=%d\n",schwelle_weiss,schwelle_schwarz);//test
   //dru_hoehe=0;//TODO
   zeichen_erkennung_von_mitte(shiftx,shifty);
  }
 int ok;
 if(startflag) {strcpy(name,"lerndaten_neu.txt"); startflag=0;}
 do {
  if(klicklern)
   {int nx=bild.nx, ny=bild.ny, x0=shiftx, y0=shifty;
    for(;;)
     {ok=requester_input(6,"Dateiname (Textdatei)","%s","%s",name,
			 "Zeichen","%s","%s",zeichen,
			 "bild.nx","%d","%d",&nx,
			 "bild.ny","%d","%d",&ny,
			 "shiftx","%d","%d",&x0,
			 "shifty","%d","%d",&y0);//TODO
      if(!ok) break;
      if(nx!=bild.nx || ny!=bild.ny || x0!=shiftx || y0!=shifty)
       {bild.nx=nx; bild.ny=ny; shiftx=x0; shifty=y0;
	printf("starte teilbild_rechts_zeichnen()\n");//test
	teilbild_rechts_zeichnen(bild, nx, ny, x0, y0, g_ymax);
	int zusaflag_vorher=zusaflag;
	int c=zeichen[0]; if(c!=0 && !isletter(c)) zusaflag=0;
	else zusaflag=g_modus;//TODO
	int zflag=2; eingabe_an_neuronen(bild,y0,x0,zflag);//TODO
	zusaflag=zusaflag_vorher;
       }
      else break;
     }
   }
  else
   {char antw[80]; strcpy(antw,"nein");
    ok=requester_input(3,"Dateiname (Textdatei)","%s","%s",name,
		       "Zeichen","%s","%s",zeichen,
		       "Rahmen groesser","%s","%s",antw);
    if(ok && antw[0]!='n' && antw[0]!='N')
     {if(shiftx>0) {shiftx--; bild.nx++;}
      if(shifty>0) {shifty--; bild.ny++;}
      if(shiftx+bild.nx<bild.breite) bild.nx++;
      if(shifty+bild.ny<bild.hoehe) bild.ny++;
      zeichen[0]=0; klicklern=true;
     }
   }
 } while(ok && zeichen[0]==0);
 if(ok)
  {
   FILE *fp=fopen(name,"a");
   if(fp==NULL) {printf("konnte \"%s\" nicht oeffnen\n",name); return;}
    fprintf(fp,"%d %d '%c' %d %d\n",shiftx,shifty,zeichen[0],bild.nx,bild.ny);
    fclose(fp);
   }
}

void test_grauwert_pixel(double x,double y)
{
 printf("Pixel an Position %f %f:\n",x,y);//test
 int i = shiftx+int((x-g_xmin)*bild.nx);
 int j = shifty+int((g_ymax-y)*bild.ny);
 printf(" i=%d j=%d\n",i,j);//test
 int grau=bild.getgrau(j,i);
 printf(" grau=%d\n",grau);
}

void maus_gedrueckt()
{
 double x,y; //dy,rand;
 int taste=mausposition(&x,&y);
 if(argflag['V']) test_grauwert_pixel(x,y);
 if(taste==LIMAUS)
  {
   mausmodus=1; maus_x1=x; maus_y1=y;
   mydrawmode(COMPLEMENT);
  }
 else if(taste==REMAUS)
  {
   mausmodus=2; maus_x1=x; maus_y1=y;
  }
 else if(taste==SCROLL_UP)
  {
   if(shifty>=32) shifty -= 32; else shifty=0;
   m_refresh();
  }
 else if(taste==SCROLL_DOWN || taste==6144) //TODO
  {
   if(shifty+32<bild.hoehe-bild.ny) shifty += 32; else shifty=bild.hoehe-bild.ny;
   m_refresh();
  }
 else
  {
   printf("maus_gedrueckt() taste=%d x=%lf y=%lf\n",taste,x,y);//test
  }
}

void maus_bewegung()
{
 double x,y;
 //int taste=
 mausposition(&x,&y);
 //printf("maus_bewegung() tasten=%d x=%f y=%f\n",taste,x,y); //test
 if(mausmodus==1 && x!=maus_x1 && y!=maus_y1)
  {
   /*
   printf("maus_bewegung() taste=%d\n",taste);//test
   if(taste==LIMAUS) printf("LIMAUS\n");//test
   if(taste==REMAUS) printf("REMAUS\n");//test
   if(taste==MIMAUS) printf("MIMAUS\n");//test
   */
   if(maus_x2!=0 && maus_y2!=0)
    {
     drawbox(maus_x1,maus_y1,maus_x2,maus_y2); //altes Fadenkreuz loeschen
    }
   maus_x2=x; maus_y2=y;
   drawbox(maus_x1,maus_y1,maus_x2,maus_y2); //neues Fadenkreuz zeichnen
  }
 else if(mausmodus==2 && x!=maus_x1 && y!=maus_y1)
  {
   maus_x2=x; maus_y2=y;
   int dx=idfix((maus_x1-maus_x2)*bild.nx); 
   int dy=idfix((maus_y2-maus_y1)*bild.ny);
   if(dx!=0 || dy!=0)
    {
     shiftx += dx; if(shiftx<0) shiftx=0;
     shifty += dy; if(shifty<0) shifty=0;
     maus_x1=maus_x2; maus_y1=maus_y2;
     m_refresh();
    }
  }
}

void maus_losgelassen()
{
 double x,y;
 mausposition(&x,&y);
 if(mausmodus==1)
  {
   if(maus_x2!=0 && maus_y2!=0)
    {
     drawbox(maus_x1,maus_y1,maus_x2,maus_y2); //altes Fadenkreuz loeschen
    }
   maus_x2=x; maus_y2=y;
   if(argflag['V']) printf("x1=%f y1=%f x2=%f y2=%f\n",maus_x1,maus_y1,maus_x2,maus_y2);//test
   int dy = idfix((1.0-maus_y1)*bild.ny);
   int dx = idfix((maus_x1)*bild.nx);
   if(fastgleich(maus_x1,maus_x2) && fastgleich(maus_y1,maus_y2))
    {
     mausmodus=0; mydrawmode(JAM1);//wieder normaler Zeichnungsmodus
     int shiftx_alt=shiftx, shifty_alt=shifty;
     int nx_alt=bild.nx, ny_alt=bild.ny;
     shifty += dy-4; if(shifty<0) shifty=0;
     shiftx += dx-4; if(shiftx<0) shiftx=0;
     bild.nx=bild.ny=8;
     m_lernpos();
     shiftx=shiftx_alt; shifty=shifty_alt;
     bild.nx=nx_alt; bild.ny=ny_alt;
    }
   else
    {
     //Position auf maux_x1,maus_y1 setzen und Skalierung anpassen:
     //werte in inital(): double xmin= -0.125,ymin=0.,xmax=1.125,ymax=1.;
     if(maus_x1>maus_x2) {double h=maus_x1; maus_x1=maus_x2; maus_x2=h;}
     if(maus_y1<maus_y2) {double h=maus_y1; maus_y1=maus_y2; maus_y2=h;}
     shifty += dy; shiftx += dx; //Position anpassen
     //jetzt noch Skalierung:
     double sy = maus_y2-maus_y1; if(sy<0) sy = -sy;
     double sx = maus_x2-maus_x1; if(sx<0) sx = -sx;
     if(sx==0) sx=sy;
     if(sy!=0)
      {double h=sx/sy; //wenn beide Faktoren fast gleich
       if(h<1.5 && h>0.75) sx=sy=(sx+sy)/2; //dann beide auf gleichen Wert setzen (Mittelwert)
       bild.nx *= sx; if(bild.nx<16) bild.nx=16;
       bild.ny *= sy; if(bild.ny<16) bild.ny=16;
      }
     mydrawmode(JAM1);//wieder normaler Zeichnungsmodus
    }
   mausmodus=0; maus_x1=maus_y1=0; maus_x2=maus_y2=0;
   m_refresh();
  }
 else if(mausmodus==2)
  {
   maus_x2=x; maus_y2=y;
   int dx=idfix((maus_x1-maus_x2)*bild.nx); 
   int dy=idfix((maus_y2-maus_y1)*bild.ny); 
   shiftx += dx; if(shiftx<0) shiftx=0;
   shifty += dy; if(shifty<0) shifty=0;
   mausmodus=0; maus_x1=maus_y1=0; maus_x2=maus_y2=0;
   m_refresh();
  }
 else
  {
   if(argflag['V']) printf("maus_losgelassen() x=%f y=%f\n",x,y); //test
  }
}

void vergroessern_mit_interpolation(Bild &bi)
{
 if(bi.breite<2 || bi.hoehe<2) {fprintf(stderr,"Error: vergroessern_mit_interpolation()\n"); exit(1);}
 int Nalt=bi.breite, Malt=bi.hoehe;
 int N=2*Nalt-1, M=2*Malt-1;
 Bild bineu(N,M);
 for(int x=0;x<Nalt;x++)
  for(int y=0;y<Malt;y++)
   {int grau=bi.getgrau(y,x);
    bineu.setgrau(y*2,x*2,grau);
   }
 for(int x=1;x<N-1;x+=2)
  for(int y=0;y<M;y+=2)
   {
    int grau = (bineu.getgrau(y,x-1) + bineu.getgrau(y,x+1))/2;
    bineu.setgrau(y,x,grau); //neue x-Werte interpolieren
   }
 for(int x=0;x<N;x++)
  for(int y=1;y<M;y+=2)
   {
    int grau = (bineu.getgrau(y-1,x) + bineu.getgrau(y+1,x))/2;
    bineu.setgrau(y,x,grau); //neue y-Werte interpolieren
   }
 delete[] bi.data;
 bi.data = bineu.data; bineu.data=NULL;
 bi.nx = bi.breite = bineu.breite;
 bi.ny = bi.hoehe = bineu.hoehe;
}

void umrechnung_nxm_nach_24x32(Bild &quelle,Bild &ziel)
{
 while(quelle.breite<NBR || quelle.hoehe<NHO) vergroessern_mit_interpolation(quelle);
 int N=quelle.breite, M=quelle.hoehe;
 ziel.init(NBR,NHO);
 for(int x=0; x<ziel.breite; x++)
  for(int y=0; y<ziel.hoehe; y++)
   {
    int i1=N*x/NBR,     j1=M*y/NHO;
    int i2=N*(x+1)/NBR, j2=M*(y+1)/NHO;
    int summe=0, n=0;
    for(int i=i1;i<i2;i++)
     for(int j=j1;j<j2;j++)
      {
       summe += quelle.getgrau(j,i);
       n++;
      }
    int grau = summe/n;
    ziel.setgrau(y,x,grau);
   }
}

void umrechnung_nxm_nach_24x32_randweiss(Bild &quelle,Bild &ziel)
{
 while(quelle.breite<NBR || quelle.hoehe<NHO) vergroessern_mit_interpolation(quelle);
 int N=quelle.breite, M=quelle.hoehe;
 double verhaeltnis = M/double(N);
 const double vsoll=NHO/double(NBR);
 if(fastgleich(verhaeltnis,vsoll,0.1)) {umrechnung_nxm_nach_24x32(quelle,ziel); return;}
 //printf("umrechnung_nxm_nach_24x32_randweiss() N=%d M=%d\n",N,M);//test
 Bild bi;
 //if(N<M)
 if(verhaeltnis > vsoll)
  {int dx2 = NBR*M/NHO-N;
   int Nneu = N+dx2;
   bi.init(Nneu,M);
   int xrand=dx2/2, xrand2=xrand+N;
   //printf("xrand=%d xrand2=%d\n",xrand,xrand2);//test
   for(int y=0; y<M; y++)
    for(int x=0; x<Nneu; x++)
     {
      if(x<xrand || x>=xrand2) bi.setgrau(y,x,255);//Rand auf weiss setzen
      else
       {
	int grau = quelle.getgrau(y,x-xrand);
	bi.setgrau(y,x,grau);
       }
     }
  }
 else //if(verhaeltnis < vsoll) //if(M<N)
  {int dy2 = NHO*N/NBR-M;
   int Mneu = M+dy2;
   int yrand=dy2/2, yrand2=yrand+M;
   bi.init(N,Mneu);
   for(int y=0; y<Mneu; y++)
    for(int x=0; x<N; x++)
     {
      if(y<yrand || y>=yrand2) bi.setgrau(y,x,255);//Rand auf weiss setzen
      else
       {
	int grau = quelle.getgrau(y-yrand,x);
	bi.setgrau(y,x,grau);
       }
     }
  }
 umrechnung_nxm_nach_24x32(bi,ziel);
}

void zusasuche(Bild& bil,Bild& hbild,int x0,int y0,int i0,int j0)
{//Zusammenhaengender dunkler Bereich suchen (Rekursive Funktion)
 int imin = (i0>0) ? i0-1 : i0;
 int jmin = (j0>0) ? j0-1 : j0;
 int imax = (i0<127) ? i0+1 : i0;
 int jmax = (j0<127) ? j0+1 : j0;
 for(int i=imin;i<=imax;i++)
  for(int j=jmin;j<=jmax;j++)
   if(hbild.getgrau(j,i)==0) //Punkt noch nicht gesetzt?
    {
     int x1=x0+i-i0, y1=y0+j-j0;
     if(x1>=0 && y1>=0 && x1<bil.breite && y1<bil.hoehe)
      {
       if(bil.getgrau(y1,x1) < schwelle_weiss)
	{hbild.setgrau(j,i,1); //dunkle Punkte mit 1 markieren
	 //printf("i=%d j=%d bil.getgrau(%d,%d) --> %d\n",i,j,y1,x1,bil.getgrau(y1,x1));//test
	 zusasuche(bil,hbild,x1,y1,i,j);
	}
       else {hbild.setgrau(j,i,2);} //Grenze mit 2 markieren
      }
     else {hbild.setgrau(j,i,3);}//ausserhalb Bildbereich auch Grenze markieren (mit 3)
    }
}

void abbildung(Bild& bild2,int i0,int j0,int br,int ho, Bild& bild1,int x0,int y0)
{
 // Abbildung von bild1 nach bild2 machen. Leere Punkte in bild2 auf Weiss setzen.
 // Bereich in bild1 von x0,y0 mit Breite br und Hoehe ho auf bild2 von i0,j0 abbilden.
 for(int i=0;i<br;i++)
  for(int j=0;j<ho;j++)
   {
    int g2=bild2.getgrau(j0+j,i0+i);
    if(g2==0) g2=255;//Leere Punkte auf Weiss setzen
    else g2=bild1.getgrau(y0+j,x0+i);
    bild2.setgrau(j0+j,i0+i,g2);
   }
}

void test_bild_als_text(Bild& bil,int x0,int y0,int nx,int ny)
{
 if(nx>32) nx=32;
 if(ny>32) ny=32;
 for(int j=y0;j<y0+ny;j++)
  {for(int i=x0;i<x0+nx;i++)
    {int grau=bil.getgrau(j,i); printf("%4d",grau);}
   printf("\n");
  }
}

void test_bilder_als_text(Bild& b1,Bild& b2,int imin,int jmin,int imax,int jmax,int x0,int y0)
{
 for(int j=jmin;j<jmax;j++)
  {for(int i=imin;i<imax;i++)
    {printf("%d ",b1.getgrau(j,i));}
   printf(" ");
   for(int i=imin;i<imax;i++)
    {int grau=b2.getgrau(y0+j-64,x0+i-64); printf("%3d",grau/10);}
   printf("\n");
  }
}

void nach_NBRxNHO_umwandeln(int i0,int j0,Bild& hbild,Bild& teilbild,int zflag)
{
 double ho=0,br=0,ypos=0;
 if(zflag) {ho=(g_ymax-g_ymin)/4; br=ho; ypos=g_ymax;} //Werte zum Teilbild zeichnen
 if(hbild.nx==NHO && hbild.ny==NBR)
  {
   teilbild_kopieren(i0, j0, hbild.nx, hbild.ny, hbild, teilbild);
   if(zflag>=2 && argflag['V'])
    printf("%dx%d teilbild_zeichnen(.. ypos-ho=%f ..)\n",teilbild.nx,teilbild.ny,ypos-ho);//test
   if(zflag>=2) teilbild_zeichnen(g_xmin, ypos-ho, g_xmin+br, ypos, teilbild);
  }
 else
  {
   Bild bi;
   teilbild_kopieren(i0, j0, hbild.nx, hbild.ny, hbild, bi);
   if(zflag>=2 && argflag['V']) printf("teilbild_zeichnen(.. ypos-ho=%f ..)\n",ypos-ho);//test
   if(zflag>=2) {teilbild_zeichnen(g_xmin, ypos-ho, g_xmin+br, ypos, bi); ypos -= ho+ho/NHO;}
   umrechnung_nxm_nach_24x32_randweiss(bi,teilbild);
   if(zflag && argflag['V']) printf("%dx%d teilbild_zeichnen(.. ypos-ho=%f ..)\n",NBR,NHO,ypos-ho);//test
   if(zflag) {teilbild_zeichnen(g_xmin, ypos-ho, g_xmin+br, ypos, teilbild); ypos -= ho+ho/NHO;}
  }
}

void eingabe_an_neuronen(Bild& bil,int j0,int i0,int zflag) //wenn zflag gesetzt: Teilbild zeichnen
{
 Bild teilbild;
 if(zflag && argflag['V']) printf("eingabe_an_neuronen(Bild& bil, j0=%d, i0=%d, zflag=%d)\n",j0,i0,zflag);//test
 if(zusaflag)
  {//einschraenken auf zusammenhaengender Teil:
   Bild hbild(128,128);
   int x0=i0, y0=j0, nx=bil.nx, ny=bil.ny;
   int y2=y0+ny, y1=y0+ny/2; if(y2-y1<bu_hoehe/2) y1=y0;
   int x1=x0, x2=x0+nx;
   //printf("nx=%d ny=%d\n",nx,ny);//test
   //test_bild_als_text(bil,x0,y0,nx,ny);//test
   bil.ausschnitt_schwelle3(x0,y0,nx,ny); //schwelle_schwarz und schwelle_weiss setzen
   int schwelle=schwelle_schwarz;
   //printf("schwelle_schwarz=%d schwelle_weiss=%d\n",schwelle_schwarz,schwelle_weiss);//test
   for(x0=x1; (y0=dunkler_pixel_in_linie(bil,x0,y2,y1,schwelle))== -1 && x0<x2; x0++) {}
   if(x0==x2) {printf("Fehler in eingabe.._neu(): kein dunkler Pixel in unterm Teil gefunden\n"); return;}
   //printf("Startpunkt fuer zusasuche(): x0=%d y0=%d\n",x0,y0);//test
   for(int j=0;j<128;j++)
    for(int i=0;i<128;i++)
     hbild.setgrau(j,i,0); //gesamtes hbild auf 0 setzen
   hbild.setgrau(64,64,1); //Startpunkt auf 1 setzen
   //Zusammenhaengender dunkler Bereich suchen und in hbild auf 1 setzen:
   zusasuche(bil,hbild,x0,y0,64,64);
   //Grenzen in hbild suchen:
   int imin=128,imax=0,jmin=128,jmax=0;
   for(int j=0;j<128;j++)
    for(int i=0;i<128;i++)
     if(hbild.getgrau(j,i)!=0)
      {if(i<imin) imin=i;
       if(i>imax) imax=i;
       if(j<jmin) jmin=j;
       if(j>jmax) jmax=j;
      }
   //printf("imin=%d imax=%d jmin=%d jmax=%d\n",imin,imax,jmin,jmax);//test
   //test_bilder_als_text(hbild,bil,imin-1,jmin-1,imax+2,jmax+2,x0,y0);//test
   
   // Punkte in hbild mit 1, 2 und 3 markiert auf Grauwerte von bil setzen,
   // und restliche Punkte auf weiss setzen:
   int breite=imax+1-imin, hoehe=jmax+1-jmin;
   abbildung(hbild,imin,jmin,breite,hoehe, bil, x0+imin-64, y0+jmin-64);
   //bil wird jetzt nicht mehr gebraucht, mit hbild weitermachen:
   i0=imin; j0=jmin; //Offset in hbild
   hbild.nx = breite;
   hbild.ny = hoehe;
   //test_bild_als_text(hbild,i0,j0,breite,hoehe);//test
   nach_NBRxNHO_umwandeln(i0,j0,hbild,teilbild,zflag);
  }
 else
  {//wenn zusaflag nicht gesetzt:
   nach_NBRxNHO_umwandeln(i0,j0,bil,teilbild,zflag);
  }
 
 int mingrau=0, maxgrau=255;
 for(int j=0,n=0;j<NHO;j++)
  for(int i=0;i<NBR;i++)
    {
     int grau = teilbild.getgrau(j,i); //j=Zeile, i=Spalte, Grauwert 0=schwarz 255=weiss
     if(grau<mingrau) mingrau=grau;
     if(grau>maxgrau) maxgrau=grau;
     X[n++] = grau;
    }
 if(maxgrau<=mingrau) maxgrau=mingrau+1;//wenn alle Pixel gleich: Fehler vermeiden
 int diff=maxgrau-mingrau;
 
#ifdef EINGABE_GRAUWERTE
 for(int i=0; i<(NHO*NBR); i++)
  {X[i] = 1.0 - (X[i]*diff/255+mingrau)/255.0;} //1.0 fuer schwarz, 0.0 fuer weiss
#else
 #ifdef EINGABE_SCHWARZWEISS //Werte auf 0.0 (helle) oder 1.0 (dunkle Pixel) setzen
 double mittleres_grau = (g_schwelle_schwarz+g_schwelle_weiss)/(2*255.0);
 for(int i=0; i<(NHO*NBR); i++)
   {X[i] = (X[i] > mittleres_grau) ? 0.0 : 1.0;} //helle Pixel auf 0.0, dunkle Pixel auf 1.0 setzen
 #endif
 #ifdef EINGABE_TRIPEL //Werte bei hellen Pixeln auf -1, bei dunklen +1, sonst 0.0
 double schwelle1 = g_schwelle_schwarz*diff/255.0+mingrau; //immer noch Bereich 0 ... 255
 double schwelle2 = g_schwelle_weiss*diff/255.0+mingrau;
 for(int i=0; i<(NHO*NBR); i++)
  {if(X[i] < schwelle1) X[i] = 1.0; //fuer schwarze Pixel +1 setzen
   else if(X[i] > schwelle2) X[i] = -1.0; //fuer weisse Pixel -1 setzen
   else X[i] = 0.0; //graue Pixel auf 0 setzen
  }
#endif
#endif
 
 if(zflag) neuronen_rechts_zeichnen(X,NBR,NHO);
 if(zflag>=2) {propagieren(); neuronen_rechts_zeichnen(H,NBR,NHO);}//TODO
}
