/* matrixklasse.cc  letzte Aenderung: 11.3.2025
History:
10.3.2025      Erstellung (RP)
*/
#ifndef MATRIXKLASSE_CC
#define MATRIXKLASSE_CC

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#ifndef ZUFALL_DEFINIERT
#define ZUFALL_DEFINIERT
double zufall01() // Zufallszahl zwischen 0.0 und 1.0
{
 static double x=581;
 double y;
 if(x==0.) x=581;
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}
#endif

class Matrix
{
 double* data;
public:
 int nx,ny;
 Matrix() {data=NULL; nx=ny=0;}
 Matrix(int hoehe,int breite) {nx=breite; ny=hoehe; data=new double[nx*ny];}
 Matrix(int hoehe,int breite,double x) {nx=breite; ny=hoehe; data=new double[nx*ny]; setall(x);}
 ~Matrix() {clear();}
 void init(int hoehe,int breite)
  {nx=breite; ny=hoehe; if(data!=NULL) clear();
   data=new double[nx*ny];
  }
 void reshape(int hoehe,int breite)
  {if(hoehe*breite==nx*ny) {ny=hoehe; nx=breite;}
   else printf("Fehler in Matrix::reshape(%d,%d)\n",hoehe,breite);
  }
 void clear() {if(data!=NULL) {delete[] data; data=NULL;}}
 double get(int i,int j) {return data[j*nx+i];}
 void set(int i,int j,double x) {data[j*nx+i]=x;}
 void add(int i,int j,double x) {data[j*nx+i]+=x;}
 void setall(double x) {for(int i=0;i<nx*ny;i++) data[i]=x;}
 void matrixmult(Matrix& x,Matrix& y); //Matrixmultiplikation 
 void matrixmult_t(Matrix& x,Matrix& y);//Matrixmultiplikation mit transponiertem y
 void matrixmult_r(Matrix& x,Matrix& y);//Matrixmultiplikation mit transponiertem x
 void transp(Matrix& x);
 void werte_begrenzen(double min,double max)
  {for(int i=0;i<nx*ny;i++)
    {if(data[i]<min) data[i]=min; else if(data[i]>max) data[i]=max;}
  }
 void print();
 bool fread_size(FILE *fp);
 int fread(FILE *fp);
 void zufallswerte(double min= -1.0,double max=1.0)
  {double a=max-min;
   for(int i=0;i<nx*ny;i++)
    {data[i]=zufall01()*a+min; //Zufallszahlen zwischen -1.0 und 1.0, oder zwischen min und max
     if(data[i]==0.0) data[i]=a*0.0001; //Null-Werte vermeiden
    }
  }
 void sigmoid(double ks); //Sigmoid-Funktion auf alle Werte anwenden
 double& operator[](int k) {return data[k];}
 Matrix& operator=(const Matrix& x)
  {init(x.ny,x.nx);
   for(int i=0;i<nx*ny;i++) data[i] = x.data[i];
   return *this;
  }
 Matrix& operator+=(const Matrix& x)
  {if(nx!=x.nx || ny!=x.ny)
    {printf("Fehler int Matrix::operator+=() (%d,%d)+(%d,%d)\n",nx,ny,x.nx,x.ny); return *this;}
   for(int i=0;i<nx*ny;i++) data[i] += x.data[i];
   return *this;
  }
 Matrix& operator-=(const Matrix& x)
  {if(nx!=x.nx || ny!=x.ny)
    {printf("Fehler int Matrix::operator-=() (%d,%d)-(%d,%d)\n",nx,ny,x.nx,x.ny); return *this;}
   for(int i=0;i<nx*ny;i++) data[i] -= x.data[i];
   return *this;
  }
 Matrix& operator*=(Matrix& x) //nicht Matrixmult, sondern jedes Element einzeln multiplizieren
  {if(nx!=x.nx || ny!=x.ny)
    {printf("Fehler int Matrix::operator*=() (%d,%d)*(%d,%d)\n",nx,ny,x.nx,x.ny); return *this;}
   for(int i=0;i<nx*ny;i++) data[i] *= x.data[i];
   return *this;
  }
 Matrix& operator*=(double x) //jedes Element mit x multiplizieren
  {for(int i=0;i<nx*ny;i++) data[i] *= x;
   return *this;
  }
 friend Matrix operator+(const Matrix&,const Matrix&);
 friend Matrix operator-(const Matrix&,const Matrix&);
};

Matrix operator+(const Matrix& x,const Matrix& y)
{
 Matrix z; z=x; z+=y;
 return z;
}

Matrix operator-(const Matrix& x,const Matrix& y)
{
 Matrix z; z=x; z-=y;
 return z;
}

void Matrix::matrixmult(Matrix& x,Matrix& y)
{// *this = x*y
 if(y.ny!=x.nx)
  {printf("Fehler: inkompatible Matrizen fuer Matrixmultiplikation\n");
   printf(" x.nx=%d x.ny=%d  y.nx=%d y.ny=%d  (y.ny muss gleich x.nx sein)\n",x.nx, x.ny, y.nx, y.ny); 
   return;
  }
 int nk=y.ny;
 init(x.ny, y.nx); //Hoehe von Ziel ist Hoehe von X, Breite von Ziel ist Breite von Y
 for(int j=0;j<ny;j++) //Zeile von Ziel
  for(int i=0;i<nx;i++) //Spalte von Ziel
   {// Zeile von x mit Spalte von y multiplizieren, daddieren und in Ziel(i,j) speichern
    double z=0;
    for(int k=0;k<nk;k++)
     {z += x.get(k,j)*y.get(i,k);}
    set(i,j,z);
   }
}

void Matrix::matrixmult_t(Matrix& x,Matrix& y) //transponiertes y verwenden
{// *this = x*y'
 //transponiertes y: y.nx und y.ny vertauscht und i,j bei y.get() vertauscht
 if(y.nx!=x.nx)
  {printf("Fehler: inkompatible Matrizen fuer Matrixmultiplikation mit transponiertem y\n");
   printf(" x.nx=%d x.ny=%d  y.nx=%d y.ny=%d  (y.nx muss gleich x.nx sein)\n",x.nx, x.ny, y.nx, y.ny);
   return;
  }
 int nk=y.nx;
 init(x.ny, y.ny);
 for(int j=0;j<ny;j++) //Zeile von Ziel
  for(int i=0;i<nx;i++) //Spalte von Ziel
   {double z=0;
    for(int k=0;k<nk;k++)
     {z += x.get(k,j)*y.get(k,i);}
    set(i,j,z);
   }
}

void Matrix::matrixmult_r(Matrix& x,Matrix& y) //transponiertes x verwenden
{// *this = x'*y
 //transponiertes x: x.nx und x.ny vertauscht und i,j bei x.get() vertauscht
 if(y.ny!=x.ny)
  {printf("Fehler: inkompatible Matrizen fuer Matrixmultiplikation mit transponiertem x\n");
   printf(" x.nx=%d x.ny=%d  y.nx=%d y.ny=%d  (y.ny muss gleich x.ny sein)\n",x.nx, x.ny, y.nx, y.ny); 
   return;
  }
 int nk=y.ny;
 init(x.nx, y.nx);
 for(int j=0;j<ny;j++) //Zeile von Ziel
  for(int i=0;i<nx;i++) //Spalte von Ziel
   {double z=0;
    for(int k=0;k<nk;k++)
     {z += x.get(j,k)*y.get(i,k);}
    set(i,j,z);
   }
}

void Matrix::transp(Matrix& x)
{// this = Transponiertes x
 init(x.nx,x.ny);
 for(int j=0;j<ny;j++)
  for(int i=0;i<nx;i++)
   data[j*nx+i] = x.get(j,i);
}

void Matrix::print()
{
 for(int j=0;j<ny;j++)
  for(int i=0;i<nx;i++)
   printf("%f %c", get(i,j), (i==nx-1)?'\n':' ');
}

bool Matrix::fread_size(FILE *fp)
{
 int n=0,ho=0,br=0;
 n+=fscanf(fp,"%d",&ho); n+=fscanf(fp,"%d",&br);
 if(n==2 && ho>=1 && br>=1) {init(ho,br); return true;}
 return false;
}

int Matrix::fread(FILE *fp)
{
 int n=0;
 for(int i=0;i<nx*ny;i++) {n+=fscanf(fp,"%lf",&data[i]);}
 return n;
}

void Matrix::sigmoid(double ks) //Sigmoid-Funktion auf alle Werte anwenden
{
 for(int i=0;i<nx;i++)
  for(int j=0;j<ny;j++)
   {
    double x=get(i,j)*ks;
    x = 1.0/(1.0+exp(-x));
    set(i,j,x);
   }
}

void matrix_eingabe(FILE *fp,Matrix& X,const char *text=NULL,const char *text2=NULL)
{// mit fp==NULL wird interaktiv gefragt und mit stdin eingegeben, sonst Eingabe von Datei ohne Rueckfragen
 // text  ist Kommentar fuer Eingabe von Groesse der Matrix
 // text2 ist Kommentar fuer Eingabe aller Zeilen
 int br,ho;
 double wert;
 if(text==NULL)
  {br=X.nx; ho=X.ny;
   if(br<1 || ho<1) text="Groesse der Matrix";
  }
 if(text!=NULL)
  {
   if(fp!=NULL) {fscanf(fp,"%d %d",&ho,&br);}
   else {printf("%s (Hoehe Breite):",text); scanf("%d %d",&ho,&br);}
   X.init(ho,br);
  }
 if(fp==NULL)
  {if(text2==NULL) text2="Werte fuer Matrix eingeben";
   printf("%s (%d Werte pro Zeile):\n",text2,X.nx);
   for(int j=0;j<X.ny;j++)
    {printf("%d. Zeile:",j+1);
     for(int i=0;i<X.nx;i++) {scanf("%lf",&wert); X.set(i,j,wert);}
    }
  }
 else
  {for(int j=0;j<X.ny;j++)
    for(int i=0;i<X.nx;i++) {fscanf(fp,"%lf",&wert); X.set(i,j,wert);}
  }
}

class NeuronalesNetz
{
public:
 double ks;
 double lernrate;
 NeuronalesNetz() {ks=0.02; lernrate=0.3;}//TODO
 NeuronalesNetz(double k,double lern) {ks=k; lernrate=lern;}
 void init(double k,double lern) {ks=k; lernrate=lern;}
 //TODO
};
NeuronalesNetz netz;//TODO

void propagieren1(Matrix& Xinp,Matrix& Yout,Matrix& w1) //ohne Zwischenschicht
{// einfachstes Netz, ohne Zwischenschicht
 Yout.matrixmult(w1,Xinp); //Yout = w1*Xinp;
 Yout.sigmoid(netz.ks);
}

void propagieren(Matrix& Xinp,Matrix& Hidd,Matrix& Yout,Matrix& w1,Matrix& w2)
{// einfaes Netz mit nur einer Zwischenschicht
 Hidd.matrixmult(w1,Xinp); //Hidd = w1*Xinp;
 Hidd.sigmoid(netz.ks);
 Yout.matrixmult(w2,Hidd); //Yout = w2*Hidd;
 Yout.sigmoid(netz.ks);
}

void propagieren(int n,Matrix& Xinp,Matrix* Hidd,Matrix& Yout,Matrix* w)
{// Netz mit n Zwischenschichten
 Hidd[0].matrixmult(w[0],Xinp); //Hidd[0] = w[0]*Xinp;
 for(int i=1;i<n;i++)
  {
   Hidd[i].matrixmult(w[i],Hidd[i-1]); //Hidd[i] = w[i]*Hidd[i-1];
   Hidd[i].sigmoid(netz.ks);
  }
 Yout.matrixmult(w[n],Hidd[n-1]); //Yout = w[n]*Hidd[n-1];
 Yout.sigmoid(netz.ks);
}

void backprop1(Matrix& X,Matrix& Y,Matrix& w1,Matrix& Soll) //ohne Zwischenschicht
{
 //Backpropagation machen:
 double alfa = netz.lernrate * netz.ks;
 /* erste mit kleinem Beispiel funktionierende Variante:
 Matrix dw(w1.ny,w1.nx);
 for(int k=0;k<Y.ny;k++)
  {double Ok=Y[k], ausdruck=alfa*(Ok-Soll[k])*Ok*(1-Ok);
   for(int j=0;j<X.ny;j++)
    {dw.set(j,k,ausdruck*X[j]);}
  }
 w1 -= dw;
 */
 //zweite Variante:
 Matrix dw;
 Matrix Ausdr(Y.ny,Y.nx,1.0); Ausdr-=Y; Ausdr*=Y; //Ausdr = Y*(1-Y)
 Matrix Ey; Ey=Y; Ey-=Soll; Ausdr*=Ey; Ausdr*=alfa; //Ausdr = alfa*(Y-Soll)*Y*(1-Y);
 dw.matrixmult_t(Ausdr, X); //Matrixmultiplikation mit transponiertem X
 w1 -= dw;
}

void backprop(Matrix& X,Matrix& H,Matrix& Y,Matrix& w1,Matrix& w2,Matrix& Soll)
{
 //Backpropagation mit einer Zwischenschicht machen:
 double alfa = netz.lernrate * netz.ks;
 /* erste mit kleinem Beispiel funktionierende Variante:
 int ny=w2.ny, nx=w2.nx;
 Matrix dw2(ny,nx);
 Matrix Err(X.ny,1); Err.setall(0);//Fehler-Matrix fuer Zwischenschicht auf 0 setzen
 //zuerst w2 anpassen:
 for(int k=0;k<ny;k++)
  {double Ok=Y[k];
   double err=(Ok-Soll[k])*Ok*(1-Ok);
   double ausdruck = alfa*err;
   for(int j=0;j<nx;j++)
    {Err[j] += err*H[j]*w2.get(j,k);//Fehler fuer Zwischenschicht aufsummieren
     dw2.set(j,k,ausdruck*H[j]);
    }
  }
 w2 -= dw2;
 //jetzt noch w1 anpassen:
 ny=w1.ny; nx=w1.nx;
 Matrix dw1(ny,nx);
 for(int j=0;j<nx;j++)
  {double Oj=H[j];
   double ausdruck = alfa*Err[j]*Oj*(1-Oj);
   for(int i=0;i<ny;i++)
    {dw1.set(i,j, ausdruck*X[i]);}
  }
 w1 -= dw1;
 */
 //zweite Varaiante:
 Matrix dw;
 //zuerst w2 anpassen:
 Matrix Ausdr(Y.ny,Y.nx,1.0); Ausdr-=Y; Ausdr*=Y; //Ausdr = Y*(1-Y)
 //Matrix Ey; Ey = Y-Soll;
 Matrix Ey; Ey=Y; Ey-=Soll; //effizienter? //Ey = Y-Soll
 Ey*=alfa; Ausdr*=Ey; //Ausdr = alfa*(Y-Soll)*Y*(1-Y); und Ey=Ey*alfa; fuer w1 Anpassung
 dw.matrixmult_t(Ausdr,H); //Matrixmultiplikation mit transponiertem H
 Matrix Eh; Eh.matrixmult_r(w2,Ey);//Fehler fuer Zwischenschicht (Matrixmult. mit transponiertem w2)
 //nach Buch1: ...(w2,Ausdr); --> schwaechere Anpassung von w1?
 w2 -= dw;
 //jetzt noch w1 anpassen: (alfa ist schon in Eh enthalten)
 Matrix dw1;
 Ausdr.init(H.ny,H.nx);
 Ausdr.setall(1.0); Ausdr-=H; Ausdr*=H; Ausdr*=Eh; //Ausdr = (alfa*Eh)*H*(1-H)
 dw.matrixmult_t(Ausdr,X);
 w1 -= dw;
}

void backprop(int n,Matrix& X,Matrix* H,Matrix& Y,Matrix* w,Matrix& Soll)
{// Netz mit n Zwischenschichten, Feldgroessen: H[n]  w[n+1]
 printf("backprop(n=%d, ...)\n TODO\n",n);//test
 //TODO
}

#endif //MATRIXKLASSE_CC
