/* matrixmult.cpp
  Beispiel von ChatGPT
  
  kompilieren mit:
  g++ -o matrixmult matrixmult.cpp -fopenmp -O3 -march=native
  
  Ueberpruefen ob SIMD-Befehle genutzt wurden:
  g++ -march=native -Q --help=target | grep march  ;zeigt welche Architektur verwendet
  objdump -d matrixmult | grep -E "vmulps|vaddps|mulps|addps"
 */
#include <iostream>
#include <vector>
#include <cstdlib>
#include <ctime>
#include <omp.h>

using namespace std;

// Funktion zur Initialisierung einer Matrix mit zufälligen Werten
void initializeMatrix(vector<vector<int>> &matrix, int rows, int cols) {
    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            matrix[i][j] = rand() % 100; // Zufallswerte zwischen 0 und 99
        }
    }
}

// Parallele Matrixmultiplikation mit OpenMP
vector<vector<int>> multiplyMatrices(const vector<vector<int>> &A, const vector<vector<int>> &B, int rowsA, int colsA, int colsB) {
    vector<vector<int>> result(rowsA, vector<int>(colsB, 0));
    
    #pragma omp parallel for collapse(2)
    for (int i = 0; i < rowsA; i++) {
        for (int j = 0; j < colsB; j++) {
	    #pragma omp simd
            for (int k = 0; k < colsA; k++) {
                result[i][j] += A[i][k] * B[k][j];
            }
        }
    }
    return result;
}

int main() {
    srand(time(0));

    //int rowsA = 500, colsA = 500, colsB = 500; // Große Matrizen für Leistungstest
    int rowsA = 1000, colsA = 1000, colsB = 1000; // Große Matrizen für Leistungstest
    vector<vector<int>> A(rowsA, vector<int>(colsA));
    vector<vector<int>> B(colsA, vector<int>(colsB));

    initializeMatrix(A, rowsA, colsA);
    initializeMatrix(B, colsA, colsB);

    cout << "Matrixmultiplikation gestartet..." << endl;
    double start = omp_get_wtime();
    vector<vector<int>> result = multiplyMatrices(A, B, rowsA, colsA, colsB);
    double end = omp_get_wtime();
    cout << "Fertig! Dauer: " << (end - start) << " Sekunden." << endl;
    
    return 0;
}
