/* siles.cc			letzte Aenderung: 7.2.2025 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 aus 7-Seg-Anzeige Ziffern in 3x5-Matrix erkennen: 0 bis 9 ermitteln

History:
6.2.2025       Erstellung (RP)
*/
//#define VARIANTE_ZUFALL
#define VARIANTE_BACKPROP

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <math.h>
#include <xtekplot1.h>

#define uchar uint8_t

#define XMAX 1024
#define YMAX  820
#define TIEFE 24

#define SCHWARZAUFWEISS //auskommentieren fuer weiss auf schwarz

/************************* Vordeklarationen ***************************/
void auswerten(const char *name);
void pixelfeld_zeichnen();
void trainieren();
void menu_load(),m_lernen(),m_refresh();
;

/************************* Globale Variablen **************************/
static int shiftx=0,shifty=0;

/*
XXX ..X     XXX
X.X ..X     X.X
X.X ..X     XXX
X.X ..X     ..X
XXX ..X ... XXX
*/

uchar lerndaten[]={
 1,1,1,
 1,0,1,
 1,0,1,
 1,0,1,
 1,1,1, 0,
 0,0,1,
 0,0,1,
 0,0,1,
 0,0,1,
 0,0,1, 1,
 /*
 0,1,0,
 0,1,0,
 0,1,0,
 0,1,0,
 0,1,0, 1,
 1,0,0,
 1,0,0,
 1,0,0,
 1,0,0,
 1,0,0, 1,
 */
 1,1,1,
 0,0,1,
 1,1,1,
 1,0,0,
 1,1,1, 2,
 1,1,1,
 0,0,1,
 1,1,1,
 0,0,1,
 1,1,1, 3,
 /*
   1,1,1,
 0,0,1,
 0,1,1,
 0,0,1,
 1,1,1, 3,
 */
 1,0,1,
 1,0,1,
 1,1,1,
 0,0,1,
 0,0,1, 4,
 /*
 1,0,0,
 1,0,1,
 1,1,1,
 0,0,1,
 0,0,1, 4,
 */
 1,1,1,
 1,0,0,
 1,1,1,
 0,0,1,
 1,1,1, 5,
 1,1,1,
 1,0,0,
 1,1,1,
 1,0,1,
 1,1,1, 6,
 /*
 1,0,0,
 1,0,0,
 1,1,1,
 1,0,1,
 1,1,1, 6,
 */
 1,1,1,
 0,0,1,
 0,0,1,
 0,0,1,
 0,0,1, 7,
 1,1,1,
 1,0,1,
 1,1,1,
 1,0,1,
 1,1,1, 8,
 1,1,1,
 1,0,1,
 1,1,1,
 0,0,1,
 1,1,1, 9,
 /*
 1,1,1,
 1,0,1,
 1,1,1,
 0,0,1,
 0,0,1, 9,
 */
 10 //10=Ende
};

uchar testdaten[]={
 1,1,1,
 1,0,1,
 1,0,1,
 1,0,1,
 1,1,1, 0,
 0,0,1,
 0,0,1,
 0,0,1,
 0,0,1,
 0,0,1, 1,
 1,1,1,
 0,0,1,
 1,1,1,
 1,0,0,
 1,1,1, 2,
 1,1,1,
 0,0,1,
 1,1,1,
 0,0,1,
 1,1,1, 3,
 1,0,1,
 1,0,1,
 1,1,1,
 0,0,1,
 0,0,1, 4,
 1,1,1,
 1,0,0,
 1,1,1,
 0,0,1,
 1,1,1, 5,
 1,1,1,
 1,0,0,
 1,1,1,
 1,0,1,
 1,1,1, 6,
 1,1,1,
 0,0,1,
 0,0,1,
 0,0,1,
 0,0,1, 7,
 1,1,1,
 1,0,1,
 1,1,1,
 1,0,1,
 1,1,1, 8,
 1,1,1,
 1,0,1,
 1,1,1,
 0,0,1,
 1,1,1, 9,
 1,0,1,
 1,0,1,
 1,0,1,
 1,0,1,
 1,1,1, 0,
 0,0,1,
 0,0,0,
 0,0,1,
 0,0,1,
 0,0,1, 1,
 1,1,1,
 0,0,1,
 1,1,0,
 1,0,0,
 1,1,1, 2,
 1,1,1,
 0,0,1,
 0,0,1,
 0,0,1,
 1,1,1, 3,
 1,0,0,
 1,0,0,
 1,1,1,
 0,0,1,
 0,0,1, 4,
 1,1,1,
 1,0,0,
 1,1,0,
 0,0,1,
 1,1,1, 5,
 1,1,0,
 1,0,0,
 1,1,1,
 1,0,1,
 1,1,1, 6,
 0,1,1,
 0,0,1,
 0,0,1,
 0,0,1,
 0,0,1, 7,
 1,1,1,
 1,0,1,
 0,1,1,
 1,0,1,
 1,1,1, 8,
 1,1,1,
 1,0,1,
 1,1,1,
 0,0,1,
 0,1,1, 9,
 10 //10=Ende
};

/***************************** Kleinkram ******************************/
const int N80=200;//maximal vorkommende Laenge eines Dateinamens
const int MAXL=1000;


int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}


// Umgang mit Dateien:
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

bool vorhanden(const char *dateiname)
{
 struct stat buf;
 return (lstat(dateiname,&buf)>=0);
}

bool istordner(char *dateiname)
{
 struct stat buf;
 if(lstat(dateiname,&buf)<0) return false;
 //if(buf.st_mode & S_IFDIR) return true;
 if((buf.st_mode & S_IFMT)==S_IFDIR) return true;
 return false;
}
bool istregulaer(char *dateiname) //Regulaere Datei ohne Softlink ohne Ordner
{
 struct stat buf; //siehe man lstat
 //(Fehler in man lstat: S_IFMT ist nicht 0017000 sondern 0170000)
 if(lstat(dateiname,&buf)<0) return false;
 if((buf.st_mode & S_IFMT)==S_IFREG) return true;
 return false;
}
bool istsoftlink(char *dateiname)
{
 struct stat buf;
 if(lstat(dateiname,&buf)<0) return false;
 if((buf.st_mode & S_IFMT)==S_IFLNK) return true;
 return false;
}

bool istbilddatei(const char *name) //Bilddatei anhand der Endung
{
 int n=strlen(name);
 if(n<5) return false;
 if(name[n-4]=='.')
   return (strcmp(&name[n-3],"jpg")==0 || strcmp(&name[n-3],"JPG")==0 ||
	   strcmp(&name[n-3],"gif")==0 || strcmp(&name[n-3],"GIF")==0 ||
	 //strcmp(&name[n-3],"ppm")==0 || strcmp(&name[n-3],"PPM")==0 ||
	   strcmp(&name[n-3],"png")==0 || strcmp(&name[n-3],"PNG")==0);
 else if(n>5 && name[n-5]=='.')
   return (strcmp(&name[n-4],"jpeg")==0 || strcmp(&name[n-4],"JPEG")==0);
 return false;
}

int anzahlblanks(const char *s) //zaehle Anzahl Leerstellen im String
{                               //und Klammern auch
 int c,n=0;
 while((c= *s++)!=0)
    if(c==' ' || c=='(' || c==')') n++;
 return n;
}

char *escapeblanks(const char *s,int nb)
{
 char *name2=new char[strlen(s)+nb+1];
 char *p=name2;
 int c;
 while((c= *s++)!=0)
   {if(--nb>=0 && (c==' ' || c=='(' || c==')'))
       *p++ = '\\'; //vor jede Leerstelle oder Klammer ein \ setzen
    *p++ = c;
   }
 *p=0;
 return name2;
}

char *entferneblanks(const char *s)
{
 char *name2=new char[strlen(s)+1];
 char *p=name2;
 int c;
 while((c= *s++)!=0)
   {if(c==' ' || c=='(' || c==')')
       c = '_'; //Leerstelle oder Klammer durch _ ersetzen
    *p++ = c;
   }
 *p=0;
 return name2;
}

class Aktuellerpfad
{
 char *pfad;
 char *liste[MAXL];//fuer Speicherrueckgabe
 int imax;
public:
 Aktuellerpfad() {pfad=NULL; imax=0;}
 ~Aktuellerpfad() {if(pfad!=NULL) delete[] pfad; loeschen();}
 void set(const char *arg0)
	{char *s; int n=strlen(arg0);
	 if(pfad!=NULL) delete[] pfad;
	 pfad=new char[n+1];
	 strcpy(pfad,arg0);
	 for(s= &pfad[n];*--s!='/';) ;
	 *s=0;
	 setenv("PWD",pfad,1);
	}
 void cd(const char* ordner);
 FILE *fopen2(const char *name,const char *rw);
 const char *vollpfad(const char *name);
 char *getpfad() {if(pfad) return pfad; else return getenv("PWD");}
 void loeschen() {while(imax>0) delete[] liste[--imax];}
};
void Aktuellerpfad::cd(const char* ordner)
{
 const char *s,*altpfad=pfad;
 if(ordner[0]=='/') s="";
 else if(altpfad==NULL) s=getenv("PWD");
 else s=altpfad;
 int n=strlen(s)+strlen(ordner)+2;
 pfad=new char[n];
 if(*s==0) strcpy(pfad,ordner);
 else sprintf(pfad,"%s/%s",s,ordner);
 while(!istordner(pfad) && (n=strlen(pfad))>1)
   {while(--n>1 && pfad[n]!='/') {}
    pfad[n]=0;
   }
 if(altpfad) delete[] altpfad;
}

FILE *Aktuellerpfad::fopen2(const char *name,const char *rw)
{
 FILE *fp;
 if(pfad!=NULL && *name!='/')
  {char str[strlen(pfad)+strlen(name)+2];
   sprintf(str,"%s/%s",pfad,name);
   fp=fopen(str,rw);
  }
 else fp=fopen(name,rw);
 return fp;
}

static int test=0;

const char *Aktuellerpfad::vollpfad(const char *name)
{
 if(name==NULL || *name=='/' || pfad==NULL) return name;
 char *name2=NULL;
 int nb;
 if((nb=anzahlblanks(name))>0) //falls in name Leerstellen sind
   name=name2=escapeblanks(name,nb);
 char vollname[strlen(pfad)+strlen(name)+2];
 sprintf(vollname,"%s/%s",pfad,name);
 int i;
 for(i=0;i<imax;i++)
   if(strcmp(vollname,liste[i])==0) {return liste[i];}
 char *str=new char[strlen(vollname)+1];
 strcpy(str,vollname);
 if(imax<MAXL)
   {liste[imax++]=str;
    if(imax==MAXL && test>0)
      printf("Aktuellerpfad::vollpfad() liste fuer Speichrrueckgabe voll.\n");
   }
 if(name2!=NULL) delete[] name2;
 return str;
}

static Aktuellerpfad pwd;
inline FILE *fopen2(const char *na,const char *rw) {return pwd.fopen2(na,rw);}
inline const char *vollpfad(const char *s) {return pwd.vollpfad(s);}
inline bool vorhanden2(const char *name) {return vorhanden(vollpfad(name));}

#include <errno.h>
void fehlermeldung(int err)
{
 if(err== -1) err=errno;
#ifdef EEXIST
 if(err==EEXIST) printf("EEXIST - Datei schon vorhanden.\n");
 else if(err==EROFS) printf("EROFS - nur lesbar\n");
 else if(err==ENOMEM) printf("ENOMEM - nicht genug Kernelspeicher\n");
 else if(err==EACCES) printf("EACCES - kein Schreibrecht\n");
 else
#endif
    printf("Fehlercode %d: siehe \"more /usr/include/asm*/errno*.h\"\n",err);
}

void system1(const char *s,int k)
{
 if(test>=2) printf("system%d> %s\n",k,s);
 int n=system(s);
 if(n!=0)
   {if(n==127) printf("Fehler %d in system(): fehlendes /bin/sh\n",n);
    else if(n<0) {printf("Fehler %d in system(%s)\n",n,s); fehlermeldung(n);}
    else if(test>=2) printf("Rueckgabewert von system() = %d\n",n);
   }
}

void system2(const char *s,const char *p1,const char *p2=NULL)
{
 char str[3*N80];
 sprintf(str,s,vollpfad(p1),vollpfad(p2));
 system1(str,2);
}

char *ohneletztenpunkt(char *name)  /* die Endung .xxx loeschen */
{
 char c=0,*s; int i;
 for(i=0,s=name;*s!=0;s++,i++) ;
 while(i>0 && (c= *s)!='.')
        {--i; --s;}
 if(c=='.') *s='\0';
 return name;
}

char *anhaengen(char *s,const char *t)  /* s + t --> s */
{
 char *p;
 for(p=s;*p!=0;p++) ;
 for(;*p++ = *t++;) ;
 return s;
}

char *endungersetzen(char *neu,const char *name,const char *endung)
{
 strcpy(neu,name); ohneletztenpunkt(neu);
 return anhaengen(neu,endung);
}

bool istppm(const char *name)
{
 int i=0;
 while(name[i]!=0 && name[i]!='.') {i++;}
 return (strcmp(&name[i],"ppm")==0);
}

double zufall4()	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* bisher bester Zufallsgenerator   */
 static double x=581;
 double y;
 if(x==0.) x=581;
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}

double zufall() //Zufallszahl zwischen -1.0 und +1.0
{
 return zufall4()*2-1;
}

/****************************** Klassen *******************************/
#define EINGABENEURON 0
#define AUSGABENEURON 1
#define ZWISCHENSCHICHTNEURON 2

class Neuron
{
public:
 int typ;
 int anzeing;
 double *eing; //Eingaenge
 double *w; //Gewichtung der Eingaenge
 double k; //Steilheit: 1=flach 1000=sehr steil
 Neuron() {typ=0; anzeing=0; w=NULL;}
 ~Neuron()
  {if(w!=NULL) {delete[] w; w=NULL;}
   if(eing!=NULL) {delete[] eing; eing=NULL;}
  }
 void init(int t,int anzahl_eingaenge,double steilheit);
 void seteingang(int i,double wert);
 double ausgabe();
#ifdef VARIANTE_ZUFALL
 void zufallsvarieren();
#endif
#ifdef VARIANTE_BACKPROP
 void backpropw1(double delta);
 void backpropw2(double delta,int j);
#endif
};

double Neuron::ausgabe()
{
 double wert=0;
 if(typ==EINGABENEURON)
  {
   for(int i=0;i<anzeing;i++)
    {
     wert += eing[i]*w[i];
    }
   wert *= k;
  }
 else if(typ==AUSGABENEURON)
  {
   for(int i=0;i<anzeing;i++)
    {
     wert += eing[i]*w[i];
    }
   wert = 1.0/(1.0+exp(-wert*k));
  }
 else //sonst Zwischenschicht
  {
   for(int i=0;i<anzeing;i++)
    {
     wert += eing[i]*w[i];
    }
   if(wert<0) wert=0; else wert=wert*k;
  }
 return wert;
}

void Neuron::init(int t,int anzahl_eingaenge,double steilheit)
{
 typ = t;
 anzeing = anzahl_eingaenge;
 k = steilheit;
 if(w!=NULL) delete[] w;
 w = new double[anzeing];
 if(eing!=NULL) delete[] eing;
 eing = new double[anzeing];
 if(anzeing==1) w[0]=1.0;
 else
  {
   for(int i=0;i<anzeing;i++)
    {
     double z=zufall(); //Zufallszahl zwischen -1.0 und +1.0
     w[i]=z;
    }
#ifdef VARIANTE_BACKPROP
   w[anzeing-1] = -1.0; //Bias immer auf 1.0 setzen und subtrahieren: also -1.0
#endif
  }
}

void Neuron::seteingang(int i,double wert)
{
 eing[i]=wert;
}

#ifdef VARIANTE_ZUFALL
void Neuron::zufallsvarieren()
{
 double z;
 static int nter=1,nter2=1;
 z=zufall4(); //Zufallszahl zwischen 0 und 1
 if(z>1.0/nter2) return;//nur jedes 2. Neuron varieren
 for(int i=0;i<anzeing;i++)
  {
   z=zufall4();
   if(z<1.0/nter) //nur jeder n. w-Wert varieren
    w[i] = zufall(); //Zufallszahl zwischen -1.0 und +1.0
  }
 if(nter>16) nter=1; else nter++;
 if(nter2>=5) nter2=1; else nter2++;
}
#endif

void neuron_kopieren(Neuron& von,Neuron& nach) //beide schon initialisiert
{
 for(int i=0;i<von.anzeing;i++)
  {
   nach.eing[i] = von.eing[i];
   nach.w[i] = von.w[i];
  }
 nach.k = von.k;
}

#define NOUT 10 //Ziffer 0 bis 9
#ifdef VARIANTE_BACKPROP
#define NINP 16 //3*5+1 (Bias)
#define NZWI 17 //16+1 (Bias)
static double Hk[NZWI]; //Ausgabewerte von ZwischenNeuronen
static double Sigmak[NZWI]; //Zwischenwerte fuer backpropw1()
static double Xi[NINP]; //Ausgabewerte von EingabeNeuronen
static double w2kj[NZWI][NOUT];
static double Vj[NOUT];
#else
#define NINP 15 //3*5
#define NZWI 16
#endif

Neuron EingabeNeuronen[NINP];
Neuron ZwischenNeuronen[NZWI];
Neuron AusgabeNeuronen[NOUT];

Neuron EingabeNeuronen_bak[NINP];
Neuron ZwischenNeuronen_bak[NZWI];
Neuron AusgabeNeuronen_bak[NOUT];

#ifdef VARIANTE_BACKPROP
void Neuron::backpropw2(double delta,int j)
{
 //nach Formel Seite 84:
 for(int hk=0;hk<anzeing;hk++)
  {
   w2kj[hk][j]=w[hk];
   w[hk] += delta*Hk[hk];
  }
}

void Neuron::backpropw1(double delta)
{
 //nach Formel Seite 85:
 for(int i=0;i<anzeing;i++)
  {
   w[i] += delta*Xi[i];
  }
}
#endif

void neuronen_init()
{
 for(int i=0;i<NINP;i++) EingabeNeuronen[i].init(EINGABENEURON,1,1);
 for(int i=0;i<NZWI;i++) ZwischenNeuronen[i].init(ZWISCHENSCHICHTNEURON,NINP,1);
 for(int i=0;i<NOUT;i++) AusgabeNeuronen[i].init(AUSGABENEURON,NZWI,10);
 for(int i=0;i<NINP;i++) EingabeNeuronen_bak[i].init(EINGABENEURON,1,1);
 for(int i=0;i<NZWI;i++) ZwischenNeuronen_bak[i].init(ZWISCHENSCHICHTNEURON,NINP,1);
 for(int i=0;i<NOUT;i++) AusgabeNeuronen_bak[i].init(AUSGABENEURON,NZWI,100);
}

void eingabe_an_neuronen(uchar *feld)
{
 int wert, n=0;
 const int NX=3,NY=5;
 for(int j=0;j<NY;j++)
  {
   for(int i=0;i<NX;i++)
    {
     wert = (feld[j*NX+i])==0 ? -1 : 1;
     EingabeNeuronen[n++].seteingang(0, wert);
    }
  }
}

void propagieren()
{
 for(int j=0;j<NINP;j++)
  {
   double wert=EingabeNeuronen[j].ausgabe();
#ifdef VARIANTE_BACKPROP
   Xi[j]=wert;//Ausgabewerte von EingabeNeuronen zwischenspeichern
#endif
   for(int i=0;i<NZWI;i++)
    ZwischenNeuronen[i].seteingang(j,wert);
  }
 for(int j=0;j<NZWI;j++)
  {
   double wert=ZwischenNeuronen[j].ausgabe();
#ifdef VARIANTE_BACKPROP
   Hk[j]=wert;//Ausgabewerte von ZwischenNeuronen zwischenspeichern
#endif
   for(int i=0;i<NOUT;i++)
    AusgabeNeuronen[i].seteingang(j,wert);
  }
}

void m_scannen()
{
 int index=0;
 //printf("Eingabe 0 bis 9 fuer korrekte Ziffern, 10 bis 19 fuer leicht fehlerhafte\n");
 //printf("Eingabe: "); scanf("%d",&index);
 int korrekt1=0,korrekt2=0;
 for(index=0;index<=19;index++)
  {
   if(index<10) printf("Testeingabe: %d korrekt\n",index);
   else printf("Testeingabe: %d leicht fehlerhaft\n",index-10);
   eingabe_an_neuronen(&testdaten[16*index]);
   propagieren();
   double max= -2, min=2;
   double summe=0;//test
   int imax=0,imin=0;
   for(int i=0;i<NOUT;i++)
    {
     double x=AusgabeNeuronen[i].ausgabe();
     printf("i=%d x=%f\n",i,x);//test
     summe += x;//test
     if(x>max) {max=x; imax=i;}
     if(x<min) {min=x; imin=i;}
    }
   printf("x durchschnitt: %f\n",summe/NOUT);//test
   printf("Resultat von Neuronalem Netz: %d\n",imax);
   printf("Groesster Wert: %d: %f\n",imax,max);
   printf("Kleinster Wert: %d: %f\n",imin,min);
   if(index<10)
    {
     if(imax==index) korrekt1++;
    }
   else
    {
     if(imax==index-10) korrekt2++;
    }
  }
 printf("Schlussauswertung:\n");
 printf(" Erfolg bei korrekten Zahlen: %d von 10 richtig\n",korrekt1);
 printf(" Erfolg bei leichten Fehlern: %d von 10 richtig\n",korrekt2);
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Menu Behandlung ****************************/
static int exitflag=0;
static char quellname[200],zielname[200];
void menu_exit() {exitflag=1;}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 quellname[0]=zielname[0]=0;
 //FILE *fp1,*fp2;
 int i,j=0,c;
 int breite,hoehe,tiefe,visklasse;
 double xmin= -0.125,ymin=0.,xmax=1.125,ymax=1.;
 if(argc>0)
  {
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else if(++j==1) strcpy(quellname,argv[i]);
	 else if(j==2) strcpy(zielname,argv[i]);
	}
  }
 if(argflag['?'] || j>MAXARG)
	{printf("siles  %s\n",VERSION);
	 printf("Anwendung: %s [-Flags] [Quelle.ppm] [Ziel]\n",argv[0]);
	 printf("  Flags: v=verbose (Testpunkte drucken)\n");
	 exit(0);
	}
 neuronen_init();
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 setsize(breite,hoehe,tiefe);
 setmenu(2,"File",    "Scannen");
 setmenu(2,"Load ...","Scannen", &menu_load, &m_scannen);
 setmenu(2,"Exit",    "Lernen",  &menu_exit, &m_lernen);
 setmenu(2,NULL,      "Refresh", NULL, &m_refresh);
 //set_funktions(maus_gedrueckt,maus_losgelassen,fenster_verdeckung,maus_bewegung);
 //set_funktions(maus_gedrueckt,maus_losgelassen,NULL,maus_bewegung);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */

#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss (default ist weiss auf schwarz):
 if(TIEFE==24)
  {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
 else
  {screenclear(1); color(0);}
#endif

 //plot(0.,0.,PENUP); plot(1.,1.,PENDOWN); /* eine Linie zeichnen */
 drawbox(0.0,0.0,1.0,1.0); /* ein Quadrat zeichnen */
 term_refresh();

 /* Variante1: */
 while(exitflag==0 && waitmenu(0)==0) // auf Benutzereingaben warten
  {
   //if(quellname[0]!=0) auswerten(quellname);
   waitBOF();		//auf Ende des Bildaufbaus warten
  }
 /* */
 
 /* Variante2: * /
 int col=0,maxcol=(1<<TIEFE);
 inital_new();
 while(exitflag==0)
	{waitBOF();		//auf Ende des Bildaufbaus warten
	//oder waitTOF();	//auf Beginn des Bildaufbaus warten
	//oder waitmenu(0);	//nicht warten
	 if((col+=128)==maxcol) col=0;
	 color(col);
	 plot(1.,0.,PENUP); plot(0.,1.,PENDOWN);
	 plot(0.,0.,PENUP); plot(1.,1.,PENDOWN);
	}
 / * */
 term_exit();
 return 0;
}/* ende von main */

void menu_load()
{
 int ok=nachfilenamefragen("Lade Datei",quellname,200);
 if(ok)
  {
   //auswerten(quellname);
  }
}

void auswerten(const char *name)
{
 /*
 if(!istppm(name))
  {
   endungersetzen(neu,name,".ppm");
   system2("convert %s %s",name,neu);
  }
 else strcpy(neu,name);
 printf("neu=\"%s\"\n",neu);//test
 FILE *fp=fopen(neu,"rb");
 if(fp==NULL) {printf("kann \"%s\" nicht oeffnen\n",neu); quellname[0]=0; return;}
 if(getc(fp)!='P' || getc(fp)!='6') {printf("Fehler in \"%s\": P6 fehlt\n",neu); quellname[0]=0; return;}
 getc(fp); //0A ueberlesen
 fscanf(fp,"%d %d",&bild.breite,&bild.hoehe);
 fscanf(fp,"%d",&bild.tiefe);
 printf("breite=%d hoehe=%d tiefe=%d\n",bild.breite,bild.hoehe,bild.tiefe);//test
 if(getc(fp)!='\n') printf("fehlender Zeilentrenner\n");//test
 int i,j,wert;
 //gesamtes Bild einlesen:
 for(j=0; j<bild.hoehe; j++)
  {
   for(i=0; i<bild.breite*3; i++)
    {
     wert = (getc(fp) & 0xFF);
     //if(bild.tiefe>255) {wert <<= 8; wert += (getc(fp) & 0xFF);}
     if(bild.tiefe>255) {getc(fp);} //auf 8Bit pro Farbwert beschraenken
     bild.setpixel(j,i,wert);
    }
  }
 fclose(fp);
 pixelfeld_zeichnen();
 quellname[0]=0;
 */
}

void pixelfeld_zeichnen()
{
 /*
 int i,j, r,g,b;
 int NX=bild.NX, NY=bild.NY;
 double dx=1.0/NX, dy=1.0/NY;
 inital_new();
 for(j=shifty; j<shifty+NY; j++)
  {
   double y1=(NY-1-(j-shifty))*dy, y2=y1+dy;
   for(i=shiftx*3; i<shiftx*3+NX*3; i+=3)
      {
       if(i<bild.breite*3 && j<bild.hoehe)
	{
	 r=bild.get(j,i);
	 g=bild.get(j,i+1);
	 b=bild.get(j,i+2);
	}
       else r=g=b=255;//weisse Pixel am Rand
       rgbcolor(r,g,b);
       double x1=(i/3-shiftx)*dx, x2=x1+dx;
       fillbox(x1,y1,x2,y2);
      }
  }
 term_refresh();
 */
}

void m_refresh()
{
#ifdef SCHWARZAUFWEISS
 //fuer schwarz auf weiss (default ist weiss auf schwarz):
 if(TIEFE==24)
  {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
 else
  {screenclear(1); color(0);}
#endif
 //pixelfeld_zeichnen();
}

void m_lernen()
{
   trainieren();
}

#define VARIEREN_NEU 1
#define VARIEREN_ZURUECK 2

#ifdef VARIANTE_ZUFALL
void neuronen_varieren(int flag)
{
 if(flag==VARIEREN_ZURUECK)
  {
   for(int i=0;i<NINP;i++) neuron_kopieren(EingabeNeuronen_bak[i], EingabeNeuronen[i]);
   for(int i=0;i<NZWI;i++) neuron_kopieren(ZwischenNeuronen_bak[i], ZwischenNeuronen[i]);
   for(int i=0;i<NOUT;i++) neuron_kopieren(AusgabeNeuronen_bak[i], AusgabeNeuronen[i]);
  }
 else if(flag==VARIEREN_NEU)
  {
   for(int i=0;i<NINP;i++) neuron_kopieren(EingabeNeuronen[i], EingabeNeuronen_bak[i]);
   for(int i=0;i<NZWI;i++) neuron_kopieren(ZwischenNeuronen[i], ZwischenNeuronen_bak[i]);
   for(int i=0;i<NOUT;i++) neuron_kopieren(AusgabeNeuronen[i], AusgabeNeuronen_bak[i]);
   for(int i=0;i<NINP;i++) EingabeNeuronen[i].zufallsvarieren();
   for(int i=0;i<NZWI;i++) ZwischenNeuronen[i].zufallsvarieren();
   for(int i=0;i<NOUT;i++) AusgabeNeuronen[i].zufallsvarieren();
  }
 else printf("Fehler: unbekanntes flag in neuronen_varieren()\n");
}
#else
void neuronen_speichern()
{
 for(int i=0;i<NZWI;i++) neuron_kopieren(ZwischenNeuronen[i], ZwischenNeuronen_bak[i]);
 for(int i=0;i<NOUT;i++) neuron_kopieren(AusgabeNeuronen[i], AusgabeNeuronen_bak[i]);
}
void neuronen_zurueck()
{
 //for(int i=0;i<NINP;i++) neuron_kopieren(EingabeNeuronen_bak[i], EingabeNeuronen[i]);
 for(int i=0;i<NZWI;i++) neuron_kopieren(ZwischenNeuronen_bak[i], ZwischenNeuronen[i]);
 for(int i=0;i<NOUT;i++) neuron_kopieren(AusgabeNeuronen_bak[i], AusgabeNeuronen[i]);
}
#endif

#ifdef VARIANTE_ZUFALL
void trainieren()
{
 int soll;
 double z[NOUT];
 double best_punkte=0;
 int ivarmax=10000000, anz_verbesserungen=0;
 for(int ivar=0;ivar<ivarmax;ivar++) //TODO
  {
   double summe_punkte=0;
   for(int j=0; lerndaten[j]!=10; j+=16)
    {
     eingabe_an_neuronen(&lerndaten[j]);
     propagieren();
     for(int i=0;i<NOUT;i++)
      {
       z[i]=AusgabeNeuronen[i].ausgabe();
      }
     //Bewertung von Resultat:
     soll=lerndaten[j+15];
     double punkte=0;
     for(int i=0;i<NOUT;i++)
      {
       if(i==soll) {punkte += z[i];}
       else punkte += (1.0-z[i]);
      }
     summe_punkte += punkte;
    }
   if(summe_punkte<best_punkte)
    {
     neuronen_varieren(VARIEREN_ZURUECK);
    }
   else
    {
     if(summe_punkte>best_punkte)
      {
       if(ivar%10000==0) printf("ivar=%d summe_punkte = %f\n",ivar,summe_punkte);//test
       best_punkte = summe_punkte;
       anz_verbesserungen++;
      }
     if(ivar!=ivarmax-1) neuronen_varieren(VARIEREN_NEU); //TODO
    }
  }
 printf("best_punkte = %f\n",best_punkte);//test
}
#endif //VARIANTE_ZUFALL

#ifdef VARIANTE_BACKPROP
void trainieren()
{
 int soll;
 double z[NOUT];
 double Epsilon=0.3; //Lernzahl gewoehnlich zwischen 0.1 und 0.9
 double best_punkte=0;
 int ivarmax=1000000, anz_verbesserungen=0;
 for(int ivar=0;ivar<ivarmax;ivar++) //TODO
  {
   double summe_punkte=0;
   for(int j=0; lerndaten[j]!=10; j+=16)
    {
     eingabe_an_neuronen(&lerndaten[j]);
     propagieren();
     for(int i=0;i<NOUT;i++)
      {
       z[i]=AusgabeNeuronen[i].ausgabe();
      }
     //Bewertung von Resultat:
     soll=lerndaten[j+15];
     double punkte=0;
     for(int i=0;i<NOUT;i++)
      {
       if(i==soll) {punkte += z[i];}
       else punkte += (1.0-z[i]);
      }
     summe_punkte += punkte;
    }
   if(summe_punkte<best_punkte)
    {
     if(ivar%10000==0) printf(" ivar=%d Epsilon=%f summe_punkte=%f best_punkte=%f Verbesserung: schlechter - zurueckgenommen\n",ivar,Epsilon,summe_punkte,best_punkte);//test
     neuronen_zurueck();
    }
   else
    {
     if(summe_punkte>best_punkte)
      {
       if(ivar%10000==0) printf("ivar=%d Epsilon=%f summe_punkte = %f\n",ivar,Epsilon,summe_punkte);//test
       best_punkte = summe_punkte;
       anz_verbesserungen++;
       neuronen_speichern();
      }
     //Epsilon=zufall4()*0.8+0.1; //Zufallszahl zwischen 0.1 und 0.9
     Epsilon+=0.1; if(Epsilon>0.9) Epsilon=0.1;
     if(ivar!=ivarmax-1)
      for(int lernj=0; lerndaten[lernj]!=10; lernj+=16)
      {
       eingabe_an_neuronen(&lerndaten[lernj]);
       propagieren();
       //double summediff=0;
       for(int i=0;i<NOUT;i++)
	{double diff;
	 if(i==soll) diff=1.0-z[i];
	 else        diff=z[i];
	 double diff2 = diff*diff;
	 //summediff += diff2;
	 //Formel Seite 84: Deltaw2kj = Epsilon*vj*Hk
	 double vj;
	 if(i==soll) vj = diff2*z[i]; //vj = diff*z[i]*(1.0-z[i]);
	 else        vj = -diff2*(1.0-z[i]); //vj = -z[i]*z[i]*(1.0-z[i]);
	 Vj[i]=vj;
	 double delta=Epsilon*vj; //Hk wird erst in folgendem Aufruf beruecksichtigt
	 AusgabeNeuronen[i].backpropw2(delta,i);
	}
       //summediff *= 0.5; //entspricht E in Formel Seite 82 im Buch von Kaffka
       for(int k=0;k<NZWI;k++)
	{
	 double summe=0;
	 for(int j=0;j<NOUT;j++)
	  {
	   summe += Vj[j]*w2kj[k][j];
	  }
	 Sigmak[k] = summe*Hk[k]*(1.0-Hk[k]);
	}
       for(int k=0;k<NZWI;k++)
	{
	 double delta=Epsilon*Sigmak[k];
	 ZwischenNeuronen[k].backpropw1(delta);
	}
      }
    }
  }
 printf("best_punkte = %f\n",best_punkte);//test
}
#endif

static int mausmodus=0;
double maus_x1=0, maus_y1=0, maus_x2=0, maus_y2=0;

void mydrawmode(int mode)
{
 if(mode==COMPLEMENT)
   {//complement_farbe(PURPUR);
    rgbcolor(255, 0, 255);//Purpur
    drawmode(mode);
   }
 else
   {drawmode(mode);//wieder normaler Zeichnungsmodus
    //complement_farbe(0);
    rgbcolor(128,128,128);//Grau
   }
}

void m_position()
{
 int ok,sx=shiftx,sy=shifty;
 ok=requester_input(2,"Position X","%d","%d",&sx,
		      "Position Y","%d","%d",&sy);
 if(ok)
  {if(sx>=0 && sy>=0) {shiftx=sx; shifty=sy;}
   else printf("Eingabefehler: X und Y muessen groesser 0 sein\n");
  }
 m_refresh();
}

void maus_gedrueckt()
{
 double x,y; //dy,rand;
 int taste=mausposition(&x,&y);
 printf("maus_gedrueckt() taste=%d x=%lf y=%lf\n",taste,x,y);//test
 mausmodus=1; maus_x1=x; maus_y1=y;
 mydrawmode(COMPLEMENT);
}

void maus_bewegung()
{
 double x,y;
 //int taste=
 mausposition(&x,&y);
 //printf("maus_bewegung() tasten=%d x=%f y=%f\n",taste,x,y); //test
 if(mausmodus==1 && x!=maus_x1 && y!=maus_y1)
  {
   /*
   printf("maus_bewegung() taste=%d\n",taste);//test
   if(taste==LIMAUS) printf("LIMAUS\n");//test
   if(taste==REMAUS) printf("REMAUS\n");//test
   if(taste==MIMAUS) printf("MIMAUS\n");//test
   */
   if(maus_x2!=0 && maus_y2!=0)
    {
     drawbox(maus_x1,maus_y1,maus_x2,maus_y2); //altes Fadenkreuz loeschen
    }
   maus_x2=x; maus_y2=y;
   drawbox(maus_x1,maus_y1,maus_x2,maus_y2); //neues Fadenkreuz zeichnen
  }
}

void maus_losgelassen()
{
 double x,y;
 //int c;
 mausposition(&x,&y);
 printf("maus_losgelassen() x=%f y=%f\n",x,y); //test
 if(mausmodus==1)
  {
   if(maus_x2!=0 && maus_y2!=0)
    {
     drawbox(maus_x1,maus_y1,maus_x2,maus_y2); //altes Fadenkreuz loeschen
     printf("x1=%f y1=%f x2=%f y2=%f\n",maus_x1,maus_y1,maus_x2,maus_y2);//test
    }
   mausmodus=0; maus_x1=maus_y1=0; maus_x2=maus_y2=0;
   mydrawmode(JAM1);//wieder normaler Zeichnungsmodus
  }
}
