/* ifdeftest.cc			letzte Aenderung: 30.5.2014 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: #ifdef #else #endif Verschachtelung ueberpruefen
                   (und auch #if #elif #elseif, oder . statt #)

History:
30.5.2014	Erstellung (RP)
*/

#include <stdio.h>
//#include <iostream>
#include <stdlib.h>
#include <string.h>

/************************* Vordeklarationen ***************************/

/************************* Globale Variablen **************************/

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 1
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while((c= *s++)!=0)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Kleinkram ********************************/
int mygetline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s=0;
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/************** Klassen und Hauptteil des Programms *******************/
void leerstellen_loeschen(char *zeile)
{
 char *s;
 int c,n=0;
 for(s=zeile;(c= *s)==' ' || c=='\t';)
  {s++; n++;}
 if(n!=0)
  {
   while(*s!=0) *zeile++ = *s++;
   *zeile=0;
  }
}

void ausdrucken(const char *zeile,int versch)
{
 char txt[400], *s;
 int n=400;
 for(s=txt;versch>0 && n>0;) {*s++ = ' '; *s++ = ' '; n-=2; --versch;}
 if(n<=0) {printf("zu starke Verschachtelung\n"); return;}
 txt[400-1]=0;
 strncpy(s,zeile,n);
 printf("%s\n",txt);
}

/*
bool ist_if_else_endif(const char *zeile)
{
 int c= *zeile;
 if(c=='#' || c=='.')
  {
   if(strncmp(&zeile[1],"if ",3)==0) return true;
   if(strncmp(&zeile[1],"ifdef",5)==0) return true;
   if(strncmp(&zeile[1],"ifndef",6)==0) return true;
   if(strncmp(&zeile[1],"else",4)==0) return true;
   if(strncmp(&zeile[1],"elif",4)==0) return true;
   if(strncmp(&zeile[1],"elseif",6)==0) return true;
   if(strncmp(&zeile[1],"endif",5)==0) return true;
  }
 return false;
}
*/

bool ist_if(const char *zeile)
{
 int c= *zeile;
 if(c=='#' || c=='.')
  {
   if(strncmp(&zeile[1],"if ",3)==0) return true;
   if(strncmp(&zeile[1],"if(",3)==0) return true;
   if(strncmp(&zeile[1],"ifdef",5)==0) return true;
   if(strncmp(&zeile[1],"ifndef",6)==0) return true;
  }
 return false;
}

bool falsches_if(const char *zeile)
{
 if(ist_if(zeile)) return false;
 int c= *zeile;
 if(c=='#' || c=='.')
  {
   if(strncmp(&zeile[1],"if",2)==0) return true;
   if(strncmp(&zeile[1],"elsif",5)==0) return true;
  }
 return false;
}

bool ist_endif(const char *zeile)
{
 int c= *zeile;
 if(c=='#' || c=='.')
  {
   if(strncmp(&zeile[1],"endif",5)==0) return true;
  }
 return false;
}

bool ist_else_elif(const char *zeile)
{
 int c= *zeile;
 if(c=='#' || c=='.')
  {
   if(strncmp(&zeile[1],"else",4)==0) return true;
   if(strncmp(&zeile[1],"elif",4)==0) return true;
   if(strncmp(&zeile[1],"elseif",6)==0) return true;
  }
 return false;
}

bool ist_def_undef(const char *zeile)
{
 int c= *zeile;
 if(c=='#' || c=='.')
  {
   if(strncmp(&zeile[1],"def",3)==0) return true;
   if(strncmp(&zeile[1],"undef",5)==0) return true;
  }
 return false;
}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 char quellname[80];
 FILE *fp1;
 int i,j,c;
 quellname[0]=0;
 if(argc<=0)
  {/* es wurde von WorkBench (GUI, Desktop, ...) gestartet */
   //workbenchflag=1;
  }
 else
  {/* es wurde von Shell (Terminal, Konsole, ...) gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
	         //else if(j==2) strcpy(zielname,argv[i]);
	}	}
  }
 if(argflag['?'] || j>MAXARG)
	{printf("ifdeftest  %s\n",VERSION);
	 printf("Anwendung: ifdeftest [-Flags] Quelle [>Ziel]\n");
	 printf(" Flags: a = Alle Zeilen mit # oder . beginnend zeigen\n");
	 printf("        d = Zeilen mit #def oder #undef beginnend zeigen\n");
	 printf("            (statt # kann jeweils auch . stehen)\n");
	 exit(0);
	}
 if(*quellname==0) {printf("Quellname:"); scanf("%s",quellname);}
 if((fp1=fopen(quellname,"r"))==NULL)
   fprintf(stderr,"Datei \"%s\" nicht gefunden.\n",quellname);
 else
  {
   char zeile[200];
   int zeilennummer=1, verschachtelung=0;
   int fehler=0;
   while(mygetline(fp1,zeile,200))
    {
     leerstellen_loeschen(zeile);
     if(ist_if(zeile))
      {
       ausdrucken(zeile,verschachtelung);
       verschachtelung++;
      }
     else if(ist_else_elif(zeile))
      {
       ausdrucken(zeile,verschachtelung-1);
      }
     else if(ist_endif(zeile))
      {
       if(verschachtelung==0)
	{
	 ausdrucken(zeile,verschachtelung);
	 printf("Fehler in Zeile %d: zu viele #endif\n",zeilennummer);
	 fehler++;
	}
       else
	 ausdrucken(zeile,--verschachtelung);
      }
     else if(falsches_if(zeile))
      {
       ausdrucken(zeile,verschachtelung);
       printf("Fehler in Zeile %d: '%.6s' Syntaxerror\n",zeilennummer,zeile);
       printf("Korrekte Syntax: #if() #ifdef #ifndef #elif oder #elseif\n");
       fehler++;
      }
     else
      {
       if(argflag['A'] && (zeile[0]=='.' || zeile[0]=='#'))
	 ausdrucken(zeile,verschachtelung);
       else if(argflag['D'] && ist_def_undef(zeile))
	 ausdrucken(zeile,verschachtelung);
      }
     zeilennummer++;
    }
   if(verschachtelung!=0)
    {
     if(verschachtelung==1)
          printf("Fehler: fehlendes #endif\n");
     else printf("Fehler: %d fehlende #endif\n",verschachtelung);
     fehler++;
    }
   fclose(fp1);
   if(fehler>0)
     printf("total %d Fehler gefunden.\n",fehler);
   else printf("keine Fehler gefunden.\n");
  }
 return 0;
}/* ende von main */
