/* led_treiber.h                 letzte Aenderung: 29.8.2017
Version 0.1

Erstellt aus bas_treiber.h welches aus lcd_treiber.h erstellt wurde.
Erklaerungen siehe led_treiber.c
*/

//Falls mehrfach eingefuegt, dann nur erstes Mal machen:
#ifndef LED_TREIBER_H
#define LED_TREIBER_H

//------------------------------------------------------------------------------
//Hier Einstellungen fuers Zielsystem machen:

// Auswahl von Controller und Anschlussvariante:
//Genau eine der folgenden Zeilen nicht auskommentieren,
//oder dann im makefile entsprechend setzen:
//#define ATMEGA1284P

//------------------------------------------------------------------------------
#include <avr/io.h>
#include <stdio.h>

//------------------------------------------------------------------------------
// Auswahl der Funktionen:

//#define LINIENZEICHNEN   //zum Zeichnen von geraden Linien und Vierecken
//#define FIGURENFUELLEN   //zum Fuellen von z.B. Vierecken

#define FONTTABELLE      //fuer Schrift auf der Grafik-Anzeige
//#define UTF8ZEICHEN      //einige UTF8-Zeichen im Zeichensatz einfuegen
                         //(in led_print() und led_printc() benutzt)

                    // einer der beiden Fonts auswaehlen:
//#define FONT_8x5    // mit diesem sollten alle Zeichen gehen
#define FONT_5x3   // dieser geht nur fuer Zahlen gut

#define BILDPUFFER 0 //Wird nur bei LCD-Treiber gebraucht, fuer LED-Treiber auf 0 lassen
//Achtung: wenn nicht gebraucht nicht auskommentieren, sondern auf 0 setzen.

//Ende der Grundeinstellungen.
//------------------------------------------------------------------------------

typedef unsigned char uchar;
#ifndef uint
typedef unsigned int  uint;
typedef unsigned long ulong;
#endif

#ifndef __cplusplus
typedef int8_t bool;
#define false 0
#define true (0xFF)
#endif

//------------------------------------------------------------------------------
// Feste Werte fuer 128x64:
//#define BAS_MAXY 64  	// Anzahl der Pixel in Y-Richtung (0...63)
//#define BAS_MAXX 128 	// Anzahl der Pixel in X-Richtung (0...127)
// Feste Werte fuer 20x10:
#define LED_MAXY 10  	// Anzahl der Pixel in Y-Richtung
#define LED_MAXX 20 	// Anzahl der Pixel in X-Richtung

// Prototypen der verwendbaren Funktionen:
void ledSendData(uchar c);  // Daten senden um auf LED-Matrix darzustellen
void ledSendDataCur(uchar); // Daten senden und Cursor erhoehen
void led_cursor(uint8_t x,uint8_t y); // Setzen des Cursors (x horizontal 0..19, y vertikal 0..9)
uchar ledReadData();        // Liest ein Byte von Cursor-Position aus

#define WHITE 0  //Dunkles Pixel
#define BLACK 1  //Leuchtendes Pixel

#ifdef LINIENZEICHNEN
// Erlaubte Werte fuer Zeichnungsmodus:
#define JAM0  0      //Pixel auf 0 setzen, oder wenn eine Farbe gesetzt das Gegenteil
#define JAM1  1      //Pixel auf 1 setzen, oder wenn eine Farbe gesetzt dann diese
#define JAM2  2      //reserviert fuer FBAS
#define COMPLEMENT 3 //Pixelfabe umkehren

// Alternative Namen fuer Zeichnungsmodus:
#define MODE_NORMAL JAM1
#define MODE_REVERS JAM0
#define MODE_TOGGLE COMPLEMENT

void led_drawmode(int8_t mode);           //Zeichnungsmodus setzen: JAM0, JAM1, oder COMPLEMENT
void led_lineto(uint8_t x,uint8_t y);     //Linie vom aktuellen Cursor bis zur neuen Position zeichnen, ohne letzter Punkt
void led_lineto_last(uint8_t x,uint8_t y);//Linie vom aktuellen Cursor bis zur neuen Position inklusive letzter Punkt
void led_setzepunkt(uint8_t x,uint8_t y); //Einzelner Grafik-Punkt setzen
void led_drawbox(uint8_t x1,uint8_t y1,uint8_t x2,uint8_t y2); //Viereck zeichnen
//#ifdef FIGURENFUELLEN
//void led_fillbox(uint8_t x1,uint8_t y1,uint8_t x2,uint8_t y2); //gefuelltes Viereck zeichnen
//#endif
#endif

#ifdef FONTTABELLE

#define GROSSERFONT 1  //mit 1 normale Groesse (andere Werte machen hier keinen Sinn)

void led_print(const char *str);  // Text an aktueller Cursor-Position ausgeben
void led_printc(uchar c);         // Einzelnes Zeichen an aktueller Cursor-Position ausgeben
void setze_zeilenabstand(uint8_t); // Zeilenabstand bei mehrzeiligen Texten
void led_printb(uchar c);   // Schreibe ein Byte eines Buchstabens (von led_printc() benutzt)
                            // Oder allgemeiner: wie ledSendData() aber auch benutzbar mit y-Positionen
                            // die nicht durch 8 teilbar sind.
void led_printb_progmem(const uchar *b0);
void led_refresh(uchar jstart=0);  // Anzeige aktualisieren ab Zeile jstart
void led_clear();    // Text-Anzeige loeschen
void led_setfontcolor(uchar farbe);  // Farbe zum Text drucken setzen (default ist 7=WEISS)
uchar led_getfontcolor();            // eingestellte Farbe lesen 
#endif

//Ende von LED_TREIBER_H
#endif
