/* test2.cc       letzte Aenderung: 27.7.2014
Testprogramm fuer LED-Matrix mit 4 Modulen
*/
#define VERSION "0.0"
/*
 Prozessor: Atmega1284P, 20MHz Quarz
 Schaltung: ledmatrix.png
            4 Stueck so verschaltet:
	      jeweils mit allen verbunden: GND, +5V, MISO, TAKT
	      IN1 ist jeweils OUT von Rechts, IN2 ist OUT von Oben

 Autor: Rolf Pfister
 Copyright: Freeware

 History:
 27.7.2014	Erstellung aus test1.cc

*/
#define F_CPU 20000000UL

#include <avr/io.h>
//#include <avr/iom1284p.h>  //test
#include <avr/interrupt.h>
#include <avr/sleep.h>
#include <stdio.h>
//#include <stdlib.h>
//#include <math.h>
#include <string.h>
#include <ctype.h>
#include <util/delay.h>

//#define DEBUG  //zur Fehlersuche

/**** Vordeklarationen ****/
#define uchar uint8_t
#define uint uint16_t
#define ulong uint32_t

/**** Zeitbehandlung ****/
static volatile uint millisec=0;
static volatile uchar sec=0,min=0,stunden=0;
static volatile uchar tage=20,monat=7; //aktuelles Datum
static volatile uint jahr=2014;
static char monatstage[13]={31,31,28,31,30,31,30,31,31,30,31,30,31};
static volatile char wochentag=6; //0=Montag ... 6=Sonntag
static volatile char sommerzeit=1; //0=Winterzeit 1=Sommerzeit

void schaltjahrtest()
{
 if(jahr%4==0 && (jahr%100!=0 || jahr%400==0)) monatstage[2]=29;
 else monatstage[2]=28;
}
void wochentagberechnen()
{
 int j=jahr-2001,t,m;
 t=j*365+j/4-j/100+j/400+tage+6;
 for(m=1;m<monat;m++) t+=monatstage[m];
 wochentag=t%7;
}
void schaltjahr_und_wochentagberechnen()
{
 schaltjahrtest();
 wochentagberechnen();
 //variable_feiertage_berechnen();
}

/** Feiertage: ** /
const char NFEST=6;//Anzahl feste Feiertage
const char festfeiertag[NFEST]={1, 2, 1, 1, 25, 26};
const char festfeiermon[NFEST]={1, 1, 5, 8, 12, 12};
const char NVARI=4;//Anzahl von Ostern abhaengige Feiertage
static char varifeiertag[NVARI];
static char varifeiermon[NVARI];
void variable_feiertage_berechnen()
{
 int a,b,c,k,p,q,M,N;
 char d,e,tag,i;
 const char mon=3;
 //Osterformel nach Gauss:
 a=jahr%19;
 b=jahr%4;
 c=jahr%7;
 k=jahr/100;
 p=(8*k+13)/25;
 q=k/4;
 M=(15+k-p-q)%30;
 N=(4+k-q)%7;
 d=(19*a+M)%30;
 e=(2*b+4*c+6*d+N)%7;
 tag=22+d+e;
 varifeiertag[0]=tag+1; varifeiermon[0]=mon; //Ostermontag
 varifeiertag[1]=tag-2; varifeiermon[1]=mon; //Karfreitag
 varifeiertag[2]=tag+39; varifeiermon[2]=mon; //Auffahrt
 varifeiertag[3]=tag+50; varifeiermon[3]=mon; //Pfingstmontag
 for(i=0;i<NVARI;i++)
   while(varifeiertag[i]>monatstage[varifeiermon[i]])
    {varifeiertag[i] -= monatstage[varifeiermon[i]]; varifeiermon[i]++;}
}

bool istfeiertag()
{
 char i;
 for(i=0;i<NFEST;i++)
   if(tage==festfeiertag[i] && monat==festfeiermon[i]) return true;
 for(i=0;i<NVARI;i++)
   if(tage==varifeiertag[i] && monat==varifeiermon[i]) return true;
 return false;
}
/ **/

// Quarz moeglichst genau ausmessen und hier eintragen:
const ulong Hz=20000000; //exakt 20MHz

#define Rest1 (Hz%1000) //jede Sekunde zu korrigierender Fehler
#define NormalerCompwert (Hz/1000-1)

void timer1_init()
{
 TCCR1B = (1<<WGM12)|(1<<CS10); //CTC-OCR1A-Modus, Prescaler=1
 OCR1A = NormalerCompwert;
 TCNT1 = 0; //Startwert des Timers
 TIMSK1 = 1<<OCIE1A; //Timer1 Interrupts bei Vergleichswert
}

ISR(TIMER1_COMPA_vect)
{
 uchar mehr;
 uint ms=millisec;
 if(++ms>=1000-Rest1) mehr=1; else mehr=0;
 sei();
 if(ms==1000)
  {ms=0; mehr=0;
   if(++sec==60)
    {sec=0;
     if(++min==60)
      {min=0;
       if(++stunden==24)
	{stunden=0; ++tage; //neuertag=1;
	 if(++wochentag==7) wochentag=0; 
	 if(tage>monatstage[monat])
	  {tage=1;
	   if(++monat==13) //Jahreswechsel
	     {monat=1; ++jahr; sei(); schaltjahrtest();
	      //variable_feiertage_berechnen();
	     }
	  }
	}
       else //Test auf Sommerzeit-Umschaltungen
	{if(sommerzeit==0)
	  {if(stunden==2 && monat==3 && wochentag==6 && tage>(31-7))
	    {sommerzeit=1; stunden++;} //am letzten Sonntag im Maerz
	  }
	 else //if(sommerzeit==1)
	  {if(stunden==3 && monat==10 && wochentag==6 && tage>(31-7))
	    {sommerzeit=0; --stunden;} //am letzten Sonntag im Oktober
	  }
	}
      }
    }
  }
 //else if((ms&0x0F)==1) {}//etwa alle 16ms
 //else if((ms&0xFF)==0xE7) {}//alle ca 250ms
 millisec=ms;
 OCR1A=NormalerCompwert+mehr;
 //tastaturcheck();
}

void milliwait(int n) //n Millisekunden warten 1000 >= n >= 1
{
 uint ms;
 cli(); ms=millisec; sei();
 while(ms==millisec) ;//auf 1. Millisekunde warten
 if((ms+=n)>=1000) ms-=1000;
 while(ms!=millisec || ms!=millisec) //zweimal lesen um cli() sei() zu sparen
   ;//auf n. Millisekunde warten
}

void secwait(uchar n) //n Sekunden warten
{
 while(n!=0) {milliwait(1000); --n;}
}

void microwait(uchar n) //mindestens n Microsekunden warten
{
 while(--n!=0) _delay_us(1);
}

/***************************** Timer0 fuer LED-Anzeige ********************************/
static volatile uchar ledfeld[5][10]; // 5 Reihen, 10 Spalten
void ledfeld_init(uchar n)
{
 uchar i,j;
 for(i=0;i<5;i++)
  for(j=0;j<10;j++)
    ledfeld[i][j]=n; //alle gleich setzen
}

void timer0_init()
{
 TCCR0A = (0<<WGM01)|(0<<WGM00); //Normal-Modus, Interrupt bei Ueberlauf (8 Bit, also Teiler durch 256)
 //TCCR0A = (1<<WGM01)|(0<<WGM00); //CTC-Modus, Interrupt bei Erreichen von OCRA
 //TCCR0B = (1<<CS00); //Takt nicht teilen
 TCCR0B = (1<<CS01); //Takt durch 8teilen
 TCNT0 = 0;
 TIMSK0 = (1<<TOIE0); //Interrupt bei Ueberlauf
 //TIMSK0 = (1<<OCIE0A); //Interrupt bei Erreichen von OCRA
}

ISR(TIMER0_OVF_vect)
{
 static uchar spalte=0;
 uchar b,c,d,tmp2,tmp3;
 bool flag;
 tmp2 = (~ledfeld[2][spalte])&7;
 tmp3 = (~ledfeld[3][spalte])<<3;
 //PORTB |= 0x0F; PORTC |= 0x7F; PORTD = 0xFF;//test
 b = ((~ledfeld[4][spalte])&7) | (tmp3&0x08);
 c = (((~ledfeld[0][spalte])&7)<<4) | (((~ledfeld[1][spalte])&7)<<1) | (tmp2>>2);
 d = ((tmp2&3)<<6) | (tmp3&0x30);
 flag = (b!=0x0F) || (c!=0x7F) || (d!=0xF0);
 PORTD |= 3; PORTA = 0xFF; //alle Transistoren aus
 PORTB = (PORTB&0xF0) | b;
 PORTC = (PORTC&0x80) | c;
 PORTD = 0x0F | d;
 if(flag) //nur wenn auch mindestens eine LED an:
  switch(spalte) //entsprechender Transistor einschalten
   {
    case 0: PORTD &= ~(1<<1); break;
    case 1: PORTD &= ~(1<<0); break;
    case 2: PORTA &= ~(1<<7); break;
    case 3: PORTA &= ~(1<<6); break;
    case 4: PORTA &= ~(1<<5); break;
    case 5: PORTA &= ~(1<<4); break;
    case 6: PORTA &= ~(1<<3); break;
    case 7: PORTA &= ~(1<<2); break;
    case 8: PORTA &= ~(1<<1); break;
    case 9: PORTA &= ~(1<<0); break;
   }
 if(++spalte==10) spalte=0;
 //if(spalte==0) spalte=9; else --spalte;//test
}

/************************ Datenuebertragung zwischen den Modulen **********************/
#define MISO_DDR  DDRB
#define MISO_PORT PORTB
#define MISO_PIN  PINB
#define MISOBIT 6
#define TAKT_DDR  DDRB
#define TAKT_PORT PORTB
#define TAKT_PIN  PINB
#define TAKTBIT 7

/* Der Master sendet einen TAKT und auf MISO jeweils 8 Bits, steigende Flanke von
   TAKT soll das Bit in MISO uebernehmen.
   Erstes gesendetes Byte ist Modulnummer, dann 1 Byte j, 1 Byte i, und 1 Byte Datenwert.
 */
bool masterflag=false; //darf nur in erstem Modul gesetzt werden
uchar modulnummer=0; //gueltige Nummern: 1...4, 0=noch nicht gesetzt

void byte_senden(uchar c)
{
 uchar i;
 for(i=0;i<8;c<<=1,i++)
  {
   if(c&0x80) MISO_PORT |= (1<<MISOBIT);
   else       MISO_PORT &= ~(1<<MISOBIT);
   TAKT_PORT &= ~(1<<TAKTBIT);
   microwait(20);
   TAKT_PORT |= (1<<TAKTBIT);
   microwait(20);
  }
}

void daten_senden(uchar nummer,uchar j,uchar i,uchar wert)
{
 byte_senden(nummer);
 byte_senden(j);
 byte_senden(i);
 byte_senden(wert);
}

bool byte_empfangen(uchar& c)
{
 uchar i,bit;
 int timeout=0;
#define TIMEOUT 1000
 c=0;
 for(i=0;i<8;i++)
  {
   while(TAKT_PIN&(1<<TAKTBIT)) //warten bis Low
     {_delay_us(1); if(++timeout>=TIMEOUT) return false;} //Fehler bei Timeout
   while((TAKT_PIN&(1<<TAKTBIT))==0) ;//warten auf High
   bit = (MISO_PIN&(1<<MISOBIT))==0 ? 0 : 1;
   c = (c<<1)+bit;
  }
 return true;
}

void daten_empfangen()
{
 uchar n,i,j,wert;
 if(!byte_empfangen(n)) return; //Rueckkehr bei Fehler
 if(!byte_empfangen(j)) return;
 if(!byte_empfangen(i)) return;
 if(!byte_empfangen(wert)) return;
 if(n==modulnummer)
   ledfeld[j][i]=wert;
}

/*************************** Serielle Schnittstelle ***********************************/
#ifndef F_CPU
#warning "F_CPU war noch nicht definiert, wird nun nachgeholt mit 16000000"
#define F_CPU 20000000UL  // Systemtakt in Hz - Definition als unsigned long
                         // Ohne ergeben sich unten Fehler in der Berechnung
#endif
 
#define BAUD 9600UL      // Baudrate
 
// Berechnungen
#define UBRR_VAL ((F_CPU+BAUD*8)/(BAUD*16)-1)   // clever runden
#define BAUD_REAL (F_CPU/(16*(UBRR_VAL+1)))     // Reale Baudrate
#define BAUD_ERROR ((BAUD_REAL*1000)/BAUD) // Fehler in Promille, 1000=kein Fehler

#if ((BAUD_ERROR<990) || (BAUD_ERROR>1010))
  #error Systematischer Fehler der Baudrate groesser 1% und damit zu hoch! 
#endif

void uart1_init()
{
 UBRR1 = UBRR_VAL;
 //UCSR1B = (1<<RXEN1)|(1<<TXEN1); // UART TX und RX einschalten
 UCSR1B = (1<<RXEN1); // UART RX einschalten
 UCSR1C = (3<<UCSZ10); // Asynchron 8N1 Atmega644
}

void uart_putc(unsigned char c)
{
 while (!(UCSR1A & (1<<UDRE1))) ;// warten bis Senden moeglich
 UDR1 = c;                      // sende Zeichen
}

unsigned char uart_getc(void)
{
 while (!(UCSR1A & (1<<RXC1))) ;// warten bis Zeichen verfuegbar
 return UDR1; // Zeichen aus UDR an Aufrufer zurueckgeben
}

bool uart_check()
{
 return (UCSR1A & (1<<RXC1)) ;//true wenn Zeichen verfuegbar
}

/********************************** Hauptprogramm *************************************/
// Master ist das Modul oben links
static volatile uchar ledfeld2[5][10]; //Modul oben rechts
static volatile uchar ledfeld3[5][10]; //Modul unten links
static volatile uchar ledfeld4[5][10]; //Modul unten rechts

void gesamtes_ledfeld_setzen(uchar j,uchar i,uchar wert) //nur von Master aufrufen
{
 if(j>=5)
  {
   if(i>=10)
    {
     ledfeld4[j-5][i-10]=wert;
     daten_senden(4,j-5,i-10,wert);
    }
   else
    {
     ledfeld3[j-5][i]=wert;
     daten_senden(3,j-5,i,wert);
    }
  }
 else if(i>=10)
  {
   ledfeld2[j][i-10]=wert;
   daten_senden(2,j,i-10,wert);
  }
 else
  ledfeld[j][i]=wert;
}

int main(void)
{
 uchar i,j,c;

 PORTA = 0xFF; //PortA alle auf High fuer inaktiv (P-Chann-Transistoren)
 PORTD = 0x0F; //PortD: unterste 2 Bits High fuer inaktiv (P-Chann-Transistoren),
               //       INT0-INT1 Pullup-Widerstaende fuer Tasten setzen
 DDRA = 0xFF; //PortA alles Ausgaenge
 DDRD = 0xF3; //PortD alle ausser INT0-INT1 auf Ausgang
 DDRB = 0x0F; //PortB untere 4 Bits auf Ausgang
 DDRC = 0xFF; //PortC alles Ausgaenge
 PORTB = 0xFF; //alle Ausgaenge inaktiv, Eingaenge Pullups setzen
 PORTC = 0x7F; //Ausgaenge fuer LEDs inaktiv, OUT auf aktiv low

 timer0_init();
 timer1_init();
 ledfeld_init(0);
 sei(); //Interrupt einschalten

 milliwait(10); //warten bis andere Module auch bereit
 c=(PINB&0x30); //Status der Eingaenge lesen
 switch(c)
  {
   case 0x00: modulnummer=3; break;
   case 0x10: modulnummer=4; break;
   case 0x20: masterflag=true; modulnummer=1; break;
   case 0x30: modulnummer=2; break;
  }

 if(masterflag) c=7; //weiss fuer Modul oben links
 else {c=modulnummer-1; if(c==3) c=4;} //rot, gruen, blau fuer die andern Module
 for(j=0;j<5;j++)
 for(i=0;i<10;i++)
  {
   ledfeld[j][i]=c; //alle LEDs nacheinander setzen
   milliwait(100);
  }

 for(j=0;j<5;j++)
 for(i=0;i<10;i++)
  {
   ledfeld[j][i]=0; //alle LEDs nacheinander wieder loeschen
   milliwait(100);
  }

 //test: einige LEDs setzen:
 ledfeld[1][9] = 1; //rot
 ledfeld[1][8] = 2; //gruen
 ledfeld[1][7] = 4; //blau
 ledfeld[1][6] = 3; //gelb
 ledfeld[1][5] = 5; //purpur
 ledfeld[1][4] = 6; //cyan
 secwait(3);

 if(!masterflag) //andere Module nur Daten vom Master empfangen
  {
   for(;;)
    {
     if((TAKT_PIN&(1<<TAKTBIT))==0) //warten bis Start einer Datenuebertragung
       daten_empfangen();
    }
  }

 //Aktionen fuer den Master:
 uart1_init(); //Serielle Schnittstelle (UART) fuer Tastatur und ev. fuer Video-Ausgabe
 milliwait(100); //warten bis andere Module bereit

 TAKT_DDR |= (1<<TAKTBIT);
 MISO_DDR |= (1<<MISOBIT);
 c=2; //gruen
 for(j=0;j<10;j++)
 for(i=0;i<20;i++)
  {
   gesamtes_ledfeld_setzen(j,i,c); //alle LEDs nacheinander setzen
   //milliwait(50);
  }

 while(1) //Hauptschlaufe
  {//int altsec=0;
   /*
   PORTC = (sec<<4)^0x70; //Sekunden auf erster RGB-LED anzeigen
   PORTA &= ~(1<<0); //Transistor Q1 ein
   milliwait(1);
   PORTA |= (1<<0); //Transistor Q1 aus
   PORTC = (min<<4)^0x70; //Minuten auf 2. RGB-LED anzeigen
   PORTA &= ~(1<<1); //Transistor Q2 ein
   milliwait(1);
   PORTA |= (1<<1); //Transistor Q2 aus
   milliwait(8);
   */
   ledfeld[1][9] = sec&0x07;
   ledfeld[1][8] = min&0x07;
   ledfeld[1][7] = stunden&0x07;
   if(uart_check())
    {
     c=uart_getc();
     uchar loslassflag=c&0x80;
     c &= 0x7F;
     for(i=0;i<5;i++)
      {
       for(j=0;j<5;j++)
	{
	 if(--c < 'A') break;
	}
       if(c<'A') break;
      }
     if(loslassflag)
       ledfeld[i][j]=0; //entsprechende LED aus
     else
       ledfeld[i][j]=1; //entsprechende LED auf Rot setzen
    }
  }//Ende Hauptschlaufe
 return 0;//wird nie erreicht
}
