/* tast5x5.cc       letzte Aenderung: 1.8.2014
Matrixtastatur 5 mal 5, bei Tastendruck ueber UART senden
*/
#define VERSION "0.0"
/*
 Prozessor: ATtiny2313, 16MHz Quarz
 Schaltung: tast5x5.png

 Autor: Rolf Pfister
 Copyright: Freeware

 History:
 31.7.2014	Erstellung

*/
#define F_CPU 16000000UL
#include <avr/io.h>
#include <util/delay.h>
//#include <avr/interrupt.h>
//#include <avr/sleep.h>
#include <stdio.h>
//#include <stdlib.h>
#include <string.h>
#include <ctype.h>

//#define DEBUG  //zur Fehlersuche

/**** Vordeklarationen ****/
#define uchar uint8_t
#define uint uint16_t

/*************************** Serielle Schnittstelle ***********************************/
#ifndef F_CPU
#warning "F_CPU war noch nicht definiert, wird nun nachgeholt mit 16000000"
#define F_CPU 16000000UL  // Systemtakt in Hz - Definition als unsigned long
                         // Ohne ergeben sich unten Fehler in der Berechnung
#endif
 
#define BAUD 9600UL      // Baudrate
 
// Berechnungen
#define UBRR_VAL ((F_CPU+BAUD*8)/(BAUD*16)-1)   // clever runden
#define BAUD_REAL (F_CPU/(16*(UBRR_VAL+1)))     // Reale Baudrate
#define BAUD_ERROR ((BAUD_REAL*1000)/BAUD) // Fehler in Promille, 1000=kein Fehler

#if ((BAUD_ERROR<990) || (BAUD_ERROR>1010))
  #error Systematischer Fehler der Baudrate groesser 1% und damit zu hoch! 
#endif

void uart_init()
{
 UBRRH = (UBRR_VAL>>8);
 UBRRL = (UBRR_VAL&0xFF);
 //UCSRB = (1<<RXEN)|(1<<TXEN); // UART TX und RX einschalten
 UCSRB = (1<<TXEN); // UART TX einschalten
 //UCSRC = (1<<USBS)|(3<<UCSZ0); // Asynchron 8N2
 UCSRC = (3<<UCSZ0); // Asynchron 8N1
}

void uart_putc(unsigned char c)
{
 while (!(UCSRA & (1<<UDRE))) ;// warten bis Senden moeglich
 UDR = c;                      // sende Zeichen
}

/*
char uart_getc(void)
{
 while (!(UCSRA & (1<<RXC))) ;// warten bis Zeichen verfuegbar
 return UDR; // Zeichen aus UDR an Aufrufer zurueckgeben
}
*/

/********************************** Hauptprogramm *************************************/
uchar tasten_check()
{
 uchar i,j,jmask,imask;
 for(j=0,jmask=0x40;j<5;j++,jmask>>=1) //Spaltenzaehler
     {
      PORTD &= ~jmask; //entsprechendes Bit auf Low
      _delay_ms(1); //1 Millisekunde warten
      imask = PINB&0x1F;
      PORTD |= jmask; //entsprechendes Bit wieder auf High
      switch(imask)
       {
        case 0x0F: i=1; break;
        case 0x17: i=6; break;
        case 0x1B: i=11; break;
        case 0x1D: i=16; break;
        case 0x1E: i=21; break;
        default: i=0;
       }
      if(i!=0) return j+i;
     }
 return 0;
}

uchar tasten_tabelle[5*5] =
 {
  'A','B','C','D','E',
  'F','G','H','I','J',
  'K','L','M','N','O',
  'P','Q','R','S','T',
  'U','V','W','X','Y'
 };

int main(void)
{
 uchar c0=0,c1,c2;
 PORTB = 0x1F; //PortB alles Eingaenge, Pullup-Widerstande fuer untere 5 Bits gesetzt
 DDRD = 0x7C; //PortD Bits 2 bis 6 auf Ausgang
 PORTD = 0x7C; //und auf High fuer inaktiv
 uart_init();
 //sei(); //Interrupt einschalten

 while(1) //Hauptschlaufe
  {
   c1=tasten_check();
   _delay_ms(1);
   c2=tasten_check();
   if(c1==c2 && c1!=c0)
      {
       if(c1!=0) uart_putc(tasten_tabelle[c1-1]); //Taste gedrueckt
       else uart_putc(tasten_tabelle[c0-1] | 0x80); //Taste losgelassen
       c0=c1;
      }
  }//Ende Hauptschlaufe
 return 0;//wird nie erreicht
}
