/* lichteraus.cc			letzte Aenderung: 2.2.2012 */
#define VERSION "Version 0.1"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Spiel aehnlich lightsoff oder lightsout

History:
22.1.2012       Erstellung (RP)
28.1.           Zufallszahlen jetzt initialisiert damit nicht jedes Mal gleich Folge kommt.
                Bei Zufallsklick vermeiden von mehrmals Klick auf gleiches Feld.
2.2.            Stellungen speichern und laden

bisher benoetigte Zeit: ca. 5 Std.


Noch zu machen:
 - Nach level 25 eventuell Feld vergroessern

*/

#include <stdio.h>
//#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <xtekplot1.h>

#define XMAX 640
#define YMAX 512
#define TIEFE 8

/************************* Vordeklarationen ***************************/
void alles_zeichnen();
void neuer_level(int n);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Kleinkram ********************************/
double zufall4()	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* bisher bester Zufallsgenerator   */
 static double x=581;
 double y;
 if(x==0.) x=581;
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}

double zufall5(int start=0)
{
 static int flag=1;
 if(flag!=0 || start!=0)
  {time_t t;
   time(&t);
   srand(t);
   flag=0;
  }
 return (1.0 - rand()/(double)RAND_MAX);
}

#define zufallszahl zufall5

/************************* Menu Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}
void m_load();
void m_save();
void m_level();
void m_hilfe();

static int level=1;

void m_level()
{
 int ok,neulevel=level;
 ok=requester_input(1,"Level:","%d","%d",&neulevel);
 if(ok) neuer_level(neulevel);
}

void m_hilfe()
{
 janeinrequester("Das Ziel dieses Spiels ist es alle Lichter zu loeschen.\n\
Die Schwierigkeit dabei ist, dass wenn man ein Licht ein- oder aus-schaltet\n\
die benachbarten Lichter auch ihren Zustand wechseln.");
}

/************************** Hauptklasse *******************************/
typedef unsigned char int8;

//globale Variablen:
const int br=(YMAX-112)/5;  //Breite pro Licht
const int bx=(XMAX-5*br)/2; //Breite Linker Rand
static int by=20; //Breite Oberer Rand
static int level_erfolgreich=0; //Wird gesetzt wenn Level in minimalen Anzahl Klicks geloest wurde
static int anzahl_klicks=0; //Anzahl benoetigte Klicks

class Spielfeld
{
public:
 int8 feld[25];
 void init() {for(int i=0;i<25;i++) feld[i]=0;}
 void zeichnen();
 void klick(int i,int j);
 void zufallsklick(int8 *klickfeld);
 void kopieren(Spielfeld&);
 bool istfertig();
};

bool ist_innerhalbspielfeld(int x,int y)
{
 return (x>bx && x<bx+5*br && y>by && y<by+5*br);
}

void Spielfeld::kopieren(Spielfeld& z)
{
 for(int i=0;i<25;i++) feld[i]=z.feld[i];
}

bool Spielfeld::istfertig()
{
 for(int i=0;i<25;i++)
  if(feld[i]!=0) return false;
 return true;
}

void Spielfeld::zeichnen()
{
 int i,j,k, by2=get_menuleistenhoehe()+40, bx2=bx+br/2, r=30;
 by=by2-br/2;
 //printf("Testpunkt1: by=%d by2=%d\n",by,by2);//test
 for(k=0,j=0;j<5;j++)
  for(i=0;i<5;i++,k++)
   {
    if(feld[k]==0) idrawcircle(bx2+br*i,by2+br*j,r,r);
    else ifillcircle(bx2+br*i,by2+br*j,r,r);
   }
}

void Spielfeld::klick(int i,int j)
{
 feld[j*5+i] ^= 1;
 if(i>0) feld[j*5+i-1] ^= 1;
 if(i<4) feld[j*5+i+1] ^= 1;
 if(j>0) feld[(j-1)*5+i] ^= 1;
 if(j<4) feld[(j+1)*5+i] ^= 1;
}

void Spielfeld::zufallsklick(int8 *klickfeld)
{
 int i,j;
 do
  {i=int(zufallszahl()*5); if(i==5) i=4;
   j=int(zufallszahl()*5); if(j==5) j=4;
  }
 while(klickfeld[j*5+i]!=0);
 klickfeld[j*5+i]=1;
 klick(i,j);
}

static Spielfeld spielfeld,startstellung;

const int zeilenabstand=20;
const int buchstabenbreite=zeilenabstand/2;
const int buchstabenhoehe=zeilenabstand*3/4;
static char anzeigetext1[80],anzeigetext2[80];

void texte_zeichnen(const char *text1=NULL,const char *text2=NULL)
{
 int y1=get_menuleistenhoehe()+40+5*br+zeilenabstand;
 static bool startflag=true;
 if(startflag)
  {
   itextsize(buchstabenbreite,buchstabenhoehe);
   startflag=false;
  }
 if(text1!=NULL) strncpy(anzeigetext1,text1,80);
 if(text2!=NULL) strncpy(anzeigetext2,text2,80);
 ischrift(bx-br/2,y1,anzeigetext1);
 ischrift(bx-br/2,y1+zeilenabstand,anzeigetext2);
}

void knopf_zeichnen()
{
 int x1=bx+br*5, y1=by+5*br;
 int x2=x1+br, y2=y1+buchstabenhoehe+10;
 idrawbox(x1,y1,x2,y2);
 ischrift(x1+buchstabenbreite,y1+buchstabenhoehe+5,"Restart"); //Nochmals-Knopf
 y1 += zeilenabstand*2;
 y2 += zeilenabstand*2;
 idrawbox(x1,y1,x2,y2);
 ischrift(x1+buchstabenbreite*3,y1+buchstabenhoehe+5,"Next"); //Weiter-Knopf
}

bool ist_innerhalb_nochmalsknopf(int x,int y)
{
 int x1=bx+br*5, y1=by+5*br;
 int x2=x1+br, y2=y1+buchstabenhoehe+10;
 return (x>x1 && x<x2 && y>y1 && y<y2);
}

bool ist_innerhalb_nextknopf(int x,int y)
{
 int x1=bx+br*5, y1=by+5*br+zeilenabstand*2;
 int x2=x1+br, y2=y1+buchstabenhoehe+10+zeilenabstand*2;
 return (x>x1 && x<x2 && y>y1 && y<y2);
}

void neuer_level(int n)
{
 int8 klickfeld[25];
 int i;
 if(n>25) n=25;
 level=n;
 sprintf(anzeigetext1,"Level %d ",n);
 if(n==0) sprintf(anzeigetext2,"Uebungslevel");
 else if(n==1) sprintf(anzeigetext2,"Laesst sich mit 1 Klick ausschalten.");
 else if(n<=6) sprintf(anzeigetext2,"Sollte sich mit %d Klicks ausschalten lassen.",n);
 else sprintf(anzeigetext2,"Sollte sich mit %d Klicks oder weniger ausschalten lassen.",n);
 spielfeld.init();
 for(i=0;i<25;i++) klickfeld[i]=0;
 for(i=0;i<n;i++) spielfeld.zufallsklick(klickfeld);
 startstellung.kopieren(spielfeld);
 alles_zeichnen();
}

void alles_zeichnen()
{
 inital_new();
 screenclear();
 spielfeld.zeichnen();
 texte_zeichnen();
 knopf_zeichnen();
 term_refresh();
}

void maus_gedrueckt()
{
 int x,y;
 imausposition(&x,&y);
 if(ist_innerhalb_nochmalsknopf(x,y))
  {
   spielfeld.kopieren(startstellung);
   anzahl_klicks=0;
   alles_zeichnen();
  }
 else if(ist_innerhalb_nextknopf(x,y))
  {
   if(level_erfolgreich!=0) neuer_level(level+1);
   else                     neuer_level(level);
   anzahl_klicks=0;
   level_erfolgreich=0;
  }
 else if(ist_innerhalbspielfeld(x,y))
  {
   int i,j;
   i=(x-bx)/br; if(i>=5) i=4;
   j=(y-by)/br; if(j>=5) j=4;
   spielfeld.klick(i,j);
   anzahl_klicks++;
   if(spielfeld.istfertig())
    {
     if(anzahl_klicks<=level)
      {
       level_erfolgreich=1;
       sprintf(anzeigetext1,"Bravo, Level %d geloest mit %d Klicks.",level,anzahl_klicks);
       sprintf(anzeigetext2,"Druecke Next fuer naechsten Level");
      }
     else
      {
       sprintf(anzeigetext1,"Level %d geloest mit %d Klicks.",level,anzahl_klicks);
      }
    }
   alles_zeichnen();
  }
}

void maus_losgelassen()
{
 
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 int i,j,c;
 int breite,hoehe,tiefe,visklasse;
 double xmin= -0.125,ymin=0.,xmax=1.125,ymax=1.;
 if(argc<=0)
   ;/* es wurde von WorkBench gestartet */
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 //else	{if(++j==1) strcpy(quellname,argv[i]);
	 //	 else if(j==2) strcpy(zielname,argv[i]);}
	}
 if(argflag['?'] || j>MAXARG)
	{printf("lichteraus  %s\n",VERSION);
	 printf("Anwendung: lichteraus\n");
	 exit(0);
	}
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 setsize(breite,hoehe,tiefe);
 setmenu(3,"File",  "Play",   "Help");
 setmenu(3,"Load..","Level..","Hilfe",&m_load,&m_level,&m_hilfe);
 setmenu(1,"Save..",&m_save);
 setmenu(1,"Exit",&menu_exit);
 set_funktions(maus_gedrueckt,maus_losgelassen,NULL,NULL);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 spielfeld.init();
 spielfeld.zeichnen();
 knopf_zeichnen();
 term_refresh();
 neuer_level(1);
 while(exitflag==0 && waitmenu(1)==0) //auf Benutzereingaben warten
  {
  }
 term_exit();
 return 0;
}/* ende von main */

/** Dateien laden und speichern: **/
void m_load()
{
 char name[80]="";
 int ok=nachfilenamefragen("Lade neue Stellung",name,80);
 if(ok)
  {
   int n,k;
   FILE *fp=fopen(name,"r");
   if(fp==NULL) {janeinrequester("Kann Datei nicht oeffnen."); return;}
   for(int i=0;i<25;i++)
    {n=fscanf(fp,"%d",&k);
     //if(n!=1) fehler
     startstellung.feld[i]=k;
    }
   spielfeld.kopieren(startstellung);
   anzahl_klicks=0;
   alles_zeichnen();
  }
}

void m_save()
{
 char name[80]="neu.txt";
 int ok=nachfilenamefragen("Speichere Stellung",name,80);
 if(ok)
  {
   FILE *fp=fopen(name,"r");
   if(fp!=NULL)
    {int nein;
     fclose(fp); nein=janeinrequester("Datei schon vorhanden. Wirklich ueberschreiben?","nein","ja");
     if(nein) return;
    }
   fp=fopen(name,"w");
   if(fp==NULL) janeinrequester("Kann Datei nicht speichern.");
   else
    {
     for(int i=0;i<25;i++)
      {
       fprintf(fp,"%d",spielfeld.feld[i]);
       if(i%5==4) fprintf(fp,"\n"); else fprintf(fp," ");
      }
     fclose(fp);
    }
  }
}
