/* lcduhr.cc       letzte Aenderung: 19.9.2009
Uhr mit Lichtwecker
 Version: 0.0
 Prozessor: Atmega32
 Schaltung: lcduhr.gif
            fuer ersten Test: nur D5,D6,D7 mit 3 LEDs verbinden
 Autor: Rolf Pfister
 Copyright: Freeware
 History:
 3.7.2009	Erstellung

LCD-Anzeige
-----------
eine 3 1/2 stellige LCD-Anzeige direkt an die PORTS angeschlossen:
    C7=3DP, C4=3E, C3=3D, C2=3C, B7=2DP, B4=2E, B3=2D, B2=2C,
    A7=Pin2, A4=1E, A3=1D, A2=1C, A1=1B, A0=1A, A5=1F, A6=1G,
    B1=2B, B0=2A, B5=2F, B6=2G, (B7)=Pin28, C1=3B, C0=3A, C5=3F,
    C6=3G, (D2)=Pin38, (D2)=Pin39, D4=Pin3, (D1)=1DP, D3=COM.
  (in Klammern gesetzt: optional anschliessbar, im Schema als Widerstand)
  Dabei ist COM (Pin1) der gemeinsame GND der Anzeige. Dieser darf nicht
  direkt mit GND verbunden sein weil die Anzeige einen Polaritaetswechsel
  mit etwa 20Hz haben sollte.  A-F sind die 7 Segmente der Ziffern:
    A
  +----+    1 ist Ziffer ganz rechts, DP ist jeweils Punkt links der Ziffer.
  |    |    2 ist zweite Ziffer von rechts
 F| G  |B   Pin28 ist in aktuller LCD nicht belegt. Andere Typen haben hier
  +----+    einen Doppelpunkt links der Ziffer2.
  |    |    Pin38 = Over
 E|    |C   Pin39 = - (Minuszeichen)
  +----+    Pin3  = Segmente A+B der 4.Ziffer (Darstellung der fuehrenden 1)
    D       Pin2  = Batt

*/
#include <avr/io.h>
#include <avr/interrupt.h>
#include "ulong.h"

/**** Zeitbehandlung ****/
static volatile uint millisec=0;
static volatile uchar sec=0,min=19,stunden=6;
static volatile uchar tage=19,monat=9;
static volatile uint jahr=2009;
static char monatstage[13]={0,31,28,31,30,31,30,31,31,30,31,30,31};

void schaltjahrtest()
{
 if(jahr%4==0 && jahr%100!=0 || jahr%400==0) monatstage[2]=29;
 else monatstage[2]=28;
}

// Quarz moeglichst genau ausmessen und hier eintragen
// in Hertz und Tausendstel Hertz:

const ulong Hz=16000000,MilliHz=0; //exakt 16MHz
//Beispiel: 16MHz ist nach n Tagen z sec vorgegangen:
//nach n Tagen sind also 16000000*(3600*24*n+z) Takte vergangen
//Frequenz ist also:
// x = (3600*24*n+z)*16000000 / (3600*24*n)
//   = 16000000 + z*16000000/(3600*24*n)
//const ulong Hz=16000049,MilliHz=383;

const uint Rest1 = Hz%1000;//jede Sekunde zu korrigierender Fehler
const uint Rest2 = MilliHz*6/100;//jede Minute
const uint Rest3 = ((MilliHz*6-Rest2*100)*60+50)/100;//jede Stunde
const uint NormalerCompwert=Hz/1000-1;
//der Compiler sollte bis hier noch keinen Code erzeugt haben.
//(der Quarz ist wahrscheinlich zu wenig stabil als dass Rest2 und Rest3
//eine Rolle spielen wuerden. Also MilliHz vorlaeufig auf 0 lassen.)

//fuer Tastenentprellung:
static volatile char entprelltetasten=0xFF;
static char status1=0xFF,status2=0xFF;
static volatile char tastegedrueckt=0;
static volatile char langgedrueckt=0;
static char status3=0,status4=0,status5=0;

//fuer LEDs:
static volatile int rothell=0,gruenhell=0,blauhell=0;//Helligkeit der LEDs
const uchar LEDROT=0x20,LEDGRUEN=0x40,LEDBLAU=0x80;
static volatile uchar LEDBITS=0;//Eingeschaltete LEDs
static volatile uchar aktportd=0x07;//aktueller Zustand von PORTD

//die Namen SIG_* sind in include/avr/iom32.h zu finden?
SIGNAL (SIG_OUTPUT_COMPARE1A)
{
 uchar mehr;
 uint ms=millisec;
 uint h;//fuer LEDs
 if(++ms>=1000-Rest1) mehr=1; else mehr=0;
 if(ms==1000)
  {ms=0;
   if(++sec>=60-Rest2) mehr=1; else mehr=0;
   if(sec==60)
    {sec=0;
     if(++min>=60-Rest3) mehr=1; else mehr=0;
     if(min==60)
      {min=0; mehr=0;
       if(++stunden==24)
	{stunden=0; ++tage; //neuertag=1;
	 if(tage>monatstage[monat])
	  {tage=1;
	   if(++monat==13) {monat=1; ++jahr; schaltjahrtest();}
	  }
	}
      }
    }
  }
 else if((ms&0x0F)==1) //alle 16ms
  {//Tasten-Entprellung: fuer 8 Tasten unabhaengig voneinander
   char pin,ung;
   pin = PIND;
   ung = (pin^status1) |   //Ist PIND verschieden zu status1 oder
         (status2^status1);//ist status2 verschieden zu status1 ?
   entprelltetasten = //entweder Alt oder Neu uebernehmen:
    (entprelltetasten&ung) //ja: Alt=Alter Zustand, nein: Alt=0
    | (pin & (ung^0xFF)); //nein: Neu=PIND, ja: Neu=0
   status2=status1;
   status1=pin;
   tastegedrueckt |= (entprelltetasten^0xFF);
  }
 else if((ms&0xFF)==0xE7) //alle ca 250ms
  {//Erkennung von langen Tastendrucken
   langgedrueckt = (entprelltetasten^0xFF) & status3 & status4 & status5;
   status5=status4; status4=status3; status3=(entprelltetasten^0xFF);
  }
 millisec=ms;
 OCR1A=NormalerCompwert+mehr;
 h=ms%10;//LEDs in 10 Helligkeitsstufen
 aktportd &= 0x1F;
 if((LEDBITS&LEDROT) && h<rothell) aktportd |= LEDROT;
 if((LEDBITS&LEDGRUEN) && h<gruenhell) aktportd |= LEDGRUEN;
 if((LEDBITS&LEDBLAU) && h<blauhell) aktportd |= LEDBLAU;
 PORTD = aktportd;
}

//Bei einem unerwarteten Interrupt nichts machen:
//SIGNAL (__vector_default) {}
//Oder besser wirklich einfach nur ein reti machen:
void __attribute__ ((naked)) __vector_default(void) {__asm__ ("reti");}
//Ohne diese Funktion wird nach 0 gesprungen, was einem Reset entspricht.

void milliwait(int n) //n Millisekunden warten  999 >= n >= 1
{
 uint ms;
 //ms=millisec+n;  das macht der Compiler nicht ganz korrekt!
 cli(); ms=millisec; sei(); ms+=n;
 if(ms>=1000) ms-=1000;
 while(ms!=millisec || ms!=millisec) ;
}

//Globale Variablen:
const char ROTETASTE=0x01,GRUENETASTE=0x02,SCHWARZETASTE=0x04,ALLETASTEN=0x07;
const char MINSEK=0,UHRZEIT=1,MOTG=2,JJJ=3,WECK1=4,WECK2=5;
static char modus=UHRZEIT,stellen=0,weck1start=0;
static char weck1std=6, weck1min=20; //Weckzeit1 = an Wochentagen
static char weck2std=8, weck2min=00; //Weckzeit2 = an Feiertagen u. Wochenende

void lcdanzeigen(int zahl,int dp2,char com)
{
 char n1,n2,n3,n4,a=0,b=0,c=0,d=0;
 n4=zahl/1000; zahl -= 1000*n4;
 n3=zahl/100; zahl -= 100*n3;
 n2=zahl/10;
 n1=zahl%10;
 switch(n1)
  {case 0: a |= 0x3F; break;
   case 1: a |= 0x06; break;
   case 2: a |= 0x5B; break;
   case 3: a |= 0x4F; break;
   case 4: a |= 0x66; break;
   case 5: a |= 0x6D; break;
   case 6: a |= 0x7D; break;
   case 7: a |= 0x07; break;
   case 8: a |= 0x7F; break;
   case 9: a |= 0x6F; break;
  }
 switch(n2)
  {case 0: b |= 0x3F; break;
   case 1: b |= 0x06; break;
   case 2: b |= 0x5B; break;
   case 3: b |= 0x4F; break;
   case 4: b |= 0x66; break;
   case 5: b |= 0x6D; break;
   case 6: b |= 0x7D; break;
   case 7: b |= 0x07; break;
   case 8: b |= 0x7F; break;
   case 9: b |= 0x6F; break;
  }
 if(millisec<dp2) //Bei Zeitanzeige 1 mal pro Sec blinken
   b |= 0x80; //2DP setzen
 switch(n3)
  {case 0: c |= 0x3F; break;
   case 1: c |= 0x06; break;
   case 2: c |= 0x5B; break;
   case 3: c |= 0x4F; break;
   case 4: c |= 0x66; break;
   case 5: c |= 0x6D; break;
   case 6: c |= 0x7D; break;
   case 7: c |= 0x07; break;
   case 8: c |= 0x7F; break;
   case 9: c |= 0x6F; break;
  }
 if(n4>0)
  {d |= 0x10; //fuehrende 1
   if(n4>1) c |= 0x80; //Over oder DP3 fuer Ueberlaufanzeige
   if(n4>2) a |= 0x80; //Test von Batt
  }
 if(stellen==1 && millisec<500) {a=b=0;} //Blinken im Stellen-Modus
 if(stellen==2 && millisec<500) {c=0; d &= ~0x10;} //Blinken im Stellen-Modus
 if(com)
  {a ^= 0xFF; b ^= 0xFF; c ^= 0xFF; d ^= 0xFF;}
 PORTA = a;
 PORTB = b;
 PORTC = c;
 d &= 0x18;
 cli();
 aktportd=(aktportd & 0xE7)+d;//obere 3 Bits=LEDs, untere 3=Pullups
 sei();
}
void zeitauflcdanzeigen(char com)
{
 int zahl,dp2=501;
 switch(modus)
  {case UHRZEIT: cli(); zahl=min+100*stunden; sei(); if(zahl>=2000) zahl-=1200;
   CASE MINSEK:  cli(); zahl=sec+100*min; sei(); if(zahl>=2000) zahl%=1000;
   CASE WECK1: zahl=weck1min+100*weck1std; dp2=1000; if(zahl>=2000) zahl-=1200;
   CASE WECK2: zahl=weck2min+100*weck2std; dp2=1000; if(zahl>=2000) zahl-=1200;
   CASE MOTG:  zahl=100*monat+tage; dp2=1000;
   CASE JJJ: default: zahl=jahr%1000; dp2=0;
  }
 lcdanzeigen(zahl,dp2,com);
}

void moduswechsel()
{
//Modus-Wechsel:
//Std:Min -> Weckzeit1 -> Weckzeit2 -> Min:Sek -> Monat.Tag -> Jahr (3stellig)
//UHRZEIT    WECK1        WECK2        MINSEK     MOTG         JJJ
 if(weck1start==0) {rothell=gruenhell=blauhell=1; LEDBITS=0;}//alle LEDs aus
 switch(modus)
  {case UHRZEIT: modus=WECK1; if(weck1start==0) LEDBITS=LEDGRUEN;
   CASE WECK1:   modus=WECK2; if(weck1start==0) LEDBITS=LEDROT;
   CASE WECK2:   modus=MINSEK;
   CASE MINSEK:  modus=MOTG;
   CASE MOTG:    modus=JJJ;
   CASE JJJ: default: modus=UHRZEIT;
  }
}
void schwarzetaste()
{
 if(modus==UHRZEIT || modus==WECK1 || modus==WECK2 || modus==MOTG)
  {if(++stellen==3) stellen=0;
  }
}
void rotetaste()
{
 if(stellen==1)
  switch(modus)
   {case UHRZEIT: sec=0; if(++min==60) min=0;
    CASE WECK1: if(++weck1min==60) weck1min=0;
    CASE WECK2: if(++weck2min==60) weck2min=0;
    CASE MOTG: if(++tage>monatstage[monat]) tage=1;
   }
 else if(stellen==2)
  switch(modus)
   {case UHRZEIT: sec=0; if(++stunden==24) stunden=0;
    CASE WECK1: if(++weck1std==24) weck1std=0;
    CASE WECK2: if(++weck2std==24) weck2std=0;
    CASE MOTG: if(++monat==13) monat=1;
   }
 else
  moduswechsel();
}
void gruenetaste()
{
 if(stellen==1)
  switch(modus)
   {case UHRZEIT: sec=0; if(min==0) min=59; else --min;
    CASE WECK1: if(weck1min==0) weck1min=59; else --weck1min;
    CASE WECK2: if(weck2min==0) weck2min=59; else --weck2min;
    CASE MOTG: if(--tage==0) tage=monatstage[monat];
   }
 else if(stellen==2)
  switch(modus)
   {case UHRZEIT: sec=0; if(stunden==0) stunden=23; else --stunden;
    CASE WECK1: if(weck1std==0) weck1std=23; else --weck1std;
    CASE WECK2: if(weck2std==0) weck2std=23; else --weck2std;
    CASE MOTG: if(--monat==0) monat=12;
   }
 else
  {rothell=gruenhell=blauhell=0; weck1start=0;//Wecklicht ausschalten
  }
}

int hellfun(int h)
{
 if(h>=5) return 10;
 if(h==4) return 5;
 return h;
}

int main(void)
{
 const char WARTE_AUF_TASTENDRUCK=0,WARTE_AUF_TASTELOSLASSEN=1;
 char com=0,warten=WARTE_AUF_TASTENDRUCK;
 DDRA  = 0xFF; //PortA alles Ausgaenge
 DDRB  = 0xFF; //PortB alles Ausgaenge
 DDRC  = 0xFF; //PortC alles Ausgaenge
 DDRD  = 0xF8; //PortD D0-D2 Eingaenge, D3-D7 Ausgaenge
 PORTA = 0;//alle Ausgaenge auf 0
 PORTB = 0;//alle Ausgaenge auf 0
 PORTC = 0;//alle Ausgaenge auf 0
 PORTD = aktportd = 0x07;//alle LEDs aus, D0-D2 Pullup-Widerstaende ein

 TCCR1B = (1<<WGM12)|(1<<CS10); //CTC-OCR1A-Modus, Prescaler=1
 OCR1A = NormalerCompwert;
 TCNT1 = 0; //Startwert des Timers
 TIMSK = 1<<OCIE1A; //Timer1 Interrupts bei Vergleichswert

 sei(); //Interrupt einschalten
 do {milliwait(200);} while((entprelltetasten&ALLETASTEN)!=ALLETASTEN);
 langgedrueckt=tastegedrueckt=0;//erste Entprellungen abwarten 

 rothell=gruenhell=blauhell=5;//Helligkeit der LEDs
 while((tastegedrueckt&7)==0) //Startschlaufe, weiter mit Tastendruck
  {LEDBITS=(sec<<5)&0xE0; //laufende Sekunden auf den LEDs anzeigen
   //aktportd=LEDBITS+7;
   //bei PORTD immer +7 wegen Pullup-Widerstaenden!!!
  }
 /** test
 tastegedrueckt=0;
 while((langgedrueckt&7)==0) //Testschlaufe, weiter mit langem Tastendruck
  {//PORTD=(entprelltetasten<<5)+7; //Status der Tasten auf den LEDs anzeigen
   PORTD=(tastegedrueckt<<5)+7; //Status der Tasten auf den LEDs anzeigen
   if((tastegedrueckt&7)==7) {milliwait(200); tastegedrueckt=0;}//test
  }
 **/
 langgedrueckt=tastegedrueckt=0;
 LEDBITS=0;//alle LEDs aus
 while(1) //Hauptschlaufe
  {zeitauflcdanzeigen(com);
   milliwait(25);
   com ^= 1;
   if(warten==WARTE_AUF_TASTENDRUCK)
    {if(tastegedrueckt&ALLETASTEN)
      {if(tastegedrueckt&SCHWARZETASTE) schwarzetaste();
       else if(tastegedrueckt&ROTETASTE) rotetaste();
       else if(tastegedrueckt&GRUENETASTE) gruenetaste();
       warten=WARTE_AUF_TASTELOSLASSEN;
      }
    }
   else //warten==WARTE_AUF_TASTELOSLASSEN
    {if((entprelltetasten&ALLETASTEN)==ALLETASTEN)
      {warten=WARTE_AUF_TASTENDRUCK; langgedrueckt=tastegedrueckt=0;}
    }
   if(weck1start)
    {int h;
     h=stunden*60+min-(weck1std*60+weck1min)+1;
     if(h<=5) rothell=hellfun(h);
     else
      {rothell=10;
       if(h<=10) gruenhell=hellfun(h-5);
       else
	{gruenhell=10;
	 if(h<=15) blauhell=hellfun(h-10);
	 else if(h<=60)
	   blauhell=10;
	 else //Wecklicht mach 1 Stunde wieder ausschalten
	  {rothell=gruenhell=blauhell=0; weck1start=0;}
	}
      }
    }
   else if(stunden==weck1std && min==weck1min)
    {//starten der Weckzeit, provi.: Wochentag noch nicht beruecksichtigt
     weck1start=1;
     rothell=gruenhell=blauhell=0; LEDBITS=0xE0;
    }
  }
 return 0;//wird nie erreicht
}
