// entprell.cc  gleich wie entprell.asm aber in c
/*;--------------------------------------------------------------------------
;; Tasten-Entprellung: fuer 8 Tasten unabhaengig voneinander
*/
static volatile char entprelltetasten=0xFF;
static volatile char status1=0xFF,status2=0xFF;
// In Timer-Interrupt etwa alle 10ms machen:
{
 char pin,ung;
 pin = PIND;
 ung = (c^status1) |     //Ist PIND verschieden zu status1 oder
       (status2^status1);//ist status2 verschieden zu status1 ?
 entprelltetasten = //entweder Alt oder Neu uebernehmen:
  (entprelltetasten&ung) //ja: Alt=Alter Zustand, nein: Alt=0
  | (pin & (ung^0xFF)); //nein: Neu=PIND, ja: Neu=0
 status2=status1;
 status1=pin;
}
// Im Hauptprogramm verwenden:
if(entprelltetasten & (1<<2)) //Taste an PortD2 gedrueckt?
   {//ja
   }
/*
;Erleuterungen:
; Es werden immer 8 Bit aufs mal berechnet. Fuer die folgende Beschreibung
; betrachten wir nur ein Bit.
; PIND vom vorhergenden Aufruf ist in status1, noch ein Aufruf vorher
; in status2. Mit ^ wird Bitweise verglichen und wenn ungleich das Bit
; gesetzt. In ung ist das Bit genau dann 0 wenn PIND, status1
; und status2 alle gleich sind. Dann wird alt zu 0 und neu zu pin und
; somit bekommt entprelltetasten den Wert aus PIND. Andernfalls wird das Bit
; in entprelltetasten beibehalten. Am Schluss wird noch status1 nach status2
; verschoben und status1 auf aktuelles PIND gesetzt.
*/
