/* myfonts.cc			letzte Aenderung: 14.9.2019 */
/*
Anwendung: einfuegen in Hauptprogramm:
 typedef unsigned char uchar;
 #include "myfonts.cc"
oder besser:
 typedef unsigned char uchar;
 #include "myfonts.h"
 dann im Makefile zum Linken: myfonts.o mit angeben

History:
5.9.2019        Erstellung (RP)
14.9.2019       Font 9x12 erstellt


Einteilung in Fonttypen:
Typ  Grund-Aufbau           x-Pixel                      y-Pixel                    Leerbits
 1   Zeilenweiser Aufbau    Bits von links nach rechts   Bytes von oben nach unten  rechts
 2   Zeilenweiser Aufbau    Bits von links nach rechts   Bytes von oben nach unten  links
 3   Zeilenweiser Aufbau    Bits von rechts nach links   Bytes von oben nach unten  rechts
 4   Zeilenweiser Aufbau    Bits von rechts nach links   Bytes von oben nach unten  links
 5   Zeilenweiser Aufbau    Bits von links nach rechts   Bytes von unten nach oben  rechts
 6   Zeilenweiser Aufbau    Bits von links nach rechts   Bytes von unten nach oben  links
 7   Zeilenweiser Aufbau    Bits von rechts nach links   Bytes von unten nach oben  rechts
 8   Zeilenweiser Aufbau    Bits von rechts nach links   Bytes von unten nach oben  links
 9   Spaltenweiser Aufbau   Bytes von links nach rechts  Bits von oben nach unten   unten
10   Spaltenweiser Aufbau   Bytes von links nach rechts  Bits von oben nach unten   oben
11   Spaltenweiser Aufbau   Bytes von links nach rechts  Bits von unten nach oben   unten
12   Spaltenweiser Aufbau   Bytes von links nach rechts  Bits von unten nach oben   oben
13   Spaltenweiser Aufbau   Bytes von rechts nach links  Bits von oben nach unten   unten
14   Spaltenweiser Aufbau   Bytes von rechts nach links  Bits von oben nach unten   oben
15   Spaltenweiser Aufbau   Bytes von rechts nach links  Bits von unten nach oben   unten
16   Spaltenweiser Aufbau   Bytes von rechts nach links  Bits von unten nach oben   oben

*/

#ifndef DXS
#define DXS 1
#endif

#ifndef DYS
#define DYS 1
#endif

typedef unsigned char uchar;
typedef unsigned int uint;
#include "myfonts.h"

// Default-Fonts:
uchar myfont6x8[256*8] = {
#include "myfont6x8.h"
};
uchar myfont9x12[256*24] = {
#include "myfont9x12.h"
};
uchar myfont12x16[256*32] = {
#include "myfont12x16.h"
};

class Font
{
public:
 uchar *pfont;
 int bx,hy,typ,bytesprozeichen;
 Font(uchar *p,int b,int h,int t,int bpz) {pfont=p; bx=b; hy=h; typ=t; bytesprozeichen=bpz;}
};
 
static Font font12x16(myfont12x16,      12,16, 1, 32);
static Font font6x8((uchar*)myfont6x8,   6, 8, 1,  8);
static Font font9x12((uchar*)myfont9x12, 9,12, 1, 24);

static Font *aktfont= &font12x16; //aktueller_font
//static int font_bytesprozeichen=32;
//static int font_bx=12,font_hy=16,font_typ=1; //voreingesteller Font, muss mit myfont.h uebereinstimmen
static double schrift_hoehe=DYS*aktfont->hy; //DYS muss Pixelgroesse in y-Richtung sein
static double schrift_breite=DXS*aktfont->bx; //DXS muss Pixelgroesse in x-Richtung sein

/************************* Vordeklarationen ***************************/
/* sollte schon in myfonts.h definiert sein
void schrift(double x0,double y0,const char *text,double winkel=0);
void zeichne_zeichen(double x0,double y0,double zhoehe,double zbreite,uchar zeichen);
void fillbox(double x1,double y1,double x2,double y2);
double textsize(double bx,double hy,const char *font=NULL,int style=0);
*/
/**************************** Hauptteil *******************************/
double textsize(double bx,double hy,const char *font,int style)
{
 if(font!=NULL)
  {
   if(strcmp(font,"12x16")==0) {aktfont = &font12x16;}
   else if(strcmp(font,"6x8")==0) {aktfont = &font6x8;}
   else if(strcmp(font,"9x12")==0) {aktfont = &font9x12;}
   //TODO: weiter Fonts erstellen
   else
    {
     printf("textsize(): Font \"%s\" nicht gefunden.\n",font);
     printf("bisher diese Fonts verwendbar: 6x8, 9x12, 12x16\n");
    }
  }
 if(style!=0) printf("textsize() style noch nicht veraenderbar\n");
 schrift_breite=bx;
 schrift_hoehe=hy;
 return hy;
}

uchar *bitlesen(uchar *pfont,int i,int j,int *maske,int bx,int hy,int typ)
{
 // i kann Werte von 0 bis bx-1 haben, 0 ist Spalte ganz links
 // j kann Werte von 0 bis hy-1 haben, 0 ist oberste Zeile
 // bx ist Fontbreite, hy ist Fonthoehe, typ ist Fonttyp
 uchar leerbits;
 uchar *p1;
 int bytesprozeile=1,bytesprospalte=1,nbits;
 int bx1=bx-1, hy1=hy-1;
 if(typ<=8) {bytesprozeile = (bx+7)/8;  leerbits = 8-bx%8;}
 else       {bytesprospalte = (hy+7)/8; leerbits = 8-hy%8;}
 //if(typ!=1)//test
 // {printf("bitlesen(pfont,i=%d,j=%d,bx=%d,hy=%d,typ=%d)\n",i,j,bx,hy,typ);//test
 //  printf("bytesprozeile=%d\n",bytesprozeile);//test
 // }
 if(leerbits==8) leerbits=0;
 if(typ<1 || typ>16)
  {
   fprintf(stderr,"Error: in bitlesen() unknown Fonttyp %d - defaulting to Typ 3\n",typ);
   typ=3;
  }
 switch(typ)
  {
   //       Typ  Grund-Aufbau           x-Pixel                      y-Pixel                    Leerbits
   case 1:// 1   Zeilenweiser Aufbau    Bits von links nach rechts   Bytes von oben nach unten  rechts
     p1 = &pfont[bytesprozeile*j+i/8];
     nbits = 7-i%8;
     break;
   case 2:// 2   Zeilenweiser Aufbau    Bits von links nach rechts   Bytes von oben nach unten  links
     p1 = &pfont[bytesprozeile*j+(i+leerbits)/8]; //noch testen
     nbits = 7-(i+leerbits)%8; //noch testen
     break;
   case 3:// 3   Zeilenweiser Aufbau    Bits von rechts nach links   Bytes von oben nach unten  rechts
     p1 = &pfont[bytesprozeile*j+(bx1-i+leerbits)/8];
     nbits = (i+leerbits)%8;
     break;
   case 4:// 4   Zeilenweiser Aufbau    Bits von rechts nach links   Bytes von oben nach unten  links
     p1 = &pfont[bytesprozeile*j+(bx1-i)/8];
     nbits = i%8;
     break;
   case 5:// 5   Zeilenweiser Aufbau    Bits von links nach rechts   Bytes von unten nach oben  rechts
     p1 = &pfont[bytesprozeile*(hy1-j)+i/8]; //noch testen
     nbits = 7-i%8; //noch testen
     break;
   case 6:// 6   Zeilenweiser Aufbau    Bits von links nach rechts   Bytes von unten nach oben  links
     p1 = &pfont[bytesprozeile*(hy1-j)+(i+leerbits)/8]; //noch testen
     nbits = 7-(i+leerbits)%8; //noch testen
     break;
   case 7:// 7   Zeilenweiser Aufbau    Bits von rechts nach links   Bytes von unten nach oben  rechts
     p1 = &pfont[bytesprozeile*(hy1-j)+(bx1-i+leerbits)/8]; //noch testen
     nbits = (i+leerbits)%8; //noch testen
     break;
   case 8:// 8   Zeilenweiser Aufbau    Bits von rechts nach links   Bytes von unten nach oben  links
     p1 = &pfont[bytesprozeile*(hy1-j)+(bx1-i)/8]; //noch testen
     nbits = i%8; //noch testen
     break;
   //       Typ  Grund-Aufbau           x-Pixel                      y-Pixel                    Leerbits
  case  9:// 9   Spaltenweiser Aufbau   Bytes von links nach rechts  Bits von oben nach unten   unten
     p1 = &pfont[bytesprospalte*i+j/8]; //noch testen
     nbits = j%8+leerbits; //noch testen
     break;
  case 10://10   Spaltenweiser Aufbau   Bytes von links nach rechts  Bits von oben nach unten   oben
     p1 = &pfont[bytesprospalte*i+(j+leerbits)/8]; //noch testen
     nbits = 7-(j+leerbits)%8; //noch testen
     break;
  case 11://11   Spaltenweiser Aufbau   Bytes von links nach rechts  Bits von unten nach oben   unten
     p1 = &pfont[bytesprospalte*i+(hy1-j+leerbits)/8]; //noch testen
     nbits = (j+leerbits)%8; //noch testen
     break;
  case 12://12   Spaltenweiser Aufbau   Bytes von links nach rechts  Bits von unten nach oben   oben
     p1 = &pfont[bytesprospalte*i+(hy1-j)/8]; //noch testen
     nbits = j%8+leerbits; //noch testen
     break;
  case 13://13   Spaltenweiser Aufbau   Bytes von rechts nach links  Bits von oben nach unten   unten
     p1 = &pfont[bytesprospalte*(bx1-i)+j/8]; //noch testen
     nbits = 7-j%8; //noch testen
     break;
  case 14://14   Spaltenweiser Aufbau   Bytes von rechts nach links  Bits von oben nach unten   oben
     p1 = &pfont[bytesprospalte*(bx1-i)+(j+leerbits)/8]; //noch testen
     nbits = 7-(j+leerbits)%8; //noch testen
     break;
  case 15://15   Spaltenweiser Aufbau   Bytes von rechts nach links  Bits von unten nach oben   unten
     p1 = &pfont[bytesprospalte*(bx1-i)+(hy1-j+leerbits)/8]; //noch testen
     nbits = (j+leerbits)%8; //noch testen
     break;
  case 16://16   Spaltenweiser Aufbau   Bytes von rechts nach links  Bits von unten nach oben   oben
     p1 = &pfont[bytesprospalte*(bx1-i)+(hy1-j)/8]; //noch testen
     nbits = j%8; //noch testen
     break;
  }
 *maske = (1<<nbits);
 return p1;
}

bool bitgesetzt(uchar *pfont,int i,int j)  //i=Zaehler in x-Richtung, j=y-Richtung
{
 int maske,c;
 uchar *p;
 p = bitlesen(pfont,i,j,&maske,aktfont->bx,aktfont->hy,aktfont->typ);
 c = *p;
 //printf("Testpunkt bitgesetzt(): c=0x%02X maske=0x%02X\n",c,maske);//test
 return (c&maske)!=0;
}

void fillbox(double x1,double y1,double x2,double y2)
{
 //TODO: glBegin und glEnd je nach dem auch aufrufen, fuer groessere Box ev. andere Methode?
 if(x1>x2) {double h=x1; x1=x2; x2=h;}
 if(y1>y2) {double h=y1; y1=y2; y2=h;}
 double y;
 for(;x1<x2;x1+=DXS)
  for(y=y1;y<y2;y+=DYS)
   glVertex2d(x1,y);
}

void zeichne_zeichen(double x0,double y0,double zhoehe,double zbreite,uchar zeichen)
{
 int i,j;
 double x,y,x1;
 uchar *pfont;
 double dy=zhoehe/aktfont->hy;
 double dx=zbreite/aktfont->bx;
 //bool testflag=(aktfont->bytesprozeichen!=32);//test
 //if(testflag) printf("zeichen=%c bytesprozeichen=%d\n",zeichen,aktfont->bytesprozeichen);//test
 pfont = &aktfont->pfont[zeichen*aktfont->bytesprozeichen];
 //if(testflag) {for(int k=0;k<aktfont->bytesprozeichen;k++) printf("0x%02X ",pfont[k]); printf("\n");}//test
 x1=x0;
 glBegin(GL_POINTS); // GL einschalten auf Punkte-Modus
 for(x=x1,i=0; i<aktfont->bx; i++,x+=dx)
  for(y=y0+(aktfont->hy-1)*dy,j=0; j<aktfont->hy; j++,y-=dy)
   {
    if(bitgesetzt(pfont,i,j))
      fillbox(x,y,x+dx,y+dy);
   }
 glEnd(); //GL ausschalten
}

void schrift(double x0,double y0,const char *text,double winkel)
{
 double x=x0;
 if(winkel==0)
  {
   for(int i=0;text[i]!=0;i++)
    {
     zeichne_zeichen(x,y0,schrift_hoehe,schrift_breite,text[i]);
     x += schrift_breite;
    }
  }
 else
  {
   //TODO
   printf("schrift() mit winkel=%f noch nicht programmiert. Bisher nur winkel=0 moeglich.\n",winkel);
  }
}

void wprintf(double x,double y,const char *cstr,int p1,int p2=0)
{
 char str[200];
 sprintf(str,cstr,p1,p2);
 schrift(x,y,str);
}

/**** Behandlung von Umlauten: ****/
#define MAXP 1024
void utf8_to_isolatin1(char *ziel,const char *von,int max)
{  //Codierung von utf-8 nach iso-8859-1
 int i,c,a1;
 for(i=1;(c= *von++ & 0xFF) && i<max;i++)
   {if((c==0xC2 || c==0xC3) && ((a1= *von & 0xFF) & 0xC0)==0x80)
      {von++;
       c=(a1&0x3F)+((c&0x03)<<6);
      }
/** keine gute Idee: gibt seltsame Effekte bei der Eingabe in Requestern
    else if(c=='\\' && *von=='\\')
      {von++;
      }
    else if(c=='\\' && *von=='\"' &&
	    ((a1=von[1])=='a'||a1=='o'||a1=='u'||a1=='A'||a1=='O'||a1=='U'))
      {//Sequenzen der Form '\"a' auch in Umlaute wandeln
       von++; von++;
       switch(a1)
	{case 'a':c=0xE4; break;case 'o':c=0xF6; break;case 'u':c=0xFC; break;
	 case 'A':c=0xC4; break;case 'O':c=0xD6; break;case 'U':c=0xDC;
	}
      }
**/
#ifdef MACOSX
   else if(c>='A' && c<='z' && (von[0]&0xFF)==0xCC && (von[1]&0xFF)==0x88)
    {
     switch(c)
	{case 'a':c=0xE4; break;case 'o':c=0xF6; break;case 'u':c=0xFC; break;
	 case 'A':c=0xC4; break;case 'O':c=0xD6; break;case 'U':c=0xDC;
	}
     von++; von++;
    }
#endif
    *ziel++ = c;
   }
 *ziel=0;
}

static char *umlaut(const char *txt)
{
 static char str[MAXP];
 utf8_to_isolatin1(str,txt,MAXP);
 return str;
}

void schrift_utf8(double x,double y,const char *str,double winkel)
{
 schrift(x,y,umlaut(str),winkel);
}
