/* pepcalc.cc				letzte Aenderung: 13.3.2013 */
#define VERSION "0.3"
/*

History:
Datum       Version Kommentar
11.12.2012  0.1     Erstellung aus mg.cc (RPF)
14.1.2013   0.2     Auch DMF, Deprotect, Activator und Activator-Base rechnen
13.3.2013   0.3     Fuer Amid-Endgruppe (NH2) "amidflag" eingefuehrt.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#define SEITENKETTEN
#include "mgkern.h"
#define MAXARG 2

extern int pflag; //Flag in mgkern.c

/*************************** globale Parameter ************************/
char peptidkette[400],zeile[400],zeile2[1200];
char argflag['Z'+1];

int ueberschuss=6;   //soviel mal mehr Millimol einsetzen als theoretisch gebraucht
int zusatzvolumen=4; //soviele ml jeweils zusaetzlich
double ansatzgroesse=0.1; //Ansatz-Menge in Millimol
int amidflag=0; //setzen fuer NH2-Endgruppe (0 fuer OH-Endgruppe)

void setflags(const char *s)
{
 int c;
 while(c= *s++)
  {
   if((c=toupper(c))<='Z')  argflag[c]=1;
   if(c=='Z')
    {if(isdigit(*s)) zusatzvolumen = *s++ - '0';
     else zusatzvolumen=0;
    }
   else if(c=='A')
    {if(isdigit(*s) && s[1]=='.')
      {sscanf(s,"%lf",&ansatzgroesse);
       for(s= &s[2];isdigit(*s);s++) ;
      }
     else ansatzgroesse=0;
    }
   else if(c=='N')
    {amidflag=1;
    }
  }
}

/*************************** Vordeklarationen: ************************/
void pepcalc(const char *peptidkette,double ansatzgroesse);

/***************************** Hauptprogramm **************************/
int main(int argc,char* argv[])
{
 double mg,mgiso=0;
 char *s,cstr[40];
 int i,j,nachkomma,n;
 for(zeile[0]=0,i=j=1;i<argc;i++)
   if(*argv[i]=='-') setflags(argv[i]);
   else switch(j++)
        {case 1:strcpy(zeile,argv[i]); break;
         default:break;
        }
 if(j>MAXARG+1 || zeile[0]=='?' || argflag['?'])
	{printf("pepcalc Version %s\n",VERSION);
	 printf("Anwendung: pepcalc [-Flags] [Peptid]\n");
	 printf("  Flags: a=Ansatzgroesse setzen (default 0.1)\n");
	 printf("         r=Reihenfolge nach Abkuerzungen (sonst alfabetisch nach Aminosaeuren)\n");
	 printf("         z2=Zusatzvolumen auf 2 ml setzen (default 4ml)\n");
	 printf("         c=Conz. variabel gemaess Tabelle im Programm\n");
	 printf("         N=Amidflag setzen\n");
	 exit(0);
	}
 if(zeile[0]==0) {printf("Peptid: ");scanf("%s",zeile);}
 if(ansatzgroesse==0)
  {
   printf("Ansatzgroesse in Millimol: "); scanf("%lf",&ansatzgroesse);
  }
 if((s=index(zeile,'~'))==NULL)
  {
   strcpy(peptidkette,zeile);
   if(amidflag) sprintf(zeile2,"H~%s~NH2",zeile);
   else sprintf(zeile2,"H~%s~OH",zeile);
   strcpy(zeile,zeile2);
  }
 else
  {
   strcpy(peptidkette,&s[1]);
   s=index(peptidkette,'~');
   *s=0;
   if(s[1]=='N') amidflag=1;
  }
 for(i='9';i>'3';i--) if(argflag[i]) break;
 nachkomma=i-'0';
 sprintf(cstr,"Molgewicht=%%.%dlf  (%%.%dlf Isotopenrein)\n",
	      nachkomma,nachkomma);
 pflag=0;
 setflags("PS");
 for(;;)
  {
   char errstr[80],warnstr[80];
   error_reset(errstr,warnstr);
   printf("Eingegebene Formel: %s\n",zeile);
   formel_normieren(zeile,zeile2,400,1200);
   if(strcmp(zeile,zeile2)!=0) printf("Normierte Formel: %s\n",zeile2);
   if((n=klammertest(zeile2))!=0)
   printf("fehlende Klammer %s\n",n<0?"auf":"zu");
   //if(argflag['I']) mg=mol_weight(zeile2,&s,ISO);
   //else if(argflag['D']) mg=mol_weight(zeile2,&s,0);
   //else
    {mg=mol_weight(zeile2,&s,0); mgiso=mol_weight(zeile2,&s,ISO);}
   if(get_actinium_warnung()!=0) printf("Hinweis: Ac = Actinium, Ace = Acetyl\n");
   if(*warnstr) printf("%s\n",warnstr);
   if(*errstr)  printf("Error: %s\n",errstr);
   printf(cstr,mg,mgiso);
   if(argflag['S'])
    {char *summenformel;
     error_reset(errstr,warnstr);
     summenformel=getsummenformel(zeile,NULL);
     if(*warnstr) printf("%s\n",warnstr);
     if(*errstr)  printf("Error: %s\n",errstr);
     printf("Summenformel: %s\n",summenformel);
     free(summenformel);
     if(argflag['P'])
      {
       pflag=1;
       summenformel=getsummenformel(zeile,NULL);
       printf("Summenformel mit Seitenketten-Schutzgruppen: %s\n",summenformel);
       mg=mol_weight(summenformel,&s,0);
       mgiso=mol_weight(summenformel,&s,ISO);
       printf("MG mit Seitenketten: "); printf(cstr,mg,mgiso);
       free(summenformel);
      }
    }
   if(j==1 && mg!=0.0)  {printf("Formel: ");scanf("%s",zeile);}
   else break;
  }
 pepcalc(peptidkette,ansatzgroesse);
 return 0;
}/* ende von main */

struct Peptab
{
 const char *formel;
 int cycle;
 double conz;
};

#define MAX26 26

static Peptab peptab[MAX26]=
 {
  //  Formel           Cyc, Conz
  {"Fmoc-Ala-OH",      1,   0.2}, //A
  {"Fmoc-Aib-OH",      1,   0.2}, //B inoffizielle Abkuerzung fuer Aib
  {"Fmoc-Cys(Trt)-OH", 1,   0.1}, //C
  {"Fmoc-Asp(tBu)-OH", 1,   0.2}, //D
  {"Fmoc-Glu(tBu)-OH", 1,   0.2}, //E
  {"Fmoc-Phe-OH",      1,   0.2}, //F
  {"Fmoc-Gly-OH",      1,   0.2}, //G
  {"Fmoc-His(Trt)-OH", 1,   0.2}, //H
  {"Fmoc-Ile-OH",      2,   0.2}, //I (beim Synthesizer fuer cycle==2 Einstellungen machen)
  {"Fmoc-Aha-OH",      1,   0.2}, //J inoffizielle Abkuerzung fuer Azidohomoalanin
  {"Fmoc-Lys(Boc)-OH", 1,   0.2}, //K
  {"Fmoc-Leu-OH",      1,   0.2}, //L
  {"Fmoc-Met-OH",      1,   0.2}, //M
  {"Fmoc-Asn(Trt)-OH", 1,   0.2}, //N
  {"Fmoc-Oxx",         1,   0.2}, //O (Reserve fuer spezielle Aminosaeure)
  {"Fmoc-Pro-OH",      1,   0.1}, //P
  {"Fmoc-Gln(Trt)-OH", 1,   0.2}, //Q
  {"Fmoc-Arg(Pbf)-OH", 2,   0.2}, //R (Synthesizer macht hier cycle==2 automatisch)
  {"Fmoc-Ser(tBu)-OH", 1,   0.1}, //S
  {"Fmoc-Thr(tBu)-OH", 1,   0.1}, //T
  {"Fmoc-Uxx",         1,   0.2}, //U (Reserve fuer spezielle Aminosaeure)
  {"Fmoc-Val-OH",      2,   0.1}, //V (beim Synthesizer fuer cycle==2 Einstellungen machen)
  {"Fmoc-Trp(Boc)-OH", 1,   0.1}, //W
  {"Fmoc-Xxx",         1,   0.2}, //X (Reserve fuer spezielle Aminosaeure)
  {"Fmoc-Tyr(tBu)-OH", 1,   0.1}, //Y
  {"Fmoc-Zxx",         1,   0.2}  //Z (Reserve fuer spezielle Aminosaeure)
 };

static int ord[MAX26]= //Ordnungs-Nummern zum alfabetisch nach Namen der Aminosaeuren zu sortieren
 {
  9,  1, 0,17,13, 3, //Aha, Aib, Ala, Arg, Asn, Asp
  2, 16, 4, 6, 7, 8, //Cys, Gln, Glu, Gly, His, Ile
  11,10,12, 5,15,18, //Leu, Lys, Met, Phe, Pro, Ser
  19,22,24,21,       //Thr, Trp, Tyr, Val
  14,20,23,25        //Oxx, Uxx, Xxx, Zxx (Reserve fuer weitere Aminosaeuren)
 };

struct V1menge
{
 double menge,v1;
};
static V1menge v1menge[]=   //Aminosaeure Volumenzugabe in Abhaengigkeit der Ansatzgroesse
 {
  {0.05, 1.3},
  {0.10, 2.5},
  {0.25, 5.0},
  {0.5, 10.0},
  {1.0, 15.0},
  {2.0, 30.0},
  {3.0, 45.0},
  {4.0, 50.0},
  {5.0, 50.0},
  {0.0,  0.0}
 };

double getv1(double menge)
{
 int i;
 for(i=0;v1menge[i].menge!=0;i++)
   if(v1menge[i].menge>=menge) return v1menge[i].v1; //v1-Zugabe aus der Tabelle verwenden
 return menge*10; //wenn nicht gefunden: Schaetzung der v1-Zugabe
}

void pepcalc(const char *peptidkette,double ansatzgroesse)
{
 int i,j,c,volumen;
 double mg,conz,v1;
 const char *s;
 char *zs, *summenformel;
 printf("\nBerechnungen fuer Chemikalienverbrauch im Peptidsynthesizer\n");
 printf(  "-----------------------------------------------------------\n");
 printf("Peptid: %s\n",peptidkette);
 printf("Mengen fuer %.2f mmol-Ansatz.\n",ansatzgroesse);
 printf("Es ist jeweils eine Reservemenge von %d ml mit eingerechnet.\n",zusatzvolumen);
 int cnt[MAX26]; //'Z'-'A'+1 = 26
 for(i=0;i<MAX26;) cnt[i++]=0;
 for(s=peptidkette;(c= *s++)!=0;)
  {
   if(c>='A' && c<='Z')
    {
     cnt[c-'A']++;
    }
   else printf("unknown: %c ignored\n",c);//test
  }
 printf("   Aminosaeure          N  Cycle   Conz.   V1   V2(ml)  Gramm\n");
 int imax = (argflag['R']) ? MAX26 : MAX26-4;
 int n1=0,n2=0;
 pflag=1;
 for(i=0;i<imax;i++)
  {
   if(argflag['R']) j=i; else j=ord[i];
   if(cnt[j]>0)
    {
     if(argflag['C']) conz=peptab[j].conz; else conz=0.2;
     v1=getv1(ansatzgroesse)+0.5;
     volumen=(int)(v1*cnt[j]*peptab[j].cycle+zusatzvolumen+0.5);
     sprintf(zeile,"Fmoc~%c~OH",'A'+j);
     formel_normieren(zeile,zeile2,400,1200);
     summenformel=getsummenformel(zeile2,NULL);
     mg=mol_weight(summenformel,&zs,0);
     printf("%c  %-20.20s%2d%4d %9.2f  %5.1f %4d %10.2f\n",
	    'A'+j, peptab[j].formel, cnt[j], peptab[j].cycle, conz, v1, volumen, mg*volumen*conz/1e3);
     n1 += cnt[j];
     n2 += peptab[j].cycle*cnt[j];
    }
   else if(!argflag['R'] && i>2)
    {
     printf("%c  %-20.20s\n", 'A'+j, peptab[j].formel);
    }
  }

 double vact,vbase,vdeprot,vdmf;
 double vact0=8.0; //8 ml Reservevolumen fuer Activator und Activator-Base
 double vdep0=60;  //60 ml Reservevolumen fuer Deprotect
 printf("\n");
 if(ansatzgroesse==0.05)      {vact=1.0; vbase=0.5; vdeprot=2*5;  vdmf=10*5+100;}
 else if(ansatzgroesse==0.1)  {vact=1.0; vbase=0.5; vdeprot=2*7;  vdmf=10*7+100;}
 else if(ansatzgroesse==0.25) {vact=2.0; vbase=1.0; vdeprot=2*10; vdmf=10*10+100;}
 else if(ansatzgroesse==0.50) {vact=4.0; vbase=2.0; vdeprot=2*15; vdmf=10*20+100;}
 //hier erweitern fuer groessere Ansaetze
 else
  {vact=4*ansatzgroesse*2.0; vbase=vact*0.5; vdeprot=4*ansatzgroesse*2*10; vdmf=4*ansatzgroesse*10*10+100;
   printf("Unbekannte Ansatzgroesse -- Nur unegfaehre Mengen der anderen Loesungen:\n");
  } //provi.
 vact = n2*vact+vact0;
 vbase = n2*vbase+vact0;
 vdeprot = n1*vdeprot+vdep0;
 vdmf = n1*vdmf;
 printf("Activator: %.0f ml 0.5 M HBTU in DMF: \t%.2f g HBTU + %.1f ml DMF\n",vact,vact*0.5*0.37925,vact*0.882);
 printf("Act.-Base: %.1f ml 2 M DIEA in NMP: \t%.1f ml DIEA + %.1f ml NMP\n",vbase,vbase/3,vbase*2/3);
 printf("Deprotect: %.0fml 20%% Piper. in DMF: \t%.0f ml Piperidin + %.0f ml DMF\n",vdeprot,vdeprot/5,vdeprot*4/5);
 printf("DMF: %.0f ml\n",vdmf);
}
