/* pepcalc.cc		letzte Aenderungen: 20.11.2021, 24.1.2022 */
#define VERSION "0.93"
/*

History:
Datum       Version Kommentar
11.12.2012  0.1     Erstellung aus mg.cc (RPF)
14.1.2013   0.2     Auch DMF, Deprotect, Activator und Activator-Base rechnen
13.3.2013   0.3     Fuer Amid-Endgruppe (NH2) "amidflag" eingefuehrt.
19.3.2013   0.4     Angaben fuer Harz eingefuegt
24.5.2013   0.5     acetylflag eingefuehrt, Vorbereitungen zum mehrere Peptide berechnen
24.2.2014   0.6     Anpassung fuer leichter spaltbare Seitenkettenschutzgruppe beim Cystein: Cys(Mmt)
31.3.2014   0.7     Fehler beim Einlesen von mehreren Peptiden korrigiert (war vorher auf 2 beschraenkt)
8.12.2014   0.8     Harzbeladung einstellbar
                    Bei Verwendung von Asp (D) im Deprotect 0.1M HOBt vorschlagen
27.1.2016   0.81    Oha (O) fuer 4-Azidophenylalanine
7.6.2016    0.9     Fehlerkorrektur: Val wurde unterschlagen weil nach Definition von Oha
                    die Anzahl Reserve-Abkuerzungen kleiner wurde.
21.11.2017          Defaultwert von Aminosaeuren-Ueberschuss auf 1ml gesetzt (4 war zu viel)
15.1.2021   0.91    Zusatzvolumen jetzt als double statt int, und Default-Menge auf 0.5ml gesetzt.
20.11.2021  0.92    Anpassungen an Windows (Visual Studio 2019)
5.1.2022    0.93    Bessere Rueckmeldung wenn nicht von Terminal gestartet
24.1.2022           Zeichen @ als Alternative zu ~
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "mgkern.h"
#define MAXARG 2

#ifdef _WIN32
#pragma warning(disable : 4996)
// unter Windows fehlende Funktionen:
#define index strchr
/*
char *index(char *str,char c)
{
 for(;*str!=0;str++)
  {
   if(*str==c) return str;
  }
 return NULL;
}

const char *index(const char *str,char c)
{
 for(;*str!=0;str++)
  {
   if(*str==c) return str;
  }
 return NULL;
}
*/
#endif //_WIN32

#define strncpy mystrncpy

void strncpy(char *dest,const char *src,int max)
{
 for(int i=1;i<max && *src!=0;i++)
  {*dest++ = *src++;}
 if(*src!=0)
  {fprintf(stderr,"Error in strncpy() source string too long\n");}
 *dest=0;
}

extern int pflag; //Flag in mgkern.c
struct Abkuerzungen {const char *sym; const char *summenformel;};
extern Abkuerzungen aminos_mit_sg[26]; //in mgkern.c

/*************************** globale Parameter ************************/
char peptidkette[400],zeile[400],zeile2[1200];
char argflag['Z'+1];

int ueberschuss=6;   //soviel mal mehr Millimol einsetzen als theoretisch gebraucht
//int zusatzvolumen=1; //soviele ml jeweils zusaetzlich
double zusatzvolumen=0.5; //soviele ml jeweils zusaetzlich
double ansatzgroesse=0.1; //Ansatz-Menge in Millimol
int amidflag=0; //setzen fuer NH2-Endgruppe (0 fuer OH-Endgruppe)
int acetylflag=0; //setzen fuer Ace-Anfangsgruppe
int aspflag=0; //setzen fuer HOBt-Vorschlag
char ersteaminos[8];
FILE *fp1=NULL;       //Datei fuer mehrere Peptide
char dateiname1[400]; //entsprechender Dateiname
int anzahlpeptide=1;  //Anzahl noch einzulesende Peptide
double harzbelad=0.6; //Harzbeladung in Millimol pro Gramm

void setflags(const char *s)
{
 int c;
 while(c= *s++)
  {
   if((c=toupper(c))<='Z')  argflag[c]=1;
   if(c=='Z')
    {if(isdigit(*s) && s[1]=='.')
      {sscanf(s,"%lf",&zusatzvolumen);
       for(s= &s[2];isdigit(*s);s++) {}
      }
     else if(isdigit(*s)) zusatzvolumen = *s++ - '0';
     else zusatzvolumen=0;
    }
   else if(c=='A')
    {if(isdigit(*s) && s[1]=='.')
      {sscanf(s,"%lf",&ansatzgroesse);
       for(s= &s[2];isdigit(*s);s++) {}
      }
     else ansatzgroesse=0;
    }
   else if(c=='B')
    {if(isdigit(*s) && s[1]=='.')
      {sscanf(s,"%lf",&harzbelad);
       for(s= &s[2];isdigit(*s);s++) ;
      }
     else fprintf(stderr,"Missing float number at option -b\n");
    }
   else if(c=='N')
    {amidflag=1;
    }
   else if(c=='E')
    {acetylflag=1;
    }
  }
}

/*************************** kleinkram ***************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

void zeichen_ersetzen(char *str,char alt,char neu)
{
 for(;*str!=0;str++) {if(*str==alt) *str=neu;}
}

/*************************** Vordeklarationen: ************************/
void pepcalc(const char *peptidkette,double ansatzgroesse);
void erste_aminosaeure_ermitteln(char *formel);
const char* naechstespeptid(); //Erweiterung fuer mehrere Peptide

/***************************** Hauptprogramm **************************/
int main(int argc,char* argv[])
{
 double mg,mgiso=0;
 char *s,cstr[40];
 int i,j,nachkomma,n;
 for(zeile[0]=0,i=j=1;i<argc;i++)
   if(*argv[i]=='-') setflags(argv[i]);
   else switch(j++)
        {case 1:strcpy(zeile,argv[i]); break;
         default:break;
        }
 if(j<2 || j>MAXARG+1 || zeile[0]=='?' || argflag['?'])
  {
   printf("pepcalc2 Version %s\n",VERSION);
   printf("Anwendung: pepcalc2 [-Flags] Peptid [-Flags] [>ausgabedatei.txt]\n");
   printf("Beispiel: pepcalc H~ACDEN~OH -z0.2\n");
   printf("  Flags: a=Ansatzgroesse setzen (0.05  0.1  0.25  0.5  1.0 ...  default: 0.1)\n");
   printf("         b=Beladung des Harzes setzen (default: %.3f)\n",harzbelad);
   printf("         r=Reihenfolge nach Abkuerzungen (sonst alfabetisch nach Aminosaeuren)\n");
   printf("         z1.5=Zusatzvolumen auf 1.5 ml setzen (default %.1fml)\n",zusatzvolumen);
   printf("         c=Conz. variabel gemaess Tabelle im Programm\n");
   printf("         n=Amidflag setzen (Endgruppe NH2 statt OH)\n");
   printf("         e=Acetylflag setzen\n");
   printf("         L=Leichter abspaltbare Seitenkettenschutzgruppe beim Cys: Mmt\n");
   printf("         m=Mengen fuer mehrere Peptide zusammen berechnen (Textdatei angeben)\n");
   if(j<2 && !argflag['?'])
    {
     printf("\nProgramm vom Terminal aus aufrufen.\n");
     printf("\nweiter mit RETURN"); getc(stdin);
    }
   exit(0);
  }
 if(zeile[0]==0)
  {
   if(argflag['M']) printf("Datei mit mehreren Peptiden: ");
   else             printf("Peptid: ");
   scanf("%s",zeile);
  }
 zeichen_ersetzen(zeile,'@','~'); //falls Tilde auf Tastatur fehlt kann auch @ verwendet werden
 if(argflag['M'])
  {
   strcpy(dateiname1,zeile);
   fp1=fopen(dateiname1,"r");
   if(fp1==NULL) {printf("Datei '%s' nicht gefunden.\n",dateiname1); exit(0);}
   if(!getline(fp1,zeile,400))
    {printf("kann Peptid von '%s' nicht einlesen.\n",dateiname1); fclose(fp1); exit(0);}
   for(anzahlpeptide=1;getline(fp1,zeile2,400);anzahlpeptide++) ;//zaehle Anzahl Eintraege in der Datei
   fclose(fp1);
   fp1=fopen(dateiname1,"r");
   getline(fp1,zeile2,400);
  }
 if(ansatzgroesse==0)
  {
   printf("Ansatzgroesse in Millimol: "); scanf("%lf",&ansatzgroesse);
  }

 if((s=index(zeile,'~'))==NULL)
  {
   strcpy(peptidkette,zeile);
   if(amidflag && acetylflag) sprintf(zeile2,"Ace~%s~NH2",zeile);
   else if(amidflag) sprintf(zeile2,"H~%s~NH2",zeile);
   else if(acetylflag) sprintf(zeile2,"Ace~%s~OH",zeile);
   else sprintf(zeile2,"H~%s~OH",zeile);
   strcpy(zeile,zeile2);
  }
 else
  {
   strcpy(peptidkette,&s[1]);
   s=index(peptidkette,'~');
   if(s==NULL) {printf("Error: syntax\n"); exit(1);}
   *s=0;
   if(s[1]=='N') amidflag=1;
   if(strncmp(zeile,"Ac",2)==0)
    {
     acetylflag=1;
     if(zeile[2]=='~')
      {
       sprintf(zeile2,"Ace~%s",&zeile[3]);
       strcpy(zeile,zeile2);
      }
    }
  }

 for(i='9';i>'3';i--) if(argflag[i]) break;
 nachkomma=i-'0';
 sprintf(cstr,"Molgewicht=%%.%dlf  (%%.%dlf Isotopenrein)\n",
	      nachkomma,nachkomma);
 pflag=0;
 setflags("PS");
 //for(;;)  {
   char errstr[80],warnstr[80];
   error_reset(errstr,warnstr);
   printf("Eingegebene Formel: %s\n",zeile);
   formel_normieren(zeile,zeile2,400,1200);
   erste_aminosaeure_ermitteln(zeile2);
   if(strcmp(zeile,zeile2)!=0) printf("Normierte Formel: %s\n",zeile2);
   if((n=klammertest(zeile2))!=0)
   printf("fehlende Klammer %s\n",n<0?"auf":"zu");
   mg=mol_weight(zeile2,&s,0); mgiso=mol_weight(zeile2,&s,ISO);
   if(get_actinium_warnung()!=0) printf("Hinweis: Ac = Actinium, Ace = Acetyl\n");
   if(*warnstr) printf("%s\n",warnstr);
   if(*errstr)  printf("Error: %s\n",errstr);
   printf(cstr,mg,mgiso);
   if(argflag['S'])
    {char *summenformel;
     error_reset(errstr,warnstr);
     summenformel=getsummenformel(zeile,NULL);
     if(*warnstr) printf("%s\n",warnstr);
     if(*errstr)  printf("Error: %s\n",errstr);
     printf("Summenformel: %s\n",summenformel);
     free(summenformel);
     if(argflag['P'])
      {
       pflag=1;
       summenformel=getsummenformel(zeile,NULL);
       printf("Summenformel mit Seitenketten-Schutzgruppen: %s\n",summenformel);
       mg=mol_weight(summenformel,&s,0);
       mgiso=mol_weight(summenformel,&s,ISO);
       printf("MG mit Seitenketten: "); printf(cstr,mg,mgiso);
       free(summenformel);
      }
    }
//   if(j==1 && mg!=0.0) //das geht nicht korrekt
//    {printf("weiteres Peptid (0 fuer fertig): ");scanf("%s",zeile);}
//   else break;
//  } //Ende for(;;)
 pepcalc(peptidkette,ansatzgroesse);
 if(fp1!=NULL) fclose(fp1);
 return 0;
}/* ende von main */

struct Peptab
{
 const char *formel;
 int cycle;
 double conz;
};

#define MAX26 26

static Peptab peptab[MAX26]=
 {
  //  Formel           Cyc, Conz
  {"Fmoc-Ala-OH",      1,   0.2}, //A
  {"Fmoc-Aib-OH",      1,   0.2}, //B inoffizielle Abkuerzung fuer Aib
  {"Fmoc-Cys(Trt)-OH", 1,   0.1}, //C
  {"Fmoc-Asp(tBu)-OH", 1,   0.2}, //D
  {"Fmoc-Glu(tBu)-OH", 1,   0.2}, //E
  {"Fmoc-Phe-OH",      1,   0.2}, //F
  {"Fmoc-Gly-OH",      1,   0.2}, //G
  {"Fmoc-His(Trt)-OH", 1,   0.2}, //H
  {"Fmoc-Ile-OH",      2,   0.2}, //I (beim Synthesizer fuer cycle==2 Einstellungen machen)
  {"Fmoc-Aha-OH",      1,   0.2}, //J inoffizielle Abkuerzung fuer Azidohomoalanin
  {"Fmoc-Lys(Boc)-OH", 1,   0.2}, //K
  {"Fmoc-Leu-OH",      1,   0.2}, //L
  {"Fmoc-Met-OH",      1,   0.2}, //M
  {"Fmoc-Asn(Trt)-OH", 1,   0.2}, //N
  {"Fmoc-Oha-OH",      1,   0.2}, //O inoffiziell fuer 4-Azidophenylalanin
  {"Fmoc-Pro-OH",      1,   0.1}, //P
  {"Fmoc-Gln(Trt)-OH", 1,   0.2}, //Q
  {"Fmoc-Arg(Pbf)-OH", 2,   0.2}, //R (Synthesizer macht hier cycle==2 automatisch)
  {"Fmoc-Ser(tBu)-OH", 1,   0.1}, //S
  {"Fmoc-Thr(tBu)-OH", 1,   0.1}, //T
  {"Fmoc-Uxx",         1,   0.2}, //U (Reserve fuer spezielle Aminosaeure)
  {"Fmoc-Val-OH",      2,   0.1}, //V (beim Synthesizer fuer cycle==2 Einstellungen machen)
  {"Fmoc-Trp(Boc)-OH", 1,   0.1}, //W
  {"Fmoc-Xxx",         1,   0.2}, //X (Reserve fuer spezielle Aminosaeure)
  {"Fmoc-Tyr(tBu)-OH", 1,   0.1}, //Y
  {"Fmoc-Zxx",         1,   0.2}  //Z (Reserve fuer spezielle Aminosaeure)
 };

static int ord[MAX26]= //Ordnungs-Nummern zum alfabetisch nach Namen der Aminosaeuren zu sortieren
 {
  9,  1, 0,17,13, 3, //Aha, Aib, Ala, Arg, Asn, Asp
  2, 16, 4, 6, 7, 8, //Cys, Gln, Glu, Gly, His, Ile
  11,10,12, 14, 5,15,18, //Leu, Lys, Met, Oha, Phe, Pro, Ser
  19,22,24,21,       //Thr, Trp, Tyr, Val
  20,23,25        //Uxx, Xxx, Zxx (Reserve fuer weitere Aminosaeuren)
 };

struct V1menge
{
 double menge,v1;
};
static V1menge v1menge[]=   //Aminosaeure Volumenzugabe in Abhaengigkeit der Ansatzgroesse
 {
  {0.05, 1.3},
  {0.10, 2.5},
  {0.25, 5.0},
  {0.5, 10.0},
  {1.0, 15.0},
  {2.0, 30.0},
  {3.0, 45.0},
  {4.0, 50.0},
  {5.0, 50.0},
  {0.0,  0.0}
 };

double getv1(double menge)
{
 int i;
 for(i=0;v1menge[i].menge!=0;i++)
   if(v1menge[i].menge>=menge) return v1menge[i].v1; //v1-Zugabe aus der Tabelle verwenden
 return menge*10; //wenn nicht gefunden: Schaetzung der v1-Zugabe
}

void pepcalc(const char *peptidkette,double ansatzgroesse)
{
 int i,j,c,volumen;
 double mg,conz,v1;
 const char *s;
 char *zs, *summenformel;
 int cnt[MAX26]; //'Z'-'A'+1 = 26
 if(argflag['L'])
  {
   peptab[2].formel="Fmoc-Cys(Mmt)-OH";
   aminos_mit_sg[2].summenformel="C23H21NO2S";
  }
 printf("\nBerechnungen fuer Chemikalienverbrauch im Peptidsynthesizer\n");
 printf(  "-----------------------------------------------------------\n");
 for(i=0;i<MAX26;) cnt[i++]=0;
 do { //Erweiterung fuer mehrere Peptide
 if(amidflag && acetylflag) printf("Peptid: Ace~%s~NH2\n",peptidkette);
 else if(amidflag) printf("Peptid: H~%s~NH2\n",peptidkette);
 else if(acetylflag) printf("Peptid: Ace~%s~OH\n",peptidkette);
 else  printf("Peptid: H~%s~OH\n",peptidkette);
 for(s=peptidkette;(c= *s++)!=0;)
  {
   if(c>='A' && c<='Z')
    {
     if(amidflag!=0 || *s!=0) //wenn amidflag nicht gesetzt, dann letzte ignorieren
       cnt[c-'A']++;
    }
   else printf("unknown: %c ignored\n",c);//test
  }
 if(--anzahlpeptide!=0) peptidkette=naechstespeptid(); //Erweiterung fuer mehrere Peptide
 if(index(peptidkette,'D')!=NULL) aspflag=1;
 } while(anzahlpeptide!=0); //Erweiterung fuer mehrere Peptide
 printf("Mengen fuer %.2f mmol-Ansatz.\n",ansatzgroesse);
 //printf("Es ist jeweils eine Reservemenge von %d ml mit eingerechnet.\n",zusatzvolumen);
 printf("Es ist jeweils eine Reservemenge von %.1f ml mit eingerechnet.\n",zusatzvolumen);
 printf("   Aminosaeure          N  Cycle   Conz.   V1   V2(ml)  Gramm\n");
 int imax = (argflag['R']) ? MAX26 : MAX26-3; //-3 ist Anzahl Reserve-Abkuerzungen
 int n1=0,n2=0;
 pflag=1;
 for(i=0;i<imax;i++)
  {
   if(argflag['R']) j=i; else j=ord[i];
   if(cnt[j]>0)
    {
     if(argflag['C']) conz=peptab[j].conz; else conz=0.2;
     v1=getv1(ansatzgroesse)+0.5;
     volumen=(int)(v1*cnt[j]*peptab[j].cycle+zusatzvolumen+0.5);
     sprintf(zeile,"Fmoc~%c~OH",'A'+j);
     formel_normieren(zeile,zeile2,400,1200);
     summenformel=getsummenformel(zeile2,NULL);
     mg=mol_weight(summenformel,&zs,0);
     printf("%c  %-20.20s%2d%4d %9.2f  %5.1f %4d %10.2f\n",
	    'A'+j, peptab[j].formel, cnt[j], peptab[j].cycle, conz, v1, volumen, mg*volumen*conz/1e3);
     n1 += cnt[j];
     n2 += peptab[j].cycle*cnt[j];
    }
   else if(!argflag['R'] && i>2)
    {
     printf("%c  %-20.20s\n", 'A'+j, peptab[j].formel);
    }
  }

 double vact,vbase,vdeprot,vdmf;
 double vact0=8.0; //8 ml Reservevolumen fuer Activator und Activator-Base
 double vdep0=60;  //60 ml Reservevolumen fuer Deprotect
 printf("\n");
 if(ansatzgroesse==0.05)      {vact=1.0; vbase=0.5; vdeprot=2*5;  vdmf=10*5+100;}
 else if(ansatzgroesse==0.1)  {vact=1.0; vbase=0.5; vdeprot=2*7;  vdmf=10*7+100;}
 else if(ansatzgroesse==0.25) {vact=2.0; vbase=1.0; vdeprot=2*10; vdmf=10*10+100;}
 else if(ansatzgroesse==0.50) {vact=4.0; vbase=2.0; vdeprot=2*15; vdmf=10*20+100;}
 //hier erweitern fuer groessere Ansaetze
 else
  {vact=4*ansatzgroesse*2.0; vbase=vact*0.5; vdeprot=4*ansatzgroesse*2*10; vdmf=4*ansatzgroesse*10*10+100;
   printf("Unbekannte Ansatzgroesse -- Nur unegfaehre Mengen der anderen Loesungen:\n");
  } //provi.
 if(amidflag)
   //printf("Harz: \"Rink Amide MBHA resin\" 0.6mmol/g: %d mg\n",int(ansatzgroesse*1000/0.6+0.5));
   printf("Harz: \"Rink Amide MBHA resin\" %.3f mmol/g: %d mg\n",harzbelad,int(ansatzgroesse*1000/harzbelad+0.5));
 //else printf("Harz: Fmoc-%s-Wang 0.6mmol/g: %d mg\n",ersteaminos ,int(ansatzgroesse*1000/0.6+0.5));
 else printf("Harz: Fmoc-%s-Wang %.3f mmol/g: %d mg\n",ersteaminos, harzbelad ,int(ansatzgroesse*1000/harzbelad+0.5));
 vact = n2*vact+vact0;
 vbase = n2*vbase+vact0;
 vdeprot = n1*vdeprot+vdep0;
 vdmf = n1*vdmf;
 printf("Activator: %.0f ml 0.5 M HBTU in DMF: \t%.2f g HBTU + %.1f ml DMF\n",vact,vact*0.5*0.37925,vact*0.882);
 printf("Act.-Base: %.1f ml 2 M DIEA in NMP: \t%.1f ml DIEA + %.1f ml NMP\n",vbase,vbase/3,vbase*2/3);
 if(aspflag)
  printf("Deprot: %.0fml 20%%Pip.+0.1M HOBt in DMF: %.0fml Piperidin + %.2fg HOBt + %.0fml DMF\n",vdeprot,vdeprot/5,vdeprot*0.015314,vdeprot*4/5);
 else
  printf("Deprotect: %.0fml 20%% Piper. in DMF: \t%.0f ml Piperidin + %.0f ml DMF\n",vdeprot,vdeprot/5,vdeprot*4/5);
 printf("DMF: %.0f ml\n",vdmf);
 if(acetylflag)
  {
   int v5=2*getv1(ansatzgroesse);
   int mikroliter=v5*20;
   printf("Acetylierung von %.2f mmol-Ansatz:\n",ansatzgroesse);
   printf("Waschen mit 2*%d ml MeOH, 3*%d ml CH2Cl2\n",v5,v5);
   printf("Acetylieren: %d ml CH2Cl2 + %d ul DIEA + %d ul Ac2O  1 Std schuetteln\n",v5,mikroliter,mikroliter);
   printf("Waschen mit 2*%d ml CH2Cl2, 3*%dml MeOH, 2*%d ml CH2Cl2\n",v5,v5,v5);
  }
}

void erste_aminosaeure_ermitteln(char *formel)
{
 int i;
 char *s,*t;
 for(s = &formel[strlen(formel)]; s!=formel && *--s != '-';) ;
 t= &ersteaminos[3]; *t = 0;
 for(i=0;i<3;i++) *--t = *--s;
}

const char* naechstespeptid() //Erweiterung fuer mehrere Peptide
{
 char *s;
 getline(fp1,zeile,400);
 if((s=index(zeile,'~'))==NULL)
  {
   strcpy(peptidkette,zeile);
   if(amidflag && acetylflag) sprintf(zeile2,"Ace~%s~NH2",zeile);
   else if(amidflag) sprintf(zeile2,"H~%s~NH2",zeile);
   else if(acetylflag) sprintf(zeile2,"Ace~%s~OH",zeile);
   else sprintf(zeile2,"H~%s~OH",zeile);
   strcpy(zeile,zeile2);
  }
 else
  {
   amidflag=acetylflag=0;
   strcpy(peptidkette,&s[1]);
   s=index(peptidkette,'~');
   *s=0;
   if(s[1]=='N') amidflag=1;
   if(strncmp(zeile,"Ac",2)==0)
    {
     acetylflag=1;
     if(zeile[2]=='~')
      {
       sprintf(zeile2,"Ace~%s",&zeile[3]);
       strcpy(zeile,zeile2);
      }
    }
  }
 strcpy(zeile2,peptidkette);
 return zeile2;
}
