//astro.h
#ifndef PASCAL_H
#include "pascal.h"
#endif
const double kgauss=0.01720209895,
	     DEG=180/PI;
const double k_gauss=kgauss; /* Gaussian gravitational constant */

char *hms(double);
char *gms(double);
char *planet_name(int plan);
FILE *fopen_num(char *name,char *rw);
void cart(double r,double theta,double phi, double& x,double& y,double& z);
void polar(double x,double y,double z, double& r,double& theta,double& phi);
void ddd(long d,long m,double s,double& dd);
void dms(double dd,long& d,long& m,double& s);
double mjd(long day,long month,long year,double hour);
void caldat(double mjd, long& day,long& month,long& year,double& hour);
void caldat(double mjd, int& day,int& month,int& year,double& hour);
void eclequ(double t,double& x,double& y,double& z);
void equecl(double t,double& x,double& y,double& z);
void pmatecl(double t1,double t2,REAL33& a);
void pmatequ(double t1,double t2,REAL33& a);
void precart(REAL33& a,double& x,double& y,double& z);
double frac(double);
double lmst(double mjd,double lambda);
void quad(double y_minus,double y_0,double y_plus,
	  double& xe,double& ye,double& zero1,double& zero2,int& nz);
void sun200(double t, double& l,double& b,double& r);
void position(int planet,double t,double& x,double& y,double& z);
const int mercury=1,venus=2,earth=3,mars=4,jupiter=5,saturn=6,
	  uranus=7,neptune=8,pluto=9,
	  nplanets=9;
void parab(double t0,double t,double q,double ecc,
	   double& x,double& y,double& vx,double& vy);
void hyperb(double t0,double t,double a,double ecc,
	    double& x,double& y,double& vx,double& vy);
void ellip(double m,double a,double ecc,double&,double&,double&,double&);
void stumpff(double e2,double& c1,double& c2,double& c3);
double hypanom(double mh,double ecc);
double eccanom(double man,double ecc);
void gausvec(double lan,double inc,double aop,REAL33& pqr);
void orbecl(double xx,double yy,REAL33& pqr,double& x,double& y,double& z);
void kepler(double t0,double t,double q,double ecc,REAL33& pqr,
	    double& x,double& y,double& z,double& vx,double& vy,double& vz);
void xyzkep(double x,double y,double z,double vx,double vy,double vz,
	    double& ax,double& ecc,double& inc,
	    double& lan,double& aop,double& ma);
void geocen(double t,double lp,double bp,double rp,
	    double ls,double bs,double rs,int iplan,int imode,
	    double& xp,double& yp,double& zp, double& xs,double& ys,
	    double& zs, double& x,double& y,double& z, double& delta0);
void nutequ(double t,double& x,double& y,double& z);
void addthe(double c1,double s1,double c2,double s2, double& c,double& s);
