/* planetium.cc    letzte Aenderungen: 5.7.2007, 22.6.2019

 Planetarium, genaue Ephemeridenberechnung und Graphische Darstellung
*/

const char *VERSION="Version 1.05",
           *COPYRIGHT="Freeware 1997-2007 Rolf Pfister";
//#define DEBUG 1
//#define DEBUG2
//#define DEBUGMACOSX

/*
History:
21.1.1997	Erstellung (RPf)
20.4.		locale.library benutzt um Zeitzone richtig einzustellen
27.4.		Funktion menu_switch() benutzt.
		k=menu_switch(id,nachf_ids,k,max,nachf_txt,k1=0,k2=max);
8.5.		Wechsel auf GCC-2.7.2.1
		(2.7.0 gab Fehler beim Vergleichen von Fliesszahlen)
18.-25.5.	Umstieg auf 68040 CPU (braucht keine nderung im Programm)
26.5.		Kleine nderungen in Zeitsteuerung
1.6.		Sterntabelle optimiert, Sternbilder-Struktur entworfen
7.6. V0.4	Maustasten, Schalter
14.7.		mydrawmode() [hardwareabhngig]
16.7.		Farbpalette
17.7.		Sterntabelle mit Typ Spektrum Entf. Eigen und Bemerk.
10.10.		klartext2()
18.10.		Kometen-Helligkeit
26.10.		Phase von Planeten und davon abhngige Helligkeiten.
1.11.  V0.5	provisorische Mondphasen (stimmt schon ziemlich gut)
8.11.		Fotos anzeigen
31.11.		Installationsprogramm, zeittakt fr langsame Rechner
7.12.   V0.6	Emulation der Mittleren Maustaste
21.12.		Pfadexpander
28.12.  V0.7	aktion_schrift(), Mond exakt gerechnet
31.12.		Nachfhrung verbessert, dazu darart=EQUATORIAL eingefhrt
18.1.98		Animation mit Nachfhrung, Anzeige von Sonnenfinsternis
24.1.98 V0.8	Testmodus fr Rechenzeitermittlung
27.9.98		kleine Fehler korrigiert
29.11.98 V0.9	Anpassung an Linux mit KDE: GetEnv(), class CHARS
25.12.98	Problembehebungen bei negativen Jahreszahlen
1.1.1999 V0.91	Verwendung von rechter Maustaste statt mittlerer unter unix.
		Refresh-Knopf angefgt.
		Menu-Umstellung und neue Menus: Linien->, Fenstergrsse
31.1.99		Mondfinsternisse (Erdschatten simulieren)
		(funktioniert noch nicht richtig)
1.8.99	V1.00	Kleine Fehler korrigiert, die sich unter Linux bemerkbar machten:
		in "char *klartext(int)" fehlendes "static" eingefgt
		inline changemenu(),  menu_switch() und menu_flag() gehen jetzt.
21.9.99		Kleinigkeiten fr Horizontlinie verbessert (Klasse Siluet):
		Siluet::init() Beschrnkung auf <90 Grad
		Noch machen: Menus verbessern, "%q Echter Horizont" "Horizontlinie setzen ..."
			save ... Klarere Benutzerschnittstelle
24.2.02  V1.01	Freeware: Lizenz-Nummern wieder entfernt,
		unbdingt noch machen: Dokumentationen anpassen.
4.4.2004	Falsch gesetzte Zugriffsrechte korrigiert, make unter Linux
		geht jetzt. Dokumentation angepasst (html-Version).
10.4.04  V1.02	Anpassungen fr MacOSX
2.5.04		Fehler mit stdout korrigiert
27.5.07   1.03  Grafischer Start, dazu auch unix-Version von pfadexpander
                angepasst.
30.5.07		kleine Fehler korrigiert: [40] --> [N40]
		                          fuer Dateinamen: [N200]
2.6.07          Statt XV neu showpict verwendet
17.6.07   1.04  Zu kleine Schriften korrigiert (hy* wurden durch textsize()
                veraendert). Umlaute in Ausgabetexten jetzt auch in UTF8.
		Seperater Menupunkt fuer Uebertreibfaktor.
		Ortsname und Koordinaten neu auf 2 Zeilen angeschrieben.
4.7.07          DEBUG2 um Fehler beim Starten mit Knoppix zu finden.
5.7.07    1.05  Bessere Fehlermeldung bei "nicht in aktuellem Pfad"
22.6.2019	Fehler in animation_load() korrigiert,
		in makefile -Wno-write-strings eingefuegt,
		neu: OBERER_FENSTERRAND,
		neues Hilfsprogramm: yless

 noch zu tun:
- Mondfinsternis Fehler suchen
- mehr Sterne einfgen
- einfache Zeitmaschine (Knpfe fuer Vor, Zurck und Stop)
- Pause bei Animationen beim Drcken eines Mausknopfs
- equinox der Fixsterne
- exakte Berechnung der Mondphasen
- Sehr helle Sterne und Planeten als mehrere Pixel zeichnen (morpix)
- Sternbilder zeichnen
- Doubel-Buffering fr fliessendere Animationen
- weitere Optimierungen, ev. alle Winkel in RAD
*/

#define OBERER_FENSTERRAND 40 //zu grosser Rand z.B. bei Opensuse
                              //auskommentieren fuer bisheriges Verhalten

//hier aktuelles System einstellen:
//oder besser im makefile einstellen und hier alle auskommentiert lassen!
//#define LINUX
//#define MACOSX
//#define IBM_AIX_UNIX
//#define DEC_Alpha_UNIX
//#define VAXORALPHA

#ifdef MACOSX
#define unix
#define INLINEABS
#endif
#ifdef LINUX
//#define unix //ist bei LINUX schon vordefiniert
//#define INLINEABS //wird je nach Compiler gebraucht oder nicht
#endif
#ifdef IBM_AIX_UNIX
#define unix
#endif
#ifdef DEC_Alpha_UNIX
#define unix
#endif

const char
  *ADRESSE=
"  Rolf Pfister\n  Baumgartenstr.11\n  CH-8118 Pfaffhausen\n\
  email: rolf.pfister@chem.uzh.ch\n\
  www.rolfp.ch/\n";

static char	*PLANETIUMPFAD="Planetium:",
		*VOREINSTDATEI="Planetium:plan.vor",
		*BILDPFAD="Planetium:bilder/",
		*ZUPHASENTABELLE="Planetium:bilder/mond/zu.phasentabelle",
		*ABPHASENTABELLE="Planetium:bilder/mond/ab.phasentabelle",
		*sterntabname="sterntabelle.dat",
		*ortstabname ="ortstabelle.dat",
		*komettabname="kometen.dat",
		*TMP_EPHEMERIDEN="RAM:ephemeriden.tmp",
		*TMP_STDOUT="RAM:planetium.tmp",
#ifdef unix
		*CPFAD="PATH:",
#else
		*CPFAD="c:,Sys:Utilities,Sys:System,s:",//provi.
#endif
		*README="Planetium:Docs/Planetium.liesmich",
		*README2="Planetium:Docs/html/index.html",
		*USERDATA="Planetium:userdata";
#define COMAX 120

//Voreinstellungen wenn kein plan.vor vorhanden:
#ifdef unix
#ifdef DEBUGMACOSX
static char show_text[COMAX]="/Applications/Safari.app/Contents/MacOS/Safari",
            show_pict[COMAX]="/Applications/Safari.app/Contents/MacOS/Safari",
	    show_html[COMAX]="/Applications/Safari.app/Contents/MacOS/Safari",
#else
static char	show_text[COMAX]="showtext", //"MultiView",
                show_pict[COMAX]="showpict", //xv, display, ...
		show_html[COMAX]="showhtml", //konqueror, safari, firefox, ...
#endif
#else /*AMIGA*/
static char	show_text[COMAX]="MultiView",//in plan.vor aktuallisiert
		show_pict[COMAX]="MultiView", //oder: Viewtek, Cybershow
		show_html[COMAX]="aweb", //aweb, konqueror, opera, mozilla,...
#endif
		*NICHT_IN_C="Warnung: %s nicht in aktuellem Pfad zu finden!\nPfad=%s",
		aktion[100]="\000";
static int	aktionzaehler=0;

const int  MINIMOON=0,EXACTMOON=1;
static int moonflag=EXACTMOON;
static int mofiflag=0; //provi. Mondfinsternis-Flag

//#include <stdio.h>
//#include <math.h>
//#include <ulong.h>
#include <stdlib.h>
#include "astro.h"
#include "astro2.h"
#include "planets200.h"
#include "moon.h"
#include <ctype.h>
#include <string.h>
#include <xtekplot1.h>
#ifdef unix
#include "zeitklasse.h"
#else
#include <zeitklasse.h>
#endif

#ifdef unix

//provisorisch:
//#ifdef NULL
//#undef NULL
//#endif
//#define NULL 0

void iffbild_speichern(char *name)
{printf("iffbild_speichern('%s') geht noch nicht unter UNIX\n",name);}
int idfix(double);
FILE *old_stdout,*new_stdout;
void save_stdout() {old_stdout=stdout;}
#ifdef stdout
#undef stdout
#endif
#define stdout new_stdout
#endif /*unix*/

#ifdef amiga
#define AMIGA_OR_POS
#endif
#ifdef pOS
#define AMIGA_OR_POS
#endif

#ifdef amiga
#define GMTIME_FALSCH
#endif

#define N NULL
static int XMAX=640,YMAX=512,TIEFE=5, XRAND=80,YRAND=64;

#define GRADZEICHEN ''

const double	j2000 =  0.0,
		b1950 = -0.500002108,
		MODJDSEC=1.0/(24.*3600.);
const double	GRAD=PI/180,		//Umrechnung von Grad in Rad
		AE=1.4959787e11,	//Astronomische Einheit in Meter
		Gravi=6.672e-11,	//Gravitationskonstante (m/kg/s)
		kgravi=0.01720209895,	//GAUSS-Gravitationskonstante
		clicht=299792500,	//Lichtgeschwindigkeit (m/s)
		SONNENMASSE=1.9891e30,
		TAGE=24*60*60.;		//Anzahl Sekunden pro Tag
const double	PIHALBE=PI/2; //PI,ZWEIPI in "astro.h->pascal.h" definiert
const double	WINKELSTD=360/24;

/* eleganter mit Zeitklasse
char *wochentag[]={
 "Sonntag","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag"};
*/

class provisorische_daten
{
 FILE *fp;
public:
 double saturn_dlong;
 provisorische_daten() {saturn_dlong=90;}
};
static provisorische_daten provi;

#ifdef INLINEABS
inline int abs(int x) {return x>=0?x:-x;}
#endif

/**************************** Farbpalette *******************************/
//auf alten Amigas mssen wir mit 16 Farben auskommen
struct rgbfarbe {UBYTE r,g,b;};

const int WEISS=3,ROT=2,GRUEN=1,BLAU=4,GELB=5,BLAUGRUEN=6,PURPUR=7;

static rgbfarbe farbpalette[1<<5]=
{{  0,  0,  0}, //Hintergrund schwarz
 { 50,150, 50}, //Grn (40 255 20 = giftgrn)
 {255, 40, 20}, //Rot  Grundfarbe fr diverse Sachen
 {255,255,255}, //Weiss fr hellste Sterne (-2 bis 0m)
 { 40, 80,255}, //Blau
 {255,255,  0}, //Gelb  (Sonne)
 {  0,255,255}, //Blaugrn
 {255,  0,255}, //Purpur
//Grauwerte fr Sternhelligkeiten:		Beispiele:
 {200,200,200}, //  0.1 bis 1 m			 XX   X
 {190,190,190}, //  1.1 bis 2			 XX   XX   XX   X
 {180,180,180}, //  2.1 bis 3			 -2  -1.2 -0.8  0
 {170,170,170}, //  3.1 bis 4
 {160,160,160}, //  4.5 bis 6
 {150,150,150}, //  6.5 bis 8
 {140,140,140}, //  8.5 bis 10
 {130,130,130}  // 10.5 bis 12
//bessere Abstufung wenn mehr Farben vorhanden
,{120,120,120}, //All diese Grauwerte werden von palette_init()
 {110,110,110}, //endgltig gesetzt.
 {100,100,100}, //
 { 90, 90, 90}, //
 { 80, 80, 80}, //
 { 70, 70, 70}, //
 { 60, 60, 60}, //
 { 50, 50, 50}, //
//ev. eigne Farbe fr jeden Planeten:
 {200,200, 80}, // Merkur
 {240,240,240}, // Venus
 {200,100,100}, // Mars
 {255,180,180}, // Jupiter
 {200,200,200}, // Saturn
 { 50, 50,100}, // Uranus
 { 90, 90, 90}, // Neptun
 { 80, 80, 80}  // Pluto
};
const int GRAU1=8;
static int GRAU2=(TIEFE>=5)?31:15;

void complement_farbe(int nr) //stark Hardwareabhngig !
{
 rgbfarbe *p;
 if(nr==0) nr=GRAU2;
 p = &farbpalette[nr];
 setcolor(GRAU2,p->r,p->g,p->b);
}
void mydrawmode(int mode)
{
 if(mode==COMPLEMENT)
   {complement_farbe(PURPUR);
    drawmode(mode);
   }
 else
   {drawmode(mode);//wieder normaler Zeichnungsmodus
    complement_farbe(0);
   }
}

void vertausche(rgbfarbe& a,rgbfarbe& b)
{
 rgbfarbe h;
 h.r=a.r; h.g=a.g; h.b=a.b;
 a.r=b.r; a.g=b.g; a.b=b.b;
 b.r=h.r; b.g=h.g; b.b=h.b;
}
void setcolor(int n,rgbfarbe& x) {setcolor(n,x.r,x.g,x.b);}
void vertausche_setcol(int i,int j,rgbfarbe& a,rgbfarbe& b)
{
 vertausche(a,b);
 setcolor(i,farbpalette[i]);
 setcolor(j,farbpalette[j]);
}
void weiss_schwarz_tausch()
{
 vertausche_setcol(0,3,farbpalette[0],farbpalette[3]);
 for(int i=GRAU1,j=GRAU2;i<j;i++,j--)
   vertausche_setcol(i,j,farbpalette[i],farbpalette[j]);
}

void palette_init()
{
 rgbfarbe *p;
 int i,max=(1<<TIEFE),max1,c,dc;
 for(p=farbpalette,i=0;i<8;i++,p++) //Grundfarben
   setcolor(i,p->r,p->g,p->b);
 if(TIEFE>=5) max1=24; else max1=16;
 for(c=255,dc=(c-50)/(max1-8);i<max1;i++,p++) //Grauwerte
   {c -= dc;
    setcolor(i,p->r=c,p->g=c,p->b=c);
   }
/**test**
 i=8; c=0;
 setcolor(i,p->r=255,p->g=c,p->b=c); i++; p++;
 setcolor(i,p->r=c,p->g=255,p->b=c); i++; p++;
 setcolor(i,p->r=c,p->g=c,p->b=255); i++; p++;
 setcolor(i,p->r=255,p->g=255,p->b=c); i++; p++;
 setcolor(i,p->r=255,p->g=c,p->b=255); i++; p++;
 setcolor(i,p->r=c,p->g=255,p->b=255); i++; p++;
 setcolor(i,p->r=128,p->g=c,p->b=c); i++; p++;
 setcolor(i,p->r=c,p->g=128,p->b=c); i++; p++;
**/
 for(;i<max;i++,p++) //restliche Farben
   setcolor(i,p->r,p->g,p->b);
 GRAU2=(TIEFE>=5)?31:15;
}

int mag2col(double mag,int& morpix)
{
 if(mag<=0)
   {if(mag <= -1.6) {morpix=7;
		     if(mag< -10 && mag> -20) return BLAUGRUEN;//test: Mond
		     if(mag< -20) return GELB;//Sonne
		    }
    else if(mag <= -1.0) morpix=3;
    else if(mag <= -0.4) morpix=1;
    else morpix=0; //Pixelgrsse bei sehr hellen Objekten
    return WEISS;
   }
#if (TIEFE>=5)
//Farbnummern WEISS,8...23 verfgbar:
 if(mag<12) return 8+int(mag*1.25);
 return 23;
#else
//Farbnummern WEISS,8...15 verfgbar:
 if(mag<5)  return 8+int(mag);
 if(mag<10) return 10+int(mag*0.5);
 return 15;
#endif
}

/************************* Globale Variablen ****************************/
static char argflag[128];
#ifdef DEBUG
static char printer[80]="RAM:tmp.dat";
#else
static char printer[80]="prt:";
#endif
static FILE *fpprint=NULL;
static char scratch[400];	//von diversen Funktionen benutzt
static char scratch3[400];	//fr janeinrequester3() benutzt
static char scratch2[1024];	//fr janeinrequester() benutzt
static char scratch1[1024];	//fr runsystem() benutzt
static REAL33	amatrix;	//von Astro-Funktionen verwendet
static int	mode='A';	//'A'=apparent  'J'=astrometric (J2000)
static int	wbflag=0;

//Koordinaten in Grad:
static double	g_lambda= -8.5,	//Geographische Lnge (negativ fr Osten)
		g_phi=47.4,	//Geographische Breite (negativ fr Sden)
		lambda,phi;	//aus Geogr. und Beobacht.-Koord berechnet
static char ortsname[80]="Zrich";

//Zeiten:
static int	zeitzone=1;	//zeitzone = Ortszeit - Weltzeit (in Std)
static Zeit	zeit(WELTZEIT); //Aktuelle Weltzeit
static double	sternzeit,	//in Grad
		modjd,		//Zeit der aktuellen Darstellung (in MJD)
		a_start,a_end,	//Zeiten fr Animation (MJD)
		a_step; 	//Schrittweite fr Animation (in Tage)
static int 	animflag=0,	//0=gestopt 1=starte 2=gestartet -1=stoppe
		echtzeitflag=2, //Darstellung in Echtzeit
		anim_dt=5;	//Verzgerungszeit in Ticks

//Darstellung:
const int HORIZONTAL=0,EQUATORIAL=1,EKLIPTAL=3,//mgliche Darstellungsarten
	  DARAUTO=2; //nur fr koorflag
static int	darart=HORIZONTAL, //Darstellungsart
		koorflag=DARAUTO;  //fr Menu-Auswahl
static double	beobachtradius=90,//in Grad
		beobachtradia=90*GRAD,//in RAD
		uebertreib=10,	  //Vergrsserungsfaktor (1.0 = normal)
		beo_azimut=0.,	  //Beobachtungsrichtung in Grad
		beo_h=90.,	  //Beobachtungshhe in Grad
		beo_sinaz=sin(beo_azimut*GRAD),
		beo_cosaz=cos(beo_azimut*GRAD),
		beo_sin90h=sin((90-beo_h)*GRAD),
		beo_cos90h=cos((90-beo_h)*GRAD), //fr schnelles Drehen
		//fr darart=EQUATORIAL :
		beo_ra=0.,	  //Beobachtungsrichtung in Grad
#define beo_tau beo_ra
		beo_dec=90.,	  //Beobachtungshhe in Grad
		beo_sinra=sin(beo_ra*GRAD),
		beo_cosra=cos(beo_ra*GRAD),
		beo_sin90dec=sin((90-beo_dec)*GRAD),
		beo_cos90dec=cos((90-beo_dec)*GRAD);//fr schnelles Drehen
static int	anschreibflag=1,  //Anschreiben von Planeten
		refresh=2,	  //Refresh bei Animation
		anzahlsterne=2;   //soviele Fixsterne zeichnen
static double	bx=0.024,hy=0.04, //Breite, Hhe der Buchstaben (Planeten)
		bx2=0.033,hy2=0.055, //Buchstaben fr grosse Schrift (Zeit)
		bx3=0.022,hy3=0.038, //und fr mittlere Schrift (Knpfe)
		hyw=0,hy2w=0,hy3w=0, //wahre Schrifthoehen
		dufaktor;	  //=uebertreib/2./beobachtradius; (Optim.)

static int	maxanzahlsterne=2,//Anzahl gespeicherte Sterne
		anzfixanschr=2,   //Anzahl Fixsterne anschreiben
		fixanschrflag,    //aktueller Fixstern anschreiben
		darmenu=0,	  //Darstellung Menauswahl
		mausemu=0,	  //Emuliere mittlere Maustaste durch linke
		limaus=LIMAUS,
		anzahlkometen=0;  //Anzahl gespeicherte Kometen (Kleinplan.)

const int GRID_RA=1,GRID_DEC=2,GRID_EKL=4,GRID_HOR=8,GRID_EQ=16,GRID_OFF=0;
static int	grids=GRID_OFF;	  //zu zeichnende Gitterlinien

//struct sonnendaten {double tt,ls,bs,rs; REAL33 as;};
struct sonnendaten {double ls,bs,rs; REAL33 as;};
static sonnendaten sonne;

static int	printephem_flag=0; //zum Ausdrucken von Ephemeriden
#ifdef DEBUG
static int	beokoflag=0;//test alte Beobacht-Koordinatenumrechnung
#endif

int menu_flag(long id,long *ids,int k,int max,char **text,int flag);

#ifdef unix
//Dies ist unter Linux ntig, weil sonst das Programm abstrzt wenn es
//versucht mit menu_switch() die Menu-Texte zu ndern. (SIGSEGV-Fehler)
class CHARS
{
public:
 char *txt;
 CHARS(char *s) {txt=new char[strlen(s)+1]; strcpy(txt,s);}
 char& operator[](int i) {return txt[i];}
};
inline int
 menu_switch(long id,long *ids,int k,int max,CHARS *txt,int k1=0,int k2=0)
{
 return menu_switch(id,ids,k,max,&txt->txt,k1,k2);
}
inline int
 menu_flag(long id,long *ids,int k,int max,CHARS *txt,int flag)
{
 return menu_flag(id,ids,k,max,&txt->txt,flag);
}
inline void changemenu(long id,CHARS& txt) {changemenu(id,txt.txt);}

//MACOSX braucht das offenbar:
inline void setsubmenu(int n,void*p1,CHARS& txt, void*q1,funkzeiger m)
{setsubmenu(n,p1,&txt[0],q1,m);}
inline void setsubmenu(int n,void*p1,void*p2,CHARS& txt,
		       void*q1,void*q2,funkzeiger m)
{setsubmenu(n,p1,p2,&txt[0],q1,q2,m);}
//

#else
typedef char* CHARS;
#endif

static long dar_ids[8];
static CHARS dar_txt[6]=
	{"%R ganze Himmelskuppel",
	 "%r Sdsicht", "%r Westsicht", "%r Nordsicht", "%r Ostsicht",
	 "%r manuell ..."
	};
static long maus_ids[2],mond_ids[2],koor_ids[3];
static CHARS maus_txt[2]={"%R mittlere Maustaste","%r linke Maustaste"};
static CHARS mond_txt[2]={"%r auf 5' genau","%R auf 1'' genau"};
static CHARS koor_txt[3]={"%r Horizontal","%r Equatorial","%R Auto"};

//Nachfhrung:
const int NACHF_OFF=0,
	  NACHF_STERN=1, //normale Nachfhrung (Sterne bleiben stehen)
	  NACHF_OBJ=2,   //auf Objekt nachfhren (z.B. Planet bleibt stehen)
	  NACHF_STERN_START=9, //mglichst bald auf NACHF_STERN schalten
	  NACHF_MASK=0x7; //Maske um Menu-Position zu erhalten
static int nachfuehrung=NACHF_OFF;
//static double sternzeit2;
class Planet;
static Planet *nachfuehrplanet=NULL;
static char nachfuehrobjekt[80]="Sonne";
static long nachf_ids[3];
static CHARS nachf_txt[3]=
	{"%R ohne Nachfhrung",
	 "%r Normale Nachfhrung",
	 "%r Nach Objekt Nachfhren"
	};
static long linien_ids[8];
static CHARS linien_txt[5]=
	{"%r Ekliptik","%r quator","%r Horizont","%r RA","%r DEC"};
static CHARS echterhorizont_txt=(CHARS)"%QEchter Horizont ...",
	     erdschatten_txt=(CHARS)"%qErdschatten ein/aus";

class Darstack
{
 int me[16],i,j;
 double radius[16],az[16],ho[16];
public:
 Darstack() {j=i=0;}
 void push();
 void pop();
};
void Darstack::push()
{
 me[i]=darmenu; radius[i]=beobachtradius;
 if(darart==HORIZONTAL)
	{az[i]=beo_azimut; ho[i]=beo_h;}
 else	{az[i]=beo_ra; ho[i]=beo_dec;}
 if(++i==16) i=0;
 if(j==i) {if(++j==16) j=0;} //bei berlauf ltester Eintrag lschen
}
void Darstack::pop()
{
 if(i==j) return;//bei Leerem Stapel --> nichts tun
 if(--i<0) i=15;
 darmenu=me[i]; beobachtradius=radius[i];
 if(darart==HORIZONTAL)
	{beo_azimut=az[i]; beo_h=ho[i];}
 else	{beo_ra=az[i]; beo_dec=ho[i];}
}

static Darstack dar_hist;

class Fenster
{
 double fa;
 double xmin,ymin,xmax,ymax;
public:
 Fenster() {xmin= -1.2625; ymin= -1.01; xmax=1.2625; ymax=1.01;}
 void oeffnen()
	{inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
	 static char titel[80]; sprintf(titel,"Planetium %s",VERSION);
	 set_tektitel(titel);
	}
 void neuegroesse(int breite,int hoehe,int tiefe);
};
void Fenster::neuegroesse(int breite,int hoehe,int tiefe)
{
 double asp=getaspect();
 double faktor1=1.35/asp,//optimales Breite/Hoehe-Verhltnis
        faktor2=1.25/asp;//minimales Breite/Hoehe-Verhltnis
 int br=int(hoehe*faktor1+0.5);
 if(breite>=br) breite=br;
 else
   {int ho=int(breite/faktor2+0.5);
    if(hoehe>ho) hoehe=ho;
   }
 xmax=ymax/hoehe*breite*asp;
 xmin= -xmax;
#ifdef DEBUG
 printf("breite=%d hoehe=%d  xmin= %lf xmax=%lf\n",breite,hoehe,xmin,xmax);
#endif
 setsize(XMAX=breite,YMAX=hoehe,tiefe);
}

static Fenster fenster;

/********************* Eigenschaften der Planeten ***********************/
const double UNBEKANNT=1;
static double albedo[11]=
	{UNBEKANNT, //Sonne
	 0.096, //Merkur
	 0.76, //Venus
	 0.39, //Erde
	 0.15, //Mars
	 0.42, //Jupiter
	 0.23, //Saturn
	 0.45, //Uranus
	 0.28, //Neptun
	 0.5, //Pluto +-0.1
	 0.07, //Erdmond
	};

/************************** Vordeklarationen ****************************/
#ifdef DEBUG
void debugg(const char *s,char *s1,char *s2=NULL,char *s3=NULL);
void debugg(const char *s,long p1,long p2=0,long p3=0);
void debugg(const char *s,double p1,double p2=0,double p3=0);
void debugg(const char *s,int p1,int p2=0,int p3=0);
void debugg6(const char *s,int p1,int p2,const char *s1,const char *s2,
	     double,double);
void debugg(const char *s,char *s1,double,double,double);
void lambdaphi_berechnung(double glam,double gphi,double baz,double bh);
#endif /*DEBUG*/
void ortskoordinaten(double geobr,double geoho);
int sucheortsname(char *name);
void zeichne_planetarium();
void animiere_planetarium();
void statischer_rand();
void dynamischer_rand(int flg=1);
void aktion_schrift(int start=0);
void rand_zeit(int flag=1);
//inline void rand_zeit() {dynamischer_rand(0);}//provi.
int echtzeit_aktualisierung();
void erdmond(double t);
void kometen(double t);
void kometen_einlesen();
void drehung(double sinw,double cosw,double& x,double& y);
inline void drehung(double w,double& x,double& y)
	{drehung(sin(w),cos(w),x,y);}
void ausdrucken(const char *name,double ra=0,double dec=0,double abstand=0,
		double durchm=0,double mag=0);
bool haz2beoko(double *x,double *y,double h,double az);
bool taudec2beoko(double *x,double *y,double dec,double tau);
inline bool radec2beoko(double *x,double *y,double dec,double ra)
{
 return taudec2beoko(x,y,dec,sternzeit-ra);
}
double planetmag(int iplan,double r,double delta,
		 double phi,double dec,double dlong);
double sonne_und_planeten();
void ausdruckstop();
#ifdef AMIGA
int get_zeitzone();
#else
inline int get_zeitzone() {return zeitzone;}
#endif
class Sternbild;
Sternbild *put_sternbild(char *name);
void maus_press();
void maus_release();
void maus_motion();
void init_knoepfe();
void runsystem(char*);
void runsystem2(char*,char*);
bool zeigebild(double ra,double dec,double sektor);
bool objektbild(int ix,int iy,const char *name,double ra=0,double dec=99);
void zeigemondbild(int ix,int iy,char *defaultbild);
void voreinstellungen_save(char*);
void voreinstellungen_load(char*);
void animation_save(char *name);
void animation_load(char *name);
void finsternis_test(double rmond,double rsonne);
char *finsternis_text();
void grids_zeichnen(int clear=0);
inline void grids_loeschen() {grids_zeichnen(1);}
void erdschatten_berechnen(double sabst,double tt,double teqx,
			   double x,double y,double z);
void grids_menus_markieren();
FILE *fopen2(char *na,char *rw);
void pfadexpand_init();

/***************************** Kleinkram ********************************/
char *ohnepfad(char *name)
{
//Beispiele:	c:viewtek --> viewtek
//		sys:Utilities/Multiview --> Multiview
 int c;
 char *s,*t=NULL;
 for(s=name;c= *s++;)
   if(c==':' || c=='/') t=s;
 if(t)
   for(s=name;*s++ = *t++;) ;
 return name;
}

char *strkopie(char *s)
{
 if(s==NULL) return NULL;
 char *t,*t0;
 t=t0=new char[strlen(s)+1];
 while(*t++ = *s++) ;
 return t0;
}

bool getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

bool vorhanden(char *dateiname)
{
 FILE *fp;
 if(fp=fopen2(dateiname,"r"))
   {fclose(fp); return 1;}
 return 0;
}

/**
bool vorhanden(char *pfade,char *dateiname)
{			//Sucht nach Dateiname in Pfaden die
 FILE *fp;		//in 'pfade' durch Kommas getrennt sind.
 char *name,*s,*t;
 name=new char[strlen(pfade)+strlen(dateiname)+2];
 int ret=0,c;
 while(*pfade)
  {for(s=name;(c= *pfade++) && c!=',';) *s++ = c;
   t=pfade; --t; if(*--t!=':') *s++ = '/';
   for(t=dateiname;c= *t++;) *s++ = c;
   *s=0;
   if(fp=fopen(name,"r"))
     {fclose(fp); ret=1; break;}
  }
 delete name;
 return ret;
}
**/

bool c_expand(char *pfade,char *dateiname)
{			//Sucht nach Dateiname in Pfaden die
 FILE *fp;		//in 'pfade' durch Kommas getrennt sind,
 char *name,*s,*t;	//und setzt vollstndiger Pfad ein.
#ifdef DEBUG2
 fp=fopen("/tmp/debug-planetium.tmp","w");
 fprintf(fp,"c_expand(pfade='%s',dateiname='%s'\n",pfade,dateiname);
 fclose(fp);
#endif
 if(fp=fopen(dateiname,"r"))
   {fclose(fp); return 1;}
 ohnepfad(dateiname);
 name=new char[strlen(pfade)+strlen(dateiname)+2];
 int ret=0,c;
 while(*pfade)
  {for(s=name;(c= *pfade++) && c!=',';) *s++ = c;
   t=pfade; --t; if(*--t!=':') *s++ = '/';
   if(c==0) --pfade;
   for(t=dateiname;c= *t++;) *s++ = c;
   *s=0;
   if(fp=fopen(name,"r"))
     {fclose(fp); ret=1;
      strcpy(dateiname,name);
      break;
     }
  }
 delete name;
 return ret;
}

Zeit getweltzeit()
{
 Zeit z(WELTZEIT);
#ifdef GMTIME_FALSCH
 z.addstd(-zeitzone);
#endif
 return z;
}

int sq(int x) {return x*x;}

int fastgleich(double x,double y)
{
 const double e1=1.0+1e-6, e2=1.0-1e-6;
 return (x>y*e2 && x<y*e1);
}

bool isbetween(double x,double a,double b)
{
 return (a>b)?(x<a && x>b):(x<b && x>a);
}

char *uebersetzen(char *latein)
{
 static char *tabelle[]={"Andromeda","Andromeda", "Aquarius","Wassermann",
  "Aquila","Adler", "Aries","Widder", "Auriga","Fuhrmann",
  "Bootes","Bootes", "Camelopardalis","Giraffe", "Cancer","Krebs",
  "Canes Venatici","Jagdhunde", "Canis Maior","Grosser Hund",
  "Canis Minor","Kleiner Hund", "Capricornus","Steinbock",
  "Cassiopeia","Kassiopeia", "Centaurus","Kantaur", "Cepheus","Kepheus",
  "Cetus","Walfisch", "Columba","Taube",
  "Coma Berenices","Haar der Berenike",
  "Corona Borealis","Nrdliche Krone", "Corvus","Rabe", "Cygnus","Schwan",
  "Delphinus","Delfin", "Draco","Drache", "Equuleus","Fllen",
  "Eridanus","Eridanus", "Fornax","Ofen", "Gemini","Zwillinge",
  "Hercules","Herkules", "Hydra","Wasserschlange", "Lacerta","Eidechse",
  "Leo","Lwe", "Leo Minor","Kleiner Lwe", "Lepus","Hase",
  "Libra","Waage", "Lupus","Wolf", "Lynx","Luchs", "Lyra","Leier",
  "Monoceros","Einhorn", "Ophiuchus","Schlangentrger", "Orion","Orion",
  "Pegasus","Pegasus", "Perseus","Perseus", "Pisces","Fische",
  "Piscis Austrinus","Sdlicher Fisch", "Puppis","Achterdeck",
  "Pyxis","Kompass", "Sagitta","Pfeil", "Sagittarius","Schtze",
  "Scorpius","Skorpion", "Sculptor","Bildhauer", "Scutum","Schild",
  "Serpens","Schlange", "Sextans","Sextant", "Taurus","Stier",
  "Triangulum","Dreieck", "Ursa Maior","Grosser Br",
  "Ursa Minor","Kleiner Br", "Virgo","Jungfrau", "Vulpecula","Fchschen",
  NULL,NULL};
 char **p,*s;
 for(p=tabelle;s= *p++;)
   if(strcmp(s,latein)==0) return *p;
 return latein;
}

bool hatendung(char *name,char *e1)
{
 int c,c0= *e1++;
 while((c= *name++))
   if(c==c0 && strcmp(name,e1)==0) return true;
 return false;
}
inline bool hatendung(char *name,char *e1,char *e2)
{
 return (hatendung(name,e1) || hatendung(name,e2));
}

char *takon(char *pfad,char *name) //Pfad und Dateiname zusammenfgen
{
 int c;
 char *s,*str;
 s=str=new char[strlen(pfad)+strlen(name)+2];
// printf("takon(%s,%s) --> ",pfad,name);//test
 if(*pfad)
  {while(c= *pfad++)  *s++ = c;
   --pfad;
   if((c= *--pfad)!=':' && c!='/') *s++ = '/';
  }
 while(c= *name++)  *s++ = c;
 *s=0;
// printf("'%s'\n",str);//test
 return str;
}

class Aktuellerpfad
{
 char *pfad;
public:
 Aktuellerpfad() {pfad=NULL;}
 ~Aktuellerpfad() {if(pfad!=NULL) delete[] pfad;}
 void set(char *arg0)
	{char *s; int n=strlen(arg0);
	 pfad=new char[n+1];
	 strcpy(pfad,arg0);
	 for(s= &pfad[n];*--s!='/';) ;
	 *s=0;
	 setenv("PWD",pfad,1);
	 setenv("PLANETIUM",pfad,1);
	 setenv("RAM","/tmp",1);
	}
 FILE *fopen2(char *name,char *rw);
};
static Aktuellerpfad pwd;

FILE *Aktuellerpfad::fopen2(char *name,char *rw)
{
 FILE *fp;
 if(pfad!=NULL && *name!='/')
  {//printf("pfad='%s'\n",pfad);//test
   char str[strlen(pfad)+strlen(name)+2];
   sprintf(str,"%s/%s",pfad,name);
   fp=fopen(str,rw);
  }
 else fp=fopen(name,rw);
 return fp;
}
FILE *fopen2(char *na,char *rw) {return pwd.fopen2(na,rw);}

FILE *fopen1(char *datei,char *rw)
{
 FILE *fp=pwd.fopen2(datei,rw);	//ffne Datei,
 if(fp==NULL)			//wenn nicht vorhanden
   {char *s;			//dann in Planetium: suchen.
    fp=fopen(s=takon(PLANETIUMPFAD,datei),rw);
    delete s;
   }
 return fp;
}

int janeinrequester2(char *s,char *s2,char *s3=NULL)
{
 sprintf(scratch2,s,s2,s3);
 janeinrequester(scratch2);
}

int janeinrequester3(char *s,char *s2,char *ja="ok",char *nein="ok")
{
 sprintf(scratch3,s,s2);
 janeinrequester(scratch3,ja,nein);
}

void sscan_string(char *quelle,char *ziel)
{
 int c2,c= *quelle++;
 if(c!='"' && c!='\'') {c='\n'; --quelle;}
 while((c2= *quelle++) && c2!=c) *ziel++ = c2;
 *ziel=0;
}

/************************** Fehlermeldungen *****************************/
void insterror(char *s1,char *s2)
{
 char *str=new char[strlen(s1)+strlen(s2)+1];
 sprintf(str,s1,s2);
 sprintf(scratch2,"%s\nVermutlich fehlerhafte Installation,\n\
beachten Sie die Hinweise in '%s'",str,README);
 janeinrequester(scratch2);
 delete str;
}

/************************ Winkel-Umrechnungen ***************************/
char *rad2sdeg(double rad)
{
 char *s=new char[16];
 int grad,min,sec,vorzeichen;
 if(rad<0.) {vorzeichen=1; rad= -rad;} else vorzeichen=0;
 rad/=GRAD;
 grad=int(rad);
 rad=(rad-grad)*60.;
 min=int(rad);
 sec=int((rad-min)*60.+0.5);
 if(sec>=60) {sec=0; if(++min>=60) {min=0; grad++;}}
 grad %= 360;
 if(vorzeichen)
   sprintf(s,"%s%d%02d'%02d''",(grad>=10)?"-":" -", grad,min,sec);
 else
   sprintf(s,"%3d%02d'%02d''",grad,min,sec);
 return s;
}
char *grad2s(double w)  //Ausgabe eines kleinen Winkels in Grad
{
 static char str[16];
 char *s=str;
 int grad,min,sec; double dsec;
 if(w<0.) {w= -w; *s++ = '-';}
 grad=int(w);
 w=(w-grad)*60.;
 min=int(w);
 dsec=(w-min)*60.;
 sec=int(dsec+0.5);
 if(sec>=60) {sec=0; if(++min>=60) {min=0; grad++;}}
 if(grad==0)
   {if(min==0)
      {if(sec>=20) sprintf(s,"%d''",sec);
       else if(dsec>=2.0) sprintf(s,"%.1lf''",dsec);
       else sprintf(s,"%.2lf''",dsec);
      }
    else sprintf(str,"%d'%02d''",min,sec);
   }
#ifdef UTF8
 else sprintf(s,"%d°%02d'%02d''",grad,min,sec);
#else
 else sprintf(s,"%d%02d'%02d''",grad,min,sec);
#endif
 return str;
}

char *std2shou(double rad)
{
 static char s[16];
 int hour,min,sec,vorzeichen;
 if(rad<0.) {vorzeichen=1; rad= -rad;} else vorzeichen=0;
 hour=int(rad);
 rad=(rad-hour)*60.;
 min=int(rad);
 sec=int((rad-min)*60.+0.5);
 if(sec>=60) {sec=0; if(++min>=60) {min=0; hour++;}}
 hour %= 24; if(vorzeichen) hour = -hour;
 sprintf(s,"%3d:%02d:%02d",hour,min,sec);
 return s;
}
inline char *rad2shou(double rad) {return std2shou(rad*(24./ZWEIPI));}
inline char *grad2shou(double x) {return std2shou(x*(GRAD*24./ZWEIPI));}

/************************ Rechnen mit Zeiten ****************************/
// Tips: alle Zeiten in MJD umrechnen (double) und nur fr Ein/Ausgaben
//       in Klasse Zeit oder String umrechnen.

/*----------------------------------------------------------------------*/
/* CALDAT: Finds the civil calendar date for a given value              */
/*         of the Julian Date (JD).                           */
/*         Julian calendar is used up to 1582 October 4,                */
/*         Gregorian calendar is used from 1582 October 15 onwards.     */
/* jd2datum: optimierte Version, funktioniert auch fr negative Jahreszahlen
/*	     Returnwert: hour
/*----------------------------------------------------------------------*/
double jd2datum(double jd1,int* day,int* month,long* year)
{
 long c,d,e,f,jd0;
 int m;
 jd0 = long(jd1+0.5);
 if(jd0<2299161)              /* calendar:    */
	c=jd0+1524;           /* -> Julian    */
 else	{                     /* -> Gregorian */
	 long b=long((jd0-1867216.25)/36524.25);
	 c=jd0+b-b/4+1525;
	}
 d=long((c-122.1)/365.25); e=365*d+d/4; f=long((c-e)/30.6001);
 *day = c-e-long(30.6001*f);
 *month = m = f-1-12*long(f/14);
 *year = d-4715-(7+m)/10;
 if(*year<=0) --(*year);//es gab kein Jahr 0, deshalb Korrektur
 return 24.0*(jd1+0.5-jd0);
}
inline double mjd2datum(double j,int* day,int* month,long* year)
	{return jd2datum(j+2400000.5,day,month,year);}

char *mjd2str(double j,char *str=NULL)
{
// Beispiele: " 1.1.1997   8:00:00"
//            "31.12.1997 23:59:59"
 if(str==NULL) {str=new char[32];}
 Zeit z;
 z.setmjd(j);
 z.stri(str);
 return str;
}

char *dmjd2str(double j,char *str=NULL)
{
 int tag,std,min,sec;
 tag=int(j); j=(j-tag)*24.0;
 std=int(j); j=(j-std)*60.0;
 min=int(j); j=(j-min)*60.0;
 sec=int(j+0.5);
 if(sec==60) {sec=0; if(++min==60) {min=0; if(++std==24) {std=0; ++tag;}}}
 if(str==NULL) {str=new char[32];}
 sprintf(str,"%2dd %2d:%02d:%02d",tag,std,min,sec);
 return str;
}

double str2mjd(char *str)
{ //funktioniert auch fr negative Jahreszahlen. Bis -4713
 int tag,mon,jahr,std,min,sec;
 sscanf(str,"%d%*c%d%*c%d %d%*c%d%*c%d",&tag,&mon,&jahr, &std,&min,&sec);
 //if(jahr<0) jahr+=1; //provisorische Korrektur
 return mjd(tag,mon,jahr,std+min/60.+sec/3600.);
}

double str2dmjd(char *str)
{
 int tag,std,min,sec;
 sscanf(str,"%d%*c%d%*c%d%*c%d",&tag,&std,&min,&sec);
 return (std+min/60.+sec/3600.)/24.+tag;
}

inline double mjd(Zeit& z)
{
 return mjd(z.tag,z.mon,z.jahr,z.std+z.min/60.0+z.sec/3600.0);
}

class Systemzeit
{
public:
 int ticks;
 unsigned long secseit1970;
 Systemzeit();
 Systemzeit& operator++();
 Systemzeit& operator+=(int);
 void test();
};
Systemzeit::Systemzeit()
{
 Zeit z;
 secseit1970=z.lokalzeit();
 ticks=0;
}
Systemzeit& Systemzeit::operator++()
{
 if(++ticks==TICKS_PER_SECOND) {ticks=0; ++secseit1970;}
 return *this;
}
Systemzeit& Systemzeit::operator+=(int x)
{
 ticks+=x;
 while(ticks>=TICKS_PER_SECOND) {ticks-=TICKS_PER_SECOND; ++secseit1970;}
 return *this;
}
void Systemzeit::test()
{
 Zeit z;
 z.set(1,1,1970,0,0,secseit1970);
 printf("Systemzeit = %s\n",z.stri());
}

/*************************** class Planet *******************************/
/* in diesem Programm werden die Bahnelemente nicht verwendet */
const long SEP94=0; //long(jd(5,9,1994)+0.5);

class Planet
{
 int	ix,iy,ix2,iy2,gezeichnetflag,
	r1,r2,  //Radius bei Darstellung (Pixelkoordinaten)
	farbnr, //Farbe bei Darstellung
	morpix; //Zustzliche Pixel um Helligkeit zu erhhen
 double magp[4];//Parameter fr mag Berechnung
 int	nmagp;  //Anzahl gltige Parameter
 void kreis(double x,double y,double du,int farbe);
 //: in diesem Programm neu
 double sonnenmasse; //bei Monden Masse des umkreisten Planeten
 Planet *planet;     //umkreister Planet oder NULL fr Sonne
 double phasenwinkel;
public:
 double phase, //Phase der Beleuchtung von Erde aus gesehen
        elong; //Elongation = Winkelabstand von Sonne (Winkel S-E-P)
 double albedo; //Flchenhelligkeit
 double radius,	//in m
	masse;	//in kg
 char *name;
 double M0,aa,ee,omega,Omega,ii;	//Oskulierende Bahnelemente
   //Einheiten: Winkel: M omega Omega und i in Rad
   //		a in AE,  e ist einheitslos
 double t0,	//Zeitpunkt fr M0 in Tage seit XVORCHRISTUS+1 vor Christus
	t1,M1,	//Momentane Werte
	x,y,z,	//Position
	vx,vy,vz,//Geschwindigkeit
	R,	//Abstand von der Sonne
	U;	//Umlaufzeit in Tagen
 Planet(char*nam,double zeit,double m,double r,	//Werte setzen
	double alb,double *mp,int nmp, //neu auch Albedo u. mag-Parameter
	double M,double a,double e,		//alle Winkel in Grad
	double o,double O,double i,Planet *p=NULL);
// void xyz(double t); //xyz-Koordinaten zum Zeitpunkt t berechnen
//in diesem Programm neu:
 double durchm,mag; //scheinbarer Durchmesser in Grad, Helligkeit
 double ho,az;      //Hhe, Azimut (bisher nur bei Sonne extern verwendet)
 double ra,dec,entf;
 void zeichnen(double abst,double ra,double dec);
 void loeschen();
 void magberechnung(double r,double delta);
 void magberechnung_saturn(double r,double delta,double dlong,double dec);
 void phaseberechnung(double delta);
 int getixiy(int *x,int *y)
   {if(gezeichnetflag) {*x=ix; *y=iy;} return gezeichnetflag;}
};

/** in diesem Programm nicht verwendet:
void v_berechnen(double *vx,double *vy,
		 double vbetrag,double e,double a,double x,double y);
double nu_von_t(double M0,double dt,double *R,double U0,double a,double e);
**/
double hoch3(double x) {return x*x*x;}

Planet::Planet(char *nam,double t,double m,double r,
		double alb,double *mp,int nmp, //neu
		double M,double a,double e,double o,double O,double i,
		Planet *p)
{
 name=nam; t1=t0=t; masse=m; radius=r*1000.0;
 M1=M0=M*GRAD; aa=a; ee=e; omega=o*GRAD; Omega=O*GRAD; ii=i*GRAD;
 planet=p;
 sonnenmasse = (p!=NULL) ? p->masse : SONNENMASSE;
 U=ZWEIPI*sqrt(hoch3(a*AE)/(sonnenmasse+masse)/Gravi)/TAGE; //Umlaufzeit
 albedo=alb;
 for(int i=0;i<nmp;i++) magp[i]=mp[i];
 nmagp=nmp;
 mag=magp[0];
}

/** in diesem Programm nicht verwendet:
void Planet::xyz(double t)
{
//Berechnung der Koordinaten x,y,z und des Geschwindigkeitsvektors vx,vy,vz
//	R = Abstand S-P (Sonne-Planet)
}
**/
/** in diesem Programm neu: **/
void Planet::phaseberechnung(double delta)
{
// static int test=0;
// if(test<10) {++test; printf("R=%lf delta=%lf r=%lf\n",R,delta,sonne.rs);}
//Abstnde: R=Planet-Sonne  delta=Erde-Planet  re=Erde-Sonne
 double cosi,re=sonne.rs;
 cosi=(R*R+delta*delta-re*re)/(2*R*delta);
 phase=0.5*(cosi+1);
 phasenwinkel=acos(cosi);
 elong=acos((delta*delta+re*re-R*R)/(2*re*delta));
}
void Planet::magberechnung(double r,double delta)
{	//r=Abst. zur Sonne, delta=Abst. zu Beob., m0=gesetzt bei Saturn
 double x=0.0,p;
 p=phasenwinkel/(100.0*GRAD);//Phasenwinkel in Hundert Grad
 for(int i=nmagp;--i>0;)
	x = (x+magp[i])*p;
 mag=magp[0]+x+5.0*log10(r*delta);
}
void Planet::magberechnung_saturn(double r,double delta,double dlong,double dec)
{ //siehe Buch S.146
 double sd=abs(sin(dec)),dl=abs(dlong*0.01);
 if(dl>1.8) dl=abs(dl-3.6);
// mag = -8.88 - 2.60*sd + 1.25*sd*sd + 4.40*dl;
 mag = (1.25*sd - 2.60)*sd - 8.88 + 4.40*dl + 5.0*log10(r*delta);
}

double	magp_merkur[]={-0.42,3.80,-2.73,2.00},
	magp_venus[] ={-4.40,0.09, 2.39,-0.65},
	magp_erde[] = {-3.86},
	magp_mars[] = {-1.52,1.60},
	magp_jupiter[]={-9.40,0.50},
	magp_saturn[] ={-8.88,-2.60,1.25},
	magp_uranus[]={-7.19},
	magp_neptun[]={-6.87},
	magp_pluto[] ={-1.0},
	magp_mond[] = {-12.7},//Vollmond
	magp_sonne[] = {-26.7};

Planet
 Sonne("Sonne",SEP94,1.989e30,696260,albedo[0],magp_sonne,1,
       0.,0.,0.,0.,0.,0.),
 Merkur("Merkur",SEP94,3.302e23,2439,albedo[1],magp_merkur,4,
	137.25231, 0.3870983, 0.2056321, 29.10831, 48.33757, 7.00533),
 Venus("Venus", SEP94,4.869e24,6052,albedo[2],magp_venus,4,
	175.14029, 0.7233276, 0.0068088, 54.80361, 76.69455, 3.39471),
 Erde("Erde",  SEP94,5.9578e24,6371,albedo[3],magp_erde,1,
	243.67233, 1.0000000, 0.0167313,334.51714,125.75139, 0.00003),
 Mars("Mars",SEP94,6.42e23,3397,albedo[4],magp_mars,2,
	 80.35665, 1.5237020, 0.0934005,286.52990, 49.57592, 1.85021),
 Jupiter("Jupiter",SEP94,1.899e27,71398,albedo[5],magp_jupiter,2,
	217.12237, 5.2026255, 0.0483745,275.21485,100.47009, 1.30464),
 Saturn("Saturn",SEP94,5.684e26,60000,albedo[6],magp_saturn,3,
	252.59619, 9.5402393, 0.0526286,338.59317,113.65714, 2.48585),
 Uranus("Uranus",SEP94,8.69e25,25559,albedo[7],magp_uranus,1,
	114.65441,19.2685300, 0.0461957,101.58137, 74.06259, 0.77297),
 Neptun("Neptun",SEP94,1.028e26,24712,albedo[8],magp_neptun,1,
	279.60001,30.2080026, 0.0066071,241.71816,131.76366, 1.77116),
 Pluto("Pluto",SEP94,1.e22,1150,albedo[9],magp_pluto,1,
	  6.82632,39.8397880, 0.2553540,114.05238,110.35700,17.12690);
Planet
 Mond("Mond",SEP94,7.35e22,1737.5,albedo[10],magp_mond,1,
	0.0, 384.4e6/AE, 0.0549, 10.65, 196.233333, 5.1452778, &Erde);

static Planet *planet[]=
 {&Sonne,&Merkur,&Venus,&Erde,&Mars,&Jupiter,&Saturn,&Uranus,&Neptun,&Pluto,
  &Mond,
  NULL
 };

static Planet nachfuehrpunkt("Nachfhrpunkt",SEP94,1.,1.,albedo[0],
			magp_sonne,1, 0.,0.,0.,0.,0.,0.);

int upper(int c)
{
 if(c>='a' && c<='z')  c -= 'a'-'A';
 return c;
}

/******************************Tabellen *********************************/
struct Ort {char *ort; double lambda,phi; int zone;};
static Ort minimaleortstabelle[]=
	{{"Zrich",  -8.5, 47.4, 1},
	 {"London",   0.0, 51.2, 0},
	 {"Hierro",  17.0, 28.0, 0},
	 {NULL, 0, 0, 0}};
static Ort *ortstabelle=NULL;

struct Stern
{
 char *name;
 double ra,dec,mag;
 int typ;
 char *spektrum;
 double entf;
 char *eigen,*bemerk;
};

class Fixstern
{
 int	ix,iy,ix2,iy2,gezeichnetflag,
	farbnr, //Farbe bei Darstellung
	morpix; //Zustzliche Pixel um Helligkeit zu erhhen
public:
 char *name;
 double ra,dec,mag,entf;
 short typ,entfm; //Sterntyp, EntfernungsMessmethode
 Sternbild *sternbild;
 char *spektrum,*eigen,*bemerk;
 Fixstern *next;
 Fixstern() {gezeichnetflag=0; name=spektrum=eigen=bemerk=NULL;
	     entf=0;entfm=0; next=NULL;
	    }
 void set(Stern *p,Sternbild *bild,int entfmethode);
 ~Fixstern() {if(name) delete name; if(spektrum) delete spektrum;
	      if(eigen) delete eigen; if(bemerk) delete bemerk;
	      if(next) delete next;
	     }
 void zeichnen();
 void loeschen();
 int getixiy(int *x,int *y)
   {if(gezeichnetflag) {*x=ix; *y=iy;} return gezeichnetflag;}
 void gethaz(double& h,double& az)
   {equhor(dec,sternzeit-ra,phi,h,az);} //Liefert Werte nach h,az  in Grad
};
void Fixstern::set(Stern *p,Sternbild *bild,int entfmethode)
{
 gezeichnetflag=0;
 name=strkopie(p->name); ra=p->ra; dec=p->dec; mag=p->mag;
 typ=p->typ; entf=p->entf; entfm=entfmethode;
 spektrum=strkopie(p->spektrum);
 eigen=strkopie(p->eigen); bemerk=strkopie(p->bemerk);
 farbnr=mag2col(mag,morpix);
 sternbild=bild;
}

struct Fixsternliste {Fixstern *star; Fixsternliste *next;};
class Sternbild
{
public:
 char	*name,  //Name des Sternbildes
	*kurve; //Information ber zu zeichnende Verbindungen
 Fixsternliste *stars;
 Sternbild *next;
 Sternbild() {stars=NULL; name=NULL; kurve=NULL; next=NULL;}
 ~Sternbild() {if(name) delete name; if(kurve) delete kurve;}
 void putstar(Fixstern *x);
};

#define MAXMINIST 2
static Stern minimalesterntabelle[MAXMINIST]=
 {{"Sirius", 6.75*WINKELSTD, -16.7, -1.5,
		'D',"A1 V/DA",8.8,"33LK;-1.5/8.5m/50.09a"},
  {"Wega", 18.61*WINKELSTD,  38.8,  0.0, 'H', "A0 V", 26, "75LK"}
 };

static Fixstern *sterntabelle=NULL;
static Sternbild *sternbilder=NULL;

Fixstern *put_fixstern(Stern *p,Sternbild *bild=NULL,int entfme=0)
{
 Fixstern *fix,*fnext,*neu;  //nach mag sortiert einfgen
 double magx=p->mag;
 neu=new Fixstern[1];
 neu->set(p,bild,entfme);
 if((fix=sterntabelle)==NULL || magx<fix->mag)
   {neu->next=fix; sterntabelle=neu;}
 else
   {for(;(fnext=fix->next)!=NULL && magx>=fnext->mag; fix=fnext)  ;
    neu->next=fnext;
    fix->next=neu;
   }
 return neu;
}

void init_minimalsterntab()
{
 int i; Stern *p;
 for(p=minimalesterntabelle,i=0;i<MAXMINIST;i++)
	put_fixstern(p++);
}

char *pars(char *s,char **name)  //String einlesen, Zeiger s erhhen
{
 char *s0=s; if(s==NULL) return NULL;
// printf("pars('%s',**name)  s=%06X\n",s,s);// test
 int c1,c;
 while((c1= *s++) && isspace(c1))  ;
 if(c1!='"' && c1!='\'') {--s; c1=' ';}
 *name=s;
 while((c= *s++) && c!='\t' && c!=c1)  ;
 if(c==0)
  {printf("pars-Error: fehlendes Stringende %c: '%s'\n",c1,s0);return NULL;}
 --s; *s++ = 0;
 return s;
}

char *klartext(int typ)
{
 static char str[40];
 switch(typ)
   {case 'H': case 0: return " ";//normaler Stern
    CASE 'D': return "Doppelstern";
    CASE 'V': return "Vernderlicher";
    CASE 'O': return "Offener Haufen";
    CASE 'K': return "Kugelhaufen";
    CASE 'N': return "Nebel";
    CASE 'G': return "Galaxie";
    CASE 'S': return "Spektrosk.Doppelstern";
    CASE 't': return "trigonometrisch gemessen";
    CASE 's': return "spektroskopisch gemessen";
    CASE 'x': case '<': return "Abschtzung: Maximalwert";
    CASE 'n': case '>': return "Abschtzung: Minimalwert";
    DEFAULT: sprintf(str,"Typ=%d",typ);
   }
 return str;
}

#define KLARMAX 400
char *klarcopy(char *s,char *t,int& i,int c=0)
{
 if(t==NULL) {if(c) *s++ = c;  return s;}
 while(c= *t++)
   {*s++ = c;
    if(++i>=KLARMAX) return s;
   }
 return s;
}
char *klarput(char *ziel,char* &s,int& i,char *text0,
	      int c1=0,int c2=0,char *text1=NULL,char *text2=NULL)
{
 int c;
 ziel=klarcopy(ziel,text0,i);
 while((c= *s++) && c!=' ')
   {if(c==c1)
      ziel=klarcopy(ziel,text1,i,c);
    else if(c==c2)
      ziel=klarcopy(ziel,text2,i,c);
    else
      *ziel++ = c; if(++i>=KLARMAX) break;
   }
 if(c==0) --s;
 return ziel;
}

char *klartext2(char *s)
{
/*
; Bemerkungen:
;	LK:   Leuchtkraft/Durchmesser (Sonne=LK1/1)
;	G:    Geschwindigkeit von Sonne weg in km/s
;	Typ:  Trmplersche Typ in O-Sternhaufen I-IV (abnemende Sternkonz.)
;	      Shapley Typ in K-Sternhaufen I-XII
;	A:    Anzahl/Helligkeitsbereich der Sterne in Haufen
;	B:    Helligkeit/Abstand/Umlaufzeit des Begleiters bei Doppelsternen
;	D:    Durchmesser oder Breite/Hhe
;	N:    Anzahl/Helligkeit der Einzelsterne in Haufen
;	V:    Min.-Max.Helligk./Periode
*/
 static char str[KLARMAX];
 char *z;
 int i,c;
 for(i=1,*str=0,z=str;i<KLARMAX && (c= *s++);)
   {switch(c)
     {case 'L':
	if(*s++=='K')
	  {z=klarput(z,s,i,"Leuchtkraft = ",'/',' '," Durchmesser=");
	   z=klarcopy(z," faches der Sonne\n",i);
	  }
      CASE 'G':
	z=klarput(z,s,i,"Fluchtgeschwindigkeit: ");
	z=klarcopy(z," km/sec",i);
      CASE 'T':
	if(*s=='y') {if(*++s=='p') s++;}
	z=klarput(z,s,i,"Typ=");
	z=klarcopy(z,"\n",i);
      CASE 'A':
	z=klarput(z,s,i,"Anzahl Sterne: ",'/',' '," mit ");
	z=klarcopy(z," Helligkeit\n",i);
      CASE 'B':
	z=klarput(z,s,i,"Begleiter: ");
	z=klarcopy(z,"\n",i);
      CASE 'D':
	z=klarput(z,s,i,"Grsse: ");
	z=klarcopy(z,"\n",i);
      CASE 'N':
	z=klarput(z,s,i,"Anzahl/Helligkeit der Einzelsterne: ");
	z=klarcopy(z,"\n",i);
      CASE 'V':
	z=klarput(z,s,i,"Helligkeitsschwankung: ",'/',' '," Periode: ");
	z=klarcopy(z,"\n",i);
      DEFAULT:
	*z++ = c; //unbekannter Bemerkungscod
	i++;
     }
   }
 *z=0;
 return str;
}
char *entfstr(double entf)
{
 static char str[40];
 if(entf>=1e7) sprintf(str,"%.1lfM",entf/1e6);
 else if(entf>1e6) sprintf(str,"%.2lfM",entf/1e6);
 else if(entf>=1e4) sprintf(str,"%.1lfk",entf/1e3);
 else if(entf>=1e3) sprintf(str,"%.0lf",entf);
 else sprintf(str,"%.1lf",entf);
 return str;
}

int isalfa(int c) {return ((c>='A' && c<='Z')||(c>='a' && c<='z'));}

char *parsb(char *s,char **name) //String einlesen, Zeiger s erhhen
{				 //darf auch einzelne Leerstellen haben.
 char *s0=s; if(s==NULL) return NULL;
// printf("parsb('%s',**name)  s=%06X\n",s,s);// test
 int c1,c;
 while((c1= *s++) && isspace(c1))  ;
 if(c1!='"' && c1!='\'') {--s; c1=' ';}
 *name=s;
 if(c1==' ')
      {while((c= *s++) && c!='\t' && (c!=c1 || isalfa(*s)))  ;}
 else {while((c= *s++) && c!='\t' && c!=c1)  ;}
 if(c==0)
   {printf("parsb-Error: fehlendes String-Endzeichen %c: '%s'\n",c1,s0);
    return NULL;
   }
 --s; *s++ = 0;
 return s;
}
char *pars(char *s,double *x)
{
 char *s0=s; if(s==NULL) return NULL;
 int c;
 if(*s=='.')
      {double z=0.1; char *t;
       for(t=s,*x=0.0;(c= *++t) && isdigit(c);z*=0.1)  *x += (c-'0')*z;
      }
 else sscanf(s,"%lf",x);
 while((c= *s++) && isspace(c))  ;
 if(c=='-' || c=='.' || isdigit(c))
   while((c= *s++) && !isspace(c))  ;
 else {printf("Fehler in pars: keine Fliesszahl:'%s'\n",s0); return NULL;}
 --s;
 return s;
}
char *pars(char *s,int *x)
{
 char *s0=s; if(s==NULL) return NULL;
 int c;
 sscanf(s,"%d",x);
 while((c= *s++) && isspace(c))  ;
 if(c=='-' || isdigit(c))
   while((c= *s++) && isdigit(c))  ;
 else {return NULL;}
 --s;
 return s;
}
char *parsv(char *s,int *x,int *minus)  //mit Vorzeichen (z.B -0)
{
 char *s0=s; if(s==NULL) return NULL;
 int c;
 while((c= *s++) && isspace(c))  ;
 if(c=='-') *minus= -1; else {*minus=0; --s;}
 sscanf(s,"%d",x);
 while((c= *s++) && isspace(c))  ;
 if(isdigit(c))
   while((c= *s++) && isdigit(c))  ;
 else {return NULL;}
 --s;
 return s;
}
char *pars(char *s,int *h,int *m,int *sec)
{
 char *s0=s; if(s==NULL) return NULL;
 int c=0,minus;
 s=parsv(s,h,&minus);
 if(s) c= *s++;
 if(c==':' || c=='d' || c=='h')
   {s=pars(s,m); c= *s++;
    if(c==':' || c=='m') s=pars(s,sec);
    else if(c=='.') {double x=0; s=pars(--s,&x); *sec=int(60*x+0.5);}
    else if(c==' ' || c=='\t') *sec=0;
    else s=NULL;
   }
 else if(c=='.')
   {double x=0;
    s=pars(s0,&x);
    if(x<0) {x= -x; minus= -1;} else minus=0;
    *h=int(x);
    x=(x-int(x))*60;
    *m=int(x); x=(x-(*m))*60;
    *sec=int(x+0.5);
   }
 else s=NULL;
 if(minus) {*h= -(*h); *m= -(*m); *sec= -(*sec);}
 if(s==NULL) printf("Fehler in pars: Falsches hms/fliess-Format:'%s'\n",s0);
 return s;
}
char *parsa(char *s,int *c)
{
 if(s==NULL) return NULL;
 while(*s==' ' || *s=='\t') s++;
 if((*c= *s)!=0) s++;
 return s;
}
char *parse(char *s,double *x,int *entfm)
{
 if(s==NULL) return NULL;
 *entfm=0;
 int c;
 while((c= *s++) && isspace(c))  ;
 if(!isdigit(c))
   {if(c=='>' || c=='<') *entfm=c;//Maximal oder Minimaldistanz
   }
 else --s;
 sscanf(s,"%lf",x);
 while((c= *s++) && isdigit(c))  ;
 if(c=='.') {while((c= *s++) && isdigit(c))  ;}
 switch(c)
   {case 'k': *x *= 1e3;
    CASE 'M': *x *= 1e6;
    CASE 't': case 's': case 'x': case 'n':
	*entfm=c;//trigonometrisch, spektroskopisch
   }
 return s;
}
char *pars(char *s,char *text)
{
 int c1,c;
 char *t=text;
 if(s==NULL || *s==0) {*t=0; return NULL;}
 while((c1= *s++) && isspace(c1))  ;
 if(c1!='"' && c1!='\'') {--s; c1=' ';}
 while((c= *s++) && c!=c1)  *t++ = c;
 *t=0;
 if(c!=c1) {printf("pars-Error: '%s'\n",text); s=NULL;}
 return s;
}

const int N40=80, //kleine Textteile in Sterntabelle
          N80=80, //etwas groessere Textteile in Sterntabelle
          N200=400; //Maximale Laenge fuer Dateinamen (samt Pfad)

void init_sterntabelle()
{
 int i,n,c,typ,entfm;
 double entf;
 char *zeile=scratch,*str,*name;
 char spektrum[N40],eigen[N40],bemerk[N80];
 Stern neu;
 Fixstern *p;
 Sternbild *aktbild=NULL;
 FILE *fp=fopen1(sterntabname,"r");
 if(fp==NULL) {init_minimalsterntab(); return;}
 int std,min,sec,d,m,s;
 double ra,dec,mag;
 for(i=0;getline(fp,zeile,200);)
  if(*zeile!=0)
   {if(*zeile==';')
     {if(strncmp(zeile,";--",3)==0) aktbild=NULL;
      else if(strncmp(zeile,";*",2)==0) aktbild=put_sternbild(&zeile[2]);
      else if(isdigit(zeile[1]) && aktbild!=NULL)
		aktbild->kurve=strkopie(&zeile[1]);
      //else Kommentarzeile ueberlesen
     }
    else
/*Beispiel:
; Name		Rektas.	Deklin.	Magn. Typ Spektrum Entf. Eigenschaften  Bemerkungen
Alpheratz	00:08.4	29:05	2.06  H   "A0 p"   >72   "LK300/5"
*/
     {str=parsb(zeile,&name);
      str=pars(str,&std,&min,&sec);
      str=pars(str,&d,&m,&s);
      str=pars(str,&mag);
      if(str==NULL) break; //bei Fehler: Abbrechen
//      if(i<5) // test
//        printf("'%s' %d:%02d:%02d  %dd%02dm%02ds  %lf\n",
//		 name, std,min,sec, d,m,s, mag);// test
      ra=(std+min/60.+sec/3600.)*WINKELSTD;
      dec=d+m/60.+s/3600.;
      neu.name=name; neu.ra=ra; neu.dec=dec; neu.mag=mag;
      if(str!=NULL && *str!=0)
	{str=parsa(str,&typ);
	 str=pars(str,spektrum);
	 str=parse(str,&entf,&entfm);
	 if(str==NULL) break; //bei Fehler: Abbrechen
	 str=pars(str,eigen);
	 str=pars(str,bemerk);
//	 printf("%s typ=%c spekt='%s' entf=%.1lf eigen='%s' bemerk='%s'\n",
//		name,typ,spektrum,entf,eigen,bemerk);// test
	 neu.typ=typ; neu.spektrum=spektrum; neu.entf=entf;
	 neu.eigen=(*eigen==0)?NULL:eigen;
	 neu.bemerk=(*bemerk==0)?NULL:bemerk;
        }
      else
	{neu.typ='H'; neu.spektrum=neu.eigen=neu.bemerk=NULL; neu.entf=0.0;
	 entfm=0;
        }
#ifdef DEBUG
      if(str!=NULL && *str!=0)
	printf("Stern=%s Rest='%s'\n",name,str);//test
#endif
      p=put_fixstern(&neu,aktbild,entfm);
      if(p==NULL)
	{printf(
	 "zu wenig RAM fuer ganze Sterntabelle - nur %d Sterne benutzt\n",i);
	 break;
        }
      if(aktbild) aktbild->putstar(p);
//      if(i<5) // test
//	  printf("'%s'\t%.3lf\t%.3lf\t%.2lf\n",
//		 p->name,p->ra,p->dec,p->mag);// test
      i++;
     }
   }
 anzahlsterne=maxanzahlsterne=i;
 anzfixanschr=(i<10)?i:10;
 printf("%d Sterne eingelesen\n",i);
 fclose(fp);
}

void Sternbild::putstar(Fixstern *x)
{
 Fixsternliste *neu=new Fixsternliste[1];
 neu->star=x;
 if(stars==NULL)
   {neu->next=NULL; stars=neu;}
 else
   {Fixsternliste *p;
    for(p=stars;p->next!=NULL;p=p->next) ;
    neu->next=p->next; p->next=neu;
   }
}

Sternbild *put_sternbild(char *name)
{
 Sternbild *neu=new Sternbild[1];
 if(*name=='"')
   {char *s= ++name; while(*s && *s!='"') s++;
    *s=0;
   }
 neu->name=strkopie(name);
 neu->next=sternbilder;
 sternbilder=neu;
 return neu;
}

/**
void test_printsternbilder()
{
 Sternbild *p;
 Fixsternliste *p2;
 int i;
 for(i=0,p=sternbilder;p!=NULL;p=p->next,i++)
  if(i<=5 || p->next==NULL)
   {printf("'%s':\n",p->name);
    for(p2=p->stars;p2!=NULL;p2=p2->next)
      printf("  %s\n",p2->star->name);
   }
}
**/

void minimalortstab()
{
 ortstabelle=minimaleortstabelle;
 g_lambda=ortstabelle[0].lambda; g_phi=ortstabelle[0].phi;
 sucheortsname(ortsname);
}
void init_ortstabelle()
{
 int i,n,k;
 char *zeile=scratch, *str, *name;
 FILE *fp=fopen1(ortstabname,"r");
 if(fp==NULL) {minimalortstab(); return;}
 for(n=0;getline(fp,zeile,200);)
   {if(*zeile==';' || *zeile=='!' || *zeile==0) continue;
    n++;
   }
 fclose(fp);
 if(n<=1) {printf("Fehler in '%s' n=%d\n",ortstabname,n); fp=NULL;}
 else fp=fopen1(ortstabname,"r");
 if(fp==NULL) {minimalortstab(); return;}
 Ort *p=ortstabelle=new Ort[n+1];
 double la,ph;
 for(i=0;i<n;)
   {if(getline(fp,zeile,200)==0) break;//Fehler
    if(*zeile==';' || *zeile=='!' || *zeile==0) continue;
    str=parsb(zeile,&name);
    str=pars(str,&la);
    if(str==NULL) break; //bei Fehler: Abbrechen
    str=pars(str,&ph);
    if(str==NULL) break; //bei Fehler: Abbrechen
    p->ort=strkopie(name); p->lambda=la; p->phi=ph;
#ifdef DEBUG
    //if(argflag['D']) printf("'%s' %lf %lf\n",p->ort,la,ph);
#endif
    i++; p++;
   }
 if(i!=n) {printf("Fehler in '%s': '%s'\n",ortstabname,zeile);
	   printf("Format ist: Name 0.0 0.0  ;beide Zahlen in Grad\n");
	  }
 p->ort=NULL; p->lambda=p->phi=0.;
 fclose(fp);
 g_lambda=ortstabelle[0].lambda; g_phi=ortstabelle[0].phi;
 sucheortsname(ortsname);
}

int sucheortskoord(char *ort)
{
 Ort *p;
 char *s;
 for(p=ortstabelle;(s=p->ort)!=NULL;p++)
   if(strcmp(s,ort)==0)
     {g_lambda=p->lambda; g_phi=p->phi; return 1;} //Ort gefunden
 return 0;//Ort nicht gefunden
}
int sucheortsname(char *name)
{
 Ort *p;
 char *s;
 for(p=ortstabelle;(s=p->ort)!=NULL;p++)
   if(g_lambda==p->lambda && g_phi==p->phi)
     {sprintf(name,"%s",p->ort); return 1;} //Ort gefunden
 *name=0;
 return 0;//nicht gefunden
}

class Siluet
{
 double *az,*ho;
 int n,imax;
 void alloc(int i);
 void del() {if(n>0) {delete az; delete ho; imax=n=0; isactiv=false;}}
public:
 bool isactiv;
 Siluet() {isactiv=false; imax=n=0; az=ho=NULL;}
 ~Siluet() {del();}
 bool init(char *name);
 double getaz(int i) {return (i>=imax)?361.0:az[i];}
 double getho(int i) {return (i>=imax)?90.0:ho[i];}
};
static Siluet siluet;
static char siluet_name[N200]="";

/********************** weitere Vordeklarationen ************************/
void zeichne_planet(Planet *plan,double abst,double ra,double dec,int num);
void m_provi(char *s=" ")
{
 char str[200];
 sprintf(str,"%s\nnoch nicht fertig programmiert",s);
 janeinrequester(str);
}
void berechneradec(double ho,double az,double& ra,double& dec);
void nachfuehrpunkt_aktualisieren();
void neue_darstellung(int neu);
bool siluet_init(char *name);

/******************************** Menus *********************************/
static int exitflag=0, prvorschub=1;
void m_exit() {exitflag=1;}
void m_save()
{
 int ok,invers,c;
 char name[N200], inv[80]="nein", typ[80]=" ";
 sprintf(name,"%s/test.iff",USERDATA);
 ok=nachfilenamefragen("Datei speichern",name,N200);
 if(ok)
 {if(hatendung(name,".iff",".IFF")) strcpy(typ,"Bild");
  else if(hatendung(name,".vor",".VOR")) strcpy(typ,"Vor");
  else strcpy(typ,"Anim");
  ok=requester_input(3,
	"Ausgabedatei (Endung .iff .vor oder .dat)","%s","%s\n",&name,
	"Invertieren ?","%s","%s",&inv,
	"Dateityp (Bild, Vor, Anim)","%s","%s",&typ);
  if(ok)
  {invers=(tolower(*inv)!='n');
   c=tolower(*typ);
   if(hatendung(name,".iff",".IFF") || c=='b')
    {if(invers) weiss_schwarz_tausch();
     iffbild_speichern(name);
     if(invers) weiss_schwarz_tausch();
    }
   else if(hatendung(name,".vor") || c=='v')
     voreinstellungen_save(name);
   else if(hatendung(name,".dat") || c=='a')
     animation_save(name);
   else
    janeinrequester("kann bisher nur IFF-Bilder (Endung .iff)\n Voreinstellungen (Endung .vor) oder Animationsdaten (.dat) speichern");//provi.
  }
 }
}
void m_load()
{
 int ok,c;
 char name[N200], typ[80]=" ";
 sprintf(name,"%s/",USERDATA);
 ok=nachfilenamefragen("Einstellungen/AnimDatei laden",name,N200);
 if(ok)
  {c=tolower(*typ);
   if(hatendung(name,".vor") || c=='v')
     voreinstellungen_load(name);
   else if(hatendung(name,".dat") || c=='a')
     animation_load(name);
   else
    janeinrequester("kann bisher nur Voreinstellungen (Endung .vor)\n oder Animationsdaten (.dat) laden");//provi.
  }
}

void m_ueber()
{
 sprintf(scratch2,
	 "Planetium %s - Freeware Planetarium\nCopyright: %s",
	 VERSION,COPYRIGHT);
 if(janeinrequester(scratch2,"ok","mehr")==0)
   {sprintf(scratch2,"Kontaktadresse:\n%s",ADRESSE);
    janeinrequester(scratch2);
   }
}

void m_help()
{
 int ok;
 sprintf(scratch2,"_schnelle Hilfe_\n\n\
 Funktionen der Maustasten:\n\
  linke Taste: kurz geklickt: Informationen ber nchstgelegenes Objekt\n\
               gedrckt halten: Zoomen\n\
  mittlere Ta: kurz geklickt: Foto des nchstgelegenen Objekts\n\
               gedrckt halten: Foto des Himmelsausschnitts\n\
  rechte Tast: Men\n\n\
fr ausfhrlichere Hilfe: '%s'",README);
 ok=janeinrequester(scratch2,"ok","mehr");
 if(!ok)
   {sprintf(scratch1,"%s %s",show_html,README2);
    runsystem(scratch1);
   }
}

void m_pre()
{
 int ok;
#ifdef unix
 ok=requester_input(2,"Ausgabegert (* oder Dateiname)","%s","%s",
		    &printer, "Seitenvorschub","%d","%d",&prvorschub);
#else
 ok=requester_input(2,"Ausgabegert (prt: oder Dateiname)","%s","%s",
		    &printer, "Seitenvorschub","%d","%d",&prvorschub);
#endif
 if(ok)
   {if(fpprint && fpprint!=stdout) {fclose(fpprint); fpprint=NULL;}
   fpprint=NULL;//test
   }
}

/*
void plotsave1(char *s)
{
 if(*s!='O')
   Delay(100);//provi. 2 Sec Zeit um ALT SHIFT S zu drcken
 else
   janeinrequester(
	"plotsave() geht noch nicht: ALT SHIFT S benutzen");//provi.
}
*/

void m_prbild()
{
 weiss_schwarz_tausch();
#ifdef unix
 plotsave("POST"); zeichne_planetarium(); plotsave("OFF");
#else
 zeichne_planetarium();
 iffbild_speichern("ram:tmp_planetium.iff");
#endif
 weiss_schwarz_tausch();
 zeichne_planetarium();
#ifdef unix
 janeinrequester("Ausdrucken geht noch nicht richtig\nprovisorisches Bild unter $PLOTSAVE gespeichert.");//provi.
#else
 janeinrequester("Ausdrucken geht noch nicht automatisch\nBild unter ram:tmp_planetium.iff gespeichert.");//provi.
#endif
}
void m_prephem()
{
 printephem_flag=1;
 ausdrucken(
   "Objekt           RA       Dekl.    Abstand       Durchm.  mag  ");
 zeichne_planetarium();
 ausdrucken(NULL);
 printephem_flag=0;
}
void m_praltaz()
{
 printephem_flag=2;
 ausdrucken(
   "Objekt        Azimut      Hhe     Abstand       Durchm.  mag  ");
 zeichne_planetarium();
 ausdrucken(NULL);
 printephem_flag=0;
}
void c_check(char *text)
{
 if(!c_expand(CPFAD,text))
    janeinrequester2(NICHT_IN_C,text,CPFAD);
}
void m_anzeig()
{
 int ok;
 char stxt[COMAX],sbild[COMAX],shtml[COMAX],*s;
 strcpy(stxt,show_text); ohnepfad(stxt);
 strcpy(sbild,show_pict); ohnepfad(sbild);
 strcpy(shtml,show_html); ohnepfad(shtml);
 ok=requester_input(3," Textanzeiger ","%s","%s\n",stxt,
		      " Bildanzeiger ","%s","%s\n",sbild,
		      " HTMLanzeiger ","%s","%s",shtml);
 if(ok)
   {strcpy(show_text,stxt);
    strcpy(show_pict,sbild);
    strcpy(show_html,shtml);
    c_check(show_text);
    c_check(show_pict);
    c_check(show_html);
   }
}

class Simplezeit
{
 char str[40];
public:
 int x,xn;
 Simplezeit(int n) {x=n; xn=x*TICKS_PER_SECOND;}
 char *stri();
 void scan(char*);
};

static Simplezeit zeittakt(1);

char *Simplezeit::stri()
{
 int std,min,sec,y;
 sec=x%60; y=x/60;
 min=y%60; 
 std=y/60;
 sprintf(str,"%d:%02d:%02d",std,min,sec);
 return str;
}
void Simplezeit::scan(char *s)
{
 int std,min,sec;
 sscanf(s,"%d%*c%d%*c%d",&std,&min,&sec);
 x=sec+60*(min+60*std);
 xn=x*TICKS_PER_SECOND;
}

void m_zeit()
{
 int ok,zone=zeitzone,std,tag,c;
 char sdat[40],szei[40],tzeit[40];
 tag=zeit.tag; std=zeit.std;
// if((std+=zone)>=24) {std -= 24; tag++;}
// else if(std<0) {std += 24; tag--;}
 sprintf(sdat,"%d.%d.%d",tag,zeit.mon,zeit.jahr);
 sprintf(szei,"%d:%02d:%02d",std,zeit.min,zeit.sec);
 sprintf(tzeit,"%s",zeittakt.stri());
 ok=requester_input(4,"Datum","%s","%s",sdat, "Weltzeit","%s","%s\n",szei,
		    "Zeitzone (Ortszeit-Weltzeit)","%d","%d\n",&zone,
		    "Zeittakt","%s","%s",tzeit);
 if(ok)
  {int std,min,sec; long day,month,year;
   zeitzone=zone; echtzeitflag=0;
   sscanf(sdat,"%d%*c%d%*c%d",&zeit.tag,&zeit.mon,&zeit.jahr);
   sscanf(szei,"%d%*c%d%*c%d",&zeit.std,&zeit.min,&zeit.sec);
   //if(zeit.jahr<0) zeit.jahr++;//provisorische Korrektur
   modjd=zeit.mjd();
   zeittakt.scan(tzeit);
   zeichne_planetarium();
  }
}
void m_syszeit()
{
 echtzeit_aktualisierung();
 zeichne_planetarium();
}
void m_echtzeit()
{
 echtzeitflag=2; zeit=getweltzeit();
 modjd=zeit.mjd();
 zeichne_planetarium();
}
void m_zeithalt()
{
 echtzeitflag=0;
 zeichne_planetarium();
}
void m_zeitstart()
{
 if(echtzeitflag) {echtzeitflag=2; /*modjd=zeit.mjd();*/}
 else echtzeitflag=1;
 zeichne_planetarium();
}

void m_ort()
{
 int ok;
 sucheortsname(ortsname);
 do
  {ok=requester_input(3,"Geographische Lnge","%.2lf","%lf\n",&g_lambda,
		      "Geographische Breite","%.2lf","%lf\n",&g_phi,
		      "Ortsname","%s","%s",ortsname);
   if(!ok) return;
   if(ortsname[0]>' ' && ortsname[0]!='?')
      {if(sucheortskoord(ortsname)==0)
	 {sprintf(ortsname,"??"); ok=0;}
      }
  }
 while(ok==0);
 zeichne_planetarium();
}

void darst_akt(int c=0)
{
 if(c!=0) anschreibflag=(c=='J' || c=='Y');
 if(anschreibflag) hyw=textsize(bx,hy);
 if(anzahlsterne>maxanzahlsterne) anzahlsterne=maxanzahlsterne;
 else if(anzahlsterne<0) anzahlsterne=0;
 if(darart==HORIZONTAL)
  {beo_sinaz=sin(beo_azimut*GRAD); beo_cosaz=cos(beo_azimut*GRAD);
   beo_sin90h=sin((90-beo_h)*GRAD); beo_cos90h=cos((90-beo_h)*GRAD);
  }
 else //if(darart==EQUATORIAL)
  {beo_sinra=sin(beo_ra*GRAD); beo_cosra=cos(beo_ra*GRAD);
   beo_sin90dec=sin((90-beo_dec)*GRAD); beo_cos90dec=cos((90-beo_dec)*GRAD);
  }
 beobachtradia=beobachtradius*GRAD;
 zeichne_planetarium();
}

void m_darst(long id)
{
 char antw[40],*s_ho,*s_az;
 int ok;
 double *az,*ho;
 if(anschreibflag) strcpy(antw,"ja"); else strcpy(antw,"nein");
 dar_hist.push();
 if(darart==HORIZONTAL)
   {s_az="Azimut"; s_ho="Hhe";
    az= &beo_azimut; ho= &beo_h;
   }
 else
   {//s_az=(nachfuehrung==0)?"  Tau  ":"Rektasz.";
    s_az="  Tau  "; s_ho="Declination";
    az= &beo_ra; ho= &beo_dec;
   }
 ok=requester_input(8,
	"Beobachtungsradius","%lf Grad","%lf",&beobachtradius,
	s_az,"%lf","%lf",az,
	s_ho,"%lf","%lf\n",ho,
	"Uebertreibfaktor","%8.2lf","%lf\n",&uebertreib,
	"Planeten anschreiben","%s","%s",antw,
	"Schriftgroesse","%10.3lf","%lf\n",&hy,
	" Fixsterne ","%10d","%d",&anzahlsterne,
	"anschreiben","%10d","%d\n",&anzfixanschr
	);
 if(ok)
   {darst_akt(toupper(*antw)); menu_switch(id,dar_ids,darmenu=5,6,dar_txt);
   }
 else
   {dar_hist.pop(); menu_switch(id,dar_ids,darmenu,6,dar_txt);}
}

void dar_beox(long id,int dm,double n1,double n2,double n3)
{
 dar_hist.push();
 darmenu=dm; beobachtradius=n1;
 if(darart==HORIZONTAL)
   {beo_azimut=n2; beo_h=n3;}
 else
   {beo_ra=n2; beo_dec=n3;}
 menu_switch(id,dar_ids,darmenu,6,dar_txt);
 darst_akt();
}

void m_darganz(long id)	{dar_beox(id,0,90,0,90);}
void m_darsued(long id)	{dar_beox(id,1,45,0,45);}
void m_darwest(long id)	{dar_beox(id,2,45,90,45);}
void m_darnord(long id)	{dar_beox(id,3,45,180,45);}
void m_darost(long id)	{dar_beox(id,4,45,270,45);}
void m_darbak(long id)
{
 dar_hist.pop();
 menu_switch(id,dar_ids,darmenu,6,dar_txt);
 darst_akt();
}

void m_somogr()
{
 int ok=requester_input(1,"Uebertreibfaktor fuer Sonne und Mond",
			"%8.2lf","%lf\n",&uebertreib);
 darst_akt();
}

void m_anim()
{
 static int stepmod=0;
 char sstart[32],send[32],sstep[32];
 double dt=double(anim_dt)/TICKS_PER_SECOND;
 int ok;
 mjd2str(a_start,sstart);
 mjd2str(a_end,send);
 dmjd2str(a_step,sstep);
 ok=requester_input(6,
   "     Startzeit     ","%s","%s",sstart,
   "      Endzeit      ","%s","%s",send,
   "       Step        ","%s","%s\n",sstep,
   "Stepmodus (0=Step  1=Sterntag  2=Automatisch)","%10d","%d\n",&stepmod,
   "Verzgerung (in sec)","%10.2lf","%lf\n",&dt,
   "Darstellungsart (0=Spur 1=TeilRefresh 2=AllesRefresh)",
		    "%10d","%d",&refresh
   );
 if(ok)
   {a_start=str2mjd(sstart); a_end=str2mjd(send);
    switch(stepmod)
      {case 1:a_step=0.99726957; //1Sterntag
       CASE 2:a_step=(a_end-a_start)/100;
       DEFAULT: a_step=str2dmjd(sstep);
      }
    anim_dt=idfix(dt*TICKS_PER_SECOND);
    if(anim_dt<1) anim_dt=1;
   }
}
void m_animstart() //Animation Startzeit setzen
{
 a_start=modjd;
}
void m_animstop() //Animation Endzeit setzen
{
 a_end=modjd;
}

void m_anista() //Animation Starten/Neustarten
{
 animflag=1;
}
static int g_altnachf= -1;
void m_anista2() //Animation Starten/Neustarten mit Nachfhrung
{
 if(nachfuehrung==NACHF_OFF)
   {g_altnachf=nachfuehrung;
    nachfuehrung=NACHF_STERN_START;
    if(koorflag==DARAUTO) neue_darstellung(EQUATORIAL);
    darst_akt();
   }
 animflag=1;
}
void m_anisto() //Animation Stoppen
{
 if(animflag==2) animflag= -1;
 else {animflag=0; zeichne_planetarium();
       if(g_altnachf==NACHF_OFF)
	 {nachfuehrung=g_altnachf; g_altnachf= -1;
	  if(koorflag==DARAUTO) neue_darstellung(HORIZONTAL);
	  darst_akt();
	 }
      }
}
void anim_stoppen()
{
 term_refresh();
 if(g_altnachf>=0)
   {nachfuehrung=g_altnachf;
    if(koorflag==DARAUTO) neue_darstellung(HORIZONTAL);
    darst_akt();
   }
 animflag=0;
}

void m_palet();
//void m_objfarb() {m_provi("m_objfarb()");}
//void m_anord() {m_provi("m_anord()");}
void m_refresh();

void m_debug1();

void m_mausmi(long id)
{
 menu_switch(id,maus_ids,mausemu=0,2,maus_txt);
 limaus=LIMAUS;
}
void m_mausli(long id)
{
 menu_switch(id,maus_ids,mausemu=1,2,maus_txt);
 limaus=MIMAUS;
}

void m_nachoff(long id)
{
 nachfuehrung=NACHF_OFF;
 menu_switch(id,nachf_ids,0,3,nachf_txt);
 if(koorflag==DARAUTO) neue_darstellung(HORIZONTAL);
 darst_akt();
}
void m_nachnorm(long id)
{
 nachfuehrung=NACHF_STERN_START;
 menu_switch(id,nachf_ids,1,3,nachf_txt);
 if(koorflag==DARAUTO) neue_darstellung(EQUATORIAL);
 darst_akt();
}
void m_nachobj(long id)
{
 int ok=requester_input(1,"Nachfhrobjekt","%s","%s",nachfuehrobjekt);
 if(ok)
   {Planet **pp=planet, *p;
    while((p= *pp++)!=NULL)
      if(strcmp(p->name,nachfuehrobjekt)==0)
	{nachfuehrplanet=p; break;}
    if(p!=NULL) {nachfuehrung=NACHF_OBJ;}
    else janeinrequester(
      "Objekt-Nachfhrung geht bisher nur mit Planeten (und Sonne, Mond)");
   }
 menu_switch(id,nachf_ids,nachfuehrung&NACHF_MASK,3,nachf_txt);
 if(koorflag==DARAUTO) neue_darstellung(EQUATORIAL);
 darst_akt();
}

void m_mondmini(long id)
{
 menu_switch(id,mond_ids,moonflag=0,2,mond_txt);
}
void m_mondexact(long id)
{
 menu_switch(id,mond_ids,moonflag=1,2,mond_txt);
}

void m_koorhoriz(long id)
{
 menu_switch(id,koor_ids,koorflag=0,3,koor_txt);
 neue_darstellung(HORIZONTAL);
 darst_akt();
}
void m_koorequat(long id)
{
 menu_switch(id,koor_ids,koorflag=1,3,koor_txt);
 neue_darstellung(EQUATORIAL);
 darst_akt();
}
void m_koorauto(long id)
{
 menu_switch(id,koor_ids,koorflag=2,3,koor_txt);
}

inline void horequra(double h,double az,double phi,double& dec,double& ra)
{
 double tau;
 horequ(h,az,phi,dec,tau); //Liefert Werte nach dec,tau
 if((ra=sternzeit-tau)<0.0) ra+=360.0;
}

void neue_darstellung(int neu)
{
 if(neu==darart) return;
 if(darart==HORIZONTAL && neu==EQUATORIAL)
   horequ(beo_h,beo_azimut,g_phi,beo_dec,beo_tau);//Liefert dec,tau in Grad
 else if(darart==EQUATORIAL && neu==HORIZONTAL)
   equhor(beo_dec,beo_tau,g_phi,beo_h,beo_azimut);//Liefert ho,az
 darart=neu;
}

void m_refresh()
{
 darst_akt();
}

void m_grid_ekl(long id)
 {grids^=GRID_EKL; menu_flag(id,linien_ids,0,5,linien_txt,grids&GRID_EKL);}
void m_grid_eq(long id)
 {grids^=GRID_EQ;  menu_flag(id,linien_ids,1,5,linien_txt,grids&GRID_EQ);}
void m_grid_hor(long id)
 {grids^=GRID_HOR; menu_flag(id,linien_ids,2,5,linien_txt,grids&GRID_HOR);
  darst_akt();
 }
void m_grid_ra(long id)
 {grids^=GRID_RA;  menu_flag(id,linien_ids,3,5,linien_txt,grids&GRID_RA);}
void m_grid_dec(long id)
 {grids^=GRID_DEC; menu_flag(id,linien_ids,4,5,linien_txt,grids&GRID_DEC);}
//void m_grid_off() {grids=GRID_OFF;}
void m_siluet(long id)
		{siluet_init(NULL);
		 echterhorizont_txt[1]=(siluet.isactiv)?'Q':'q';//provi.
		 changemenu(id,echterhorizont_txt);
		 darst_akt();
	        }
void m_erdsch(long id)
		{mofiflag=1-mofiflag;
		 erdschatten_txt[1]=(mofiflag)?'Q':'q';
		 changemenu(id,erdschatten_txt);
		 darst_akt();
	        }//provi.

void m_fenstgr()
{
 char str[200];//provi.
 int br,ho,ti,vk,ok;
 double asp,rasp;
 getsize(&br,&ho,&ti,&vk);
 asp=getaspect();
 rasp=getraspect();
 sprintf(str,"Fenstergroesse: %d %d (noch) nicht aenderbar\n\
Tiefe=%d visualklasse=%d\n\
aspect=%lf rasp=%lf\n\
TekPlot-Version: %lf\n",
	br,ho,ti,vk,asp,rasp,get_tekplot_version());
 janeinrequester(str);
 getmaxsize(&br,&ho,&ti,&vk);
 ok=requester_input(2,"Breite","%d","%d",&br, " Hoehe","%d","%d",&ho);
 fenster.neuegroesse(br,ho,TIEFE);
}

/*************************** Hauptprogramm ******************************/
#define SM setmenu
#define SSM setsubmenu
#define W22 "%~~~~~~~~~~~~~~~~~~~~~~"

#define MAXARG 0
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

main(int argc,char *argv[])
{
 int i,j=0,c;
#ifdef unix
 save_stdout();
#endif
 if(argc<=0)
  {/* es wurde von WorkBench gestartet */
#ifdef unix
   pfadexpand_init();
#endif
   stdout=fopen(TMP_STDOUT,"w");
   wbflag=1;
  }
 else if(argc==1 && *argv[0]=='/')
   {// Grafischer Start: z.B. von KDE (Linux) gestartet
    pwd.set(argv[0]);
    pfadexpand_init();
   }
 else
  {/* es wurde von der Shell gestartet */
#ifdef unix
   stdout=old_stdout;
   pfadexpand_init();
#endif
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else ++j;
	}
   if(argflag['?'] || j>MAXARG)
	{printf("planetium  %s\n",VERSION);
	 printf("Anwendung: planetium [-Flags]\n");
	 printf("  Flags: t = Testmodus: ermittelt Rechenzeit\n");
#ifdef DEBUG
	 printf("         d = Debugger (Testpunkte ausdrucken)\n");
#endif
	 exit(0);
	}
   sprintf(printer,"*");//Ausgabe in Shell als Druckervoreinstellung
  }
 int col=0,maxcol, breite,hoehe,tiefe,visklasse;
#ifdef DEBUG
//if(argflag['D']) tek_setdebug(1);//tekplot-debug
#endif
 int std,min,sec;
 long day, month, year;
 voreinstellungen_load(VOREINSTDATEI);
#ifdef GMTIME_FALSCH
#ifdef DEBUG
 if(argflag['D'])
  {printf("Lokalzeit: %d.%d.%d %d:%02d:%02d\n",
	zeit.tag,zeit.mon,zeit.jahr, zeit.std,zeit.min,zeit.sec);
  }
#endif
 zeitzone=get_zeitzone();
 zeit.addstd(-zeitzone);
#ifdef DEBUG
 if(argflag['D'])
  printf("Weltzeit: %d.%d.%d %d:%02d:%02d\n",
	zeit.tag,zeit.mon,zeit.jahr, zeit.std,zeit.min,zeit.sec);
#endif /*DEBUG*/
#endif /*GMTIME_FALSCH*/
 a_start=a_end=mjd(zeit); //Startzeit Voreinstellung = momentane Zeit
 a_end+=1.0;		  //Endzeit = 1 Tag spter
 a_step=10.0/24./60.;	  //Schrittweite = 10 Minuten
 if(!wbflag)
  {printf("\n Planetium %s\n",VERSION);
   printf(  " ---------------------\n");
#ifdef DEBUG
   printf(" DEBUG on (needs new compilation to turn off)\n");
#endif
  }
 init_ortstabelle();
 init_sterntabelle();
// test_printsternbilder();
 kometen_einlesen();
//Geographische Koordinaten:
#ifdef DEBUG
 if(argflag['D']) printf("Beobachtungsort='%s'\n",ortsname);
#endif
 modjd=zeit.mjd();
#ifdef DEBUG
 printf("%s %s ET   JD:%12.6lf   (%s %s)\n",
	//wochentag[long(modjd+3)%7],zeit.stri(scratch),modjd+2400000.5,
	zeit.wochentag,zeit.stri(scratch),modjd+2400000.5,
	"geocentric",(mode=='A')?"apparent":"astrometric");
#endif
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
#ifdef OBERER_FENSTERRAND
 hoehe -= OBERER_FENSTERRAND;
 hoehe -= get_menuleistenhoehe();
#endif
 if(tiefe>TIEFE) tiefe=TIEFE; else TIEFE=tiefe;
 maxcol=(1<<TIEFE);
 fenster.neuegroesse(breite,hoehe,tiefe);
 SM(5,"File",	 "Steuerung",	     "Darstellung", "Animation","Help");
 SM(5,"Load ...","Ortskoordinaten ...","Kuppel ->", "Start=aktuelle Zeit","Help ...",
    m_load,	  m_ort,		N,		m_animstart, m_help);
 SSM(3,N,N,	dar_txt[0], N,N,m_darganz);
 SSM(3,N,N,	dar_txt[1], N,N,m_darsued);
 SSM(3,N,N,	dar_txt[2], N,N,m_darwest);
 SSM(3,N,N,	dar_txt[3], N,N,m_darnord);
 SSM(3,N,N,	dar_txt[4], N,N,m_darost);
 SSM(3,N,N,	dar_txt[5], N,N,m_darst);
 SSM(3,N,N,	"%~~~~~~~~~~~~~~", N,N,N);
#ifdef UTF8
 SSM(3,N,N,	"zurück",   N,N,m_darbak);
#else
 SSM(3,N,N,	"zurck",   N,N,m_darbak);
#endif
 SM(4,"Save ...","Zeit setzen ...", "Farbpalette", "Stop=aktuelle Zeit",
	m_save,	  m_zeit,		m_palet,	m_animstop);
 SM(4,W22,"Systemzeit bernehmen","Anzeigeprogis ...","Einstellungen setzen ...",
	N, m_syszeit,		   m_anzeig,		m_anim);
 SM(4,"Print Bild","Zeit starten","Mond ->",	   "%~~~~~~~~~~~~~~~~~~~~",
	m_prbild,   m_zeitstart, N, N);
 SSM(3,N,N,mond_txt[0],N,N,m_mondmini);
 SSM(3,N,N,mond_txt[1],N,N,m_mondexact);
 SM(4,"Print-Optionen ...","Echtzeit starten","Koordinatensystem ->","Start"
,	m_pre,			m_echtzeit,	N,		  m_anista);
 SSM(3,N,N,koor_txt[0],N,N,m_koorhoriz);
 SSM(3,N,N,koor_txt[1],N,N,m_koorequat);
 SSM(3,N,N,koor_txt[2],N,N,m_koorauto);
 SM(4,"Print Ephemeriden","Zeit anhalten","Refresh","Start mit Nachfhrung",
	m_prephem,	   m_zeithalt,	  m_refresh, m_anista2);
 SM(4,"Print AltAzimut","%~~~~~~~~~~~~~~~", "Linien ->", "Stop",
	 m_praltaz,	N,		    N,		 m_anisto);
 SSM(3,N,N,linien_txt[0],N,N,m_grid_ekl);//Ekliptik
 SSM(3,N,N,linien_txt[1], N,N,m_grid_eq);//quator
 SSM(3,N,N,linien_txt[2],N,N,m_grid_hor);//Horizont
 SSM(3,N,N,linien_txt[3], N,N,m_grid_ra);
 SSM(3,N,N,linien_txt[4],N,N,m_grid_dec);
 SSM(3,N,N,"%~~~~~~~~~~~~~~~",N,N,N);
 SSM(3,N,N,echterhorizont_txt,N,N,m_siluet);
 SSM(3,N,N,erdschatten_txt,N,N,m_erdsch);
#ifdef UTF8
 SM(3,"%~~~~~~~~~~~~~~~", "BildanzeigeKnopf ->", "Fenstergrösse ...",
	N,			N,		  m_fenstgr);
#else
 SM(3,"%~~~~~~~~~~~~~~~", "BildanzeigeKnopf ->", "Fenstergrsse ...",
	N,			N,		  m_fenstgr);
#endif
 setsubmenu(2,NULL,maus_txt[0],NULL,m_mausmi);
 setsubmenu(2,NULL,maus_txt[1],NULL,m_mausli);
#ifdef UTF8
 SM(3,"Über ...",	  "Nachführung      ->", "Sonne+Mond-Grösse...",
    m_ueber,NULL,m_somogr);
#else
 SM(3,"ber ...",	  "Nachfhrung      ->", "Sonne+Mond-Grsse...",
    m_ueber,NULL,m_somogr);
#endif
 setsubmenu(2,NULL,nachf_txt[0],NULL,m_nachoff);
 setsubmenu(2,NULL,nachf_txt[1],NULL,m_nachnorm);
 setsubmenu(2,NULL,nachf_txt[2],NULL,m_nachobj);
 SM(1,"Exit",m_exit);
#ifdef DEBUG
 if(argflag['D'])
   {setmenu(1,"%~~~~~~~~~~~~~~~~~~~~~~",NULL);
    setmenu(1,"Test",m_debug1);
   }
#endif
 set_funktions(maus_press,maus_release,NULL,maus_motion);
 fenster.oeffnen(); //darin wir ein inital() gemacht
 palette_init();
 term_refresh();
 c_check(show_text);
 c_check(show_pict);
 c_check(show_html);
 hyw=textsize(bx,hy);
 zeichne_planetarium();
#ifdef DEBUG
 Systemzeit systemzeit;
 systemzeit.test();
#endif
 if(argflag['T'])
   {int imax=100,n=0; double z,z2;
    inital_new();
    printf("Testmodus: ermittle Rechenzeit\n");
    for(imax=10;n<10;imax*=10)
      {Systemzeit zeit1;
       for(i=0;i<imax;i++)
	 animiere_planetarium();
       Systemzeit zeit2;
       n=zeit2.secseit1970-zeit1.secseit1970;
       z=n/(double)imax; z2=1/(double)imax;
      }
    printf("Zeit pro animiere_planetarium(): %lf sec (+-%lf)\n",z,z2);
    term_refresh();
   }
 int it=1,takt=0,takt2=0;
 while(exitflag==0 && waitmenu(0)==0) // auf Benutzereingaben warten
   {waitTOF();
#ifdef DEBUG
    ++systemzeit;
#endif
    takt++; takt2++;
    if(animflag)
     {if(animflag<0) anim_stoppen();
      else if(--it<=0)
      {if(animflag==1) //Start der Animation
		{echtzeitflag=0; inital_new(); animflag=2; modjd=a_start;}
       animiere_planetarium(); it=anim_dt;
       modjd += a_step;
       if(modjd>a_end) anim_stoppen();
     }}
    else if(takt>=TICKS_PER_SECOND)
      {takt=0; modjd+=MODJDSEC;
       inital_new(); //test
       if(echtzeitflag==1)
	 {if(takt2>=zeittakt.xn)
	   {takt2 -= zeittakt.xn; animiere_planetarium();}
	  else rand_zeit();
	 }
       else if(echtzeitflag==2)
	 {if((c=echtzeit_aktualisierung())>0)
	   {if(c>1) animiere_planetarium();
	    else {sonne_und_planeten(); rand_zeit();}
	 } }
       else aktion_schrift();
       term_refresh(); //test
      }
   }
#ifdef DEBUG
 if(argflag['D'])
  {printf("Berechnung verlorener Ticks:\n");
   systemzeit.test();
   Systemzeit warezeit;
   warezeit.test();
   long verloreneticks=(warezeit.secseit1970-systemzeit.secseit1970)
		* TICKS_PER_SECOND + warezeit.ticks-systemzeit.ticks;
   printf("Verlorene TICKS: %d\n",verloreneticks);
  }
#endif
 term_exit();
 prvorschub=1; ausdruckstop();
 if(wbflag) fclose(stdout);
 return 0;
} /* ende main */

inline void planet200(int iplan,double t,double& l,double& b,double& r)
{
 switch(iplan)
	{case 1: mer200(t,l,b,r); CASE 2: ven200(t,l,b,r);
	 CASE 4: mar200(t,l,b,r); CASE 5: jup200(t,l,b,r);
	 CASE 6: sat200(t,l,b,r); CASE 7: ura200(t,l,b,r);
	 CASE 8: nep200(t,l,b,r); CASE 9: plu200(t,l,b,r);
	 CASE 0: l=b=r=0.0;
	 //CASE 3: l=ls+180.0; b= -bs; r=rs; //Erde
	}
}
void fixsterne()
{
 Fixstern *p=sterntabelle;
 int i,imax=anzfixanschr;
 if(imax>anzahlsterne) imax=anzahlsterne;
 fixanschrflag=1;
 for(i=0;i<imax;i++,p=p->next)
	p->zeichnen();
 fixanschrflag=0;
 for(;i<anzahlsterne;i++,p=p->next)
	p->zeichnen();
// if(nachfuehrung) //test
//  nachfuehrpunkt.zeichnen(1,nachfuehrpunkt.ra,nachfuehrpunkt.dec);
}

double sonne_und_planeten()
{
 Planet *plan,**pplan;
 int iplan,k,imode=(mode=='A')?2:1;
 double tt, x,y,z, xp,yp,zp, xs,ys,zs,
	l,b,r, ls,bs,rs, ra,dec,delta,abstand;
 char *s;
 double teqx=(mode=='B')?b1950:j2000;
 tt=(modjd-51544.5)/36525.0;
#ifdef DEBUG
 if(beokoflag==1) //alte Variante
   lambdaphi_berechnung(g_lambda,g_phi,beo_azimut,beo_h);
 else //neue Variante: Beobachtungskoordinaten erst in haz2beoko() verwenden
#endif
   {lambda=g_lambda; phi=g_phi;}
 sternzeit=15*lmst(modjd,lambda);//lambda in Grad
 if(nachfuehrung) nachfuehrpunkt_aktualisieren();
 // ecliptic coordinates of the sun, Equinox tt
 sun200(tt,ls,bs,rs);
 sonne.ls=ls; sonne.bs=bs; sonne.rs=rs;
 pmatecl(tt,teqx,sonne.as); //Matrix berechnen
 // planetary coordinates;
 if(-1.1<tt && tt<1.0) k=9; else k=8; //include Pluto between 1890 and 2100
 for(iplan=0,pplan=planet;iplan<=k;iplan++)
	{plan= *pplan++;
	 if(iplan==3) continue; //Erde nicht zeichnen
	 planet200(iplan,tt,l,b,r);
	 plan->R=r;//Abstand von Sonne (wird in objektinfo() verwendet)
	 geocen(tt, l,b,r, ls,bs,rs, iplan, imode,
		xp,yp,zp, xs,ys,zs, x,y,z,abstand);
	 if(mofiflag && iplan==0)
		erdschatten_berechnen(abstand,tt,teqx,-x,-y,-z);
	 if(mode=='A')
		{eclequ(tt,x,y,z); nutequ(tt,x,y,z);}
	 else	{pmatecl(tt,teqx,amatrix);
		 //precart(amatrix,xp,yp,zp);//ueberfluessig
		 precart(amatrix,x,y,z); eclequ(teqx,x,y,z);
		}
	 polar(x,y,z,delta,dec,ra); //berechnet delta,dec,ra (AE,Grad,Grad)
	 if(iplan!=0) //nicht fr Sonne
	  {plan->phaseberechnung(delta);
	   if(iplan==6) //Saturn braucht spezialbehandlung
	     {double dlong=provi.saturn_dlong;//provi.
	      plan->magberechnung_saturn(r,delta,dlong,dec*GRAD);
	     }
	   else
	     plan->magberechnung(r,delta);
	  }
	 plan->zeichnen(abstand,ra,dec); //ra,dec in Grad
	 if(printephem_flag==1) ausdrucken(plan->name,ra,dec,delta,
					   plan->durchm,plan->mag);
	}
 return tt;
}

void zeichne_planetarium()
{
 inital_new(); screenclear();
 statischer_rand();
 double tt=sonne_und_planeten();
 dynamischer_rand();
 fixsterne();
 erdmond(tt);
 kometen(tt);
 term_refresh();
}
void animiere_planetarium()
{
 if(grids!=GRID_OFF && refresh>1) grids_loeschen();
 double tt=sonne_und_planeten();
 dynamischer_rand(refresh>1);
 if(refresh>1) fixsterne();
 erdmond(tt);
 kometen(tt);
}

void Planet::kreis(double x,double y,double du,int farbe)
{
// int r1,r2,ix,iy; sind private Variablen der Planet-Klasse
 koorduser2pix(x,y,&ix,&iy);
 deltakoorduser2pix(du,du,&r1,&r2);
// printf("kreis(%lf,%lf,%lf,%d) --> ix=%d iy=%d r1=%d r2=%d\n",
//	x,y,du,farbe, ix,iy,r1,r2);// test
 if(r1+r2>2)
   {color(farbe); ifillcircle(ix,iy,r1,r2);}
 else ipunkt(ix,iy,farbe);
}

void Planet::loeschen()
{
 if(r1+r2>2)
   {color(0); ifillcircle(ix,iy,r1,r2);}
 else ipunkt(ix,iy,0);
 if(gezeichnetflag>1) ischrift(ix2,iy2,name);
 gezeichnetflag=0;
}

void Planet::zeichnen(double abst,double ra0,double dec0) //ra,dec in Grad
{
 int farbnr,ok;
 ra=ra0; dec=dec0; entf=abst;
 double hellig, x,y,r,du;
 durchm=atan(radius/(abst*AE))*(2.0/GRAD);//Durchmesser in Grad
 if(darart==HORIZONTAL)
  {equhor(dec,sternzeit-ra,phi,ho,az);//Liefert ho,az  alle Winkel in Grad
   if(printephem_flag==2) ausdrucken(name,az,ho,abst,durchm,mag);
   ok=haz2beoko(&x,&y,ho,az);
  }
 else //if(darart==EQUATORIAL)
   ok=radec2beoko(&x,&y,dec,ra);
 if(refresh>0 && gezeichnetflag) loeschen();
 if(ok)
   {farbnr=mag2col(mag,morpix);
    du=durchm/2./beobachtradius*uebertreib;
    kreis(x,y,du,farbnr);
    if(anschreibflag)
      {koorduser2pix(x+bx,y-hy/2,&ix2,&iy2); ischrift(ix2,iy2,name);
       gezeichnetflag=2;
      }
    else gezeichnetflag=1;
//    printf("%s gezeichnet\n",name);//debug
   }
// else printf("%s nicht sichtbar\n",name);//debug
}

bool haz2beoko(double *x,double *y,double h,double az)
{  //Hhe,Azimut (in Grad) in BeobachtungsKoordinaten umrechnen
   //Rckgabewert: true wenn im Zeichenbereich,  false: x,y undefiniert
#ifdef DEBUG
/* alte Variante: */
 if(beokoflag)
 {if(beokoflag==1) //alte Variante
    {double r=(90-h)/beobachtradius;
     if(r<=1.0 && r>= -1.0)
       {az = (az-90-beo_azimut)*GRAD;
	*x=r*cos(az); *y=r*sin(az);
	return 1;
       }
     return 0;
    }
  //else if(beokoflag==2)  noch nicht optimierte Variante:
  h *= GRAD; az *= GRAD; //alle Winkel in rad umrechnen
  //so drehen dass Beobachtungspunkt in 'Zenit' zu liegen kommt:
  az -= beo_azimut*GRAD; //erste Drehung
  double z1=sin(h),cosh=cos(h),r;
  double x1=cos(az)*cosh, y1= -sin(az)*cosh;
  //drehung(beo_sinaz,beo_cosaz,x1,y1); erste Drehung vor Umrechnung in xyz
  drehung(beo_sin90h,beo_cos90h,x1,z1);
  //jetzt Werte fr Abbildung berechnen:
  r=acos(z1)/beobachtradia;  //90-h == acos(z1/1)
  if(r<=1.0)
    {cosh=sqrt(1.0-z1*z1);
     double cosalfa=x1/cosh, sinalfa=y1/cosh;
     *x = -r*sinalfa;  *y = -r*cosalfa;
     return 1;
    }
  return 0;
 }
#endif
//Optimierte Variante: (Optimierung sinnvoll da diese Berechnung fr
// jeden Stern gemacht werden muss)
 az = (az-beo_azimut)*GRAD;
 double cosh=cos(h*=GRAD);
 double x1alt=cos(az)*cosh, y1= -sin(az)*cosh, z1=sin(h);
 double x1=beo_cos90h*x1alt-beo_sin90h*z1;
 z1=beo_cos90h*z1+beo_sin90h*x1alt;
 double r=acos(z1)/beobachtradia;  //90-h == acos(z1/1)
 if(r<=1.0)
    {r /= -sqrt(1.0-z1*z1);  // Siehe 'nicht optimierte' Variante !!
     *x = r*y1;  *y = r*x1;
     return 1;
    }
 return 0;
}

bool beoko2haz(double x,double y,double *hoehe,double *azimut)
{  //von BeobachtungsKoordinaten wieder in Hhe,Azimut (in Grad) umrechnen
   //Rckgabewert: true wenn erfolgreich
 int i=0,imax=20;
 double ho=beo_h,az=beo_azimut,x1=0.,y1=0.,dx,dy;
 double a=0.002, b= -a;
 //printf("beoko2haz(x=%lf y=%lf )\n",x,y);// test
 if((ho>89 || ho<-89) && beobachtradius>1)
   {ho-=sqrt(x*x+y*y)*beobachtradius;
    az+=atan2(y,x)/GRAD+90; if(az<0) az+=360;
    //printf("ho=%lf az=%lf\n",ho,az);// test
   }
 else
  for(i=0;i<imax;i++)
   {dx=x-x1; dy=y-y1;
    if(dx<a && dx>b && dy<a && dy>b) break;
    az+=dx*beobachtradius; ho+=dy*beobachtradius;
    if(ho>90) ho=180-ho;
    if(ho<-90) ho= -180-ho;
    haz2beoko(&x1,&y1,ho,az);
    //printf("ho=%lf az=%lf --> x1=%lf y1=%lf\n",ho,az,x1,y1);// test
   }
 if(i==imax) printf("beoko2haz: iteration konvergiert nicht\n");
 *hoehe=ho; *azimut=az; //Rckgabewerte in WinkelGrad
 return (i<imax);
}

bool taudec2beoko(double *x,double *y,double dec,double tau)
{
 //gleich wie haz2beoko(), aber dec,tau statt h,az
 tau = (tau-beo_tau)*GRAD;
 double cosh=cos(dec*=GRAD);
 double x1alt=cos(tau)*cosh, y1= -sin(tau)*cosh, z1=sin(dec);
 double x1=beo_cos90dec*x1alt-beo_sin90dec*z1;
 z1=beo_cos90dec*z1+beo_sin90dec*x1alt;
 double r=acos(z1)/beobachtradia;  //90-h == acos(z1/1)
 if(r<=1.0)
    {r /= -sqrt(1.0-z1*z1);  // Siehe 'nicht optimierte' Variante !!
     *x = r*y1;  *y = r*x1;
     return 1;
    }
 return 0;
}

bool beoko2taudec(double x,double y,double *decret,double *tauret)
{  //von BeobachtungsKoordinaten wieder in dec,tau (in Grad) umrechnen
   //Rckgabewert: true wenn erfolgreich
   //gleich wie beoko2haz() aber ho,az ersetzt durch dec,tau
 int i=0,imax=20;
 double dec=beo_dec,tau=beo_tau,x1=0.,y1=0.,dx,dy;
 double a=0.002, b= -a;
 if((dec>89 || dec<-89) && beobachtradius>1)
   {dec-=sqrt(x*x+y*y)*beobachtradius;
    tau+=atan2(y,x)/GRAD+90; if(tau<0) tau+=360;
   }
 else
  for(i=0;i<imax;i++)
   {dx=x-x1; dy=y-y1;
    if(dx<a && dx>b && dy<a && dy>b) break;
    tau+=dx*beobachtradius; dec+=dy*beobachtradius;
    if(dec>90) dec=180-dec;
    if(dec<-90) dec= -180-dec;
    taudec2beoko(&x1,&y1,dec,tau);
   }
 if(i>=imax) printf("beoko2taudec: iteration konvergiert nicht\n");
 *decret=dec; *tauret=tau; //Rckgabewerte in WinkelGrad
 return (i<imax);
}
bool beoko2radec(double x,double y,double *decret,double *raret)
{
 double tau;
 beoko2taudec(x,y,decret,&tau);
 *raret = sternzeit-tau;
}

void Fixstern::zeichnen()
{
 double h,az,x,y;
 int ok;
 if(darart==HORIZONTAL)
  {equhor(dec,sternzeit-ra,phi,h,az);//Liefert h,az  alle Winkel in Grad
   ok=haz2beoko(&x,&y,h,az);
  }
 else
   ok=radec2beoko(&x,&y,dec,ra);
 if(refresh>1 && gezeichnetflag) loeschen();
 if(ok)
   {koorduser2pix(x,y,&ix,&iy);
    ipunkt(ix,iy,farbnr);
    if(fixanschrflag && name!=NULL)
      {koorduser2pix(x+bx,y-hy/2,&ix2,&iy2); ischrift(ix2,iy2,name);
       gezeichnetflag=2;
      }
    else gezeichnetflag=1;
   }
}
void Fixstern::loeschen()
{
 ipunkt(ix,iy,0);
 if(gezeichnetflag>1) ischrift(ix2,iy2,name);
 gezeichnetflag=0;
}

#ifdef DEBUG
void lambdaphi_berechnung(double glam,double gphi,double baz,double bh)
{
/*
 Aus Beobachtungsrichtung und Geographischen Koordinaten
 die Werte lambda und phi berechnen.
*/
 if(beokoflag==1) //alte Variante
   {double tau;
    horequ(bh,baz,gphi,phi,tau); //Liefert Werte nach dec,tau  (phi=dec)
    lambda=glam+tau;
   }
 else //neue Variante
      //Beobachtungskoordinaten werden erst in haz2beoko() verwendet.
   {lambda=glam; phi=gphi;
   }
 if(phi< -90 || phi>90) //test
   {printf("Seltsame Werte fr phi: lambda=%lf phi=%lf\n",lambda,phi);
    printf(" berechnet aus: glam=%lf gphi=%lf baz=%lf bh=%lf\n",
	   glam,gphi,baz,bh);
   }
}
#endif

/********************** Beschriftung an Rndern *************************/
void zentrieren(char *str)
{
 int n,c;
 char *s,*z;
 for(n=0,s=str;*s++ ==' ';n++) ;
 if(n>=2)
   {for(z= &str[n/2], s= &str[n];(c= *s++);) *z++ = c;
    *z=0;
   }
}

void statischer_rand()
{
 static char str4[80],str5[80];
 static int flg=0;
// static int ix2=XMAX*11/15,iy1=YMAX/25*2-YMAX/100;//provi.
 static int ix2,iy1,ix3,iy3;
 if(flg==0)
   {const double x2=0.54, y1=0.89, x3=0.74,y3=0.81;
    koorduser2pix(x2,y1,&ix2,&iy1);
    koorduser2pix(x3,y3,&ix3,&iy3);
   }
 if(grids==GRID_OFF)
   {color(ROT);
    drawcircle(0.0,0.0,1.0,1.0);//Roter Kreis markiert Zeichenbereich
   }
 hy2w=textsize(bx2,hy2);
//Ort:
 if(flg) {color(0); ischrift(ix2,iy1,str4); ischrift(ix3,iy3,str5);}
 color(GRUEN);
 sprintf(str4,"%30s",ortsname); zentrieren(str4);
 ischrift(ix2,iy1,str4);
 sprintf(str5,"%.2lf %.2lf",g_lambda,g_phi);
 ischrift(ix3,iy3,str5);
 flg=1;
 init_knoepfe();
 textsize(bx,hy);
}

void rand_zeit(int flag)
{
 static char str1[80],str2[80];
 static int ix1,iy0,iy1,iy2, flg=0;
 if(flg==0)
   {const double x1= -1.25, y1=0.89, y2=0.81;
    koorduser2pix(x1,y1,&ix1,&iy1);
    koorduser2pix(x1,y2,&ix1,&iy2);
   }
 Zeit z(modjd);
 hy2w=textsize(bx2,hy2);
//Weltzeit:
 if(flg) {color(0); ischrift(ix1,iy1,str1);}
 if(echtzeitflag==2) sprintf(str1,"%s  ET.",z.stri(scratch));
 else sprintf(str1,"%s  ET",z.stri(scratch));
 color(GRUEN); ischrift(ix1,iy1,str1);
//Sternzeit:
 if(flg) {color(0); ischrift(ix1,iy2,str2);}
 color(GRUEN);
// sprintf(str2,"Sternzeit: %s",std2shou(lmst(modjd,g_lambda)));
 sprintf(str2,"Sternzeit: %s",std2shou(sternzeit/15.0));
 ischrift(ix1,iy2,str2);
 flg=1;
 if(flag)
   {aktion_schrift();
    if(anschreibflag || anzfixanschr>0) textsize(bx,hy);
   }
}

void dynamischer_rand(int flag)
{
 rand_zeit(0);
 static char str3[80],str4[80],str5[80];
 static int flg=0;
// static int ix1=2,iy1=YMAX/25-YMAX/100+get_menuleistenhoehe(),
//	   iy2=YMAX/25*2-YMAX/100,iy3=YMAX-5+get_menuleistenhoehe();//provi.
 static int ix1,iy0,iy1,iy2,iy3,iy4,ix5,iy5;
 if(flg==0)
   {const double x1= -1.25, y1=0.89, y2=0.81, y3= -0.99, y4= -0.91, x5=0.35;
    koorduser2pix(x1,y1,&ix1,&iy1);
    koorduser2pix(x1,y2,&ix1,&iy2);
    koorduser2pix(x1,y3,&ix1,&iy3);
    koorduser2pix(x1,y4,&ix1,&iy4);
    koorduser2pix(x5,y3,&ix5,&iy5);
   }
//Sonnenhoehe:
 if(flg) {color(0); ischrift(ix1,iy3,str3);}
 color(GRUEN);
#ifdef UTF8
 sprintf(str3,"Sonnenhöhe: %.2lf",Sonne.ho);
#else
 sprintf(str3,"Sonnenhhe: %.2lf",Sonne.ho);
#endif
 ischrift(ix1,iy3,str3);
//Finsternis:
 if(flg) {color(0); ischrift(ix1,iy4,str4);}
 color(GRUEN);
 sprintf(str4,"%s",finsternis_text());
 ischrift(ix1,iy4,str4);
//Gitterlinien:
 if(grids!=GRID_OFF && flag)
   {color(ROT);
    drawcircle(0.0,0.0,1.0,1.0);//Roter Kreis markiert Zeichenbereich
    grids_zeichnen();
   }
//Blickrichtung:
 if(flg) {color(0); ischrift(ix5,iy3,str5);}
 color(GRUEN);
 if(darart==HORIZONTAL)
   sprintf(str5,"AZ=%.2lf H=%.2lf R=%.2lf",
	   beo_azimut,beo_h,beobachtradius);
 else
   sprintf(str5,"RA=%.2lf DEC=%.2lf R=%.2lf",
	   beo_ra,beo_dec,beobachtradius);
 ischrift(ix5,iy5,str5);
//Endbehandlung:
 flg=1;
 aktion_schrift();
 if(anschreibflag || anzfixanschr>0) textsize(bx,hy);
}

void aktion_schrift(int start)
{
 static int flg=0,iy0,kx1,ky1,kx2,ky2,kb,kh;
 if(flg==0)
   {const double x1= -1.25, y0=0.97, xk2= -0.29, yk2=1.01;
    double b=0.02,h=0.05,hw;
    koorduser2pix(x1,y0,&kx1,&iy0);
#ifdef DEBUG
    printf("aktion_schrift(): textsize(b=%lf,h=%lf)",b,h);
#endif
    hw=textsize(b,h);
#ifdef DEBUG
    printf(" --> hw=%lf\n",h);
#endif
    deltakoorduser2pix(b,h,&kb,&kh);
    koorduser2pix(x1,y0-h/3,&kx1,&ky1);
    koorduser2pix(xk2,yk2,&kx2,&ky2);
    flg=1;
   }
 if(start>0) aktionzaehler=start;
 if(aktionzaehler==0) return;
 itextsize(kb,kh);
 color(0); ifillbox(kx1,ky1,kx2,ky2); color(GRUEN);
 if(--aktionzaehler>0) ischrift(kx1,iy0,aktion);
}

void put_aktion(char *s0)
{
 int c;
 char *s,*t;
 while(*s0==' ') s0++;
 for(t=CPFAD,c= *t;c!=0;)
   {for(s=s0;*s == (c= *t++);s++) ;
    if(c==',' || c==0) {s0=s; if(*s0=='/') s0++;  break;}
    while(c!=',' && c!=0) c= *t++;
   }
 char *str=new char[strlen(s0)+1];
 for(s=s0,t=str;(c= *s++) && c!=' ';)
	*t++ = c;
 *t++ = c;
 if(c==' ')
   {if(strncmp(s,"Planetium:",10)==0) s= &s[10];
    while(*t++ = *s++) ;
   }
 sprintf(aktion,"%.50s",str);
 delete str;
}
void put_aktion(char *s1,char *s2)
{
// sprintf(scratch2,"%.20s %s",s1,s2);
 sprintf(scratch2,"%s %s",s1,s2);
 put_aktion(scratch2);
}

int echtzeit_aktualisierung()
{
 int n;
 Zeit jetzt(WELTZEIT);
#ifdef GMTIME_FALSCH
 jetzt.addstd(-zeitzone);
#endif
 if(jetzt.min!=zeit.min) n=2;//Aktualisierung ntig
 else if(jetzt.sec>=zeit.sec+zeittakt.x) n=1;//Aktualisierung erwnscht
 else n=0;//keine Aktualisierung ntig
 if(n!=0)
   {zeit=jetzt; modjd=zeit.mjd();}
 return n;
}

/******************* allgemein ntzliche Funktionen *********************/
double wizwistars(double ra1,double dec1,double ra2,double dec2)
{
// Winkel zwischen zwei Sternen in RAD
 double beta,x2,y2,z2,a,b;
 double cosdec1=cos(dec1),sindec1=sin(dec1),cosdec2=cos(dec2);
 double deltara=ra1-ra2;
//um ra1 gedreht so dass P1 auf xz-Ebene zu liegen kommt:
 x2=cos(deltara)*cosdec2;
 y2=sin(deltara)*cosdec2;
 z2=sin(dec2);
//um dec1 um y-Achse drehen: (von z richtung x)
 a =cosdec1*x2+sindec1*z2; //a = neues x2
 z2=cosdec1*z2-sindec1*x2;
//Winkel zwischen x-Achse und P2:
 b=sqrt(y2*y2+z2*z2);
 if(a==0) beta=PIHALBE;
 else if(a<0) beta=PI-atan(b/(-a));
 else beta=atan(b/a);
 return beta;
}

void drehung(double sinw,double cosw,double& x,double& y)
{
//Um den Winkel w von x- Richtung y-Achse drehen (z-Achse = Drehachse)
 double xneu=cosw*x-sinw*y;
 y=cosw*y+sinw*x;
 x=xneu;
}

/******************************* Mond ***********************************/
class Mondposition
{
 int r1,r2,farbe,morpix,dunklefarbe;
public:
 int ix,iy,sichtbar,zuab;
#define ZUNEHMEND 1
#define ABNEHMEND 2
 double ho,az,ra,dec,entf;
 Mondposition() {sichtbar=0; farbe=mag2col(Mond.mag,morpix);/*provi.*/
	         dunklefarbe=GRAU2;}
 void zeichne(double x,double y,double du);
 void loesche();
 void putparameters(double h,double a,double b)	{ho=h; az=a; entf=b;}
 void berechneradec();
};
static Mondposition mondpos;

void halbkreis(int ix,int iy,int r1,int r2,double w1,double w2)
{
 const int n=18;
 int xf[n],yf[n],i;
 double da=(w2-w1)/(n-1);
 for(i=0;i<n;i++,w1+=da)
   {xf[i]=ix+idfix(r1*cos(w1));
    yf[i]=iy+idfix(r2*sin(w1));
   }
 ifillpolygon(n,xf,yf);
}

void Mondposition::zeichne(double x,double y,double du)
{
 koorduser2pix(x,y,&ix,&iy);
 deltakoorduser2pix(du,du,&r1,&r2);
 if(r1+r2>2)
   {//provi.: Orientierung noch nicht richtig
    color(farbe); ifillcircle(ix,iy,r1,r2);
    color(dunklefarbe);
    if(Mond.phase<0.5)
      ifillcircle(ix,iy,idfix(r1*(1-2*Mond.phase)),r2);
    if(zuab==ABNEHMEND)
      halbkreis(ix,iy,r1+1,r2+1,-90*GRAD,90*GRAD);
    else //zuab==ZUNEHMEND
      halbkreis(ix,iy,r1+1,r2+1,90*GRAD,270*GRAD);
    if(Mond.phase>0.5)
      {color(farbe);
       ifillcircle(ix,iy,idfix(r1*(2*Mond.phase-1)),r2);
      }
   }
 else ipunkt(ix,iy,farbe);
 sichtbar=1;
}
void Mondposition::loesche()
{
 if(r1+r2>2)
   {color(0); ifillcircle(ix,iy,r1+1,r2+1);}
 else ipunkt(ix,iy,0);
 sichtbar=0;
}
void Mondposition::berechneradec()
{
 double tau;
 horequ(ho,az,g_phi,dec,tau); //Liefert Werte nach dec,tau
 if((ra=sternzeit-tau)<0.0) ra+=360.0;
}
void berechneradec(double ho,double az,double& ra,double& dec)
{
 double tau;
 horequ(ho,az,g_phi,dec,tau); //Liefert Werte nach dec,tau
 if((ra=sternzeit-tau)<0.0) ra+=360.0;
}

double mondphase_provi(double ra,double sora)
{
 double phase=sora-ra;
 if(phase<0) phase+=360.0;
 else if(phase>360.0) phase-=360.0;
 phase/=180.0;
 if(phase>1)
   {mondpos.zuab=ZUNEHMEND; phase=2-phase;}
 else mondpos.zuab=ABNEHMEND;
 return phase;
}

const double erdradius=6.3675e6; //in Meter

void erdmond(double t)
{
 const double durchschn_abstand=384.4e6; //in Meter
 double abstand,ra,dec,kabst,paralax,durchm,durchmhalbe,mag;
 double h,az,x,y,rr,du,c,a;
 int ok;
 if(moonflag==MINIMOON)
   {mini_moon(t,ra,dec); //liefert ra,dec  nur auf etwa 5' genau (' = min.)
    ra *= WINKELSTD; //ra in Grad umrechnen
    abstand=durchschn_abstand;
    rr=abstand/erdradius; //Abstand in Erdradien (ungenau)
   }
 else
   {moonequ(t,ra,dec,rr); //liefert ra,dec,rr  auf etwa 1'' genau
    abstand=rr*erdradius;
   }
 kabst=1.0/rr; //Kehrwert des Abstands in Erdradien
//ra,dec sollte in Grad sein
 paralax=asin(kabst)/GRAD; //Tgliche Parallaxe in Grad
// hellig=durchm*durchm*Mond.albedo;//??
/* Paralax-Berechnung: */
 equhor(dec,sternzeit-ra,g_phi,h,az);//Liefert Werte nach h,az  in Grad
 c = sin(h*GRAD);
 h -= paralax*cos(h*GRAD);
 mondpos.putparameters(h,az,rr);
/* :ende Paralax-Berechnung */
 a=erdradius*(sqrt(rr*rr-(1.0-c*c))-c);//Abstand Beobachter-Mondmitte
 durchm=2*(durchmhalbe=asin(Mond.radius/a)/GRAD);//Durchmesser in Grad
/** test **
#ifdef DEBUG
 printf("erdmond: ra=%lf dec=%lf rr=%lf paralax=%s\n",
	ra,dec,rr,grad2s(paralax));
 printf("Bereich von durchm: %s bis",
	grad2s(2*asin(Mond.radius/abstand)/GRAD));
 printf(" %s\n",
	grad2s(2*asin(Mond.radius/(abstand-erdradius))/GRAD));
 printf("durchm = %s\n",grad2s(durchm));
#endif
/**/
 mondpos.berechneradec();//ra und dec nach Paralax-Korrektur
 Mond.phase=mondphase_provi(mondpos.ra,Sonne.ra);
 finsternis_test(durchmhalbe,Sonne.durchm/2);
 mag=Mond.mag*Mond.phase;//provi.
 if(printephem_flag)
   {const char *smond=(moonflag==MINIMOON)?"Mond (ca.)":"Mond";
    if(printephem_flag==1)
	{horequra(h,az,g_phi,dec,ra); //Liefert Werte nach dec,ra
	 ausdrucken(smond,ra,dec,rr,durchm,mag);
	}
    else ausdrucken(smond,az,h,rr,durchm,mag);
   }
 if(refresh>0 && mondpos.sichtbar) mondpos.loesche();
 if(darart==HORIZONTAL)
   ok=haz2beoko(&x,&y,h,az);
 else
  {if(printephem_flag!=1)
     horequra(h,az,g_phi,dec,ra); //Liefert Werte nach dec,ra
   ok=radec2beoko(&x,&y,dec,ra);
  }
 if(ok)
   {du=durchmhalbe/beobachtradius*uebertreib;
    mondpos.zeichne(x,y,du);
   }
}

/***************************** Kometen **********************************/
class Komet
{
 int ix,iy,ix2,iy2,gezeichnetflag;
 REAL33 pqr,aa;
 double delta,mag_h0,mag_n;
public:
 Komet *next;
 char *name;
 int jahr,mon,tag; double hour;
 double qperi,exze,incl,asce,wperi,t0,teqx0;
 double ra,dec,mag,entf,ho,az,R;
 Komet() {gezeichnetflag=0; next=NULL; mag=mag_h0=0;mag_n=1;entf=0;delta=0;}
 void init(double dtag,double equi,double h0,double n0);
 void berechnen(double t);
 void zeichnen();
 void loeschen();
 int getixiy(int *x,int *y)
   {if(gezeichnetflag) {*x=ix; *y=iy;} return gezeichnetflag;}
 char* getperis();
 double helligkeit(double h0,double n,double rs,double re);
};

void Komet::zeichnen()
{
 double r,x,y;
 int ok;
 if(darart==HORIZONTAL)
  {equhor(dec,sternzeit-ra,phi,ho,az);//Liefert ho,az alle Winkel in Grad
   if(printephem_flag==2) ausdrucken(name,az,ho,delta,/*durchm=*/0,mag);
   ok=haz2beoko(&x,&y,ho,az);
  }
 else
   ok=radec2beoko(&x,&y,dec,ra);
 if(refresh>0 && gezeichnetflag) loeschen();
 if(ok)
   {int morpix,farbe;//provi. gehrt in vorberechnungen
    farbe=mag2col(mag,morpix);
    koorduser2pix(x,y,&ix,&iy);
    ipunkt(ix,iy,farbe);
    if(anschreibflag && name!=NULL)
      {koorduser2pix(x+bx,y-hy/2,&ix2,&iy2); ischrift(ix2,iy2,name);
       gezeichnetflag=2;
      }
    else gezeichnetflag=1;
    entf=delta;
   }
}
void Komet::loeschen()
{
 ipunkt(ix,iy,0);
 if(gezeichnetflag>1) ischrift(ix2,iy2,name);
 gezeichnetflag=0;
}

static Komet *kometenliste=NULL;

void kometen_einlesen()
{
/** Datenbeispiel:
;kometen.dat
"Hale-Bopp"	 ! --- Comet Hale-Bopp 1996/97 --- !
 1997 4 1.10743  ;Zeit des Periheldurchgangs (year month day.fraction)
    0.913993837  ;Periheldistanz q in AE
    0.995048001  ;Numerische Exzentrizitt e
   89.4206485    ;Bahnneigung (Inclination) i
  282.4721531    ;Lnge des aufsteigenden Knotens (ascending node)
  130.5956174    ;Argument des Perihels (perihelion) w
 2000.0          ;Equinox for the orbital elements
 -1.0 4.0	 ;H0 n (fr Helligkeitsberechnung)
**/
 if(anzahlkometen!=0)
   {printf("Fehler: Kometen schon eingelesen\n"); return;}
 FILE *fp;
 Komet *p,*p0;
 p0=p=kometenliste=new Komet[1];
 char *zeile=scratch;
 int i,c,fehler=1;
 double dtag,equi,h0,n0;
 char *s;
 if(!(fp=fopen1(komettabname,"r"))) return; //keine Kometen vorhanden
 for(i=0;i<1000;)
     {if(getline(fp,zeile,200)==0) {fehler=0; break;}
      if(*zeile==';' || *zeile=='!' || *zeile==0) continue;
      if(i>0)
	{p0=p; p=new Komet[1]; p0->next=p;}
      pars(zeile,&s);
      if((c= *s)==0 || isspace(c) || isdigit(c) || c=='.' || c=='-')
	{printf("Error in '%s' fehlerhafter Name:\n '%s'\n",
		komettabname,zeile);
	 break;
        }
      p->name=strkopie(s);
      if(getline(fp,zeile,200)==0) break;
      sscanf(zeile,"%d %d %lf",&p->jahr,&p->mon,&dtag);
      if(getline(fp,zeile,200)==0) break;
      sscanf(zeile,"%lf",&p->qperi);
      if(getline(fp,zeile,200)==0) break;
      sscanf(zeile,"%lf",&p->exze);
      if(getline(fp,zeile,200)==0) break;
      sscanf(zeile,"%lf",&p->incl);
      if(getline(fp,zeile,200)==0) break;
      sscanf(zeile,"%lf",&p->asce);
      if(getline(fp,zeile,200)==0) break;
      sscanf(zeile,"%lf",&p->wperi);
      if(getline(fp,zeile,200)==0) break;
      sscanf(zeile,"%lf",&equi);
      if(getline(fp,zeile,200)==0) break;
      sscanf(zeile,"%lf %lf",&h0,&n0);
      p->init(dtag,equi,h0,n0);
      i++;
     }
 fclose(fp);
 if(fehler)
   {p0->next=NULL;
    if(i==1000) printf("so viele Kometen ?? da kann was nicht stimmen!\n");
    printf("Error in '%s': Fehlerhafte Kometen-Datei\n",komettabname);
    printf("letzte gelesene Zeile: '%s'\n",zeile);
   }
 else
   printf("%d Kometen eingelesen\n",anzahlkometen=i);
}

void kometen(double tt)  //und Kleinplaneten ...
{
 Komet *p=kometenliste;
 for(int i=0;i<anzahlkometen && p!=NULL;i++,p=p->next)
   {p->berechnen(tt);
    p->zeichnen();
   }
}

void Komet::init(double dtag,double equi,double h0,double n0)
{
 tag=int(dtag); hour=24.0*(dtag-tag);
 t0 = (mjd(tag,mon,jahr,hour) - 51544.5) / 36525.0;
 teqx0 = (equi-2000.0)/100.0;
 gausvec(asce,incl,wperi,pqr);
 mag_h0=h0; mag_n=n0;
// printf("Komet.init() '%s' %lf %lf %lf %lf %lf\n",
//	name,qperi,exze,incl,asce,wperi);// test
}

char* Komet::getperis() //Periheldurchgang als Text erhalten
{
 static char str[80];
 int tg,mo;
 long jahr;
 double std, jd=t0*36525.0+51544.5;
 std=mjd2datum(jd,&tg,&mo,&jahr);
 sprintf(str,"%ld-%d-%d %lf",jahr,mo,tg,std);
 return str;
}

void Komet::berechnen(double t)
{
 double teqx=(mode=='B')?b1950:j2000;
 double xs,ys,zs,x,y,z,vx,vy,vz,r,b,l,fac,delta0;
 pmatecl(teqx0,teqx,aa); //calculate precession matrix
 cart(sonne.rs,sonne.bs,sonne.ls,xs,ys,zs);
 precart(sonne.as,xs,ys,zs);
 /* heliocentric ecliptic coordinates of the comet       */
 kepler(t0,t,qperi,exze,pqr,x,y,z,vx,vy,vz);
 precart(aa,x,y,z); precart(aa,vx,vy,vz); polar(x,y,z,r,b,l); R=r;
 /* geometric geocentric coordinates of the comet        */
 x += xs; y += ys; z += zs;  delta0 = sqrt(x*x+y*y+z*z);
 /* first order correction for light travel time         */
 fac = 0.00578*delta0;  x -= fac*vx;  y -= fac*vy;  z -= fac*vz;
 eclequ(teqx,x,y,z);
 polar(x,y,z,delta,dec,ra); //liefert dec,ra in Grad
 mag=helligkeit(mag_h0,mag_n,R,delta0);
 if(printephem_flag==1) ausdrucken(name,ra,dec,delta,0,mag);
// printf("Komet '%s' dec=%lf ra=%lf\n",name,dec,ra);// test
}

double Komet::helligkeit(double h0,double n,double rs,double re)
{
 double mag; //Formel nach SuW 10(1997)823
 mag = h0+5*log10(re)+2.5*n*log10(rs); //re=Abstand zur Erde, rs=zur Sonne
 return mag;
}

/********************* Ephemeriden ausdrucken ***************************/
//static int printephem_flag=0; schon weiter oben
//static FILE *fpprint=NULL;

void ausdruckstop()
{
 if(fpprint && fpprint!=stdout && prvorschub)
	{fclose(fpprint); fpprint=NULL;}
}

void ausdrucken(const char *name,double ra,double dec,double abstand,
		double durchm,double mag)
{
 if(*printer=='*')
   {fpprint=stdout; if(name==NULL) return;}
 else
   {if(name==NULL) {ausdruckstop();  return;}//Ausdruck beenden
    if(fpprint==NULL && !(fpprint=fopen(printer,"w")))
		return;//Drucker nicht erreichbar
   }
 if(abstand==0)
   {char str[80],*s; int i;
    fprintf(fpprint,"\n%s  Geogr.Lnge: %.2lf  Geogr.Breite: %.2lf\n",
	    ortsname,g_lambda,g_phi);
    Zeit z(modjd);
    fprintf(fpprint,"Ephemeriden am  %s (ET)   Sternzeit: %s\n",
	    z.stri(scratch),std2shou(lmst(modjd,g_lambda)));
    for(i=strlen(name),s=str;--i>=0;) *s++ = '-';
    *s=0;
    fprintf(fpprint,"%s\n%s\n%s\n",str,name,str); //unterstrichener Titel
   }
 else if(printephem_flag==1) //RA, Dekl
   fprintf(fpprint,"%-12s %-9s %-11s %-12lf  %-7s  %.2lf\n",
   //fprintf(fpprint,"%-12s %-9s %-11s %-12lf  %-7s  %lg\n",
	   name,rad2shou(ra*GRAD),rad2sdeg(dec*GRAD),abstand,
	   grad2s(durchm),mag);
 else //(printephem_flag==2) //AltAzimut
   fprintf(fpprint,"%-12s %-9.3lf %-11s %-12lf  %-7s  %.2lf\n",
	   name,ra,rad2sdeg(dec*GRAD),abstand,
	   grad2s(durchm),mag);
}

void ephem_more(char *s)
{
 FILE *fp,*fp0; int c0;
 if(fpprint) ausdruckstop();
 if(!(fp=fopen(TMP_EPHEMERIDEN,"w")))
   {janeinrequester2("kann \"%s\" nicht ffnen",TMP_EPHEMERIDEN); return;}
 fp0=fpprint; fpprint=fp;
 c0= *printer; *printer=0;
 m_prephem();
 *printer=c0;
 if(fpprint!=NULL) fclose(fpprint);
 fpprint=fp0;
 sprintf(scratch1,"%s %s",show_text,TMP_EPHEMERIDEN);
 runsystem(scratch1);
}

/************************** Nachfhrung *********************************/
void nachfuehrpunkt_aktualisieren()
{
 if(darart==HORIZONTAL)
  {if(nachfuehrung==NACHF_STERN)
     {equhor(nachfuehrpunkt.dec,sternzeit-nachfuehrpunkt.ra,g_phi,
	     nachfuehrpunkt.ho,nachfuehrpunkt.az);
      beo_azimut=nachfuehrpunkt.az; beo_h=nachfuehrpunkt.ho;
     }
   else if(nachfuehrung==NACHF_STERN_START)
     {double ho,az;
      beoko2haz(0.0,0.0,&ho,&az);
      berechneradec(ho,az,nachfuehrpunkt.ra,nachfuehrpunkt.dec);
      nachfuehrpunkt.az=beo_azimut=az; nachfuehrpunkt.ho=beo_h=ho;
      nachfuehrung=NACHF_STERN;
     }
   else if(nachfuehrung==NACHF_OBJ)
     {beo_azimut=nachfuehrplanet->az; beo_h=nachfuehrplanet->ho;}
   beo_sinaz=sin(beo_azimut*GRAD); beo_cosaz=cos(beo_azimut*GRAD);
   beo_sin90h=sin((90-beo_h)*GRAD); beo_cos90h=cos((90-beo_h)*GRAD);
  }
 else
  {if(nachfuehrung==NACHF_STERN)
     {beo_ra=sternzeit-nachfuehrpunkt.ra; beo_dec=nachfuehrpunkt.dec;}
   else if(nachfuehrung==NACHF_STERN_START)
     {nachfuehrpunkt.dec=beo_dec; nachfuehrpunkt.ra=sternzeit-beo_tau;
      equhor(beo_dec,beo_tau,g_phi,nachfuehrpunkt.ho,nachfuehrpunkt.az);
      nachfuehrung=NACHF_STERN;
     }
   else if(nachfuehrung==NACHF_OBJ)
     {beo_ra=sternzeit-nachfuehrplanet->ra; beo_dec=nachfuehrplanet->dec;}
   beo_sinra=sin(beo_ra*GRAD); beo_cosra=cos(beo_ra*GRAD);
   beo_sin90dec=sin((90-beo_dec)*GRAD); beo_cos90dec=cos((90-beo_dec)*GRAD);
  }
}

/************************ Systemvariablen *******************************/
//Systemabhngige Funktionen
#ifdef AMIGA
int get_zeitzone()
{
 OPEN_Locale();
 if(!LocaleBase) return zeitzone;//konnte Locale-Library nicht ffnen
 Locale* locale=OpenLocale(NULL);
 int n=locale->GMTOffset;
 CloseLocale(locale);
 closelibs();
 return -n/60;
}

void closelibs() {CLOSELIB(LocaleBase);}
#endif

/************************** Maus-Steuerung ******************************/
#define MAUKLICK 1
#define MAUZOOM  2
#define MAUKNOPF 4
#define FADENOFF 1

void objektinfo();
void objektfoto();
void zoom_in();
void zoom_foto();
void knopfdruck(int x,int y,int ud);

class Mauszustand
{
public:
 int status,ta;
 int x0,y0,x1,y1;
 Mauszustand() {status=ta=0;}
 void faden(int x,int y,int off=0);
 int fastgleich()
  {const int d=10; //war vorher 2
   return (x1-x0<d && y1-y0<d && x0-x1<d && y0-y1<d);
  }
};
inline void ibox(int x0,int y0,int x1,int y1)
{
 idrawbox(x0,y0,x1,y1);
}
void Mauszustand::faden(int x,int y,int off)
{
 if((status & MAUZOOM)==0) status |= MAUZOOM;
 else	ibox(x0,y0,x1,y1); //altes Fadenkreuz loeschen
 x1=x; y1=y;
 if(off) {status &= ~MAUZOOM;
	  mydrawmode(JAM1);//wieder normaler Zeichnungsmodus
	 }
 else	{mydrawmode(COMPLEMENT);
	 ibox(x0,y0,x1,y1); //Fadenkreuz neu zeichnen
	}
}

static Mauszustand maus;

void maus_press()
{
 if(maus.status!=0) return;//drcken von zweiter Maustaste ignorieren
 int ta,x,y;
 ta=imausposition(&x,&y);
 if(ta==REMAUS)
     ta=MIMAUS; //Mausklicks um Mens anzuwhlen werden normalerweise nicht
		//bis hier durchgereicht. Unter Linux kann hiermit aber
		//die rechte Maustaste anstelle der Linken verwendet werden.
 maus.x0=x; maus.y0=y; maus.ta=ta; //LIMAUS oder MIMAUS
 double ax,ay;
 koordpix2user(x,y,&ax,&ay);
#ifdef DEBUG
 //printf("maus_press() x=%d y=%d ax=%lf ay=%lf\n",x,y,ax,ay);//test
#endif
 if(ax*ax+ay*ay>1.0)
	{maus.status=MAUKNOPF; knopfdruck(x,y,1);}
 else	{maus.status=MAUKLICK;}
}
void maus_release()
{
 if(maus.status!=0)
   {int x,y;
    imausposition(&x,&y);
    if(maus.status==MAUKNOPF) knopfdruck(x,y,0);//Klick auf einen Knopf
    else if(maus.status==MAUKLICK || maus.fastgleich()) //einfacher Klick
      {if(maus.status & MAUZOOM) maus.faden(x,y,FADENOFF);
       if(maus.ta & limaus) objektinfo(); else objektfoto();
      }
    else //MAUZOOM
      {maus.faden(x,y,FADENOFF);
       if(maus.ta & limaus) zoom_in(); else zoom_foto();
      }
    maus.status=0;
   }
}
void maus_motion()
{
 if(maus.status!=0 && maus.status!=MAUKNOPF)
   {int x,y;
    imausposition(&x,&y);
    maus.faden(x,y);
   }
}

inline int abstandq(int x1,int y1,int x2,int y2)
{
 return sq(x2-x1)+sq(y2-y1);
}
inline int abstandq(Fixstern *p,int x2,int y2)
{
 int x,y;
 if(!p->getixiy(&x,&y)) return 32000;
 return sq(x2-x)+sq(y2-y);
}
inline int abstandq(Planet *p,int x2,int y2)
{
 int x,y;
 if(!p->getixiy(&x,&y)) return 32000;
 return sq(x2-x)+sq(y2-y);
}
inline int abstandq(Komet *p,int x2,int y2)
{
 int x,y;
 if(!p->getixiy(&x,&y)) return 32000;
 return sq(x2-x)+sq(y2-y);
}

void objektmarkieren(int ix,int iy,int farb=PURPUR)
{
 double x,y,r=0.015;
 koordpix2user(ix,iy,&x,&y);
 color(farb); drawcircle(x,y,r,r);
}

void objektinfo()
{
#ifdef DEBUG
 printf("objektinfo()\n");//test
#endif
 int ok,ix,iy, besta=32000,a;
 char str[400],*stebildname=NULL,*bemerk;
 ix=maus.x0; iy=maus.y0;
 Fixstern *p,*best=NULL;
 Planet **pl,*bestp=NULL;
#ifdef DEBUG
 printf("mondpos.sichtbar=%d\n",mondpos.sichtbar);//test
#endif
 if(mondpos.sichtbar)
   besta=abstandq(mondpos.ix,mondpos.iy,ix,iy);
#ifdef DEBUG
 printf("1.besta=%d\n",besta);//test
#endif
 for(p=sterntabelle;p!=NULL;p=p->next)
   if((a=abstandq(p,ix,iy))<besta) {besta=a; best=p;}
 for(pl=planet;*pl;pl++)
   if((a=abstandq(*pl,ix,iy))<=besta) {besta=a; bestp= *pl;}
 Komet *pk=kometenliste,*bestk=NULL;
 for(int i=0;i<anzahlkometen && pk!=NULL;i++,pk=pk->next)
   if((a=abstandq(pk,ix,iy))<=besta) {besta=a; bestk=pk;}
#ifdef DEBUG
 printf("2.besta=%d\n",besta);//test
#endif
 if(bestk && bestk->getixiy(&ix,&iy))
   {//nchstes Objekt ist ein Komet
    objektmarkieren(ix,iy);
    sprintf(str,"Komet %s\nra=%s  dec=%s\nAzimut: %.3lf  Hhe: %s\n\
Magn: %.2lf  Entfernung: %.4lf AE\nAbstand von Sonne: %lf AE",
	    bestk->name,rad2shou(bestk->ra*GRAD),rad2sdeg(bestk->dec*GRAD),
	    bestk->az,rad2sdeg(bestk->ho*GRAD),
	    bestk->mag,bestk->entf,bestk->R);
    ok=janeinrequester(str,"aha","mehr");
    if(!ok)
      {sprintf(str,"'%s'\nPeriheldurchgang: %s\nPeriheldistanz: %lf AE\n\
Exzentrizitt: %lf\n  Bahnneigung: %lf \naufsteig. Knoten: %lf \n\
 PerihelArgument: %lf \nEquinox: %.1lf",
	       bestk->name,bestk->getperis(),
	       bestk->qperi,bestk->exze,bestk->incl,bestk->asce,
	       bestk->wperi,bestk->teqx0*100+2000.0);
      }
    objektmarkieren(ix,iy,0);
   }
 else if(bestp && bestp->getixiy(&ix,&iy))
   {//gefundenes Objekt ist ein Planet
    objektmarkieren(ix,iy);
    if(bestp == &Sonne)
     sprintf(str,"%s\nra=%s  dec=%s\nAzimut: %.3lf  Hhe: %s\n\
Magn: %.2lf  Entfernung: %.4lf AE",
	    bestp->name,rad2shou(bestp->ra*GRAD),rad2sdeg(bestp->dec*GRAD),
	    bestp->az,rad2sdeg(bestp->ho*GRAD),
	    bestp->mag,bestp->entf);
    else
     sprintf(str,"%s\nra=%s  dec=%s\nAzimut: %.3lf  Hhe: %s\n\
Magn: %.2lf  Entfernung: %.4lf AE\n\
Elong: %.1lf  Phase: %.3lf",
	    bestp->name,rad2shou(bestp->ra*GRAD),rad2sdeg(bestp->dec*GRAD),
	    bestp->az,rad2sdeg(bestp->ho*GRAD),
	    bestp->mag,bestp->entf,
	    bestp->elong/GRAD,bestp->phase);
    ok=janeinrequester(str,"aha","mehr");
    if(!ok)
     if(bestp == &Sonne)
      {sprintf(str,"%s\nMasse: %lg kg\nRadius: %.3lf km",
	    bestp->name,bestp->masse,bestp->radius/1e3);
      }
     else
      {sprintf(str,"Planet %s\n\
Masse: %lg kg\nRadius: %.3lf km\nAlbedo: %.3lf\n\
Abstand von der Sonne: %lf AE\n\
Umlaufzeit  um  Sonne: %.2lf Tage",
	    bestp->name,
	    bestp->masse,bestp->radius/1e3,bestp->albedo,bestp->R,
	    bestp->U);
      }
    objektmarkieren(ix,iy,0);
   }
 else if(best==NULL && bestp==NULL && besta<32000)
   {//gefundenes Objekt ist der Mond
    mondpos.berechneradec();
    objektmarkieren(ix=mondpos.ix,iy=mondpos.iy);
    sprintf(str,"Erdmond\nra=%s  dec=%s\nAzimut: %.3lf  Hhe: %s\n\
Entfernung: %.2lf Erdradien\nPhase: %.3lf  %s",
	rad2shou(mondpos.ra*GRAD),rad2sdeg(mondpos.dec*GRAD),
	mondpos.az,rad2sdeg(mondpos.ho*GRAD), mondpos.entf, Mond.phase,
	(mondpos.zuab==ZUNEHMEND)?"zunehmend":"abnehmend");
    ok=janeinrequester(str,"aha","mehr");
    if(!ok)
      {Planet *p= &Mond;
       sprintf(str,"Erdmond\n\
Masse: %lg kg\nRadius: %.3lf km\nAlbedo: %.3lf\n\
Mittlerer Abstand von der Erde: 384400 km\n\
Umlaufzeit (siderisch) : %.3lf Tage",
	    p->masse,p->radius/1e3,p->albedo, p->U);
      }
    objektmarkieren(ix,iy,0);
   }
 else //gefundenes Objekt ist ein Stern
 {if(besta==32000)
   {sprintf(str,"kein Objekt in der Nhe");
    ok=0;
   }
  else
   {double ho,az;
    int imehr;
    best->getixiy(&ix,&iy); objektmarkieren(ix,iy);
#ifdef DEBUG
    printf("Stern markiert\n");//test
#endif
    best->gethaz(ho,az);
    if(best->sternbild!=NULL) stebildname=best->sternbild->name;
    if(stebildname==NULL) stebildname="unbekannt";
    if((bemerk=best->bemerk)==NULL) bemerk="keine";
    sprintf(str,"%s\n%s\nra=%s  dec=%s\nAzimut: %.3lf  Hhe: %s\n\
Magnitude: %.2lf  Entfernung: %s Lichtj.\n\
Sternbild: %s (%s)\nBemerkungen: %s",
	    best->name,klartext(best->typ),
	    rad2shou(best->ra*GRAD),rad2sdeg(best->dec*GRAD),
	    az,rad2sdeg(ho*GRAD),
	    best->mag,entfstr(best->entf),
	    stebildname,uebersetzen(stebildname), bemerk);
    imehr=(best->eigen!=NULL || best->entfm!=0);
    ok=janeinrequester(str,"aha",(char*)(imehr?"mehr":"aha"));
    if(!imehr) ok=1;
    if(!ok)
      {sprintf(str,"%s\nEntfernung: %s LJ  %s\n%s",
	       best->name,
	       entfstr(best->entf),klartext(best->entfm),
	       klartext2(best->eigen));
      }
    objektmarkieren(ix,iy,0);
   }
 }
 if(ok==0) janeinrequester(str,"aha","aha");
}

void objektfoto()
{
 int ok=1,ix,iy, besta=32000,a;
 char str[80],*stebildname=NULL,*bemerk;
 ix=maus.x0; iy=maus.y0;
 Fixstern *p,*best=NULL;
 Planet **pl,*bestp=NULL;
 if(mondpos.sichtbar)
   besta=abstandq(mondpos.ix,mondpos.iy,ix,iy);
 for(p=sterntabelle;p!=NULL;p=p->next)
   if((a=abstandq(p,ix,iy))<besta) {besta=a; best=p;}
 for(pl=planet;*pl;pl++)
   if((a=abstandq(*pl,ix,iy))<=besta) {besta=a; bestp= *pl;}
 Komet *pk=kometenliste,*bestk=NULL;
 for(int i=0;i<anzahlkometen && pk!=NULL;i++,pk=pk->next)
   if((a=abstandq(pk,ix,iy))<=besta) {besta=a; bestk=pk;}
 if(bestk && bestk->getixiy(&ix,&iy))
   {//nchstes Objekt ist ein Komet
    objektbild(ix,iy,bestk->name);
   }
 else if(bestp && bestp->getixiy(&ix,&iy))
   {//gefundenes Objekt ist ein Planet
    objektbild(ix,iy,bestp->name);
   }
 else if(best==NULL && bestp==NULL && besta<32000)
   {//gefundenes Objekt ist der Mond
    mondpos.berechneradec();
    zeigemondbild(mondpos.ix,mondpos.iy,"Erdmond");
   }
 else //gefundenes Objekt ist ein Stern
 {if(besta==32000)
   {sprintf(str,"kein Objekt in der Nhe");
    ok=0;
   }
  else
   {best->getixiy(&ix,&iy);
    objektbild(ix,iy,best->name,best->ra,best->dec);
   }
 }
 if(ok==0) janeinrequester(str,"aha","aha");
}
void zoom_foto()
{
 double x0,y0,x1,y1,az,ho,az2,ho2,dx,dy,ra,dec,sektor;
 koordpix2user(maus.x0,maus.y0,&x0,&y0);
 koordpix2user(maus.x1,maus.y1,&x1,&y1);
 dx = (x1>=x0) ? x1-x0 : x0-x1;
 dy = (y1>=y0) ? y1-y0 : y0-y1;
 if(dy>dx) dx=dy;
 if(dx==0) dx=0.001;
 x0=(x0+x1)/2.0; y0=(y0+y1)/2.0;
 if(darart==HORIZONTAL)
  {beoko2haz(x0,y0,&ho,&az);
   berechneradec(ho,az,ra,dec); //Zentrum des gewnschten Bildes
  }
 else
  {beoko2radec(x0,y0,&dec,&ra);}
 sektor=beobachtradius*dx/2; //Grsse in Grad (des Himmelssektors)
 zeigebild(ra,dec,sektor);
}

void darmenu_sonst()
{
 int id=dar_ids[5];
 if(id) menu_switch(id,dar_ids,darmenu,6,dar_txt);
}
void zoom_in()
{
 double x0,y0,x1,y1,dx,dy,dh;
 koordpix2user(maus.x0,maus.y0,&x0,&y0);
 koordpix2user(maus.x1,maus.y1,&x1,&y1);
// printf("zoom_in() %lg %lg %lg %lg\n",x0,y0,x1,y1);// test
 dar_hist.push();
 dx = (x1>=x0) ? x1-x0 : x0-x1;
 dy = (y1>=y0) ? y1-y0 : y0-y1;
 if(dy>dx) dx=dy;
 if(dx==0) dx=0.001;
 x0=(x0+x1)/2.0; y0=(y0+y1)/2.0;
// dh=sqrt(x0*x0+y0*y0);
 if(darart==HORIZONTAL)
	beoko2haz(x0,y0,&beo_h,&beo_azimut);
 else	beoko2taudec(x0,y0,&beo_dec,&beo_tau);
 darmenu=5; beobachtradius *= dx/2;
 darmenu_sonst();
 darst_akt();
}
void zoom_undo(char *s)
{
 dar_hist.pop();
 darmenu_sonst();
 darst_akt();
}
void zoom_out(char *s)
{
 double faktor;
 if(beobachtradius>178.999) return;//kein weiteres "Zoom out" mglich
 dar_hist.push();
 faktor = 1.01+(180-beobachtradius)*0.49/135; //weniger starkes rauszoomen
 if(faktor>1.5) faktor=1.5;		      //wenn Radius schon gross.
 beobachtradius*=faktor;
 if(beobachtradius>179) beobachtradius=179; //stets kleiner als 180 Grad
 darmenu_sonst();
 darst_akt();
}

/***************************** Knpfe ***********************************/
typedef void (*kfunkzeiger)(char*);

void test_fun(char *s)
{
 printf("knopf '%s' gedrckt\n",s);
}
#define TEST_FUN (kfunkzeiger)(test_fun)

class Knopf
{
 double x,y;
 kfunkzeiger fun;
 bool drin(int x,int y);
 void mark(int);
public:
 int x1,y1,x2,y2,xt,yt;
 char *text;
 Knopf(char *s,double x0,double y0,kfunkzeiger z);
 void init(double bx,double hy);
 bool keypress(int x,int y);
 bool keyrelease(int x,int y);
};
Knopf::Knopf(char *s,double x0,double y0,kfunkzeiger z)
{
 text=s; x=x0; y=y0; fun=z;
}
void Knopf::mark(int f)
{
 color(f); idrawbox(x1,y1,x2,y2);
}
void Knopf::init(double bx,double hy)
{
 koorduser2pix(x,y,&x1,&y1);
 koorduser2pix(x+(strlen(text)+1)*bx,y+1.4*hy,&x2,&y2);
 koorduser2pix(x+0.5*bx,y+0.25*hy,&xt,&yt);
 color(BLAU); idrawbox(x1,y1,x2,y2);
 color(BLAUGRUEN); ischrift(xt,yt,text);
}
bool Knopf::drin(int x,int y)
{
 int hy1,hy2;
 if(y2<y1) {hy1=y2; hy2=y1;}
 else      {hy1=y1; hy2=y2;}
 return (x>=x1 && x<=x2 && y>=hy1 && y<=hy2);
}
bool Knopf::keypress(int x,int y)
{
 bool ok=drin(x,y);
 if(ok) mark(WEISS);
 return ok;
}
bool Knopf::keyrelease(int x,int y)
{
 bool ok=drin(x,y);
 mark(BLAU);
 if(ok) (*fun)(text);
 return ok;
}

Knopf	refreshknopf("Ref",0.82,-0.64,(kfunkzeiger)m_refresh),
	undoknopf("Undo",0.8,-0.7,zoom_undo),
	zoomoutknopf("Zoom Out",0.74,-0.76,zoom_out),
	ephemknopf("Ephemeriden",0.68,-0.82,ephem_more);
Knopf	*knoepfe[]={&refreshknopf,&undoknopf,&zoomoutknopf,
		    &ephemknopf,NULL};

void init_knoepfe()
{
 hy3w=textsize(bx3,hy3);
 for(Knopf **p=knoepfe;*p;p++)  (*p)->init(bx3,hy3);
}

void knopfdruck(int x,int y,int ud)
{
 static Knopf *p0=NULL;
 Knopf **pp,*p;
 if(ud==0) //Taste losgelassen
   {if(p0) p0->keyrelease(x,y);
    p0=NULL;
    return;
   }
 for(pp=knoepfe;(p= *pp++)!=NULL;)
   if(p->keypress(x,y))  {p0=p; return;}
}

/************************ System-Commandos ******************************/
#ifdef unix

void runsystem(char *str)
{
 char rstr[120];
// sprintf(rstr,"run >NIL: %.108s",str);
 sprintf(rstr,"%.108s&",str);
#ifdef DEBUG
 printf("runsystem() --> system(%s)\n",rstr);//test
#endif
 system(rstr);
}
void runsystem2(char *s1,char *s2)
{
// char *rstr, *cstr="run >NIL: %s %s";
 char *rstr, *cstr="%s %s&";
 rstr=new char[strlen(s1)+strlen(s2)+strlen(cstr)];
 sprintf(rstr,cstr,s1,s2);
#ifdef DEBUG
 printf("runsystem2() --> system(%s)\n",rstr);//test
#endif
 system(rstr);
 delete rstr;
}

#else /*unix*/

/* int system(char *str)
{
 printf("system(%s)\n",str);//test
 Execute(str,0,0);
} */

void runsystem(char *str)
{
 char rstr[120];
 sprintf(rstr,"run >NIL: %.108s",str);
 put_aktion(str); aktion_schrift(10);
#ifdef DEBUG
 printf("runsystem(%s)\n",rstr);//test
#endif
 int ok=Execute(rstr,NULL,NULL);
 if(!ok) janeinrequester2("Fehler in Execute('%s')",rstr);
}
void runsystem2(char *s1,char *s2)
{
 char *rstr, *cstr="run >NIL: %s %s";
 rstr=new char[strlen(s1)+strlen(s2)+strlen(cstr)];
 sprintf(rstr,cstr,s1,s2);
 put_aktion(s1,s2); aktion_schrift(10);
#ifdef DEBUG
 printf("runsystem2(%s)\n",rstr);//test
#endif
 int ok=Execute(rstr,0,0);
 if(!ok) janeinrequester2("Fehler bei Execute('%s')",rstr);
 delete rstr;
}

#endif /*unix else*/

/************************** Farbpalette *********************************/
typedef char string40[40];

void m_palet()
{
//provi.
 int ok,i,r,g,b;
 rgbfarbe *p;
 string40 str[7];
 for(i=0,p= &farbpalette[1];i<7;i++,p++)
   sprintf(str[i],"%d %d %d",p->r,p->g,p->b);
 ok=requester_input(7,
	"GRUEN  Men, Zeit und Ort-Beschriftungen","%s","%s\n",str[0],
	"ROT  Grundfarbe fr diverse Sachen","%s","%s\n",str[1],
	"WEISS  hellste Sterne","%s","%s\n",str[2],
	"BLAU  Schalter-Rahmen","%s","%s\n",str[3],
	"GELB  Sonne","%s","%s\n",str[4],
	"BLAUGRUEN  Schalter-Beschriftungen","%s","%s\n",str[5],
	"PURPUR  Zoomfarbe, Markierungsfarbe","%s","%s\n",str[6]);
 if(ok)
   for(i=0,p= &farbpalette[1];i<7;i++,p++)
      {//printf("str[%d]='%s'\n",i,str[i]);// test
       sscanf(str[i],"%d %d %d",&r,&g,&b);
       if(r+g+b <= 0)
	 {printf("Farbfehler: %d %d %d --> 90 90 90\n",r,g,b);
	  r=g=b=90;
	 }
       p->r=r; p->g=g; p->b=b;
       setcolor(i+1,p->r,p->g,p->b);
      }
}

/******************** Bilder (Fotos) anzeigen ***************************/
char *dateinamefilter(const char *name,char *dname,int max)
{
 int c,i; char *s;
 for(s=dname,i=1;(c= *name++)!=0 && i<max;i++)
   {if(isupper(c)) c=tolower(c);
    if(c==' ' || c=='\t' || c==',' || c==';')
		c='_';
    *s++ = c;
   }
 *s=0;
 return dname;
}
//Variante ohne pfad wre:
// if(c==' ' || c=='\t' || c=='\\' || c=='/' || c==',' || c==';')

bool bildvorhanden(char *name)
{
 char str[N200];
 sprintf(str,"%s%s.jpg",BILDPFAD,name);
 if(vorhanden(str)) return 1;
 sprintf(str,"%s%s.iff",BILDPFAD,name);
 return vorhanden(str);
}

bool showpic(char *name)
{
 if(!vorhanden(name)) return 0;
 runsystem2(show_pict,name);
 return 1;
}

void dann_schick_es()
{
 sprintf(scratch2,"Das wre toll!\n\
Bitte schick das Foto an folgende Adresse:\n\n%s\n\
Es kann ein Bild im IFF, JPEG oder GIF-Format\n\
oder auch ein Papierbild oder Dia sein.",ADRESSE);
 janeinrequester(scratch2);
}

bool zeigebild(double ras,double dec,double sektor)
{
 //Foto anzeigen das mglichst genau dem angegebenen Sternausschnitt
 //entspricht. (sektor = Radius des Bildausschnitts)
 int ok=0,c;
 FILE *fp;
 static char zeile[N200],name[80],bestname[N200];
 double ra,de,se,diff,bestdiff=1000;
 sprintf(zeile,"%sbilder.liste",BILDPFAD);
 if(fp=fopen1(zeile,"r"))
   {while(getline(fp,zeile,120))
      {if((c= *zeile)=='.') break;
       if(c==';' || c=='\n' || c==0) continue;
       if(sscanf(zeile,"%s %lf %lf %lf",name,&ra,&de,&se)!=4)
	 {
#ifdef DEBUG
	  debugg("Syntaxfehler in 'bilder.liste':\n  '%.60s'",zeile);
#endif
	  continue;
	 }
       ra=abs(ra-ras); de=abs(de-dec);
       if(ra<se && de<se)
	 {diff = ra+de + abs(se-sektor); //provi.
	  if(diff<bestdiff)
	    {sprintf(bestname,"%s%s",BILDPFAD,name);
	     bestdiff=diff; ok=1;
	    }
	 }
      }
    fclose(fp);
    if(ok) {if(!showpic(bestname)) insterror("Datei '%s' fehlt!",bestname);}
   }
 else insterror("kann '%s' nicht finden",zeile);
 if(!ok && sektor!=0)
   {if(janeinrequester("Leider kein Bild von diesem Bereich vorhanden\n\
Wer schickt mir ein entsprechendes Foto ?","aha","ich")==0)
	dann_schick_es();
   }
 return ok;
}

bool objektbild(int ix,int iy,const char *name,double ra,double dec)
{
//Foto eines Objekts (z.B. Planet) zeigen
//Wenn nicht gefunden: Bild mit Zentrum auf Stern bei ho,az.
 int ok=0,vt;
 static char dateiname[N200];
 char dname[80];
 objektmarkieren(ix,iy);
 dateinamefilter(name,dname,80);
 sprintf(dateiname,"%s%s.iff",BILDPFAD,dname);
 if(!(ok=vorhanden(dateiname)))
   {sprintf(dateiname,"%s%s.jpg",BILDPFAD,dname);
    if(!(ok=vorhanden(dateiname)))
      {sprintf(dateiname,"%s%s.gif",BILDPFAD,dname);
       ok=vorhanden(dateiname);
   }  }
 if(ok) showpic(dateiname);
 else if(dec<=90.0) ok=zeigebild(ra,dec,0);
 if(!ok)
   {sprintf(scratch2,"Leider kein Bild von '%s' vorhanden\n\
Wer schickt mir ein entsprechendes Foto ?",name);
    if(janeinrequester(scratch2,"aha","ich")==0)
	dann_schick_es();
   }
 objektmarkieren(ix,iy,0);
 return ok;
}

int phasprozrunden(int proz1)
{
 int proz=100,n,d,best=100;
 FILE *fp;
 if(mondpos.zuab==ZUNEHMEND)
   fp=fopen(ZUPHASENTABELLE,"r");
 else
   fp=fopen(ABPHASENTABELLE,"r");
 if(fp)
   {while(fscanf(fp,"%d",&n)==1)
      if((d=abs(proz1-n))<best) {best=d; proz=n;}
    fclose(fp);
   }
 else proz=((proz1+5)/10)*10; //auf 10% runden
 return proz;
}

void zeigemondbild(int ix,int iy,char *bild)
{
 static char str[80];
 int phaseprozent=idfix(100*Mond.phase);
 for(int i=0;i<2;i++)
   {sprintf(str,"mond/%s%02d",
	    (mondpos.zuab==ZUNEHMEND)?"zu":"ab", phaseprozent);
    if(bildvorhanden(str)) {bild=str; break;}
    else phaseprozent=phasprozrunden(phaseprozent);
   }
 objektbild(ix,iy,bild);
}

/**************** Voreinstellungen laden, speichern *********************/
void voreinstellungen_load(char *name)
{
 char zeile[120],*key,*s1;
 int c;
#ifdef DEBUG
 printf("voreinstellungen_load(%s)\n",name);
#endif
 FILE *fp=fopen(name,"r");
 if(!fp) return;
 while(getline(fp,zeile,120))
   {
#ifdef DEBUG
    printf("'%s' ",zeile);
#endif
    for(s1=key=zeile;(c= *s1++) && c!=';';)
		if(c=='=') {*--s1=0; s1++; break;}
#ifdef DEBUG
    if(c==';') printf("\n"); else printf("key='%s' s1='%s'\n",key,s1);
#endif
    if(c!='=') continue;
    if(strcmp(key,"zeittakt")==0) {zeittakt.scan(s1);}
    else if(strcmp(key,"show_text")==0) {sprintf(show_text,"%.80s",s1);}
    else if(strcmp(key,"show_pict")==0) {sprintf(show_pict,"%.80s",s1);}
    else if(strcmp(key,"show_html")==0) {sprintf(show_html,"%.80s",s1);}
    else if(strcmp(key,"saturn_dlong")==0)
		sscanf(s1,"%lf",&provi.saturn_dlong);//provi.
    else if(strcmp(key,"grids")==0)
		{sscanf(s1,"%d",&grids); grids_menus_markieren();}
    else if(strcmp(key,"siluet")==0)	siluet_init(s1);
    else printf("unbekanntes Keywort: '%s'=%s\n",key,s1);
   }
 fclose(fp);
#ifdef DEBUG
 printf("voreinstellungen_load() fertig\n");
#endif
}
void voreinstellungen_save(char *name)
{
 FILE *fp=fopen(name,"w");
 if(!fp) return;
 fprintf(fp,";%s\n",VOREINSTDATEI);
 fprintf(fp,"zeittakt=%s\n",zeittakt.stri());
 fprintf(fp,"show_text=%s\n",show_text);
 fprintf(fp,"show_pict=%s\n",show_pict);
 fprintf(fp,"show_html=%s\n",show_html);
 fprintf(fp,"saturn_dlong=%.2lf  ;Grad\n",provi.saturn_dlong);//provi.
 if(grids!=GRID_OFF) fprintf(fp,"grids=%d\n",grids);
 if(siluet.isactiv)
   fprintf(fp,"siluet=%s\n",siluet_name);
 fclose(fp);
}

void animation_save(char *name)  //Szene speichern
{
 FILE *fp=fopen(name,"w");
 if(!fp) return;
 fprintf(fp,";Animationsdatei\n");
 fprintf(fp,"a_start=%.9lf\n",a_start);
 fprintf(fp,"a_end=%.9lf\n",a_end);
 fprintf(fp,"a_step=%.9lf\n",a_step);
 fprintf(fp,"anim_dt=%d\n",anim_dt);
 fprintf(fp,"refresh=%d\n",refresh);
 fprintf(fp,"uebertreib=%lf\n",uebertreib);
 if(sucheortskoord(ortsname)==0)
	fprintf(fp,"ortskoordinaten=%lf %lf\n",g_lambda,g_phi);
 else	fprintf(fp,"ortsname=\"%s\"\n",ortsname);
 if(!echtzeitflag)
   fprintf(fp,"zeit=%d.%d.%d %d:%02d:%02d\n",
	   zeit.tag,zeit.mon,zeit.jahr, zeit.std,zeit.min,zeit.sec);
 fclose(fp);
}
void animation_load(char *name)
{
 char zeile[120],*key,*s1;
 int c;
 FILE *fp=fopen(name,"r");
 if(!fp) return;
 while(getline(fp,zeile,120))
   {
    for(s1=key=zeile;(c= *s1++) && c!=';';)
		if(c=='=') {*--s1=0; s1++; break;}
    if(c!='=') continue;
    if(strcmp(key,"a_start")==0) sscanf(s1,"%lf",&a_start);
    else if(strcmp(key,"a_end")==0) sscanf(s1,"%lf",&a_end);
    else if(strcmp(key,"a_step")==0) sscanf(s1,"%lf",&a_step);
    else if(strcmp(key,"anim_dt")==0) sscanf(s1,"%d",&anim_dt);
    else if(strcmp(key,"refresh")==0) sscanf(s1,"%d",&refresh);
    else if(strcmp(key,"uebertreib")==0) sscanf(s1,"%lf",&uebertreib);
    else if(strcmp(key,"ortskoordinaten")==0)
       sscanf(s1,"%lf %lf",&g_lambda,&g_phi); //korr. 22.6.2019 (fehlende &)
    else if(strcmp(key,"ortsname")==0)
		{sscan_string(s1,ortsname);
		 if(sucheortskoord(ortsname)==0)
		   janeinrequester2("Ort '%s' nicht gefunden",ortsname);
		}
    else if(strcmp(key,"zeit")==0)
		{echtzeitflag=0;
		 sscanf(s1,"%d.%d.%d %d:%d:%d",&zeit.tag,&zeit.mon,
			&zeit.jahr,  &zeit.std,&zeit.min,&zeit.sec);
		 modjd=zeit.mjd();
		}
    else printf("unbekanntes Keywort: '%s'=%s\n",key,s1);
   }
 fclose(fp);
 zeichne_planetarium();
}

/************************ Pfaderweiterungen *****************************/
#ifdef unix
char *GetEnv(char *name)
{
 char str[80],*s,*t=getenv(name);
 int i;
 if(t==NULL)
   {for(i=1,s=str,t=name;++i<80 && *t;t++) *s++ = toupper(*t);
    *s=0;
    t=getenv(str);
   }
 return t;
}

class Pfadexpander
{
public:
 char *expand(char *pfad);
// Pfadexpander(); //wuerde vor main() gestartet, dort gesetztes
                   //setenv waere somit wirkungslos!
 void init();
};
//Pfadexpander::Pfadexpander()
void Pfadexpander::init()
{
 char *s;
 if((s=getenv("RAM"))==NULL || *s==0)
    setenv("RAM","/tmp",1);
 PLANETIUMPFAD=expand(PLANETIUMPFAD);
 VOREINSTDATEI=expand(VOREINSTDATEI);
#ifdef DEBUG
 printf("expand(%s) --> ",BILDPFAD);//test
#endif
 BILDPFAD=expand(BILDPFAD);
#ifdef DEBUG
 printf("'%s'\n",BILDPFAD);//test
#endif
 ZUPHASENTABELLE=expand(ZUPHASENTABELLE);
 ABPHASENTABELLE=expand(ABPHASENTABELLE);
 README=expand(README);
 README2=expand(README2);
 CPFAD=expand(CPFAD);
 for(int c=0,i=0;CPFAD[i]!=0;i++) {if(CPFAD[i]==':') CPFAD[i]=',';}
 TMP_EPHEMERIDEN=expand(TMP_EPHEMERIDEN);
 TMP_STDOUT=expand(TMP_STDOUT);
 USERDATA=expand(USERDATA);
}
char *Pfadexpander::expand(char *pfad)
{
 int c;
 char *str,*s,*p,*t;
 str=new char[strlen(pfad)+1];
 for(p=pfad,s=str;(c= *p++) && c!=':';)  *s++ = c;
 *s=0;
 if(c==':')
   {if((t=GetEnv(str))==NULL) t=".";
    delete str;
    str=new char[strlen(t)+strlen(p)+2];
    for(s=str;c= *t++;) *s++ = c;
    if(*p) *s++ = '/';
    while(*s++ = *p++) ;
   }
 return str;
}
static Pfadexpander pfadexpander;
void pfadexpand_init() {pfadexpander.init();}

#else /*unix*/

#ifdef AMIGA_PFADEXPAND
class Pfadexpander
{
public:
 char *expand(char *pfad);
 Pfadexpander();
};
Pfadexpander::Pfadexpander()
{
 CPFAD=expand(CPFAD);
}
char *Pfadexpander::expand(char *pfad)
{
 return "c:,Sys:Utilities,Sys:System,s:";//provi.
 diese Variante geht nicht weil system() nicht richtig geht.
 int c,i;
 const int max=1024;//provi.
 char zeile[80],*str,*s,*t,*ret=pfad;
 FILE *fp;
 printf("Pfadexpander::expand('%s')\n",pfad);//test
 if(strcmp(pfad,"c:")==0)
  {geht nicht:  system("path >ram:path.tmp");
   printf("fopen('ram:path.tmp','r')\n");//test
   fp=fopen("ram:path.tmp","r");
   if(!fp) {printf("konnte path.tmp nicht ffnen\n"); return pfad;}
   printf("fopen() erfolgreich\n");//test
   ret=str=new char[max];
   for(s=str,i=1;getline(fp,zeile,80) && i<max-80;)
     {if(strcmp(zeile,"Ram Disk:")==0) strcpy(zeile,"RAM:");
      else if(strcmp(zeile,"Aktuelles Verzeichnis")==0
	      || strcmp(zeile,"Current_directory")==0) *zeile=0;
      for(t=zeile;c= *t++;) {*s++ = c; i++;}
      *s++ = ','; i++;
     }
   *--s=0;
  }
 printf("CPFAD='%s'\n",ret);//test
 return ret;
}
static Pfadexpander pfadexpander;
#endif
#endif /*unix else*/

/*************************** Finsternisse *******************************/
static int finsternis=0;
static double finst_start=0,finst_end=0;
const int SOFI_PARTIELL=1, SOFI_TOTAL=2;

void finsternis_test(double rmond,double rsonne)
{
 if(!mondpos.sichtbar) {finsternis=0; return;}
 double abst=wizwistars(mondpos.ra*GRAD,mondpos.dec*GRAD,
			Sonne.ra*GRAD,Sonne.dec*GRAD)/GRAD;
 if(abst < rmond+rsonne)
  {if(abst+rsonne <= rmond)
     {if(finsternis!=SOFI_TOTAL)
	{finst_start=modjd;
	 finsternis=SOFI_TOTAL;
     }  }
   else
     {if(finsternis==SOFI_TOTAL)
	{char s1[80],s2[80];
	 finst_end=modjd;
	 Zeit z1(finst_start),z2(finst_end);
	 sprintf(scratch2,
		 "Start der Totalitt: %s\n Ende der Totalitt: %s",
		 z1.stri(s1),z2.stri(s2));//provi.
	 janeinrequester(scratch2);
        }
      finsternis=SOFI_PARTIELL;
     }
  }
 else finsternis=0;
}
char *finsternis_text()
{
 switch(finsternis)
   {case SOFI_TOTAL: return "Totale Sonnenfinsternis";
    CASE SOFI_PARTIELL: return "Partielle Sonnenfinsternis";
/*
"Halbschatten-Mondfinsternis"
"Kernschatten-Mondfinsternis"
"Totale Kernschatten-Mondfinsternis"
*/
   }
 return " ";
}


/****************** Berechnungen fr Mondfinsternis *********************/
class Erdschatten
{
 int r1,r2,r1h,r2h,ix,iy,ix2,iy2;
 double ra,dec,abst;
 double radius; //Radius des Kernschattens
 double radius2; //Radius des Halbschattens
 char *name;
public:
 int gezeichnetflag;
 double durchm,durchm2,ho,az,mag;
 Erdschatten() {gezeichnetflag=0; mag=0; name="Erdschatten";}
 void kreis(double x,double y,double du,double du2,int farbe);
 void zeichnen(double a,double rk,double rh,double ra0,double dec0);
 void loeschen();
};
static Erdschatten erdschatten;

void Erdschatten::kreis(double x,double y,double du,double du2,int farbe)
{
 koorduser2pix(x,y,&ix,&iy);
 deltakoorduser2pix(du,du,&r1,&r2); //Kernschatten
 color(farbe); idrawcircle(ix,iy,r1,r2);
 deltakoorduser2pix(du2,du2,&r1h,&r2h); //Halbschatten
 idrawcircle(ix,iy,r1h,r2h);
}

void Erdschatten::loeschen()
{
 color(0); idrawcircle(ix,iy,r1,r2);
 idrawcircle(ix,iy,r1h,r2h);
 gezeichnetflag=0;
}

void Erdschatten::zeichnen(double a,double rk,double rh,
			   double ra0,double dec0)
{ //abst,radius in Meter,  ra,dec in Grad
 int farbnr=PURPUR,ok;
 double x,y,r,du,du2;
 ra=ra0; dec=dec0; abst=a; radius=rk; radius2=rh;
 durchm=atan(radius/(abst*AE))*(2.0/GRAD);//Durchmesser in Grad
 durchm2=atan(radius2/(abst*AE))*(2.0/GRAD);//HalbschattenDurchmesser
 if(darart==HORIZONTAL)
  {equhor(dec,sternzeit-ra,phi,ho,az);//Liefert ho,az  alle Winkel in Grad
   if(printephem_flag==2) ausdrucken(name,az,ho,abst,durchm,mag);
   ok=haz2beoko(&x,&y,ho,az);
  }
 else //if(darart==EQUATORIAL)
   ok=radec2beoko(&x,&y,dec,ra);
 if(refresh>0 && gezeichnetflag) loeschen();
 if(ok)
   {du=durchm/2./beobachtradius*uebertreib;
    du2=durchm2/2./beobachtradius*uebertreib;
    kreis(x,y,du,du2,farbnr);
    //if(anschreibflag)
    //  {koorduser2pix(x+bx,y-hy/2,&ix2,&iy2); ischrift(ix2,iy2,name);
    //   gezeichnetflag=2;
    //  }
    //else
    gezeichnetflag=1;
    printf("%s gezeichnet\n",name);//debug
   }
 else printf("%s nicht sichtbar\n",name);//debug
}

void erdschatten_berechnen(double sabst,double tt,double teqx,
			   double x,double y,double z)
{
 double delta,dec,ra;
 double abstand=mondpos.entf*erdradius/AE, durchm,xh,h;
 double f=abstand/sabst;
 x*=f; y*=f; z*=f;
 if(mode=='A')
	{eclequ(tt,x,y,z); nutequ(tt,x,y,z);}
 else	{pmatecl(tt,teqx,amatrix);
	 //precart(amatrix,xp,yp,zp);//ueberfluessig
	 precart(amatrix,x,y,z); eclequ(teqx,x,y,z);
	}
 polar(x,y,z,delta,dec,ra); //berechnet delta,dec,ra (AE,Grad,Grad)
 printf("delta = %lf = %lf = Mondabstand\n",delta,abstand);//test

 double R=Sonne.radius,r=erdradius,A=sabst,a=abstand;//provi.
 // dec= -dec; ra+=180.0;
 // if(ra>=360.0) ra-=360.0;//test
 durchm=2*(r*(A+a)-R*a)/A;
 h=A*r/(R+r); xh=2*R*(a+h)/(A-h);
#ifdef DEBUG
 double test=2*(r-a*(R-r)/A);
 printf("durchm=%lf test=%lf\n",durchm,test);//test
 printf("sabst=%lf abstand=%lf\n",sabst,abstand);
 printf("Sonnendurchm=%lf Erddurchm=%lf\n",Sonne.radius*2,erdradius*2);
 printf("Erdschatten: ra=%lf dec=%lf xkernshaten=%lf xhalbshaten=%lf\n",
	ra,dec,durchm,xh);//test
#endif
 erdschatten.zeichnen(abstand,durchm/2,xh/2,ra,dec); //provi.
}

/************************** GitterLinien ********************************/
int menu_flag(long id,long *ids,int k,int max,char **text,int flag)
{
 int c; char* p=text[k];
 if(!(*ids)) {getmenuids(id,ids,max); if(!(*ids)) return -1;}
 if(*p!='%') return -2;
 c=p[1];
 p[1]=(flag)?toupper(c):tolower(c);
 changemenu(ids[k],p);
 return k;
}

void Siluet::alloc(int i)
{
 double *a,*h;
 a=new double[i];
 h=new double[i];
 if(n>0)
   {for(int j=0;j<n;j++) {a[j]=az[j]; h[j]=ho[j];}
    delete az; delete ho;
   }
 az=a; ho=h; n=i;
}

bool Siluet::init(char *name)
{
 int max=64,i,k;
 FILE *fp;
 if(!(fp=fopen(name,"r"))) false; //kein erfolg
 del();
 alloc(max);
 for(i=0;;)
   {k=fscanf(fp,"%lf %lf",&az[i],&ho[i]);
    if(k<2) break;
    if(ho[i]>=90.0) ho[i]=89.999;
    if(++i==max) alloc(max+=max);
   }
 imax=i;
 fclose(fp);
 isactiv=(imax>2);
//provi if(isactiv) linien_txt[2][1]=toupper(linien_txt[2][1]);
 return true;
}

void grids_punktxy(int flg,double x,double y,int ok,int farbnr)
{
 int ix,iy;
 static int flag=0;
 if(flg) flag=0;
 if(ok)
   {koorduser2pix(x,y,&ix,&iy);
    if(flag==1)
      {lineto(ix,iy);}
    else
      {ipunkt(ix,iy,farbnr); moveto(ix,iy); flag=1;}
   }
 else flag=0;
}
void grids_punkt(double ra,double dec,int farbnr)
{
 double h,az,x,y;
 int ok;
 if(darart==HORIZONTAL)
  {equhor(dec,sternzeit-ra,phi,h,az);//Liefert h,az  alle Winkel in Grad
   ok=haz2beoko(&x,&y,h,az);
  }
 else
   ok=radec2beoko(&x,&y,dec,ra);
 grids_punktxy(ra==0,x,y,ok,farbnr);
}
void grids_punkt(double az,int farbnr,double h=0)
{
 double x,y;
 int ok;
 if(darart==HORIZONTAL)
   ok=haz2beoko(&x,&y,h,az);
 else
   {double dec,ra;
    horequra(h,az,g_phi,dec,ra); //Liefert Werte nach dec,ra
    ok=radec2beoko(&x,&y,dec,ra);
   }
 grids_punktxy(az==0,x,y,ok,farbnr);
}

void grids_zeichnen(int clear)
{
 double ra,dec,az,phi,x,y,z,dd=beobachtradius/20.;
 double max=360+dd/2;
 if(grids&GRID_EQ)
   {int gridcol=(clear==0)?(GRUEN):0;
    for(ra=0,dec=0;ra<max;ra+=dd)
      grids_punkt(ra,dec,gridcol);
   }
 if(grids&GRID_HOR)
   {int gridcol=(clear==0)?(GRUEN):0;
    if(siluet.isactiv)
      for(int i=0;(az=siluet.getaz(i))<=360.0;i++)
	grids_punkt(az,gridcol,siluet.getho(i));
    else
      for(az=0;az<max;az+=dd)
	grids_punkt(az,gridcol);
   }
 if(grids&GRID_EKL)
   {double r,theta,phi2;
    double teqx=(mode=='B')?b1950:j2000;
    int gridcol=(clear==0)?(BLAUGRUEN):0;
    //REAL33 aa; pmatecl(0,teqx,aa); //calculate precession matrix
    for(phi=0;phi<max;phi+=dd)
      {x=cos(r=phi*GRAD); y=sin(r); z=0;
       //precart(aa,x,y,z); //Precession bercksichtigen
       eclequ(teqx,x,y,z);
       polar(x,y,z,r,dec,ra);
       grids_punkt(ra,dec,gridcol);
      }
   }
// if(grids&GRID_RA) {}//provi.
// if(grids&GRID_DEC) {}
}

bool siluet_init(char *nam)
{
 static char akt[40]="ja",neu[40]="nein";
 int c,ok;
 if(nam==NULL)
  {if(siluet_name[0]==0)
   {sprintf(siluet_name,"%s/horizontlinie.dat",getenv("PWD"));
    ok=nachfilenamefragen("lade Horizont-Datei",siluet_name,N200);
    if(ok) ok=siluet.init(siluet_name);
   }
   else
   {ok=requester_input(3,
		"   Horizont-Datei (Siluette)   ","%s","%s\n",&siluet_name,
		"alte Datei aktivieren (ja/nein)","%s","%s\n",&akt,
		"  neue Datei laden (ja/nein)   ","%s","%s\n",&neu);
    if(ok)
      {if(tolower(*neu)=='j')
	 {ok=nachfilenamefragen("lade Horizont-Datei",siluet_name,N200);
	  if(ok) ok=siluet.init(siluet_name);
	 }
       else ok=(tolower(*akt)=='j');
      }
   }
  }
 else
   {strcpy(siluet_name,nam); strcpy(akt,"ja"); ok=siluet.init(siluet_name);}
 siluet.isactiv=(ok)?true:false;
 return ok;
}

void grids_menus_markieren()
{
 if(grids&GRID_EKL) linien_txt[0][1]=toupper(linien_txt[0][1]);
 if(grids&GRID_EQ)  linien_txt[1][1]=toupper(linien_txt[1][1]);
 if(grids&GRID_HOR) linien_txt[2][1]=toupper(linien_txt[2][1]);
 if(grids&GRID_RA)  linien_txt[3][1]=toupper(linien_txt[3][1]);
 if(grids&GRID_DEC) linien_txt[4][1]=toupper(linien_txt[4][1]);
}

/**************************** Debugger **********************************/
#ifdef DEBUG

void m_debug1()
{
 int ok=requester_input(1,"alte beo-Umrechnung","%d","%d",&beokoflag);
}

static char str[1024];

void debugg1(char *s)
{
 static int flag=1; static char *rw="w";
 FILE *fp=fopen("df2:plan.debug",rw);
 if(fp)
   {fprintf(fp,s);
    fclose(fp);
   }
 printf(s);
 if(flag) {rw="a"; flag=0;}
}
void debugg(const char *s,long p1,long p2,long p3)
{
 sprintf(str,s,p1,p2,p3);
 debugg1(str);
}
void debugg(const char *s,double p1,double p2,double p3)
{
 sprintf(str,s,p1,p2,p3);
 debugg1(str);
}
void debugg(const char *s,int p1,int p2,int p3)
{
 sprintf(str,s,p1,p2,p3);
 debugg1(str);
}
void debugg6(const char *s,int p1,int p2,const char *s1,const char *s2,
	     double a,double b)
{
 sprintf(str,s,p1,p2,s1,s2,a,b);
 debugg1(str);
}
void debugg(const char *s,char *s1,double a,double b,double c)
{
 sprintf(str,s,s1,a,b,c);
 debugg1(str);
}
void debugg(const char *s,char *s1,char *s2,char *s3)
{
 sprintf(str,s,s1,s2,s3);
 debugg1(str);
}

#endif /*DEBUG*/
