/* kleinrech.cc			letzte nderung: 1.11.1997 */
#define VERSION "Version 0.0"
/*

 Kurzbeschreibung: einige kleine Berechnungen

History:
25.10.1997	Erstellung (RPf), Kometenhelligkeit
1.11.		Sterne ausmessen
*/

#include <stdio.h>

#ifndef GCC_VERSION
#define GCC_VERSION (__GNUC__ * 1000 + __GNUC_MINOR__)
#endif
#if GCC_VERSION>=3000
#include <iostream>
using namespace std;
#else
#include <stream.h>
#endif

#include <stdlib.h>
#include <math.h>
#include <ulong.h>

#ifndef PI
const double PI=4.0*atan(1.0);
#endif

/************************* Vordeklarationen ***************************/
//static char scratch[400];

void kometenhelligkeit();
void sterneausmessen();

/*************************** kleinkram ***************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 int wahl,ok;
 printf("kleinrech.cc %s\n",VERSION);
 printf("****************\n");
// printf(" 0  Hilfe\n");
 printf(" 1  Kometenhelligkeit\n");
 printf(" 2  Sterne ausmessen\n");
 if(argc>=2)
   {printf("bitte ohne Parameter aufrufen oder:\n");
    printf(" kleinrech <eingabe.dat >ausgabe.dat\n");
    return 0;
   }
 do {printf("Auswahl:"); scanf("%d",&wahl); ok=(wahl>=1 && wahl<=2);
     if(!ok) printf("bitte eine der obigen Zahlen eingeben!\n");
    }
 while(!ok);
 switch(wahl)
   {case 1: kometenhelligkeit();
    CASE 2: sterneausmessen();
   }
 return 0;
}/* ende von main */

void kometenhelligkeit()
{
 double m1,m2,re1,re2,rs1,rs2,n,h0;
 printf("Berechnung der Parameter fr Kometenhelligkeit\n");
 printf("erste Messung: Helligkeit:"); scanf("%lf",&m1);
 printf("erste Messung: Abstand zur Erde:"); scanf("%lf",&re1);
 printf("erste Messung: Abstand zur Sonne:"); scanf("%lf",&rs1);
 printf("zweite Messung: Helligkeit:"); scanf("%lf",&m2);
 printf("zweite Messung: Abstand zur Erde:"); scanf("%lf",&re2);
 printf("zweite Messung: Abstand zur Sonne:"); scanf("%lf",&rs2);
 n=(m2-m1-5*log10(re2/re1))/(2.5*log10(rs2/rs1));
 h0=m1-5*log10(re1)-2.5*n*log10(rs1);
 printf("H0=%.3lf n=%.3lf\n",h0,n);
}

class Zeiten
{
public:
 int vor,std,min;
 double sec,dmin;
 void split(double);
};
void Zeiten::split(double x)
{
 if(x<0.0) {vor='-'; x= -x;} else vor=' ';
 min=int(x/60);
 sec=x-60*min;
 std=min/60;
 min -= 60*std;
 dmin=min+sec/60;
}

void sterneausmessen()
{
 const double	sterntagfaktor=0.9972695664,
		GRAD=PI/180, //fr Umrechnung von Grad in Rad
		WISEC=360.0/24; //Umrech von Zeitsek in Winkelsek.
 double beodek,skaln,skalsec,wisecproskal,s,d,dra,ddec;
 double Mag[100],Ra[100],Dec[100],Mag0,Ra0,Dec0;
 int m,n,vondatei,i;
 char str[80],*st,name[80];
 Zeiten ra,dec;
 printf("fr Skala-Eichung:\n");
 printf("  Beobachtungs-Deklination in Grad:");
 do {*str=0; getline(stdin,str,80);} while(*str==0);
 st=str; if(vondatei=(*st=='B')) {st++; st++;}
 sscanf(st,"%lf",&beodek);
 printf("  gemessene Sternlauf-Zeit in Sekunden:"); scanf("%lf",&skalsec);
 printf("  Anzahl dabei berstrichener Skalateile:"); scanf("%lf",&skaln);
 wisecproskal=skalsec/skaln/sterntagfaktor*WISEC*cos(beodek*GRAD);
 printf("  --> 1 Skalateil = %.1lf ''\n",wisecproskal);
 if(!vondatei)
 {printf("Umrechnung von gemessenen Werten: (Abbruch mit 0 0)\n");
  printf("  Eingabebeispiel: 1:41.5  -12.5\n\
  (kam 1Min.41.5Sec nach Vergleichsstern und 12.5Skalenteile tiefer)\n");
 }
 if(vondatei) //Referenzstern einlesen
   {do {*str=0; getline(stdin,str,80);} while(*str==0);
    sscanf(str,"%s %d:%lf %d:%lf %lf",name,&m,&s,&n,&d,&Mag0);
    if(m<0)  Ra0=60*(m*60-s); else  Ra0=60*(m*60+s);
    if(n<0) Dec0=60*(n*60-d); else Dec0=60*(n*60+d);
   }
 for(n=0;;n++)
  {if(!vondatei) printf(" RA DEC: ");
   do {*str=0; getline(stdin,str,80);} while(*str==0);
   if(*str=='0' && str[1]==0 || str[1]==' ') break;
   if(vondatei) sscanf(str,"%s %d:%lf %lf %lf",name,&m,&s,&d,&Mag[n]);
   else		sscanf(str,"%d:%lf %lf",&m,&s,&d);
   if(m<0) dra=(m*60-s)/sterntagfaktor;
   else    dra=(m*60+s)/sterntagfaktor;
   ddec=d*wisecproskal;
   ra.split(dra); dec.split(ddec);
   if(vondatei) printf("%s",name);
   printf(" -->  RA = %c%d:%02d:%02.1lf   DEC = %c%d%02d'%02.1lf''\n",
	  ra.vor,ra.std,ra.min,ra.sec, dec.vor,dec.std,dec.min,dec.sec);
   Ra[n]=dra+Ra0;
   Dec[n]=ddec+Dec0;
  }
 printf("%d Objekte gemessen\n",n);
 if(vondatei)
   {ra.split(Ra0); dec.split(Dec0);
    printf("Referenz\t%c%d:%02.1lf\t%c%d:%02.1lf\t%.2lf\n",
	   ra.vor,ra.std,ra.dmin, dec.vor,dec.std,dec.dmin, Mag0);
   }
 for(i=0;i<n;i++)
   {ra.split(Ra[i]);
    dec.split(Dec[i]);
    printf("%c%d:%02.1lf\t%c%d:%02.1lf\t%.2lf\n",
	   ra.vor,ra.std,ra.dmin, dec.vor,dec.std,dec.dmin, Mag[i]);
   }
}

/* ende von kleinrech.cc */
