//pascal.h
#ifndef PASCAL_H
#define PASCAL_H
//#define TEST_ARRAY

#include <stdio.h>
#include <math.h>
#include <ulong.h>
#ifdef unix
#define trunc p_trunc
#define abs p_abs
#define quad p_quad
#endif

//typedef int bool;
//const int true=1,false=0;

typedef double REAL33[4][4];

#ifdef PI
#undef PI
#endif
const double PI=4*atan(1.0);
const double RAD=PI/180, ZWEIPI=2*PI;

inline double arctan(double x) {return atan(x);}
#ifndef _STDLIB_H_
inline int abs(int x) {return (x<0) ? -x : x;}
inline long abs(long x) {return (x<0) ? -x : x;}
#endif
inline double abs(double x) {return (x<0.0) ? -x : x;}
inline double sn(double x) {return sin(x*RAD);}
inline double cs(double x) {return cos(x*RAD);}
inline double tn(double x) {return tan(x*RAD);}
inline double asn(double x) {return asin(x)/RAD;}
inline double acs(double x) {return acos(x)/RAD;}
inline double atn(double x) {return atan(x)/RAD;}
inline double atn2(double x,double y) {return atan2(x,y)/RAD;}
inline long trunc(double x) {return long(x);}
inline long trunc(long x) {return x;}
inline double ln(double x) {return log(x);}

/** alte Variante: **
class ARRAYREAL
{
 double *a;
 int ug,og;
public:
 ARRAYREAL(int u,int o) {ug=u; og=o; a=new double[o-u+1];}
 ~ARRAYREAL() {delete a;}
 double& operator[](int n) {return a[n-ug];}
//mit Prfen der Grenzen:
// double& operator[](int n)
//	{if(n<ug || n>og) {printf("Error: Array out of bound\n"); n=ug;}
//	 return a[n-ug];
//	}
};
** :alt **/
/** neu: **/
class ARRAYREAL
{
 double *a;
 int ug,og;
public:
 ARRAYREAL() {a=NULL;}
 ARRAYREAL(int u,int o) {ug=u; og=o; a=new double[o-u+1];}
 ~ARRAYREAL() {if(a) delete a;}
 void init(int u,int o) {ug=u; og=o; if(a) delete a;  a=new double[o-u+1];}
#ifndef TEST_ARRAY
 double& operator[](int n) {return a[n-ug];}
#else
 double& operator[](int n)	//mit Prfen der Grenzen:
	{if(n<ug || n>og) {printf("Error: Array out of bound\n"); n=ug;}
	 return a[n-ug];
	}
#endif
};
/** :neu **/

inline void write(char *s) {printf("%s",s);}
inline void writeln() {putc('\n',stdout);}
inline void writeln(char *s) {printf("%s\n",s);}
void writeln(char *s,double x,int a,int b);

inline void readln(char& x) {char s[32]; scanf("%s",s); x= *s;}
inline void readln(int& x) {scanf("%d",&x);}
inline void readln(long& x) {scanf("%ld",&x);}
inline void readln(double& x) {scanf("%lf",&x);}
inline void readln(long& x,double& y) {scanf("%ld%*c%lf",&x,&y);}
inline void readln(double& x,double& y,double& z)
	{scanf("%lf%*c%lf%*c%lf",&x,&y,&z);}
inline void readln(long& a,long& b,double& x)
	{scanf("%ld%*c%ld%*c%lf",&a,&b,&x);}
inline void readln(long& a,long& b,double& x,double& y)
	{scanf("%ld%*c%ld%*c%lf%*c%lf",&a,&b,&x,&y);}
inline void readln(long& a,long& b,long& c)
	{scanf("%ld%*c%ld%*c%ld",&a,&b,&c);}
inline void readln(long& a,long& b,long& c,double& x)
	{scanf("%ld%*c%ld%*c%ld%*c%lf",&a,&b,&c,&x);}
#define read readln
inline void readln(FILE *f,double& x) {fscanf(f,"%lf",&x);}
inline void readln(FILE *f,long& a,long& b,double& x)
	{fscanf(f,"%ld%*c%ld%*c%lf",&a,&b,&x);}

bool in(int m,char* s);
#define until(x) while(!(x))

#endif /* PASCAL_H */
