//planets200.cc
#include "astro2.h"
const double p2=ZWEIPI;

/*************************************************************
/*  Klassendefinitionen fuer alle Planeten praktisch gleich  *
/*************************************************************/

class Merkur200
{
 //ARRAYREAL c1(-1,9),s1(-1,9), c(-5,0),s(-5,0);
 ARRAYREAL c1,s1, c,s;
 double m1,m2,m3,m5,m6;
 double u,v, dl,dr,db,t;
 int i;
 void term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs);
 void pertven();
 void pertear();
 void pertjup();
 void pertsat();
public:
 Merkur200()
	{c1.init(-1,9); s1.init(-1,9); c.init(-5,0); s.init(-5,0);}
 void start(double t0,double& l,double& b,double& r);
};

void Merkur200::term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs)
{
 if(it==0) addthe(c1[j],s1[j],c[i],s[i],u,v);
 else  {u *= t; v *= t;}
 dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v;
}

static Merkur200 merkur200;

void mer200(double t,double& l,double& b,double& r)
{
 merkur200.start(t,l,b,r);
}

class Venus200
{
 double c2[9],s2[9]; //ARRAYREAL c(-8,0),s(-8,0);
 ARRAYREAL c,s;
 double m1,m2,m3,m4,m5,m6;
 double u,v, dl,dr,db,t;
 int i;
 void term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs);
 void pertmer();
 void pertear();
 void pertmar();
 void pertjup();
 void pertsat();
public:
 Venus200() {c.init(-8,0); s.init(-8,0);}
 void start(double t0,double& l,double& b,double& r);
};

void Venus200::term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs)
{
 if(it==0) addthe(c2[j],s2[j],c[i],s[i],u,v);
 else  {u *= t; v *= t;}
 dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v;
}

static Venus200 venus200;

void ven200(double t,double& l,double& b,double& r)
{
 venus200.start(t,l,b,r);
}

class Mars200
{
 //ARRAYREAL c4(-2,16),s4(-2,16), c(-9,0),s(-9,0);
 ARRAYREAL c4,s4, c,s;
 double m2,m3,m4,m5,m6;
 double u,v, dl,dr,db,t;
 int i;
 void term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs);
 void pertven();
 void pertear();
 void pertjup();
 void pertsat();
public:
 Mars200()
	{c4.init(-2,16); s4.init(-2,16); c.init(-9,0); s.init(-9,0);}
 void start(double t0,double& l,double& b,double& r);
};

void Mars200::term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs)
{
 if(it==0) addthe(c4[j],s4[j],c[i],s[i],u,v);
 else  {u *= t; v *= t;}
 dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v;
}

static Mars200 mars200;

void mar200(double t,double& l,double& b,double& r)
{
 mars200.start(t,l,b,r);
}

class Jupiter200
{
 //ARRAYREAL c5(-1,5),s5(-1,5), c(-10,0),s(-10,0);
 ARRAYREAL c5,s5, c,s;
 double m5,m6,m7;
 double u,v, dl,dr,db,t;
 int i;
 void term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs);
 void pertsat();
 void pertura();
 void pertsur();
public:
 Jupiter200()
	{c5.init(-1,5); s5.init(-1,5); c.init(-10,0); s.init(-10,0);}
 void start(double t0,double& l,double& b,double& r);
};

void Jupiter200::term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs)
{
 if(it==0) addthe(c5[j],s5[j],c[i],s[i],u,v);
 else  {u *= t; v *= t;}
 dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v;
}

static Jupiter200 jupiter200;

void jup200(double t,double& l,double& b,double& r)
{
 jupiter200.start(t,l,b,r);
}

class Saturn200
{
 double c6[12],s6[12]; //ARRAYREAL c(-6,1),s(-6,1);
 ARRAYREAL c,s;
 double m5,m6,m7,m8;
 double u,v, dl,dr,db,t;
 int i;
 void term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs);
 void pertjup();
 void pertura();
 void pertnep();
 void pertjur();
public:
 Saturn200() {c.init(-6,1); s.init(-6,1);}
 void start(double t0,double& l,double& b,double& r);
};

void Saturn200::term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs)
{
 if(it==0) addthe(c6[j],s6[j],c[i],s[i],u,v);
 else  {u *= t; v *= t;}
 dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v;
}

static Saturn200 saturn200;

void sat200(double t,double& l,double& b,double& r)
{
 saturn200.start(t,l,b,r);
}

class Uranus200
{
 //ARRAYREAL c7(-2,7),s7(-2,7), c(-8,1),s(-8,1);
 ARRAYREAL c7,s7, c,s;
 double m5,m6,m7,m8;
 double u,v, dl,dr,db,t;
 int i;
 void term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs);
 void pertjup();
 void pertsat();
 void pertnep();
 void pertjsu();
public:
 Uranus200()
	{c7.init(-2,7); s7.init(-2,7); c.init(-8,1); s.init(-8,1);}
 void start(double t0,double& l,double& b,double& r);
};

void Uranus200::term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs)
{
 if(it==0) addthe(c7[j],s7[j],c[i],s[i],u,v);
 else  {u *= t; v *= t;}
 dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v;
}

static Uranus200 uranus200;

void ura200(double t,double& l,double& b,double& r)
{
 uranus200.start(t,l,b,r);
}

class Neptun200
{
 double c8[7],s8[7]; //ARRAYREAL c(-6,0),s(-6,0);
 ARRAYREAL c,s;
 double m5,m6,m7,m8;
 double u,v, dl,dr,db,t;
 int i;
 void term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs);
 void pertjup();
 void pertsat();
 void pertura();
public:
 Neptun200() {c.init(-6,0); s.init(-6,0);}
 void start(double t0,double& l,double& b,double& r);
};

void Neptun200::term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs)
{
 if(it==0) addthe(c8[j],s8[j],c[i],s[i],u,v);
 else  {u *= t; v *= t;}
 dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v;
}

static Neptun200 neptun200;

void nep200(double t,double& l,double& b,double& r)
{
 neptun200.start(t,l,b,r);
}

class Pluto200
{
 double c9[7],s9[7]; //ARRAYREAL c(-3,2),s(-3,2);
 ARRAYREAL c,s;
 double m5,m6,m9;
 double u,v, dl,dr,db,t;
 int i;
 void term(int j,int i,
	double dlc,double dls,double drc,double drs,double dbc,double dbs);
 void pertjup();
 void pertsat();
 void pertjus();
 void prec(double t0,double& l,double& b);
public:
 Pluto200() {c.init(-3,2); s.init(-3,2);}
 void start(double t0,double& l,double& b,double& r);
};

void Pluto200::term(int j,int i,
	double dlc,double dls,double drc,double drs,double dbc,double dbs)
{
 addthe(c9[j],s9[j],c[i],s[i],u,v);
 dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v;
}

static Pluto200 pluto200;

void plu200(double t,double& l,double& b,double& r)
{
 pluto200.start(t,l,b,r);
}

/*************************************************************
/*  Ende der Klassendefinitionen 			     *
/*************************************************************/

/*-----------------------------------------------------------------------*/
/* MER200: Mercury; ecliptic coordinates L,B,R (in deg and AU)           */
/*         equinox of date                                               */
/*         (T: time in Julian centuries since J2000)                     */
/*         (   = (JED-2451545.0)/36525             )                     */
/*-----------------------------------------------------------------------*/

void Merkur200::pertven()  /* Kepler terms and perturbations by Venus */
{
 int i;
 c[0] = 1.0; s[0] = 0.0;  c[-1] = cos(m2); s[-1] = -sin(m2);
 for(i = -1; i>= -4 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term( 1, 0,0, 259.74,84547.39,-78342.34, 0.01,11683.22,21203.79);
 term( 1, 0,1,   2.30,    5.04,    -7.52, 0.02,  138.55,  -71.01);
 term( 1, 0,2,   0.01,   -0.01,     0.01, 0.01,   -0.19,   -0.54);
 term( 2, 0,0,-549.71,10394.44, -7955.45, 0.00, 2390.29, 4306.79);
 term( 2, 0,1,  -4.77,    8.97,    -1.53, 0.00,   28.49,  -14.18);
 term( 2, 0,2,   0.00,    0.00,     0.00, 0.00,   -0.04,   -0.11);
 term( 3, 0,0,-234.04, 1748.74, -1212.86, 0.00,  535.41,  984.33);
 term( 3, 0,1,  -2.03,    3.48,    -0.35, 0.00,    6.56,   -2.91);
 term( 4, 0,0, -77.64,  332.63,  -219.23, 0.00,  124.40,  237.03);
 term( 4, 0,1,  -0.70,    1.10,    -0.08, 0.00,    1.59,   -0.59);
 term( 5, 0,0, -23.59,   67.28,   -43.54, 0.00,   29.44,   58.77);
 term( 5, 0,1,  -0.23,    0.32,    -0.02, 0.00,    0.39,   -0.11);
 term( 6, 0,0,  -6.86,   14.06,    -9.18, 0.00,    7.03,   14.84);
 term( 6, 0,1,  -0.07,    0.09,    -0.01, 0.00,    0.10,   -0.02);
 term( 7, 0,0,  -1.94,    2.98,    -2.02, 0.00,    1.69,    3.80);
 term( 8, 0,0,  -0.54,    0.63,    -0.46, 0.00,    0.41,    0.98);
 term( 9, 0,0,  -0.15,    0.13,    -0.11, 0.00,    0.10,    0.25);
 term(-1,-2,0,  -0.17,   -0.06,    -0.05, 0.14,   -0.06,   -0.07);
 term( 0,-1,0,   0.24,   -0.16,    -0.11,-0.16,    0.04,   -0.01);
 term( 0,-2,0,  -0.68,   -0.25,    -0.26, 0.73,   -0.16,   -0.18);
 term( 0,-5,0,   0.37,    0.08,     0.06,-0.28,    0.13,    0.12);
 term( 1,-1,0,   0.58,   -0.41,     0.26, 0.36,    0.01,   -0.01);
 term( 1,-2,0,  -3.51,   -1.23,     0.23,-0.63,   -0.05,   -0.06);
 term( 1,-3,0,   0.08,    0.53,    -0.11, 0.04,    0.02,   -0.09);
 term( 1,-5,0,   1.44,    0.31,     0.30,-1.39,    0.34,    0.29);
 term( 2,-1,0,   0.15,   -0.11,     0.09, 0.12,    0.02,   -0.04);
 term( 2,-2,0,  -1.99,   -0.68,     0.65,-1.91,   -0.20,    0.03);
 term( 2,-3,0,  -0.34,   -1.28,     0.97,-0.26,    0.03,    0.03);
 term( 2,-4,0,  -0.33,    0.35,    -0.13,-0.13,   -0.01,    0.00);
 term( 2,-5,0,   7.19,    1.56,    -0.05, 0.12,    0.06,    0.05);
 term( 3,-2,0,  -0.52,   -0.18,     0.13,-0.39,   -0.16,    0.03);
 term( 3,-3,0,  -0.11,   -0.42,     0.36,-0.10,   -0.05,   -0.05);
 term( 3,-4,0,  -0.19,    0.22,    -0.23,-0.20,   -0.01,    0.02);
 term( 3,-5,0,   2.77,    0.49,    -0.45, 2.56,    0.40,   -0.12);
 term( 4,-5,0,   0.67,    0.12,    -0.09, 0.47,    0.24,   -0.08);
 term( 5,-5,0,   0.18,    0.03,    -0.02, 0.12,    0.09,   -0.03);
}

void Merkur200::pertear()  /* perturbations by the Earth */
{
 int i;
 c[-1] = cos(m3); s[-1] = -sin(m3);
 for(i = -1; i>= -3 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term( 0,-4,0,  -0.11,   -0.07,    -0.08, 0.11,   -0.02,   -0.04);
 term( 1,-1,0,   0.10,   -0.20,     0.15, 0.07,    0.00,    0.00);
 term( 1,-2,0,  -0.35,    0.28,    -0.13,-0.17,   -0.01,    0.00);
 term( 1,-4,0,  -0.67,   -0.45,     0.00, 0.01,   -0.01,   -0.01);
 term( 2,-2,0,  -0.20,    0.16,    -0.16,-0.20,   -0.01,    0.02);
 term( 2,-3,0,   0.13,   -0.02,     0.02, 0.14,    0.01,    0.00);
 term( 2,-4,0,  -0.33,   -0.18,     0.17,-0.31,   -0.04,    0.00);
}

void Merkur200::pertjup()  /* perturbations by Jupiter */
{
 int i;
 c[-1] = cos(m5); s[-1] = -sin(m5);
 for(i = -1; i>= -2 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term(-1,-1,0,  -0.08,    0.16,     0.15, 0.08,   -0.04,    0.01);
 term(-1,-2,0,   0.10,   -0.06,    -0.07,-0.12,    0.07,   -0.01);
 term( 0,-1,0,  -0.31,    0.48,    -0.02, 0.13,   -0.03,   -0.02);
 term( 0,-2,0,   0.42,   -0.26,    -0.38,-0.50,    0.20,   -0.03);
 term( 1,-1,0,  -0.70,    0.01,    -0.02,-0.63,    0.00,    0.03);
 term( 1,-2,0,   2.61,   -1.97,     1.74, 2.32,    0.01,    0.01);
 term( 1,-3,0,   0.32,   -0.15,     0.13, 0.28,    0.00,    0.00);
 term( 2,-1,0,  -0.18,    0.01,     0.00,-0.13,   -0.03,    0.03);
 term( 2,-2,0,   0.75,   -0.56,     0.45, 0.60,    0.08,   -0.17);
 term( 3,-2,0,   0.20,   -0.15,     0.10, 0.14,    0.04,   -0.08);
}

void Merkur200::pertsat()  /* perturbations by Saturn */
{
 c[-2] = cos(2*m6); s[-2] = -sin(2*m6);
 term( 1,-2,0,  -0.19,    0.33,     0.00, 0.00,    0.00,    0.00);
}

void Merkur200::start(double t0,double& l,double& b,double& r)
{
 dl=dr=db=0.0; t=t0;
 m1 = p2*frac(0.4855407+415.2014314*t);
 m2 = p2*frac(0.1394222+162.5490444*t);
 m3 = p2*frac(0.9937861+ 99.9978139*t);
 m5 = p2*frac(0.0558417+  8.4298417*t);
 m6 = p2*frac(0.8823333+  3.3943333*t);
 c1[0] = 1.0;     s1[0] = 0.0;
 c1[1] = cos(m1); s1[1] = sin(m1);  c1[-1] = c1[1]; s1[-1] = -s1[1];
 for(i=2;i<=9;i++)  addthe(c1[i-1],s1[i-1],c1[1],s1[1],c1[i],s1[i]);
 pertven(); pertear(); pertjup(); pertsat();
 dl += 2.8+3.2*t;
 l = 360.0*frac(0.2151379 + m1/p2 + ((5601.7+1.1*t)*t+dl)/1296.0e3 );
 r = 0.3952829 + 0.0000016*t  +  dr*1.0e-6;
 b = ( -2522.15 + (-30.18 + 0.04*t) * t  +  db ) / 3600.0;
}   /* MER200 */

/*-----------------------------------------------------------------------*/
/* VEN200: Venus; ecliptic coordinates L,B,R (in deg and AU)             */
/*         equinox of date                                               */
/*         (T: time in Julian centuries since J2000)                     */
/*         (   = (JED-2451545.0)/36525             )                     */
/*-----------------------------------------------------------------------*/
void Venus200::pertmer()  /* perturbations by Mercury */
{
 c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m1); s[-1] = -sin(m1);
 addthe(c[-1],s[-1],c[-1],s[-1],c[-2],s[-2]);
 term(1,-1,0,   0.00,   0.00,    0.06, -0.09,   0.01,   0.00);
 term(2,-1,0,   0.25,  -0.09,   -0.09, -0.27,   0.00,   0.00);
 term(4,-2,0,  -0.07,  -0.08,   -0.14,  0.14,  -0.01,  -0.01);
 term(5,-2,0,  -0.35,   0.08,    0.02,  0.09,   0.00,   0.00);
}

void Venus200::pertear()  /* Kepler terms and perturbations by the Earth */
{
 int i;
 c[-1] = cos(m3); s[-1] = -sin(m3);
 for(i = -1; i>= -7 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term(1, 0,0,   2.37,2793.23,-4899.07,  0.11,9995.27,7027.22);
 term(1, 0,1,   0.10, -19.65,   34.40,  0.22,  64.95, -86.10);
 term(1, 0,2,   0.06,   0.04,   -0.07,  0.11,  -0.55,  -0.07);
 term(2, 0,0,-170.42,  73.13,  -16.59,  0.00,  67.71,  47.56);
 term(2, 0,1,   0.93,   2.91,    0.23,  0.00,  -0.03,  -0.92);
 term(3, 0,0,  -2.31,   0.90,   -0.08,  0.00,   0.04,   2.09);
 term(1,-1,0,  -2.38,  -4.27,    3.27, -1.82,   0.00,   0.00);
 term(1,-2,0,   0.09,   0.00,   -0.08,  0.05,  -0.02,  -0.25);
 term(2,-2,0,  -9.57,  -5.93,    8.57,-13.83,  -0.01,  -0.01);
 term(2,-3,0,  -2.47,  -2.40,    0.83, -0.95,   0.16,   0.24);
 term(3,-2,0,  -0.09,  -0.05,    0.08, -0.13,  -0.28,   0.12);
 term(3,-3,0,   7.12,   0.32,   -0.62, 13.76,  -0.07,   0.01);
 term(3,-4,0,  -0.65,  -0.17,    0.18, -0.73,   0.10,   0.05);
 term(3,-5,0,  -1.08,  -0.95,   -0.17,  0.22,  -0.03,  -0.03);
 term(4,-3,0,   0.06,   0.00,   -0.01,  0.08,   0.14,  -0.18);
 term(4,-4,0,   0.93,  -0.46,    1.06,  2.13,  -0.01,   0.01);
 term(4,-5,0,  -1.53,   0.38,   -0.64, -2.54,   0.27,   0.00);
 term(4,-6,0,  -0.17,  -0.05,    0.03, -0.11,   0.02,   0.00);
 term(5,-5,0,   0.18,  -0.28,    0.71,  0.47,  -0.02,   0.04);
 term(5,-6,0,   0.15,  -0.14,    0.30,  0.31,  -0.04,   0.03);
 term(5,-7,0,  -0.08,   0.02,   -0.03, -0.11,   0.01,   0.00);
 term(5,-8,0,  -0.23,   0.00,    0.01, -0.04,   0.00,   0.00);
 term(6,-6,0,   0.01,  -0.14,    0.39,  0.04,   0.00,  -0.01);
 term(6,-7,0,   0.02,  -0.05,    0.12,  0.04,  -0.01,   0.01);
 term(6,-8,0,   0.10,  -0.10,    0.19,  0.19,  -0.02,   0.02);
 term(7,-7,0,  -0.03,  -0.06,    0.18, -0.08,   0.00,   0.00);
 term(8,-8,0,  -0.03,  -0.02,    0.06, -0.08,   0.00,   0.00);
}

void Venus200::pertmar()  /* perturbations by Mars */
{
 int i;
 c[-1] = cos(m4); s[-1] = -sin(m4);
 for(i = -1; i>= -2 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term(1,-3,0,  -0.65,   1.02,   -0.04, -0.02,  -0.02,   0.00);
 term(2,-2,0,  -0.05,   0.04,   -0.09, -0.10,   0.00,   0.00);
 term(2,-3,0,  -0.50,   0.45,   -0.79, -0.89,   0.01,   0.03);
}

void Venus200::pertjup()  /* perturbations by Jupiter */
{
 int i;
 c[-1] = cos(m5); s[-1] = -sin(m5);
 for(i = -1; i>= -2 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term(0,-1,0,  -0.05,   1.56,    0.16,  0.04,  -0.08,  -0.04);
 term(1,-1,0,  -2.62,   1.40,   -2.35, -4.40,   0.02,   0.03);
 term(1,-2,0,  -0.47,  -0.08,    0.12, -0.76,   0.04,  -0.18);
 term(2,-2,0,  -0.73,  -0.51,    1.27, -1.82,  -0.01,   0.01);
 term(2,-3,0,  -0.14,  -0.10,    0.25, -0.34,   0.00,   0.00);
 term(3,-3,0,  -0.01,   0.04,   -0.11, -0.02,   0.00,   0.00);
}

void Venus200::pertsat()  /* perturbations by Saturn */
{
 c[-1] = cos(m6); s[-1] = -sin(m6);
 term(0,-1,0,   0.00,   0.21,    0.00,  0.00,   0.00,  -0.01);
 term(1,-1,0,  -0.11,  -0.14,    0.24, -0.20,   0.01,   0.00);
}

void Venus200::start(double t0,double& l,double& b,double& r)
{
 dl=dr=db=0.0; t=t0;
 m1 = p2*frac(0.4861431+415.2018375*t);
 m2 = p2*frac(0.1400197+162.5494552*t);
 m3 = p2*frac(0.9944153+ 99.9982208*t);
 m4 = p2*frac(0.0556297+ 53.1674631*t);
 m5 = p2*frac(0.0567028+  8.4305083*t);
 m6 = p2*frac(0.8830539+  3.3947206*t);
 c2[0] = 1.0; s2[0] = 0.0; c2[1] = cos(m2); s2[1] = sin(m2);
 for(i=2;i<=8;i++)  addthe(c2[i-1],s2[i-1],c2[1],s2[1],c2[i],s2[i]);
 pertmer(); pertear(); pertmar(); pertjup(); pertsat();
 dl += 2.74*sin(p2*(0.0764+0.4174*t))
	+ 0.27*sin(p2*(0.9201+0.3307*t));
 dl += 1.9+1.8*t;
 l = 360.0*frac(0.3654783 + m2/p2 + ((5071.2+1.1*t)*t+dl)/1296.0e3 );
 r = 0.7233482 - 0.0000002*t  +  dr*1.0e-6;
 b = ( -67.70 + ( 0.04 + 0.01*t) * t  +  db ) / 3600.0;
}   /* VEN200 */

/*-----------------------------------------------------------------------*/
/* MAR200: Mars; ecliptic coordinates L,B,R (in deg and AU)              */
/*         equinox of date                                               */
/*         (T: time in Julian centuries since J2000)                     */
/*         (   = (JED-2451545.0)/36525             )                     */
/*-----------------------------------------------------------------------*/
void Mars200::pertven() /* perturbations by Venus */
{
 c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m2); s[-1] = -sin(m2);
 addthe(c[-1],s[-1],c[-1],s[-1],c[-2],s[-2]);
 term( 0,-1,0, -0.01,   -0.03,      0.10, -0.04,    0.00,   0.00);
 term( 1,-1,0,  0.05,    0.10,     -2.08,  0.75,    0.00,   0.00);
 term( 2,-1,0, -0.25,   -0.57,     -2.58,  1.18,    0.05,  -0.04);
 term( 2,-2,0,  0.02,    0.02,      0.13, -0.14,    0.00,   0.00);
 term( 3,-1,0,  3.41,    5.38,      1.87, -1.15,    0.01,  -0.01);
 term( 3,-2,0,  0.02,    0.02,      0.11, -0.13,    0.00,   0.00);
 term( 4,-1,0,  0.32,    0.49,     -1.88,  1.21,   -0.07,   0.07);
 term( 4,-2,0,  0.03,    0.03,      0.12, -0.14,    0.00,   0.00);
 term( 5,-1,0,  0.04,    0.06,     -0.17,  0.11,   -0.01,   0.01);
 term( 5,-2,0,  0.11,    0.09,      0.35, -0.43,   -0.01,   0.01);
 term( 6,-2,0, -0.36,   -0.28,     -0.20,  0.25,    0.00,   0.00);
 term( 7,-2,0, -0.03,   -0.03,      0.11, -0.13,    0.00,  -0.01);
}

void Mars200::pertear()  /* Kepler terms and perturbations by the Earth */
{
 int i;
 c[-1] = cos(m3); s[-1] = -sin(m3);
 for( i = -1 ;i>= -8 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term( 1, 0,0, -5.32,38481.97,-141856.04,  0.40,-6321.67,1876.89);
 term( 1, 0,1, -1.12,   37.98,   -138.67, -2.93,   37.28, 117.48);
 term( 1, 0,2, -0.32,   -0.03,      0.12, -1.19,    1.04,  -0.40);
 term( 2, 0,0, 28.28, 2285.80,  -6608.37,  0.00, -589.35, 174.81);
 term( 2, 0,1,  1.64,    3.37,    -12.93,  0.00,    2.89,  11.10);
 term( 2, 0,2,  0.00,    0.00,      0.00,  0.00,    0.10,  -0.03);
 term( 3, 0,0,  5.31,  189.29,   -461.81,  0.00,  -61.98,  18.53);
 term( 3, 0,1,  0.31,    0.35,     -1.36,  0.00,    0.25,   1.19);
 term( 4, 0,0,  0.81,   17.96,    -38.26,  0.00,   -6.88,   2.08);
 term( 4, 0,1,  0.05,    0.04,     -0.15,  0.00,    0.02,   0.14);
 term( 5, 0,0,  0.11,    1.83,     -3.48,  0.00,   -0.79,   0.24);
 term( 6, 0,0,  0.02,    0.20,     -0.34,  0.00,   -0.09,   0.03);
 term(-1,-1,0,  0.09,    0.06,      0.14, -0.22,    0.02,  -0.02);
 term( 0,-1,0,  0.72,    0.49,      1.55, -2.31,    0.12,  -0.10);
 term( 1,-1,0,  7.00,    4.92,     13.93,-20.48,    0.08,  -0.13);
 term( 2,-1,0, 13.08,    4.89,     -4.53, 10.01,   -0.05,   0.13);
 term( 2,-2,0,  0.14,    0.05,     -0.48, -2.66,    0.01,   0.14);
 term( 3,-1,0,  1.38,    0.56,     -2.00,  4.85,   -0.01,   0.19);
 term( 3,-2,0, -6.85,    2.68,      8.38, 21.42,    0.00,   0.03);
 term( 3,-3,0, -0.08,    0.20,      1.20,  0.46,    0.00,   0.00);
 term( 4,-1,0,  0.16,    0.07,     -0.19,  0.47,   -0.01,   0.05);
 term( 4,-2,0, -4.41,    2.14,     -3.33, -7.21,   -0.07,  -0.09);
 term( 4,-3,0, -0.12,    0.33,      2.22,  0.72,   -0.03,  -0.02);
 term( 4,-4,0, -0.04,   -0.06,     -0.36,  0.23,    0.00,   0.00);
 term( 5,-2,0, -0.44,    0.21,     -0.70, -1.46,   -0.06,  -0.07);
 term( 5,-3,0,  0.48,   -2.60,     -7.25, -1.37,    0.00,   0.00);
 term( 5,-4,0, -0.09,   -0.12,     -0.66,  0.50,    0.00,   0.00);
 term( 5,-5,0,  0.03,    0.00,      0.01, -0.17,    0.00,   0.00);
 term( 6,-2,0, -0.05,    0.03,     -0.07, -0.15,   -0.01,  -0.01);
 term( 6,-3,0,  0.10,   -0.96,      2.36,  0.30,    0.04,   0.00);
 term( 6,-4,0, -0.17,   -0.20,     -1.09,  0.94,    0.02,  -0.02);
 term( 6,-5,0,  0.05,    0.00,      0.00, -0.30,    0.00,   0.00);
 term( 7,-3,0,  0.01,   -0.10,      0.32,  0.04,    0.02,   0.00);
 term( 7,-4,0,  0.86,    0.77,      1.86, -2.01,    0.01,  -0.01);
 term( 7,-5,0,  0.09,   -0.01,     -0.05, -0.44,    0.00,   0.00);
 term( 7,-6,0, -0.01,    0.02,      0.10,  0.08,    0.00,   0.00);
 term( 8,-4,0,  0.20,    0.16,     -0.53,  0.64,   -0.01,   0.02);
 term( 8,-5,0,  0.17,   -0.03,     -0.14, -0.84,    0.00,   0.01);
 term( 8,-6,0, -0.02,    0.03,      0.16,  0.09,    0.00,   0.00);
 term( 9,-5,0, -0.55,    0.15,      0.30,  1.10,    0.00,   0.00);
 term( 9,-6,0, -0.02,    0.04,      0.20,  0.10,    0.00,   0.00);
 term(10,-5,0, -0.09,    0.03,     -0.10, -0.33,    0.00,  -0.01);
 term(10,-6,0, -0.05,    0.11,      0.48,  0.21,   -0.01,   0.00);
 term(11,-6,0,  0.10,   -0.35,     -0.52, -0.15,    0.00,   0.00);
 term(11,-7,0, -0.01,   -0.02,     -0.10,  0.07,    0.00,   0.00);
 term(12,-6,0,  0.01,   -0.04,      0.18,  0.04,    0.01,   0.00);
 term(12,-7,0, -0.05,   -0.07,     -0.29,  0.20,    0.01,   0.00);
 term(13,-7,0,  0.23,    0.27,      0.25, -0.21,    0.00,   0.00);
 term(14,-7,0,  0.02,    0.03,     -0.10,  0.09,    0.00,   0.00);
 term(14,-8,0,  0.05,    0.01,      0.03, -0.23,    0.00,   0.03);
 term(15,-8,0, -1.53,    0.27,      0.06,  0.42,    0.00,   0.00);
 term(16,-8,0, -0.14,    0.02,     -0.10, -0.55,   -0.01,  -0.02);
 term(16,-9,0,  0.03,   -0.06,     -0.25, -0.11,    0.00,   0.00);
}

void Mars200::pertjup() /* perturbations by Jupiter */
{
 int i;
 c[-1] = cos(m5); s[-1] = -sin(m5);
 for( i = -1 ;i>= -4 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term(-2,-1,0,  0.05,    0.03,      0.08, -0.14,    0.01,  -0.01);
 term(-1,-1,0,  0.39,    0.27,      0.92, -1.50,   -0.03,  -0.06);
 term(-1,-2,0, -0.16,    0.03,      0.13,  0.67,   -0.01,   0.06);
 term(-1,-3,0, -0.02,    0.01,      0.05,  0.09,    0.00,   0.01);
 term( 0,-1,0,  3.56,    1.13,     -5.41, -7.18,   -0.25,  -0.24);
 term( 0,-2,0, -1.44,    0.25,      1.24,  7.96,    0.02,   0.31);
 term( 0,-3,0, -0.21,    0.11,      0.55,  1.04,    0.01,   0.05);
 term( 0,-4,0, -0.02,    0.02,      0.11,  0.11,    0.00,   0.01);
 term( 1,-1,0, 16.67,  -19.15,     61.00, 53.36,   -0.06,  -0.07);
 term( 1,-2,0,-21.64,    3.18,     -7.77,-54.64,   -0.31,   0.50);
 term( 1,-3,0, -2.82,    1.45,     -2.53, -5.73,    0.01,   0.07);
 term( 1,-4,0, -0.31,    0.28,     -0.34, -0.51,    0.00,   0.00);
 term( 2,-1,0,  2.15,   -2.29,      7.04,  6.94,    0.33,   0.19);
 term( 2,-2,0,-15.69,    3.31,    -15.70,-73.17,   -0.17,  -0.25);
 term( 2,-3,0, -1.73,    1.95,     -9.19, -7.20,    0.02,  -0.03);
 term( 2,-4,0, -0.01,    0.33,     -1.42,  0.08,    0.01,  -0.01);
 term( 2,-5,0,  0.03,    0.03,     -0.13,  0.12,    0.00,   0.00);
 term( 3,-1,0,  0.26,   -0.28,      0.73,  0.71,    0.08,   0.04);
 term( 3,-2,0, -2.06,    0.46,     -1.61, -6.72,   -0.13,  -0.25);
 term( 3,-3,0, -1.28,   -0.27,      2.21, -6.90,   -0.04,  -0.02);
 term( 3,-4,0, -0.22,    0.08,     -0.44, -1.25,    0.00,   0.01);
 term( 3,-5,0, -0.02,    0.03,     -0.15, -0.08,    0.00,   0.00);
 term( 4,-1,0,  0.03,   -0.03,      0.08,  0.08,    0.01,   0.01);
 term( 4,-2,0, -0.26,    0.06,     -0.17, -0.70,   -0.03,  -0.05);
 term( 4,-3,0, -0.20,   -0.05,      0.22, -0.79,   -0.01,  -0.02);
 term( 4,-4,0, -0.11,   -0.14,      0.93, -0.60,    0.00,   0.00);
 term( 4,-5,0, -0.04,   -0.02,      0.09, -0.23,    0.00,   0.00);
 term( 5,-4,0, -0.02,   -0.03,      0.13, -0.09,    0.00,   0.00);
 term( 5,-5,0,  0.00,   -0.03,      0.21,  0.01,    0.00,   0.00);
}

void Mars200::pertsat()  /* perturbations by Saturn */
{
 int i;
 c[-1] = cos(m6); s[-1] = -sin(m6);
 for( i = -1 ;i>= -3 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term(-1,-1,0,  0.03,    0.13,      0.48, -0.13,    0.02,   0.00);
 term( 0,-1,0,  0.27,    0.84,      0.40, -0.43,    0.01,  -0.01);
 term( 0,-2,0,  0.12,   -0.04,     -0.33, -0.55,   -0.01,  -0.02);
 term( 0,-3,0,  0.02,   -0.01,     -0.07, -0.08,    0.00,   0.00);
 term( 1,-1,0,  1.12,    0.76,     -2.66,  3.91,   -0.01,   0.01);
 term( 1,-2,0,  1.49,   -0.95,      3.07,  4.83,    0.04,  -0.05);
 term( 1,-3,0,  0.21,   -0.18,      0.55,  0.64,    0.00,   0.00);
 term( 2,-1,0,  0.12,    0.10,     -0.29,  0.34,   -0.01,   0.02);
 term( 2,-2,0,  0.51,   -0.36,      1.61,  2.25,    0.03,   0.01);
 term( 2,-3,0,  0.10,   -0.10,      0.50,  0.43,    0.00,   0.00);
 term( 2,-4,0,  0.01,   -0.02,      0.11,  0.05,    0.00,   0.00);
 term( 3,-2,0,  0.07,   -0.05,      0.16,  0.22,    0.01,   0.01);
}

void Mars200::start(double t0,double& l,double& b,double& r)
{
 dl=dr=db=0.0; t=t0;
 m2 = p2*frac(0.1382208+162.5482542*t);
 m3 = p2*frac(0.9926208+99.9970236*t);
 m4 = p2*frac(0.0538553+ 53.1662736*t);
 m5 = p2*frac(0.0548944+ 8.4290611*t);
 m6 = p2*frac(0.8811167+  3.3935250*t);
 c4[0] = 1.0; s4[0] = 0.0;  c4[1] = cos(m4); s4[1] = sin(m4);
 for(i=2;i<=16;i++)  addthe(c4[i-1],s4[i-1],c4[1],s4[1],c4[i],s4[i]);
 for(i= -2; i<= -1; i++)  {c4[i]=c4[-i]; s4[i]= -s4[-i];}
 pertven(); pertear(); pertjup(); pertsat();
 dl += 52.49*sin(p2*(0.1868+0.0549*t))
	+  0.61*sin(p2*(0.9220+0.3307*t))
	+  0.32*sin(p2*(0.4731+2.1485*t))
	+  0.28*sin(p2*(0.9467+0.1133*t));
 dl += 0.14+0.87*t-0.11*t*t;
 l = 360.0*frac(0.9334591 + m4/p2 + ((6615.5+1.1*t)*t+dl)/1296.0e3 );
 r = 1.5303352 + 0.0000131*t  +  dr*1.0e-6;
 b = ( 596.32 + (-2.92 - 0.10*t) * t  +  db ) / 3600.0;
}

/*-----------------------------------------------------------------------*/
/* JUP200: Jupiter; ecliptic coordinates L,B,R (in deg and AU)           */
/*         equinox of date                                               */
/*         T: time in Julian centuries since J2000                       */
/*            = (JED-2451545.0)/36525                                    */
/*-----------------------------------------------------------------------*/
void Jupiter200::pertsat()  /* Kepler terms and perturbations by Saturn */
{
 int i;
 c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m6); s[-1] = -sin(m6);
 for( i = -1 ;i>= -9 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term(-1, -1,0,  -0.2,    1.4,     2.0,   0.6,    0.1, -0.2);
 term( 0, -1,0,   9.4,    8.9,     3.9,  -8.3,   -0.4, -1.4);
 term( 0, -2,0,   5.6,   -3.0,    -5.4,  -5.7,   -2.0,  0.0);
 term( 0, -3,0,  -4.0,   -0.1,     0.0,   5.5,    0.0,  0.0);
 term( 0, -5,0,   3.3,   -1.6,    -1.6,  -3.1,   -0.5, -1.2);
 term( 1,  0,0,-113.1,19998.6,-25208.2,-142.2,-4670.7,288.9);
 term( 1,  0,1, -76.1,   66.9,   -84.2, -95.8,   21.6, 29.4);
 term( 1,  0,2,  -0.5,   -0.3,     0.4,  -0.7,    0.1, -0.1);
 term( 1, -1,0,  78.8,  -14.5,    11.5,  64.4,   -0.2,  0.2);
 term( 1, -2,0,  -2.0, -132.4,    28.8,   4.3,   -1.7,  0.4);
 term( 1, -2,1,  -1.1,   -0.7,     0.2,  -0.3,    0.0,  0.0);
 term( 1, -3,0,  -7.5,   -6.8,    -0.4,  -1.1,    0.6, -0.9);
 term( 1, -4,0,   0.7,    0.7,     0.6,  -1.1,    0.0, -0.2);
 term( 1, -5,0,  51.5,  -26.0,   -32.5, -64.4,   -4.9,-12.4);
 term( 1, -5,1,  -1.2,   -2.2,    -2.7,   1.5,   -0.4,  0.3);
 term( 2,  0,0,  -3.4,  632.0,  -610.6,  -6.5, -226.8, 12.7);
 term( 2,  0,1,  -4.2,    3.8,    -4.1,  -4.5,    0.2,  0.6);
 term( 2, -1,0,   5.3,   -0.7,     0.7,   6.1,    0.2,  1.1);
 term( 2, -2,0, -76.4, -185.1,   260.2,-108.0,    1.6,  0.0);
 term( 2, -3,0,  66.7,   47.8,   -51.4,  69.8,    0.9,  0.3);
 term( 2, -3,1,   0.6,   -1.0,     1.0,   0.6,    0.0,  0.0);
 term( 2, -4,0,  17.0,    1.4,    -1.8,   9.6,    0.0, -0.1);
 term( 2, -5,0,1066.2, -518.3,    -1.3, -23.9,    1.8, -0.3);
 term( 2, -5,1, -25.4,  -40.3,    -0.9,   0.3,    0.0,  0.0);
 term( 2, -5,2,  -0.7,    0.5,     0.0,   0.0,    0.0,  0.0);
 term( 3,  0,0,  -0.1,   28.0,   -22.1,  -0.2,  -12.5,  0.7);
 term( 3, -2,0,  -5.0,  -11.5,    11.7,  -5.4,    2.1, -1.0);
 term( 3, -3,0,  16.9,   -6.4,    13.4,  26.9,   -0.5,  0.8);
 term( 3, -4,0,   7.2,  -13.3,    20.9,  10.5,    0.1, -0.1);
 term( 3, -5,0,  68.5,  134.3,  -166.9,  86.5,    7.1, 15.2);
 term( 3, -5,1,   3.5,   -2.7,     3.4,   4.3,    0.5, -0.4);
 term( 3, -6,0,   0.6,    1.0,    -0.9,   0.5,    0.0,  0.0);
 term( 3, -7,0,  -1.1,    1.7,    -0.4,  -0.2,    0.0,  0.0);
 term( 4,  0,0,   0.0,    1.4,    -1.0,   0.0,   -0.6,  0.0);
 term( 4, -2,0,  -0.3,   -0.7,     0.4,  -0.2,    0.2, -0.1);
 term( 4, -3,0,   1.1,   -0.6,     0.9,   1.2,    0.1,  0.2);
 term( 4, -4,0,   3.2,    1.7,    -4.1,   5.8,    0.2,  0.1);
 term( 4, -5,0,   6.7,    8.7,    -9.3,   8.7,   -1.1,  1.6);
 term( 4, -6,0,   1.5,   -0.3,     0.6,   2.4,    0.0,  0.0);
 term( 4, -7,0,  -1.9,    2.3,    -3.2,  -2.7,    0.0, -0.1);
 term( 4, -8,0,   0.4,   -1.8,     1.9,   0.5,    0.0,  0.0);
 term( 4, -9,0,  -0.2,   -0.5,     0.3,  -0.1,    0.0,  0.0);
 term( 4,-10,0,  -8.6,   -6.8,    -0.4,   0.1,    0.0,  0.0);
 term( 4,-10,1,  -0.5,    0.6,     0.0,   0.0,    0.0,  0.0);
 term( 5, -5,0,  -0.1,    1.5,    -2.5,  -0.8,   -0.1,  0.1);
 term( 5, -6,0,   0.1,    0.8,    -1.6,   0.1,    0.0,  0.0);
 term( 5, -9,0,  -0.5,   -0.1,     0.1,  -0.8,    0.0,  0.0);
 term( 5,-10,0,   2.5,   -2.2,     2.8,   3.1,    0.1, -0.2);
}

void Jupiter200::pertura()  /* perturbations by Uranus */
{
 c[-1] = cos(m7); s[-1] = -sin(m7);
 addthe(c[-1],s[-1],c[-1],s[-1],c[-2],s[-2]);
 term( 1, -1,0,   0.4,    0.9,     0.0,   0.0,    0.0,  0.0);
 term( 1, -2,0,   0.4,    0.4,    -0.4,   0.3,    0.0,  0.0);
}

void Jupiter200::pertsur()  /* perturbations by Saturn and Uranus */
{
 double phi,x,y;
 phi = (2*m5-6*m6+3*m7); x = cos(phi); y = sin(phi);
 dl += 8.5*y-0.8*x; dr -= 0.1*x;
 addthe(x,y,c5[1],s5[1],x,y);
 dl += 0.4*x+0.5*y; dr += 0.5*y-0.7*x; db -= 0.1*x;
}

void Jupiter200::start(double t0,double& l,double& b,double& r)
{
 dl=dr=db=0.0; t=t0;
 m5 = p2*frac(0.0565314+8.4302963*t); m6 = p2*frac(0.8829867+3.3947688*t);
 m7 = p2*frac(0.3969537+1.1902586*t);
 c5[0] = 1.0;     s5[0] = 0.0;
 c5[1] = cos(m5); s5[1] = sin(m5);  c5[-1] = c5[1]; s5[-1] = -s5[1];
 for(i=2;i<=5;i++)  addthe(c5[i-1],s5[i-1],c5[1],s5[1],c5[i],s5[i]);
 pertsat(); pertura(); pertsur();
 l = 360.0*frac(0.0388910 + m5/p2 + ((5025.2+0.8*t)*t+dl)/1296.0e3 );
 r = 5.208873 + 0.000041*t  +  dr*1.0e-5;
 b = ( 227.3 - 0.3*t + db ) / 3600.0;
}   /* JUP200 */

/*-----------------------------------------------------------------------*/
/* SAT200: Saturn; ecliptic coordinates L,B,R (in deg and AU)            */
/*         equinox of date                                               */
/*         (T: time in Julian centuries since J2000)                     */
/*         (   = (JED-2451545.0)/36525             )                     */
/*-----------------------------------------------------------------------*/
void Saturn200::pertjup()  /* Kepler terms and perturbations by Jupiter */
{
 int i;
 c[0] = 1.0; s[0] = 0.0; c[1] = cos(m5); s[1] = sin(m5);
 for( i = 0 ;i>= -5 ;i--)  addthe(c[i],s[i],c[1],-s[1],c[i-1],s[i-1]);
 term( 0,-1,0,   12.0,   -1.4,   -13.9,    6.4,    1.2,  -1.8);
 term( 0,-2,0,    0.0,   -0.2,    -0.9,    1.0,    0.0,  -0.1);
 term( 1, 1,0,    0.9,    0.4,    -1.8,    1.9,    0.2,   0.2);
 term( 1, 0,0, -348.3,22907.7,-52915.5, -752.2,-3266.5,8314.4);
 term( 1, 0,1, -225.2, -146.2,   337.7, -521.3,   79.6,  17.4);
 term( 1, 0,2,    1.3,   -1.4,     3.2,    2.9,    0.1,  -0.4);
 term( 1,-1,0,   -1.0,  -30.7,   108.6, -815.0,   -3.6,  -9.3);
 term( 1,-2,0,   -2.0,   -2.7,    -2.1,  -11.9,   -0.1,  -0.4);
 term( 2, 1,0,    0.1,    0.2,    -1.0,    0.3,    0.0,   0.0);
 term( 2, 0,0,   44.2,  724.0, -1464.3,  -34.7, -188.7, 459.1);
 term( 2, 0,1,  -17.0,  -11.3,    18.9,  -28.6,    1.0,  -3.7);
 term( 2,-1,0,   -3.5, -426.6,  -546.5,  -26.5,   -1.6,  -2.7);
 term( 2,-1,1,    3.5,   -2.2,    -2.6,   -4.3,    0.0,   0.0);
 term( 2,-2,0,   10.5,  -30.9,  -130.5,  -52.3,   -1.9,   0.2);
 term( 2,-3,0,   -0.2,   -0.4,    -1.2,   -0.1,   -0.1,   0.0);
 term( 3, 0,0,    6.5,   30.5,   -61.1,    0.4,  -11.6,  28.1);
 term( 3, 0,1,   -1.2,   -0.7,     1.1,   -1.8,   -0.2,  -0.6);
 term( 3,-1,0,   29.0,  -40.2,    98.2,   45.3,    3.2,  -9.4);
 term( 3,-1,1,    0.6,    0.6,    -1.0,    1.3,    0.0,   0.0);
 term( 3,-2,0,  -27.0,  -21.1,   -68.5,    8.1,  -19.8,   5.4);
 term( 3,-2,1,    0.9,   -0.5,    -0.4,   -2.0,   -0.1,  -0.8);
 term( 3,-3,0,   -5.4,   -4.1,   -19.1,   26.2,   -0.1,  -0.1);
 term( 4, 0,0,    0.6,    1.4,    -3.0,   -0.2,   -0.6,   1.6);
 term( 4,-1,0,    1.5,   -2.5,    12.4,    4.7,    1.0,  -1.1);
 term( 4,-2,0, -821.9,   -9.6,   -26.0, 1873.6,  -70.5,  -4.4);
 term( 4,-2,1,    4.1,  -21.9,   -50.3,   -9.9,    0.7,  -3.0);
 term( 4,-3,0,   -2.0,   -4.7,   -19.3,    8.2,   -0.1,  -0.3);
 term( 4,-4,0,   -1.5,    1.3,     6.5,    7.3,    0.0,   0.0);
 term( 5,-2,0,-2627.6,-1277.3,   117.4, -344.1,  -13.8,  -4.3);
 term( 5,-2,1,   63.0,  -98.6,    12.7,    6.7,    0.1,  -0.2);
 term( 5,-2,2,    1.7,    1.2,    -0.2,    0.3,    0.0,   0.0);
 term( 5,-3,0,    0.4,   -3.6,   -11.3,   -1.6,    0.0,  -0.3);
 term( 5,-4,0,   -1.4,    0.3,     1.5,    6.3,   -0.1,   0.0);
 term( 5,-5,0,    0.3,    0.6,     3.0,   -1.7,    0.0,   0.0);
 term( 6,-2,0, -146.7,  -73.7,   166.4, -334.3,  -43.6, -46.7);
 term( 6,-2,1,    5.2,   -6.8,    15.1,   11.4,    1.7,  -1.0);
 term( 6,-3,0,    1.5,   -2.9,    -2.2,   -1.3,    0.1,  -0.1);
 term( 6,-4,0,   -0.7,   -0.2,    -0.7,    2.8,    0.0,   0.0);
 term( 6,-5,0,    0.0,    0.5,     2.5,   -0.1,    0.0,   0.0);
 term( 6,-6,0,    0.3,   -0.1,    -0.3,   -1.2,    0.0,   0.0);
 term( 7,-2,0,   -9.6,   -3.9,     9.6,  -18.6,   -4.7,  -5.3);
 term( 7,-2,1,    0.4,   -0.5,     1.0,    0.9,    0.3,  -0.1);
 term( 7,-3,0,    3.0,    5.3,     7.5,   -3.5,    0.0,   0.0);
 term( 7,-4,0,    0.2,    0.4,     1.6,   -1.3,    0.0,   0.0);
 term( 7,-5,0,   -0.1,    0.2,     1.0,    0.5,    0.0,   0.0);
 term( 7,-6,0,    0.2,    0.0,     0.2,   -1.0,    0.0,   0.0);
 term( 8,-2,0,   -0.7,   -0.2,     0.6,   -1.2,   -0.4,  -0.4);
 term( 8,-3,0,    0.5,    1.0,    -2.0,    1.5,    0.1,   0.2);
 term( 8,-4,0,    0.4,    1.3,     3.6,   -0.9,    0.0,  -0.1);
 term( 9,-4,0,    4.0,   -8.7,   -19.9,   -9.9,    0.2,  -0.4);
 term( 9,-4,1,    0.5,    0.3,     0.8,   -1.8,    0.0,   0.0);
 term(10,-4,0,   21.3,  -16.8,     3.3,    3.3,    0.2,  -0.2);
 term(10,-4,1,    1.0,    1.7,    -0.4,    0.4,    0.0,   0.0);
 term(11,-4,0,    1.6,   -1.3,     3.0,    3.7,    0.8,  -0.2);
}

void Saturn200::pertura()  /* perturbations by Uranus */
{
 int i;
 c[-1] = cos(m7); s[-1] = -sin(m7);
 for( i = -1 ;i>= -4 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term( 0,-1,0,    1.0,    0.7,     0.4,   -1.5,    0.1,   0.0);
 term( 0,-2,0,    0.0,   -0.4,    -1.1,    0.1,   -0.1,  -0.1);
 term( 0,-3,0,   -0.9,   -1.2,    -2.7,    2.1,   -0.5,  -0.3);
 term( 1,-1,0,    7.8,   -1.5,     2.3,   12.7,    0.0,   0.0);
 term( 1,-2,0,   -1.1,   -8.1,     5.2,   -0.3,   -0.3,  -0.3);
 term( 1,-3,0,  -16.4,  -21.0,    -2.1,    0.0,    0.4,   0.0);
 term( 2,-1,0,    0.6,   -0.1,     0.1,    1.2,    0.1,   0.0);
 term( 2,-2,0,   -4.9,  -11.7,    31.5,  -13.3,    0.0,  -0.2);
 term( 2,-3,0,   19.1,   10.0,   -22.1,   42.1,    0.1,  -1.1);
 term( 2,-4,0,    0.9,   -0.1,     0.1,    1.4,    0.0,   0.0);
 term( 3,-2,0,   -0.4,   -0.9,     1.7,   -0.8,    0.0,  -0.3);
 term( 3,-3,0,    2.3,    0.0,     1.0,    5.7,    0.3,   0.3);
 term( 3,-4,0,    0.3,   -0.7,     2.0,    0.7,    0.0,   0.0);
 term( 3,-5,0,   -0.1,   -0.4,     1.1,   -0.3,    0.0,   0.0);
}

void Saturn200::pertnep()  /* perturbations by Neptune */
{
 c[-1] = cos(m8); s[-1] = -sin(m8);
 addthe(c[-1],s[-1],c[-1],s[-1],c[-2],s[-2]);
 term( 1,-1,0,   -1.3,   -1.2,     2.3,   -2.5,    0.0,   0.0);
 term( 1,-2,0,    1.0,   -0.1,     0.1,    1.4,    0.0,   0.0);
 term( 2,-2,0,    1.1,   -0.1,     0.2,    3.3,    0.0,   0.0);
}

void Saturn200::pertjur()  /* perturbations by Jupiter and Uranus */
{
 double phi,x,y;
 phi = (-2*m5+5*m6-3*m7); x = cos(phi); y = sin(phi);
 dl -= 0.8*x+0.1*y; dr += 1.8*y-0.2*x; db += 0.3*x+0.5*y;
 addthe(x,y,c6[1],s6[1],x,y);
 dl += (2.4-0.7*t)*x+(27.8-0.4*t)*y; dr += 2.1*x-0.2*y;
 addthe(x,y,c6[1],s6[1],x,y);
 dl += 0.1*x+1.6*y; dr += 0.3*y-3.6*x; db += 0.6*y-0.2*x;
}

void Saturn200::start(double t0,double& l,double& b,double& r)
{
 dl=dr=db=0.0; t=t0;
 m5 = p2*frac(0.0565314+8.4302963*t); m6 = p2*frac(0.8829867+3.3947688*t);
 m7 = p2*frac(0.3969537+1.1902586*t); m8 = p2*frac(0.7208473+0.6068623*t);
 c6[0] = 1.0; s6[0] = 0.0;  c6[1] = cos(m6); s6[1] = sin(m6);
 for(i=2;i<=11;i++)  addthe(c6[i-1],s6[i-1],c6[1],s6[1],c6[i],s6[i]);
 pertjup(); pertura(); pertnep(); pertjur();
 l = 360.0*frac(0.2561136 + m6/p2 + ((5018.6+t*1.9)*t +dl)/1296.0e3 );
 r = 9.557584 - 0.000186*t  +  dr*1.0e-5;
 b = ( 175.1 - 10.2*t + db ) / 3600.0;
}   /* SAT200 */

/*-----------------------------------------------------------------------*/
/* URA200: Uranus; ecliptic coordinates L,B,R (in deg and AU)            */
/*         equinox of date                                               */
/*         (T: time in Julian centuries since J2000)                     */
/*         (   = (JED-2451545.0)/36525             )                     */
/*-----------------------------------------------------------------------*/
void Uranus200::pertjup()  /* perturbations by Jupiter */
{
 c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m5); s[-1] = -sin(m5);
 addthe(c[-1],s[-1],c[-1],s[-1],c[-2],s[-2]);
 term(-1,-1,0,  0.0,    0.0,    -0.1,   1.7,  -0.1,   0.0);
 term( 0,-1,0,  0.5,   -1.2,    18.9,   9.1,  -0.9,   0.1);
 term( 1,-1,0,-21.2,   48.7,  -455.5,-198.8,   0.0,   0.0);
 term( 1,-2,0, -0.5,    1.2,   -10.9,  -4.8,   0.0,   0.0);
 term( 2,-1,0, -1.3,    3.2,   -23.2, -11.1,   0.3,   0.1);
 term( 2,-2,0, -0.2,    0.2,     1.1,   1.5,   0.0,   0.0);
 term( 3,-1,0,  0.0,    0.2,    -1.8,   0.4,   0.0,   0.0);
}

void Uranus200::pertsat()  /* perturbations by Saturn */
{
 int i;
 c[-1] = cos(m6); s[-1] = -sin(m6);
 for( i = -1 ;i>= -3 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term( 0,-1,0,  1.4,   -0.5,    -6.4,   9.0,  -0.4,  -0.8);
 term( 1,-1,0,-18.6,  -12.6,    36.7,-336.8,   1.0,   0.3);
 term( 1,-2,0, -0.7,   -0.3,     0.5,  -7.5,   0.1,   0.0);
 term( 2,-1,0, 20.0, -141.6,  -587.1,-107.0,   3.1,  -0.8);
 term( 2,-1,1,  1.0,    1.4,     5.8,  -4.0,   0.0,   0.0);
 term( 2,-2,0,  1.6,   -3.8,   -35.6, -16.0,   0.0,   0.0);
 term( 3,-1,0, 75.3, -100.9,   128.9,  77.5,  -0.8,   0.1);
 term( 3,-1,1,  0.2,    1.8,    -1.9,   0.3,   0.0,   0.0);
 term( 3,-2,0,  2.3,   -1.3,    -9.5, -17.9,   0.0,   0.1);
 term( 3,-3,0, -0.7,   -0.5,    -4.9,   6.8,   0.0,   0.0);
 term( 4,-1,0,  3.4,   -5.0,    21.6,  14.3,  -0.8,  -0.5);
 term( 4,-2,0,  1.9,    0.1,     1.2, -12.1,   0.0,   0.0);
 term( 4,-3,0, -0.1,   -0.4,    -3.9,   1.2,   0.0,   0.0);
 term( 4,-4,0, -0.2,    0.1,     1.6,   1.8,   0.0,   0.0);
 term( 5,-1,0,  0.2,   -0.3,     1.0,   0.6,  -0.1,   0.0);
 term( 5,-2,0, -2.2,   -2.2,    -7.7,   8.5,   0.0,   0.0);
 term( 5,-3,0,  0.1,   -0.2,    -1.4,  -0.4,   0.0,   0.0);
 term( 5,-4,0, -0.1,    0.0,     0.1,   1.2,   0.0,   0.0);
 term( 6,-2,0, -0.2,   -0.6,     1.4,  -0.7,   0.0,   0.0);
}

void Uranus200::pertnep()  /* Kepler terms and perturbations by Neptune  */
{
 int i;
 c[-1] = cos(m8); s[-1] = -sin(m8);
 for( i = -1 ;i>= -7 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term( 1, 0,0,-78.1,19518.1,-90718.2,-334.7,2759.5,-311.9);
 term( 1, 0,1,-81.6,  107.7,  -497.4,-379.5,  -2.8, -43.7);
 term( 1, 0,2, -6.6,   -3.1,    14.4, -30.6,  -0.4,  -0.5);
 term( 1, 0,3,  0.0,   -0.5,     2.4,   0.0,   0.0,   0.0);
 term( 2, 0,0, -2.4,  586.1, -2145.2, -15.3, 130.6, -14.3);
 term( 2, 0,1, -4.5,    6.6,   -24.2, -17.8,   0.7,  -1.6);
 term( 2, 0,2, -0.4,    0.0,     0.1,  -1.4,   0.0,   0.0);
 term( 3, 0,0,  0.0,   24.5,   -76.2,  -0.6,   7.0,  -0.7);
 term( 3, 0,1, -0.2,    0.4,    -1.4,  -0.8,   0.1,  -0.1);
 term( 4, 0,0,  0.0,    1.1,    -3.0,   0.1,   0.4,   0.0);
 term(-1,-1,0, -0.2,    0.2,     0.7,   0.7,  -0.1,   0.0);
 term( 0,-1,0, -2.8,    2.5,     8.7,  10.5,  -0.4,  -0.1);
 term( 1,-1,0,-28.4,   20.3,   -51.4, -72.0,   0.0,   0.0);
 term( 1,-2,0, -0.6,   -0.1,     4.2, -14.6,   0.2,   0.4);
 term( 1,-3,0,  0.2,    0.5,     3.4,  -1.6,  -0.1,   0.1);
 term( 2,-1,0, -1.8,    1.3,    -5.5,  -7.7,   0.0,   0.3);
 term( 2,-2,0, 29.4,   10.2,   -29.0,  83.2,   0.0,   0.0);
 term( 2,-3,0,  8.8,   17.8,   -41.9,  21.5,  -0.1,  -0.3);
 term( 2,-4,0,  0.0,    0.1,    -2.1,  -0.9,   0.1,   0.0);
 term( 3,-2,0,  1.5,    0.5,    -1.7,   5.1,   0.1,  -0.2);
 term( 3,-3,0,  4.4,   14.6,   -84.3,  25.2,   0.1,  -0.1);
 term( 3,-4,0,  2.4,   -4.5,    12.0,   6.2,   0.0,   0.0);
 term( 3,-5,0,  2.9,   -0.9,     2.1,   6.2,   0.0,   0.0);
 term( 4,-3,0,  0.3,    1.0,    -4.0,   1.1,   0.1,  -0.1);
 term( 4,-4,0,  2.1,   -2.7,    17.9,  14.0,   0.0,   0.0);
 term( 4,-5,0,  3.0,   -0.4,     2.3,  17.6,  -0.1,  -0.1);
 term( 4,-6,0, -0.6,   -0.5,     1.1,  -1.6,   0.0,   0.0);
 term( 5,-4,0,  0.2,   -0.2,     1.0,   0.8,   0.0,   0.0);
 term( 5,-5,0, -0.9,   -0.1,     0.6,  -7.1,   0.0,   0.0);
 term( 5,-6,0, -0.5,   -0.6,     3.8,  -3.6,   0.0,   0.0);
 term( 5,-7,0,  0.0,   -0.5,     3.0,   0.1,   0.0,   0.0);
 term( 6,-6,0,  0.2,    0.3,    -2.7,   1.6,   0.0,   0.0);
 term( 6,-7,0, -0.1,    0.2,    -2.0,  -0.4,   0.0,   0.0);
 term( 7,-7,0,  0.1,   -0.2,     1.3,   0.5,   0.0,   0.0);
 term( 7,-8,0,  0.1,    0.0,     0.4,   0.9,   0.0,   0.0);
}

void Uranus200::pertjsu()  /* perturbations by Jupiter and Saturn */
{
 int i;
 c[-1] = cos(m6);         s[-1] = -sin(m6);
 c[-4] = cos(-4*m6+2*m5); s[-4] = sin(-4*m6+2*m5);
 for(i = -4; i>= -5 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term(-2,-4,0, -0.7,    0.4,    -1.5,  -2.5,   0.0,   0.0);
 term(-1,-4,0, -0.1,   -0.1,    -2.2,   1.0,   0.0,   0.0);
 term( 1,-5,0,  0.1,   -0.4,     1.4,   0.2,   0.0,   0.0);
 term( 1,-6,0,  0.4,    0.5,    -0.8,  -0.8,   0.0,   0.0);
 term( 2,-6,0,  5.7,    6.3,    28.5, -25.5,   0.0,   0.0);
 term( 2,-6,1,  0.1,   -0.2,    -1.1,  -0.6,   0.0,   0.0);
 term( 3,-6,0, -1.4,   29.2,   -11.4,   1.1,   0.0,   0.0);
 term( 3,-6,1,  0.8,   -0.4,     0.2,   0.3,   0.0,   0.0);
 term( 4,-6,0,  0.0,    1.3,    -6.0,  -0.1,   0.0,   0.0);
}

void Uranus200::start(double t0,double& l,double& b,double& r)
{
 dl=dr=db=0.0; t=t0;
 m5 = p2*frac(0.0564472+8.4302889*t); m6 = p2*frac(0.8829611+3.3947583*t);
 m7 = p2*frac(0.3967117+1.1902849*t); m8 = p2*frac(0.7216833+0.6068528*t);
 c7[0] = 1.0; s7[0] = 0.0; c7[1] = cos(m7); s7[1] = sin(m7);
 for(i=2;i<=7;i++)  addthe(c7[i-1],s7[i-1],c7[1],s7[1],c7[i],s7[i]);
 for(i=1;i<=2;i++)  {c7[-i] = c7[i]; s7[-i] = -s7[i];}
 pertjup(); pertsat(); pertnep(); pertjsu();
 l = 360.0*frac(0.4734843 + m7/p2 + ((5082.3+34.2*t)*t+dl)/1296.0e3 );
 r = 19.211991 + (-0.000333-0.000005*t)*t  +  dr*1.0e-5;
 b = (-130.61 + (-0.54+0.04*t)*t + db ) / 3600.0;
}   /* URA200 */

/*-----------------------------------------------------------------------*/
/* PLU200: Pluto; ecliptic coordinates L,B,R (in deg and AU)             */
/*         equinox of date; only valid between 1890 and 2100!!           */
/*         (T: time in Julian centuries since J2000)                     */
/*         (   = (JED-2451545.0)/36525             )                     */
/*-----------------------------------------------------------------------*/
void Pluto200::pertjup()  /* Kepler terms and perturbations by Jupiter */
{
 int i;
 c[0] = 1.0; s[0] = 0.0;  c[1] = cos(m5); s[1] = sin(m5);
 for( i = 0 ;i>= -1 ;i--)  addthe(c[i],s[i],c[1],-s[1],c[i-1],s[i-1]);
 addthe(c[1],s[1],c[1],s[1],c[2],s[2]);
 term(1, 0,   0.06,100924.08,-960396.0,15965.1,51987.68,-24288.76);
 term(2, 0,3274.74, 17835.12,-118252.2, 3632.4,12687.49, -6049.72);
 term(3, 0,1543.52,  4631.99, -21446.6, 1167.0, 3504.00, -1853.10);
 term(4, 0, 688.99,  1227.08,  -4823.4,  213.5, 1048.19,  -648.26);
 term(5, 0, 242.27,   415.93,  -1075.4,  140.6,  302.33,  -209.76);
 term(6, 0, 138.41,   110.91,   -308.8,  -55.3,  109.52,   -93.82);
 term(3,-1,  -0.99,     5.06,    -25.6,   19.8,    1.26,    -1.96);
 term(2,-1,   7.15,     5.61,    -96.7,   57.2,    1.64,    -2.16);
 term(1,-1,  10.79,    23.13,   -390.4,  236.4,   -0.33,     0.86);
 term(0, 1,  -0.23,     4.43,    102.8,   63.2,    3.15,     0.34);
 term(1, 1,  -1.10,    -0.92,     11.8,   -2.3,    0.43,     0.14);
 term(2, 1,   0.62,     0.84,      2.3,    0.7,    0.05,    -0.04);
 term(3, 1,  -0.38,    -0.45,      1.2,   -0.8,    0.04,     0.05);
 term(4, 1,   0.17,     0.25,      0.0,    0.2,   -0.01,    -0.01);
 term(3,-2,   0.06,     0.07,     -0.6,    0.3,    0.03,    -0.03);
 term(2,-2,   0.13,     0.20,     -2.2,    1.5,    0.03,    -0.07);
 term(1,-2,   0.32,     0.49,     -9.4,    5.7,   -0.01,     0.03);
 term(0,-2,  -0.04,    -0.07,      2.6,   -1.5,    0.07,    -0.02);
}

void Pluto200::pertsat()  /* perturbations by Saturn */
{
 int i;
 c[1] = cos(m6); s[1] = sin(m6);
 for( i = 0 ;i>= -1 ;i--)  addthe(c[i],s[i],c[1],-s[1],c[i-1],s[i-1]);
 term(1,-1, -29.47,    75.97,   -106.4, -204.9,  -40.71,   -17.55);
 term(0, 1, -13.88,    18.20,     42.6,  -46.1,    1.13,     0.43);
 term(1, 1,   5.81,   -23.48,     15.0,   -6.8,   -7.48,     3.07);
 term(2, 1, -10.27,    14.16,     -7.9,    0.4,    2.43,    -0.09);
 term(3, 1,   6.86,   -10.66,      7.3,   -0.3,   -2.25,     0.69);
 term(2,-2,   4.32,     2.00,      0.0,   -2.2,   -0.24,     0.12);
 term(1,-2,  -5.04,    -0.83,     -9.2,   -3.1,    0.79,    -0.24);
 term(0,-2,   4.25,     2.48,     -5.9,   -3.3,    0.58,     0.02);
}

void Pluto200::pertjus()  /* perturbations by Jupiter and Saturn */
{
 double phi,x,y;
 phi = (m5-m6); x = cos(phi); y = sin(phi);
 dl += 0.12*y-9.11*x; dr -= 3.4*x+3.3*y; db += 0.81*x+0.78*y;
 addthe(x,y,c9[1],s9[1],x,y);
 dl += 5.92*x+0.25*y; dr += 2.3*x-3.8*y; db -= 0.67*x+0.51*y;
}

void Pluto200::prec(double t,double& l,double& b)
{	/* precess. 1950->equinox of date */
 const double deg=180/PI; //57.2957795
 double d,ppi,pi,p,c1,s1,c2,s2,c3,s3,x,y,z;
 d = t+0.5; l /= deg; b /= deg;
 ppi = 3.044; pi = 2.28e-4*d; p = (0.0243764+5.39e-6*d)*d;
 c1 = cos(pi); c2 = cos(b); c3 = cos(ppi-l);
 s1 = sin(pi); s2 = sin(b); s3 = sin(ppi-l);
 x = c2*c3; y = c1*c2*s3-s1*s2; z = s1*c2*s3+c1*s2;
 b = deg * arctan( z / sqrt((1.0-z)*(1.0+z)) );
 if(x>0) l = 360.0*frac((ppi+p-arctan(y/x))/p2);
 else    l = 360.0*frac((ppi+p-arctan(y/x))/p2+0.5);
}

void Pluto200::start(double t0,double& l,double& b,double& r)
{
 dl=dr=db=0.0; t=t0;
 m5 = p2*frac(0.0565314+8.4302963*t); m6 = p2*frac(0.8829867+3.3947688*t);
 m9 = p2*frac(0.0385795+0.4026667*t);
 c9[0] = 1.0; s9[0] = 0.0;  c9[1] = cos(m9); s9[1] = sin(m9);
 for(i=2;i<=6;i++)  addthe(c9[i-1],s9[i-1],c9[1],s9[1],c9[i],s9[i]);
 pertjup(); pertsat(); pertjus();
 l = 360.0*frac( 0.6232469 + m9/p2 + dl/1296.0e3 );
 r = 40.7247248  +  dr * 1.0e-5;
 b = -3.909434  +  db / 3600.0;
 prec(t,l,b);
}   /* PLU200 */

/*-----------------------------------------------------------------------*/
/* NEP200: Neptune; ecliptic coordinates L,B,R (in deg and AU)           */
/*         equinox of date                                               */
/*         (T: time in Julian centuries since J2000)                     */
/*         (   = (JED-2451545.0)/36525             )                     */
/*-----------------------------------------------------------------------*/
void Neptun200::pertjup()  /* perturbations by Jupiter */
{
 c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m5); s[-1] = -sin(m5);
 addthe(c[-1],s[-1],c[-1],s[-1],c[-2],s[-2]);
 term(0,-1,0,  0.1,   0.1,    -3.0,   1.8,   -0.3, -0.3);
 term(1, 0,0,  0.0,   0.0,   -15.9,   9.0,    0.0,  0.0);
 term(1,-1,0,-17.6, -29.3,   416.1,-250.0,    0.0,  0.0);
 term(1,-2,0, -0.4,  -0.7,    10.4,  -6.2,    0.0,  0.0);
 term(2,-1,0, -0.2,  -0.4,     2.4,  -1.4,    0.4, -0.3);
}

void Neptun200::pertsat()  /* perturbations by Saturn */
{
 c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m6); s[-1] = -sin(m6);
 addthe(c[-1],s[-1],c[-1],s[-1],c[-2],s[-2]);
 term(0,-1,0, -0.1,   0.0,     0.2,  -1.8,   -0.1, -0.5);
 term(1, 0,0,  0.0,   0.0,    -8.3, -10.4,    0.0,  0.0);
 term(1,-1,0, 13.6, -12.7,   187.5, 201.1,    0.0,  0.0);
 term(1,-2,0,  0.4,  -0.4,     4.5,   4.5,    0.0,  0.0);
 term(2,-1,0,  0.4,  -0.1,     1.7,  -3.2,    0.2,  0.2);
 term(2,-2,0, -0.1,   0.0,    -0.2,   2.7,    0.0,  0.0);
}

void Neptun200::pertura()  /* Kepler terms and perturbations by Uranus */
{
 int i;
 c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m7); s[-1] = -sin(m7);
 for( i = -1 ;i>= -5 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term(1, 0,0, 32.3,3549.5,-25880.2, 235.8,-6360.5,374.0);
 term(1, 0,1, 31.2,  34.4,  -251.4, 227.4,   34.9, 29.3);
 term(1, 0,2, -1.4,   3.9,   -28.6, -10.1,    0.0, -0.9);
 term(2, 0,0,  6.1,  68.0,  -111.4,   2.0,  -54.7,  3.7);
 term(2, 0,1,  0.8,  -0.2,    -2.1,   2.0,   -0.2,  0.8);
 term(3, 0,0,  0.1,   1.0,    -0.7,   0.0,   -0.8,  0.1);
 term(0,-1,0, -0.1,  -0.3,    -3.6,   0.0,    0.0,  0.0);
 term(1, 0,0,  0.0,   0.0,     5.5,  -6.9,    0.1,  0.0);
 term(1,-1,0, -2.2,  -1.6,  -116.3, 163.6,    0.0, -0.1);
 term(1,-2,0,  0.2,   0.1,    -1.2,   0.4,    0.0, -0.1);
 term(2,-1,0,  4.2,  -1.1,    -4.4, -34.6,   -0.2,  0.1);
 term(2,-2,0,  8.6,  -2.9,   -33.4, -97.0,    0.2,  0.1);
 term(3,-1,0,  0.1,  -0.2,     2.1,  -1.2,    0.0,  0.1);
 term(3,-2,0, -4.6,   9.3,    38.2,  19.8,    0.1,  0.1);
 term(3,-3,0, -0.5,   1.7,    23.5,   7.0,    0.0,  0.0);
 term(4,-2,0,  0.2,   0.8,     3.3,  -1.5,   -0.2, -0.1);
 term(4,-3,0,  0.9,   1.7,    17.9,  -9.1,   -0.1,  0.0);
 term(4,-4,0, -0.4,  -0.4,    -6.2,   4.8,    0.0,  0.0);
 term(5,-3,0, -1.6,  -0.5,    -2.2,   7.0,    0.0,  0.0);
 term(5,-4,0, -0.4,  -0.1,    -0.7,   5.5,    0.0,  0.0);
 term(5,-5,0,  0.2,   0.0,     0.0,  -3.5,    0.0,  0.0);
 term(6,-4,0, -0.3,   0.2,     2.1,   2.7,    0.0,  0.0);
 term(6,-5,0,  0.1,  -0.1,    -1.4,  -1.4,    0.0,  0.0);
 term(6,-6,0, -0.1,   0.1,     1.4,   0.7,    0.0,  0.0);
}

void Neptun200::start(double t0,double& l,double& b,double& r)
{
 dl=dr=db=0.0; t=t0;
 m5 = p2*frac(0.0563867+8.4298907*t); m6 = p2*frac(0.8825086+3.3957748*t);
 m7 = p2*frac(0.3965358+1.1902851*t); m8 = p2*frac(0.7214906+0.6068526*t);
 c8[0] = 1.0; s8[0] = 0.0; c8[1] = cos(m8); s8[1] = sin(m8);
 for(i=2;i<=6;i++)  addthe(c8[i-1],s8[i-1],c8[1],s8[1],c8[i],s8[i]);
 pertjup(); pertsat(); pertura();
 l = 360.0*frac(0.1254046 + m8/p2 + ((4982.8-21.3*t)*t+dl)/1296.0e3 );
 r = 30.072984 + (0.001234+0.000003*t) * t  +  dr*1.0e-5;
 b = (  54.77 + ( 0.26 + 0.06*t) * t  +  db ) / 3600.0;
}   /* NEP200 */
