//planets203.cc
#include "astro2.h"
const double p2=ZWEIPI;

/*************************************************************
/*  Klassendefinitionen fuer alle Planeten praktisch gleich  *
/*************************************************************/

class Uranus200
{
 //ARRAYREAL c7(-2,7),s7(-2,7), c(-8,1),s(-8,1);
 ARRAYREAL c7,s7, c,s;
 double m5,m6,m7,m8;
 double u,v, dl,dr,db,t;
 int i;
 void term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs);
 void pertjup();
 void pertsat();
 void pertnep();
 void pertjsu();
public:
 Uranus200()
	{c7.init(-2,7); s7.init(-2,7); c.init(-8,1); s.init(-8,1);}
 void start(double t0,double& l,double& b,double& r);
};

void Uranus200::term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs)
{
 if(it==0) addthe(c7[j],s7[j],c[i],s[i],u,v);
 else  {u *= t; v *= t;}
 dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v;
}

static Uranus200 uranus200;

void ura200(double t,double& l,double& b,double& r)
{
 uranus200.start(t,l,b,r);
}

class Neptun200
{
 double c8[7],s8[7]; //ARRAYREAL c(-6,0),s(-6,0);
 ARRAYREAL c,s;
 double m5,m6,m7,m8;
 double u,v, dl,dr,db,t;
 int i;
 void term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs);
 void pertjup();
 void pertsat();
 void pertura();
public:
 Neptun200() {c.init(-6,0); s.init(-6,0);}
 void start(double t0,double& l,double& b,double& r);
};

void Neptun200::term(int j,int i,int it,
	double dlc,double dls,double drc,double drs,double dbc,double dbs)
{
 if(it==0) addthe(c8[j],s8[j],c[i],s[i],u,v);
 else  {u *= t; v *= t;}
 dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v;
}

static Neptun200 neptun200;

void nep200(double t,double& l,double& b,double& r)
{
 neptun200.start(t,l,b,r);
}

class Pluto200
{
 double c9[7],s9[7]; //ARRAYREAL c(-3,2),s(-3,2);
 ARRAYREAL c,s;
 double m5,m6,m9;
 double u,v, dl,dr,db,t;
 int i;
 void term(int j,int i,
	double dlc,double dls,double drc,double drs,double dbc,double dbs);
 void pertjup();
 void pertsat();
 void pertjus();
 void prec(double t0,double& l,double& b);
public:
 Pluto200() {c.init(-3,2); s.init(-3,2);}
 void start(double t0,double& l,double& b,double& r);
};

void Pluto200::term(int j,int i,
	double dlc,double dls,double drc,double drs,double dbc,double dbs)
{
 addthe(c9[j],s9[j],c[i],s[i],u,v);
 dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v;
}

static Pluto200 pluto200;

void plu200(double t,double& l,double& b,double& r)
{
 pluto200.start(t,l,b,r);
}

/*************************************************************
/*  Ende der Klassendefinitionen 			     *
/*************************************************************/

/*-----------------------------------------------------------------------*/
/* URA200: Uranus; ecliptic coordinates L,B,R (in deg and AU)            */
/*         equinox of date                                               */
/*         (T: time in Julian centuries since J2000)                     */
/*         (   = (JED-2451545.0)/36525             )                     */
/*-----------------------------------------------------------------------*/
void Uranus200::pertjup()  /* perturbations by Jupiter */
{
 c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m5); s[-1] = -sin(m5);
 addthe(c[-1],s[-1],c[-1],s[-1],c[-2],s[-2]);
 term(-1,-1,0,  0.0,    0.0,    -0.1,   1.7,  -0.1,   0.0);
 term( 0,-1,0,  0.5,   -1.2,    18.9,   9.1,  -0.9,   0.1);
 term( 1,-1,0,-21.2,   48.7,  -455.5,-198.8,   0.0,   0.0);
 term( 1,-2,0, -0.5,    1.2,   -10.9,  -4.8,   0.0,   0.0);
 term( 2,-1,0, -1.3,    3.2,   -23.2, -11.1,   0.3,   0.1);
 term( 2,-2,0, -0.2,    0.2,     1.1,   1.5,   0.0,   0.0);
 term( 3,-1,0,  0.0,    0.2,    -1.8,   0.4,   0.0,   0.0);
}

void Uranus200::pertsat()  /* perturbations by Saturn */
{
 int i;
 c[-1] = cos(m6); s[-1] = -sin(m6);
 for( i = -1 ;i>= -3 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term( 0,-1,0,  1.4,   -0.5,    -6.4,   9.0,  -0.4,  -0.8);
 term( 1,-1,0,-18.6,  -12.6,    36.7,-336.8,   1.0,   0.3);
 term( 1,-2,0, -0.7,   -0.3,     0.5,  -7.5,   0.1,   0.0);
 term( 2,-1,0, 20.0, -141.6,  -587.1,-107.0,   3.1,  -0.8);
 term( 2,-1,1,  1.0,    1.4,     5.8,  -4.0,   0.0,   0.0);
 term( 2,-2,0,  1.6,   -3.8,   -35.6, -16.0,   0.0,   0.0);
 term( 3,-1,0, 75.3, -100.9,   128.9,  77.5,  -0.8,   0.1);
 term( 3,-1,1,  0.2,    1.8,    -1.9,   0.3,   0.0,   0.0);
 term( 3,-2,0,  2.3,   -1.3,    -9.5, -17.9,   0.0,   0.1);
 term( 3,-3,0, -0.7,   -0.5,    -4.9,   6.8,   0.0,   0.0);
 term( 4,-1,0,  3.4,   -5.0,    21.6,  14.3,  -0.8,  -0.5);
 term( 4,-2,0,  1.9,    0.1,     1.2, -12.1,   0.0,   0.0);
 term( 4,-3,0, -0.1,   -0.4,    -3.9,   1.2,   0.0,   0.0);
 term( 4,-4,0, -0.2,    0.1,     1.6,   1.8,   0.0,   0.0);
 term( 5,-1,0,  0.2,   -0.3,     1.0,   0.6,  -0.1,   0.0);
 term( 5,-2,0, -2.2,   -2.2,    -7.7,   8.5,   0.0,   0.0);
 term( 5,-3,0,  0.1,   -0.2,    -1.4,  -0.4,   0.0,   0.0);
 term( 5,-4,0, -0.1,    0.0,     0.1,   1.2,   0.0,   0.0);
 term( 6,-2,0, -0.2,   -0.6,     1.4,  -0.7,   0.0,   0.0);
}

void Uranus200::pertnep()  /* Kepler terms and perturbations by Neptune  */
{
 int i;
 c[-1] = cos(m8); s[-1] = -sin(m8);
 for( i = -1 ;i>= -7 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term( 1, 0,0,-78.1,19518.1,-90718.2,-334.7,2759.5,-311.9);
 term( 1, 0,1,-81.6,  107.7,  -497.4,-379.5,  -2.8, -43.7);
 term( 1, 0,2, -6.6,   -3.1,    14.4, -30.6,  -0.4,  -0.5);
 term( 1, 0,3,  0.0,   -0.5,     2.4,   0.0,   0.0,   0.0);
 term( 2, 0,0, -2.4,  586.1, -2145.2, -15.3, 130.6, -14.3);
 term( 2, 0,1, -4.5,    6.6,   -24.2, -17.8,   0.7,  -1.6);
 term( 2, 0,2, -0.4,    0.0,     0.1,  -1.4,   0.0,   0.0);
 term( 3, 0,0,  0.0,   24.5,   -76.2,  -0.6,   7.0,  -0.7);
 term( 3, 0,1, -0.2,    0.4,    -1.4,  -0.8,   0.1,  -0.1);
 term( 4, 0,0,  0.0,    1.1,    -3.0,   0.1,   0.4,   0.0);
 term(-1,-1,0, -0.2,    0.2,     0.7,   0.7,  -0.1,   0.0);
 term( 0,-1,0, -2.8,    2.5,     8.7,  10.5,  -0.4,  -0.1);
 term( 1,-1,0,-28.4,   20.3,   -51.4, -72.0,   0.0,   0.0);
 term( 1,-2,0, -0.6,   -0.1,     4.2, -14.6,   0.2,   0.4);
 term( 1,-3,0,  0.2,    0.5,     3.4,  -1.6,  -0.1,   0.1);
 term( 2,-1,0, -1.8,    1.3,    -5.5,  -7.7,   0.0,   0.3);
 term( 2,-2,0, 29.4,   10.2,   -29.0,  83.2,   0.0,   0.0);
 term( 2,-3,0,  8.8,   17.8,   -41.9,  21.5,  -0.1,  -0.3);
 term( 2,-4,0,  0.0,    0.1,    -2.1,  -0.9,   0.1,   0.0);
 term( 3,-2,0,  1.5,    0.5,    -1.7,   5.1,   0.1,  -0.2);
 term( 3,-3,0,  4.4,   14.6,   -84.3,  25.2,   0.1,  -0.1);
 term( 3,-4,0,  2.4,   -4.5,    12.0,   6.2,   0.0,   0.0);
 term( 3,-5,0,  2.9,   -0.9,     2.1,   6.2,   0.0,   0.0);
 term( 4,-3,0,  0.3,    1.0,    -4.0,   1.1,   0.1,  -0.1);
 term( 4,-4,0,  2.1,   -2.7,    17.9,  14.0,   0.0,   0.0);
 term( 4,-5,0,  3.0,   -0.4,     2.3,  17.6,  -0.1,  -0.1);
 term( 4,-6,0, -0.6,   -0.5,     1.1,  -1.6,   0.0,   0.0);
 term( 5,-4,0,  0.2,   -0.2,     1.0,   0.8,   0.0,   0.0);
 term( 5,-5,0, -0.9,   -0.1,     0.6,  -7.1,   0.0,   0.0);
 term( 5,-6,0, -0.5,   -0.6,     3.8,  -3.6,   0.0,   0.0);
 term( 5,-7,0,  0.0,   -0.5,     3.0,   0.1,   0.0,   0.0);
 term( 6,-6,0,  0.2,    0.3,    -2.7,   1.6,   0.0,   0.0);
 term( 6,-7,0, -0.1,    0.2,    -2.0,  -0.4,   0.0,   0.0);
 term( 7,-7,0,  0.1,   -0.2,     1.3,   0.5,   0.0,   0.0);
 term( 7,-8,0,  0.1,    0.0,     0.4,   0.9,   0.0,   0.0);
}

void Uranus200::pertjsu()  /* perturbations by Jupiter and Saturn */
{
 int i;
 c[-1] = cos(m6);         s[-1] = -sin(m6);
 c[-4] = cos(-4*m6+2*m5); s[-4] = sin(-4*m6+2*m5);
 for(i = -4; i>= -5 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term(-2,-4,0, -0.7,    0.4,    -1.5,  -2.5,   0.0,   0.0);
 term(-1,-4,0, -0.1,   -0.1,    -2.2,   1.0,   0.0,   0.0);
 term( 1,-5,0,  0.1,   -0.4,     1.4,   0.2,   0.0,   0.0);
 term( 1,-6,0,  0.4,    0.5,    -0.8,  -0.8,   0.0,   0.0);
 term( 2,-6,0,  5.7,    6.3,    28.5, -25.5,   0.0,   0.0);
 term( 2,-6,1,  0.1,   -0.2,    -1.1,  -0.6,   0.0,   0.0);
 term( 3,-6,0, -1.4,   29.2,   -11.4,   1.1,   0.0,   0.0);
 term( 3,-6,1,  0.8,   -0.4,     0.2,   0.3,   0.0,   0.0);
 term( 4,-6,0,  0.0,    1.3,    -6.0,  -0.1,   0.0,   0.0);
}

void Uranus200::start(double t0,double& l,double& b,double& r)
{
 dl=dr=db=0.0; t=t0;
 m5 = p2*frac(0.0564472+8.4302889*t); m6 = p2*frac(0.8829611+3.3947583*t);
 m7 = p2*frac(0.3967117+1.1902849*t); m8 = p2*frac(0.7216833+0.6068528*t);
 c7[0] = 1.0; s7[0] = 0.0; c7[1] = cos(m7); s7[1] = sin(m7);
 for(i=2;i<=7;i++)  addthe(c7[i-1],s7[i-1],c7[1],s7[1],c7[i],s7[i]);
 for(i=1;i<=2;i++)  {c7[-i] = c7[i]; s7[-i] = -s7[i];}
 pertjup(); pertsat(); pertnep(); pertjsu();
 l = 360.0*frac(0.4734843 + m7/p2 + ((5082.3+34.2*t)*t+dl)/1296.0e3 );
 r = 19.211991 + (-0.000333-0.000005*t)*t  +  dr*1.0e-5;
 b = (-130.61 + (-0.54+0.04*t)*t + db ) / 3600.0;
}   /* URA200 */

/*-----------------------------------------------------------------------*/
/* PLU200: Pluto; ecliptic coordinates L,B,R (in deg and AU)             */
/*         equinox of date; only valid between 1890 and 2100!!           */
/*         (T: time in Julian centuries since J2000)                     */
/*         (   = (JED-2451545.0)/36525             )                     */
/*-----------------------------------------------------------------------*/
void Pluto200::pertjup()  /* Kepler terms and perturbations by Jupiter */
{
 int i;
 c[0] = 1.0; s[0] = 0.0;  c[1] = cos(m5); s[1] = sin(m5);
 for( i = 0 ;i>= -1 ;i--)  addthe(c[i],s[i],c[1],-s[1],c[i-1],s[i-1]);
 addthe(c[1],s[1],c[1],s[1],c[2],s[2]);
 term(1, 0,   0.06,100924.08,-960396.0,15965.1,51987.68,-24288.76);
 term(2, 0,3274.74, 17835.12,-118252.2, 3632.4,12687.49, -6049.72);
 term(3, 0,1543.52,  4631.99, -21446.6, 1167.0, 3504.00, -1853.10);
 term(4, 0, 688.99,  1227.08,  -4823.4,  213.5, 1048.19,  -648.26);
 term(5, 0, 242.27,   415.93,  -1075.4,  140.6,  302.33,  -209.76);
 term(6, 0, 138.41,   110.91,   -308.8,  -55.3,  109.52,   -93.82);
 term(3,-1,  -0.99,     5.06,    -25.6,   19.8,    1.26,    -1.96);
 term(2,-1,   7.15,     5.61,    -96.7,   57.2,    1.64,    -2.16);
 term(1,-1,  10.79,    23.13,   -390.4,  236.4,   -0.33,     0.86);
 term(0, 1,  -0.23,     4.43,    102.8,   63.2,    3.15,     0.34);
 term(1, 1,  -1.10,    -0.92,     11.8,   -2.3,    0.43,     0.14);
 term(2, 1,   0.62,     0.84,      2.3,    0.7,    0.05,    -0.04);
 term(3, 1,  -0.38,    -0.45,      1.2,   -0.8,    0.04,     0.05);
 term(4, 1,   0.17,     0.25,      0.0,    0.2,   -0.01,    -0.01);
 term(3,-2,   0.06,     0.07,     -0.6,    0.3,    0.03,    -0.03);
 term(2,-2,   0.13,     0.20,     -2.2,    1.5,    0.03,    -0.07);
 term(1,-2,   0.32,     0.49,     -9.4,    5.7,   -0.01,     0.03);
 term(0,-2,  -0.04,    -0.07,      2.6,   -1.5,    0.07,    -0.02);
}

void Pluto200::pertsat()  /* perturbations by Saturn */
{
 int i;
 c[1] = cos(m6); s[1] = sin(m6);
 for( i = 0 ;i>= -1 ;i--)  addthe(c[i],s[i],c[1],-s[1],c[i-1],s[i-1]);
 term(1,-1, -29.47,    75.97,   -106.4, -204.9,  -40.71,   -17.55);
 term(0, 1, -13.88,    18.20,     42.6,  -46.1,    1.13,     0.43);
 term(1, 1,   5.81,   -23.48,     15.0,   -6.8,   -7.48,     3.07);
 term(2, 1, -10.27,    14.16,     -7.9,    0.4,    2.43,    -0.09);
 term(3, 1,   6.86,   -10.66,      7.3,   -0.3,   -2.25,     0.69);
 term(2,-2,   4.32,     2.00,      0.0,   -2.2,   -0.24,     0.12);
 term(1,-2,  -5.04,    -0.83,     -9.2,   -3.1,    0.79,    -0.24);
 term(0,-2,   4.25,     2.48,     -5.9,   -3.3,    0.58,     0.02);
}

void Pluto200::pertjus()  /* perturbations by Jupiter and Saturn */
{
 double phi,x,y;
 phi = (m5-m6); x = cos(phi); y = sin(phi);
 dl += 0.12*y-9.11*x; dr -= 3.4*x+3.3*y; db += 0.81*x+0.78*y;
 addthe(x,y,c9[1],s9[1],x,y);
 dl += 5.92*x+0.25*y; dr += 2.3*x-3.8*y; db -= 0.67*x+0.51*y;
}

void Pluto200::prec(double t,double& l,double& b)
{	/* precess. 1950->equinox of date */
 const double deg=180/PI; //57.2957795
 double d,ppi,pi,p,c1,s1,c2,s2,c3,s3,x,y,z;
 d = t+0.5; l /= deg; b /= deg;
 ppi = 3.044; pi = 2.28e-4*d; p = (0.0243764+5.39e-6*d)*d;
 c1 = cos(pi); c2 = cos(b); c3 = cos(ppi-l);
 s1 = sin(pi); s2 = sin(b); s3 = sin(ppi-l);
 x = c2*c3; y = c1*c2*s3-s1*s2; z = s1*c2*s3+c1*s2;
 b = deg * arctan( z / sqrt((1.0-z)*(1.0+z)) );
 if(x>0) l = 360.0*frac((ppi+p-arctan(y/x))/p2);
 else    l = 360.0*frac((ppi+p-arctan(y/x))/p2+0.5);
}

void Pluto200::start(double t0,double& l,double& b,double& r)
{
 dl=dr=db=0.0; t=t0;
 m5 = p2*frac(0.0565314+8.4302963*t); m6 = p2*frac(0.8829867+3.3947688*t);
 m9 = p2*frac(0.0385795+0.4026667*t);
 c9[0] = 1.0; s9[0] = 0.0;  c9[1] = cos(m9); s9[1] = sin(m9);
 for(i=2;i<=6;i++)  addthe(c9[i-1],s9[i-1],c9[1],s9[1],c9[i],s9[i]);
 pertjup(); pertsat(); pertjus();
 l = 360.0*frac( 0.6232469 + m9/p2 + dl/1296.0e3 );
 r = 40.7247248  +  dr * 1.0e-5;
 b = -3.909434  +  db / 3600.0;
 prec(t,l,b);
}   /* PLU200 */

/*-----------------------------------------------------------------------*/
/* NEP200: Neptune; ecliptic coordinates L,B,R (in deg and AU)           */
/*         equinox of date                                               */
/*         (T: time in Julian centuries since J2000)                     */
/*         (   = (JED-2451545.0)/36525             )                     */
/*-----------------------------------------------------------------------*/
void Neptun200::pertjup()  /* perturbations by Jupiter */
{
 c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m5); s[-1] = -sin(m5);
 addthe(c[-1],s[-1],c[-1],s[-1],c[-2],s[-2]);
 term(0,-1,0,  0.1,   0.1,    -3.0,   1.8,   -0.3, -0.3);
 term(1, 0,0,  0.0,   0.0,   -15.9,   9.0,    0.0,  0.0);
 term(1,-1,0,-17.6, -29.3,   416.1,-250.0,    0.0,  0.0);
 term(1,-2,0, -0.4,  -0.7,    10.4,  -6.2,    0.0,  0.0);
 term(2,-1,0, -0.2,  -0.4,     2.4,  -1.4,    0.4, -0.3);
}

void Neptun200::pertsat()  /* perturbations by Saturn */
{
 c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m6); s[-1] = -sin(m6);
 addthe(c[-1],s[-1],c[-1],s[-1],c[-2],s[-2]);
 term(0,-1,0, -0.1,   0.0,     0.2,  -1.8,   -0.1, -0.5);
 term(1, 0,0,  0.0,   0.0,    -8.3, -10.4,    0.0,  0.0);
 term(1,-1,0, 13.6, -12.7,   187.5, 201.1,    0.0,  0.0);
 term(1,-2,0,  0.4,  -0.4,     4.5,   4.5,    0.0,  0.0);
 term(2,-1,0,  0.4,  -0.1,     1.7,  -3.2,    0.2,  0.2);
 term(2,-2,0, -0.1,   0.0,    -0.2,   2.7,    0.0,  0.0);
}

void Neptun200::pertura()  /* Kepler terms and perturbations by Uranus */
{
 int i;
 c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m7); s[-1] = -sin(m7);
 for( i = -1 ;i>= -5 ;i--)  addthe(c[i],s[i],c[-1],s[-1],c[i-1],s[i-1]);
 term(1, 0,0, 32.3,3549.5,-25880.2, 235.8,-6360.5,374.0);
 term(1, 0,1, 31.2,  34.4,  -251.4, 227.4,   34.9, 29.3);
 term(1, 0,2, -1.4,   3.9,   -28.6, -10.1,    0.0, -0.9);
 term(2, 0,0,  6.1,  68.0,  -111.4,   2.0,  -54.7,  3.7);
 term(2, 0,1,  0.8,  -0.2,    -2.1,   2.0,   -0.2,  0.8);
 term(3, 0,0,  0.1,   1.0,    -0.7,   0.0,   -0.8,  0.1);
 term(0,-1,0, -0.1,  -0.3,    -3.6,   0.0,    0.0,  0.0);
 term(1, 0,0,  0.0,   0.0,     5.5,  -6.9,    0.1,  0.0);
 term(1,-1,0, -2.2,  -1.6,  -116.3, 163.6,    0.0, -0.1);
 term(1,-2,0,  0.2,   0.1,    -1.2,   0.4,    0.0, -0.1);
 term(2,-1,0,  4.2,  -1.1,    -4.4, -34.6,   -0.2,  0.1);
 term(2,-2,0,  8.6,  -2.9,   -33.4, -97.0,    0.2,  0.1);
 term(3,-1,0,  0.1,  -0.2,     2.1,  -1.2,    0.0,  0.1);
 term(3,-2,0, -4.6,   9.3,    38.2,  19.8,    0.1,  0.1);
 term(3,-3,0, -0.5,   1.7,    23.5,   7.0,    0.0,  0.0);
 term(4,-2,0,  0.2,   0.8,     3.3,  -1.5,   -0.2, -0.1);
 term(4,-3,0,  0.9,   1.7,    17.9,  -9.1,   -0.1,  0.0);
 term(4,-4,0, -0.4,  -0.4,    -6.2,   4.8,    0.0,  0.0);
 term(5,-3,0, -1.6,  -0.5,    -2.2,   7.0,    0.0,  0.0);
 term(5,-4,0, -0.4,  -0.1,    -0.7,   5.5,    0.0,  0.0);
 term(5,-5,0,  0.2,   0.0,     0.0,  -3.5,    0.0,  0.0);
 term(6,-4,0, -0.3,   0.2,     2.1,   2.7,    0.0,  0.0);
 term(6,-5,0,  0.1,  -0.1,    -1.4,  -1.4,    0.0,  0.0);
 term(6,-6,0, -0.1,   0.1,     1.4,   0.7,    0.0,  0.0);
}

void Neptun200::start(double t0,double& l,double& b,double& r)
{
 dl=dr=db=0.0; t=t0;
 m5 = p2*frac(0.0563867+8.4298907*t); m6 = p2*frac(0.8825086+3.3957748*t);
 m7 = p2*frac(0.3965358+1.1902851*t); m8 = p2*frac(0.7214906+0.6068526*t);
 c8[0] = 1.0; s8[0] = 0.0; c8[1] = cos(m8); s8[1] = sin(m8);
 for(i=2;i<=6;i++)  addthe(c8[i-1],s8[i-1],c8[1],s8[1],c8[i],s8[i]);
 pertjup(); pertsat(); pertura();
 l = 360.0*frac(0.1254046 + m8/p2 + ((4982.8-21.3*t)*t+dl)/1296.0e3 );
 r = 30.072984 + (0.001234+0.000003*t) * t  +  dr*1.0e-5;
 b = (  54.77 + ( 0.26 + 0.06*t) * t  +  db ) / 3600.0;
}   /* NEP200 */
