/* universum.cc			letzte nderung: 1.9.1996 */
#define VERSION "Version 0.2"
/*
History:
10.8.1996	Erstellung (RPf)
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "universum.h"
#include "astro.h"

const double tropjahr=365.24219879;
//const double sidjahr=365.25636042;
//const double anomjahr=365.259626;
const double faktor=tropjahr/(tropjahr+1.0);

inline long JD(int t,int m,int y) {return long(jd(t,m,y)+0.5);}
static long datum_1_1_1992=JD(1,1,1992),
	    datum_6_7_1996=JD(6,7,1996);

long local2sternzeit(long zeit,long dat,int zeitzone,long ozeit)
{
 long sternzeit,n,ix;
 double t,t0,x;
 zeit+=zeitzone*3600;
 if(zeit<0) {zeit+=24*3600; dat--;}
 else if(zeit>24*3600) {zeit-=24*3600; dat++;}
 t=zeit/faktor;
 t0=(18*60+57)*60+1; //am 6.7.1996 0:00:00 war Sternzeit 18:57:01
 n=dat-datum_6_7_1996; x=n/faktor-n;
 ix=int(x); dat+=ix; x-=ix;
 t0+=x*24.0*3600.0;
 sternzeit=idfix(t0+t)-ozeit;
 if(sternzeit<0) {sternzeit+=24*3600; dat--;}
 else if(sternzeit>24*3600) {sternzeit-=24*3600; dat++;}
 return sternzeit;
}

char *t2s(long zeit)
{
 char *s=new char[16];
 int std,min,sec,sig;
 if(zeit<0) {sig=1; zeit = -zeit;} else sig=0;
 sec=zeit%60; zeit/=60;
 min=zeit%60; zeit/=60;
 std=zeit%24;
 if(sig) sprintf(s,"-%d:%02d:%02d",std,min,sec);
 else sprintf(s,"%2d:%02d:%02d",std,min,sec);
 return s;
}

char *d2s(long datum)  //datum als MJD
{
 char *s=new char[16];
 int tag,monat,jahr;
// datum_aus_tagedatum(datum,&tag,&monat,&jahr);
 double hour;
 caldat(datum,tag,monat,jahr,hour);
 sprintf(s,"%d.%d.%d",tag,monat,jahr);
 return s;
}

/** mjd() ist besser
//static int monatstage[]={0,31,28,31,30,31,30,31,31,30,31,30,31};
inline int ist_schaltjahr(int y) {return (y%4==0 && y%100!=0 || y%400==0);}

void datum_aus_tagedatum(long tage,int *tag,int *monat,int *jahr)
{
 static int monatstage[]={0,31,28,31,30,31,30,31,31,30,31,30,31};
 int j,t,m; long n;
 for(j=tage*100/36525;;)
   {n=j*365+j/4-j/100+j/400; j++;
    if(ist_schaltjahr(j)) t=366; else t=365;
    if(tage-n<=t) break;
   }
 *jahr=j-XVORCHRISTUS; tage-=n;
 monatstage[2] = ist_schaltjahr(j) ? 29 : 28;
 for(j=1;tage>(m=monatstage[j]);j++)  tage-=m;
 *monat=j;
 *tag=tage;
}

long tagedatum(int tag,int monat,int jahr)
{
 static int monatstage[]={0,31,28,31,30,31,30,31,31,30,31,30,31};
 jahr+=XVORCHRISTUS;//somit kann man bis 4801 vor Christus rechnen
 monatstage[2] = ist_schaltjahr(jahr) ? 29 : 28;
 jahr--;
 long tage = jahr*365+jahr/4-jahr/100+jahr/400 + tag;
 for(int i=1;i<monat;i++) tage+=monatstage[i];
 return tage;
}
**/

char *machgross(char *s)
{
 int c;
 char *s0=s;
 for(;c= *s;s++)
   if(islower(c)) *s=toupper(c);
 return s0;
}

/************ Julianisches Datum ***************/

double juldat(long datum,long ortszeit,int zeitzone)
{
//Julianisches Datum = Tage seit 4713 vor Christus
//mit Tageswechsel um 12:00 UT
// 1.Jan.-4712 12:00 = 1.0 JD
// 1.Jan.1992 0:00 = 2448622.5 JD
//17.Nov.1858 0:00 = 2400000.5 JD
 return 2448622.5 + datum - datum_1_1_1992
	+ (ortszeit+zeitzone*3600)/(3600.*24.);
}

/************ Koordinatenumrechnungen ***************/
void drehung(double x,double y,double w,double *px,double *py)
{
 //Punkt wird von x- gegen die y-Achse gedreht (=Gegenuhrzeigersinn)
 double sinw=sin(w),cosw=cos(w),xneu,yneu;
 xneu = x*cosw-y*sinw;
 yneu = x*sinw+y*cosw;
 *px = xneu;
 *py = yneu;
}

/**************** Winkel-Umrechnungen *****************/
char *rad2sdeg(double rad)
{
 char *s=new char[16];
 int grad,min,sec,vorzeichen;
 if(rad<0.) {vorzeichen=1; rad= -rad;} else vorzeichen=0;
 rad/=GRAD;
 grad=int(rad);
 rad=(rad-grad)*60.;
 min=int(rad);
 sec=int((rad-min)*60.+0.5);
 if(sec>=60) {sec=0; if(++min>=60) {min=0; grad++;}}
 grad %= 360; if(vorzeichen) grad = -grad;
 sprintf(s,"%3d%02d'%02d''",grad,min,sec);
 return s;
}
char *rad2shou(double rad)
{
 char *s=new char[16];
 int hour,min,sec,vorzeichen;
 if(rad<0.) {vorzeichen=1; rad= -rad;} else vorzeichen=0;
 rad*=24./ZWEIPI;
 hour=int(rad);
 rad=(rad-hour)*60.;
 min=int(rad);
 sec=int((rad-min)*60.+0.5);
 if(sec>=60) {sec=0; if(++min>=60) {min=0; hour++;}}
 hour %= 24; if(vorzeichen) hour = -hour;
 sprintf(s,"%3d:%02d:%02d",hour,min,sec);
 return s;
}

/**************** class Planet *****************/
void v_berechnen(double *vx,double *vy,
		 double vbetrag,double e,double a,double x,double y);
double nu_von_t(double M0,double dt,double *R,double U0,double a,double e);
double hoch3(double x) {return x*x*x;}

Planet::Planet(char *nam,double t,double m,double r,
		double M,double a,double e,double o,double O,double i,
		Planet *p)
{
 name=nam; t1=t0=t; masse=m; radius=r*1000.0;
 M1=M0=M*GRAD; aa=a; ee=e; omega=o*GRAD; Omega=O*GRAD; ii=i*GRAD;
 planet=p;
 sonnenmasse = (p) ? p->masse : SONNENMASSE;
 U=ZWEIPI*sqrt(hoch3(a*AE)/(sonnenmasse+masse)/Gravi)/TAGE; //Umlaufzeit
 double U2=ZWEIPI/kgravi*sqrt(a*a*a);//test: Nherungsformel
 printf("'%s' Umlaufzeit = %lf = %lf\n",name,U,U2);//test
}

void Planet::xyz(double t)
{
//Berechnung der Koordinaten x,y,z und des Geschwindigkeitsvektors vx,vy,vz
//	R = Abstand S-P (Sonne-Planet)
 double E=0,E0,	//exzentrische Anomalie
	q,		//kleinster Abstand von der Sonne (Periheldistanz)
	nu,		//Winkel zwischen q und S-P
	vbetrag;	//Geschwindigkeit
 double dt,w,a=aa*AE,PB2,b,h;
 if(a==0.) {x=y=z=0.; return;} //Spezialfall: Sonne
 int j=0;
 t1=t; dt=t1-t0;
 M1=M0+dt*ZWEIPI/U;
 DBUG("'%s'.xyz()  Testpunkte: dt=%lf M1=%lf GRAD\n",name,dt,M1/GRAD);
 if(M1>=ZWEIPI)		{h=M1/ZWEIPI; M1=(h-int(h))*ZWEIPI;}
 else if(M1<=(-ZWEIPI))	{h= -M1/ZWEIPI; M1=ZWEIPI-(h-int(h))*ZWEIPI;}
/** Formel aus Buch "Astrowissen": **/
 do {E=M1+ee*sin(E0=E);}
 while(E!=E0 && (++j<10 || (abs(E-E0)>1e-14 && j<=100)));
 if(j>100)
   printf("Fehler: E konvertiert nicht! E=%.15lg E0=%.15lg\n",E,E0);//test
//Im Buch fehlt in der folgenden Formel die Wurzel !
 nu=2*atan(sqrt((1+ee)/(1-ee))*tan(E/2));
 DBUG("Winkel zwischen q und S-P: nu=%lf GRAD\n",nu/GRAD);
 R = a*(1-ee*cos(E));
 DBUG("Abstand zur Sonne: R=%lf AE\n",R/AE);
/** :ende Formel aus Buch **/
/** alternative Formel liefert gleiche Resultate:
 nu=nu_von_t(M0,dt,&R,U,aa,ee);
 DBUG("nach neuer Formel: nu=%lf GRAD  R=%lf AE\n",nu/GRAD,R/AE);
**/
 vbetrag = sqrt(Gravi*sonnenmasse*(2/R-1/a));
 DBUG("|v|=%lf m/sec\n",vbetrag);
//wir definieren das Koordinatensystem so dass die grosse Ellipsenachse
//auf die y-Koordinate zu liegen kommt, und die x-Achse auf der Bahnebene
//liegt. Spter mssen wir dann um den Winkel w drehen um die x-Achse auf
//die Ekliptikebene zu bringen:
 w = 270.0*GRAD-omega;
 x=R*cos(nu-PIHALBE);
 y=R*sin(nu-PIHALBE);
 v_berechnen(&vx,&vy,vbetrag,ee,a,x,y);
//Koordinatensystem drehen um x-Achse auf Ekliptikebene zu bringen:
 drehung(vx,vy,-w,&vx,&vy);
 drehung(x,y,-w,&x,&y);
 z=0.; vz=0.;	//Koordinaten liegen immer noch auf Planetenbahnebene
 DBUG("nach 1. Drehung (%lf GRAD): x=%lf y=%lf z=%lf AE\n",
      w/GRAD,x/AE,y/AE,z/AE);
//Drehung um x-Achse so dass auch y-Achse auf Ekliptikebene
//zu liegen kommt:
 drehung(y,z,ii,&y,&z);
 drehung(vy,vz,ii,&vy,&vz);
 DBUG("nach 2. Drehung (%lf GRAD): x=%lf y=%lf z=%lf AE\n",
      ii/GRAD,x/AE,y/AE,z/AE);
 DBUG("Drehung um z-Achse %lf GRAD\n",Omega/GRAD);
//Drehung um z-Achse so dass x-Koordinate zum Frhlingspunkt zeigt:
 drehung(x,y,Omega,&x,&y);
 drehung(vx,vy,Omega,&vx,&vy);
 DBUG("nach 3. Drehung (%lf GRAD): x=%lf y=%lf z=%lf AE\n",
      Omega/GRAD,x/AE,y/AE,z/AE);
 DBUG("Geschwindigkeit: vx=%lf vy=%lf vz=%lf\n",vx,vy,vz);
 if(planet!=NULL)
   {x+=planet->x; y+=planet->y; z+=planet->z;
    vx+=planet->vx; vy+=planet->vy; vz+=planet->vz;
    DBUG("Mondpostion rel. zur Sonne: x=%lf y=%lf z=%lf AE\n",
	 x/AE,y/AE,z/AE);
   }
 if(debugflag) {printf("weiter mit RETURN"); getc(stdin); getc(stdin);}
}

void v_berechnen(double *vx,double *vy,
		 double vbetrag,double e,double a,double x,double y)
{
 double c=a*e, bdurcha=sqrt(1-e*e);
 double x1,y1,f1;
 x1=bdurcha*(c-y);
 y1=c+x/bdurcha;
 f1=vbetrag/sqrt(x1*x1+y1*y1);
 *vx = f1*x1;
 *vy = f1*y1;
}

/************ Rechnung nach neuer Formel (selbst hergeleitet) ***********/
static double U,alfa,nustrich,singamma,bdurcha,cc,ee;

double t_von_nu(double nu)
{
 if(nu>PI) return U-t_von_nu(ZWEIPI-nu);
 alfa=atan(bdurcha*tan(nu-PIHALBE));
 nustrich=PIHALBE+alfa;
 double beta=asin(ee*sin(PI-nustrich));
 double gamma=nustrich-beta;
 singamma=sin(gamma);
 return U/ZWEIPI*(gamma-ee*singamma);
}

int fastgleich(double t1,double t2)
{
 double dt=(t1+t2)*1e-14;
 return (t2<t1+dt && t2>t1-dt);
}

double nu_von_t(double M0,double dt,double *R,double U0,double a,double e)
{
 double nu,t,t2;
 U=U0;
 ee=e;
 cc=a*e;
 bdurcha=sqrt(1.0-e*e);
 t=U/ZWEIPI*M0+dt;
 long n=long(t/U);
 t-=n*U;
 int j=0;//test
 for(t2=nu=0.;!fastgleich(t2,t) && j<100;j++)
   {nu+=ZWEIPI/U*(t-t2);
    t2=t_von_nu(nu);
   }
 if(j>=100) //test
  {printf("nu_von_t(M0=%lfGRAD dt=%lf U0=%lf) t=%lf\n",M0/GRAD,dt,U0,t);
   printf("nu_von_t: Iteration konvergiert nicht! t=%lf t2=%lf\n",t,t2);
  }
//Berechnung von R (=Abstand zur Sonne):
 double Rstrich,A,b=a*bdurcha,h;
 Rstrich=b*singamma/sin(PI-nustrich);
 A=sin(alfa)*Rstrich;
 h=cc*A/b;
 *R=sqrt(h*h+Rstrich*Rstrich)*AE;
 return nu;
}

/*************** genauere Berechnungen *****************/
#define JD2000 2451545.0

double exactEkl(double jd)
{
 double t=(jd-JD2000)/36525.0; //Anzahl Julianische Jahrhundert
 return Ekl-(46.8150+(0.00059-0.001813*t)*t)*t/3600.0;
}
